from bosa_server_plugins.code_interpreter.constant import DATA_FILE_PATH as DATA_FILE_PATH, DEFAULT_LANGUAGE as DEFAULT_LANGUAGE
from bosa_server_plugins.code_interpreter.entities.file import File as File
from bosa_server_plugins.code_interpreter.helper.sandbox.file_watcher import E2BFileWatcher as E2BFileWatcher
from bosa_server_plugins.code_interpreter.helper.sandbox.models import ExecutionResult as ExecutionResult, ExecutionStatus as ExecutionStatus
from bosa_server_plugins.code_interpreter.helper.sandbox.utils import calculate_duration_ms as calculate_duration_ms
from e2b.sandbox_sync.commands.command import Commands as Commands
from e2b_code_interpreter import Sandbox

SANDBOX_NOT_INITIALIZED_ERROR_MESSAGE: str

class E2BRemoteSandbox:
    """E2B Remote Sandbox wrapper.

    Attributes:
        language (str): Programming language for dependency installation.
        additional_packages (list[str]): Additional packages to install during initialization.
        sandbox (Sandbox): E2B sandbox instance.
        file_watcher (E2BFileWatcher): File watcher for monitoring file creation.
        commands (Any): Command interface for the sandbox.
    """
    language: str
    additional_packages: list[str]
    sandbox: Sandbox
    file_watcher: E2BFileWatcher
    commands: Commands
    def __init__(self, *, template_id: str | None = None, api_key: str, domain: str | None = None, language: str = ..., additional_packages: list[str] | None = None) -> None:
        '''Initialize E2B Remote Sandbox instance.

        Args:
            template_id (str | None, optional): E2B template ID. Defaults to None.
            api_key (str): E2B API key.
            domain (str | None, optional): E2B domain . Defaults to None.
            language (str, optional): Programming language for dependency installation. Defaults to "python".
            additional_packages (list[str] | None, optional): Additional packages to install during initialization.
                Defaults to None.

        Raises:
            RuntimeError: If E2B Cloud sandbox initialization fails.
        '''
    async def execute_code(self, code: str, timeout: int = 30, files: list[File] | None = None, output_dirs: list[str] | None = None) -> ExecutionResult:
        """Execute code in the E2B Cloud sandbox.

        Args:
            code (str): The code to execute.
            timeout (int, optional): Maximum execution time in seconds. Defaults to 30.
            files (list[File] | None, optional): List of File objects with file details. Defaults to None.
            output_dirs (list[str] | None, optional): List of output directories to monitor for file creation.
                Defaults to None.

        Returns:
            ExecutionResult: Structured result of the execution.

        Raises:
            RuntimeError: If sandbox is not initialized.
        """
    def terminate(self) -> None:
        """Terminate the sandbox environment and clean up resources."""
    def get_created_files(self) -> list[str]:
        """Get the list of files created during the last monitored execution.

        Returns:
            list[str]: List of file paths that were created.
        """
    async def download_file(self, file_path: str) -> File | None:
        """Download file content from the sandbox.

        Uses download_url method to get a direct URL and downloads via HTTP,
        which avoids the binary corruption issue with files.read().

        Args:
            file_path (str): Path to the file in the sandbox.

        Returns:
            File | None: Downloaded file or None if download fails.

        Raises:
            RuntimeError: If sandbox is not initialized.
        """
