from enum import StrEnum

class MimeTypes(StrEnum):
    """Enum for MIME types."""
    GOOGLE_DOCS = 'application/vnd.google-apps.document'
    GOOGLE_SPREADSHEET = 'application/vnd.google-apps.spreadsheet'
    GOOGLE_SLIDE = 'application/vnd.google-apps.presentation'
    GOOGLE_FORM = 'application/vnd.google-apps.form'
    GOOGLE_DRAWING = 'application/vnd.google-apps.drawing'
    GOOGLE_FOLDER = 'application/vnd.google-apps.folder'
    GOOGLE_SCRIPT = 'application/vnd.google-apps.script'
    GOOGLE_SHORTCUT = 'application/vnd.google-apps.shortcut'
    GOOGLE_SITE = 'application/vnd.google-apps.site'
    GOOGLE_JAM = 'application/vnd.google-apps.jam'
    GOOGLE_MAP = 'application/vnd.google-apps.map'
    DOC = 'application/msword'
    DOCX = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
    XLS = 'application/vnd.ms-excel'
    XLSX = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
    PPT = 'application/vnd.ms-powerpoint'
    PPTX = 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
    DOTX = 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'
    XLTX = 'application/vnd.openxmlformats-officedocument.spreadsheetml.template'
    ODT = 'application/vnd.oasis.opendocument.text'
    ODS = 'application/vnd.oasis.opendocument.spreadsheet'
    ODP = 'application/vnd.oasis.opendocument.presentation'
    PDF = 'application/pdf'
    HTML = 'text/html'
    TXT = 'text/plain'
    RTF = 'application/rtf'
    CSV = 'text/csv'
    ZIP = 'application/zip'
    RAR = 'application/vnd.rar'
    SEVENZ = 'application/x-7z-compressed'
    JSON = 'application/json'
    XML = 'application/xml'
    YAML = 'application/yaml'
    SQL = 'application/sql'
    SQLITE = 'application/x-sqlite3'
    DB = 'application/octet-stream'
    MARKDOWN = 'text/markdown'
    MD = 'text/markdown'
    PNG = 'image/png'
    JPEG = 'image/jpeg'
    JPG = 'image/jpeg'
    GIF = 'image/gif'
    BMP = 'image/bmp'
    SVG = 'image/svg+xml'
    AI = 'application/postscript'
    PSD = 'image/vnd.adobe.photoshop'
    SKETCH = 'application/sketch'
    MP4 = 'video/mp4'
    MOV = 'video/quicktime'
    AVI = 'video/x-msvideo'
    MP3 = 'audio/mpeg'
    WAV = 'audio/wav'
    JS = 'text/javascript'
    TS = 'application/typescript'
    PY = 'text/x-python'
    JAVA = 'text/x-java'
    RUBY = 'text/ruby'
    RB = 'text/ruby'
    CPP = 'text/x-c++src'
    IPYNB = 'application/x-ipynb+json'
    OCTET_STREAM = 'application/octet-stream'
