from dataclasses import dataclass
from datetime import datetime

@dataclass
class GitUser:
    """A Git user with basic information used in commits."""
    date: datetime
    name: str | None = ...
    email: str | None = ...

@dataclass
class SimpleUser:
    """A GitHub user."""
    name: str | None = ...
    email: str | None = ...
    login: str = ...
    id: int = ...
    node_id: str = ...
    avatar_url: str = ...
    gravatar_id: str | None = ...
    url: str = ...
    html_url: str = ...
    followers_url: str = ...
    following_url: str = ...
    gists_url: str = ...
    starred_url: str = ...
    subscriptions_url: str = ...
    organizations_url: str = ...
    repos_url: str = ...
    events_url: str = ...
    received_events_url: str = ...
    type: str = ...
    site_admin: bool = ...
    starred_at: str | None = ...
    user_view_type: str | None = ...
    @classmethod
    def from_dict(cls, data: dict) -> SimpleUser:
        """Create a SimpleUser instance from a dictionary.

        Args:
            data: Dictionary containing user data from GitHub API

        Returns:
            SimpleUser instance
        """

@dataclass
class Permissions:
    """Repository permissions for a collaborator."""
    pull: bool
    push: bool
    admin: bool
    triage: bool | None = ...
    maintain: bool | None = ...
    @classmethod
    def from_dict(cls, data: dict) -> Permissions:
        """Create a Permissions instance from a dictionary.

        Args:
            data: Dictionary containing permissions data from GitHub API

        Returns:
            Permissions instance
        """

@dataclass
class Collaborator(SimpleUser):
    """A GitHub repository collaborator."""
    role_name: str = ...
    permissions: Permissions = ...
    @classmethod
    def from_dict(cls, data: dict) -> Collaborator:
        """Create a Collaborator instance from a dictionary.

        Args:
            data: Dictionary containing collaborator data from GitHub API

        Returns:
            Collaborator instance
        """
