from _typeshed import Incomplete
from bosa_server_plugins.google_docs.helper.copy_content.requests.base import BatchUpdateRequest as BatchUpdateRequest, NO_CONTENT_LENGTH as NO_CONTENT_LENGTH

class UpdateTableColumnProperties(BatchUpdateRequest):
    """Google Docs update table column properties batch update request."""
    column: Incomplete
    properties: Incomplete
    def __init__(self, column: int, properties: dict) -> None:
        """Initialize the UpdateTableColumnProperties object.

        Args:
            column: The column index to be updated.
            properties: The properties to be updated for the specified column.
        """
    def length(self) -> int:
        """Length of the content.

        Used to update the cursor position after pasting.

        Returns:
            int: The length of the content that was pasted.
        """
    def paste(self, index: int, segment_id: str = None) -> dict:
        """Generate the batch update request for pasting the content in specified index and segment.

        Args:
            index: The index where the content will be pasted.
            segment_id: The segment ID for the content.

        Returns:
            A dictionary representing the batch update request.
        """
