# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBdsInstanceApiKeyResult',
    'AwaitableGetBdsInstanceApiKeyResult',
    'get_bds_instance_api_key',
    'get_bds_instance_api_key_output',
]

@pulumi.output_type
class GetBdsInstanceApiKeyResult:
    """
    A collection of values returned by getBdsInstanceApiKey.
    """
    def __init__(__self__, api_key_id=None, bds_instance_id=None, default_region=None, domain_ocid=None, fingerprint=None, id=None, key_alias=None, passphrase=None, pemfilepath=None, state=None, tenant_id=None, time_created=None, user_id=None):
        if api_key_id and not isinstance(api_key_id, str):
            raise TypeError("Expected argument 'api_key_id' to be a str")
        pulumi.set(__self__, "api_key_id", api_key_id)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if default_region and not isinstance(default_region, str):
            raise TypeError("Expected argument 'default_region' to be a str")
        pulumi.set(__self__, "default_region", default_region)
        if domain_ocid and not isinstance(domain_ocid, str):
            raise TypeError("Expected argument 'domain_ocid' to be a str")
        pulumi.set(__self__, "domain_ocid", domain_ocid)
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_alias and not isinstance(key_alias, str):
            raise TypeError("Expected argument 'key_alias' to be a str")
        pulumi.set(__self__, "key_alias", key_alias)
        if passphrase and not isinstance(passphrase, str):
            raise TypeError("Expected argument 'passphrase' to be a str")
        pulumi.set(__self__, "passphrase", passphrase)
        if pemfilepath and not isinstance(pemfilepath, str):
            raise TypeError("Expected argument 'pemfilepath' to be a str")
        pulumi.set(__self__, "pemfilepath", pemfilepath)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> str:
        return pulumi.get(self, "api_key_id")

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> str:
        """
        The name of the region to establish the Object Storage endpoint which was set as part of key creation operation. If no region was provided this will be set to be the same region where the cluster lives. Example us-phoenix-1 .
        >>>>>>> theirs
        """
        return pulumi.get(self, "default_region")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> str:
        """
        Identity domain OCID ,where user is present. For default domain ,this field will be optional.
        =======
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The fingerprint that corresponds to the public API key requested.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Identifier of the user's API key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> str:
        """
        User friendly identifier used to uniquely differentiate between different API keys. Only ASCII alphanumeric characters with no spaces allowed.
        """
        return pulumi.get(self, "key_alias")

    @property
    @pulumi.getter
    def passphrase(self) -> str:
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter
    def pemfilepath(self) -> str:
        """
        The full path and file name of the private key used for authentication. This location will be automatically selected on the BDS local file system.
        """
        return pulumi.get(self, "pemfilepath")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current status of the API key.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The OCID of your tenancy.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the API key was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The user OCID for which this API key was created.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetBdsInstanceApiKeyResult(GetBdsInstanceApiKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceApiKeyResult(
            api_key_id=self.api_key_id,
            bds_instance_id=self.bds_instance_id,
            default_region=self.default_region,
            domain_ocid=self.domain_ocid,
            fingerprint=self.fingerprint,
            id=self.id,
            key_alias=self.key_alias,
            passphrase=self.passphrase,
            pemfilepath=self.pemfilepath,
            state=self.state,
            tenant_id=self.tenant_id,
            time_created=self.time_created,
            user_id=self.user_id)


def get_bds_instance_api_key(api_key_id: Optional[str] = None,
                             bds_instance_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceApiKeyResult:
    """
    This data source provides details about a specific Bds Instance Api Key resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns the user's API key information for the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_api_key = oci.BigDataService.get_bds_instance_api_key(api_key_id=test_api_key["id"],
        bds_instance_id=test_bds_instance["id"])
    ```


    :param str api_key_id: The API key identifier.
    :param str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['apiKeyId'] = api_key_id
    __args__['bdsInstanceId'] = bds_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceApiKey:getBdsInstanceApiKey', __args__, opts=opts, typ=GetBdsInstanceApiKeyResult).value

    return AwaitableGetBdsInstanceApiKeyResult(
        api_key_id=pulumi.get(__ret__, 'api_key_id'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        default_region=pulumi.get(__ret__, 'default_region'),
        domain_ocid=pulumi.get(__ret__, 'domain_ocid'),
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        key_alias=pulumi.get(__ret__, 'key_alias'),
        passphrase=pulumi.get(__ret__, 'passphrase'),
        pemfilepath=pulumi.get(__ret__, 'pemfilepath'),
        state=pulumi.get(__ret__, 'state'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_bds_instance_api_key_output(api_key_id: Optional[pulumi.Input[str]] = None,
                                    bds_instance_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceApiKeyResult]:
    """
    This data source provides details about a specific Bds Instance Api Key resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns the user's API key information for the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_api_key = oci.BigDataService.get_bds_instance_api_key(api_key_id=test_api_key["id"],
        bds_instance_id=test_bds_instance["id"])
    ```


    :param str api_key_id: The API key identifier.
    :param str bds_instance_id: The OCID of the cluster.
    """
    __args__ = dict()
    __args__['apiKeyId'] = api_key_id
    __args__['bdsInstanceId'] = bds_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceApiKey:getBdsInstanceApiKey', __args__, opts=opts, typ=GetBdsInstanceApiKeyResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceApiKeyResult(
        api_key_id=pulumi.get(__response__, 'api_key_id'),
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        default_region=pulumi.get(__response__, 'default_region'),
        domain_ocid=pulumi.get(__response__, 'domain_ocid'),
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        key_alias=pulumi.get(__response__, 'key_alias'),
        passphrase=pulumi.get(__response__, 'passphrase'),
        pemfilepath=pulumi.get(__response__, 'pemfilepath'),
        state=pulumi.get(__response__, 'state'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        user_id=pulumi.get(__response__, 'user_id')))
