# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOccHandoverResourceBlocksResult',
    'AwaitableGetOccHandoverResourceBlocksResult',
    'get_occ_handover_resource_blocks',
    'get_occ_handover_resource_blocks_output',
]

@pulumi.output_type
class GetOccHandoverResourceBlocksResult:
    """
    A collection of values returned by getOccHandoverResourceBlocks.
    """
    def __init__(__self__, compartment_id=None, filters=None, handover_date_greater_than_or_equal_to=None, handover_date_less_than_or_equal_to=None, handover_resource_name=None, id=None, namespace=None, occ_handover_resource_block_collections=None, occ_handover_resource_block_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if handover_date_greater_than_or_equal_to and not isinstance(handover_date_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'handover_date_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "handover_date_greater_than_or_equal_to", handover_date_greater_than_or_equal_to)
        if handover_date_less_than_or_equal_to and not isinstance(handover_date_less_than_or_equal_to, str):
            raise TypeError("Expected argument 'handover_date_less_than_or_equal_to' to be a str")
        pulumi.set(__self__, "handover_date_less_than_or_equal_to", handover_date_less_than_or_equal_to)
        if handover_resource_name and not isinstance(handover_resource_name, str):
            raise TypeError("Expected argument 'handover_resource_name' to be a str")
        pulumi.set(__self__, "handover_resource_name", handover_resource_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if occ_handover_resource_block_collections and not isinstance(occ_handover_resource_block_collections, list):
            raise TypeError("Expected argument 'occ_handover_resource_block_collections' to be a list")
        pulumi.set(__self__, "occ_handover_resource_block_collections", occ_handover_resource_block_collections)
        if occ_handover_resource_block_id and not isinstance(occ_handover_resource_block_id, str):
            raise TypeError("Expected argument 'occ_handover_resource_block_id' to be a str")
        pulumi.set(__self__, "occ_handover_resource_block_id", occ_handover_resource_block_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of the compartment where the resource block's are placed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOccHandoverResourceBlocksFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="handoverDateGreaterThanOrEqualTo")
    def handover_date_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "handover_date_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="handoverDateLessThanOrEqualTo")
    def handover_date_less_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "handover_date_less_than_or_equal_to")

    @property
    @pulumi.getter(name="handoverResourceName")
    def handover_resource_name(self) -> Optional[str]:
        """
        The name of the resource handed over by oracle.  For instance for compute namespace this will be the name of the bare metal hardware resource.
        """
        return pulumi.get(self, "handover_resource_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration.  For example Compute, Exadata and so on.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="occHandoverResourceBlockCollections")
    def occ_handover_resource_block_collections(self) -> Sequence['outputs.GetOccHandoverResourceBlocksOccHandoverResourceBlockCollectionResult']:
        """
        The list of occ_handover_resource_block_collection.
        """
        return pulumi.get(self, "occ_handover_resource_block_collections")

    @property
    @pulumi.getter(name="occHandoverResourceBlockId")
    def occ_handover_resource_block_id(self) -> Optional[str]:
        return pulumi.get(self, "occ_handover_resource_block_id")


class AwaitableGetOccHandoverResourceBlocksResult(GetOccHandoverResourceBlocksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccHandoverResourceBlocksResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            handover_date_greater_than_or_equal_to=self.handover_date_greater_than_or_equal_to,
            handover_date_less_than_or_equal_to=self.handover_date_less_than_or_equal_to,
            handover_resource_name=self.handover_resource_name,
            id=self.id,
            namespace=self.namespace,
            occ_handover_resource_block_collections=self.occ_handover_resource_block_collections,
            occ_handover_resource_block_id=self.occ_handover_resource_block_id)


def get_occ_handover_resource_blocks(compartment_id: Optional[str] = None,
                                     filters: Optional[Sequence[Union['GetOccHandoverResourceBlocksFilterArgs', 'GetOccHandoverResourceBlocksFilterArgsDict']]] = None,
                                     handover_date_greater_than_or_equal_to: Optional[str] = None,
                                     handover_date_less_than_or_equal_to: Optional[str] = None,
                                     handover_resource_name: Optional[str] = None,
                                     namespace: Optional[str] = None,
                                     occ_handover_resource_block_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccHandoverResourceBlocksResult:
    """
    This data source provides the list of Occ Handover Resource Blocks in Oracle Cloud Infrastructure Capacity Management service.

    List Occ Handover Resource blocks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_handover_resource_blocks = oci.CapacityManagement.get_occ_handover_resource_blocks(compartment_id=compartment_id,
        handover_date_greater_than_or_equal_to=occ_handover_resource_block_handover_date_greater_than_or_equal_to,
        handover_date_less_than_or_equal_to=occ_handover_resource_block_handover_date_less_than_or_equal_to,
        handover_resource_name=test_resource["name"],
        namespace=occ_handover_resource_block_namespace,
        occ_handover_resource_block_id=test_occ_handover_resource_block["id"])
    ```


    :param str compartment_id: The OCID of the compartment or tenancy in which resources are to be listed.
    :param str handover_date_greater_than_or_equal_to: This filter helps in fetching all handed over resources for which the recordDate is greater than or equal to the startDate.
    :param str handover_date_less_than_or_equal_to: This filter helps in fetching all handed over resources for which the recordDate is less than or equal to the endDate.
    :param str handover_resource_name: A filter to return only the list of resources that match the name provided in this filter.
    :param str namespace: The namespace by which we would filter the list.
    :param str occ_handover_resource_block_id: This filter helps in fetching the handed over resource for which the occHandoverResourceId is equal to the one provided here.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['handoverDateGreaterThanOrEqualTo'] = handover_date_greater_than_or_equal_to
    __args__['handoverDateLessThanOrEqualTo'] = handover_date_less_than_or_equal_to
    __args__['handoverResourceName'] = handover_resource_name
    __args__['namespace'] = namespace
    __args__['occHandoverResourceBlockId'] = occ_handover_resource_block_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccHandoverResourceBlocks:getOccHandoverResourceBlocks', __args__, opts=opts, typ=GetOccHandoverResourceBlocksResult).value

    return AwaitableGetOccHandoverResourceBlocksResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        handover_date_greater_than_or_equal_to=pulumi.get(__ret__, 'handover_date_greater_than_or_equal_to'),
        handover_date_less_than_or_equal_to=pulumi.get(__ret__, 'handover_date_less_than_or_equal_to'),
        handover_resource_name=pulumi.get(__ret__, 'handover_resource_name'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        occ_handover_resource_block_collections=pulumi.get(__ret__, 'occ_handover_resource_block_collections'),
        occ_handover_resource_block_id=pulumi.get(__ret__, 'occ_handover_resource_block_id'))
def get_occ_handover_resource_blocks_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOccHandoverResourceBlocksFilterArgs', 'GetOccHandoverResourceBlocksFilterArgsDict']]]]] = None,
                                            handover_date_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                            handover_date_less_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                            handover_resource_name: Optional[pulumi.Input[Optional[str]]] = None,
                                            namespace: Optional[pulumi.Input[Optional[str]]] = None,
                                            occ_handover_resource_block_id: Optional[pulumi.Input[Optional[str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccHandoverResourceBlocksResult]:
    """
    This data source provides the list of Occ Handover Resource Blocks in Oracle Cloud Infrastructure Capacity Management service.

    List Occ Handover Resource blocks.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occ_handover_resource_blocks = oci.CapacityManagement.get_occ_handover_resource_blocks(compartment_id=compartment_id,
        handover_date_greater_than_or_equal_to=occ_handover_resource_block_handover_date_greater_than_or_equal_to,
        handover_date_less_than_or_equal_to=occ_handover_resource_block_handover_date_less_than_or_equal_to,
        handover_resource_name=test_resource["name"],
        namespace=occ_handover_resource_block_namespace,
        occ_handover_resource_block_id=test_occ_handover_resource_block["id"])
    ```


    :param str compartment_id: The OCID of the compartment or tenancy in which resources are to be listed.
    :param str handover_date_greater_than_or_equal_to: This filter helps in fetching all handed over resources for which the recordDate is greater than or equal to the startDate.
    :param str handover_date_less_than_or_equal_to: This filter helps in fetching all handed over resources for which the recordDate is less than or equal to the endDate.
    :param str handover_resource_name: A filter to return only the list of resources that match the name provided in this filter.
    :param str namespace: The namespace by which we would filter the list.
    :param str occ_handover_resource_block_id: This filter helps in fetching the handed over resource for which the occHandoverResourceId is equal to the one provided here.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['handoverDateGreaterThanOrEqualTo'] = handover_date_greater_than_or_equal_to
    __args__['handoverDateLessThanOrEqualTo'] = handover_date_less_than_or_equal_to
    __args__['handoverResourceName'] = handover_resource_name
    __args__['namespace'] = namespace
    __args__['occHandoverResourceBlockId'] = occ_handover_resource_block_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccHandoverResourceBlocks:getOccHandoverResourceBlocks', __args__, opts=opts, typ=GetOccHandoverResourceBlocksResult)
    return __ret__.apply(lambda __response__: GetOccHandoverResourceBlocksResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        handover_date_greater_than_or_equal_to=pulumi.get(__response__, 'handover_date_greater_than_or_equal_to'),
        handover_date_less_than_or_equal_to=pulumi.get(__response__, 'handover_date_less_than_or_equal_to'),
        handover_resource_name=pulumi.get(__response__, 'handover_resource_name'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        occ_handover_resource_block_collections=pulumi.get(__response__, 'occ_handover_resource_block_collections'),
        occ_handover_resource_block_id=pulumi.get(__response__, 'occ_handover_resource_block_id')))
