# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEkmsPrivateEndpointResult',
    'AwaitableGetEkmsPrivateEndpointResult',
    'get_ekms_private_endpoint',
    'get_ekms_private_endpoint_output',
]

@pulumi.output_type
class GetEkmsPrivateEndpointResult:
    """
    A collection of values returned by getEkmsPrivateEndpoint.
    """
    def __init__(__self__, ca_bundle=None, compartment_id=None, defined_tags=None, display_name=None, ekms_private_endpoint_id=None, external_key_manager_ip=None, freeform_tags=None, id=None, lifecycle_details=None, port=None, private_endpoint_ip=None, state=None, subnet_id=None, time_created=None, time_updated=None):
        if ca_bundle and not isinstance(ca_bundle, str):
            raise TypeError("Expected argument 'ca_bundle' to be a str")
        pulumi.set(__self__, "ca_bundle", ca_bundle)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if ekms_private_endpoint_id and not isinstance(ekms_private_endpoint_id, str):
            raise TypeError("Expected argument 'ekms_private_endpoint_id' to be a str")
        pulumi.set(__self__, "ekms_private_endpoint_id", ekms_private_endpoint_id)
        if external_key_manager_ip and not isinstance(external_key_manager_ip, str):
            raise TypeError("Expected argument 'external_key_manager_ip' to be a str")
        pulumi.set(__self__, "external_key_manager_ip", external_key_manager_ip)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if private_endpoint_ip and not isinstance(private_endpoint_ip, str):
            raise TypeError("Expected argument 'private_endpoint_ip' to be a str")
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="caBundle")
    def ca_bundle(self) -> str:
        """
        CABundle to validate TLS certificate of the external key manager system in PEM format
        """
        return pulumi.get(self, "ca_bundle")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Identifier of the compartment this EKMS private endpoint belongs to
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Mutable name of the EKMS private endpoint
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="ekmsPrivateEndpointId")
    def ekms_private_endpoint_id(self) -> str:
        return pulumi.get(self, "ekms_private_endpoint_id")

    @property
    @pulumi.getter(name="externalKeyManagerIp")
    def external_key_manager_ip(self) -> str:
        """
        Private IP of the external key manager system to connect to from the EKMS private endpoint
        """
        return pulumi.get(self, "external_key_manager_ip")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port of the external key manager system
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        The IP address in the customer's VCN for the EKMS private endpoint. This is taken from subnet
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the EKMS private endpoint resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Subnet Identifier
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the EKMS private endpoint was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the EKMS private endpoint was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetEkmsPrivateEndpointResult(GetEkmsPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEkmsPrivateEndpointResult(
            ca_bundle=self.ca_bundle,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            ekms_private_endpoint_id=self.ekms_private_endpoint_id,
            external_key_manager_ip=self.external_key_manager_ip,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            port=self.port,
            private_endpoint_ip=self.private_endpoint_ip,
            state=self.state,
            subnet_id=self.subnet_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_ekms_private_endpoint(ekms_private_endpoint_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEkmsPrivateEndpointResult:
    """
    This data source provides details about a specific Ekms Private Endpoint resource in Oracle Cloud Infrastructure Kms service.

    Gets a specific EKMS private by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ekms_private_endpoint = oci.Kms.get_ekms_private_endpoint(ekms_private_endpoint_id=test_ekms_private_endpoint_oci_kms_ekms_private_endpoint["id"])
    ```


    :param str ekms_private_endpoint_id: Unique EKMS private endpoint identifier.
    """
    __args__ = dict()
    __args__['ekmsPrivateEndpointId'] = ekms_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Kms/getEkmsPrivateEndpoint:getEkmsPrivateEndpoint', __args__, opts=opts, typ=GetEkmsPrivateEndpointResult).value

    return AwaitableGetEkmsPrivateEndpointResult(
        ca_bundle=pulumi.get(__ret__, 'ca_bundle'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        ekms_private_endpoint_id=pulumi.get(__ret__, 'ekms_private_endpoint_id'),
        external_key_manager_ip=pulumi.get(__ret__, 'external_key_manager_ip'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        port=pulumi.get(__ret__, 'port'),
        private_endpoint_ip=pulumi.get(__ret__, 'private_endpoint_ip'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_ekms_private_endpoint_output(ekms_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEkmsPrivateEndpointResult]:
    """
    This data source provides details about a specific Ekms Private Endpoint resource in Oracle Cloud Infrastructure Kms service.

    Gets a specific EKMS private by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ekms_private_endpoint = oci.Kms.get_ekms_private_endpoint(ekms_private_endpoint_id=test_ekms_private_endpoint_oci_kms_ekms_private_endpoint["id"])
    ```


    :param str ekms_private_endpoint_id: Unique EKMS private endpoint identifier.
    """
    __args__ = dict()
    __args__['ekmsPrivateEndpointId'] = ekms_private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Kms/getEkmsPrivateEndpoint:getEkmsPrivateEndpoint', __args__, opts=opts, typ=GetEkmsPrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetEkmsPrivateEndpointResult(
        ca_bundle=pulumi.get(__response__, 'ca_bundle'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        ekms_private_endpoint_id=pulumi.get(__response__, 'ekms_private_endpoint_id'),
        external_key_manager_ip=pulumi.get(__response__, 'external_key_manager_ip'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        port=pulumi.get(__response__, 'port'),
        private_endpoint_ip=pulumi.get(__response__, 'private_endpoint_ip'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
