# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRedisClusterResult',
    'AwaitableGetRedisClusterResult',
    'get_redis_cluster',
    'get_redis_cluster_output',
]

@pulumi.output_type
class GetRedisClusterResult:
    """
    A collection of values returned by getRedisCluster.
    """
    def __init__(__self__, cluster_mode=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, node_collections=None, node_count=None, node_memory_in_gbs=None, nsg_ids=None, primary_endpoint_ip_address=None, primary_fqdn=None, redis_cluster_id=None, replicas_endpoint_ip_address=None, replicas_fqdn=None, shard_count=None, software_version=None, state=None, subnet_id=None, system_tags=None, time_created=None, time_updated=None):
        if cluster_mode and not isinstance(cluster_mode, str):
            raise TypeError("Expected argument 'cluster_mode' to be a str")
        pulumi.set(__self__, "cluster_mode", cluster_mode)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if node_collections and not isinstance(node_collections, list):
            raise TypeError("Expected argument 'node_collections' to be a list")
        pulumi.set(__self__, "node_collections", node_collections)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if node_memory_in_gbs and not isinstance(node_memory_in_gbs, float):
            raise TypeError("Expected argument 'node_memory_in_gbs' to be a float")
        pulumi.set(__self__, "node_memory_in_gbs", node_memory_in_gbs)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if primary_endpoint_ip_address and not isinstance(primary_endpoint_ip_address, str):
            raise TypeError("Expected argument 'primary_endpoint_ip_address' to be a str")
        pulumi.set(__self__, "primary_endpoint_ip_address", primary_endpoint_ip_address)
        if primary_fqdn and not isinstance(primary_fqdn, str):
            raise TypeError("Expected argument 'primary_fqdn' to be a str")
        pulumi.set(__self__, "primary_fqdn", primary_fqdn)
        if redis_cluster_id and not isinstance(redis_cluster_id, str):
            raise TypeError("Expected argument 'redis_cluster_id' to be a str")
        pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)
        if replicas_endpoint_ip_address and not isinstance(replicas_endpoint_ip_address, str):
            raise TypeError("Expected argument 'replicas_endpoint_ip_address' to be a str")
        pulumi.set(__self__, "replicas_endpoint_ip_address", replicas_endpoint_ip_address)
        if replicas_fqdn and not isinstance(replicas_fqdn, str):
            raise TypeError("Expected argument 'replicas_fqdn' to be a str")
        pulumi.set(__self__, "replicas_fqdn", replicas_fqdn)
        if shard_count and not isinstance(shard_count, int):
            raise TypeError("Expected argument 'shard_count' to be a int")
        pulumi.set(__self__, "shard_count", shard_count)
        if software_version and not isinstance(software_version, str):
            raise TypeError("Expected argument 'software_version' to be a str")
        pulumi.set(__self__, "software_version", software_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterMode")
    def cluster_mode(self) -> str:
        """
        Specifies whether the cluster is sharded or non-sharded.
        """
        return pulumi.get(self, "cluster_mode")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the compartment that contains the cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name of a cluster node.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nodeCollections")
    def node_collections(self) -> Sequence['outputs.GetRedisClusterNodeCollectionResult']:
        """
        The collection of  cluster nodes.
        """
        return pulumi.get(self, "node_collections")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeMemoryInGbs")
    def node_memory_in_gbs(self) -> float:
        """
        The amount of memory allocated to the cluster's nodes, in gigabytes.
        """
        return pulumi.get(self, "node_memory_in_gbs")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        A list of Network Security Group (NSG) [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this cluster. For more information, see [Using an NSG for Clusters](https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="primaryEndpointIpAddress")
    def primary_endpoint_ip_address(self) -> str:
        """
        The private IP address of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_endpoint_ip_address")

    @property
    @pulumi.getter(name="primaryFqdn")
    def primary_fqdn(self) -> str:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.
        """
        return pulumi.get(self, "primary_fqdn")

    @property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> str:
        return pulumi.get(self, "redis_cluster_id")

    @property
    @pulumi.getter(name="replicasEndpointIpAddress")
    def replicas_endpoint_ip_address(self) -> str:
        """
        The private IP address of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_endpoint_ip_address")

    @property
    @pulumi.getter(name="replicasFqdn")
    def replicas_fqdn(self) -> str:
        """
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.
        """
        return pulumi.get(self, "replicas_fqdn")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> int:
        """
        The number of shards in a sharded cluster. Only applicable when clusterMode is SHARDED.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> str:
        """
        The Oracle Cloud Infrastructure Cache engine version that the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the cluster was created. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the cluster was updated. An [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetRedisClusterResult(GetRedisClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRedisClusterResult(
            cluster_mode=self.cluster_mode,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            node_collections=self.node_collections,
            node_count=self.node_count,
            node_memory_in_gbs=self.node_memory_in_gbs,
            nsg_ids=self.nsg_ids,
            primary_endpoint_ip_address=self.primary_endpoint_ip_address,
            primary_fqdn=self.primary_fqdn,
            redis_cluster_id=self.redis_cluster_id,
            replicas_endpoint_ip_address=self.replicas_endpoint_ip_address,
            replicas_fqdn=self.replicas_fqdn,
            shard_count=self.shard_count,
            software_version=self.software_version,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_redis_cluster(redis_cluster_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRedisClusterResult:
    """
    This data source provides details about a specific Redis Cluster resource in Oracle Cloud Infrastructure Redis service.

    Retrieves the specified Oracle Cloud Infrastructure Cache cluster. A cluster is a memory-based storage solution. For more information, see [OCI Cache](https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_redis_cluster = oci.Redis.get_redis_cluster(redis_cluster_id=test_redis_cluster_oci_redis_redis_cluster["id"])
    ```


    :param str redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
    """
    __args__ = dict()
    __args__['redisClusterId'] = redis_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Redis/getRedisCluster:getRedisCluster', __args__, opts=opts, typ=GetRedisClusterResult).value

    return AwaitableGetRedisClusterResult(
        cluster_mode=pulumi.get(__ret__, 'cluster_mode'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        node_collections=pulumi.get(__ret__, 'node_collections'),
        node_count=pulumi.get(__ret__, 'node_count'),
        node_memory_in_gbs=pulumi.get(__ret__, 'node_memory_in_gbs'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        primary_endpoint_ip_address=pulumi.get(__ret__, 'primary_endpoint_ip_address'),
        primary_fqdn=pulumi.get(__ret__, 'primary_fqdn'),
        redis_cluster_id=pulumi.get(__ret__, 'redis_cluster_id'),
        replicas_endpoint_ip_address=pulumi.get(__ret__, 'replicas_endpoint_ip_address'),
        replicas_fqdn=pulumi.get(__ret__, 'replicas_fqdn'),
        shard_count=pulumi.get(__ret__, 'shard_count'),
        software_version=pulumi.get(__ret__, 'software_version'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_redis_cluster_output(redis_cluster_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRedisClusterResult]:
    """
    This data source provides details about a specific Redis Cluster resource in Oracle Cloud Infrastructure Redis service.

    Retrieves the specified Oracle Cloud Infrastructure Cache cluster. A cluster is a memory-based storage solution. For more information, see [OCI Cache](https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_redis_cluster = oci.Redis.get_redis_cluster(redis_cluster_id=test_redis_cluster_oci_redis_redis_cluster["id"])
    ```


    :param str redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
    """
    __args__ = dict()
    __args__['redisClusterId'] = redis_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Redis/getRedisCluster:getRedisCluster', __args__, opts=opts, typ=GetRedisClusterResult)
    return __ret__.apply(lambda __response__: GetRedisClusterResult(
        cluster_mode=pulumi.get(__response__, 'cluster_mode'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        node_collections=pulumi.get(__response__, 'node_collections'),
        node_count=pulumi.get(__response__, 'node_count'),
        node_memory_in_gbs=pulumi.get(__response__, 'node_memory_in_gbs'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        primary_endpoint_ip_address=pulumi.get(__response__, 'primary_endpoint_ip_address'),
        primary_fqdn=pulumi.get(__response__, 'primary_fqdn'),
        redis_cluster_id=pulumi.get(__response__, 'redis_cluster_id'),
        replicas_endpoint_ip_address=pulumi.get(__response__, 'replicas_endpoint_ip_address'),
        replicas_fqdn=pulumi.get(__response__, 'replicas_fqdn'),
        shard_count=pulumi.get(__response__, 'shard_count'),
        software_version=pulumi.get(__response__, 'software_version'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
