# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetResourcesResult',
    'AwaitableGetResourcesResult',
    'get_resources',
    'get_resources_output',
]

@pulumi.output_type
class GetResourcesResult:
    """
    A collection of values returned by getResources.
    """
    def __init__(__self__, compartment_id=None, entitlement_id=None, filters=None, id=None, resources_collections=None, service_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if entitlement_id and not isinstance(entitlement_id, str):
            raise TypeError("Expected argument 'entitlement_id' to be a str")
        pulumi.set(__self__, "entitlement_id", entitlement_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resources_collections and not isinstance(resources_collections, list):
            raise TypeError("Expected argument 'resources_collections' to be a list")
        pulumi.set(__self__, "resources_collections", resources_collections)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="entitlementId")
    def entitlement_id(self) -> Optional[str]:
        return pulumi.get(self, "entitlement_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourcesCollections")
    def resources_collections(self) -> Sequence['outputs.GetResourcesResourcesCollectionResult']:
        """
        The list of resources_collection.
        """
        return pulumi.get(self, "resources_collections")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")


class AwaitableGetResourcesResult(GetResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcesResult(
            compartment_id=self.compartment_id,
            entitlement_id=self.entitlement_id,
            filters=self.filters,
            id=self.id,
            resources_collections=self.resources_collections,
            service_name=self.service_name)


def get_resources(compartment_id: Optional[str] = None,
                  entitlement_id: Optional[str] = None,
                  filters: Optional[Sequence[Union['GetResourcesFilterArgs', 'GetResourcesFilterArgsDict']]] = None,
                  service_name: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcesResult:
    """
    This data source provides the list of Resources in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the resource details for a service
    > **Important**: Calls to this API will only succeed against the endpoint in the home region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resources = oci.UsageProxy.get_resources(compartment_id=compartment_id,
        service_name=test_service["name"],
        entitlement_id=test_entitlement["id"])
    ```


    :param str compartment_id: The OCID of the root compartment.
    :param str entitlement_id: Subscription or entitlement Id.
    :param str service_name: Service Name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['entitlementId'] = entitlement_id
    __args__['filters'] = filters
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:UsageProxy/getResources:getResources', __args__, opts=opts, typ=GetResourcesResult).value

    return AwaitableGetResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        entitlement_id=pulumi.get(__ret__, 'entitlement_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        resources_collections=pulumi.get(__ret__, 'resources_collections'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_resources_output(compartment_id: Optional[pulumi.Input[str]] = None,
                         entitlement_id: Optional[pulumi.Input[Optional[str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetResourcesFilterArgs', 'GetResourcesFilterArgsDict']]]]] = None,
                         service_name: Optional[pulumi.Input[str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourcesResult]:
    """
    This data source provides the list of Resources in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the resource details for a service
    > **Important**: Calls to this API will only succeed against the endpoint in the home region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resources = oci.UsageProxy.get_resources(compartment_id=compartment_id,
        service_name=test_service["name"],
        entitlement_id=test_entitlement["id"])
    ```


    :param str compartment_id: The OCID of the root compartment.
    :param str entitlement_id: Subscription or entitlement Id.
    :param str service_name: Service Name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['entitlementId'] = entitlement_id
    __args__['filters'] = filters
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:UsageProxy/getResources:getResources', __args__, opts=opts, typ=GetResourcesResult)
    return __ret__.apply(lambda __response__: GetResourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        entitlement_id=pulumi.get(__response__, 'entitlement_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        resources_collections=pulumi.get(__response__, 'resources_collections'),
        service_name=pulumi.get(__response__, 'service_name')))
