# Copyright (C) 2022 Cochise Ruhulessin
#
# All rights reserved. No warranty, explicit or implicit, provided. In
# no event shall the author(s) be liable for any claim or damages.
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
import pydantic
from ckms.utils import b64encode_str


class VersionedMAC(pydantic.BaseModel):
    dsn: str
    mac: str

    @pydantic.validator('mac', pre=True)
    def preprocess_mac(cls, value: bytes | str | None) -> str | None:
        if isinstance(value, bytes):
            value = b64encode_str(value)
        return value
