# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_adjustment_note_support_document_request_company_tax_code import CreateAdjustmentNoteSupportDocumentRequestCompanyTaxCode
from typing import Optional, Set
from typing_extensions import Self

class CreateAdjustmentNoteSupportDocumentRequestCompany(BaseModel):
    """
    Objeto que contiene la información del obligado a facturar o emisor del documento electrónico. <br><i>Grupo de información oficial DIAN &lt;AccountingSupplierParty&gt;</i>
    """ # noqa: E501
    id: StrictStr = Field(description="Id de la empresa. Id único generado por la API")
    organization_type: Optional[Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Identificador de tipo de organización jurídica de la persona o empresa. Se debe colocar el Código que corresponda de la tabla de tipos de organización jurídica de la DIAN. <br><i>Campo oficial DIAN &lt;AdditionalAccountID&gt;</i>", alias="organizationType")
    identification_number: Optional[StrictStr] = Field(default=None, description="Número de identificación o NIT del emisor, sin guiones ni DV. <br><i>Campo oficial DIAN &lt;CompanyID&gt;</i>", alias="identificationNumber")
    dv: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DV del NIT del emisor. Es obligatorio si identificationType = 31. <br><i>Campo oficial DIAN &lt;@schemeID&gt;</i>")
    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Nombre (Razón Social) del Emisor. Si no se envía, se tomará el Nombre/Razón Social de la compañía. <br><i>Campo oficial DIAN &lt;RegistrationName&gt;</i>")
    regime_code: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Régimen o tipo de obligación o responsabilidad del emisor. Se debe colocar el Código que corresponda de la tabla de tipos de régimen/responsabilidades fiscales de la DIAN. Para reportar varias obligaciones / responsabilidades, se deben reportar separando cada uno de los valores de la lista con ';'. Ejemplo O‐13;O‐15; <br><i>Campo oficial DIAN &lt;TaxLevelCode&gt;</i>", alias="regimeCode")
    tax_code: CreateAdjustmentNoteSupportDocumentRequestCompanyTaxCode = Field(alias="taxCode")
    __properties: ClassVar[List[str]] = ["id", "organizationType", "identificationNumber", "dv", "name", "regimeCode", "taxCode"]

    @field_validator('organization_type')
    def organization_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set([1, 2]):
            raise ValueError("must be one of enum values (1, 2)")
        return value

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    @field_validator('regime_code')
    def regime_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^(O-(15|23|47|48|49)|R-99-PN)(;(O-(15|23|47|48|49)|R-99-PN))*$", value):
            raise ValueError(r"must validate the regular expression /^(O-(15|23|47|48|49)|R-99-PN)(;(O-(15|23|47|48|49)|R-99-PN))*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteSupportDocumentRequestCompany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateAdjustmentNoteSupportDocumentRequestCompany from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationType": obj.get("organizationType"),
            "identificationNumber": obj.get("identificationNumber"),
            "dv": obj.get("dv"),
            "name": obj.get("name"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": CreateAdjustmentNoteSupportDocumentRequestCompanyTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None
        })
        return _obj


