# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.create_equivalent_document_pos_request_additional_document_reference import CreateEquivalentDocumentPosRequestAdditionalDocumentReference
from openapi_client.models.create_equivalent_document_pos_request_buyer_benefits import CreateEquivalentDocumentPosRequestBuyerBenefits
from openapi_client.models.create_equivalent_document_pos_request_cash_register import CreateEquivalentDocumentPosRequestCashRegister
from openapi_client.models.create_equivalent_document_pos_request_company import CreateEquivalentDocumentPosRequestCompany
from openapi_client.models.create_equivalent_document_pos_request_customer import CreateEquivalentDocumentPosRequestCustomer
from openapi_client.models.create_equivalent_document_pos_request_discounts_and_charges_inner import CreateEquivalentDocumentPosRequestDiscountsAndChargesInner
from openapi_client.models.create_equivalent_document_pos_request_exchange_rate import CreateEquivalentDocumentPosRequestExchangeRate
from openapi_client.models.create_equivalent_document_pos_request_items_inner import CreateEquivalentDocumentPosRequestItemsInner
from openapi_client.models.create_equivalent_document_pos_request_payments_inner import CreateEquivalentDocumentPosRequestPaymentsInner
from openapi_client.models.create_equivalent_document_pos_request_resolution import CreateEquivalentDocumentPosRequestResolution
from openapi_client.models.create_equivalent_document_pos_request_total_amounts import CreateEquivalentDocumentPosRequestTotalAmounts
from typing import Optional, Set
from typing_extensions import Self

class CreateEquivalentDocumentPosRequest(BaseModel):
    """
    CreateEquivalentDocumentPosRequest
    """ # noqa: E501
    document_type: Optional[StrictStr] = Field(default=None, description="Indica que se emitirá un documento equivalente POS electrónico reemplazando un documento físico generado en contingencia, este elemento acepta la siguiente opción: `07` Contingencia por parte del emisor.<br><i>Campo oficial DIAN &lt;InvoiceTypeCode&gt;</i>", alias="documentType")
    number: StrictStr = Field(description="Número del documento equivalente. <br><i>Campo oficial DIAN &lt;ID&gt;</i>")
    resolution: CreateEquivalentDocumentPosRequestResolution
    company: CreateEquivalentDocumentPosRequestCompany
    customer: Optional[CreateEquivalentDocumentPosRequestCustomer] = None
    items: List[CreateEquivalentDocumentPosRequestItemsInner] = Field(description="Array que contiene el listado de artículos y/o servicios")
    payments: Optional[List[CreateEquivalentDocumentPosRequestPaymentsInner]] = Field(default=None, description="Array con el listado de pagos. Grupo de campos para información relacionadas con el pago de la factura. <br><i>Grupo de información oficial DIAN &lt;PaymentMeans&gt;</i>")
    discounts_and_charges: Optional[List[CreateEquivalentDocumentPosRequestDiscountsAndChargesInner]] = Field(default=None, description="Array con el listado de Descuentos o Cargos a nivel de factura. Grupo de campos para información relacionada con los descuentos o cargos que no afectan las bases gravables. Los descuentos o cargos que afectan bases gravables se deben informar a nivel de ítem. <br><i>Grupo de información oficial DIAN &lt;AllowanceCharge&gt;</i>", alias="discountsAndCharges")
    exchange_rate: Optional[CreateEquivalentDocumentPosRequestExchangeRate] = Field(default=None, alias="exchangeRate")
    total_amounts: CreateEquivalentDocumentPosRequestTotalAmounts = Field(alias="totalAmounts")
    buyer_benefits: Optional[CreateEquivalentDocumentPosRequestBuyerBenefits] = Field(default=None, alias="buyerBenefits")
    cash_register: Optional[CreateEquivalentDocumentPosRequestCashRegister] = Field(default=None, alias="cashRegister")
    note: Optional[StrictStr] = Field(default=None, description="Nota relativa al documento equivalente")
    additional_document_reference: Optional[CreateEquivalentDocumentPosRequestAdditionalDocumentReference] = Field(default=None, alias="additionalDocumentReference")
    __properties: ClassVar[List[str]] = ["documentType", "number", "resolution", "company", "customer", "items", "payments", "discountsAndCharges", "exchangeRate", "totalAmounts", "buyerBenefits", "cashRegister", "note", "additionalDocumentReference"]

    @field_validator('document_type')
    def document_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['07']):
            raise ValueError("must be one of enum values ('07')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateEquivalentDocumentPosRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resolution
        if self.resolution:
            _dict['resolution'] = self.resolution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts_and_charges (list)
        _items = []
        if self.discounts_and_charges:
            for _item_discounts_and_charges in self.discounts_and_charges:
                if _item_discounts_and_charges:
                    _items.append(_item_discounts_and_charges.to_dict())
            _dict['discountsAndCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of exchange_rate
        if self.exchange_rate:
            _dict['exchangeRate'] = self.exchange_rate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_amounts
        if self.total_amounts:
            _dict['totalAmounts'] = self.total_amounts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of buyer_benefits
        if self.buyer_benefits:
            _dict['buyerBenefits'] = self.buyer_benefits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cash_register
        if self.cash_register:
            _dict['cashRegister'] = self.cash_register.to_dict()
        # override the default output from pydantic by calling `to_dict()` of additional_document_reference
        if self.additional_document_reference:
            _dict['additionalDocumentReference'] = self.additional_document_reference.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateEquivalentDocumentPosRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "documentType": obj.get("documentType"),
            "number": obj.get("number"),
            "resolution": CreateEquivalentDocumentPosRequestResolution.from_dict(obj["resolution"]) if obj.get("resolution") is not None else None,
            "company": CreateEquivalentDocumentPosRequestCompany.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "customer": CreateEquivalentDocumentPosRequestCustomer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "items": [CreateEquivalentDocumentPosRequestItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "payments": [CreateEquivalentDocumentPosRequestPaymentsInner.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "discountsAndCharges": [CreateEquivalentDocumentPosRequestDiscountsAndChargesInner.from_dict(_item) for _item in obj["discountsAndCharges"]] if obj.get("discountsAndCharges") is not None else None,
            "exchangeRate": CreateEquivalentDocumentPosRequestExchangeRate.from_dict(obj["exchangeRate"]) if obj.get("exchangeRate") is not None else None,
            "totalAmounts": CreateEquivalentDocumentPosRequestTotalAmounts.from_dict(obj["totalAmounts"]) if obj.get("totalAmounts") is not None else None,
            "buyerBenefits": CreateEquivalentDocumentPosRequestBuyerBenefits.from_dict(obj["buyerBenefits"]) if obj.get("buyerBenefits") is not None else None,
            "cashRegister": CreateEquivalentDocumentPosRequestCashRegister.from_dict(obj["cashRegister"]) if obj.get("cashRegister") is not None else None,
            "note": obj.get("note"),
            "additionalDocumentReference": CreateEquivalentDocumentPosRequestAdditionalDocumentReference.from_dict(obj["additionalDocumentReference"]) if obj.get("additionalDocumentReference") is not None else None
        })
        return _obj


