# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateEquivalentDocumentPosRequestAdditionalDocumentReference(BaseModel):
    """
    Grupo de campos para información que describen un documento referenciado por el documento equivalente POS electrónico. Este objeto es requerido cuando se generen POS electrónicos en contingencia y deban ser enviados a la DIAN. <i>Grupo de información oficial DIAN &lt;AdditionalDocumentReference&gt;</i>
    """ # noqa: E501
    number: StrictStr = Field(description="Prefijo y Número del documento referenciado, para el caso de  documentos POS en contingencia se deberá enviar el número del documento generado. <br><i>Grupo de información oficial DIAN &lt;ID&gt;</i>")
    issue_date: date = Field(description="Fecha de emisión del documento referenciado; obligatorio en operaciones en contingencia cuando se quiera referenciar un documento POS físico. <br><i>Grupo de información oficial DIAN &lt;IssueDate&gt;</i>", alias="issueDate")
    document_type_code: Optional[StrictStr] = Field(default=None, description="Identificador del tipo de documento de referencia, corresponde a una codificación propia de la empresa. <br><i>Grupo de información oficial DIAN &lt;DocumentTypeCode&gt;</i>", alias="documentTypeCode")
    __properties: ClassVar[List[str]] = ["number", "issueDate", "documentTypeCode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateEquivalentDocumentPosRequestAdditionalDocumentReference from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateEquivalentDocumentPosRequestAdditionalDocumentReference from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "number": obj.get("number"),
            "issueDate": obj.get("issueDate"),
            "documentTypeCode": obj.get("documentTypeCode")
        })
        return _obj


