# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_equivalent_document_pos_request_company_contact import CreateEquivalentDocumentPosRequestCompanyContact
from openapi_client.models.create_equivalent_document_pos_request_company_tax_code import CreateEquivalentDocumentPosRequestCompanyTaxCode
from openapi_client.models.get_companies200_response_companies_inner_address import GetCompanies200ResponseCompaniesInnerAddress
from typing import Optional, Set
from typing_extensions import Self

class CreateEquivalentDocumentPosRequestCompany(BaseModel):
    """
    Objeto que contiene la información del obligado a facturar o emisor del documento electrónico. <br><i>Grupo de información oficial DIAN &lt;AccountingSupplierParty&gt;</i>
    """ # noqa: E501
    id: StrictStr = Field(description="Id de la empresa. Id único generado por la API")
    organization_type: Optional[Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Identificador de tipo de organización jurídica de la persona o empresa. Se debe colocar el Código que corresponda de la tabla de tipos de organización jurídica de la DIAN. <br><i>Campo oficial DIAN &lt;AdditionalAccountID&gt;</i>", alias="organizationType")
    identification_number: Optional[StrictStr] = Field(default=None, description="Número de identificación o NIT del emisor, sin guiones ni DV. <br><i>Campo oficial DIAN &lt;CompanyID&gt;</i>", alias="identificationNumber")
    dv: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="DV del NIT del emisor. Es obligatorio si identificationType = 31. <br><i>Campo oficial DIAN &lt;@schemeID&gt;</i>")
    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Nombre (Razón Social) del Emisor. Si no se envía, se tomará el Nombre/Razón Social de la compañía. <br><i>Campo oficial DIAN &lt;RegistrationName&gt;</i>")
    trade_name: Optional[StrictStr] = Field(default=None, description="Nombre Comercial del Emisor. <br><i>Campo oficial DIAN &lt;Name&gt;</i>", alias="tradeName")
    regime_code: Optional[StrictStr] = Field(default=None, description="Régimen o tipo de obligación o responsabilidad del emisor. Se debe colocar el Código que corresponda de la tabla de tipos de régimen/responsabilidades fiscales de la DIAN. Para reportar varias obligaciones / responsabilidades, se deben reportar separando cada uno de los valores de la lista con ';'. Ejemplo O‐13;O‐15; <br><i>Campo oficial DIAN &lt;TaxLevelCode&gt;</i>", alias="regimeCode")
    tax_code: Optional[CreateEquivalentDocumentPosRequestCompanyTaxCode] = Field(default=None, alias="taxCode")
    economic_activities: Optional[Annotated[List[Annotated[str, Field(strict=True)]], Field(min_length=1)]] = Field(default=None, description="Lista de actividades económicas de la empresa. Debe informar el código según lista CIIU", alias="economicActivities")
    email: Optional[StrictStr] = Field(default=None, description="Correo electrónico. Se debe colocar el correo de recepción para documentos e instrumentos electrónicos. <br><i>Campo oficial DIAN &lt;ElectronicMail&gt;</i>")
    phone: Optional[StrictStr] = Field(default=None, description="Número de teléfono, celular u otro. <br><i>Campo oficial DIAN &lt;Telephone&gt;</i>")
    address: Optional[GetCompanies200ResponseCompaniesInnerAddress] = None
    contact: Optional[CreateEquivalentDocumentPosRequestCompanyContact] = None
    __properties: ClassVar[List[str]] = ["id", "organizationType", "identificationNumber", "dv", "name", "tradeName", "regimeCode", "taxCode", "economicActivities", "email", "phone", "address", "contact"]

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateEquivalentDocumentPosRequestCompany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of contact
        if self.contact:
            _dict['contact'] = self.contact.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateEquivalentDocumentPosRequestCompany from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationType": obj.get("organizationType"),
            "identificationNumber": obj.get("identificationNumber"),
            "dv": obj.get("dv"),
            "name": obj.get("name"),
            "tradeName": obj.get("tradeName"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": CreateEquivalentDocumentPosRequestCompanyTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None,
            "economicActivities": obj.get("economicActivities"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "address": GetCompanies200ResponseCompaniesInnerAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "contact": CreateEquivalentDocumentPosRequestCompanyContact.from_dict(obj["contact"]) if obj.get("contact") is not None else None
        })
        return _obj


