# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_equivalent_document_pos_request_exchange_rate import CreateEquivalentDocumentPosRequestExchangeRate
from openapi_client.models.create_equivalent_document_pos_request_payments_inner import CreateEquivalentDocumentPosRequestPaymentsInner
from openapi_client.models.create_equivalent_document_pos_request_total_amounts import CreateEquivalentDocumentPosRequestTotalAmounts
from openapi_client.models.create_invoice_request_additional_document_reference import CreateInvoiceRequestAdditionalDocumentReference
from openapi_client.models.create_invoice_request_advance_payments_inner import CreateInvoiceRequestAdvancePaymentsInner
from openapi_client.models.create_invoice_request_company import CreateInvoiceRequestCompany
from openapi_client.models.create_invoice_request_customer import CreateInvoiceRequestCustomer
from openapi_client.models.create_invoice_request_discounts_and_charges_inner import CreateInvoiceRequestDiscountsAndChargesInner
from openapi_client.models.create_invoice_request_health_sector_general import CreateInvoiceRequestHealthSectorGeneral
from openapi_client.models.create_invoice_request_invoice_period import CreateInvoiceRequestInvoicePeriod
from openapi_client.models.create_invoice_request_items_inner import CreateInvoiceRequestItemsInner
from openapi_client.models.create_invoice_request_order_reference import CreateInvoiceRequestOrderReference
from openapi_client.models.create_invoice_request_resolution import CreateInvoiceRequestResolution
from typing import Optional, Set
from typing_extensions import Self

class CreateInvoiceRequest(BaseModel):
    """
    CreateInvoiceRequest
    """ # noqa: E501
    document_type: StrictStr = Field(description="Tipo de Documento / Factura. 01: Estándar, 02: Exportación, 03: Mandato, 04: Contingencia Facturador Electrónico, 05: Transporte, 06: AIU, 07: Factura electrónica de Compra de divisa, 08: Factura electrónica de Venta de divisa", alias="documentType")
    number: Union[StrictFloat, StrictInt] = Field(description="Número de la factura electrónica. <br><i>Campo oficial DIAN &lt;ID&gt;</i>")
    note: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, description="Nota o información adicional: Texto libre, relativo al documento. <br><i>Campo oficial DIAN &lt;Note&gt;</i>")
    resolution: CreateInvoiceRequestResolution
    company: CreateInvoiceRequestCompany
    customer: CreateInvoiceRequestCustomer
    items: List[CreateInvoiceRequestItemsInner] = Field(description="Array que contiene el listado de artículos y/o servicios")
    payments: Optional[List[CreateEquivalentDocumentPosRequestPaymentsInner]] = Field(default=None, description="Array con el listado de pagos. Grupo de campos para información relacionadas con el pago de la factura. <br><i>Grupo de información oficial DIAN &lt;PaymentMeans&gt;</i>")
    advance_payments: Optional[List[CreateInvoiceRequestAdvancePaymentsInner]] = Field(default=None, description="Array con el listado de anticipos. Grupo de campos para información relacionadas con un anticipo. <br><i>Grupo de información oficial DIAN &lt;PrePaidPayment&gt;</i>", alias="advancePayments")
    discounts_and_charges: Optional[List[CreateInvoiceRequestDiscountsAndChargesInner]] = Field(default=None, description="Array con el listado de Descuentos o Cargos a nivel de factura. Grupo de campos para información relacionada con los descuentos o cargos que no afectan las bases gravables. Los descuentos o cargos que afectan bases gravables se deben informar a nivel de ítem. <br><i>Grupo de información oficial DIAN &lt;AllowanceCharge&gt;</i>", alias="discountsAndCharges")
    exchange_rate: Optional[CreateEquivalentDocumentPosRequestExchangeRate] = Field(default=None, alias="exchangeRate")
    total_amounts: CreateEquivalentDocumentPosRequestTotalAmounts = Field(alias="totalAmounts")
    health_sector_general: Optional[CreateInvoiceRequestHealthSectorGeneral] = Field(default=None, alias="healthSectorGeneral")
    invoice_period: Optional[CreateInvoiceRequestInvoicePeriod] = Field(default=None, alias="invoicePeriod")
    additional_document_reference: Optional[CreateInvoiceRequestAdditionalDocumentReference] = Field(default=None, alias="additionalDocumentReference")
    order_reference: Optional[CreateInvoiceRequestOrderReference] = Field(default=None, alias="orderReference")
    __properties: ClassVar[List[str]] = ["documentType", "number", "note", "resolution", "company", "customer", "items", "payments", "advancePayments", "discountsAndCharges", "exchangeRate", "totalAmounts", "healthSectorGeneral", "invoicePeriod", "additionalDocumentReference", "orderReference"]

    @field_validator('document_type')
    def document_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['01', '02', '03', '04', '05', '06', '07', '08']):
            raise ValueError("must be one of enum values ('01', '02', '03', '04', '05', '06', '07', '08')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resolution
        if self.resolution:
            _dict['resolution'] = self.resolution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of company
        if self.company:
            _dict['company'] = self.company.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item_items in self.items:
                if _item_items:
                    _items.append(_item_items.to_dict())
            _dict['items'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in payments (list)
        _items = []
        if self.payments:
            for _item_payments in self.payments:
                if _item_payments:
                    _items.append(_item_payments.to_dict())
            _dict['payments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in advance_payments (list)
        _items = []
        if self.advance_payments:
            for _item_advance_payments in self.advance_payments:
                if _item_advance_payments:
                    _items.append(_item_advance_payments.to_dict())
            _dict['advancePayments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in discounts_and_charges (list)
        _items = []
        if self.discounts_and_charges:
            for _item_discounts_and_charges in self.discounts_and_charges:
                if _item_discounts_and_charges:
                    _items.append(_item_discounts_and_charges.to_dict())
            _dict['discountsAndCharges'] = _items
        # override the default output from pydantic by calling `to_dict()` of exchange_rate
        if self.exchange_rate:
            _dict['exchangeRate'] = self.exchange_rate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of total_amounts
        if self.total_amounts:
            _dict['totalAmounts'] = self.total_amounts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of health_sector_general
        if self.health_sector_general:
            _dict['healthSectorGeneral'] = self.health_sector_general.to_dict()
        # override the default output from pydantic by calling `to_dict()` of invoice_period
        if self.invoice_period:
            _dict['invoicePeriod'] = self.invoice_period.to_dict()
        # override the default output from pydantic by calling `to_dict()` of additional_document_reference
        if self.additional_document_reference:
            _dict['additionalDocumentReference'] = self.additional_document_reference.to_dict()
        # override the default output from pydantic by calling `to_dict()` of order_reference
        if self.order_reference:
            _dict['orderReference'] = self.order_reference.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateInvoiceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "documentType": obj.get("documentType"),
            "number": obj.get("number"),
            "note": obj.get("note"),
            "resolution": CreateInvoiceRequestResolution.from_dict(obj["resolution"]) if obj.get("resolution") is not None else None,
            "company": CreateInvoiceRequestCompany.from_dict(obj["company"]) if obj.get("company") is not None else None,
            "customer": CreateInvoiceRequestCustomer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "items": [CreateInvoiceRequestItemsInner.from_dict(_item) for _item in obj["items"]] if obj.get("items") is not None else None,
            "payments": [CreateEquivalentDocumentPosRequestPaymentsInner.from_dict(_item) for _item in obj["payments"]] if obj.get("payments") is not None else None,
            "advancePayments": [CreateInvoiceRequestAdvancePaymentsInner.from_dict(_item) for _item in obj["advancePayments"]] if obj.get("advancePayments") is not None else None,
            "discountsAndCharges": [CreateInvoiceRequestDiscountsAndChargesInner.from_dict(_item) for _item in obj["discountsAndCharges"]] if obj.get("discountsAndCharges") is not None else None,
            "exchangeRate": CreateEquivalentDocumentPosRequestExchangeRate.from_dict(obj["exchangeRate"]) if obj.get("exchangeRate") is not None else None,
            "totalAmounts": CreateEquivalentDocumentPosRequestTotalAmounts.from_dict(obj["totalAmounts"]) if obj.get("totalAmounts") is not None else None,
            "healthSectorGeneral": CreateInvoiceRequestHealthSectorGeneral.from_dict(obj["healthSectorGeneral"]) if obj.get("healthSectorGeneral") is not None else None,
            "invoicePeriod": CreateInvoiceRequestInvoicePeriod.from_dict(obj["invoicePeriod"]) if obj.get("invoicePeriod") is not None else None,
            "additionalDocumentReference": CreateInvoiceRequestAdditionalDocumentReference.from_dict(obj["additionalDocumentReference"]) if obj.get("additionalDocumentReference") is not None else None,
            "orderReference": CreateInvoiceRequestOrderReference.from_dict(obj["orderReference"]) if obj.get("orderReference") is not None else None
        })
        return _obj


