# coding: utf-8

"""
    API Alegra Proveedor Electrónico Colombia

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_company_request_all_of_address import CreateCompanyRequestAllOfAddress
from openapi_client.models.create_company_request_all_of_certificate import CreateCompanyRequestAllOfCertificate
from openapi_client.models.create_company_request_all_of_notification_by_email import CreateCompanyRequestAllOfNotificationByEmail
from openapi_client.models.create_company_request_all_of_webhooks import CreateCompanyRequestAllOfWebhooks
from openapi_client.models.get_companies200_response_companies_inner_tax_code import GetCompanies200ResponseCompaniesInnerTaxCode
from typing import Optional, Set
from typing_extensions import Self

class UpdateCompanyRequest(BaseModel):
    """
    UpdateCompanyRequest
    """ # noqa: E501
    name: Optional[Annotated[str, Field(min_length=5, strict=True, max_length=450)]] = Field(default=None, description="Nombre/Razón Social de la empresa")
    trade_name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=450)]] = Field(default=None, description="Nombre Comercial de la empresa", alias="tradeName")
    identification: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=30)]] = Field(default=None, description="Identificación de la empresa")
    dv: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Dígito verificador de la identificación de la empresa")
    type: Optional[StrictStr] = Field(default=None, description="Tipo de empresa")
    use_alegra_certificate: Optional[StrictBool] = Field(default=None, description="Indica si se desea usar el certificado de Alegra o no", alias="useAlegraCertificate")
    certificate: Optional[CreateCompanyRequestAllOfCertificate] = None
    notification_by_email: Optional[CreateCompanyRequestAllOfNotificationByEmail] = Field(default=None, alias="notificationByEmail")
    webhooks: Optional[CreateCompanyRequestAllOfWebhooks] = None
    organization_type: Optional[Union[Annotated[float, Field(strict=True)], Annotated[int, Field(strict=True)]]] = Field(default=None, description="Tipo de organización jurídica de la empresa. Se debe colocar el Código que corresponda de la tabla de tipo de organización jurídica de la DIAN", alias="organizationType")
    identification_type: Optional[Annotated[str, Field(strict=True, max_length=2)]] = Field(default=None, description="Tipo de documento de identificación de la empresa. Se debe colocar el Código que corresponda de la tabla de tipos de identificación de la DIAN", alias="identificationType")
    regime_code: Optional[StrictStr] = Field(default=None, description="Régimen al que pertenece la empresa. Se debe colocar el Código que corresponda de la tabla de tipos de responsabilidad fiscal de la DIAN. Para reportar varias obligaciones / responsabilidades, se deben reportar separando cada uno de los valores de la lista con ';'. Ejemplo O‐13;O‐15;", alias="regimeCode")
    tax_code: Optional[GetCompanies200ResponseCompaniesInnerTaxCode] = Field(default=None, alias="taxCode")
    economic_activities: Optional[Annotated[List[Annotated[str, Field(strict=True)]], Field(min_length=1)]] = Field(default=None, description="Lista de actividades económicas de la empresa. Debe informar el código según lista CIIU", alias="economicActivities")
    email: Optional[StrictStr] = Field(default=None, description="Correo electrónico de la empresa registrado en la DIAN para la recepción de documentos")
    phone: Optional[StrictStr] = Field(default=None, description="Número de teléfono, celular u otro")
    address: Optional[CreateCompanyRequestAllOfAddress] = None
    logo: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Imagen del logo en base64 a incluir en todos los documentos PDF ## Consideraciones - El tamaño máximo de la imagen es de 150 KB (aproximadamente 150,000 caracteres en base64). - La validación final del tamaño se realizará en el servidor después de decodificar la imagen. - Si un documento es creado con un logo, este siempre mostrará ese logo. Si el logo es actualizado posteriormente, los documentos creados anteriormente no serán actualizados para mostrar el nuevo logo. Por lo tanto, se recomienda crear documentos con un logo solo después de haber cargado y establecido el logo final.")
    other_responsabilities: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=193)]] = Field(default=None, description="Texto que permite incluir información adicional sobre las responsabilidades fiscales o de otro tipo que la empresa desee reflejar en los documentos emitidos. Esta información se incluirá tanto en el XML como en el PDF de los documentos generados", alias="otherResponsabilities")
    __properties: ClassVar[List[str]] = ["name", "tradeName", "identification", "dv", "type", "useAlegraCertificate", "certificate", "notificationByEmail", "webhooks", "organizationType", "identificationType", "regimeCode", "taxCode", "economicActivities", "email", "phone", "address", "logo", "otherResponsabilities"]

    @field_validator('dv')
    def dv_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]{1})$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]{1})$/")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['main', 'associated']):
            raise ValueError("must be one of enum values ('main', 'associated')")
        return value

    @field_validator('other_responsabilities')
    def other_responsabilities_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^$|.{15,}$", value):
            raise ValueError(r"must validate the regular expression /^$|.{15,}$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateCompanyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of certificate
        if self.certificate:
            _dict['certificate'] = self.certificate.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notification_by_email
        if self.notification_by_email:
            _dict['notificationByEmail'] = self.notification_by_email.to_dict()
        # override the default output from pydantic by calling `to_dict()` of webhooks
        if self.webhooks:
            _dict['webhooks'] = self.webhooks.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tax_code
        if self.tax_code:
            _dict['taxCode'] = self.tax_code.to_dict()
        # override the default output from pydantic by calling `to_dict()` of address
        if self.address:
            _dict['address'] = self.address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateCompanyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "tradeName": obj.get("tradeName"),
            "identification": obj.get("identification"),
            "dv": obj.get("dv"),
            "type": obj.get("type"),
            "useAlegraCertificate": obj.get("useAlegraCertificate"),
            "certificate": CreateCompanyRequestAllOfCertificate.from_dict(obj["certificate"]) if obj.get("certificate") is not None else None,
            "notificationByEmail": CreateCompanyRequestAllOfNotificationByEmail.from_dict(obj["notificationByEmail"]) if obj.get("notificationByEmail") is not None else None,
            "webhooks": CreateCompanyRequestAllOfWebhooks.from_dict(obj["webhooks"]) if obj.get("webhooks") is not None else None,
            "organizationType": obj.get("organizationType"),
            "identificationType": obj.get("identificationType"),
            "regimeCode": obj.get("regimeCode"),
            "taxCode": GetCompanies200ResponseCompaniesInnerTaxCode.from_dict(obj["taxCode"]) if obj.get("taxCode") is not None else None,
            "economicActivities": obj.get("economicActivities"),
            "email": obj.get("email"),
            "phone": obj.get("phone"),
            "address": CreateCompanyRequestAllOfAddress.from_dict(obj["address"]) if obj.get("address") is not None else None,
            "logo": obj.get("logo"),
            "otherResponsabilities": obj.get("otherResponsabilities")
        })
        return _obj


