"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaWorkflow = exports.MediaWorkflowProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mps_generated_1 = require("./mps.generated");
Object.defineProperty(exports, "MediaWorkflowProperty", { enumerable: true, get: function () { return mps_generated_1.RosMediaWorkflow; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::MPS::MediaWorkflow`, which is used to add a media workflow.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosMediaWorkflow`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-mps-mediaworkflow
 */
class MediaWorkflow extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosMediaWorkflow = new mps_generated_1.RosMediaWorkflow(this, id, {
            triggerMode: props.triggerMode,
            topology: props.topology,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosMediaWorkflow;
        this.attrCreationTime = rosMediaWorkflow.attrCreationTime;
        this.attrMediaWorkflowId = rosMediaWorkflow.attrMediaWorkflowId;
        this.attrName = rosMediaWorkflow.attrName;
        this.attrState = rosMediaWorkflow.attrState;
        this.attrTopology = rosMediaWorkflow.attrTopology;
        this.attrTriggerMode = rosMediaWorkflow.attrTriggerMode;
    }
}
exports.MediaWorkflow = MediaWorkflow;
//# sourceMappingURL=data:application/json;base64,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