
"""The namespace is the core for nested namespaces and the most basic objects used for Aspose.Imaging processing."""
from typing import List, Optional, Dict, Iterable, Any, overload
import enum
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.imaging
import aspose.imaging.apsbuilder
import aspose.imaging.apsbuilder.dib
import aspose.imaging.asynctask
import aspose.imaging.brushes
import aspose.imaging.dithering
import aspose.imaging.exif
import aspose.imaging.exif.enums
import aspose.imaging.extensions
import aspose.imaging.fileformats
import aspose.imaging.fileformats.apng
import aspose.imaging.fileformats.avif
import aspose.imaging.fileformats.bigtiff
import aspose.imaging.fileformats.bmp
import aspose.imaging.fileformats.bmp.structures
import aspose.imaging.fileformats.cdr
import aspose.imaging.fileformats.cdr.const
import aspose.imaging.fileformats.cdr.enum
import aspose.imaging.fileformats.cdr.objects
import aspose.imaging.fileformats.cdr.types
import aspose.imaging.fileformats.cmx
import aspose.imaging.fileformats.cmx.objectmodel
import aspose.imaging.fileformats.cmx.objectmodel.enums
import aspose.imaging.fileformats.cmx.objectmodel.specs
import aspose.imaging.fileformats.cmx.objectmodel.styles
import aspose.imaging.fileformats.core
import aspose.imaging.fileformats.core.vectorpaths
import aspose.imaging.fileformats.dicom
import aspose.imaging.fileformats.djvu
import aspose.imaging.fileformats.dng
import aspose.imaging.fileformats.dng.decoder
import aspose.imaging.fileformats.emf
import aspose.imaging.fileformats.emf.dtyp
import aspose.imaging.fileformats.emf.dtyp.commondatastructures
import aspose.imaging.fileformats.emf.emf
import aspose.imaging.fileformats.emf.emf.consts
import aspose.imaging.fileformats.emf.emf.objects
import aspose.imaging.fileformats.emf.emf.records
import aspose.imaging.fileformats.emf.emfplus
import aspose.imaging.fileformats.emf.emfplus.consts
import aspose.imaging.fileformats.emf.emfplus.objects
import aspose.imaging.fileformats.emf.emfplus.records
import aspose.imaging.fileformats.emf.emfspool
import aspose.imaging.fileformats.emf.emfspool.records
import aspose.imaging.fileformats.emf.graphics
import aspose.imaging.fileformats.eps
import aspose.imaging.fileformats.eps.consts
import aspose.imaging.fileformats.gif
import aspose.imaging.fileformats.gif.blocks
import aspose.imaging.fileformats.ico
import aspose.imaging.fileformats.jpeg
import aspose.imaging.fileformats.jpeg2000
import aspose.imaging.fileformats.opendocument
import aspose.imaging.fileformats.opendocument.enums
import aspose.imaging.fileformats.opendocument.objects
import aspose.imaging.fileformats.opendocument.objects.brush
import aspose.imaging.fileformats.opendocument.objects.font
import aspose.imaging.fileformats.opendocument.objects.graphic
import aspose.imaging.fileformats.opendocument.objects.pen
import aspose.imaging.fileformats.pdf
import aspose.imaging.fileformats.png
import aspose.imaging.fileformats.psd
import aspose.imaging.fileformats.svg
import aspose.imaging.fileformats.svg.graphics
import aspose.imaging.fileformats.tga
import aspose.imaging.fileformats.tiff
import aspose.imaging.fileformats.tiff.enums
import aspose.imaging.fileformats.tiff.filemanagement
import aspose.imaging.fileformats.tiff.filemanagement.bigtiff
import aspose.imaging.fileformats.tiff.instancefactory
import aspose.imaging.fileformats.tiff.pathresources
import aspose.imaging.fileformats.tiff.tifftagtypes
import aspose.imaging.fileformats.webp
import aspose.imaging.fileformats.wmf
import aspose.imaging.fileformats.wmf.consts
import aspose.imaging.fileformats.wmf.graphics
import aspose.imaging.fileformats.wmf.objects
import aspose.imaging.fileformats.wmf.objects.escaperecords
import aspose.imaging.imagefilters
import aspose.imaging.imagefilters.complexutils
import aspose.imaging.imagefilters.convolution
import aspose.imaging.imagefilters.filteroptions
import aspose.imaging.imageloadoptions
import aspose.imaging.imageoptions
import aspose.imaging.interfaces
import aspose.imaging.magicwand
import aspose.imaging.magicwand.imagemasks
import aspose.imaging.masking
import aspose.imaging.masking.options
import aspose.imaging.masking.result
import aspose.imaging.memorymanagement
import aspose.imaging.metadata
import aspose.imaging.multithreading
import aspose.imaging.palettehelper
import aspose.imaging.progressmanagement
import aspose.imaging.shapes
import aspose.imaging.shapesegments
import aspose.imaging.sources
import aspose.imaging.watermark
import aspose.imaging.watermark.options
import aspose.imaging.xmp
import aspose.imaging.xmp.schemas
import aspose.imaging.xmp.schemas.dicom
import aspose.imaging.xmp.schemas.dublincore
import aspose.imaging.xmp.schemas.pdf
import aspose.imaging.xmp.schemas.photoshop
import aspose.imaging.xmp.schemas.xmpbaseschema
import aspose.imaging.xmp.schemas.xmpdm
import aspose.imaging.xmp.schemas.xmpmm
import aspose.imaging.xmp.schemas.xmprm
import aspose.imaging.xmp.types
import aspose.imaging.xmp.types.basic
import aspose.imaging.xmp.types.complex
import aspose.imaging.xmp.types.complex.colorant
import aspose.imaging.xmp.types.complex.dimensions
import aspose.imaging.xmp.types.complex.font
import aspose.imaging.xmp.types.complex.resourceevent
import aspose.imaging.xmp.types.complex.resourceref
import aspose.imaging.xmp.types.complex.thumbnail
import aspose.imaging.xmp.types.complex.version
import aspose.imaging.xmp.types.derived

class Blend:
    '''Defines a blend pattern. This class cannot be inherited.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Blend` class. The number of elements in the factor and blend arrays will be equal to 1.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, count : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Blend` class with the specified number of factors and positions.
        
        :param count: The number of elements in the factor and position arrays.'''
        raise NotImplementedError()
    
    @property
    def factors(self) -> List[float]:
        '''Gets the array of blend factors for the gradient.'''
        raise NotImplementedError()
    
    @factors.setter
    def factors(self, value : List[float]) -> None:
        '''Sets the array of blend factors for the gradient.'''
        raise NotImplementedError()
    
    @property
    def positions(self) -> List[float]:
        '''Gets the array of blend positions for the gradient.'''
        raise NotImplementedError()
    
    @positions.setter
    def positions(self, value : List[float]) -> None:
        '''Sets the array of blend positions for the gradient.'''
        raise NotImplementedError()
    

class Brush(DisposableObject):
    '''The base brush class.'''
    
    def deep_clone(self) -> aspose.imaging.Brush:
        '''Creates a new deep clone of the current :py:class:`aspose.imaging.Brush`.
        
        :returns: A new :py:class:`aspose.imaging.Brush` which is the deep clone of this :py:class:`aspose.imaging.Brush` instance.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def opacity(self) -> float:
        '''Gets the brush opacity. The value should be between 0 and 1. Value of 0 means that brush is fully visible, value of 1 means the brush is fully opaque.'''
        raise NotImplementedError()
    
    @opacity.setter
    def opacity(self, value : float) -> None:
        '''Sets the brush opacity. The value should be between 0 and 1. Value of 0 means that brush is fully visible, value of 1 means the brush is fully opaque.'''
        raise NotImplementedError()
    

class BuildVersionInfo:
    '''Contains the current build version information.'''
    
    @property
    def ASSEMBLY_VERSION(self) -> str:
        '''The assembly version.'''
        raise NotImplementedError()

    @property
    def FILE_VERSION(self) -> str:
        '''The file version.'''
        raise NotImplementedError()

    @property
    def PRODUCT(self) -> str:
        '''The product title.'''
        raise NotImplementedError()

    @property
    def PRODUCT_MAJOR(self) -> int:
        '''The major product version.'''
        raise NotImplementedError()

    @property
    def PRODUCT_MINOR(self) -> int:
        '''The minor product version.'''
        raise NotImplementedError()

    @property
    def RELEASE_DATE(self) -> datetime:
        '''The product release date.'''
        raise NotImplementedError()


class Cache:
    '''Contains cache settings.'''
    
    @staticmethod
    def set_defaults() -> None:
        '''Sets the :py:class:`aspose.imaging.Cache` settings to defaults.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_exact_reallocate_only(value: bool) -> None:
        '''Gets a value indicating whether reallocation should be exact or not. If reallocation is non exact the performance should be higher.'''
    @property
    def exact_reallocate_only(self) -> bool:
        '''Sets a value indicating whether reallocation should be exact or not. If reallocation is non exact the performance should be higher.'''
        raise NotImplementedError()

    @staticmethod
    def set_cache_folder(value: str) -> None:
        '''Gets the cache folder.'''
    @property
    def cache_folder(self) -> str:
        '''Sets the cache folder.'''
        raise NotImplementedError()

    @property
    def allocated_memory_bytes_count(self) -> int:
        '''Gets the allocated in-memory bytes count.'''
        raise NotImplementedError()

    @property
    def allocated_disk_bytes_count(self) -> int:
        '''Gets the allocated disk bytes count.'''
        raise NotImplementedError()

    @staticmethod
    def set_max_memory_for_cache(value: int) -> None:
        '''Gets the maximum available memory for cache in memory. The value specified is megabytes count.'''
    @property
    def max_memory_for_cache(self) -> int:
        '''Sets the maximum available memory for cache in memory. The value specified is megabytes count.'''
        raise NotImplementedError()

    @staticmethod
    def set_max_disk_space_for_cache(value: int) -> None:
        '''Gets the maximum available disk space for cache. The value specified is megabytes count.'''
    @property
    def max_disk_space_for_cache(self) -> int:
        '''Sets the maximum available disk space for cache. The value specified is megabytes count.'''
        raise NotImplementedError()

    @staticmethod
    def set_cache_type(value: aspose.imaging.CacheType) -> None:
        '''Gets the cache scheme used.'''
    @property
    def cache_type(self) -> aspose.imaging.CacheType:
        '''Sets the cache scheme used.'''
        raise NotImplementedError()


class CmykColor:
    '''The CMYK color of pixel.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixels : List[int]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from 32-bit ARGB color to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param argb_pixels: The pixels of 32-bit ARGB format.
        :returns: The :py:class:`List[aspose.imaging.CmykColor]`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixel : int) -> aspose.imaging.CmykColor:
        '''The conversion from 32-bit ARGB to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param argb_pixel: The pixel of 32-bit ARGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_color(cmyk_pixels : List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion  with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The array of the ARGB colors.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_color(cmyk_pixel : aspose.imaging.CmykColor) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb`.
        
        :param cmyk_pixel: The pixels of CMYKColor type in CMYK format.
        :returns: The :py:class:`List[aspose.imaging.Color]`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixels : List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The :py:class:`List[aspose.imaging.Color]`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixel : aspose.imaging.CmykColor) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixel: The pixel of CMYKColor type in CMYK format.
        :returns: The :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixels : List[aspose.imaging.CmykColor], cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The :py:class:`List[aspose.imaging.Color]`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_color_icc(cmyk_pixel : aspose.imaging.CmykColor, cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixel: The pixel of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_params(cyan : int, magenta : int, yellow : int, black : int) -> aspose.imaging.CmykColor:
        '''Creates a :py:class:`aspose.imaging.CmykColor` structure from a 32-bit cyan, magenta, yellow and black values.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.from_components`.
        
        :param cyan: The cyan component. Valid values are 0 through 255.
        :param magenta: The magenta component. Valid values are 0 through 255.
        :param yellow: The yellow component. Valid values are 0 through 255.
        :param black: The black component. Valid values are 0 through 255.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_colors(cmyk_pixels : List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion  with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The array of the ARGB colors.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb32(cmyk_pixels : List[aspose.imaging.CmykColor]) -> List[int]:
        '''The conversion from CMYKColor to 32-bit ARGB Color using icc conversion  with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb32`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The array of the 32-bit ARGB color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_color(argb_pixel : int) -> aspose.imaging.CmykColor:
        '''The conversion from 32-bit ARGB to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param argb_pixel: The pixel of 32-bit ARGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_colors_with_def_icc(cmyk_pixels : List[aspose.imaging.CmykColor]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :returns: The :py:class:`List[aspose.imaging.Color]`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_color_with_def_icc(cmyk_pixels : aspose.imaging.CmykColor) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixels: The pixel of CMYKColor type in CMYK format.
        :returns: The :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_colors_with_icc(cmyk_pixels : List[aspose.imaging.CmykColor], cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixels: The pixels of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The :py:class:`List[aspose.imaging.Color]`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_color_with_icc(cmyk_pixels : aspose.imaging.CmykColor, cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> aspose.imaging.Color:
        '''The conversion from CMYKColor to Color using icc conversion.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_argb_icc`.
        
        :param cmyk_pixels: The pixel of CMYKColor type in CMYK format.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :returns: The :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_colors(argb_pixels : List[int]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from 32-bit ARGB color to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param argb_pixels: The pixels of 32-bit ARGB format.
        :returns: The :py:class:`List[aspose.imaging.CmykColor]`.'''
        raise NotImplementedError()
    
    def to_value(self) -> int:
        '''The to value.
        
        :returns: The long CMYK value.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.CmykColor:
        '''Gets the empty.'''
        raise NotImplementedError()

    @property
    def c(self) -> int:
        '''Gets the cyan component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def m(self) -> int:
        '''Gets the magenta component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the yellow component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def k(self) -> int:
        '''Gets the black component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Color` structure is uninitialized.'''
        raise NotImplementedError()
    

class CmykColorHelper:
    '''Helper methods to work with CMYK color presented as a signed 32-bit integer value.
    Provides the similar API as the :py:class:`aspose.imaging.CmykColor` struct.
    It\'s more lightweight because CMYK color is presented just as Int32 rather than structure with internal fields.
    Please prefer to use static methods of this class when possible instead of the deprecated
    :py:class:`aspose.imaging.CmykColor` struct.'''
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixels : List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param argb_pixels: The ARGB colors presented as 32-bit integer values.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(argb_pixel : int) -> int:
        '''The conversion from ARGB color to CMYK color.
        
        :param argb_pixel: The ARGB color presented as a 32-bit integer value.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(pixel : aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(pixels : List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_argb(cmyk_pixels : List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_argb(cmyk_pixel : int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixels : List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with default profiles.
        
        :param cmyk_pixels: The CMYK pixels presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixels : List[int], cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with custom profiles.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB colors.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixel : int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB Color using Icc conversion with default profiles.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_argb_icc(cmyk_pixel : int, cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color using Icc conversion with custom profile.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels : List[aspose.imaging.Color], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels : List[int], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels : List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels : List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel : aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(argb : int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel : aspose.imaging.Color, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(argb : int, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param argb: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(pixels : List[int], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(pixels : List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(argb : int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value in KCMY byte order with inverted channel values.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_psd_cmyk_icc(pixel : int, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        raise NotImplementedError()
    
    @staticmethod
    def get_c(cmyk : int) -> int:
        '''Gets the cyan component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The cyan component value.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_m(cmyk : int) -> int:
        '''Gets the magenta component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The magenta component value.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_y(cmyk : int) -> int:
        '''Gets the yellow component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The yellow component value.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_k(cmyk : int) -> int:
        '''Gets the black component value.
        
        :param cmyk: The CMYK color presented as a 32-bit integer value.
        :returns: The black component value.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_components(cyan : int, magenta : int, yellow : int, black : int) -> int:
        '''Creates CMYK from a 32-bit cyan, magenta, yellow and black values.
        
        :param cyan: The cyan component. Valid values are 0 through 255.
        :param magenta: The magenta component. Valid values are 0 through 255.
        :param yellow: The yellow component. Valid values are 0 through 255.
        :param black: The black component. Valid values are 0 through 255.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_array(argb_pixels : List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param argb_pixels: The ARGB colors presented as 32-bit integer values.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_bytes(argb_pixels : List[int], start_index : int, length : int) -> List[int]:
        '''Converts ARGB to CMYK.
        
        :param argb_pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :returns: The CMYK colors presented as a byte array.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyka_bytes(argb_pixels : List[int], start_index : int, length : int) -> List[int]:
        '''Converts ARGB to CMYKA (with transparency).
        
        :param argb_pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :returns: The CMYK colors presented as a byte array.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_color(pixel : aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_colors(pixels : List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb_colors(cmyk_pixels : List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb_color(cmyk_pixel : int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb32(cmyk_pixels : List[int]) -> List[int]:
        '''The conversion from CMYK colors to ARGB colors.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :returns: The ARGB colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb_colors_with_def_icc(cmyk_pixels : List[int]) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with default profiles.
        
        :param cmyk_pixels: The CMYK pixels presented as 32-bit integer values.
        :returns: The ARGB colors.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb_colors_with_icc(cmyk_pixels : List[int], cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> List[aspose.imaging.Color]:
        '''The conversion from CMYK colors to ARGB colors using Icc conversion with custom profiles.
        
        :param cmyk_pixels: The CMYK colors presented as 32-bit integer values.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB colors.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb_color_with_def_icc(cmyk_pixel : int) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB Color using Icc conversion with default profiles.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :returns: The ARGB color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_argb_color_with_icc(cmyk_pixel : int, cmyk_icc_stream : io._IOBase, rgb_icc_stream : io._IOBase) -> aspose.imaging.Color:
        '''The conversion from CMYK color to ARGB color using Icc conversion with custom profile.
        
        :param cmyk_pixel: The CMYK color presented as a 32-bit integer value.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :returns: The ARGB color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_array_with_icc(pixels : List[aspose.imaging.Color], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_cmyk_array_with_icc(pixels : List[int], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_psd_cmyk_array_with_icc(pixels : List[int], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with custom profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_icc_bytes(pixels : List[int], start_index : int, length : int, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''Converts RGB to CMYK using custom ICC profiles.
        
        :param pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :param rgb_icc_stream: The RGB profile stream.
        :param cmyk_icc_stream: The CMYK profile stream.
        :returns: The CMYK colors presented as a byte array.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyka_icc_bytes(pixels : List[int], start_index : int, length : int, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[int]:
        '''Converts RGB to CMYKA (with alpha) using custom ICC profiles.
        
        :param pixels: The RGB colors presented as 32-bit integer values.
        :param start_index: The start index of RGB color.
        :param length: The number of RGB pixels to convert.
        :param rgb_icc_stream: The RGB profile stream.
        :param cmyk_icc_stream: The CMYK profile stream.
        :returns: The CMYK colors presented as a byte array.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_array_with_def_icc(pixels : List[aspose.imaging.Color]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_cmyk_array(pixels : List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_psd_cmyk_array(pixels : List[int]) -> List[int]:
        '''The conversion from ARGB colors to CMYK colors using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param pixels: The ARGB colors.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_with_def_icc(pixel : aspose.imaging.Color) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param pixel: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_cmyk(argb : int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_psd_cmyk(argb : int) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with default profiles.
        Uses PSD CMYK format KCMY byte order with inverted channel values.
        
        :param argb: The ARGB color.
        :returns: The CMYK color presented as a 32-bit integer value in KCMY byte order with inverted channel values.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_with_icc(pixel : aspose.imaging.Color, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_cmyk_with_icc(argb : int, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param argb: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK color presented as a 32-bit integer value.'''
        raise NotImplementedError()
    
    @staticmethod
    def argb_32_to_psd_cmyk_with_icc(pixel : int, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> int:
        '''The conversion from ARGB color to CMYK color using Icc conversion with custom profiles.
        
        :param pixel: The ARGB color.
        :param rgb_icc_stream: The stream containing RGB Icc profile.
        :param cmyk_icc_stream: The stream containing CMYK Icc profile.
        :returns: The CMYK colors presented as 32-bit integer values in KCMY byte order with inverted channel values..'''
        raise NotImplementedError()
    

class Color:
    '''The color of the pixel.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def from_argb(argb : int) -> aspose.imaging.Color:
        '''Creates a :py:class:`aspose.imaging.Color` structure from a 32-bit ARGB value.
        
        :param argb: A value specifying the 32-bit ARGB value.
        :returns: The :py:class:`aspose.imaging.Color` structure that this method creates.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def from_argb(alpha : int, red : int, green : int, blue : int) -> aspose.imaging.Color:
        '''Creates a :py:class:`aspose.imaging.Color` structure from the four ARGB component (alpha, red, green, and blue) values. Although this method allows a 32-bit value to be passed for each component, the value of each component is limited to 8 bits.
        
        :param alpha: The alpha component. Valid values are 0 through 255.
        :param red: The red component. Valid values are 0 through 255.
        :param green: The green component. Valid values are 0 through 255.
        :param blue: The blue component. Valid values are 0 through 255.
        :returns: The :py:class:`aspose.imaging.Color` that this method creates.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def from_argb(alpha : int, base_color : aspose.imaging.Color) -> aspose.imaging.Color:
        '''Creates a :py:class:`aspose.imaging.Color` structure from the specified :py:class:`aspose.imaging.Color` structure, but with the new specified alpha value. Although this method allows a 32-bit value to be passed for the alpha value, the value is limited to 8 bits.
        
        :param alpha: The alpha value for the new :py:class:`aspose.imaging.Color`. Valid values are 0 through 255.
        :param base_color: The :py:class:`aspose.imaging.Color` from which to create the new :py:class:`aspose.imaging.Color`.
        :returns: The :py:class:`aspose.imaging.Color` that this method creates.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def from_argb(red : int, green : int, blue : int) -> aspose.imaging.Color:
        '''Creates a :py:class:`aspose.imaging.Color` structure from the specified 8-bit color values (red, green, and blue). The alpha value is implicitly 255 (fully opaque). Although this method allows a 32-bit value to be passed for each color component, the value of each component is limited to 8 bits.
        
        :param red: The red component value for the new :py:class:`aspose.imaging.Color`. Valid values are 0 through 255.
        :param green: The green component value for the new :py:class:`aspose.imaging.Color`. Valid values are 0 through 255.
        :param blue: The blue component value for the new :py:class:`aspose.imaging.Color`. Valid values are 0 through 255.
        :returns: The :py:class:`aspose.imaging.Color` that this method creates.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(pixels : List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`[].'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk(pixel : aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel : aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels : List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`[].'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixels : List[aspose.imaging.Color], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixels: The pixels of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The :py:class:`List[aspose.imaging.CmykColor]`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def to_cmyk_icc(pixel : aspose.imaging.Color, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixel: The pixel of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The :py:class:`List[aspose.imaging.CmykColor]`.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_known_color(color : aspose.imaging.KnownColor) -> aspose.imaging.Color:
        '''Creates a :py:class:`aspose.imaging.Color` structure from the specified predefined color.
        
        :param color: An element of the :py:class:`aspose.imaging.KnownColor` enumeration.
        :returns: The :py:class:`aspose.imaging.Color` that this method creates.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_name(name : str) -> aspose.imaging.Color:
        '''Creates a :py:class:`aspose.imaging.Color` structure from the specified name of a predefined color.
        
        :param name: A string that is the name of a predefined color. Valid names are the same as the names of the elements of the :py:class:`aspose.imaging.KnownColor` enumeration.
        :returns: The :py:class:`aspose.imaging.Color` that this method creates.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_color(pixel : aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_color_with_def_icc(pixel : aspose.imaging.Color) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixel: The pixel of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_colors_with_def_icc(pixels : List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`[].'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_colors_with_icc(pixels : List[aspose.imaging.Color], rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor using icc conversion.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixels: The pixels of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The :py:class:`aspose.imaging.CmykColor`[].'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_color_with_icc(pixel : aspose.imaging.Color, rgb_icc_stream : io._IOBase, cmyk_icc_stream : io._IOBase) -> aspose.imaging.CmykColor:
        '''The conversion from Color to CMYKColor using icc conversion with default profiles.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk_icc`.
        
        :param pixel: The pixel of Color type in RGB format.
        :param rgb_icc_stream: The stream containing icc rgb profile.
        :param cmyk_icc_stream: The stream containing icc cmyk profile.
        :returns: The :py:class:`aspose.imaging.CmykColor`[].'''
        raise NotImplementedError()
    
    def get_brightness(self) -> float:
        '''Gets the hue-saturation-brightness (HSB) brightness value for this :py:class:`aspose.imaging.Color` structure.
        
        :returns: The brightness of this :py:class:`aspose.imaging.Color`. The brightness ranges from 0.0 through 1.0, where 0.0 represents black and 1.0 represents white.'''
        raise NotImplementedError()
    
    def get_hue(self) -> float:
        '''Gets the hue-saturation-brightness (HSB) hue value, in degrees, for this :py:class:`aspose.imaging.Color` structure.
        
        :returns: The hue, in degrees, of this :py:class:`aspose.imaging.Color`. The hue is measured in degrees, ranging from 0.0 through 360.0, in HSB color space.'''
        raise NotImplementedError()
    
    def get_saturation(self) -> float:
        '''Gets the hue-saturation-brightness (HSB) saturation value for this :py:class:`aspose.imaging.Color` structure.
        
        :returns: The saturation of this :py:class:`aspose.imaging.Color`. The saturation ranges from 0.0 through 1.0, where 0.0 is grayscale and 1.0 is the most saturated.'''
        raise NotImplementedError()
    
    def to_argb(self) -> int:
        '''Gets the 32-bit ARGB value of this :py:class:`aspose.imaging.Color` structure.
        
        :returns: The 32-bit ARGB value of this :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    def to_known_color(self) -> aspose.imaging.KnownColor:
        '''Gets the :py:class:`aspose.imaging.KnownColor` value of this :py:class:`aspose.imaging.Color` structure.
        
        :returns: An element of the :py:class:`aspose.imaging.KnownColor` enumeration, if the :py:class:`aspose.imaging.Color` is created from a predefined color by using either the :py:func:`aspose.imaging.Color.from_name` method or the :py:func:`aspose.imaging.Color.from_known_color` method; otherwise, 0.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_cmyk_colors(pixels : List[aspose.imaging.Color]) -> List[aspose.imaging.CmykColor]:
        '''The conversion from Color to CMYKColor.
        This method is deprecated. Please use more effective :py:func:`aspose.imaging.CmykColorHelper.to_cmyk`.
        
        :param pixels: The pixels of Color type in RGB format.
        :returns: The :py:class:`aspose.imaging.CmykColor`[].'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.Color:
        '''Gets an empty :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()

    @property
    def transparent(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def alice_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def antique_white(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def aqua(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def aquamarine(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def azure(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def beige(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def bisque(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def black(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def blanched_almond(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def blue_violet(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def brown(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def burly_wood(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def cadet_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def chartreuse(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def chocolate(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def coral(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def cornflower_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def cornsilk(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def crimson(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def cyan(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_cyan(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_goldenrod(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_khaki(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_magenta(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_olive_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_orange(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_orchid(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_red(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_salmon(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_sea_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_slate_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_slate_gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_turquoise(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dark_violet(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def deep_pink(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def deep_sky_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dim_gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def dodger_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def firebrick(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def floral_white(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def forest_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def fuchsia(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def gainsboro(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def ghost_white(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def gold(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def goldenrod(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def green_yellow(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def honeydew(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def hot_pink(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def indian_red(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def indigo(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def ivory(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def khaki(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def lavender(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def lavender_blush(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def lawn_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def lemon_chiffon(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_coral(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_cyan(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_goldenrod_yellow(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_pink(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_salmon(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_sea_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_sky_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_slate_gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_steel_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def light_yellow(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def lime(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def lime_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def linen(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def magenta(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def maroon(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_aquamarine(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_orchid(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_purple(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_sea_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_slate_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_spring_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_turquoise(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def medium_violet_red(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def midnight_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def mint_cream(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def misty_rose(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def moccasin(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def navajo_white(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def navy(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def old_lace(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def olive(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def olive_drab(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def orange(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def orange_red(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def orchid(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def pale_goldenrod(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def pale_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def pale_turquoise(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def pale_violet_red(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def papaya_whip(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def peach_puff(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def peru(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def pink(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def plum(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def powder_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def purple(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def red(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def rosy_brown(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def royal_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def saddle_brown(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def salmon(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def sandy_brown(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def sea_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def sea_shell(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def sienna(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def silver(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def sky_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def slate_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def slate_gray(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def snow(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def spring_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def steel_blue(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def tan(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def teal(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def thistle(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def tomato(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def turquoise(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def violet(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def wheat(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def white(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def white_smoke(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def yellow(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def yellow_green(self) -> aspose.imaging.Color:
        '''Gets a system-defined color.'''
        raise NotImplementedError()

    @property
    def r(self) -> int:
        '''Gets the red component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def g(self) -> int:
        '''Gets the green component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def b(self) -> int:
        '''Gets the blue component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def a(self) -> int:
        '''Gets the alpha component value of this :py:class:`aspose.imaging.Color` structure.'''
        raise NotImplementedError()
    
    @property
    def is_known_color(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Color` structure is a predefined color. Predefined colors are represented by the elements of the :py:class:`aspose.imaging.KnownColor` enumeration.'''
        raise NotImplementedError()
    
    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Color` structure is uninitialized.'''
        raise NotImplementedError()
    
    @property
    def is_named_color(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Color` structure is a named color or a member of the :py:class:`aspose.imaging.KnownColor` enumeration.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of this :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    

class ColorBlend:
    '''Defines arrays of colors and positions used for interpolating color blending in a multicolor gradient. This class cannot be inherited.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorBlend` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, count : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorBlend` class with the specified number of colors and positions.
        
        :param count: The number of colors and positions in this :py:class:`aspose.imaging.ColorBlend`.'''
        raise NotImplementedError()
    
    @property
    def colors(self) -> List[aspose.imaging.Color]:
        '''Gets an array of colors that represents the colors to use at corresponding positions along a gradient.'''
        raise NotImplementedError()
    
    @colors.setter
    def colors(self, value : List[aspose.imaging.Color]) -> None:
        '''Sets an array of colors that represents the colors to use at corresponding positions along a gradient.'''
        raise NotImplementedError()
    
    @property
    def positions(self) -> List[float]:
        '''Gets the positions along a gradient line.'''
        raise NotImplementedError()
    
    @positions.setter
    def positions(self, value : List[float]) -> None:
        '''Sets the positions along a gradient line.'''
        raise NotImplementedError()
    

class ColorMap:
    '''Defines a map for converting colors. Several methods of the :py:class:`aspose.imaging.ImageAttributes` class adjust image colors by using a color-remap table, which is an array of :py:class:`aspose.imaging.ColorMap` structures. Not inheritable.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def old_color(self) -> aspose.imaging.Color:
        '''Gets the existing :py:class:`aspose.imaging.Color` structure to be converted.'''
        raise NotImplementedError()
    
    @old_color.setter
    def old_color(self, value : aspose.imaging.Color) -> None:
        '''Sets the existing :py:class:`aspose.imaging.Color` structure to be converted.'''
        raise NotImplementedError()
    
    @property
    def new_color(self) -> aspose.imaging.Color:
        '''Gets the new :py:class:`aspose.imaging.Color` structure to which to convert.'''
        raise NotImplementedError()
    
    @new_color.setter
    def new_color(self, value : aspose.imaging.Color) -> None:
        '''Sets the new :py:class:`aspose.imaging.Color` structure to which to convert.'''
        raise NotImplementedError()
    

class ColorMatrix:
    '''Defines a 5 x 5 matrix that contains the coordinates for the RGBA space. Several methods of the :py:class:`aspose.imaging.ImageAttributes` class adjust image colors by using a color matrix. This class cannot be inherited.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorMatrix` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, new_color_matrix : List[List[float]]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorMatrix` class using the elements in the specified matrix ``newColorMatrix``.
        
        :param new_color_matrix: The values of the elements for the new :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    def get(self, row : int, column : int) -> float:
        '''Gets the element at the specified row and column in the :py:class:`aspose.imaging.ColorMatrix`.
        
        :param row: The row number.
        :param column: The column number.
        :returns: The element at the specified row and column.'''
        raise NotImplementedError()
    
    def set(self, row : int, column : int, value : float) -> None:
        '''Sets the element at the specified row and column in the :py:class:`aspose.imaging.ColorMatrix`.
        
        :param row: The row number.
        :param column: The column number.
        :param value: The element at the specified row and column.'''
        raise NotImplementedError()
    
    def get_matrix(self) -> List[List[float]]:
        '''Gets the matrix values.
        
        :returns: The matrix values array.'''
        raise NotImplementedError()
    
    @property
    def matrix00(self) -> float:
        '''Gets the element at the 0 (zero) row and 0 column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix00.setter
    def matrix00(self, value : float) -> None:
        '''Sets the element at the 0 (zero) row and 0 column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix01(self) -> float:
        '''Gets the element at the 0 (zero) row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix01.setter
    def matrix01(self, value : float) -> None:
        '''Sets the element at the 0 (zero) row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix02(self) -> float:
        '''Gets the element at the 0 (zero) row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix02.setter
    def matrix02(self, value : float) -> None:
        '''Sets the element at the 0 (zero) row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix03(self) -> float:
        '''Gets the element at the 0 (zero) row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix03.setter
    def matrix03(self, value : float) -> None:
        '''Sets the element at the 0 (zero) row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix04(self) -> float:
        '''Gets the element at the 0 (zero) row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix04.setter
    def matrix04(self, value : float) -> None:
        '''Sets the element at the 0 (zero) row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix10(self) -> float:
        '''Gets the element at the first row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix10.setter
    def matrix10(self, value : float) -> None:
        '''Sets the element at the first row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix11(self) -> float:
        '''Gets the element at the first row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix11.setter
    def matrix11(self, value : float) -> None:
        '''Sets the element at the first row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix12(self) -> float:
        '''Gets the element at the first row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix12.setter
    def matrix12(self, value : float) -> None:
        '''Sets the element at the first row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix13(self) -> float:
        '''Gets the element at the first row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix13.setter
    def matrix13(self, value : float) -> None:
        '''Sets the element at the first row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix14(self) -> float:
        '''Gets the element at the first row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix14.setter
    def matrix14(self, value : float) -> None:
        '''Sets the element at the first row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix20(self) -> float:
        '''Gets the element at the second row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix20.setter
    def matrix20(self, value : float) -> None:
        '''Sets the element at the second row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix21(self) -> float:
        '''Gets the element at the second row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix21.setter
    def matrix21(self, value : float) -> None:
        '''Sets the element at the second row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix22(self) -> float:
        '''Gets the element at the second row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix22.setter
    def matrix22(self, value : float) -> None:
        '''Sets the element at the second row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix23(self) -> float:
        '''Gets the element at the second row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix23.setter
    def matrix23(self, value : float) -> None:
        '''Sets the element at the second row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix24(self) -> float:
        '''Gets the element at the second row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix24.setter
    def matrix24(self, value : float) -> None:
        '''Sets the element at the second row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix30(self) -> float:
        '''Gets the element at the third row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix30.setter
    def matrix30(self, value : float) -> None:
        '''Sets the element at the third row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix31(self) -> float:
        '''Gets the element at the third row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix31.setter
    def matrix31(self, value : float) -> None:
        '''Sets the element at the third row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix32(self) -> float:
        '''Gets the element at the third row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix32.setter
    def matrix32(self, value : float) -> None:
        '''Sets the element at the third row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix33(self) -> float:
        '''Gets the element at the third row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix33.setter
    def matrix33(self, value : float) -> None:
        '''Sets the element at the third row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix34(self) -> float:
        '''Gets the element at the third row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix34.setter
    def matrix34(self, value : float) -> None:
        '''Sets the element at the third row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix40(self) -> float:
        '''Gets the element at the fourth row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix40.setter
    def matrix40(self, value : float) -> None:
        '''Sets the element at the fourth row and 0 (zero) column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix41(self) -> float:
        '''Gets the element at the fourth row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix41.setter
    def matrix41(self, value : float) -> None:
        '''Sets the element at the fourth row and first column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix42(self) -> float:
        '''Gets the element at the fourth row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix42.setter
    def matrix42(self, value : float) -> None:
        '''Sets the element at the fourth row and second column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix43(self) -> float:
        '''Gets the element at the fourth row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix43.setter
    def matrix43(self, value : float) -> None:
        '''Sets the element at the fourth row and third column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def matrix44(self) -> float:
        '''Gets the element at the fourth row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @matrix44.setter
    def matrix44(self, value : float) -> None:
        '''Sets the element at the fourth row and fourth column of this :py:class:`aspose.imaging.ColorMatrix`.'''
        raise NotImplementedError()
    
    @property
    def MATRIX_DIMENSION_ELEMENTS_COUNT(self) -> int:
        '''The number of elements in matrix dimension.'''
        raise NotImplementedError()

    @property
    def MATRIX_DIMENSIONS_COUNT(self) -> int:
        '''The number of matrix dimensions.'''
        raise NotImplementedError()

    @property
    def MATRIX_TOTAL_ELEMENTS_COUNT(self) -> int:
        '''The total number of elements in the matrix.'''
        raise NotImplementedError()


class ColorPalette(IColorPalette):
    '''Defines an array of colors that make up a color palette. The colors are 32-bit ARGB colors. Not inheritable.'''
    
    @overload
    def __init__(self, argb_32_entries : List[int], is_compact_palette : bool) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, argb_32_entries : List[int]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class and IsCompactPalette is false.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, entries : List[aspose.imaging.Color], is_compact_palette : bool) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class.
        
        :param entries: The color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, entries : List[aspose.imaging.Color]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class and IsCompactPalette is false.
        
        :param entries: The color palette entries.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def copy_palette(color_palette : aspose.imaging.IColorPalette, use_compact_palette : bool) -> aspose.imaging.ColorPalette:
        '''Copies the palette.
        
        :param color_palette: The color palette.
        :param use_compact_palette: Indicating whether compact palette.
        :returns: The newly created and copied palette or null if null palette passed.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def copy_palette(color_palette : aspose.imaging.IColorPalette) -> aspose.imaging.ColorPalette:
        '''Copies the palette.
        
        :param color_palette: The color palette.
        :returns: The newly created and copied palette or null if null palette passed.'''
        raise NotImplementedError()
    
    @overload
    def get_nearest_color_index(self, argb_32_color : int) -> int:
        '''Gets the index of the nearest color.
        
        :param argb_32_color: The 32-bit ARGB color.
        :returns: The index of the nearest color.'''
        raise NotImplementedError()
    
    @overload
    def get_nearest_color_index(self, color : aspose.imaging.Color) -> int:
        '''Gets the index of the nearest color.
        
        :param color: The color.
        :returns: The index of the nearest color.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_argb_compact(argb_32_entries : List[int], is_compact_palette : bool) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_argb(argb_32_entries : List[int]) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class and IsCompactPalette is false.
        
        :param argb_32_entries: The 32-bit ARGB color palette entries.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_colors_compact(entries : List[aspose.imaging.Color], is_compact_palette : bool) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class.
        
        :param entries: The color palette entries.
        :param is_compact_palette: Indicating whether compact it palette.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_colors(entries : List[aspose.imaging.Color]) -> aspose.imaging.ColorPalette:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ColorPalette` class and IsCompactPalette is false.
        
        :param entries: The color palette entries.'''
        raise NotImplementedError()
    
    def get_nearest_argb_index(self, argb_32_color : int) -> int:
        '''Gets the index of the nearest color.
        
        :param argb_32_color: The 32-bit ARGB color.
        :returns: The index of the nearest color.'''
        raise NotImplementedError()
    
    def get_argb_32_color(self, index : int) -> int:
        '''Gets the 32-bit ARGB palette color by index.
        
        :param index: The 32-bit ARGB palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        raise NotImplementedError()
    
    def get_color(self, index : int) -> aspose.imaging.Color:
        '''Gets the palette color by index.
        
        :param index: The palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        raise NotImplementedError()
    
    @property
    def entries_count(self) -> int:
        '''Gets the entries count.'''
        raise NotImplementedError()
    
    @property
    def argb_32_entries(self) -> List[int]:
        '''Gets an array of 32-bit ARGB structures.'''
        raise NotImplementedError()
    
    @property
    def entries(self) -> List[aspose.imaging.Color]:
        '''Gets an array of :py:class:`aspose.imaging.Color` structures.'''
        raise NotImplementedError()
    
    @property
    def is_compact_palette(self) -> bool:
        '''Gets a value indicating whether compact palette is used.'''
        raise NotImplementedError()
    

class ColorPaletteHelper:
    '''Helper class for color palettes manipulation.'''
    
    @overload
    @staticmethod
    def get_close_image_palette(image : aspose.imaging.RasterImage, entries_count : int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_close_image_palette(image : aspose.imaging.RasterImage, entries_count : int, palette_mining_method : aspose.imaging.PaletteMiningMethod) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. Palette is about to be optimized for better indexed image quality or taken "AS IS" when PaletteMiningMethod.UseCurrentPalette is used.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :param palette_mining_method: The palette mining method.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_close_image_palette(image : aspose.imaging.RasterImage, dest_bounds : aspose.imaging.Rectangle, entries_count : int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_close_image_palette(image : aspose.imaging.RasterImage, dest_bounds : aspose.imaging.Rectangle, entries_count : int, use_image_palette : bool) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :param use_image_palette: If set, it will use its own image palette if available
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_close_image_palette(image : aspose.imaging.RasterImage, dest_bounds : aspose.imaging.Rectangle, entries_count : int, use_image_palette : bool, alpha_blend_in_color : aspose.imaging.Color) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :param use_image_palette: If set, it will use its own image palette if available
        :param alpha_blend_in_color: The color that should be used as a background color for semi-transparent alpha replacement.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_close_image_palette(image : aspose.imaging.RasterImage, dest_bounds : aspose.imaging.Rectangle, entries_count : int, use_image_palette : bool, alpha_blend_in_color : aspose.imaging.Color, keep_transparency : bool) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :param use_image_palette: If set, it will use its own image palette if available
        :param alpha_blend_in_color: The color that should be used as a background color for semi-transparent alpha replacement.
        :param keep_transparency: If set, it will consider alpha channel bits of the image colors.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_monochrome() -> aspose.imaging.IColorPalette:
        '''Creates a monochrome color palette containing 2 colors only.
        
        :returns: Color palette for monochrome images.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_4_bit() -> aspose.imaging.IColorPalette:
        '''Creates the 4 bit color palette.
        
        :returns: The 4 bit color palette.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_4_bit_grayscale(min_is_white : bool) -> aspose.imaging.IColorPalette:
        '''Creates the 4 bit grayscale palette.
        
        :param min_is_white: if set to ``true`` the palette starts with white color, otherwise it starts with black color.
        :returns: The 4 bit grayscale palette.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_8_bit() -> aspose.imaging.IColorPalette:
        '''Creates the 8 bit color palette.
        
        :returns: The 8 bit color palette.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_8_bit_grayscale(min_is_white : bool) -> aspose.imaging.IColorPalette:
        '''Creates the 8 bit grayscale palette.
        
        :param min_is_white: if set to ``true`` the palette starts with white color, otherwise it starts with black color.
        :returns: The 8 bit grayscale palette.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_close_transparent_image_palette(image : aspose.imaging.RasterImage, entries_count : int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_close_image_palette_by_method(image : aspose.imaging.RasterImage, entries_count : int, palette_mining_method : aspose.imaging.PaletteMiningMethod) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. Palette is about to be optimized for better indexed image quality or taken "AS IS" when PaletteMiningMethod.UseCurrentPalette is used.
        
        :param image: The raster image.
        :param entries_count: The desired entries count.
        :param palette_mining_method: The palette mining method.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_close_image_palette_by_rect(image : aspose.imaging.RasterImage, dest_bounds : aspose.imaging.Rectangle, entries_count : int) -> aspose.imaging.IColorPalette:
        '''Gets color palette from raster image (palletizes image) in case the image does not have one. In case palette exists it will be used instead performing calculations.
        
        :param image: The raster image.
        :param dest_bounds: The destination image bounds.
        :param entries_count: The desired entries count.
        :returns: The color palette which starts with the most frequent colors from the ``image`` and contains ``entriesCount`` entries.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_uniform_color_palette(image : aspose.imaging.RasterImage) -> aspose.imaging.ColorPalette:
        '''Get uniform 256 color palette.
        
        :param image: The image.
        :returns: The :py:class:`aspose.imaging.ColorPalette`.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_downscale_palette(image : aspose.imaging.RasterImage) -> aspose.imaging.ColorPalette:
        '''Get 256 color palette, composed from upper bits of initial image color values.
        
        :param image: The image.
        :returns: The :py:class:`aspose.imaging.ColorPalette`.'''
        raise NotImplementedError()
    
    @staticmethod
    def has_transparent_colors(palette : aspose.imaging.IColorPalette) -> bool:
        '''Determines whether the specified palette has transparent colors.
        
        :param palette: The palette.
        :returns: ``true`` if the specified palette has transparent colors; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_grayscale(bits : int) -> aspose.imaging.IColorPalette:
        '''Gets the grayscale palette of specified bit count. Allowed bit values are 1, 2, 4, 8.
        
        :param bits: The bit count.
        :returns: Grayscale palette.'''
        raise NotImplementedError()
    

class ColorTranslator:
    '''Translates colors to and from GDI+ Color structures. This class cannot be inherited.'''
    
    @staticmethod
    def from_html(html_color : str) -> aspose.imaging.Color:
        '''Takes color from the HTML color.
        
        :param html_color: HTML color.
        :returns: The color.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_ole(ole_color : int) -> aspose.imaging.Color:
        '''Takes color from the OLE color.
        
        :param ole_color: OLE color.
        :returns: The color.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_win32(win_32_color : int) -> aspose.imaging.Color:
        '''Takes color from the HTML color.
        
        :param win_32_color: Win32 color.
        :returns: The color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_html(c : aspose.imaging.Color) -> str:
        '''Creates HTML color  from the color.
        
        :param c: The color class.
        :returns: The html string color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_ole(c : aspose.imaging.Color) -> int:
        '''Translates OLE color to color.
        
        :param c: The color.
        :returns: The OLE color.'''
        raise NotImplementedError()
    
    @staticmethod
    def to_win32(c : aspose.imaging.Color) -> int:
        '''Translates the color to win32 color.
        
        :param c: The color.
        :returns: The win32 color.'''
        raise NotImplementedError()
    

class CustomLineCap:
    '''Encapsulates a custom user-defined line cap.'''
    
    @overload
    def __init__(self, fill_path : aspose.imaging.GraphicsPath, stroke_path : aspose.imaging.GraphicsPath) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.CustomLineCap` class with the specified outline and fill.
        
        :param fill_path: A :py:class:`aspose.imaging.GraphicsPath` object that defines the fill for the custom cap.
        :param stroke_path: A :py:class:`aspose.imaging.GraphicsPath` object that defines the outline of the custom cap.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, fill_path : aspose.imaging.GraphicsPath, stroke_path : aspose.imaging.GraphicsPath, base_cap : aspose.imaging.LineCap) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.CustomLineCap` class from the specified existing :py:class:`aspose.imaging.LineCap` enumeration with the specified outline and fill.
        
        :param fill_path: A :py:class:`aspose.imaging.GraphicsPath` object that defines the fill for the custom cap.
        :param stroke_path: A :py:class:`aspose.imaging.GraphicsPath` object that defines the outline of the custom cap.
        :param base_cap: The line cap from which to create the custom cap.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, fill_path : aspose.imaging.GraphicsPath, stroke_path : aspose.imaging.GraphicsPath, base_cap : aspose.imaging.LineCap, base_inset : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.CustomLineCap` class from the specified existing :py:class:`aspose.imaging.LineCap` enumeration with the specified outline, fill, and inset.
        
        :param fill_path: A :py:class:`aspose.imaging.GraphicsPath` object that defines the fill for the custom cap.
        :param stroke_path: A :py:class:`aspose.imaging.GraphicsPath` object that defines the outline of the custom cap.
        :param base_cap: The line cap from which to create the custom cap.
        :param base_inset: The distance between the cap and the line.'''
        raise NotImplementedError()
    
    def set_stroke_caps(self, start_cap : aspose.imaging.LineCap, end_cap : aspose.imaging.LineCap) -> None:
        '''Sets the caps used to start and end lines that make up this custom cap.
        
        :param start_cap: The :py:class:`aspose.imaging.LineCap` enumeration used at the beginning of a line within this cap.
        :param end_cap: The :py:class:`aspose.imaging.LineCap` enumeration used at the end of a line within this cap.'''
        raise NotImplementedError()
    
    def get_stroke_caps(self, start_cap : List[aspose.imaging.LineCap], end_cap : List[aspose.imaging.LineCap]) -> None:
        '''Gets the caps used to start and end lines that make up this custom cap.
        
        :param start_cap: The :py:class:`aspose.imaging.LineCap` enumeration used at the beginning of a line within this cap.
        :param end_cap: The :py:class:`aspose.imaging.LineCap` enumeration used at the end of a line within this cap.'''
        raise NotImplementedError()
    
    @property
    def fill_path(self) -> aspose.imaging.GraphicsPath:
        '''Gets the object that defines the fill for the custom cap.'''
        raise NotImplementedError()
    
    @fill_path.setter
    def fill_path(self, value : aspose.imaging.GraphicsPath) -> None:
        '''Sets the object that defines the fill for the custom cap.'''
        raise NotImplementedError()
    
    @property
    def stroke_path(self) -> aspose.imaging.GraphicsPath:
        '''Gets the object that defines the outline of the custom cap.'''
        raise NotImplementedError()
    
    @stroke_path.setter
    def stroke_path(self, value : aspose.imaging.GraphicsPath) -> None:
        '''Sets the object that defines the outline of the custom cap.'''
        raise NotImplementedError()
    
    @property
    def stroke_join(self) -> aspose.imaging.LineJoin:
        '''Gets the :py:class:`aspose.imaging.LineJoin` enumeration that determines how lines that compose this :py:class:`aspose.imaging.CustomLineCap` object are joined.'''
        raise NotImplementedError()
    
    @stroke_join.setter
    def stroke_join(self, value : aspose.imaging.LineJoin) -> None:
        '''Sets the :py:class:`aspose.imaging.LineJoin` enumeration that determines how lines that compose this :py:class:`aspose.imaging.CustomLineCap` object are joined.'''
        raise NotImplementedError()
    
    @property
    def base_cap(self) -> aspose.imaging.LineCap:
        '''Gets the :py:class:`aspose.imaging.LineCap` enumeration on which this :py:class:`aspose.imaging.CustomLineCap` is based.'''
        raise NotImplementedError()
    
    @base_cap.setter
    def base_cap(self, value : aspose.imaging.LineCap) -> None:
        '''Sets the :py:class:`aspose.imaging.LineCap` enumeration on which this :py:class:`aspose.imaging.CustomLineCap` is based.'''
        raise NotImplementedError()
    
    @property
    def base_inset(self) -> float:
        '''Gets the distance between the cap and the line.'''
        raise NotImplementedError()
    
    @base_inset.setter
    def base_inset(self, value : float) -> None:
        '''Sets the distance between the cap and the line.'''
        raise NotImplementedError()
    
    @property
    def width_scale(self) -> float:
        '''Gets the amount by which to scale this :py:class:`aspose.imaging.CustomLineCap` Class object with respect to the width of the :py:class:`Any` object.'''
        raise NotImplementedError()
    
    @width_scale.setter
    def width_scale(self, value : float) -> None:
        '''Sets the amount by which to scale this :py:class:`aspose.imaging.CustomLineCap` Class object with respect to the width of the :py:class:`Any` object.'''
        raise NotImplementedError()
    

class DataStreamSupporter(DisposableObject):
    '''The data stream container.'''
    
    @overload
    def save(self) -> None:
        '''Saves the object\'s data to the current :py:class:`aspose.imaging.DataStreamSupporter`.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data and ensures no additional data loading will be performed from the underlying :py:attr:`aspose.imaging.DataStreamSupporter.data_stream_container`.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether object\'s data is cached currently and no data reading is required.'''
        raise NotImplementedError()
    

class DisposableObject:
    '''Represents disposable object.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    

class EmbeddedImage(DisposableObject):
    '''The embedded image class'''
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def image(self) -> aspose.imaging.Image:
        '''Gets the image.'''
        raise NotImplementedError()
    

class Figure(ObjectWithBounds):
    '''The figure. A container for shapes.'''
    
    def __init__(self) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Figure` instance.
        A constructor required for a JSON deserialization.'''
        raise NotImplementedError()
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix, pen : aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object\'s bounds size.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    def transform(self, transform : aspose.imaging.Matrix) -> None:
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        raise NotImplementedError()
    
    def add_shape(self, shape : aspose.imaging.Shape) -> None:
        '''Adds a shape to the figure.
        
        :param shape: The shape to add.'''
        raise NotImplementedError()
    
    def add_shapes(self, shapes : List[aspose.imaging.Shape]) -> None:
        '''Adds a range of shapes to the figure.
        
        :param shapes: The shapes to add.'''
        raise NotImplementedError()
    
    def remove_shape(self, shape : aspose.imaging.Shape) -> None:
        '''Removes a shape from the figure.
        
        :param shape: The shape to remove.'''
        raise NotImplementedError()
    
    def remove_shapes(self, shapes : List[aspose.imaging.Shape]) -> None:
        '''Removes a range of shapes from the figure.
        
        :param shapes: The shapes range to remove.'''
        raise NotImplementedError()
    
    def reverse(self) -> None:
        '''Reverses this figure shapes order and shapes point order.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.'''
        raise NotImplementedError()
    
    @property
    def shapes(self) -> List[aspose.imaging.Shape]:
        '''Gets the shapes.'''
        raise NotImplementedError()
    
    @property
    def is_closed(self) -> bool:
        '''Gets a value indicating whether this figure is closed. A closed figure will make a difference only in case where
        the first and the last figure\'s shapes are continuous shapes. In such case the first point of the first shape will be
        connected by a straight line from the last point of the last shape.'''
        raise NotImplementedError()
    
    @is_closed.setter
    def is_closed(self, value : bool) -> None:
        '''Sets a value indicating whether this figure is closed. A closed figure will make a difference only in case where
        the first and the last figure\'s shapes are continuous shapes. In such case the first point of the first shape will be
        connected by a straight line from the last point of the last shape.'''
        raise NotImplementedError()
    
    @property
    def segments(self) -> List[aspose.imaging.ShapeSegment]:
        '''Gets the whole figure segments.'''
        raise NotImplementedError()
    

class FileStreamContainer(StreamContainer):
    '''Helper for file stream processing.'''
    
    @overload
    def write(self, bytes : List[int]) -> None:
        '''Writes all of the specified bytes to the stream.
        
        :param bytes: The bytes to write.'''
        raise NotImplementedError()
    
    @overload
    def write(self, buffer : List[int], offset : int, count : int) -> None:
        '''Writes a sequence of bytes to the current stream and advances the current position within this stream by the number of bytes written.
        
        :param buffer: An array of bytes. This method copies ``count`` bytes from ``buffer`` to the current stream.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin copying bytes to the current stream.
        :param count: The number of bytes to be written to the current stream.'''
        raise NotImplementedError()
    
    @overload
    def read(self, bytes : List[int]) -> int:
        '''Reads bytes to fill the specified bytes buffer.
        
        :param bytes: The bytes to fill.
        :returns: The number of bytes read. This value can be less than the number of bytes in the buffer if there is not enough bytes in the stream.'''
        raise NotImplementedError()
    
    @overload
    def read(self, buffer : List[int], offset : int, count : int) -> int:
        '''Reads a sequence of bytes from the current stream and advances the position within the stream by the number of bytes read.
        
        :param buffer: An array of bytes. When this method returns, the buffer contains the specified byte array with the values between ``offset`` and (``offset`` + ``count`` - 1) replaced by the bytes read from the current source.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin storing the data read from the current stream.
        :param count: The maximum number of bytes to be read from the current stream.
        :returns: The total number of bytes read into the buffer. This can be less than the number of bytes requested if that many bytes are not currently available, or zero (0) if the end of the stream has been reached.'''
        raise NotImplementedError()
    
    @overload
    def to_bytes(self) -> List[int]:
        '''Converts the stream data to the :py:class:`int` array.
        
        :returns: The stream data converted to the :py:class:`int` array.'''
        raise NotImplementedError()
    
    @overload
    def to_bytes(self, position : int, bytes_count : int) -> List[int]:
        '''Converts the stream data to the :py:class:`int` array.
        
        :param position: The position to start reading bytes from.
        :param bytes_count: The bytes count to read.
        :returns: The stream data converted to the :py:class:`int` array.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase, buffer_size : int) -> None:
        '''Saves (copies) all the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, buffer_size : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @overload
    def write_to(self, stream_container : aspose.imaging.StreamContainer) -> None:
        '''Copies the contained data to another :py:class:`aspose.imaging.StreamContainer`.
        
        :param stream_container: The stream container to copy to.'''
        raise NotImplementedError()
    
    @overload
    def write_to(self, stream_container : aspose.imaging.StreamContainer, length : int) -> None:
        '''Copies the contained data to another :py:class:`aspose.imaging.StreamContainer`.
        
        :param stream_container: The stream container to copy to.
        :param length: The bytes count to write.'''
        raise NotImplementedError()
    
    def flush(self) -> None:
        '''Clears all buffers for this stream and causes any buffered data to be written to the underlying device.'''
        raise NotImplementedError()
    
    def write_byte(self, value : int) -> None:
        '''Writes a byte to the current position in the stream and advances the position within the stream by one byte.
        
        :param value: The byte to write to the stream.'''
        raise NotImplementedError()
    
    def read_byte(self) -> int:
        '''Reads a byte from the stream and advances the position within the stream by one byte, or returns -1 if at the end of the stream.
        
        :returns: The unsigned byte cast to an Int32, or -1 if at the end of the stream.'''
        raise NotImplementedError()
    
    def seek(self, offset : int, origin : aspose.imaging.SeekOrigin) -> int:
        '''Sets the position within the current stream.
        
        :param offset: A byte offset relative to the ``origin`` parameter. This value represents offset from the starting stream position passed in the StreamContainer constructor.
        :param origin: A value of type :py:class:`System.IO.SeekOrigin` indicating the reference point used to obtain the new position.
        :returns: The new position within the current stream.'''
        raise NotImplementedError()
    
    def seek_begin(self) -> None:
        '''Sets the stream position to the beginning of the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    def save_to_stream(self, destination_stream : io._IOBase) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.'''
        raise NotImplementedError()
    
    def save_to_stream_with_buf_size(self, destination_stream : io._IOBase, buffer_size : int) -> None:
        '''Saves (copies) all the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        raise NotImplementedError()
    
    def save_to_stream_with_buf_size_and_len(self, destination_stream : io._IOBase, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    def save_with_buf_size(self, file_path : str, buffer_size : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.'''
        raise NotImplementedError()
    
    def save_with_buf_size_and_len(self, file_path : str, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_file_stream(file_location : str, is_temporal : bool) -> aspose.imaging.FileStreamContainer:
        '''Creates a new file stream.
        
        :param file_location: The file location.
        :param is_temporal: If set to ``true`` the file stream container is temporal.
        :returns: The file stream container.'''
        raise NotImplementedError()
    
    @staticmethod
    def open_file_stream(file_location : str) -> aspose.imaging.FileStreamContainer:
        '''Opens an existing file stream. If file stream does not exist the appropriate exception is thrown.
        
        :param file_location: The file location.
        :returns: The file stream container.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def sync_root(self) -> Any:
        '''Gets an object that can be used to synchronize access to the synchronized resource.'''
        raise NotImplementedError()
    
    @property
    def position(self) -> int:
        '''Gets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : int) -> None:
        '''Sets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @property
    def stream(self) -> io._IOBase:
        '''Gets the data stream.'''
        raise NotImplementedError()
    
    @property
    def is_stream_disposed_on_close(self) -> bool:
        '''Gets a value indicating whether this stream is disposed on close.'''
        raise NotImplementedError()
    
    @property
    def length(self) -> int:
        '''Gets the stream length in bytes. This value is less than the :py:attr:`io._IOBase.Length` by the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @length.setter
    def length(self, value : int) -> None:
        '''Sets the stream length in bytes. This value is less than the :py:attr:`io._IOBase.Length` by the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @property
    def can_read(self) -> bool:
        '''Gets a value indicating whether stream supports reading.'''
        raise NotImplementedError()
    
    @property
    def can_seek(self) -> bool:
        '''Gets a value indicating whether stream supports seeking.'''
        raise NotImplementedError()
    
    @property
    def can_write(self) -> bool:
        '''Gets a value indicating whether stream supports writing.'''
        raise NotImplementedError()
    
    @property
    def READ_WRITE_BYTES_COUNT(self) -> int:
        '''Specifies read and write bytes count when reading sequentially.'''
        raise NotImplementedError()

    @property
    def is_temporal(self) -> bool:
        '''Gets a value indicating whether stream is temporal.'''
        raise NotImplementedError()
    
    @is_temporal.setter
    def is_temporal(self, value : bool) -> None:
        '''Sets a value indicating whether stream is temporal.'''
        raise NotImplementedError()
    
    @property
    def is_created(self) -> bool:
        '''Gets a value indicating whether stream was created explicitly.'''
        raise NotImplementedError()
    
    @property
    def file_path(self) -> str:
        '''Gets the file path.'''
        raise NotImplementedError()
    

class Font:
    '''Defines a particular format for text, including font face, size, and style attributes. This class cannot be inherited.'''
    
    @overload
    def __init__(self, prototype : aspose.imaging.Font, new_style : aspose.imaging.FontStyle) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Font` that uses the specified existing :py:class:`aspose.imaging.Font` and :py:class:`aspose.imaging.FontStyle` enumeration.
        
        :param prototype: The existing :py:class:`aspose.imaging.Font` from which to create the new :py:class:`aspose.imaging.Font`.
        :param new_style: The :py:class:`aspose.imaging.FontStyle` to apply to the new :py:class:`aspose.imaging.Font`. Multiple values of the :py:class:`aspose.imaging.FontStyle` enumeration can be combined with the OR operator.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, font_name : str, em_size : float) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size. The character set is set to :py:attr:`aspose.imaging.CharacterSet.DEFAULT`, the graphics unit to :py:attr:`aspose.imaging.GraphicsUnit.POINT`, the font style to :py:attr:`aspose.imaging.FontStyle.REGULAR`.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size, in points, of the new font.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, font_name : str, em_size : float, style : aspose.imaging.FontStyle) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size and style. The character set is set to :py:attr:`aspose.imaging.CharacterSet.DEFAULT`, the graphics unit to :py:attr:`aspose.imaging.GraphicsUnit.POINT`.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size, in points, of the new font.
        :param style: The :py:class:`aspose.imaging.FontStyle` of the new font.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, font_name : str, em_size : float, unit : aspose.imaging.GraphicsUnit) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size and unit. The character set is set to :py:attr:`aspose.imaging.CharacterSet.DEFAULT`, the style is set to :py:attr:`aspose.imaging.FontStyle.REGULAR`.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param unit: The :py:class:`aspose.imaging.GraphicsUnit` of the new font.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, font_name : str, em_size : float, style : aspose.imaging.FontStyle, unit : aspose.imaging.GraphicsUnit, character_set : aspose.imaging.CharacterSet) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size, style, unit, and character set.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param style: The :py:class:`aspose.imaging.FontStyle` of the new font.
        :param unit: The :py:class:`aspose.imaging.GraphicsUnit` of the new font.
        :param character_set: A character set to use for this font.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, font_name : str, em_size : float, style : aspose.imaging.FontStyle, unit : aspose.imaging.GraphicsUnit) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size, style, and unit.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param style: The :py:class:`aspose.imaging.FontStyle` of the new font.
        :param unit: The :py:class:`aspose.imaging.GraphicsUnit` of the new font.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_prototype(prototype : aspose.imaging.Font, new_style : aspose.imaging.FontStyle) -> aspose.imaging.Font:
        '''Initializes a new :py:class:`aspose.imaging.Font` that uses the specified existing :py:class:`aspose.imaging.Font` and :py:class:`aspose.imaging.FontStyle` enumeration.
        
        :param prototype: The existing :py:class:`aspose.imaging.Font` from which to create the new :py:class:`aspose.imaging.Font`.
        :param new_style: The :py:class:`aspose.imaging.FontStyle` to apply to the new :py:class:`aspose.imaging.Font`. Multiple values of the :py:class:`aspose.imaging.FontStyle` enumeration can be combined with the OR operator.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_size(font_name : str, em_size : float) -> aspose.imaging.Font:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size. The character set is set to :py:attr:`aspose.imaging.CharacterSet.DEFAULT`, the graphics unit to :py:attr:`aspose.imaging.GraphicsUnit.POINT`, the font style to :py:attr:`aspose.imaging.FontStyle.REGULAR`.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size, in points, of the new font.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_size_style(font_name : str, em_size : float, style : aspose.imaging.FontStyle) -> aspose.imaging.Font:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size and style. The character set is set to :py:attr:`aspose.imaging.CharacterSet.DEFAULT`, the graphics unit to :py:attr:`aspose.imaging.GraphicsUnit.POINT`.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size, in points, of the new font.
        :param style: The :py:class:`aspose.imaging.FontStyle` of the new font.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_size_unit(font_name : str, em_size : float, unit : aspose.imaging.GraphicsUnit) -> aspose.imaging.Font:
        '''Initializes a new :py:class:`aspose.imaging.Font` using a specified size and unit. The character set is set to :py:attr:`aspose.imaging.CharacterSet.DEFAULT`, the style is set to :py:attr:`aspose.imaging.FontStyle.REGULAR`.
        
        :param font_name: A string representation of the :py:class:`aspose.imaging.Font` name.
        :param em_size: The em-size of the new font in the units specified by the ``unit`` parameter.
        :param unit: The :py:class:`aspose.imaging.GraphicsUnit` of the new font.'''
        raise NotImplementedError()
    
    def deep_clone(self) -> aspose.imaging.Font:
        '''Creates an exact deep copy of this :py:class:`aspose.imaging.Font`.
        
        :returns: The :py:class:`aspose.imaging.Font` this method creates.'''
        raise NotImplementedError()
    
    @property
    def bold(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Font` is bold.'''
        raise NotImplementedError()
    
    @property
    def character_set(self) -> aspose.imaging.CharacterSet:
        '''Gets a byte value that specifies the character set that this :py:class:`aspose.imaging.Font` uses.'''
        raise NotImplementedError()
    
    @property
    def italic(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Font` is italic.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the face name of this :py:class:`aspose.imaging.Font`.'''
        raise NotImplementedError()
    
    @property
    def strikeout(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Font` specifies a horizontal line through the font.'''
        raise NotImplementedError()
    
    @property
    def underline(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Font` is underlined.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.imaging.FontStyle:
        '''Gets style information for this :py:class:`aspose.imaging.Font`.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> float:
        '''Gets the em-size of this :py:class:`aspose.imaging.Font` measured in the units specified by the :py:attr:`aspose.imaging.Font.unit` property.'''
        raise NotImplementedError()
    
    @property
    def unit(self) -> aspose.imaging.GraphicsUnit:
        '''Gets the unit of measure for this :py:class:`aspose.imaging.Font`.'''
        raise NotImplementedError()
    

class FontSettings:
    '''General imaging vector formats renderer font settings.'''
    
    @staticmethod
    def get_fonts_folders() -> List[str]:
        '''Gets a copy of the array that contains the list of folders where Aspose.Words looks for TrueType fonts.
        
        :returns: A copy of the current font locations.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_default_fonts_folders() -> List[str]:
        '''Gets the default fonts folders.
        
        :returns: Returns system folder'''
        raise NotImplementedError()
    
    @staticmethod
    def set_fonts_folder(font_folder : str) -> None:
        '''This is a shortcut to :py:func:`aspose.imaging.FontSettings.set_fonts_folders` for setting only one font directory.
        There are no checks performed on the fonts folder.
        
        :param font_folder: The font folder.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_fonts_folders(fonts_folders : List[str], recursive : bool) -> None:
        '''Sets the folders where TrueType fonts are loaded from and clears all loaded fonts.
        There are no checks performed on the fonts folders.
        
        :param fonts_folders: The fonts folders.
        :param recursive: if set to ``true`` [recursive].'''
        raise NotImplementedError()
    
    @staticmethod
    def reset() -> None:
        '''Resets the fonts folder and default font name to the system default.'''
        raise NotImplementedError()
    
    @staticmethod
    def update_fonts() -> None:
        '''Updates fonts cache for PSD files that contain text layers. This method guarantees that fonts from folder fontsFolder using
        method FontSettings.SetFontsFolder(fontsFolder) or after reset fonts using FontSettings.Reset() will be taken into consideration when processing PSD files. Please use this method each time when
        FontSettings.SetFontsFolder(fontsFolder) or FontSettings.Reset() called for PSD images. Without calling this Method there is no guarantee that fonts will be updated.'''
        raise NotImplementedError()
    
    @staticmethod
    def set_get_system_alternative_font(value: bool) -> None:
        '''Gets a value indicating whether [get alternative font].'''
    @property
    def get_system_alternative_font(self) -> bool:
        '''Sets a value indicating whether [get alternative font].'''
        raise NotImplementedError()

    @staticmethod
    def set_default_font_name(value: str) -> None:
        '''Gets the default name of the font.'''
    @property
    def default_font_name(self) -> str:
        '''Sets the default name of the font.'''
        raise NotImplementedError()


class Graphics:
    '''Represents the graphics according to the graphics engine used in the current assembly.'''
    
    def __init__(self, source_image : aspose.imaging.Image) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Graphics` class.
        
        :param source_image: The source image.'''
        raise NotImplementedError()
    
    @overload
    def multiply_transform(self, matrix : aspose.imaging.Matrix) -> None:
        '''Multiplies the :py:class:`aspose.imaging.Matrix` that represents the local geometric transform of this :py:class:`aspose.imaging.Graphics` by the specified :py:class:`aspose.imaging.Matrix` by prepending the specified :py:class:`aspose.imaging.Matrix`.
        
        :param matrix: The :py:class:`aspose.imaging.Matrix` by which to multiply the geometric transform.'''
        raise NotImplementedError()
    
    @overload
    def multiply_transform(self, matrix : aspose.imaging.Matrix, order : aspose.imaging.MatrixOrder) -> None:
        '''Multiplies the :py:class:`aspose.imaging.Matrix` that represents the local geometric transform of this :py:class:`aspose.imaging.Graphics` by the specified :py:class:`aspose.imaging.Matrix` in the specified order.
        
        :param matrix: The :py:class:`aspose.imaging.Matrix` by which to multiply the geometric transform.
        :param order: A :py:class:`aspose.imaging.MatrixOrder` that specifies in which order to multiply the two matrices.'''
        raise NotImplementedError()
    
    @overload
    def translate_transform(self, dx : float, dy : float) -> None:
        '''Translates the local geometric transform by the specified dimensions. This method prepends the translation to the transform.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.'''
        raise NotImplementedError()
    
    @overload
    def translate_transform(self, dx : float, dy : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Translates the local geometric transform by the specified dimensions in the specified order.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.
        :param order: The order (prepend or append) in which to apply the translation.'''
        raise NotImplementedError()
    
    @overload
    def scale_transform(self, sx : float, sy : float) -> None:
        '''Scales the local geometric transform by the specified amounts. This method prepends the scaling matrix to the transform.
        
        :param sx: The amount by which to scale the transform in the x-axis direction.
        :param sy: The amount by which to scale the transform in the y-axis direction.'''
        raise NotImplementedError()
    
    @overload
    def scale_transform(self, sx : float, sy : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Scales the local geometric transform by the specified amounts in the specified order.
        
        :param sx: The amount by which to scale the transform in the x-axis direction.
        :param sy: The amount by which to scale the transform in the y-axis direction.
        :param order: A :py:class:`aspose.imaging.MatrixOrder` that specifies whether to append or prepend the scaling matrix.'''
        raise NotImplementedError()
    
    @overload
    def rotate_transform(self, angle : float) -> None:
        '''Rotates the local geometric transform by the specified amount. This method prepends the rotation to the transform.
        
        :param angle: The angle of rotation.'''
        raise NotImplementedError()
    
    @overload
    def rotate_transform(self, angle : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Rotates the local geometric transform by the specified amount in the specified order.
        
        :param angle: The angle of rotation.
        :param order: A :py:class:`aspose.imaging.MatrixOrder` that specifies whether to append or prepend the rotation matrix.'''
        raise NotImplementedError()
    
    @overload
    def draw_line(self, pen : aspose.imaging.Pen, point1 : aspose.imaging.Point, point2 : aspose.imaging.Point) -> None:
        '''Draws a line connecting two :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param point1: :py:class:`aspose.imaging.Point` structure that represents the first point to connect.
        :param point2: :py:class:`aspose.imaging.Point` structure that represents the second point to connect.'''
        raise NotImplementedError()
    
    @overload
    def draw_line(self, pen : aspose.imaging.Pen, point1 : aspose.imaging.PointF, point2 : aspose.imaging.PointF) -> None:
        '''Draws a line connecting two :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param point1: :py:class:`aspose.imaging.PointF` structure that represents the first point to connect.
        :param point2: :py:class:`aspose.imaging.PointF` structure that represents the second point to connect.'''
        raise NotImplementedError()
    
    @overload
    def draw_line(self, pen : aspose.imaging.Pen, x1 : int, y1 : int, x2 : int, y2 : int) -> None:
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        raise NotImplementedError()
    
    @overload
    def draw_line(self, pen : aspose.imaging.Pen, x1 : float, y1 : float, x2 : float, y2 : float) -> None:
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        raise NotImplementedError()
    
    @overload
    def draw_lines(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a series of line segments that connect an array of :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line segments.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the points to connect.'''
        raise NotImplementedError()
    
    @overload
    def draw_lines(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a series of line segments that connect an array of :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line segments.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the points to connect.'''
        raise NotImplementedError()
    
    @overload
    def fill_rectangle(self, brush : aspose.imaging.Brush, rect : aspose.imaging.Rectangle) -> None:
        '''Fills the interior of a rectangle specified by a :py:class:`aspose.imaging.Rectangle` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the rectangle to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_rectangle(self, brush : aspose.imaging.Brush, rect : aspose.imaging.RectangleF) -> None:
        '''Fills the interior of a rectangle specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the rectangle to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_rectangle(self, brush : aspose.imaging.Brush, x : float, y : float, width : float, height : float) -> None:
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_rectangle(self, brush : aspose.imaging.Brush, x : int, y : int, width : int, height : int) -> None:
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_rectangles(self, brush : aspose.imaging.Brush, rects : List[aspose.imaging.Rectangle]) -> None:
        '''Fills the interiors of a series of rectangles specified by :py:class:`aspose.imaging.Rectangle` structures.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rects: Array of :py:class:`aspose.imaging.Rectangle` structures that represent the rectangles to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_rectangles(self, brush : aspose.imaging.Brush, rects : List[aspose.imaging.RectangleF]) -> None:
        '''Fills the interiors of a series of rectangles specified by :py:class:`aspose.imaging.RectangleF` structures.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rects: Array of :py:class:`aspose.imaging.Rectangle` structures that represent the rectangles to fill.'''
        raise NotImplementedError()
    
    @overload
    def draw_rectangle(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF) -> None:
        '''Draws a rectangle specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param rect: A :py:class:`aspose.imaging.RectangleF` structure that represents the rectangle to draw.'''
        raise NotImplementedError()
    
    @overload
    def draw_rectangle(self, pen : aspose.imaging.Pen, rect : aspose.imaging.Rectangle) -> None:
        '''Draws a rectangle specified by a :py:class:`aspose.imaging.Rectangle` structure.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param rect: A :py:class:`aspose.imaging.Rectangle` structure that represents the rectangle to draw.'''
        raise NotImplementedError()
    
    @overload
    def draw_rectangle(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float) -> None:
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: The width of the rectangle to draw.
        :param height: The height of the rectangle to draw.'''
        raise NotImplementedError()
    
    @overload
    def draw_rectangle(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int) -> None:
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: Width of the rectangle to draw.
        :param height: Height of the rectangle to draw.'''
        raise NotImplementedError()
    
    @overload
    def draw_rectangles(self, pen : aspose.imaging.Pen, rects : List[aspose.imaging.RectangleF]) -> None:
        '''Draws a series of rectangles specified by :py:class:`aspose.imaging.RectangleF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the outlines of the rectangles.
        :param rects: Array of :py:class:`aspose.imaging.RectangleF` structures that represent the rectangles to draw.'''
        raise NotImplementedError()
    
    @overload
    def draw_rectangles(self, pen : aspose.imaging.Pen, rects : List[aspose.imaging.Rectangle]) -> None:
        '''Draws a series of rectangles specified by :py:class:`aspose.imaging.Rectangle` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the outlines of the rectangles.
        :param rects: Array of :py:class:`aspose.imaging.Rectangle` structures that represent the rectangles to draw.'''
        raise NotImplementedError()
    
    @overload
    def draw_ellipse(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF) -> None:
        '''Draws an ellipse defined by a bounding :py:class:`aspose.imaging.RectangleF`.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that defines the boundaries of the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def draw_ellipse(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float) -> None:
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def draw_ellipse(self, pen : aspose.imaging.Pen, rect : aspose.imaging.Rectangle) -> None:
        '''Draws an ellipse specified by a bounding :py:class:`aspose.imaging.Rectangle` structure.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that defines the boundaries of the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def draw_ellipse(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int) -> None:
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def draw_polygon(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a polygon defined by an array of :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the polygon.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the vertices of the polygon.'''
        raise NotImplementedError()
    
    @overload
    def draw_polygon(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a polygon defined by an array of :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the polygon.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the vertices of the polygon.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, point : aspose.imaging.PointF) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image`, using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: :py:class:`aspose.imaging.PointF` structure that represents the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, x : float, y : float) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image`, using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect : aspose.imaging.RectangleF) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that specifies the location and size of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle to draw in.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.Rectangle, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.RectangleF, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.Rectangle, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.RectangleF, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The source rectangle.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit to use.
        :param image_attributes: The image attributes to use.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point]) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point], src_rect : aspose.imaging.Rectangle) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point], src_rect : aspose.imaging.Rectangle, src_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point], src_rect : aspose.imaging.Rectangle, src_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF]) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, src_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, src_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, x : float, y : float, width : float, height : float) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, point : aspose.imaging.Point) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image`, using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: :py:class:`aspose.imaging.Point` structure that represents the location of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, x : int, y : int) -> None:
        '''Draws the specified image, using its original physical size, at the location specified by a coordinate pair.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, rect : aspose.imaging.Rectangle) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that specifies the location and size of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image(self, source_image : aspose.imaging.Image, x : int, y : int, width : int, height : int) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image_unscaled(self, source_image : aspose.imaging.Image, point : aspose.imaging.Point) -> None:
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param point: :py:class:`aspose.imaging.Point` structure that specifies the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image_unscaled(self, source_image : aspose.imaging.Image, x : int, y : int) -> None:
        '''Draws the specified image using its original physical size at the location specified by a coordinate pair.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    @overload
    def draw_image_unscaled(self, source_image : aspose.imaging.Image, rect : aspose.imaging.Rectangle) -> None:
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param rect: :py:class:`aspose.imaging.Rectangle` that specifies the upper-left corner of the drawn image. The X and Y properties of the rectangle specify the upper-left corner. The Width and Height properties are ignored.'''
        raise NotImplementedError()
    
    @overload
    def draw_image_unscaled(self, source_image : aspose.imaging.Image, x : int, y : int, width : int, height : int) -> None:
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: The parameter is not used.
        :param height: The parameter is not used.'''
        raise NotImplementedError()
    
    @overload
    def draw_arc(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float, start_angle : float, sweep_angle : float) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    @overload
    def draw_arc(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF, start_angle : float, sweep_angle : float) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    @overload
    def draw_arc(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int, start_angle : int, sweep_angle : int) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    @overload
    def draw_arc(self, pen : aspose.imaging.Pen, rect : aspose.imaging.Rectangle, start_angle : float, sweep_angle : float) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a :py:class:`aspose.imaging.Rectangle` structure.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    @overload
    def draw_pie(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF, start_angle : float, sweep_angle : float) -> None:
        '''Draws a pie shape defined by an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    @overload
    def draw_pie(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float, start_angle : float, sweep_angle : float) -> None:
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    @overload
    def draw_pie(self, pen : aspose.imaging.Pen, rect : aspose.imaging.Rectangle, start_angle : float, sweep_angle : float) -> None:
        '''Draws a pie shape defined by an ellipse specified by a :py:class:`aspose.imaging.Rectangle` structure and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    @overload
    def draw_pie(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int, start_angle : int, sweep_angle : int) -> None:
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures. This method uses a default tension of 0.5.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures using a specified tension.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the points that define the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], offset : int, number_of_segments : int) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures. The drawing begins offset from the beginning of the array.
        This method uses a default tension of 0.5.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], offset : int, number_of_segments : int, tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures using a specified tension. The drawing begins offset from the beginning of the array.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point], tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.Point` structures using a specified tension.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point], offset : int, number_of_segments : int, tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.Point` structures using a specified tension.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_closed_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.PointF` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.'''
        raise NotImplementedError()
    
    @overload
    def draw_closed_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], tension : float) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.PointF` structures using a specified tension. This method uses a default :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_closed_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.Point` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.'''
        raise NotImplementedError()
    
    @overload
    def draw_closed_curve(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point], tension : float) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.Point` structures using a specified tension. This method uses a default :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_bezier(self, pen : aspose.imaging.Pen, x1 : float, y1 : float, x2 : float, y2 : float, x3 : float, y3 : float, x4 : float, y4 : float) -> None:
        '''Draws a Bézier spline defined by four ordered pairs of coordinates that represent points.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param x1: The x-coordinate of the starting point of the curve.
        :param y1: The y-coordinate of the starting point of the curve.
        :param x2: The x-coordinate of the first control point of the curve.
        :param y2: The y-coordinate of the first control point of the curve.
        :param x3: The x-coordinate of the second control point of the curve.
        :param y3: The y-coordinate of the second control point of the curve.
        :param x4: The x-coordinate of the ending point of the curve.
        :param y4: The y-coordinate of the ending point of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_bezier(self, pen : aspose.imaging.Pen, pt1 : aspose.imaging.PointF, pt2 : aspose.imaging.PointF, pt3 : aspose.imaging.PointF, pt4 : aspose.imaging.PointF) -> None:
        '''Draws a Bézier spline defined by four :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param pt1: :py:class:`aspose.imaging.PointF` structure that represents the starting point of the curve.
        :param pt2: :py:class:`aspose.imaging.PointF` structure that represents the first control point for the curve.
        :param pt3: :py:class:`aspose.imaging.PointF` structure that represents the second control point for the curve.
        :param pt4: :py:class:`aspose.imaging.PointF` structure that represents the ending point of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_bezier(self, pen : aspose.imaging.Pen, pt1 : aspose.imaging.Point, pt2 : aspose.imaging.Point, pt3 : aspose.imaging.Point, pt4 : aspose.imaging.Point) -> None:
        '''Draws a Bézier spline defined by four :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` structure that determines the color, width, and style of the curve.
        :param pt1: :py:class:`aspose.imaging.Point` structure that represents the starting point of the curve.
        :param pt2: :py:class:`aspose.imaging.Point` structure that represents the first control point for the curve.
        :param pt3: :py:class:`aspose.imaging.Point` structure that represents the second control point for the curve.
        :param pt4: :py:class:`aspose.imaging.Point` structure that represents the ending point of the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_beziers(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a series of Bézier splines from an array of :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the points that determine the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_beziers(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a series of Bézier splines from an array of :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the points that determine the curve.'''
        raise NotImplementedError()
    
    @overload
    def draw_string(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, x : float, y : float) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param x: The x-coordinate of the upper-left corner of the drawn text.
        :param y: The y-coordinate of the upper-left corner of the drawn text.'''
        raise NotImplementedError()
    
    @overload
    def draw_string(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, point : aspose.imaging.PointF) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param point: :py:class:`aspose.imaging.PointF` structure that specifies the upper-left corner of the drawn text.'''
        raise NotImplementedError()
    
    @overload
    def draw_string(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, x : float, y : float, format : aspose.imaging.StringFormat) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects using the formatting attributes of the specified :py:class:`aspose.imaging.StringFormat`.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param x: The x-coordinate of the upper-left corner of the drawn text.
        :param y: The y-coordinate of the upper-left corner of the drawn text.
        :param format: :py:class:`aspose.imaging.StringFormat` that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        raise NotImplementedError()
    
    @overload
    def draw_string(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, point : aspose.imaging.PointF, format : aspose.imaging.StringFormat) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects using the formatting attributes of the specified :py:class:`aspose.imaging.StringFormat`.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param point: :py:class:`aspose.imaging.PointF` structure that specifies the upper-left corner of the drawn text.
        :param format: :py:class:`aspose.imaging.StringFormat` that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        raise NotImplementedError()
    
    @overload
    def draw_string(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, layout_rectangle : aspose.imaging.RectangleF) -> None:
        '''Draws the specified text string in the specified rectangle with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param layout_rectangle: :py:class:`aspose.imaging.RectangleF` structure that specifies the location of the drawn text.'''
        raise NotImplementedError()
    
    @overload
    def draw_string(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, layout_rectangle : aspose.imaging.RectangleF, format : aspose.imaging.StringFormat) -> None:
        '''Draws the specified text string in the specified rectangle with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects using the formatting attributes of the specified :py:class:`aspose.imaging.StringFormat`.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param layout_rectangle: :py:class:`aspose.imaging.RectangleF` structure that specifies the location of the drawn text.
        :param format: :py:class:`aspose.imaging.StringFormat` that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        raise NotImplementedError()
    
    @overload
    def fill_ellipse(self, brush : aspose.imaging.Brush, rect : aspose.imaging.RectangleF) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def fill_ellipse(self, brush : aspose.imaging.Brush, x : float, y : float, width : float, height : float) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def fill_ellipse(self, brush : aspose.imaging.Brush, rect : aspose.imaging.Rectangle) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a :py:class:`aspose.imaging.Rectangle` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def fill_ellipse(self, brush : aspose.imaging.Brush, x : int, y : int, width : int, height : int) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    @overload
    def fill_pie(self, brush : aspose.imaging.Brush, rect : aspose.imaging.Rectangle, start_angle : float, sweep_angle : float) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    @overload
    def fill_pie(self, brush : aspose.imaging.Brush, rect : aspose.imaging.RectangleF, start_angle : float, sweep_angle : float) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    @overload
    def fill_pie(self, brush : aspose.imaging.Brush, x : float, y : float, width : float, height : float, start_angle : float, sweep_angle : float) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    @overload
    def fill_pie(self, brush : aspose.imaging.Brush, x : int, y : int, width : int, height : int, start_angle : int, sweep_angle : int) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    @overload
    def fill_polygon(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF]) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.PointF` structures and :py:attr:`aspose.imaging.FillMode.ALTERNATE`.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the vertices of the polygon to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_polygon(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF], fill_mode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.PointF` structures using the specified fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines the style of the fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_polygon(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point]) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.Point` structures and :py:attr:`aspose.imaging.FillMode.ALTERNATE`.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the vertices of the polygon to fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_polygon(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point], fill_mode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.Point` structures using the specified fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines the style of the fill.'''
        raise NotImplementedError()
    
    @overload
    def fill_closed_curve(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF]) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.PointF` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.'''
        raise NotImplementedError()
    
    @overload
    def fill_closed_curve(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF], fill_mode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.PointF` structures using the specified fill mode. This method uses a default tension of 0.5.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param fill_mode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.'''
        raise NotImplementedError()
    
    @overload
    def fill_closed_curve(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF], fillmode : aspose.imaging.FillMode, tension : float) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.PointF` structures using the specified fill mode and tension.
        
        :param brush: A :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param fillmode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    @overload
    def fill_closed_curve(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point]) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.Point` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.'''
        raise NotImplementedError()
    
    @overload
    def fill_closed_curve(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point], fillmode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.Point` structures using the specified fill mode. This method uses a default tension of 0.5.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param fillmode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.'''
        raise NotImplementedError()
    
    @overload
    def fill_closed_curve(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point], fillmode : aspose.imaging.FillMode, tension : float) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.Point` structures using the specified fill mode and tension.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param fillmode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def reset_transform(self) -> None:
        '''Resets the :py:attr:`aspose.imaging.Graphics.transform` property to identity.'''
        raise NotImplementedError()
    
    def begin_update(self) -> None:
        '''Starts caching of the following graphics operations. The graphics effects applied afterwards will not be applied immediately instead the EndUpdate will cause applying all the effects at once.'''
        raise NotImplementedError()
    
    def end_update(self) -> None:
        '''Finishes caching of the graphics operations started after BeginUpdate was called. The preceding graphics operations will be applied at once when calling this method.'''
        raise NotImplementedError()
    
    def clear(self, color : aspose.imaging.Color) -> None:
        '''Clears the graphics surface using the specified color.
        
        :param color: The color to clear the graphics surface by.'''
        raise NotImplementedError()
    
    def draw_line_point_f(self, pen : aspose.imaging.Pen, point1 : aspose.imaging.PointF, point2 : aspose.imaging.PointF) -> None:
        '''Draws a line connecting two :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param point1: :py:class:`aspose.imaging.PointF` structure that represents the first point to connect.
        :param point2: :py:class:`aspose.imaging.PointF` structure that represents the second point to connect.'''
        raise NotImplementedError()
    
    def draw_line_by_xy(self, pen : aspose.imaging.Pen, x1 : int, y1 : int, x2 : int, y2 : int) -> None:
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        raise NotImplementedError()
    
    def draw_line_f_by_xy(self, pen : aspose.imaging.Pen, x1 : float, y1 : float, x2 : float, y2 : float) -> None:
        '''Draws a line connecting the two points specified by the coordinate pairs.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line.
        :param x1: The x-coordinate of the first point.
        :param y1: The y-coordinate of the first point.
        :param x2: The x-coordinate of the second point.
        :param y2: The y-coordinate of the second point.'''
        raise NotImplementedError()
    
    def draw_lines_f(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a series of line segments that connect an array of :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the line segments.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the points to connect.'''
        raise NotImplementedError()
    
    def fill_rectangle_f(self, brush : aspose.imaging.Brush, rect : aspose.imaging.RectangleF) -> None:
        '''Fills the interior of a rectangle specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the rectangle to fill.'''
        raise NotImplementedError()
    
    def fill_rectangle_f_with_brush(self, brush : aspose.imaging.Brush, x : float, y : float, width : float, height : float) -> None:
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        raise NotImplementedError()
    
    def fill_rectangle_with_brush(self, brush : aspose.imaging.Brush, x : int, y : int, width : int, height : int) -> None:
        '''Fills the interior of a rectangle specified by a pair of coordinates, a width and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the rectangle to fill.
        :param y: The y-coordinate of the upper-left corner of the rectangle to fill.
        :param width: Width of the rectangle to fill.
        :param height: Height of the rectangle to fill.'''
        raise NotImplementedError()
    
    def fill_rectangles_f(self, brush : aspose.imaging.Brush, rects : List[aspose.imaging.RectangleF]) -> None:
        '''Fills the interiors of a series of rectangles specified by :py:class:`aspose.imaging.RectangleF` structures.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rects: Array of :py:class:`aspose.imaging.Rectangle` structures that represent the rectangles to fill.'''
        raise NotImplementedError()
    
    def draw_rectangle_f(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF) -> None:
        '''Draws a rectangle specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param rect: A :py:class:`aspose.imaging.RectangleF` structure that represents the rectangle to draw.'''
        raise NotImplementedError()
    
    def draw_rect_f(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float) -> None:
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: The width of the rectangle to draw.
        :param height: The height of the rectangle to draw.'''
        raise NotImplementedError()
    
    def draw_rect(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int) -> None:
        '''Draws a rectangle specified by a coordinate pair, a width, and a height.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the rectangle.
        :param x: The x-coordinate of the upper-left corner of the rectangle to draw.
        :param y: The y-coordinate of the upper-left corner of the rectangle to draw.
        :param width: Width of the rectangle to draw.
        :param height: Height of the rectangle to draw.'''
        raise NotImplementedError()
    
    def draw_rectangles_f(self, pen : aspose.imaging.Pen, rects : List[aspose.imaging.RectangleF]) -> None:
        '''Draws a series of rectangles specified by :py:class:`aspose.imaging.RectangleF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the outlines of the rectangles.
        :param rects: Array of :py:class:`aspose.imaging.RectangleF` structures that represent the rectangles to draw.'''
        raise NotImplementedError()
    
    def draw_ellipse_f(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF) -> None:
        '''Draws an ellipse defined by a bounding :py:class:`aspose.imaging.RectangleF`.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that defines the boundaries of the ellipse.'''
        raise NotImplementedError()
    
    def draw_ellipse_by_xyf(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float) -> None:
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    def draw_ellipse_by_xy(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int) -> None:
        '''Draws an ellipse defined by a bounding rectangle specified by a pair of coordinates, a height, and a width.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the ellipse.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    def draw_polygon_f(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a polygon defined by an array of :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the polygon.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the vertices of the polygon.'''
        raise NotImplementedError()
    
    def draw_image_at_point_f(self, source_image : aspose.imaging.Image, point : aspose.imaging.PointF) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image`, using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: :py:class:`aspose.imaging.PointF` structure that represents the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_at_xyf(self, source_image : aspose.imaging.Image, x : float, y : float) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image`, using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_rectangle_f(self, source_image : aspose.imaging.Image, rect : aspose.imaging.RectangleF) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that specifies the location and size of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_to_rect_with_unit(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    def draw_image_to_rect_f_with_unit(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    def draw_image_dest_rect_with_unit_attribs(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    def draw_image_dest_rect_f_with_unit_attribs(self, source_image : aspose.imaging.Image, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_destination: The destination rectangle to draw in.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    def draw_image_src_dest_rects_with_unit(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.Rectangle, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    def draw_image_src_dest_rects_f_with_unit(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.RectangleF, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.'''
        raise NotImplementedError()
    
    def draw_image_src_dst_rects_with_unit_and_attribs(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.Rectangle, rect_destination : aspose.imaging.Rectangle, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The rect source.
        :param rect_destination: The rect destination.
        :param graphics_unit: The graphics unit.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    def draw_image_src_dst_rect_f_with_unit_and_attribs(self, source_image : aspose.imaging.Image, rect_source : aspose.imaging.RectangleF, rect_destination : aspose.imaging.RectangleF, graphics_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect_source: The source rectangle.
        :param rect_destination: The destination rectangle.
        :param graphics_unit: The graphics unit to use.
        :param image_attributes: The image attributes to use.'''
        raise NotImplementedError()
    
    def draw_image_points(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point]) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        raise NotImplementedError()
    
    def draw_image_dest_points_src_rect(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point], src_rect : aspose.imaging.Rectangle) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        raise NotImplementedError()
    
    def draw_image_dest_points_src_rect_with_unit(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point], src_rect : aspose.imaging.Rectangle, src_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        raise NotImplementedError()
    
    def draw_image_dest_points_src_rect_with_unit_and_attribs(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.Point], src_rect : aspose.imaging.Rectangle, src_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    def draw_image_points_f(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF]) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.'''
        raise NotImplementedError()
    
    def draw_image_dest_points_f_src_rect_f(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.'''
        raise NotImplementedError()
    
    def draw_image_dest_point_f_src_rect_f_with_unit(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, src_unit : aspose.imaging.GraphicsUnit) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.'''
        raise NotImplementedError()
    
    def draw_image_dest_point_f_src_rect_f_with_unit_and_attribs(self, image : aspose.imaging.Image, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, src_unit : aspose.imaging.GraphicsUnit, image_attributes : aspose.imaging.ImageAttributes) -> None:
        '''Draws the specified portion of the specified ``image`` at the specified location and with the specified size.
        
        :param image: The image to draw.
        :param dest_points: Array of three PointF structures that define a parallelogram.
        :param src_rect: The source rectangle.
        :param src_unit: The units of measure.
        :param image_attributes: The image attributes.'''
        raise NotImplementedError()
    
    def draw_image_in_rect_f(self, source_image : aspose.imaging.Image, x : float, y : float, width : float, height : float) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_at_point(self, source_image : aspose.imaging.Image, point : aspose.imaging.Point) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image`, using its original physical size, at the specified location.
        
        :param source_image: The image to draw with.
        :param point: :py:class:`aspose.imaging.Point` structure that represents the location of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_at_xy(self, source_image : aspose.imaging.Image, x : int, y : int) -> None:
        '''Draws the specified image, using its original physical size, at the location specified by a coordinate pair.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_in_rectangle(self, source_image : aspose.imaging.Image, rect : aspose.imaging.Rectangle) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that specifies the location and size of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_in_rect(self, source_image : aspose.imaging.Image, x : int, y : int, width : int, height : int) -> None:
        '''Draws the specified :py:attr:`aspose.imaging.Graphics.image` at the specified location and with the specified size.
        
        :param source_image: The image to draw with.
        :param x: The x-coordinate of the upper-left corner of the drawn image.
        :param y: The y-coordinate of the upper-left corner of the drawn image.
        :param width: Width of the drawn image.
        :param height: Height of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_unscaled_to_point(self, source_image : aspose.imaging.Image, point : aspose.imaging.Point) -> None:
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param point: :py:class:`aspose.imaging.Point` structure that specifies the upper-left corner of the drawn image.'''
        raise NotImplementedError()
    
    def draw_image_unscaled_in_rectangle(self, source_image : aspose.imaging.Image, rect : aspose.imaging.Rectangle) -> None:
        '''Draws a specified image using its original physical size at a specified location.
        
        :param source_image: The image to draw with.
        :param rect: :py:class:`aspose.imaging.Rectangle` that specifies the upper-left corner of the drawn image. The X and Y properties of the rectangle specify the upper-left corner. The Width and Height properties are ignored.'''
        raise NotImplementedError()
    
    def draw_image_unscaled_and_clipped(self, source_image : aspose.imaging.Image, rect : aspose.imaging.Rectangle) -> None:
        '''Draws the specified image without scaling and clips it, if necessary, to fit in the specified rectangle.
        
        :param source_image: The image to draw with.
        :param rect: The :py:class:`aspose.imaging.Rectangle` in which to draw the image.'''
        raise NotImplementedError()
    
    def draw_arc_xyf(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float, start_angle : float, sweep_angle : float) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    def draw_arc_in_rect_f(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF, start_angle : float, sweep_angle : float) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    def draw_arc_xy(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int, start_angle : int, sweep_angle : int) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a pair of coordinates, a width, and a height.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param x: The x-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the rectangle that defines the ellipse.
        :param width: Width of the rectangle that defines the ellipse.
        :param height: Height of the rectangle that defines the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    def draw_arc_in_rect(self, pen : aspose.imaging.Pen, rect : aspose.imaging.Rectangle, start_angle : float, sweep_angle : float) -> None:
        '''Draws an arc representing a portion of an ellipse specified by a :py:class:`aspose.imaging.Rectangle` structure.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the arc.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that defines the boundaries of the ellipse.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the starting point of the arc.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to ending point of the arc.'''
        raise NotImplementedError()
    
    def draw_pie_in_rect_f(self, pen : aspose.imaging.Pen, rect : aspose.imaging.RectangleF, start_angle : float, sweep_angle : float) -> None:
        '''Draws a pie shape defined by an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    def draw_pie_xyf(self, pen : aspose.imaging.Pen, x : float, y : float, width : float, height : float, start_angle : float, sweep_angle : float) -> None:
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    def draw_pie_in_rect(self, pen : aspose.imaging.Pen, rect : aspose.imaging.Rectangle, start_angle : float, sweep_angle : float) -> None:
        '''Draws a pie shape defined by an ellipse specified by a :py:class:`aspose.imaging.Rectangle` structure and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    def draw_pie_xy(self, pen : aspose.imaging.Pen, x : int, y : int, width : int, height : int, start_angle : int, sweep_angle : int) -> None:
        '''Draws a pie shape defined by an ellipse specified by a coordinate pair, a width, a height, and two radial lines.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the pie shape.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie shape comes.
        :param start_angle: Angle measured in degrees clockwise from the x-axis to the first side of the pie shape.
        :param sweep_angle: Angle measured in degrees clockwise from the ``startAngle`` parameter to the second side of the pie shape.'''
        raise NotImplementedError()
    
    def draw_curve_by_points(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures. This method uses a default tension of 0.5.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.'''
        raise NotImplementedError()
    
    def draw_curve_by_point_fs_tension(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures using a specified tension.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the points that define the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_curve_by_points_f_offs_num_segm_tension(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], offset : int, number_of_segments : int, tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.PointF` structures using a specified tension. The drawing begins offset from the beginning of the array.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_curve_by_point_fs(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.'''
        raise NotImplementedError()
    
    def draw_curve_by_points_tension(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point], tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.Point` structures using a specified tension.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_curve_by_points_offs_num_segm_tension(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point], offset : int, number_of_segments : int, tension : float) -> None:
        '''Draws a cardinal spline through a specified array of :py:class:`aspose.imaging.Point` structures using a specified tension.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param offset: Offset from the first element in the array of the ``points`` parameter to the starting point in the curve.
        :param number_of_segments: Number of segments after the starting point to include in the curve.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_closed_curve_by_points_f(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.PointF` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.'''
        raise NotImplementedError()
    
    def draw_closed_curve_by_points_f_tension(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF], tension : float) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.PointF` structures using a specified tension. This method uses a default :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_closed_curve_by_points(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.Point` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.'''
        raise NotImplementedError()
    
    def draw_closed_curve_by_points_tension(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point], tension : float) -> None:
        '''Draws a closed cardinal spline defined by an array of :py:class:`aspose.imaging.Point` structures using a specified tension. This method uses a default :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and height of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_bezier_by_points_f(self, pen : aspose.imaging.Pen, pt1 : aspose.imaging.PointF, pt2 : aspose.imaging.PointF, pt3 : aspose.imaging.PointF, pt4 : aspose.imaging.PointF) -> None:
        '''Draws a Bézier spline defined by four :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param pt1: :py:class:`aspose.imaging.PointF` structure that represents the starting point of the curve.
        :param pt2: :py:class:`aspose.imaging.PointF` structure that represents the first control point for the curve.
        :param pt3: :py:class:`aspose.imaging.PointF` structure that represents the second control point for the curve.
        :param pt4: :py:class:`aspose.imaging.PointF` structure that represents the ending point of the curve.'''
        raise NotImplementedError()
    
    def draw_bezier_by_points(self, pen : aspose.imaging.Pen, pt1 : aspose.imaging.Point, pt2 : aspose.imaging.Point, pt3 : aspose.imaging.Point, pt4 : aspose.imaging.Point) -> None:
        '''Draws a Bézier spline defined by four :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` structure that determines the color, width, and style of the curve.
        :param pt1: :py:class:`aspose.imaging.Point` structure that represents the starting point of the curve.
        :param pt2: :py:class:`aspose.imaging.Point` structure that represents the first control point for the curve.
        :param pt3: :py:class:`aspose.imaging.Point` structure that represents the second control point for the curve.
        :param pt4: :py:class:`aspose.imaging.Point` structure that represents the ending point of the curve.'''
        raise NotImplementedError()
    
    def draw_beziers_by_pt_array(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.Point]) -> None:
        '''Draws a series of Bézier splines from an array of :py:class:`aspose.imaging.Point` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the points that determine the curve.'''
        raise NotImplementedError()
    
    def draw_beziers_by_pt_array_f(self, pen : aspose.imaging.Pen, points : List[aspose.imaging.PointF]) -> None:
        '''Draws a series of Bézier splines from an array of :py:class:`aspose.imaging.PointF` structures.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the curve.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the points that determine the curve.'''
        raise NotImplementedError()
    
    def draw_string_at_xy(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, x : float, y : float) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param x: The x-coordinate of the upper-left corner of the drawn text.
        :param y: The y-coordinate of the upper-left corner of the drawn text.'''
        raise NotImplementedError()
    
    def draw_string_at_point_f(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, point : aspose.imaging.PointF) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param point: :py:class:`aspose.imaging.PointF` structure that specifies the upper-left corner of the drawn text.'''
        raise NotImplementedError()
    
    def draw_string_at_point_f_format(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, point : aspose.imaging.PointF, format : aspose.imaging.StringFormat) -> None:
        '''Draws the specified text string at the specified location with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects using the formatting attributes of the specified :py:class:`aspose.imaging.StringFormat`.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param point: :py:class:`aspose.imaging.PointF` structure that specifies the upper-left corner of the drawn text.
        :param format: :py:class:`aspose.imaging.StringFormat` that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        raise NotImplementedError()
    
    def draw_string_in_rect(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, layout_rectangle : aspose.imaging.RectangleF) -> None:
        '''Draws the specified text string in the specified rectangle with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param layout_rectangle: :py:class:`aspose.imaging.RectangleF` structure that specifies the location of the drawn text.'''
        raise NotImplementedError()
    
    def draw_string_in_rect_f(self, s : str, font : aspose.imaging.Font, brush : aspose.imaging.Brush, layout_rectangle : aspose.imaging.RectangleF, format : aspose.imaging.StringFormat) -> None:
        '''Draws the specified text string in the specified rectangle with the specified :py:class:`aspose.imaging.Brush` and :py:class:`aspose.imaging.Font` objects using the formatting attributes of the specified :py:class:`aspose.imaging.StringFormat`.
        
        :param s: String to draw.
        :param font: :py:class:`aspose.imaging.Font` that defines the text format of the string.
        :param brush: :py:class:`aspose.imaging.Brush` that determines the color and texture of the drawn text.
        :param layout_rectangle: :py:class:`aspose.imaging.RectangleF` structure that specifies the location of the drawn text.
        :param format: :py:class:`aspose.imaging.StringFormat` that specifies formatting attributes, such as line spacing and alignment, that are applied to the drawn text.'''
        raise NotImplementedError()
    
    def fill_ellipse_in_rect_f(self, brush : aspose.imaging.Brush, rect : aspose.imaging.RectangleF) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a :py:class:`aspose.imaging.RectangleF` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    def fill_ellipse_at_xywhf(self, brush : aspose.imaging.Brush, x : float, y : float, width : float, height : float) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    def fill_ellipse_in_rect(self, brush : aspose.imaging.Brush, rect : aspose.imaging.Rectangle) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a :py:class:`aspose.imaging.Rectangle` structure.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    def fill_ellipse_at_xywh(self, brush : aspose.imaging.Brush, x : int, y : int, width : int, height : int) -> None:
        '''Fills the interior of an ellipse defined by a bounding rectangle specified by a pair of coordinates, a width, and a height.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse.
        :param width: Width of the bounding rectangle that defines the ellipse.
        :param height: Height of the bounding rectangle that defines the ellipse.'''
        raise NotImplementedError()
    
    def fill_pie_in_rect(self, brush : aspose.imaging.Brush, rect : aspose.imaging.Rectangle, start_angle : float, sweep_angle : float) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.Rectangle` structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    def fill_pie_in_rect_f(self, brush : aspose.imaging.Brush, rect : aspose.imaging.RectangleF, start_angle : float, sweep_angle : float) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a :py:class:`aspose.imaging.RectangleF` structure and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param rect: :py:class:`aspose.imaging.RectangleF` structure that represents the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    def fill_pie_at_xyf(self, brush : aspose.imaging.Brush, x : float, y : float, width : float, height : float, start_angle : float, sweep_angle : float) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    def fill_pie_at_xy(self, brush : aspose.imaging.Brush, x : int, y : int, width : int, height : int, start_angle : int, sweep_angle : int) -> None:
        '''Fills the interior of a pie section defined by an ellipse specified by a pair of coordinates, a width, a height, and two radial lines.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param x: The x-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param y: The y-coordinate of the upper-left corner of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param width: Width of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param height: Height of the bounding rectangle that defines the ellipse from which the pie section comes.
        :param start_angle: Angle in degrees measured clockwise from the x-axis to the first side of the pie section.
        :param sweep_angle: Angle in degrees measured clockwise from the ``startAngle`` parameter to the second side of the pie section.'''
        raise NotImplementedError()
    
    def fill_polygon_by_point_f(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF]) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.PointF` structures and :py:attr:`aspose.imaging.FillMode.ALTERNATE`.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the vertices of the polygon to fill.'''
        raise NotImplementedError()
    
    def fill_polygon_by_point_f_fill_mode(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF], fill_mode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.PointF` structures using the specified fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines the style of the fill.'''
        raise NotImplementedError()
    
    def fill_polygon_by_point(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point]) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.Point` structures and :py:attr:`aspose.imaging.FillMode.ALTERNATE`.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the vertices of the polygon to fill.'''
        raise NotImplementedError()
    
    def fill_polygon_by_point_fill_mode(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point], fill_mode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a polygon defined by an array of points specified by :py:class:`aspose.imaging.Point` structures using the specified fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that represent the vertices of the polygon to fill.
        :param fill_mode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines the style of the fill.'''
        raise NotImplementedError()
    
    def fill_closed_curve_by_point_f(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF]) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.PointF` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.'''
        raise NotImplementedError()
    
    def fill_closed_curve_by_point_f_fill_mode(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF], fillmode : aspose.imaging.FillMode) -> None:
        raise NotImplementedError()
    
    def fill_closed_curve_by_point_f_fill_mode_tension(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.PointF], fillmode : aspose.imaging.FillMode, tension : float) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.PointF` structures using the specified fill mode and tension.
        
        :param brush: A :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.PointF` structures that define the spline.
        :param fillmode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def fill_closed_curve_by_point(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point]) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.Point` structures. This method uses a default tension of 0.5 and :py:attr:`aspose.imaging.FillMode.ALTERNATE` fill mode.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.'''
        raise NotImplementedError()
    
    def fill_closed_curve_by_point_fill_mode(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point], fillmode : aspose.imaging.FillMode) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.Point` structures using the specified fill mode. This method uses a default tension of 0.5.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param fillmode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.'''
        raise NotImplementedError()
    
    def fill_closed_curve_by_point_fill_mode_tension(self, brush : aspose.imaging.Brush, points : List[aspose.imaging.Point], fillmode : aspose.imaging.FillMode, tension : float) -> None:
        '''Fills the interior of a closed cardinal spline curve defined by an array of :py:class:`aspose.imaging.Point` structures using the specified fill mode and tension.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param points: Array of :py:class:`aspose.imaging.Point` structures that define the spline.
        :param fillmode: Member of the :py:class:`aspose.imaging.FillMode` enumeration that determines how the curve is filled.
        :param tension: Value greater than or equal to 0.0F that specifies the tension of the curve.'''
        raise NotImplementedError()
    
    def draw_path(self, pen : aspose.imaging.Pen, path : aspose.imaging.GraphicsPath) -> None:
        '''Draws a :py:class:`aspose.imaging.GraphicsPath`.
        
        :param pen: :py:class:`aspose.imaging.Pen` that determines the color, width, and style of the path.
        :param path: :py:class:`aspose.imaging.GraphicsPath` to draw.'''
        raise NotImplementedError()
    
    def fill_path(self, brush : aspose.imaging.Brush, path : aspose.imaging.GraphicsPath) -> None:
        '''Fills the interior of a :py:class:`aspose.imaging.GraphicsPath`.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param path: :py:class:`aspose.imaging.GraphicsPath` that represents the path to fill.'''
        raise NotImplementedError()
    
    def fill_region(self, brush : aspose.imaging.Brush, region : aspose.imaging.Region) -> None:
        '''Fills the interior of a :py:class:`aspose.imaging.Region`.
        
        :param brush: :py:class:`aspose.imaging.Brush` that determines the characteristics of the fill.
        :param region: :py:class:`aspose.imaging.Region` that represents the area to fill.'''
        raise NotImplementedError()
    
    def measure_string(self, text : str, font : aspose.imaging.Font, layout_area : aspose.imaging.SizeF, string_format : aspose.imaging.StringFormat) -> aspose.imaging.SizeF:
        '''Measures the specified text string with specified parameters
        
        :param text: The text to measure.
        :param font: The font to measure.
        :param layout_area: The layout area.
        :param string_format: The string format.
        :returns: Size in pixels of measured text string'''
        raise NotImplementedError()
    
    @property
    def dpi_x(self) -> float:
        '''Gets the horizontal resolution of this Aspose.Imaging.Graphics.'''
        raise NotImplementedError()
    
    @property
    def dpi_y(self) -> float:
        '''Gets the vertical resolution of this Aspose.Imaging.Graphics.'''
        raise NotImplementedError()
    
    @property
    def page_unit(self) -> aspose.imaging.GraphicsUnit:
        '''Gets the unit of measure used for page coordinates in this Aspose.Imaging.Graphics.'''
        raise NotImplementedError()
    
    @page_unit.setter
    def page_unit(self, value : aspose.imaging.GraphicsUnit) -> None:
        '''Sets the unit of measure used for page coordinates in this Aspose.Imaging.Graphics.'''
        raise NotImplementedError()
    
    @property
    def page_scale(self) -> float:
        '''Gets the scaling between world units and page units for this Aspose.Imaging.Graphics.'''
        raise NotImplementedError()
    
    @page_scale.setter
    def page_scale(self, value : float) -> None:
        '''Sets the scaling between world units and page units for this Aspose.Imaging.Graphics.'''
        raise NotImplementedError()
    
    @property
    def clip(self) -> aspose.imaging.Region:
        '''Gets the clip region.'''
        raise NotImplementedError()
    
    @clip.setter
    def clip(self, value : aspose.imaging.Region) -> None:
        '''Sets the clip region.'''
        raise NotImplementedError()
    
    @property
    def transform(self) -> aspose.imaging.Matrix:
        '''Gets a copy of the geometric world transformation for this :py:class:`aspose.imaging.Graphics`.'''
        raise NotImplementedError()
    
    @transform.setter
    def transform(self, value : aspose.imaging.Matrix) -> None:
        '''Sets a copy of the geometric world transformation for this :py:class:`aspose.imaging.Graphics`.'''
        raise NotImplementedError()
    
    @property
    def is_in_begin_update_call(self) -> bool:
        '''Gets a value indicating whether graphics is in BeginUpdate call state.'''
        raise NotImplementedError()
    
    @property
    def image(self) -> aspose.imaging.Image:
        '''Gets the image.'''
        raise NotImplementedError()
    
    @property
    def compositing_quality(self) -> aspose.imaging.CompositingQuality:
        '''Gets the compositing quality.'''
        raise NotImplementedError()
    
    @compositing_quality.setter
    def compositing_quality(self, value : aspose.imaging.CompositingQuality) -> None:
        '''Sets the compositing quality.'''
        raise NotImplementedError()
    
    @property
    def interpolation_mode(self) -> aspose.imaging.InterpolationMode:
        '''Gets the interpolation mode.'''
        raise NotImplementedError()
    
    @interpolation_mode.setter
    def interpolation_mode(self, value : aspose.imaging.InterpolationMode) -> None:
        '''Sets the interpolation mode.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.SmoothingMode:
        '''Gets the smoothing mode.'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.SmoothingMode) -> None:
        '''Sets the smoothing mode.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.TextRenderingHint:
        '''Gets the text rendering hint.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.TextRenderingHint) -> None:
        '''Sets the text rendering hint.'''
        raise NotImplementedError()
    
    @property
    def paintable_image_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets image options, used to create paintable vactor images to draw.'''
        raise NotImplementedError()
    
    @paintable_image_options.setter
    def paintable_image_options(self, value : aspose.imaging.ImageOptionsBase) -> None:
        '''Sets image options, used to create paintable vactor images to draw.'''
        raise NotImplementedError()
    

class GraphicsPath(ObjectWithBounds):
    '''Represents a series of connected lines and curves. This class cannot be inherited.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.GraphicsPath` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, figures : List[aspose.imaging.Figure]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.GraphicsPath` class.
        
        :param figures: The figures to initialize from.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, figures : List[aspose.imaging.Figure], fill_mode : aspose.imaging.FillMode) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.GraphicsPath` class.
        
        :param figures: The figures to initialize from.
        :param fill_mode: The fill mode.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, fill_mode : aspose.imaging.FillMode) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.GraphicsPath` class.
        
        :param fill_mode: The fill mode.'''
        raise NotImplementedError()
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix, pen : aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object\'s bounds size.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : float, y : float) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, point : aspose.imaging.PointF) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param point: A :py:class:`aspose.imaging.PointF` that represents the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : int, y : int) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, point : aspose.imaging.Point) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param point: A :py:class:`aspose.imaging.Point` that represents the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : float, y : float, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath` in the visible clip region of the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, pt : aspose.imaging.PointF, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param pt: A :py:class:`aspose.imaging.PointF` that represents the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : int, y : int, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`, using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, pt : aspose.imaging.Point, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param pt: A :py:class:`aspose.imaging.Point` that represents the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, x : float, y : float, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, point : aspose.imaging.PointF, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param point: A :py:class:`aspose.imaging.PointF` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, x : float, y : float, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, pt : aspose.imaging.PointF, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param pt: A :py:class:`aspose.imaging.PointF` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, x : int, y : int, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, point : aspose.imaging.Point, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param point: A :py:class:`aspose.imaging.Point` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, x : int, y : int, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_outline_visible(self, pt : aspose.imaging.Point, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param pt: A :py:class:`aspose.imaging.Point` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def flatten(self) -> None:
        '''Converts each curve in this path into a sequence of connected line segments.'''
        raise NotImplementedError()
    
    @overload
    def flatten(self, matrix : aspose.imaging.Matrix) -> None:
        '''Applies the specified transform and then converts each curve in this :py:class:`aspose.imaging.GraphicsPath` into a sequence of connected line segments.
        
        :param matrix: A :py:class:`aspose.imaging.Matrix` by which to transform this :py:class:`aspose.imaging.GraphicsPath` before flattening.'''
        raise NotImplementedError()
    
    @overload
    def flatten(self, matrix : aspose.imaging.Matrix, flatness : float) -> None:
        '''Converts each curve in this :py:class:`aspose.imaging.GraphicsPath` into a sequence of connected line segments.
        
        :param matrix: A :py:class:`aspose.imaging.Matrix` by which to transform this :py:class:`aspose.imaging.GraphicsPath` before flattening.
        :param flatness: Specifies the maximum permitted error between the curve and its flattened approximation. A value of 0.25 is the default. Reducing the flatness value will increase the number of line segments in the approximation.'''
        raise NotImplementedError()
    
    @overload
    def widen(self, pen : aspose.imaging.Pen) -> None:
        '''Adds an additional outline to the path.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that specifies the width between the original outline of the path and the new outline this method creates.'''
        raise NotImplementedError()
    
    @overload
    def widen(self, pen : aspose.imaging.Pen, matrix : aspose.imaging.Matrix) -> None:
        '''Adds an additional outline to the :py:class:`aspose.imaging.GraphicsPath`.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that specifies the width between the original outline of the path and the new outline this method creates.
        :param matrix: A :py:class:`aspose.imaging.Matrix` that specifies a transform to apply to the path before widening.'''
        raise NotImplementedError()
    
    @overload
    def widen(self, pen : aspose.imaging.Pen, matrix : aspose.imaging.Matrix, flatness : float) -> None:
        '''Replaces this :py:class:`aspose.imaging.GraphicsPath` with curves that enclose the area that is filled when this path is drawn by the specified pen.
        
        :param pen: A :py:class:`aspose.imaging.Pen` that specifies the width between the original outline of the path and the new outline this method creates.
        :param matrix: A :py:class:`aspose.imaging.Matrix` that specifies a transform to apply to the path before widening.
        :param flatness: A value that specifies the flatness for curves.'''
        raise NotImplementedError()
    
    @overload
    def warp(self, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF) -> None:
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param dest_points: An array of :py:class:`aspose.imaging.PointF` structures that define a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A :py:class:`aspose.imaging.RectangleF` that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.'''
        raise NotImplementedError()
    
    @overload
    def warp(self, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, matrix : aspose.imaging.Matrix) -> None:
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param dest_points: An array of :py:class:`aspose.imaging.PointF` structures that define a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A :py:class:`aspose.imaging.RectangleF` that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.
        :param matrix: A :py:class:`aspose.imaging.Matrix` that specifies a geometric transform to apply to the path.'''
        raise NotImplementedError()
    
    @overload
    def warp(self, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, matrix : aspose.imaging.Matrix, warp_mode : aspose.imaging.WarpMode) -> None:
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param dest_points: An array of :py:class:`aspose.imaging.PointF` structures that defines a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A :py:class:`aspose.imaging.RectangleF` that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.
        :param matrix: A :py:class:`aspose.imaging.Matrix` that specifies a geometric transform to apply to the path.
        :param warp_mode: A :py:class:`aspose.imaging.WarpMode` enumeration that specifies whether this warp operation uses perspective or bilinear mode.'''
        raise NotImplementedError()
    
    @overload
    def warp(self, dest_points : List[aspose.imaging.PointF], src_rect : aspose.imaging.RectangleF, matrix : aspose.imaging.Matrix, warp_mode : aspose.imaging.WarpMode, flatness : float) -> None:
        '''Applies a warp transform, defined by a rectangle and a parallelogram, to this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param dest_points: An array of :py:class:`aspose.imaging.PointF` structures that define a parallelogram to which the rectangle defined by ``srcRect`` is transformed. The array can contain either three or four elements. If the array contains three elements, the lower-right corner of the parallelogram is implied by the first three points.
        :param src_rect: A :py:class:`aspose.imaging.RectangleF` that represents the rectangle that is transformed to the parallelogram defined by ``destPoints``.
        :param matrix: A :py:class:`aspose.imaging.Matrix` that specifies a geometric transform to apply to the path.
        :param warp_mode: A :py:class:`aspose.imaging.WarpMode` enumeration that specifies whether this warp operation uses perspective or bilinear mode.
        :param flatness: A value from 0 through 1 that specifies how flat the resulting path is. For more information, see the :py:func:`aspose.imaging.GraphicsPath.flatten` methods.'''
        raise NotImplementedError()
    
    @overload
    def add_path(self, adding_path : aspose.imaging.GraphicsPath) -> None:
        '''Appends the specified :py:class:`aspose.imaging.GraphicsPath` to this path.
        
        :param adding_path: The :py:class:`aspose.imaging.GraphicsPath` to add.'''
        raise NotImplementedError()
    
    @overload
    def add_path(self, adding_path : aspose.imaging.GraphicsPath, connect : bool) -> None:
        '''Appends the specified :py:class:`aspose.imaging.GraphicsPath` to this path.
        
        :param adding_path: The :py:class:`aspose.imaging.GraphicsPath` to add.
        :param connect: A Boolean value that specifies whether the first figure in the added path is part of the last figure in this path. A value of true specifies that the first figure in the added path is part of the last figure in this path. A value of false specifies that the first figure in the added path is separate from the last figure in this path.'''
        raise NotImplementedError()
    
    def transform(self, transform : aspose.imaging.Matrix) -> None:
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        raise NotImplementedError()
    
    def reset(self) -> None:
        '''Empties the graphics path and sets the :py:class:`aspose.imaging.FillMode` to :py:attr:`aspose.imaging.FillMode.ALTERNATE`.'''
        raise NotImplementedError()
    
    def reverse(self) -> None:
        '''Reverses the order of figures, shapes, and points in each shape of this :py:class:`aspose.imaging.GraphicsPath`.'''
        raise NotImplementedError()
    
    def is_visible_xyf(self, x : float, y : float) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point_f(self, point : aspose.imaging.PointF) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param point: A :py:class:`aspose.imaging.PointF` that represents the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xy(self, x : int, y : int) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point(self, point : aspose.imaging.Point) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param point: A :py:class:`aspose.imaging.Point` that represents the point to test.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xyf_graphics(self, x : float, y : float, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath` in the visible clip region of the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point_f_graphics(self, pt : aspose.imaging.PointF, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param pt: A :py:class:`aspose.imaging.PointF` that represents the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xy_graphics(self, x : int, y : int, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`, using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point_graphics(self, pt : aspose.imaging.Point, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`.
        
        :param pt: A :py:class:`aspose.imaging.Point` that represents the point to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within this :py:class:`aspose.imaging.GraphicsPath`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_xyf(self, x : float, y : float, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_point_f(self, point : aspose.imaging.PointF, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param point: A :py:class:`aspose.imaging.PointF` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_xyf_graphics(self, x : float, y : float, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_point_f_graphics(self, pt : aspose.imaging.PointF, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param pt: A :py:class:`aspose.imaging.PointF` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_xy(self, x : int, y : int, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_point(self, point : aspose.imaging.Point, pen : aspose.imaging.Pen) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`.
        
        :param point: A :py:class:`aspose.imaging.Point` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_xy_graphics(self, x : int, y : int, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_outline_visible_point_graphics(self, pt : aspose.imaging.Point, pen : aspose.imaging.Pen, graphics : aspose.imaging.Graphics) -> bool:
        '''Indicates whether the specified point is contained within (under) the outline of this :py:class:`aspose.imaging.GraphicsPath` when drawn with the specified :py:class:`aspose.imaging.Pen` and using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param pt: A :py:class:`aspose.imaging.Point` that specifies the location to test.
        :param pen: The :py:class:`aspose.imaging.Pen` to test.
        :param graphics: The :py:class:`aspose.imaging.Graphics` for which to test visibility.
        :returns: This method returns true if the specified point is contained within the outline of this :py:class:`aspose.imaging.GraphicsPath` as drawn with the specified :py:class:`aspose.imaging.Pen`; otherwise, false.'''
        raise NotImplementedError()
    
    def add_figure(self, figure : aspose.imaging.Figure) -> None:
        '''Adds a new figure.
        
        :param figure: The figure to add.'''
        raise NotImplementedError()
    
    def add_figures(self, figures : List[aspose.imaging.Figure]) -> None:
        '''Adds new figures.
        
        :param figures: The figures to add.'''
        raise NotImplementedError()
    
    def remove_figure(self, figure : aspose.imaging.Figure) -> None:
        '''Removes a figure.
        
        :param figure: The figure to remove.'''
        raise NotImplementedError()
    
    def remove_figures(self, figures : List[aspose.imaging.Figure]) -> None:
        '''Removes figures.
        
        :param figures: The figures to remove.'''
        raise NotImplementedError()
    
    def deep_clone(self) -> aspose.imaging.GraphicsPath:
        '''Performs a deep clone of this graphics path.
        
        :returns: A deep clone of the graphics path.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.'''
        raise NotImplementedError()
    
    @property
    def fill_mode(self) -> aspose.imaging.FillMode:
        '''Gets a :py:class:`aspose.imaging.FillMode` enumeration that determines how the interiors of shapes in this :py:class:`aspose.imaging.GraphicsPath` are filled.'''
        raise NotImplementedError()
    
    @fill_mode.setter
    def fill_mode(self, value : aspose.imaging.FillMode) -> None:
        '''Sets a :py:class:`aspose.imaging.FillMode` enumeration that determines how the interiors of shapes in this :py:class:`aspose.imaging.GraphicsPath` are filled.'''
        raise NotImplementedError()
    
    @property
    def figures(self) -> List[aspose.imaging.Figure]:
        '''Gets the path figures.'''
        raise NotImplementedError()
    

class IAdvancedBufferProcessor:
    '''The advanced buffer processor.'''
    
    def finish_row(self) -> None:
        '''Finishes the row.'''
        raise NotImplementedError()
    
    def finish_rows(self, rows_count : int) -> None:
        '''Finishes the rows.
        
        :param rows_count: The rows count.'''
        raise NotImplementedError()
    

class IAnimationFrame:
    '''The Animation frame'''
    
    def get_full_frame(self) -> aspose.imaging.RasterImage:
        '''Gets the full frame.
        
        :returns: The RasterImage with full frame'''
        raise NotImplementedError()
    
    @property
    def frame_time(self) -> int:
        '''Gets the frame duration.'''
        raise NotImplementedError()
    
    @property
    def frame_top(self) -> int:
        '''Gets the frame top offset.'''
        raise NotImplementedError()
    
    @property
    def frame_left(self) -> int:
        '''Gets the frame left offset.'''
        raise NotImplementedError()
    
    @property
    def use_alpha_blending(self) -> bool:
        '''Gets a value indicating whether [use alpha blending].'''
        raise NotImplementedError()
    
    @property
    def disposal_method(self) -> aspose.imaging.AnimationDisposalMethods:
        '''Gets the disposal method.'''
        raise NotImplementedError()
    

class IBufferProcessor:
    '''The buffer processor.'''
    
    def process_buffer(self, buffer : List[int], buffer_length : int) -> None:
        '''Processes the buffer.
        
        :param buffer: The buffer to process.
        :param buffer_length: The buffer length to process.'''
        raise NotImplementedError()
    

class IColorConverter:
    '''The color converter.'''
    
    def convert(self, source_format : aspose.imaging.PixelDataFormat, data : List[int], offset : int, bit_start : int, samples_count : int, lines_count : int, dest_format : aspose.imaging.PixelDataFormat, output_data : List[int], output_offset : int) -> int:
        '''Converts the passed data to the output format.
        
        :param source_format: The source format.
        :param data: The source data.
        :param offset: The offset in bytes where data copying should begin.
        :param bit_start: The bit start. Note this value is not byte aligned value instead this is actual bit where copying should begin.
        :param samples_count: The samples count.
        :param lines_count: The lines count.
        :param dest_format: The destination format.
        :param output_data: The output data.
        :param output_offset: The output offset where data copying should start.
        :returns: The converted bytes count.'''
        raise NotImplementedError()
    

class IColorPalette:
    '''The color palette interface.'''
    
    @overload
    def get_nearest_color_index(self, argb_32_color : int) -> int:
        '''Gets the index of the nearest 32-bit ARGB color.
        
        :param argb_32_color: The 32-bit ARGB color.
        :returns: The index of the nearest color.'''
        raise NotImplementedError()
    
    @overload
    def get_nearest_color_index(self, color : aspose.imaging.Color) -> int:
        '''Gets the index of the nearest color.
        
        :param color: The color.
        :returns: The index of the nearest color.'''
        raise NotImplementedError()
    
    def get_argb_32_color(self, index : int) -> int:
        '''Gets the 32-bit ARGB palette color by index.
        
        :param index: The 32-bit ARGB palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        raise NotImplementedError()
    
    def get_color(self, index : int) -> aspose.imaging.Color:
        '''Gets the palette color by index.
        
        :param index: The palette color index.
        :returns: The color palette entry specified by the ``index``.'''
        raise NotImplementedError()
    
    @property
    def entries_count(self) -> int:
        '''Gets the entries count.'''
        raise NotImplementedError()
    
    @property
    def argb_32_entries(self) -> List[int]:
        '''Gets an array of 32-bit ARGB structures.'''
        raise NotImplementedError()
    
    @property
    def entries(self) -> List[aspose.imaging.Color]:
        '''Gets an array of :py:class:`aspose.imaging.Color` structures.'''
        raise NotImplementedError()
    
    @property
    def is_compact_palette(self) -> bool:
        '''Gets a value indicating whether compact palette is used.'''
        raise NotImplementedError()
    

class IHasMetadata:
    '''Image metadata interface.'''
    

class IImageCreator:
    '''The image creator.'''
    
    def create(self, stream_container : aspose.imaging.StreamContainer, image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image instance with ``imageOptions``.
        
        :param stream_container: The stream container to create image data in.
        :param image_options: The image options.
        :param width: width of new image
        :param height: height of new image
        :returns: A new image instance.'''
        raise NotImplementedError()
    

class IImageCreatorDescriptor:
    '''The image creator descriptor specifying the creator properties. The creator descriptor is used to overcome
    the necessity to contain each image creator instance in memory and multithreading issues.'''
    
    def can_create(self, image_options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image creator can create a new image using the ``imageOptions``.
        
        :param image_options: The image options.
        :returns: ``True`` if image creator created by this descriptor can create image data using the specified ``imageOptions``; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def create_instance(self) -> aspose.imaging.IImageCreator:
        '''Creates a new creator instance.
        
        :returns: A new creator instance.'''
        raise NotImplementedError()
    

class IImageDescriptor:
    '''The image descriptor. Contains base properties and methods for all other image descriptor types.'''
    
    @property
    def supported_format(self) -> aspose.imaging.FileFormat:
        '''Gets the supported format.'''
        raise NotImplementedError()
    

class IImageExporter:
    '''The image exporter. Can export data from internal Aspose.Imaging format to a specified data format.'''
    
    @overload
    def export(self, image : aspose.imaging.Image, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Exports the specified image data into specified data format.
        
        :param image: The image data to export.
        :param stream: The stream to export data to.
        :param options_base: Options for image export'''
        raise NotImplementedError()
    
    @overload
    def export(self, image : aspose.imaging.Image, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Exports the specified image data into specified data format.
        
        :param image: The image data to export.
        :param stream: The stream to export data to.
        :param options_base: Options for image export
        :param bounds_rectangle: The bounds rectangle.'''
        raise NotImplementedError()
    

class IImageExporterDescriptor:
    '''Represents the image exporter descriptor. The exporter descriptor is used to overcome the necessity to contain each exporter instance
    in memory and multithreading issues.'''
    
    def can_export(self, image : aspose.imaging.Image, options_base : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image exporter can export the specified image to the specified image format specified by save options.
        
        :param image: The image to export.
        :param options_base: The options base.
        :returns: ``True`` if exporter created by this descriptor can export the specified image to the specified file format; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def create_instance(self) -> aspose.imaging.IImageExporter:
        '''Creates a new exporter instance.
        
        :returns: A new exporter instance.'''
        raise NotImplementedError()
    

class IImageLoader:
    '''The image loader.'''
    
    def load(self, stream_container : aspose.imaging.StreamContainer, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Opens a new image with ``loadOptions``.
        
        :param stream_container: The stream container.
        :param load_options: The load options.
        :returns: A newly opened image instance.'''
        raise NotImplementedError()
    

class IImageLoaderDescriptor:
    '''The image loader descriptor specifying the loader properties. The loader descriptor is used to overcome
    the necessity to contain each image loader instance in memory and multithreading issues.'''
    
    def can_load(self, stream_container : aspose.imaging.StreamContainer, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image loader can read a new image from the specified stream and optionally using the ``loadOptions``.
        
        :param stream_container: The stream container.
        :param load_options: The file format details specified by ``loadOptions``. The ``loadOptions`` may be null.
        :returns: ``true`` if image loader created by this descriptor can read image from stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def create_instance(self) -> aspose.imaging.IImageLoader:
        '''Creates a new loader instance.
        
        :returns: A new loader instance.'''
        raise NotImplementedError()
    

class IIndexedColorConverter:
    '''The color converter for indexed image formats.'''
    
    def fill_indexedto_indexed_map(self, map : List[int], source_format : aspose.imaging.PixelDataFormat, dest_format : aspose.imaging.PixelDataFormat) -> None:
        '''Fills the indexed to indexed image conversion map.
        
        :param map: The conversion map.
        :param source_format: The source format.
        :param dest_format: The destination format.'''
        raise NotImplementedError()
    

class IMetadataContainer:
    '''Image metadata container interface.'''
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True if ``metadata`` is not null and the :py:class:`aspose.imaging.IMetadataContainer` instance
        supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    

class IMultipageImage:
    '''The multipage image interface'''
    
    @property
    def page_count(self) -> int:
        '''Gets the page count.'''
        raise NotImplementedError()
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        raise NotImplementedError()
    

class IMultipageImageExt:
    '''The extended multipage image interface'''
    
    def add_page(self, page : aspose.imaging.RasterImage) -> None:
        '''Adds page to the image.
        
        :param page: The page to add.'''
        raise NotImplementedError()
    

class IObjectWithBounds:
    '''Represents an object with bounds.'''
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the object size.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the object bounds.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the object width.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the object height.'''
        raise NotImplementedError()
    

class IOrderedShape:
    '''Represents an ordered shape. An ordered shape is a continuous set of points having a start point and end point.
    The continuous set of points connected using a specific rule.'''
    
    def reverse(self) -> None:
        '''Reverses the order of points for this shape.'''
        raise NotImplementedError()
    
    @property
    def start_point(self) -> aspose.imaging.PointF:
        '''Gets the starting shape point.'''
        raise NotImplementedError()
    
    @property
    def end_point(self) -> aspose.imaging.PointF:
        '''Gets the ending shape point.'''
        raise NotImplementedError()
    
    @property
    def is_closed(self) -> bool:
        '''Gets a value indicating whether ordered shape is closed. When processing closed ordered shape the starting and ending points have no meaning.'''
        raise NotImplementedError()
    
    @is_closed.setter
    def is_closed(self, value : bool) -> None:
        '''Sets a value indicating whether ordered shape is closed. When processing closed ordered shape the starting and ending points have no meaning.'''
        raise NotImplementedError()
    

class IPartialArgb32PixelLoader:
    '''Conforms to the 32-bit ARGB pixels loaded partially.'''
    
    def process(self, pixels_rectangle : aspose.imaging.Rectangle, pixels : List[int], start : aspose.imaging.Point, end : aspose.imaging.Point) -> None:
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The 32-bit ARGB pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        raise NotImplementedError()
    

class IPartialArgb64PixelLoader:
    '''The 64-bit ARGB pixels loader.'''
    
    def process64(self, pixels_rectangle : aspose.imaging.Rectangle, pixels : List[int], start : aspose.imaging.Point, end : aspose.imaging.Point) -> None:
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The 64-bit ARGB pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        raise NotImplementedError()
    

class IPartialPixelLoader:
    '''Conforms to the pixels loaded partially.'''
    
    def process(self, pixels_rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.Color], start : aspose.imaging.Point, end : aspose.imaging.Point) -> None:
        '''Processes the loaded pixels.
        
        :param pixels_rectangle: The pixels rectangle.
        :param pixels: The pixels.
        :param start: The start pixels point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end pixels point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        raise NotImplementedError()
    

class IPartialRawDataLoader:
    '''The partial data loader.'''
    
    @overload
    def process(self, rectangle : aspose.imaging.Rectangle, data : List[int], start : aspose.imaging.Point, end : aspose.imaging.Point) -> None:
        '''Processes the loaded data.
        
        :param rectangle: The data rectangle.
        :param data: The raw data.
        :param start: The start data point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end data point. If not equal to (right,bottom) meaning that it is not full rectangle we have.'''
        raise NotImplementedError()
    
    @overload
    def process(self, rectangle : aspose.imaging.Rectangle, data : List[int], start : aspose.imaging.Point, end : aspose.imaging.Point, load_options : aspose.imaging.LoadOptions) -> None:
        '''Processes the loaded data.
        
        :param rectangle: The data rectangle.
        :param data: The raw data.
        :param start: The start data point. If not equal to (left,top) meaning that it is not full rectangle we have.
        :param end: The end data point. If not equal to (right,bottom) meaning that it is not full rectangle we have.
        :param load_options: The load options.'''
        raise NotImplementedError()
    

class IRasterImageArgb32PixelLoader:
    '''The raster image 32-bit ARGB pixel loader.'''
    
    def load_partial_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Loads 32-bit ARGB pixels partially (by blocks).
        
        :param rectangle: The rectangle to load pixels from.
        :param partial_pixel_loader: The partial pixel loader.'''
        raise NotImplementedError()
    

class IRasterImageArgb64PixelLoader:
    '''The raster image 64-bit ARGB pixel loader.'''
    
    def load_partial_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb64PixelLoader) -> None:
        '''Loads 64-bit ARGB pixels partially (by blocks).
        
        :param rectangle: The rectangle to load pixels from.
        :param partial_pixel_loader: The partial pixel loader.'''
        raise NotImplementedError()
    

class IRasterImagePixelLoader:
    '''The raster image pixel loader.'''
    
    def load_partial_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialPixelLoader) -> None:
        '''Loads pixels partially (by blocks).
        
        :param rectangle: The rectangle to load pixels from.
        :param partial_pixel_loader: The partial pixel loader.'''
        raise NotImplementedError()
    

class IRasterImageRawDataLoader:
    '''The raster image raw data loader.'''
    
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @property
    def is_raw_data_available(self) -> bool:
        '''Gets a value indicating whether raw data loading is supported.'''
        raise NotImplementedError()
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        '''Gets the current raw data settings. Note when using these settings the data loads without conversion.'''
        raise NotImplementedError()
    

class Image(DataStreamSupporter):
    '''The image is the base class for all type of images.'''
    
    @overload
    def save(self) -> None:
        '''Saves the image data to the underlying stream.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int, pixels : List[int]) -> aspose.imaging.Image:
        '''Creates a :py:class:`aspose.imaging.RasterImage` instance from the provided pixel array.
        
        Validates that the specified width and height match the dimensions of the pixel data.
        This method can only be used when the library is in Licensed mode.
        
        :param image_options: The options used to create the :py:class:`aspose.imaging.RasterImage`.
        :param width: The width of the :py:class:`aspose.imaging.RasterImage`.
        :param height: The height of the :py:class:`aspose.imaging.RasterImage`.
        :param pixels: The array of pixel values used to populate the image.
        :returns: A :py:class:`aspose.imaging.RasterImage` populated with the provided pixel data.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(multipage_create_options : aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(file_path : str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, pixels : List[int], width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int) -> None:
        '''Resizes the image. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int) -> None:
        '''Resizes the width proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int) -> None:
        '''Resizes the height proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, rectangle : aspose.imaging.Rectangle) -> None:
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, left_shift : int, right_shift : int, top_shift : int, bottom_shift : int) -> None:
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data and ensures no additional data loading will be performed from the underlying :py:attr:`aspose.imaging.DataStreamSupporter.data_stream_container`.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_file_format_of_stream(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_width(width : int, height : int, new_height : int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_height(width : int, height : int, new_width : int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        raise NotImplementedError()
    
    def remove_metadata(self) -> None:
        '''Removes metadata.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type; otherwise, false.'''
        raise NotImplementedError()
    
    def can_save(self, options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def resize_by_type(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    def resize_by_settings(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    def get_default_options(self, args : List[Any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        raise NotImplementedError()
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        :py:func:`aspose.imaging.DataStreamSupporter.save` method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the :py:func:`aspose.imaging.Image.save` method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        raise NotImplementedError()
    
    def resize_width_proportionally_settings(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def resize_height_proportionally_settings(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def rotate_flip(self, rotate_flip_type : aspose.imaging.RotateFlipType) -> None:
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        raise NotImplementedError()
    
    def rotate(self, angle : float) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        raise NotImplementedError()
    
    def save_with_options(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    def save_with_options_rect(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options_rect(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    def get_serialized_stream(self, image_options : aspose.imaging.ImageOptionsBase, clipping_rectangle : aspose.imaging.Rectangle, page_number : List[int]) -> io._IOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        raise NotImplementedError()
    
    def set_palette(self, palette : aspose.imaging.IColorPalette, update_colors : bool) -> None:
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether object\'s data is cached currently and no data reading is required.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        raise NotImplementedError()
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the :py:class:`aspose.imaging.Image` container.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @property
    def use_palette(self) -> bool:
        '''Gets a value indicating whether the image palette is used.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        '''Gets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor) -> None:
        '''Sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def auto_adjust_palette(self) -> bool:
        '''Gets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool) -> None:
        '''Sets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @property
    def has_background_color(self) -> bool:
        '''Gets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @has_background_color.setter
    def has_background_color(self, value : bool) -> None:
        '''Sets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        '''Gets a value of file format'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a value for the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a value for the background color.'''
        raise NotImplementedError()
    
    @property
    def metadata(self) -> aspose.imaging.metadata.ImageMetadata:
        '''Gets the image metadata.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the Xmp data.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the Xmp data.'''
        raise NotImplementedError()
    

class ImageAttributes:
    '''An :py:class:`aspose.imaging.ImageAttributes` object contains information about how bitmap and metafile colors are manipulated during rendering. An :py:class:`aspose.imaging.ImageAttributes` object maintains several color-adjustment settings, including color-adjustment matrices, grayscale-adjustment matrices, gamma-correction values, color-map tables, and color-threshold values. During rendering, colors can be corrected, darkened, lightened, and removed. To apply such manipulations, initialize an :py:class:`aspose.imaging.ImageAttributes` object and pass the path of that :py:class:`aspose.imaging.ImageAttributes` object (along with the path of an :py:class:`aspose.imaging.Image`) to the DrawImage method.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ImageAttributes` class.'''
        raise NotImplementedError()
    
    @overload
    def set_color_matrix(self, new_color_matrix : aspose.imaging.ColorMatrix) -> None:
        '''Sets the color-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.'''
        raise NotImplementedError()
    
    @overload
    def set_color_matrix(self, new_color_matrix : aspose.imaging.ColorMatrix, flags : aspose.imaging.ColorMatrixFlag) -> None:
        '''Sets the color-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param flags: An element of :py:class:`aspose.imaging.ColorMatrixFlag` that specifies the type of image and color that will be affected by the color-adjustment matrix.'''
        raise NotImplementedError()
    
    @overload
    def set_color_matrix(self, new_color_matrix : aspose.imaging.ColorMatrix, mode : aspose.imaging.ColorMatrixFlag, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the color-adjustment matrix for a specified category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param mode: An element of :py:class:`aspose.imaging.ColorMatrixFlag` that specifies the type of image and color that will be affected by the color-adjustment matrix.
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color-adjustment matrix is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_color_matrix(self) -> None:
        '''Clears the color-adjustment matrix for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_color_matrix(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the color-adjustment matrix for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color-adjustment matrix is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_color_matrices(self, new_color_matrix : aspose.imaging.ColorMatrix, gray_matrix : aspose.imaging.ColorMatrix) -> None:
        '''Sets the color-adjustment matrix and the grayscale-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param gray_matrix: The grayscale-adjustment matrix.'''
        raise NotImplementedError()
    
    @overload
    def set_color_matrices(self, new_color_matrix : aspose.imaging.ColorMatrix, gray_matrix : aspose.imaging.ColorMatrix, flags : aspose.imaging.ColorMatrixFlag) -> None:
        '''Sets the color-adjustment matrix and the grayscale-adjustment matrix for the default category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param gray_matrix: The grayscale-adjustment matrix.
        :param flags: An element of :py:class:`aspose.imaging.ColorMatrixFlag` that specifies the type of image and color that will be affected by the color-adjustment and grayscale-adjustment matrices.'''
        raise NotImplementedError()
    
    @overload
    def set_color_matrices(self, new_color_matrix : aspose.imaging.ColorMatrix, gray_matrix : aspose.imaging.ColorMatrix, mode : aspose.imaging.ColorMatrixFlag, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the color-adjustment matrix and the grayscale-adjustment matrix for a specified category.
        
        :param new_color_matrix: The color-adjustment matrix.
        :param gray_matrix: The grayscale-adjustment matrix.
        :param mode: An element of :py:class:`aspose.imaging.ColorMatrixFlag` that specifies the type of image and color that will be affected by the color-adjustment and grayscale-adjustment matrices.
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color-adjustment and grayscale-adjustment matrices are set.'''
        raise NotImplementedError()
    
    @overload
    def set_threshold(self, threshold : float) -> None:
        '''Sets the threshold (transparency range) for the default category.
        
        :param threshold: A real number that specifies the threshold value.'''
        raise NotImplementedError()
    
    @overload
    def set_threshold(self, threshold : float, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the threshold (transparency range) for a specified category.
        
        :param threshold: A threshold value from 0.0 to 1.0 that is used as a breakpoint to sort colors that will be mapped to either a maximum or a minimum value.
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color threshold is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_threshold(self) -> None:
        '''Clears the threshold value for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_threshold(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the threshold value for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the threshold is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_gamma(self, gamma : float) -> None:
        '''Sets the gamma value for the default category.
        
        :param gamma: The gamma correction value.'''
        raise NotImplementedError()
    
    @overload
    def set_gamma(self, gamma : float, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the gamma value for a specified category.
        
        :param gamma: The gamma correction value.
        :param type: An element of the :py:class:`aspose.imaging.ColorAdjustType` enumeration that specifies the category for which the gamma value is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_gamma(self) -> None:
        '''Disables gamma correction for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_gamma(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Disables gamma correction for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which gamma correction is disabled.'''
        raise NotImplementedError()
    
    @overload
    def set_no_op(self) -> None:
        '''Turns off color adjustment for the default category.'''
        raise NotImplementedError()
    
    @overload
    def set_no_op(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Turns off color adjustment for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which color correction is turned off.'''
        raise NotImplementedError()
    
    @overload
    def clear_no_op(self) -> None:
        '''Clears the NoOp setting for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_no_op(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the NoOp setting for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the NoOp setting is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_color_key(self, color_low : aspose.imaging.Color, color_high : aspose.imaging.Color) -> None:
        '''Sets the color key for the default category.
        
        :param color_low: The low color-key value.
        :param color_high: The high color-key value.'''
        raise NotImplementedError()
    
    @overload
    def set_color_key(self, color_low : aspose.imaging.Color, color_high : aspose.imaging.Color, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the color key (transparency range) for a specified category.
        
        :param color_low: The low color-key value.
        :param color_high: The high color-key value.
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color key is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_color_key(self) -> None:
        '''Clears the color key (transparency range) for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_color_key(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the color key (transparency range) for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color key is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_output_channel(self, flags : aspose.imaging.ColorChannelFlag) -> None:
        '''Sets the CMYK (cyan-magenta-yellow-black) output channel for the default category.
        
        :param flags: An element of :py:class:`aspose.imaging.ColorChannelFlag` that specifies the output channel.'''
        raise NotImplementedError()
    
    @overload
    def set_output_channel(self, flags : aspose.imaging.ColorChannelFlag, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the CMYK (cyan-magenta-yellow-black) output channel for a specified category.
        
        :param flags: An element of :py:class:`aspose.imaging.ColorChannelFlag` that specifies the output channel.
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the output channel is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_output_channel(self) -> None:
        '''Clears the CMYK (cyan-magenta-yellow-black) output channel setting for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_output_channel(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the (cyan-magenta-yellow-black) output channel setting for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the output channel setting is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_output_channel_color_profile(self, color_profile_filename : str) -> None:
        '''Sets the output channel color-profile file for the default category.
        
        :param color_profile_filename: The path name of a color-profile file. If the color-profile file is in the %SystemRoot%\System32\Spool\Drivers\Color directory, this parameter can be the file name. Otherwise, this parameter must be the fully qualified path name.'''
        raise NotImplementedError()
    
    @overload
    def set_output_channel_color_profile(self, color_profile_filename : str, type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the output channel color-profile file for a specified category.
        
        :param color_profile_filename: The path name of a color-profile file. If the color-profile file is in the %SystemRoot%\System32\Spool\Drivers\Color directory, this parameter can be the file name. Otherwise, this parameter must be the fully qualified path name.
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the output channel color-profile file is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_output_channel_color_profile(self) -> None:
        '''Clears the output channel color profile setting for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_output_channel_color_profile(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the output channel color profile setting for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the output channel profile setting is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_remap_table(self, map : List[aspose.imaging.ColorMap]) -> None:
        '''Sets the color-remap table for the default category.
        
        :param map: An array of color pairs of type :py:class:`aspose.imaging.ColorMap`. Each color pair contains an existing color (the first value) and the color that it will be mapped to (the second value).'''
        raise NotImplementedError()
    
    @overload
    def set_remap_table(self, map : List[aspose.imaging.ColorMap], type : aspose.imaging.ColorAdjustType) -> None:
        '''Sets the color-remap table for a specified category.
        
        :param map: An array of color pairs of type :py:class:`aspose.imaging.ColorMap`. Each color pair contains an existing color (the first value) and the color that it will be mapped to (the second value).
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the color-remap table is set.'''
        raise NotImplementedError()
    
    @overload
    def clear_remap_table(self) -> None:
        '''Clears the color-remap table for the default category.'''
        raise NotImplementedError()
    
    @overload
    def clear_remap_table(self, type : aspose.imaging.ColorAdjustType) -> None:
        '''Clears the color-remap table for a specified category.
        
        :param type: An element of :py:class:`aspose.imaging.ColorAdjustType` that specifies the category for which the remap table is cleared.'''
        raise NotImplementedError()
    
    @overload
    def set_wrap_mode(self, mode : aspose.imaging.WrapMode) -> None:
        '''Sets the wrap mode that is used to decide how to tile a texture across a shape, or at shape boundaries. A texture is tiled across a shape to fill it in when the texture is smaller than the shape it is filling.
        
        :param mode: An element of :py:class:`aspose.imaging.WrapMode` that specifies how repeated copies of an image are used to tile an area.'''
        raise NotImplementedError()
    
    @overload
    def set_wrap_mode(self, mode : aspose.imaging.WrapMode, color : aspose.imaging.Color) -> None:
        '''Sets the wrap mode and color used to decide how to tile a texture across a shape, or at shape boundaries. A texture is tiled across a shape to fill it in when the texture is smaller than the shape it is filling.
        
        :param mode: An element of :py:class:`aspose.imaging.WrapMode` that specifies how repeated copies of an image are used to tile an area.
        :param color: An :py:class:`aspose.imaging.ImageAttributes` object that specifies the color of pixels outside of a rendered image. This color is visible if the mode parameter is set to :py:attr:`aspose.imaging.WrapMode.CLAMP` and the source rectangle passed to DrawImage is larger than the image itself.'''
        raise NotImplementedError()
    
    @overload
    def set_wrap_mode(self, mode : aspose.imaging.WrapMode, color : aspose.imaging.Color, clamp : bool) -> None:
        '''Sets the wrap mode and color used to decide how to tile a texture across a shape, or at shape boundaries. A texture is tiled across a shape to fill it in when the texture is smaller than the shape it is filling.
        
        :param mode: An element of :py:class:`aspose.imaging.WrapMode` that specifies how repeated copies of an image are used to tile an area.
        :param color: A color object that specifies the color of pixels outside of a rendered image. This color is visible if the mode parameter is set to :py:attr:`aspose.imaging.WrapMode.CLAMP` and the source rectangle passed to DrawImage is larger than the image itself.
        :param clamp: This parameter has no effect. Set it to false.'''
        raise NotImplementedError()
    
    def set_brush_remap_table(self, map : List[aspose.imaging.ColorMap]) -> None:
        '''Sets the color-remap table for the brush category.
        
        :param map: An array of :py:class:`aspose.imaging.ColorMap` objects.'''
        raise NotImplementedError()
    
    def clear_brush_remap_table(self) -> None:
        '''Clears the brush color-remap table of this :py:class:`aspose.imaging.ImageAttributes` object.'''
        raise NotImplementedError()
    

class ImageCreatorsRegistry:
    '''Represents the image creators registry.'''
    
    @staticmethod
    def register(image_creator_descriptor : aspose.imaging.IImageCreatorDescriptor) -> None:
        '''Registers the specified image creator descriptor.
        
        :param image_creator_descriptor: The image creator descriptor.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_first_supported_descriptor(image_options : aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageCreatorDescriptor:
        '''Gets the fist found supported descriptor suitable for the specified.
        
        :param image_options: The image options.
        :returns: The creator descriptor which supports the specified or null if no such descriptor is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_first_supported_creator(image_options : aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageCreator:
        '''Creates the first found creator suitable for the specified.
        
        :param image_options: The image options.
        :returns: The creator which supports the specified or null if no such creator is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def register_creator(creator_descriptor : aspose.imaging.IImageCreatorDescriptor) -> None:
        '''Registers the creator.
        
        :param creator_descriptor: The creator descriptor to register.'''
        raise NotImplementedError()
    
    @staticmethod
    def unregister_creator(creator_descriptor : aspose.imaging.IImageCreatorDescriptor) -> None:
        '''Unregisters the creator.
        
        :param creator_descriptor: The creator descriptor.'''
        raise NotImplementedError()
    
    @property
    def registered_formats(self) -> aspose.imaging.FileFormat:
        '''Gets the registered image creation formats.'''
        raise NotImplementedError()

    @property
    def registered_descriptors(self) -> List[aspose.imaging.IImageCreatorDescriptor]:
        '''Gets the registered descriptors.'''
        raise NotImplementedError()


class ImageExportersRegistry:
    '''Represents the image exporters registry.'''
    
    @staticmethod
    def register(image_exporter_descriptor : aspose.imaging.IImageExporterDescriptor) -> None:
        '''Registers the specified image exporter descriptor.
        
        :param image_exporter_descriptor: The image exporter descriptor.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_first_supported_descriptor(image : aspose.imaging.Image, options : aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageExporterDescriptor:
        '''Gets the fist found supported descriptor suitable for the specified save options and image.
        
        :param image: The image to export.
        :param options: The options.
        :returns: The exporter descriptor which supports the specified image and save options or null if no such descriptor is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_first_supported_exporter(image : aspose.imaging.Image, options : aspose.imaging.ImageOptionsBase) -> aspose.imaging.IImageExporter:
        '''Creates the first found exporter suitable for the specified save options and image.
        
        :param image: The image to export.
        :param options: The save options to use for export.
        :returns: The exporter which supports the specified image and save options or null if no such exporter is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def register_exporter(exporter_descriptor : aspose.imaging.IImageExporterDescriptor) -> None:
        '''Registers the exporter.
        
        :param exporter_descriptor: The exporter descriptor to register.'''
        raise NotImplementedError()
    
    @staticmethod
    def unregister_exporter(exporter_descriptor : aspose.imaging.IImageExporterDescriptor) -> None:
        '''Unregisters the exporter.
        
        :param exporter_descriptor: The exporter descriptor to unregister.'''
        raise NotImplementedError()
    
    @property
    def registered_formats(self) -> aspose.imaging.FileFormat:
        '''Gets the registered export formats.'''
        raise NotImplementedError()

    @property
    def registered_exporter_descriptors(self) -> List[aspose.imaging.IImageExporterDescriptor]:
        '''Gets the registered exporter descriptors.'''
        raise NotImplementedError()


class ImageLoadersRegistry:
    '''Represents the image loaders registry.'''
    
    @staticmethod
    def register(image_loader_descriptor : aspose.imaging.IImageLoaderDescriptor) -> None:
        '''Registers the specified image loader descriptor.
        
        :param image_loader_descriptor: The image loader descriptor.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_first_supported_descriptor_by_type_name(descriptor_type_name : str) -> aspose.imaging.IImageLoaderDescriptor:
        '''Gets the first supported descriptor by its type name.
        
        :param descriptor_type_name: The descriptor type name.
        :returns: The first found loader descriptor or null if not such descriptor is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_first_supported_descriptor_by_file_format(file_format : aspose.imaging.FileFormat) -> aspose.imaging.IImageLoaderDescriptor:
        '''Gets the first supported file format by its type name.
        
        :param file_format: The supported descriptor file format.
        :returns: The first found loader descriptor or null if not such descriptor is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_first_supported_descriptor(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.IImageLoaderDescriptor:
        '''Gets the fist found supported descriptor suitable for the specified ``stream`` and optionally the ``loadOptions``.
        
        :param stream: The stream.
        :param load_options: The load options.
        :returns: The loader descriptor which supports the specified ``stream`` and ``loadOptions`` or null if no such descriptor is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_first_supported_loader(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.IImageLoader:
        '''Creates the first found loader suitable for the specified ``stream`` and optionally the ``loadOptions``.
        
        :param stream: The stream.
        :param load_options: The load options.
        :returns: The loader which supports the specified ``stream`` and ``loadOptions`` or null if no such loader is found.'''
        raise NotImplementedError()
    
    @staticmethod
    def register_loader(loader_descriptor : aspose.imaging.IImageLoaderDescriptor) -> None:
        '''Registers the loader.
        
        :param loader_descriptor: The loader descriptor to register.'''
        raise NotImplementedError()
    
    @staticmethod
    def unregister_loader(loader_descriptor : aspose.imaging.IImageLoaderDescriptor) -> None:
        '''Unregisters the loader.
        
        :param loader_descriptor: The loader descriptor to unregister.'''
        raise NotImplementedError()
    
    @property
    def registered_formats(self) -> aspose.imaging.FileFormat:
        '''Gets the registered image loading formats.'''
        raise NotImplementedError()

    @property
    def registered_descriptors(self) -> List[aspose.imaging.IImageLoaderDescriptor]:
        '''Gets the registered descriptors.'''
        raise NotImplementedError()


class ImageOptionsBase(DisposableObject):
    '''The image base options.'''
    
    def clone(self) -> aspose.imaging.ImageOptionsBase:
        '''Creates a memberwise clone of this instance.
        
        :returns: A memberwise clone of this instance.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.IMetadataContainer` instance supports and/or implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` instance; otherwise, false.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def keep_metadata(self) -> bool:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @keep_metadata.setter
    def keep_metadata(self, value : bool) -> None:
        '''Gets a value whether to keep original image metadata on export.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the XMP metadata container.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the XMP metadata container.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def source(self) -> aspose.imaging.Source:
        '''Gets the source to create image in.'''
        raise NotImplementedError()
    
    @source.setter
    def source(self, value : aspose.imaging.Source) -> None:
        '''Sets the source to create image in.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette.'''
        raise NotImplementedError()
    
    @property
    def resolution_settings(self) -> aspose.imaging.ResolutionSetting:
        '''Gets the resolution settings.'''
        raise NotImplementedError()
    
    @resolution_settings.setter
    def resolution_settings(self, value : aspose.imaging.ResolutionSetting) -> None:
        '''Sets the resolution settings.'''
        raise NotImplementedError()
    
    @property
    def vector_rasterization_options(self) -> aspose.imaging.imageoptions.VectorRasterizationOptions:
        '''Gets the vector rasterization options.'''
        raise NotImplementedError()
    
    @vector_rasterization_options.setter
    def vector_rasterization_options(self, value : aspose.imaging.imageoptions.VectorRasterizationOptions) -> None:
        '''Sets the vector rasterization options.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def multi_page_options(self) -> aspose.imaging.imageoptions.MultiPageOptions:
        '''The multipage options'''
        raise NotImplementedError()
    
    @multi_page_options.setter
    def multi_page_options(self, value : aspose.imaging.imageoptions.MultiPageOptions) -> None:
        '''The multipage options'''
        raise NotImplementedError()
    
    @property
    def full_frame(self) -> bool:
        '''Gets a value indicating whether [full frame].'''
        raise NotImplementedError()
    
    @full_frame.setter
    def full_frame(self, value : bool) -> None:
        '''Sets a value indicating whether [full frame].'''
        raise NotImplementedError()
    

class ImageResizeSettings:
    '''Image resize settings class'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ImageResizeSettings` class.'''
        raise NotImplementedError()
    
    @property
    def entries_count(self) -> int:
        '''Gets the entries count'''
        raise NotImplementedError()
    
    @entries_count.setter
    def entries_count(self, value : int) -> None:
        '''Sets the entries count'''
        raise NotImplementedError()
    
    @property
    def mode(self) -> aspose.imaging.ResizeType:
        '''Gets the interpolation mode.'''
        raise NotImplementedError()
    
    @mode.setter
    def mode(self, value : aspose.imaging.ResizeType) -> None:
        '''Sets the interpolation mode.'''
        raise NotImplementedError()
    
    @property
    def filter_type(self) -> aspose.imaging.ImageFilterType:
        '''Gets the type of the filter.'''
        raise NotImplementedError()
    
    @filter_type.setter
    def filter_type(self, value : aspose.imaging.ImageFilterType) -> None:
        '''Sets the type of the filter.'''
        raise NotImplementedError()
    
    @property
    def color_quantization_method(self) -> aspose.imaging.ColorQuantizationMethod:
        '''Gets the color quantization method.'''
        raise NotImplementedError()
    
    @color_quantization_method.setter
    def color_quantization_method(self, value : aspose.imaging.ColorQuantizationMethod) -> None:
        '''Sets the color quantization method.'''
        raise NotImplementedError()
    
    @property
    def color_compare_method(self) -> aspose.imaging.ColorCompareMethod:
        '''Gets the color compare method.'''
        raise NotImplementedError()
    
    @color_compare_method.setter
    def color_compare_method(self, value : aspose.imaging.ColorCompareMethod) -> None:
        '''Sets the color compare method.'''
        raise NotImplementedError()
    

class IntRange:
    '''Class for representing sequence of elements'''
    
    @overload
    def __init__(self, start : int, count : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.IntRange` class.
        
        :param start: The start.
        :param count: The count.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, start : int, count : int, delta : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.IntRange` class.
        
        :param start: The start.
        :param count: The count.
        :param delta: The delta.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, range : List[int]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.IntRange` class.
        
        :param range: The range.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_range(start : int, count : int, delta : int) -> System.Collections.Generic.IEnumerable`1[[System.Int32]]:
        '''Gets the count range of int elements starting at start
        
        :param start: The start.
        :param count: The count.
        :param delta: The delta.
        :returns: Array of items'''
        raise NotImplementedError()
    
    def get_array_one_item_from_index(self, index : int) -> List[int]:
        '''Returns one item array from specified index
        
        :param index: The range index.
        :returns: The array of :py:class:`str`'''
        raise NotImplementedError()
    
    @property
    def range(self) -> List[int]:
        '''Gets the range.'''
        raise NotImplementedError()
    
    @range.setter
    def range(self, value : List[int]) -> None:
        '''Sets the range.'''
        raise NotImplementedError()
    

class License:
    '''Provides methods to license the component.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.License` class.
        Initializes a new instance of this class.'''
        raise NotImplementedError()
    
    @overload
    def set_license(self, license_name : str) -> None:
        '''Licenses the component.
        
        :param license_name: Can be a full or short file name . Use an empty string to switch to evaluation mode.'''
        raise NotImplementedError()
    
    @overload
    def set_license(self, stream : io._IOBase) -> None:
        '''Licenses the component.
        
        :param stream: A stream that contains the license.'''
        raise NotImplementedError()
    
    def set_license_stream(self, stream : io._IOBase) -> None:
        '''Licenses the component.
        
        :param stream: A stream that contains the license.'''
        raise NotImplementedError()
    

class LoadOptions:
    '''Represents the loading options.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.LoadOptions`.'''
        raise NotImplementedError()
    
    @property
    def data_recovery_mode(self) -> aspose.imaging.DataRecoveryMode:
        '''Gets the data recovery mode.'''
        raise NotImplementedError()
    
    @data_recovery_mode.setter
    def data_recovery_mode(self, value : aspose.imaging.DataRecoveryMode) -> None:
        '''Sets the data recovery mode.'''
        raise NotImplementedError()
    
    @property
    def data_background_color(self) -> aspose.imaging.Color:
        '''Gets the :py:class:`aspose.imaging.Image` background :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    @data_background_color.setter
    def data_background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets the :py:class:`aspose.imaging.Image` background :py:class:`aspose.imaging.Color`.'''
        raise NotImplementedError()
    
    @property
    def use_icc_profile_conversion(self) -> bool:
        '''Gets a value indicating whether ICC profile conversion should be applied.'''
        raise NotImplementedError()
    
    @use_icc_profile_conversion.setter
    def use_icc_profile_conversion(self, value : bool) -> None:
        '''Sets a value indicating whether ICC profile conversion should be applied.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def concurrent_image_processing(self) -> bool:
        '''Gets a value indicating whether [concurrent image processing].'''
        raise NotImplementedError()
    
    @concurrent_image_processing.setter
    def concurrent_image_processing(self, value : bool) -> None:
        '''Sets a value indicating whether [concurrent image processing].'''
        raise NotImplementedError()
    

class Matrix:
    '''Replaces the GDI+ Matrix.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the Matrix class as the identity matrix.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, m11 : float, m12 : float, m21 : float, m22 : float, m31 : float, m32 : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Matrix` class.
        
        :param m11: m00     M11     Scale X
        :param m12: m10     M12     Shear Y
        :param m21: m01     M21     Shear X
        :param m22: m11     M22     Scale Y
        :param m31: m02     M31     Translate X
        :param m32: m12     M32     Translate Y'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, rect : aspose.imaging.RectangleF, plgpts : List[aspose.imaging.PointF]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Matrix` class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A :py:class:`aspose.imaging.RectangleF` structure that represents the rectangle to be transformed.
        :param plgpts: An array of three :py:class:`aspose.imaging.PointF` structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, rect : aspose.imaging.Rectangle, plgpts : List[aspose.imaging.Point]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Matrix` class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A :py:class:`aspose.imaging.Rectangle` structure that represents the rectangle to be transformed.
        :param plgpts: An array of three :py:class:`aspose.imaging.Point` structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, origin : aspose.imaging.Matrix) -> None:
        '''Makes a copy of the :py:class:`aspose.imaging.Matrix` class.
        
        :param origin: A base matrix for coping'''
        raise NotImplementedError()
    
    @overload
    def scale(self, scale_x : float, scale_y : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Applies the specified scale vector (scaleX and scaleY) to this :py:class:`aspose.imaging.Matrix` using the specified order.
        
        :param scale_x: The scale X.
        :param scale_y: The scale Y.
        :param order: The order.'''
        raise NotImplementedError()
    
    @overload
    def scale(self, sx : float, sy : float) -> None:
        '''Applies the specified scale vector (scaleX and scaleY) to this Matrix using (default) Prepend order.
        
        :param sx: The sx. The sx. The sx.
        :param sy: The sy. The sy. The sy.'''
        raise NotImplementedError()
    
    @overload
    def translate(self, offset_x : float, offset_y : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Applies the specified translation vector to this Matrix in the specified order.
        
        :param offset_x: The offset X.
        :param offset_y: The offset Y.
        :param order: The order.'''
        raise NotImplementedError()
    
    @overload
    def translate(self, tx : float, ty : float) -> None:
        '''Applies the specified translation vector to this :py:class:`aspose.imaging.Matrix` using (default) Prepend order.
        
        :param tx: The tx. The tx. The tx.
        :param ty: The ty. The ty. The ty.'''
        raise NotImplementedError()
    
    @overload
    def multiply(self, t_tx : aspose.imaging.Matrix, order : aspose.imaging.MatrixOrder) -> None:
        '''Multiplies this Matrix by the matrix specified in the matrix parameter, and in the order specified in the order parameter.
        
        :param t_tx: The tx. The tx. The tx.
        :param order: The order. The order. The order.'''
        raise NotImplementedError()
    
    @overload
    def multiply(self, t_tx : aspose.imaging.Matrix) -> None:
        '''Multiplies this Matrix by the matrix specified in the matrix parameter using (default) Prepend order.
        
        :param t_tx: The matrix to multiply with.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Applies a clockwise rotation of an amount specified in the angle parameter, around the origin (zero x and y coordinates) for this Matrix in the specified order.
        
        :param angle: The rotate angle.
        :param order: The matrix order.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float) -> None:
        '''Applies a clockwise rotation of an amount specified in the angle parameter, around the origin (zero x and y coordinates) for this Matrix in the default (Prepend) order.
        
        :param angle: The rotate angle.'''
        raise NotImplementedError()
    
    @overload
    def rotate_at(self, angle : float, point : aspose.imaging.PointF, order : aspose.imaging.MatrixOrder) -> None:
        '''Applies a clockwise rotation about the specified point to this Matrix in the specified order.
        
        :param angle: The angle.
        :param point: The point.
        :param order: The order.'''
        raise NotImplementedError()
    
    @overload
    def rotate_at(self, angle : float, point : aspose.imaging.PointF) -> None:
        '''Applies a clockwise rotation about the specified point to this Matrix in the default (Prepend) order.
        
        :param angle: The angle.
        :param point: The point.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_rect_f(rect : aspose.imaging.RectangleF, plgpts : List[aspose.imaging.PointF]) -> aspose.imaging.Matrix:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Matrix` class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A :py:class:`aspose.imaging.RectangleF` structure that represents the rectangle to be transformed.
        :param plgpts: An array of three :py:class:`aspose.imaging.PointF` structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_rect(rect : aspose.imaging.Rectangle, plgpts : List[aspose.imaging.Point]) -> aspose.imaging.Matrix:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Matrix` class to the geometric transform defined by the specified rectangle and array of points.
        
        :param rect: A :py:class:`aspose.imaging.Rectangle` structure that represents the rectangle to be transformed.
        :param plgpts: An array of three :py:class:`aspose.imaging.Point` structures that represents the points of a parallelogram to which the upper-left, upper-right, and lower-left corners of the rectangle is to be transformed. The lower-right corner of the parallelogram is implied by the first three corners.'''
        raise NotImplementedError()
    
    @staticmethod
    def equals(a : aspose.imaging.Matrix, b : aspose.imaging.Matrix) -> bool:
        '''Determines whether two matrixes are equal.
        
        :param a: The first matrix to compare.
        :param b: The second matrix to compare.
        :returns: True if matrixes are equal.'''
        raise NotImplementedError()
    
    def get_elements(self) -> List[float]:
        '''Gets the copy of matrix elements.
        
        :returns: A matrix elements copy.'''
        raise NotImplementedError()
    
    def transform_points(self, points : List[aspose.imaging.PointF]) -> None:
        '''Applies the geometric transform represented by this :py:class:`aspose.imaging.Matrix` to a specified array of points.
        
        :param points: The points.'''
        raise NotImplementedError()
    
    def reset(self) -> None:
        '''Resets this Matrix to have the elements of the identity matrix.'''
        raise NotImplementedError()
    
    @property
    def elements(self) -> List[float]:
        '''Gets an array of floating-point values that represents the elements of this :py:class:`aspose.imaging.Matrix`.'''
        raise NotImplementedError()
    
    @property
    def m11(self) -> float:
        '''Gets the matrix element at first row first column. Represents scale along X axis.'''
        raise NotImplementedError()
    
    @property
    def m12(self) -> float:
        '''Gets the matrix element at first row second column. Represents shear along Y axis.'''
        raise NotImplementedError()
    
    @property
    def m21(self) -> float:
        '''Gets the matrix element at second row first column. Represents shear along X axis.'''
        raise NotImplementedError()
    
    @property
    def m22(self) -> float:
        '''Gets the matrix element at second row second column. Represents scale along Y axis.'''
        raise NotImplementedError()
    
    @property
    def m31(self) -> float:
        '''Gets the matrix element at third row first column. Represents translation along X axis.'''
        raise NotImplementedError()
    
    @property
    def m32(self) -> float:
        '''Gets the matrix element at third row first column. Represents translation along Y axis.'''
        raise NotImplementedError()
    
    @property
    def TYPE_IDENTITY(self) -> int:
        '''An identity transform is one in which the output coordinates are
        always the same as the input coordinates.
        If this transform is anything other than the identity transform,
        the type will either be the constant GENERAL_TRANSFORM or a
        combination of the appropriate flag bits for the various coordinate
        conversions that this transform performs.'''
        raise NotImplementedError()

    @property
    def TYPE_TRANSLATION(self) -> int:
        '''A translation moves the coordinates by a constant amount in x
        and y without changing the length or angle of vectors.'''
        raise NotImplementedError()

    @property
    def TYPE_UNIFORM_SCALE(self) -> int:
        '''A uniform scale multiplies the length of vectors by the same amount
        in both the x and y directions without changing the angle between
        vectors.
        This flag bit is mutually exclusive with the TypeGeneralScale flag.'''
        raise NotImplementedError()

    @property
    def TYPE_GENERAL_SCALE(self) -> int:
        '''A general scale multiplies the length of vectors by different
        amounts in the x and y directions without changing the angle
        between perpendicular vectors.
        This flag bit is mutually exclusive with the TypeUniformScale flag.'''
        raise NotImplementedError()

    @property
    def TYPE_MASK_SCALE(self) -> int:
        '''This constant is a bit mask for any of the scale flag bits.'''
        raise NotImplementedError()

    @property
    def TYPE_FLIP(self) -> int:
        '''This flag bit indicates that the transform defined by this object
        performs a mirror image flip about some axis which changes the
        normally right handed coordinate system into a left handed
        system in addition to the conversions indicated by other flag bits.
        A right handed coordinate system is one where the positive X
        axis rotates counterclockwise to overlay the positive Y axis
        similar to the direction that the fingers on your right hand
        curl when you stare end on at your thumb.
        A left handed coordinate system is one where the positive X
        axis rotates clockwise to overlay the positive Y axis similar
        to the direction that the fingers on your left hand curl.
        There is no mathematical way to determine the angle of the
        original flipping or mirroring transformation since all angles
        of flip are identical given an appropriate adjusting rotation.
        NOTE: TypeFlip was added after GENERAL_TRANSFORM was in public
        circulation and the flag bits could no longer be conveniently
        renumbered without introducing binary incompatibility in outside
        code.'''
        raise NotImplementedError()

    @property
    def TYPE_QUADRANT_ROTATION(self) -> int:
        '''This flag bit indicates that the transform defined by this object
        performs a quadrant rotation by some multiple of 90 degrees in
        addition to the conversions indicated by other flag bits.
        A rotation changes the angles of vectors by the same amount
        regardless of the original direction of the vector and without
        changing the length of the vector.
        This flag bit is mutually exclusive with the TypeGeneralRotation flag.'''
        raise NotImplementedError()

    @property
    def TYPE_GENERAL_ROTATION(self) -> int:
        '''This flag bit indicates that the transform defined by this object
        performs a rotation by an arbitrary angle in addition to the
        conversions indicated by other flag bits.
        A rotation changes the angles of vectors by the same amount
        regardless of the original direction of the vector and without
        changing the length of the vector.
        This flag bit is mutually exclusive with the'''
        raise NotImplementedError()

    @property
    def TYPE_MASK_ROTATION(self) -> int:
        '''This constant is a bit mask for any of the rotation flag bits.'''
        raise NotImplementedError()

    @property
    def TYPE_GENERAL_TRANSFORM(self) -> int:
        '''This constant indicates that the transform defined by this object
        performs an arbitrary conversion of the input coordinates.
        If this transform can be classified by any of the above constants,
        the type will either be the constant TypeIdentity or a
        combination of the appropriate flag bits for the various coordinate
        conversions that this transform performs.'''
        raise NotImplementedError()


class Metered:
    '''Provides metered methods for integration'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of this class.'''
        raise NotImplementedError()
    
    def set_metered_key(self, public_key : str, private_key : str) -> None:
        '''Sets metered public and private key.
        If you purchase metered license, when start application, this API should be called, normally, this is enough.
        However, if always fail to upload consumption data and exceed 24 hours, the license will be set to evaluation status,
        to avoid such case, you should regularly check the license status, if it is evaluation status, call this API again.
        
        :param public_key: public key
        :param private_key: private key'''
        raise NotImplementedError()
    
    @staticmethod
    def get_consumption_quantity() -> System.Decimal:
        '''Gets consumption file size
        
        :returns: consumption quantity'''
        raise NotImplementedError()
    
    @staticmethod
    def get_consumption_credit() -> System.Decimal:
        '''Gets consumption credit
        
        :returns: consumption quantity'''
        raise NotImplementedError()
    

class NonGenericDictionary:
    '''Represents a non generic dictionary.'''
    
    def remove(self, key : Any) -> None:
        '''Removes the element with the specified key from the
        :py:class:`dict` object.
        
        :param key: The key of the element to remove.'''
        raise NotImplementedError()
    
    def add(self, key : Any, value : Any) -> None:
        '''Adds an element with the provided key and value to the
        :py:class:`dict` object.
        
        :param key: The
        :py:class:`Any` to use as the key of the element to add.
        :param value: The
        :py:class:`Any` to use as the value of the element to add.'''
        raise NotImplementedError()
    
    def clear(self) -> None:
        '''Removes all elements from the
        :py:class:`dict` object.'''
        raise NotImplementedError()
    
    @property
    def is_fixed_size(self) -> bool:
        '''Gets a value indicating whether the
        :py:class:`dict` object has a fixed size.'''
        raise NotImplementedError()
    
    @property
    def is_read_only(self) -> bool:
        '''Gets a value indicating whether the
        :py:class:`dict` object is read-only.'''
        raise NotImplementedError()
    
    @property
    def keys(self) -> List[Any]:
        '''Gets an
        :py:class:`List[Any]` object containing the keys of the
        :py:class:`dict` object.'''
        raise NotImplementedError()
    
    @property
    def values(self) -> List[Any]:
        '''Gets an
        :py:class:`List[Any]` object containing the values in the
        :py:class:`dict` object.'''
        raise NotImplementedError()
    

class NonGenericList:
    '''Non generic list of objects'''
    
    def __init__(self, list : List[Any]) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.NonGenericList` class.
        
        :param list: The list - container of objects.'''
        raise NotImplementedError()
    

class ObjectWithBounds:
    '''The object having bounds.'''
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix, pen : aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object\'s bounds size.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    def transform(self, transform : aspose.imaging.Matrix) -> None:
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.'''
        raise NotImplementedError()
    

class OpenTypeFontsCache:
    '''Cache for OpenType fonts that are installed in the system.'''
    
    @staticmethod
    def update_cache() -> None:
        ''''''
        raise NotImplementedError()
    

class Pen(TransparencySupporter):
    '''Defines an object used to draw lines, curves and figures.'''
    
    @overload
    def __init__(self, color : aspose.imaging.Color) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified color.
        
        :param color: A :py:attr:`aspose.imaging.Pen.color` structure that indicates the color of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, color : aspose.imaging.Color, width : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified :py:attr:`aspose.imaging.Pen.color` and :py:attr:`aspose.imaging.Pen.width` properties.
        
        :param color: A :py:attr:`aspose.imaging.Pen.color` structure that indicates the color of this :py:class:`aspose.imaging.Pen`.
        :param width: A value indicating the width of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, brush : aspose.imaging.Brush) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified :py:attr:`aspose.imaging.Pen.brush`.
        
        :param brush: A :py:attr:`aspose.imaging.Pen.brush` that determines the fill properties of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, brush : aspose.imaging.Brush, width : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified :py:attr:`aspose.imaging.Pen.brush` and :py:attr:`aspose.imaging.Pen.width`.
        
        :param brush: A :py:attr:`aspose.imaging.Pen.brush` that determines the characteristics of this :py:class:`aspose.imaging.Pen`.
        :param width: The width of the new :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @overload
    def multiply_transform(self, matrix : aspose.imaging.Matrix) -> None:
        '''Multiplies the transformation matrix for this :py:class:`aspose.imaging.Pen` by the specified :py:class:`aspose.imaging.Matrix`.
        
        :param matrix: The :py:class:`aspose.imaging.Matrix` object by which to multiply the transformation matrix.'''
        raise NotImplementedError()
    
    @overload
    def multiply_transform(self, matrix : aspose.imaging.Matrix, order : aspose.imaging.MatrixOrder) -> None:
        '''Multiplies the transformation matrix for this :py:class:`aspose.imaging.Pen` by the specified :py:class:`aspose.imaging.Matrix` in the specified order.
        
        :param matrix: The :py:class:`aspose.imaging.Matrix` by which to multiply the transformation matrix.
        :param order: The order in which to perform the multiplication operation.'''
        raise NotImplementedError()
    
    @overload
    def translate_transform(self, dx : float, dy : float) -> None:
        '''Translates the local geometric transformation by the specified dimensions. This method prepends the translation to the transformation.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.'''
        raise NotImplementedError()
    
    @overload
    def translate_transform(self, dx : float, dy : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Translates the local geometric transformation by the specified dimensions in the specified order.
        
        :param dx: The value of the translation in x.
        :param dy: The value of the translation in y.
        :param order: The order (prepend or append) in which to apply the translation.'''
        raise NotImplementedError()
    
    @overload
    def scale_transform(self, sx : float, sy : float) -> None:
        '''Scales the local geometric transformation by the specified factors. This method prepends the scaling matrix to the transformation.
        
        :param sx: The factor by which to scale the transformation in the x-axis direction.
        :param sy: The factor by which to scale the transformation in the y-axis direction.'''
        raise NotImplementedError()
    
    @overload
    def scale_transform(self, sx : float, sy : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Scales the local geometric transformation by the specified factors in the specified order.
        
        :param sx: The factor by which to scale the transformation in the x-axis direction.
        :param sy: The factor by which to scale the transformation in the y-axis direction.
        :param order: A :py:class:`aspose.imaging.MatrixOrder` that specifies whether to append or prepend the scaling matrix.'''
        raise NotImplementedError()
    
    @overload
    def rotate_transform(self, angle : float) -> None:
        '''Rotates the local geometric transformation by the specified angle. This method prepends the rotation to the transformation.
        
        :param angle: The angle of rotation.'''
        raise NotImplementedError()
    
    @overload
    def rotate_transform(self, angle : float, order : aspose.imaging.MatrixOrder) -> None:
        '''Rotates the local geometric transformation by the specified angle in the specified order.
        
        :param angle: The angle of rotation.
        :param order: A :py:class:`aspose.imaging.MatrixOrder` that specifies whether to append or prepend the rotation matrix.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_color(color : aspose.imaging.Color) -> aspose.imaging.Pen:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified color.
        
        :param color: A :py:attr:`aspose.imaging.Pen.color` structure that indicates the color of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_color_width(color : aspose.imaging.Color, width : float) -> aspose.imaging.Pen:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified :py:attr:`aspose.imaging.Pen.color` and :py:attr:`aspose.imaging.Pen.width` properties.
        
        :param color: A :py:attr:`aspose.imaging.Pen.color` structure that indicates the color of this :py:class:`aspose.imaging.Pen`.
        :param width: A value indicating the width of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_brush(brush : aspose.imaging.Brush) -> aspose.imaging.Pen:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified :py:attr:`aspose.imaging.Pen.brush`.
        
        :param brush: A :py:attr:`aspose.imaging.Pen.brush` that determines the fill properties of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_brush_width(brush : aspose.imaging.Brush, width : float) -> aspose.imaging.Pen:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Pen` class with the specified :py:attr:`aspose.imaging.Pen.brush` and :py:attr:`aspose.imaging.Pen.width`.
        
        :param brush: A :py:attr:`aspose.imaging.Pen.brush` that determines the characteristics of this :py:class:`aspose.imaging.Pen`.
        :param width: The width of the new :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    def set_line_cap(self, start_cap : aspose.imaging.LineCap, end_cap : aspose.imaging.LineCap, dash_cap : aspose.imaging.DashCap) -> None:
        '''Sets the values that determine the style of cap used to end lines drawn by this :py:class:`aspose.imaging.Pen`.
        
        :param start_cap: A :py:class:`aspose.imaging.LineCap` that represents the cap style to use at the beginning of lines drawn with this :py:class:`aspose.imaging.Pen`.
        :param end_cap: A :py:class:`aspose.imaging.LineCap` that represents the cap style to use at the end of lines drawn with this :py:class:`aspose.imaging.Pen`.
        :param dash_cap: A :py:class:`aspose.imaging.LineCap` that represents the cap style to use at the beginning or end of dashed lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    def reset_transform(self) -> None:
        '''Resets the geometric transformation matrix for this :py:class:`aspose.imaging.Pen` to identity.'''
        raise NotImplementedError()
    
    @property
    def opacity(self) -> float:
        '''Gets the object\'s opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        raise NotImplementedError()
    
    @opacity.setter
    def opacity(self, value : float) -> None:
        '''Sets the object\'s opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Gets the width of this :py:class:`aspose.imaging.Pen`, in units of the Graphics object used for drawing.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : float) -> None:
        '''Sets the width of this :py:class:`aspose.imaging.Pen`, in units of the Graphics object used for drawing.'''
        raise NotImplementedError()
    
    @property
    def start_cap(self) -> aspose.imaging.LineCap:
        '''Gets the cap style used at the beginning of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @start_cap.setter
    def start_cap(self, value : aspose.imaging.LineCap) -> None:
        '''Sets the cap style used at the beginning of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def end_cap(self) -> aspose.imaging.LineCap:
        '''Gets the cap style used at the end of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @end_cap.setter
    def end_cap(self, value : aspose.imaging.LineCap) -> None:
        '''Sets the cap style used at the end of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def dash_cap(self) -> aspose.imaging.DashCap:
        '''Gets the cap style used at the end of the dashes that make up dashed lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @dash_cap.setter
    def dash_cap(self, value : aspose.imaging.DashCap) -> None:
        '''Sets the cap style used at the end of the dashes that make up dashed lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def line_join(self) -> aspose.imaging.LineJoin:
        '''Gets the join style for the ends of two consecutive lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @line_join.setter
    def line_join(self, value : aspose.imaging.LineJoin) -> None:
        '''Sets the join style for the ends of two consecutive lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def custom_start_cap(self) -> aspose.imaging.CustomLineCap:
        '''Gets a custom cap to use at the beginning of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @custom_start_cap.setter
    def custom_start_cap(self, value : aspose.imaging.CustomLineCap) -> None:
        '''Sets a custom cap to use at the beginning of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def custom_end_cap(self) -> aspose.imaging.CustomLineCap:
        '''Gets a custom cap to use at the end of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @custom_end_cap.setter
    def custom_end_cap(self, value : aspose.imaging.CustomLineCap) -> None:
        '''Sets a custom cap to use at the end of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def miter_limit(self) -> float:
        '''Gets the limit of the thickness of the join on a mitered corner.'''
        raise NotImplementedError()
    
    @miter_limit.setter
    def miter_limit(self, value : float) -> None:
        '''Sets the limit of the thickness of the join on a mitered corner.'''
        raise NotImplementedError()
    
    @property
    def alignment(self) -> aspose.imaging.PenAlignment:
        '''Gets the alignment for this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @alignment.setter
    def alignment(self, value : aspose.imaging.PenAlignment) -> None:
        '''Sets the alignment for this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def transform(self) -> aspose.imaging.Matrix:
        '''Gets a copy of the geometric transformation for this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @transform.setter
    def transform(self, value : aspose.imaging.Matrix) -> None:
        '''Sets a copy of the geometric transformation for this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def pen_type(self) -> aspose.imaging.PenType:
        '''Gets the style of lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.imaging.Color:
        '''Gets the color of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.imaging.Color) -> None:
        '''Sets the color of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def brush(self) -> aspose.imaging.Brush:
        '''Gets the :py:attr:`aspose.imaging.Pen.brush` that determines attributes of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @brush.setter
    def brush(self, value : aspose.imaging.Brush) -> None:
        '''Sets the :py:attr:`aspose.imaging.Pen.brush` that determines attributes of this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def dash_style(self) -> aspose.imaging.DashStyle:
        '''Gets the style used for dashed lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @dash_style.setter
    def dash_style(self, value : aspose.imaging.DashStyle) -> None:
        '''Sets the style used for dashed lines drawn with this :py:class:`aspose.imaging.Pen`.'''
        raise NotImplementedError()
    
    @property
    def dash_offset(self) -> float:
        '''Gets the distance from the start of a line to the beginning of a dash pattern.'''
        raise NotImplementedError()
    
    @dash_offset.setter
    def dash_offset(self, value : float) -> None:
        '''Sets the distance from the start of a line to the beginning of a dash pattern.'''
        raise NotImplementedError()
    
    @property
    def dash_pattern(self) -> List[float]:
        '''Gets an array of custom dashes and spaces.'''
        raise NotImplementedError()
    
    @dash_pattern.setter
    def dash_pattern(self, value : List[float]) -> None:
        '''Sets an array of custom dashes and spaces.'''
        raise NotImplementedError()
    
    @property
    def compound_array(self) -> List[float]:
        '''Gets an array of values that specifies a compound pen. A compound pen draws a compound line made up of parallel lines and spaces.'''
        raise NotImplementedError()
    
    @compound_array.setter
    def compound_array(self, value : List[float]) -> None:
        '''Sets an array of values that specifies a compound pen. A compound pen draws a compound line made up of parallel lines and spaces.'''
        raise NotImplementedError()
    

class PixelDataFormat:
    '''The pixel data format. This is an immutable object.'''
    
    @overload
    @staticmethod
    def get_grayscale_alpha(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets GrayscaleAlpha color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The GrayscaleAlpha color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_grayscale_alpha(bits_per_sample : int, alpha_channel_bits : int) -> aspose.imaging.PixelDataFormat:
        '''Gets GrayscaleAlpha color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :param alpha_channel_bits: The number of bits per sample in the alpha channel.
        :returns: The GrayscaleAlpha color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_rgb(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGB color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The RGB color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_rgb(bits_per_red_channel : int, bits_per_green_channel : int, bits_per_blue_channel : int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGB color with a specified number of bits per sample.
        
        :param bits_per_red_channel: The number of bits per Red channel.
        :param bits_per_green_channel: The number of bits per Green channel.
        :param bits_per_blue_channel: The number of bits per Blue channel.
        :returns: The RGB color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_rgba(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGBA color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The RGBA color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_rgba(bits_per_red_channel : int, bits_per_green_channel : int, bits_per_blue_channel : int, bits_per_alpha_channel : int) -> aspose.imaging.PixelDataFormat:
        '''Gets RGBA color with a specified number of bits per sample.
        
        :param bits_per_red_channel: The number of bits per Red channel.
        :param bits_per_green_channel: The number of bits per Green channel.
        :param bits_per_blue_channel: The number of bits per Blue channel.
        :param bits_per_alpha_channel: The number of bits per Alpha channel.
        :returns: The RGBA color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_y_cb_cr(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets YCbCr color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The YCbCr color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_y_cb_cr(bits_per_y : int, bits_per_cb : int, bits_per_cr : int) -> aspose.imaging.PixelDataFormat:
        '''Gets YCbCr color with a specified number of bits per sample.
        
        :param bits_per_y: The number of bits per Y channel.
        :param bits_per_cb: The number of bits per Cb channel.
        :param bits_per_cr: The number of bits per Cr channel.
        :returns: The YCbCr color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_cmyk(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets CMYK color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The CMYK color.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_cmyk(bits_per_cyan_channel : int, bits_per_magenta_channel : int, bits_per_yellow_channel : int, bits_per_key_channel : int) -> aspose.imaging.PixelDataFormat:
        '''Gets CMYK color with a specified number of bits per sample.
        
        :param bits_per_cyan_channel: The number of bits per Cyan channel.
        :param bits_per_magenta_channel: The number of bits per Magenta channel.
        :param bits_per_yellow_channel: The number of bits per Yellow channel.
        :param bits_per_key_channel: The number of bits per Key channel.
        :returns: The CMYK color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_grayscale(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets Grayscale color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The Grayscale color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_rgb_indexed(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets BGRA indexed color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The BGRA color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_bgra(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets BGRA color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The BGRA color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_bgr(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets BGR color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The BGR color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_cmyka(bits_per_cyan_channel : int, bits_per_magenta_channel : int, bits_per_yellow_channel : int, bits_per_key_channel : int, bits_per_alpha_channel : int) -> aspose.imaging.PixelDataFormat:
        '''Gets CMYKA color with a specified number of bits per sample.
        
        :param bits_per_cyan_channel: The number of bits per Cyan channel.
        :param bits_per_magenta_channel: The number of bits per Magenta channel.
        :param bits_per_yellow_channel: The number of bits per Yellow channel.
        :param bits_per_key_channel: The number of bits per Key channel.
        :param bits_per_alpha_channel: The number of bits per Alpha channel.
        :returns: The CMYK color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_ycck(bits_per_sample : int) -> aspose.imaging.PixelDataFormat:
        '''Gets YCCK color with a specified number of bits per sample.
        
        :param bits_per_sample: The number of bits per sample.
        :returns: The YCCK color.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_cie_lab(bits_per_l : int, bits_per_a : int, bits_per_b : int) -> aspose.imaging.PixelDataFormat:
        '''Gets CIE Lab color with a specified number of bits per sample.
        
        :param bits_per_l: The number of bits per L channel.
        :param bits_per_a: The number of bits per A channel.
        :param bits_per_b: The number of bits per B channel.
        :returns: The CIE Lab color.'''
        raise NotImplementedError()
    
    @property
    def rgb_32_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 32 bits per pixel with 8 bits for each of the alpha, red, green and blue.'''
        raise NotImplementedError()

    @property
    def cmyk(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 32 bits per pixel with 8 bits for each of the cyan, magenta, yellow and black.'''
        raise NotImplementedError()

    @property
    def cmyka(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the acmyk.'''
        raise NotImplementedError()

    @property
    def rgb_24_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 24 bits per pixel with 8 bits for each of the alpha, red, green and blue, alpha is not defined.'''
        raise NotImplementedError()

    @property
    def rgb_16_bpp_555(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 16 bits per pixel with 5 bits for each of the red, green and blue, alpha is not defined.'''
        raise NotImplementedError()

    @property
    def rgb_16_bpp_565(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 16 bits per pixel with 5 bits for red, 6 bits for green and 5 bits for blue, alpha is not defined.'''
        raise NotImplementedError()

    @property
    def rgb_indexed_8_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for indexed 8 bit per color.
        The indexed pixel data storage is intended to allow data storage and retrieval everywhere the color palette is used.
        Use with caution, because may require conversion from one palette to another or from RGBA to indexed color model.'''
        raise NotImplementedError()

    @property
    def rgb_indexed_4_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for indexed 4 bit per color.
        The indexed pixel data storage is intended to allow data storage and retrieval everywhere the color palette is used.
        Use with caution, because may require conversion from one palette to another or from RGBA to indexed color model.'''
        raise NotImplementedError()

    @property
    def rgb_indexed_2_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for indexed 2 bit per color.
        The indexed pixel data storage is intended to allow data storage and retrieval everywhere the color palette is used.
        Use with caution, because may require conversion from one palette to another or from RGBA to indexed color model.'''
        raise NotImplementedError()

    @property
    def rgb_indexed_1_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for indexed 1 bit per color.
        The indexed pixel data storage is intended to allow data storage and retrieval everywhere the color palette is used.
        Use with caution, because may require conversion from one palette to another or from RGBA to indexed color model.'''
        raise NotImplementedError()

    @property
    def y_cb_cr(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 24 bits per pixel with 8 bits for each of the luma, blue-difference and red-difference chroma components.'''
        raise NotImplementedError()

    @property
    def ycck(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 32 bits per pixel with 8 bits for each of the luma, blue-difference, red-difference and black chroma components.'''
        raise NotImplementedError()

    @property
    def rgba_32_bpp(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 32 bits per pixel with 8 bits for each of the alpha, red, green and blue.'''
        raise NotImplementedError()

    @property
    def rgb_24_bpp_png(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 24 bits per pixel with 8 bits for each of the alpha, red, green and blue, alpha is not defined.'''
        raise NotImplementedError()

    @property
    def grayscale_alpha(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 16 bits per pixel with 8 bits representing grayscale intensity in the 0-255 interval and additional 8 bit alpha component.'''
        raise NotImplementedError()

    @property
    def pixel_format(self) -> aspose.imaging.PixelFormat:
        '''Gets the pixel format.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the bits per pixel.'''
        raise NotImplementedError()
    
    @property
    def channels_count(self) -> int:
        '''Gets the channels count.'''
        raise NotImplementedError()
    
    @property
    def channel_bits(self) -> List[int]:
        '''Gets the bits count for each channel.'''
        raise NotImplementedError()
    
    @property
    def caption(self) -> str:
        '''Gets the pixel data format caption.'''
        raise NotImplementedError()
    
    @property
    def GRAYSCALE16(self) -> aspose.imaging.PixelDataFormat:
        '''Defined for 16 bits per pixel with up to 16 bits representing grayscale intensity.'''
        raise NotImplementedError()

    @staticmethod
    def set_grayscale(value: aspose.imaging.PixelDataFormat) -> None:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 8 bits per pixel with 8 bits representing grayscale intensity in the 0-255 interval.'''
    @property
    def grayscale(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the :py:class:`aspose.imaging.PixelDataFormat` defined for 8 bits per pixel with 8 bits representing grayscale intensity in the 0-255 interval.'''
        raise NotImplementedError()


class Point:
    '''Represents an ordered pair of integer x- and y-coordinates that defines a point in a two-dimensional plane.'''
    
    @overload
    def __init__(self, x : int, y : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Point` structure with the specified coordinates.
        
        :param x: The horizontal position of the point.
        :param y: The vertical position of the point.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, size : aspose.imaging.Size) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Point` structure from the :py:class:`aspose.imaging.Size` structure.
        
        :param size: Contains the new point coordinates.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, dw : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Point` structure using coordinates specified by an integer value.
        
        :param dw: A 32-bit integer that specifies the coordinates for the new point.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    def offset(self, point : aspose.imaging.Point) -> None:
        '''Translates this :py:class:`aspose.imaging.Point` by the specified :py:class:`aspose.imaging.Point`.
        
        :param point: The :py:class:`aspose.imaging.Point` used to offset this :py:class:`aspose.imaging.Point`.'''
        raise NotImplementedError()
    
    @overload
    def offset(self, dx : int, dy : int) -> None:
        '''Translates this :py:class:`aspose.imaging.Point` by the specified amount.
        
        :param dx: The amount to offset the x-coordinate.
        :param dy: The amount to offset the y-coordinate.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_size(size : aspose.imaging.Size) -> aspose.imaging.Point:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Point` structure from the :py:class:`aspose.imaging.Size` structure.
        
        :param size: Contains the new point coordinates.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_d_word(dw : int) -> aspose.imaging.Point:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Point` structure using coordinates specified by an integer value.
        
        :param dw: A 32-bit integer that specifies the coordinates for the new point.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_long(packed_point : int, x : List[int], y : List[int]) -> None:
        '''Deconstruct a Point object packed into a long object to separate X and Y int values.
        
        :param packed_point: The Point object packed into one long value.
        :param x: The extracted from the packed Point X value.
        :param y: The extracted from the packed Point Y value.'''
        raise NotImplementedError()
    
    @staticmethod
    def add(point : aspose.imaging.Point, size : aspose.imaging.Size) -> aspose.imaging.Point:
        '''Adds the specified :py:class:`aspose.imaging.Size` to the specified :py:class:`aspose.imaging.Point`.
        
        :param point: The :py:class:`aspose.imaging.Point` to add to.
        :param size: The :py:class:`aspose.imaging.Size` to add to the ``point``.
        :returns: The :py:class:`aspose.imaging.Point` that is the result of the addition operation.'''
        raise NotImplementedError()
    
    @staticmethod
    def subtract(point : aspose.imaging.Point, size : aspose.imaging.Size) -> aspose.imaging.Point:
        '''Returns the result of subtracting specified :py:class:`aspose.imaging.Size` from the specified :py:class:`aspose.imaging.Point`.
        
        :param point: The :py:class:`aspose.imaging.Point` to be subtracted from.
        :param size: The :py:class:`aspose.imaging.Size` to subtract from the ``point``.
        :returns: The :py:class:`aspose.imaging.Point` that is the result of the subtraction operation.'''
        raise NotImplementedError()
    
    @staticmethod
    def ceiling(point : aspose.imaging.PointF) -> aspose.imaging.Point:
        '''Converts the specified :py:class:`aspose.imaging.PointF` to a :py:class:`aspose.imaging.Point` by rounding the values of the :py:class:`aspose.imaging.PointF` to the next higher integer values.
        
        :param point: The :py:class:`aspose.imaging.PointF` to convert.
        :returns: The :py:class:`aspose.imaging.Point` this method converts to.'''
        raise NotImplementedError()
    
    @staticmethod
    def round(point : aspose.imaging.PointF) -> aspose.imaging.Point:
        '''Converts the specified :py:class:`aspose.imaging.PointF` to a :py:class:`aspose.imaging.Point` object by rounding the :py:class:`aspose.imaging.Point` values to the nearest integer.
        
        :param point: The :py:class:`aspose.imaging.PointF` to convert.
        :returns: The :py:class:`aspose.imaging.Point` this method converts to.'''
        raise NotImplementedError()
    
    @staticmethod
    def truncate(point : aspose.imaging.PointF) -> aspose.imaging.Point:
        '''Converts the specified :py:class:`aspose.imaging.PointF` to a :py:class:`aspose.imaging.Point` by truncating the values of the :py:class:`aspose.imaging.Point`.
        
        :param point: The :py:class:`aspose.imaging.PointF` to convert.
        :returns: The :py:class:`aspose.imaging.Point` this method converts to.'''
        raise NotImplementedError()
    
    def to_long(self) -> int:
        '''Convert this Point to a single long value, containing X and Y coordinates in high and low bits.
        
        :returns: The Point object packed into one long value.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.Point:
        '''Gets a new instance of the :py:class:`aspose.imaging.Point` structure that has :py:attr:`aspose.imaging.Point.x` and :py:attr:`aspose.imaging.Point.y` values set to zero.'''
        raise NotImplementedError()

    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Point` is empty.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x-coordinate of this :py:class:`aspose.imaging.Point`.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x-coordinate of this :py:class:`aspose.imaging.Point`.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y-coordinate of this :py:class:`aspose.imaging.Point`.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y-coordinate of this :py:class:`aspose.imaging.Point`.'''
        raise NotImplementedError()
    

class PointF:
    '''Represents an ordered pair of floating-point x- and y-coordinates that defines a point in a two-dimensional plane.'''
    
    @overload
    def __init__(self, x : float, y : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.PointF` structure with the specified coordinates.
        
        :param x: The horizontal position of the point.
        :param y: The vertical position of the point.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def add(point : aspose.imaging.PointF, size : aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a given :py:class:`aspose.imaging.PointF` by the specified :py:class:`aspose.imaging.Size`.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.Size` that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def add(point : aspose.imaging.PointF, size : aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a given :py:class:`aspose.imaging.PointF` by a specified :py:class:`aspose.imaging.SizeF`.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.SizeF` that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def subtract(point : aspose.imaging.PointF, size : aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a :py:class:`aspose.imaging.PointF` by the negative of a specified size.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.Size` that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def subtract(point : aspose.imaging.PointF, size : aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a :py:class:`aspose.imaging.PointF` by the negative of a specified size.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.SizeF` that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def add_size(point : aspose.imaging.PointF, size : aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a given :py:class:`aspose.imaging.PointF` by the specified :py:class:`aspose.imaging.Size`.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.Size` that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def subtract_size(point : aspose.imaging.PointF, size : aspose.imaging.Size) -> aspose.imaging.PointF:
        '''Translates a :py:class:`aspose.imaging.PointF` by the negative of a specified size.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.Size` that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def add_size_f(point : aspose.imaging.PointF, size : aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a given :py:class:`aspose.imaging.PointF` by a specified :py:class:`aspose.imaging.SizeF`.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.SizeF` that specifies the numbers to add to the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def subtract_size_f(point : aspose.imaging.PointF, size : aspose.imaging.SizeF) -> aspose.imaging.PointF:
        '''Translates a :py:class:`aspose.imaging.PointF` by the negative of a specified size.
        
        :param point: The :py:class:`aspose.imaging.PointF` to translate.
        :param size: The :py:class:`aspose.imaging.SizeF` that specifies the numbers to subtract from the coordinates of ``point``.
        :returns: The translated :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.PointF:
        '''Gets a new instance of the :py:class:`aspose.imaging.PointF` structure that has :py:attr:`aspose.imaging.PointF.x` and :py:attr:`aspose.imaging.PointF.y` values set to zero.'''
        raise NotImplementedError()

    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.PointF` is empty.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> float:
        '''Gets the x-coordinate of this :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : float) -> None:
        '''Sets the x-coordinate of this :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> float:
        '''Gets the y-coordinate of this :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : float) -> None:
        '''Sets the y-coordinate of this :py:class:`aspose.imaging.PointF`.'''
        raise NotImplementedError()
    

class RasterCachedImage(RasterImage):
    '''Represents a raster image supporting raster graphics operations. This image caches pixel data when required.'''
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self) -> None:
        '''Saves the image data to the underlying stream.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int, pixels : List[int]) -> aspose.imaging.Image:
        '''Creates a :py:class:`aspose.imaging.RasterImage` instance from the provided pixel array.
        
        Validates that the specified width and height match the dimensions of the pixel data.
        This method can only be used when the library is in Licensed mode.
        
        :param image_options: The options used to create the :py:class:`aspose.imaging.RasterImage`.
        :param width: The width of the :py:class:`aspose.imaging.RasterImage`.
        :param height: The height of the :py:class:`aspose.imaging.RasterImage`.
        :param pixels: The array of pixel values used to populate the image.
        :returns: A :py:class:`aspose.imaging.RasterImage` populated with the provided pixel data.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(multipage_create_options : aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(file_path : str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, pixels : List[int], width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int) -> None:
        '''Resizes the image. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int) -> None:
        '''Resizes the width proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int) -> None:
        '''Resizes the height proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float, resize_proportionally : bool, background_color : aspose.imaging.Color) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, rectangle : aspose.imaging.Rectangle) -> None:
        '''Cropping the image.
        
        :param rectangle: The rectangle.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, left_shift : int, right_shift : int, top_shift : int, bottom_shift : int) -> None:
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        raise NotImplementedError()
    
    @overload
    def dither(self, dithering_method : aspose.imaging.DitheringMethod, bits_count : int, custom_palette : aspose.imaging.IColorPalette) -> None:
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.
        :param custom_palette: The custom palette for dithering.'''
        raise NotImplementedError()
    
    @overload
    def dither(self, dithering_method : aspose.imaging.DitheringMethod, bits_count : int) -> None:
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.'''
        raise NotImplementedError()
    
    @overload
    def get_default_raw_data(self, rectangle : aspose.imaging.Rectangle, partial_raw_data_loader : aspose.imaging.IPartialRawDataLoader, raw_data_settings : aspose.imaging.RawDataSettings) -> None:
        '''Gets the default raw data array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_raw_data_loader: The partial raw data loader.
        :param raw_data_settings: The raw data settings.'''
        raise NotImplementedError()
    
    @overload
    def get_default_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings) -> List[int]:
        '''Gets the default raw data array.
        
        :param rectangle: The rectangle to get raw data for.
        :param raw_data_settings: The raw data settings.
        :returns: The default raw data array.'''
        raise NotImplementedError()
    
    @overload
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @overload
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, dest_image_bounds : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param dest_image_bounds: The dest image bounds.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @overload
    def binarize_bradley(self, brightness_difference : float, window_size : int) -> None:
        '''Binarization of an image using Bradley\'s adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.
        :param window_size: The size of s x s window of pixels centered around this pixel'''
        raise NotImplementedError()
    
    @overload
    def binarize_bradley(self, brightness_difference : float) -> None:
        '''Binarization of an image using Bradley\'s adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.'''
        raise NotImplementedError()
    
    @overload
    def blend(self, origin : aspose.imaging.Point, overlay : aspose.imaging.RasterImage, overlay_area : aspose.imaging.Rectangle, overlay_alpha : int) -> None:
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_area: The overlay area.
        :param overlay_alpha: The overlay alpha.'''
        raise NotImplementedError()
    
    @overload
    def blend(self, origin : aspose.imaging.Point, overlay : aspose.imaging.RasterImage, overlay_alpha : int) -> None:
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_alpha: The overlay alpha.'''
        raise NotImplementedError()
    
    @overload
    def adjust_gamma(self, gamma_red : float, gamma_green : float, gamma_blue : float) -> None:
        '''Gamma-correction of an image.
        
        :param gamma_red: Gamma for red channel coefficient
        :param gamma_green: Gamma for green channel coefficient
        :param gamma_blue: Gamma for blue channel coefficient'''
        raise NotImplementedError()
    
    @overload
    def adjust_gamma(self, gamma : float) -> None:
        '''Gamma-correction of an image.
        
        :param gamma: Gamma for red, green and blue channels coefficient'''
        raise NotImplementedError()
    
    @overload
    def normalize_angle(self) -> None:
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses :py:func:`aspose.imaging.RasterImage.get_skew_angle` and :py:func:`aspose.imaging.RasterImage.rotate` methods.'''
        raise NotImplementedError()
    
    @overload
    def normalize_angle(self, resize_proportionally : bool, background_color : aspose.imaging.Color) -> None:
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses :py:func:`aspose.imaging.RasterImage.get_skew_angle` and :py:func:`aspose.imaging.RasterImage.rotate` methods.
        
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        raise NotImplementedError()
    
    @overload
    def replace_color(self, old_color : aspose.imaging.Color, old_color_diff : int, new_color : aspose.imaging.Color) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color: Old color to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color: New color to replace old color with.'''
        raise NotImplementedError()
    
    @overload
    def replace_color(self, old_color_argb : int, old_color_diff : int, new_color_argb : int) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        raise NotImplementedError()
    
    @overload
    def replace_non_transparent_colors(self, new_color : aspose.imaging.Color) -> None:
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color: New color to replace non transparent colors with.'''
        raise NotImplementedError()
    
    @overload
    def replace_non_transparent_colors(self, new_color_argb : int) -> None:
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color_argb: New color ARGB value to replace non transparent colors with.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data and ensures no additional data loading will be performed from the underlying :py:attr:`aspose.imaging.DataStreamSupporter.data_stream_container`.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_file_format_of_stream(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_width(width : int, height : int, new_height : int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_height(width : int, height : int, new_width : int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        raise NotImplementedError()
    
    def remove_metadata(self) -> None:
        '''Removes this image instance metadata by setting this :py:attr:`aspose.imaging.xmp.IHasXmpData.xmp_data` value to .'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type; otherwise, false.'''
        raise NotImplementedError()
    
    def can_save(self, options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def resize_by_type(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    def resize_by_settings(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    def get_default_options(self, args : List[Any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        raise NotImplementedError()
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        :py:func:`aspose.imaging.DataStreamSupporter.save` method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the :py:func:`aspose.imaging.Image.save` method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        raise NotImplementedError()
    
    def resize_width_proportionally_settings(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def resize_height_proportionally_settings(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def rotate_flip(self, rotate_flip_type : aspose.imaging.RotateFlipType) -> None:
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: The rotate flip type.'''
        raise NotImplementedError()
    
    def save_with_options(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    def save_with_options_rect(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options_rect(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    def get_serialized_stream(self, image_options : aspose.imaging.ImageOptionsBase, clipping_rectangle : aspose.imaging.Rectangle, page_number : List[int]) -> io._IOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        raise NotImplementedError()
    
    def set_palette(self, palette : aspose.imaging.IColorPalette, update_colors : bool) -> None:
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        raise NotImplementedError()
    
    def get_modify_date(self, use_default : bool) -> datetime:
        '''Gets the date and time the resource image was last modified.
        
        :param use_default: if set to ``true`` uses the information from FileInfo as default value.
        :returns: The date and time the resource image was last modified.'''
        raise NotImplementedError()
    
    def get_default_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Gets the default pixels array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_pixel_loader: The partial pixel loader.'''
        raise NotImplementedError()
    
    def get_default_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Gets the default 32-bit ARGB pixels array.
        
        :param rectangle: The rectangle to get pixels for.
        :returns: The default pixels array.'''
        raise NotImplementedError()
    
    def get_argb_32_pixel(self, x : int, y : int) -> int:
        '''Gets an image 32-bit ARGB pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The 32-bit ARGB pixel for the specified location.'''
        raise NotImplementedError()
    
    def get_pixel(self, x : int, y : int) -> aspose.imaging.Color:
        '''Gets an image pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The pixel color for the specified location.'''
        raise NotImplementedError()
    
    def set_argb_32_pixel(self, x : int, y : int, argb_32_color : int) -> None:
        '''Sets an image 32-bit ARGB pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param argb_32_color: The 32-bit ARGB pixel for the specified position.'''
        raise NotImplementedError()
    
    def set_pixel(self, x : int, y : int, color : aspose.imaging.Color) -> None:
        '''Sets an image pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param color: The pixel color for the specified position.'''
        raise NotImplementedError()
    
    def read_scan_line(self, scan_line_index : int) -> List[aspose.imaging.Color]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line pixel color values array.'''
        raise NotImplementedError()
    
    def read_argb_32_scan_line(self, scan_line_index : int) -> List[int]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line 32-bit ARGB color values array.'''
        raise NotImplementedError()
    
    def write_scan_line(self, scan_line_index : int, pixels : List[aspose.imaging.Color]) -> None:
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param pixels: The pixel colors array to write.'''
        raise NotImplementedError()
    
    def write_argb_32_scan_line(self, scan_line_index : int, argb_32_pixels : List[int]) -> None:
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param argb_32_pixels: The 32-bit ARGB colors array to write.'''
        raise NotImplementedError()
    
    def load_partial_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Loads 32-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 32-bit ARGB pixel loader.'''
        raise NotImplementedError()
    
    def load_partial_pixels(self, desired_rectangle : aspose.imaging.Rectangle, pixel_loader : aspose.imaging.IPartialPixelLoader) -> None:
        '''Loads pixels partially by packs.
        
        :param desired_rectangle: The desired rectangle.
        :param pixel_loader: The pixel loader.'''
        raise NotImplementedError()
    
    def load_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 32-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def load_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads 64-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 64-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def load_partial_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb64PixelLoader) -> None:
        '''Loads 64-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 64-bit ARGB pixel loader.'''
        raise NotImplementedError()
    
    def load_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[aspose.imaging.Color]:
        '''Loads pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded pixels array.'''
        raise NotImplementedError()
    
    def load_cmyk_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[aspose.imaging.CmykColor]:
        '''Loads pixels in CMYK format.
        This method is deprecated. Please use more effective the :py:func:`aspose.imaging.RasterImage.load_cmyk_32_pixels` method.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels array.'''
        raise NotImplementedError()
    
    def load_cmyk_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads pixels in CMYK format.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels presentes as 32-bit inateger values.'''
        raise NotImplementedError()
    
    def save_raw_data(self, data : List[int], data_offset : int, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings) -> None:
        '''Saves the raw data.
        
        :param data: The raw data.
        :param data_offset: The starting raw data offset.
        :param rectangle: The raw data rectangle.
        :param raw_data_settings: The raw data settings the data is in.'''
        raise NotImplementedError()
    
    def save_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[int]) -> None:
        '''Saves the 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The 32-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def save_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.Color]) -> None:
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The pixels array.'''
        raise NotImplementedError()
    
    def save_cmyk_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.CmykColor]) -> None:
        '''Saves the pixels.
        This method is deprecated. Please use more effective the :py:func:`aspose.imaging.RasterImage.save_cmyk_32_pixels` method.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels array.'''
        raise NotImplementedError()
    
    def save_cmyk_32_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[int]) -> None:
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels presented as the 32-bit integer values.'''
        raise NotImplementedError()
    
    def set_resolution(self, dpi_x : float, dpi_y : float) -> None:
        '''Sets the resolution for this :py:class:`aspose.imaging.RasterImage`.
        
        :param dpi_x: The horizontal resolution, in dots per inch, of the :py:class:`aspose.imaging.RasterImage`.
        :param dpi_y: The vertical resolution, in dots per inch, of the :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    def auto_rotate(self) -> None:
        '''Automatically rotates the image based on orientation data extracted from Exif
        metadata. This method ensures that images are displayed in the correct orientation,
        enhancing user experience and eliminating the need for manual adjustments. By
        analyzing Exif information, the image is rotated accordingly, providing a seamless
        viewing experience across different platforms and devices. This automated rotation
        process simplifies image handling and improves overall usability, especially when
        dealing with large batches of images with varying orientations.'''
        raise NotImplementedError()
    
    def binarize_fixed(self, threshold : int) -> None:
        '''Binarization of an image with predefined threshold
        
        :param threshold: Threshold value. If corresponding gray value of a pixel is greater than threshold, a value of 255 will be assigned to it, 0 otherwise.'''
        raise NotImplementedError()
    
    def binarize_otsu(self) -> None:
        '''Binarization of an image with Otsu thresholding'''
        raise NotImplementedError()
    
    def grayscale(self) -> None:
        '''Transformation of an image to its grayscale representation'''
        raise NotImplementedError()
    
    def normalize_histogram(self) -> None:
        '''Normalizes the image histogram — adjust pixel values to use all available range.'''
        raise NotImplementedError()
    
    def auto_brightness_contrast(self) -> None:
        '''Performs automatic adaptive brightness and contrast normalization for the entire image.'''
        raise NotImplementedError()
    
    def adjust_brightness(self, brightness : int) -> None:
        '''Adjust of a brightness for image.
        
        :param brightness: Brightness value.'''
        raise NotImplementedError()
    
    def adjust_contrast(self, contrast : float) -> None:
        '''Image contrasting
        
        :param contrast: Contrast value (in range [-100; 100])'''
        raise NotImplementedError()
    
    def embed_digital_signature(self, password : str) -> None:
        '''Embed digital sign based on provided password into the image using steganography.
        
        :param password: The password used for generate digital sign data'''
        raise NotImplementedError()
    
    def analyze_percentage_digital_signature(self, password : str) -> int:
        '''Calculates the percentage similarity between the extracted data and the original password.
        
        :param password: The password used to extract the embedded data.
        :returns: The percentage similarity value.'''
        raise NotImplementedError()
    
    def is_digital_signed(self, password : str, percentage_threshold : int) -> bool:
        '''Performs a fast check to determine if the image is digitally signed, using the provided password and threshold.
        
        :param password: The password to check the signing.
        :param percentage_threshold: The threshold (in percentage)[0-100] that determines if the image is considered signed.
        If not specified, a default threshold (``75``) will be applied.
        :returns: True if the image is signed, otherwise false.'''
        raise NotImplementedError()
    
    def get_skew_angle(self) -> float:
        '''Gets the skew angle.
        This method is applicable to scanned text documents, to determine the skew angle when scanning.
        
        :returns: The skew angle, in degrees.'''
        raise NotImplementedError()
    
    def filter(self, rectangle : aspose.imaging.Rectangle, options : aspose.imaging.imagefilters.filteroptions.FilterOptionsBase) -> None:
        '''Filters the specified rectangle.
        
        :param rectangle: The rectangle.
        :param options: The options.'''
        raise NotImplementedError()
    
    def replace_argb(self, old_color_argb : int, old_color_diff : int, new_color_argb : int) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether image data is cached currently.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        raise NotImplementedError()
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the :py:class:`aspose.imaging.Image` container.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @property
    def use_palette(self) -> bool:
        '''Gets a value indicating whether the image palette is used.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        '''Gets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor) -> None:
        '''Sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def auto_adjust_palette(self) -> bool:
        '''Gets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool) -> None:
        '''Sets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @property
    def has_background_color(self) -> bool:
        '''Gets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @has_background_color.setter
    def has_background_color(self, value : bool) -> None:
        '''Sets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        '''Gets a value of file format'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a value for the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a value for the background color.'''
        raise NotImplementedError()
    
    @property
    def metadata(self) -> aspose.imaging.metadata.ImageMetadata:
        '''Gets the image metadata.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the Xmp data.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the Xmp data.'''
        raise NotImplementedError()
    
    @property
    def premultiply_components(self) -> bool:
        '''Gets a value indicating whether the image components must be premultiplied.'''
        raise NotImplementedError()
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool) -> None:
        '''Sets a value indicating whether the image components must be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def use_raw_data(self) -> bool:
        '''Gets a value indicating whether to use raw data loading when the raw data loading is available.'''
        raise NotImplementedError()
    
    @use_raw_data.setter
    def use_raw_data(self, value : bool) -> None:
        '''Sets a value indicating whether to use raw data loading when the raw data loading is available.'''
        raise NotImplementedError()
    
    @property
    def update_xmp_data(self) -> bool:
        '''Gets a value indicating whether to update the XMP metadata.'''
        raise NotImplementedError()
    
    @update_xmp_data.setter
    def update_xmp_data(self, value : bool) -> None:
        '''Sets a value indicating whether to update the XMP metadata.'''
        raise NotImplementedError()
    
    @property
    def raw_indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        '''Gets the indexed color converter'''
        raise NotImplementedError()
    
    @raw_indexed_color_converter.setter
    def raw_indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter) -> None:
        '''Sets the indexed color converter'''
        raise NotImplementedError()
    
    @property
    def raw_custom_color_converter(self) -> aspose.imaging.IColorConverter:
        '''Gets the custom color converter'''
        raise NotImplementedError()
    
    @raw_custom_color_converter.setter
    def raw_custom_color_converter(self, value : aspose.imaging.IColorConverter) -> None:
        '''Sets the custom color converter'''
        raise NotImplementedError()
    
    @property
    def raw_fallback_index(self) -> int:
        '''Gets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @raw_fallback_index.setter
    def raw_fallback_index(self, value : int) -> None:
        '''Sets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        '''Gets the current raw data settings. Note when using these settings the data loads without conversion.'''
        raise NotImplementedError()
    
    @property
    def raw_data_format(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the raw data format.'''
        raise NotImplementedError()
    
    @property
    def raw_line_size(self) -> int:
        '''Gets the raw line size in bytes.'''
        raise NotImplementedError()
    
    @property
    def is_raw_data_available(self) -> bool:
        '''Gets a value indicating whether raw data loading is available.'''
        raise NotImplementedError()
    
    @property
    def horizontal_resolution(self) -> float:
        '''Gets the horizontal resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float) -> None:
        '''Sets the horizontal resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @property
    def vertical_resolution(self) -> float:
        '''Gets the vertical resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float) -> None:
        '''Sets the vertical resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @property
    def has_transparent_color(self) -> bool:
        '''Gets a value indicating whether image has transparent color.'''
        raise NotImplementedError()
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : bool) -> None:
        '''Gets a value indicating whether image has transparent color.'''
        raise NotImplementedError()
    
    @property
    def has_alpha(self) -> bool:
        '''Gets a value indicating whether this instance has alpha.'''
        raise NotImplementedError()
    
    @property
    def transparent_color(self) -> aspose.imaging.Color:
        '''Gets the image transparent color.'''
        raise NotImplementedError()
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.imaging.Color) -> None:
        '''Gets the image transparent color.'''
        raise NotImplementedError()
    
    @property
    def image_opacity(self) -> float:
        '''Gets opacity of this image.'''
        raise NotImplementedError()
    

class RasterCachedMultipageImage(RasterCachedImage):
    '''The raster multipage image'''
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self) -> None:
        '''Saves the image data to the underlying stream.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int, pixels : List[int]) -> aspose.imaging.Image:
        '''Creates a :py:class:`aspose.imaging.RasterImage` instance from the provided pixel array.
        
        Validates that the specified width and height match the dimensions of the pixel data.
        This method can only be used when the library is in Licensed mode.
        
        :param image_options: The options used to create the :py:class:`aspose.imaging.RasterImage`.
        :param width: The width of the :py:class:`aspose.imaging.RasterImage`.
        :param height: The height of the :py:class:`aspose.imaging.RasterImage`.
        :param pixels: The array of pixel values used to populate the image.
        :returns: A :py:class:`aspose.imaging.RasterImage` populated with the provided pixel data.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(multipage_create_options : aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(file_path : str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, pixels : List[int], width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int) -> None:
        '''Resizes the image. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int) -> None:
        '''Resizes the width proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int) -> None:
        '''Resizes the height proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float, resize_proportionally : bool, background_color : aspose.imaging.Color) -> None:
        ''':py:func:`aspose.imaging.RasterCachedMultipageImage.rotate` image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.
        :param resize_proportionally: if set to ``true`` you will have your image size changed
        according to rotated rectangle (corner points) projections in other
        case that leaves dimensions untouched and only
        image contents are rotated.
        :param background_color: Color of the background.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, rectangle : aspose.imaging.Rectangle) -> None:
        '''Cropping the image.
        
        :param rectangle: The rectangle.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, left_shift : int, right_shift : int, top_shift : int, bottom_shift : int) -> None:
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        raise NotImplementedError()
    
    @overload
    def dither(self, dithering_method : aspose.imaging.DitheringMethod, bits_count : int, custom_palette : aspose.imaging.IColorPalette) -> None:
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.
        :param custom_palette: The custom palette for dithering.'''
        raise NotImplementedError()
    
    @overload
    def dither(self, dithering_method : aspose.imaging.DitheringMethod, bits_count : int) -> None:
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.'''
        raise NotImplementedError()
    
    @overload
    def get_default_raw_data(self, rectangle : aspose.imaging.Rectangle, partial_raw_data_loader : aspose.imaging.IPartialRawDataLoader, raw_data_settings : aspose.imaging.RawDataSettings) -> None:
        '''Gets the default raw data array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_raw_data_loader: The partial raw data loader.
        :param raw_data_settings: The raw data settings.'''
        raise NotImplementedError()
    
    @overload
    def get_default_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings) -> List[int]:
        '''Gets the default raw data array.
        
        :param rectangle: The rectangle to get raw data for.
        :param raw_data_settings: The raw data settings.
        :returns: The default raw data array.'''
        raise NotImplementedError()
    
    @overload
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @overload
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, dest_image_bounds : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param dest_image_bounds: The dest image bounds.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @overload
    def binarize_bradley(self, brightness_difference : float, window_size : int) -> None:
        '''Binarization of an image using Bradley\'s adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels
        centered around this pixel.
        :param window_size: The size of s x s window of pixels centered around this pixel'''
        raise NotImplementedError()
    
    @overload
    def binarize_bradley(self, brightness_difference : float) -> None:
        '''Binarization of an image using Bradley\'s adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels
        centered around this pixel.'''
        raise NotImplementedError()
    
    @overload
    def blend(self, origin : aspose.imaging.Point, overlay : aspose.imaging.RasterImage, overlay_area : aspose.imaging.Rectangle, overlay_alpha : int) -> None:
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_area: The overlay area.
        :param overlay_alpha: The overlay alpha.'''
        raise NotImplementedError()
    
    @overload
    def blend(self, origin : aspose.imaging.Point, overlay : aspose.imaging.RasterImage, overlay_alpha : int) -> None:
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_alpha: The overlay alpha.'''
        raise NotImplementedError()
    
    @overload
    def adjust_gamma(self, gamma_red : float, gamma_green : float, gamma_blue : float) -> None:
        '''Gamma-correction of an image.
        
        :param gamma_red: Gamma for red channel coefficient
        :param gamma_green: Gamma for green channel coefficient
        :param gamma_blue: Gamma for blue channel coefficient'''
        raise NotImplementedError()
    
    @overload
    def adjust_gamma(self, gamma : float) -> None:
        '''Gamma-correction of an image.
        
        :param gamma: Gamma for red, green and blue channels coefficient'''
        raise NotImplementedError()
    
    @overload
    def normalize_angle(self, resize_proportionally : bool, background_color : aspose.imaging.Color) -> None:
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses :py:func:`aspose.imaging.RasterImage.get_skew_angle` and :py:func:`aspose.imaging.RasterCachedMultipageImage.rotate` methods.
        
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        raise NotImplementedError()
    
    @overload
    def normalize_angle(self) -> None:
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses :py:func:`aspose.imaging.RasterImage.get_skew_angle` and :py:func:`aspose.imaging.RasterImage.rotate` methods.'''
        raise NotImplementedError()
    
    @overload
    def replace_color(self, old_color_argb : int, old_color_diff : int, new_color_argb : int) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        raise NotImplementedError()
    
    @overload
    def replace_color(self, old_color : aspose.imaging.Color, old_color_diff : int, new_color : aspose.imaging.Color) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color: Old color to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color: New color to replace old color with.'''
        raise NotImplementedError()
    
    @overload
    def replace_non_transparent_colors(self, new_color_argb : int) -> None:
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color_argb: New color ARGB value to replace non transparent colors with.'''
        raise NotImplementedError()
    
    @overload
    def replace_non_transparent_colors(self, new_color : aspose.imaging.Color) -> None:
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color: New color to replace non transparent colors with.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data private.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_file_format_of_stream(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_width(width : int, height : int, new_height : int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_height(width : int, height : int, new_width : int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        raise NotImplementedError()
    
    def remove_metadata(self) -> None:
        '''Removes this image instance metadata by setting this :py:attr:`aspose.imaging.xmp.IHasXmpData.xmp_data` value to .'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type; otherwise, false.'''
        raise NotImplementedError()
    
    def can_save(self, options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def resize_by_type(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    def resize_by_settings(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    def get_default_options(self, args : List[Any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        raise NotImplementedError()
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        :py:func:`aspose.imaging.DataStreamSupporter.save` method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the :py:func:`aspose.imaging.Image.save` method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        raise NotImplementedError()
    
    def resize_width_proportionally_settings(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def resize_height_proportionally_settings(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def rotate_flip(self, rotate_flip_type : aspose.imaging.RotateFlipType) -> None:
        '''Rotates, flips, or rotates and flips all pages.
        
        :param rotate_flip_type: The rotate flip type.'''
        raise NotImplementedError()
    
    def save_with_options(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    def save_with_options_rect(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options_rect(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    def get_serialized_stream(self, image_options : aspose.imaging.ImageOptionsBase, clipping_rectangle : aspose.imaging.Rectangle, page_number : List[int]) -> io._IOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        raise NotImplementedError()
    
    def set_palette(self, palette : aspose.imaging.IColorPalette, update_colors : bool) -> None:
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        raise NotImplementedError()
    
    def get_modify_date(self, use_default : bool) -> datetime:
        '''Gets the date and time the resource image was last modified.
        
        :param use_default: if set to ``true`` uses the information from FileInfo as default value.
        :returns: The date and time the resource image was last modified.'''
        raise NotImplementedError()
    
    def get_default_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Gets the default pixels array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_pixel_loader: The partial pixel loader.'''
        raise NotImplementedError()
    
    def get_default_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Gets the default 32-bit ARGB pixels array.
        
        :param rectangle: The rectangle to get pixels for.
        :returns: The default pixels array.'''
        raise NotImplementedError()
    
    def get_argb_32_pixel(self, x : int, y : int) -> int:
        '''Gets an image 32-bit ARGB pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The 32-bit ARGB pixel for the specified location.'''
        raise NotImplementedError()
    
    def get_pixel(self, x : int, y : int) -> aspose.imaging.Color:
        '''Gets an image pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The pixel color for the specified location.'''
        raise NotImplementedError()
    
    def set_argb_32_pixel(self, x : int, y : int, argb_32_color : int) -> None:
        '''Sets an image 32-bit ARGB pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param argb_32_color: The 32-bit ARGB pixel for the specified position.'''
        raise NotImplementedError()
    
    def set_pixel(self, x : int, y : int, color : aspose.imaging.Color) -> None:
        '''Sets an image pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param color: The pixel color for the specified position.'''
        raise NotImplementedError()
    
    def read_scan_line(self, scan_line_index : int) -> List[aspose.imaging.Color]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line pixel color values array.'''
        raise NotImplementedError()
    
    def read_argb_32_scan_line(self, scan_line_index : int) -> List[int]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line 32-bit ARGB color values array.'''
        raise NotImplementedError()
    
    def write_scan_line(self, scan_line_index : int, pixels : List[aspose.imaging.Color]) -> None:
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param pixels: The pixel colors array to write.'''
        raise NotImplementedError()
    
    def write_argb_32_scan_line(self, scan_line_index : int, argb_32_pixels : List[int]) -> None:
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param argb_32_pixels: The 32-bit ARGB colors array to write.'''
        raise NotImplementedError()
    
    def load_partial_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Loads 32-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 32-bit ARGB pixel loader.'''
        raise NotImplementedError()
    
    def load_partial_pixels(self, desired_rectangle : aspose.imaging.Rectangle, pixel_loader : aspose.imaging.IPartialPixelLoader) -> None:
        '''Loads pixels partially by packs.
        
        :param desired_rectangle: The desired rectangle.
        :param pixel_loader: The pixel loader.'''
        raise NotImplementedError()
    
    def load_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 32-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def load_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads 64-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 64-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def load_partial_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb64PixelLoader) -> None:
        '''Loads 64-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 64-bit ARGB pixel loader.'''
        raise NotImplementedError()
    
    def load_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[aspose.imaging.Color]:
        '''Loads pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded pixels array.'''
        raise NotImplementedError()
    
    def load_cmyk_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[aspose.imaging.CmykColor]:
        '''Loads pixels in CMYK format.
        This method is deprecated. Please use more effective the :py:func:`aspose.imaging.RasterImage.load_cmyk_32_pixels` method.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels array.'''
        raise NotImplementedError()
    
    def load_cmyk_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads pixels in CMYK format.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels presentes as 32-bit inateger values.'''
        raise NotImplementedError()
    
    def save_raw_data(self, data : List[int], data_offset : int, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings) -> None:
        '''Saves the raw data.
        
        :param data: The raw data.
        :param data_offset: The starting raw data offset.
        :param rectangle: The raw data rectangle.
        :param raw_data_settings: The raw data settings the data is in.'''
        raise NotImplementedError()
    
    def save_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[int]) -> None:
        '''Saves the 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The 32-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def save_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.Color]) -> None:
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The pixels array.'''
        raise NotImplementedError()
    
    def save_cmyk_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.CmykColor]) -> None:
        '''Saves the pixels.
        This method is deprecated. Please use more effective the :py:func:`aspose.imaging.RasterImage.save_cmyk_32_pixels` method.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels array.'''
        raise NotImplementedError()
    
    def save_cmyk_32_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[int]) -> None:
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels presented as the 32-bit integer values.'''
        raise NotImplementedError()
    
    def set_resolution(self, dpi_x : float, dpi_y : float) -> None:
        '''Sets the resolution for this :py:class:`aspose.imaging.RasterImage`.
        
        :param dpi_x: The horizontal resolution, in dots per inch, of the :py:class:`aspose.imaging.RasterImage`.
        :param dpi_y: The vertical resolution, in dots per inch, of the :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    def auto_rotate(self) -> None:
        '''Automatically rotates the image based on orientation data extracted from Exif
        metadata. This method ensures that images are displayed in the correct orientation,
        enhancing user experience and eliminating the need for manual adjustments. By
        analyzing Exif information, the image is rotated accordingly, providing a seamless
        viewing experience across different platforms and devices. This automated rotation
        process simplifies image handling and improves overall usability, especially when
        dealing with large batches of images with varying orientations.'''
        raise NotImplementedError()
    
    def binarize_fixed(self, threshold : int) -> None:
        '''Binarization of an image with predefined threshold
        
        :param threshold: Threshold value. If corresponding gray value of a pixel is greater than threshold, a value of
        255 will be assigned to it, 0 otherwise.'''
        raise NotImplementedError()
    
    def binarize_otsu(self) -> None:
        '''Binarization of an image with Otsu thresholding'''
        raise NotImplementedError()
    
    def grayscale(self) -> None:
        '''Transformation of an image to its grayscale representation'''
        raise NotImplementedError()
    
    def normalize_histogram(self) -> None:
        '''Normalizes the image histogram — adjust pixel values to use all available range.'''
        raise NotImplementedError()
    
    def auto_brightness_contrast(self) -> None:
        '''Performs automatic adaptive brightness and contrast normalization for the entire image.'''
        raise NotImplementedError()
    
    def adjust_brightness(self, brightness : int) -> None:
        '''Adjust of a ``brightness`` for image.
        
        :param brightness: Brightness value.'''
        raise NotImplementedError()
    
    def adjust_contrast(self, contrast : float) -> None:
        ''':py:class:`aspose.imaging.Image` contrasting
        
        :param contrast: Contrast value (in range [-100; 100])'''
        raise NotImplementedError()
    
    def embed_digital_signature(self, password : str) -> None:
        '''Embed digital sign based on provided password into each page of the image.
        
        :param password: The password used for generate digital sign data'''
        raise NotImplementedError()
    
    def analyze_percentage_digital_signature(self, password : str) -> int:
        '''Calculates the percentage similarity between the extracted data and the original password.
        
        :param password: The password used to extract the embedded data.
        :returns: The percentage similarity value.'''
        raise NotImplementedError()
    
    def is_digital_signed(self, password : str, percentage_threshold : int) -> bool:
        '''Performs a fast check to determine if the image is digitally signed, using the provided password and threshold.
        
        :param password: The password to check the signing.
        :param percentage_threshold: The threshold (in percentage)[0-100] that determines if the image is considered signed.
        If not specified, a default threshold (``75``) will be applied.
        :returns: True if the image is signed, otherwise false.'''
        raise NotImplementedError()
    
    def get_skew_angle(self) -> float:
        '''Gets the skew angle.
        This method is applicable to scanned text documents, to determine the skew angle when scanning.
        
        :returns: The skew angle, in degrees.'''
        raise NotImplementedError()
    
    def filter(self, rectangle : aspose.imaging.Rectangle, options : aspose.imaging.imagefilters.filteroptions.FilterOptionsBase) -> None:
        '''Filters the specified rectangle.
        
        :param rectangle: The rectangle.
        :param options: The options.'''
        raise NotImplementedError()
    
    def replace_argb(self, old_color_argb : int, old_color_diff : int, new_color_argb : int) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        raise NotImplementedError()
    
    def rotate_flip_all(self, rotate_flip : aspose.imaging.RotateFlipType) -> None:
        '''Rotates the flip all.
        
        :param rotate_flip: The rotate flip.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether image data is cached currently.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        raise NotImplementedError()
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the :py:class:`aspose.imaging.Image` container.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @property
    def use_palette(self) -> bool:
        '''Gets a value indicating whether the image palette is used.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        '''Gets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor) -> None:
        '''Sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def auto_adjust_palette(self) -> bool:
        '''Gets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool) -> None:
        '''Sets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @property
    def has_background_color(self) -> bool:
        '''Gets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @has_background_color.setter
    def has_background_color(self, value : bool) -> None:
        '''Sets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        '''Gets a value of file format'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a value for the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a value for the background color.'''
        raise NotImplementedError()
    
    @property
    def metadata(self) -> aspose.imaging.metadata.ImageMetadata:
        '''Gets XMP data from frame.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the Xmp data.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the Xmp data.'''
        raise NotImplementedError()
    
    @property
    def premultiply_components(self) -> bool:
        '''Gets a value indicating whether the image components must be premultiplied.'''
        raise NotImplementedError()
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool) -> None:
        '''Sets a value indicating whether the image components must be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def use_raw_data(self) -> bool:
        '''Gets a value indicating whether to use raw data loading when the raw data loading is available.'''
        raise NotImplementedError()
    
    @use_raw_data.setter
    def use_raw_data(self, value : bool) -> None:
        '''Sets a value indicating whether to use raw data loading when the raw data loading is available.'''
        raise NotImplementedError()
    
    @property
    def update_xmp_data(self) -> bool:
        '''Gets a value indicating whether to update the XMP metadata.'''
        raise NotImplementedError()
    
    @update_xmp_data.setter
    def update_xmp_data(self, value : bool) -> None:
        '''Sets a value indicating whether to update the XMP metadata.'''
        raise NotImplementedError()
    
    @property
    def raw_indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        '''Gets the indexed color converter'''
        raise NotImplementedError()
    
    @raw_indexed_color_converter.setter
    def raw_indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter) -> None:
        '''Sets the indexed color converter'''
        raise NotImplementedError()
    
    @property
    def raw_custom_color_converter(self) -> aspose.imaging.IColorConverter:
        '''Gets the custom color converter'''
        raise NotImplementedError()
    
    @raw_custom_color_converter.setter
    def raw_custom_color_converter(self, value : aspose.imaging.IColorConverter) -> None:
        '''Sets the custom color converter'''
        raise NotImplementedError()
    
    @property
    def raw_fallback_index(self) -> int:
        '''Gets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @raw_fallback_index.setter
    def raw_fallback_index(self, value : int) -> None:
        '''Sets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        '''Gets the current raw data settings. Note when using these settings the data loads without conversion.'''
        raise NotImplementedError()
    
    @property
    def raw_data_format(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the raw data format.'''
        raise NotImplementedError()
    
    @property
    def raw_line_size(self) -> int:
        '''Gets the raw line size in bytes.'''
        raise NotImplementedError()
    
    @property
    def is_raw_data_available(self) -> bool:
        '''Gets a value indicating whether raw data loading is available.'''
        raise NotImplementedError()
    
    @property
    def horizontal_resolution(self) -> float:
        '''Gets the horizontal resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float) -> None:
        '''Sets the horizontal resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @property
    def vertical_resolution(self) -> float:
        '''Gets the vertical resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float) -> None:
        '''Sets the vertical resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @property
    def has_transparent_color(self) -> bool:
        '''Gets a value indicating whether image has transparent color.'''
        raise NotImplementedError()
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : bool) -> None:
        '''Gets a value indicating whether image has transparent color.'''
        raise NotImplementedError()
    
    @property
    def has_alpha(self) -> bool:
        '''Gets a value indicating whether this instance has alpha.'''
        raise NotImplementedError()
    
    @property
    def transparent_color(self) -> aspose.imaging.Color:
        '''Gets the image transparent color.'''
        raise NotImplementedError()
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.imaging.Color) -> None:
        '''Gets the image transparent color.'''
        raise NotImplementedError()
    
    @property
    def image_opacity(self) -> float:
        '''Gets opacity of this image.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the page count.'''
        raise NotImplementedError()
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        raise NotImplementedError()
    

class RasterImage(Image):
    '''Represents a raster image supporting raster graphics operations.'''
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self) -> None:
        '''Saves the image data to the underlying stream.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int, pixels : List[int]) -> aspose.imaging.Image:
        '''Creates a :py:class:`aspose.imaging.RasterImage` instance from the provided pixel array.
        
        Validates that the specified width and height match the dimensions of the pixel data.
        This method can only be used when the library is in Licensed mode.
        
        :param image_options: The options used to create the :py:class:`aspose.imaging.RasterImage`.
        :param width: The width of the :py:class:`aspose.imaging.RasterImage`.
        :param height: The height of the :py:class:`aspose.imaging.RasterImage`.
        :param pixels: The array of pixel values used to populate the image.
        :returns: A :py:class:`aspose.imaging.RasterImage` populated with the provided pixel data.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(multipage_create_options : aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(file_path : str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, pixels : List[int], width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image with extended options.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int) -> None:
        '''Resizes the image. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int) -> None:
        '''Resizes the width proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int) -> None:
        '''Resizes the height proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float, resize_proportionally : bool, background_color : aspose.imaging.Color) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        raise NotImplementedError()
    
    @overload
    def rotate(self, angle : float) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, rectangle : aspose.imaging.Rectangle) -> None:
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, left_shift : int, right_shift : int, top_shift : int, bottom_shift : int) -> None:
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        raise NotImplementedError()
    
    @overload
    def dither(self, dithering_method : aspose.imaging.DitheringMethod, bits_count : int) -> None:
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.'''
        raise NotImplementedError()
    
    @overload
    def dither(self, dithering_method : aspose.imaging.DitheringMethod, bits_count : int, custom_palette : aspose.imaging.IColorPalette) -> None:
        '''Performs dithering on the current image.
        
        :param dithering_method: The dithering method.
        :param bits_count: The final bits count for dithering.
        :param custom_palette: The custom palette for dithering.'''
        raise NotImplementedError()
    
    @overload
    def get_default_raw_data(self, rectangle : aspose.imaging.Rectangle, partial_raw_data_loader : aspose.imaging.IPartialRawDataLoader, raw_data_settings : aspose.imaging.RawDataSettings) -> None:
        '''Gets the default raw data array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_raw_data_loader: The partial raw data loader.
        :param raw_data_settings: The raw data settings.'''
        raise NotImplementedError()
    
    @overload
    def get_default_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings) -> List[int]:
        '''Gets the default raw data array.
        
        :param rectangle: The rectangle to get raw data for.
        :param raw_data_settings: The raw data settings.
        :returns: The default raw data array.'''
        raise NotImplementedError()
    
    @overload
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @overload
    def load_raw_data(self, rectangle : aspose.imaging.Rectangle, dest_image_bounds : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings, raw_data_loader : aspose.imaging.IPartialRawDataLoader) -> None:
        '''Loads raw data.
        
        :param rectangle: The rectangle to load raw data from.
        :param dest_image_bounds: The dest image bounds.
        :param raw_data_settings: The raw data settings to use for loaded data. Note if data is not in the format specified then data conversion will be performed.
        :param raw_data_loader: The raw data loader.'''
        raise NotImplementedError()
    
    @overload
    def binarize_bradley(self, brightness_difference : float) -> None:
        '''Binarization of an image using Bradley\'s adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.'''
        raise NotImplementedError()
    
    @overload
    def binarize_bradley(self, brightness_difference : float, window_size : int) -> None:
        '''Binarization of an image using Bradley\'s adaptive thresholding algorithm using the integral image thresholding
        
        :param brightness_difference: The brightness difference between pixel and the average of an s x s window of pixels centered around this pixel.
        :param window_size: The size of s x s window of pixels centered around this pixel'''
        raise NotImplementedError()
    
    @overload
    def blend(self, origin : aspose.imaging.Point, overlay : aspose.imaging.RasterImage, overlay_area : aspose.imaging.Rectangle, overlay_alpha : int) -> None:
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_area: The overlay area.
        :param overlay_alpha: The overlay alpha.'''
        raise NotImplementedError()
    
    @overload
    def blend(self, origin : aspose.imaging.Point, overlay : aspose.imaging.RasterImage, overlay_alpha : int) -> None:
        '''Blends this image instance with the ``overlay`` image.
        
        :param origin: The background image blending origin.
        :param overlay: The overlay image.
        :param overlay_alpha: The overlay alpha.'''
        raise NotImplementedError()
    
    @overload
    def adjust_gamma(self, gamma_red : float, gamma_green : float, gamma_blue : float) -> None:
        '''Gamma-correction of an image.
        
        :param gamma_red: Gamma for red channel coefficient
        :param gamma_green: Gamma for green channel coefficient
        :param gamma_blue: Gamma for blue channel coefficient'''
        raise NotImplementedError()
    
    @overload
    def adjust_gamma(self, gamma : float) -> None:
        '''Gamma-correction of an image.
        
        :param gamma: Gamma for red, green and blue channels coefficient'''
        raise NotImplementedError()
    
    @overload
    def normalize_angle(self) -> None:
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses :py:func:`aspose.imaging.RasterImage.get_skew_angle` and :py:func:`aspose.imaging.RasterImage.rotate` methods.'''
        raise NotImplementedError()
    
    @overload
    def normalize_angle(self, resize_proportionally : bool, background_color : aspose.imaging.Color) -> None:
        '''Normalizes the angle.
        This method is applicable to scanned text documents to get rid of the skewed scan.
        This method uses :py:func:`aspose.imaging.RasterImage.get_skew_angle` and :py:func:`aspose.imaging.RasterImage.rotate` methods.
        
        :param resize_proportionally: if set to ``true`` you will have your image size changed according to rotated rectangle (corner points) projections in other case that leaves dimensions untouched and only internal image contents are rotated.
        :param background_color: Color of the background.'''
        raise NotImplementedError()
    
    @overload
    def replace_color(self, old_color : aspose.imaging.Color, old_color_diff : int, new_color : aspose.imaging.Color) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color: Old color to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color: New color to replace old color with.'''
        raise NotImplementedError()
    
    @overload
    def replace_color(self, old_color_argb : int, old_color_diff : int, new_color_argb : int) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        raise NotImplementedError()
    
    @overload
    def replace_non_transparent_colors(self, new_color : aspose.imaging.Color) -> None:
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color: New color to replace non transparent colors with.'''
        raise NotImplementedError()
    
    @overload
    def replace_non_transparent_colors(self, new_color_argb : int) -> None:
        '''Replaces all non-transparent colors with new color and preserves original alpha value to save smooth edges.
        Note: if you use it on images without transparency, all colors will be replaced with a single one.
        
        :param new_color_argb: New color ARGB value to replace non transparent colors with.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data and ensures no additional data loading will be performed from the underlying :py:attr:`aspose.imaging.DataStreamSupporter.data_stream_container`.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_file_format_of_stream(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_width(width : int, height : int, new_height : int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_height(width : int, height : int, new_width : int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        raise NotImplementedError()
    
    def remove_metadata(self) -> None:
        '''Removes this image instance metadata by setting this :py:attr:`aspose.imaging.xmp.IHasXmpData.xmp_data` value to .'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type; otherwise, false.'''
        raise NotImplementedError()
    
    def can_save(self, options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def resize_by_type(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    def resize_by_settings(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    def get_default_options(self, args : List[Any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default options.
        
        :param args: The arguments.
        :returns: Default options'''
        raise NotImplementedError()
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        :py:func:`aspose.imaging.DataStreamSupporter.save` method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the :py:func:`aspose.imaging.Image.save` method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        raise NotImplementedError()
    
    def resize_width_proportionally_settings(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def resize_height_proportionally_settings(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def rotate_flip(self, rotate_flip_type : aspose.imaging.RotateFlipType) -> None:
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        raise NotImplementedError()
    
    def save_with_options(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    def save_with_options_rect(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options_rect(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    def get_serialized_stream(self, image_options : aspose.imaging.ImageOptionsBase, clipping_rectangle : aspose.imaging.Rectangle, page_number : List[int]) -> io._IOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        raise NotImplementedError()
    
    def set_palette(self, palette : aspose.imaging.IColorPalette, update_colors : bool) -> None:
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        raise NotImplementedError()
    
    def get_modify_date(self, use_default : bool) -> datetime:
        '''Gets the date and time the resource image was last modified.
        
        :param use_default: if set to ``true`` uses the information from FileInfo as default value.
        :returns: The date and time the resource image was last modified.'''
        raise NotImplementedError()
    
    def get_default_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Gets the default pixels array using partial pixel loader.
        
        :param rectangle: The rectangle to get pixels for.
        :param partial_pixel_loader: The partial pixel loader.'''
        raise NotImplementedError()
    
    def get_default_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Gets the default 32-bit ARGB pixels array.
        
        :param rectangle: The rectangle to get pixels for.
        :returns: The default pixels array.'''
        raise NotImplementedError()
    
    def get_argb_32_pixel(self, x : int, y : int) -> int:
        '''Gets an image 32-bit ARGB pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The 32-bit ARGB pixel for the specified location.'''
        raise NotImplementedError()
    
    def get_pixel(self, x : int, y : int) -> aspose.imaging.Color:
        '''Gets an image pixel.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :returns: The pixel color for the specified location.'''
        raise NotImplementedError()
    
    def set_argb_32_pixel(self, x : int, y : int, argb_32_color : int) -> None:
        '''Sets an image 32-bit ARGB pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param argb_32_color: The 32-bit ARGB pixel for the specified position.'''
        raise NotImplementedError()
    
    def set_pixel(self, x : int, y : int, color : aspose.imaging.Color) -> None:
        '''Sets an image pixel for the specified position.
        
        :param x: The pixel x location.
        :param y: The pixel y location.
        :param color: The pixel color for the specified position.'''
        raise NotImplementedError()
    
    def read_scan_line(self, scan_line_index : int) -> List[aspose.imaging.Color]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line pixel color values array.'''
        raise NotImplementedError()
    
    def read_argb_32_scan_line(self, scan_line_index : int) -> List[int]:
        '''Reads the whole scan line by the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :returns: The scan line 32-bit ARGB color values array.'''
        raise NotImplementedError()
    
    def write_scan_line(self, scan_line_index : int, pixels : List[aspose.imaging.Color]) -> None:
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param pixels: The pixel colors array to write.'''
        raise NotImplementedError()
    
    def write_argb_32_scan_line(self, scan_line_index : int, argb_32_pixels : List[int]) -> None:
        '''Writes the whole scan line to the specified scan line index.
        
        :param scan_line_index: Zero based index of the scan line.
        :param argb_32_pixels: The 32-bit ARGB colors array to write.'''
        raise NotImplementedError()
    
    def load_partial_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb32PixelLoader) -> None:
        '''Loads 32-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 32-bit ARGB pixel loader.'''
        raise NotImplementedError()
    
    def load_partial_pixels(self, desired_rectangle : aspose.imaging.Rectangle, pixel_loader : aspose.imaging.IPartialPixelLoader) -> None:
        '''Loads pixels partially by packs.
        
        :param desired_rectangle: The desired rectangle.
        :param pixel_loader: The pixel loader.'''
        raise NotImplementedError()
    
    def load_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 32-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def load_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads 64-bit ARGB pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded 64-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def load_partial_argb_64_pixels(self, rectangle : aspose.imaging.Rectangle, partial_pixel_loader : aspose.imaging.IPartialArgb64PixelLoader) -> None:
        '''Loads 64-bit ARGB pixels partially by packs.
        
        :param rectangle: The desired rectangle.
        :param partial_pixel_loader: The 64-bit ARGB pixel loader.'''
        raise NotImplementedError()
    
    def load_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[aspose.imaging.Color]:
        '''Loads pixels.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded pixels array.'''
        raise NotImplementedError()
    
    def load_cmyk_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[aspose.imaging.CmykColor]:
        '''Loads pixels in CMYK format.
        This method is deprecated. Please use more effective the :py:func:`aspose.imaging.RasterImage.load_cmyk_32_pixels` method.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels array.'''
        raise NotImplementedError()
    
    def load_cmyk_32_pixels(self, rectangle : aspose.imaging.Rectangle) -> List[int]:
        '''Loads pixels in CMYK format.
        
        :param rectangle: The rectangle to load pixels from.
        :returns: The loaded CMYK pixels presentes as 32-bit inateger values.'''
        raise NotImplementedError()
    
    def save_raw_data(self, data : List[int], data_offset : int, rectangle : aspose.imaging.Rectangle, raw_data_settings : aspose.imaging.RawDataSettings) -> None:
        '''Saves the raw data.
        
        :param data: The raw data.
        :param data_offset: The starting raw data offset.
        :param rectangle: The raw data rectangle.
        :param raw_data_settings: The raw data settings the data is in.'''
        raise NotImplementedError()
    
    def save_argb_32_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[int]) -> None:
        '''Saves the 32-bit ARGB pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The 32-bit ARGB pixels array.'''
        raise NotImplementedError()
    
    def save_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.Color]) -> None:
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The pixels array.'''
        raise NotImplementedError()
    
    def save_cmyk_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[aspose.imaging.CmykColor]) -> None:
        '''Saves the pixels.
        This method is deprecated. Please use more effective the :py:func:`aspose.imaging.RasterImage.save_cmyk_32_pixels` method.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels array.'''
        raise NotImplementedError()
    
    def save_cmyk_32_pixels(self, rectangle : aspose.imaging.Rectangle, pixels : List[int]) -> None:
        '''Saves the pixels.
        
        :param rectangle: The rectangle to save pixels to.
        :param pixels: The CMYK pixels presented as the 32-bit integer values.'''
        raise NotImplementedError()
    
    def set_resolution(self, dpi_x : float, dpi_y : float) -> None:
        '''Sets the resolution for this :py:class:`aspose.imaging.RasterImage`.
        
        :param dpi_x: The horizontal resolution, in dots per inch, of the :py:class:`aspose.imaging.RasterImage`.
        :param dpi_y: The vertical resolution, in dots per inch, of the :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    def auto_rotate(self) -> None:
        '''Automatically rotates the image based on orientation data extracted from Exif
        metadata. This method ensures that images are displayed in the correct orientation,
        enhancing user experience and eliminating the need for manual adjustments. By
        analyzing Exif information, the image is rotated accordingly, providing a seamless
        viewing experience across different platforms and devices. This automated rotation
        process simplifies image handling and improves overall usability, especially when
        dealing with large batches of images with varying orientations.'''
        raise NotImplementedError()
    
    def binarize_fixed(self, threshold : int) -> None:
        '''Binarization of an image with predefined threshold
        
        :param threshold: Threshold value. If corresponding gray value of a pixel is greater than threshold, a value of 255 will be assigned to it, 0 otherwise.'''
        raise NotImplementedError()
    
    def binarize_otsu(self) -> None:
        '''Binarization of an image with Otsu thresholding'''
        raise NotImplementedError()
    
    def grayscale(self) -> None:
        '''Transformation of an image to its grayscale representation'''
        raise NotImplementedError()
    
    def normalize_histogram(self) -> None:
        '''Normalizes the image histogram — adjust pixel values to use all available range.'''
        raise NotImplementedError()
    
    def auto_brightness_contrast(self) -> None:
        '''Automatic adaptive brightness and contrast normalization for the entire image.'''
        raise NotImplementedError()
    
    def adjust_brightness(self, brightness : int) -> None:
        '''Adjust of a brightness for image.
        
        :param brightness: Brightness value.'''
        raise NotImplementedError()
    
    def adjust_contrast(self, contrast : float) -> None:
        '''Image contrasting
        
        :param contrast: Contrast value (in range [-100; 100])'''
        raise NotImplementedError()
    
    def embed_digital_signature(self, password : str) -> None:
        '''Embed digital sign based on provided password into the image using steganography.
        
        :param password: The password used for generate digital sign data'''
        raise NotImplementedError()
    
    def analyze_percentage_digital_signature(self, password : str) -> int:
        '''Calculates the percentage similarity between the extracted data and the original password.
        
        :param password: The password used to extract the embedded data.
        :returns: The percentage similarity value.'''
        raise NotImplementedError()
    
    def is_digital_signed(self, password : str, percentage_threshold : int) -> bool:
        '''Performs a fast check to determine if the image is digitally signed, using the provided password and threshold.
        
        :param password: The password to check the signing.
        :param percentage_threshold: The threshold (in percentage)[0-100] that determines if the image is considered signed.
        If not specified, a default threshold (``75``) will be applied.
        :returns: True if the image is signed, otherwise false.'''
        raise NotImplementedError()
    
    def get_skew_angle(self) -> float:
        '''Gets the skew angle.
        This method is applicable to scanned text documents, to determine the skew angle when scanning.
        
        :returns: The skew angle, in degrees.'''
        raise NotImplementedError()
    
    def filter(self, rectangle : aspose.imaging.Rectangle, options : aspose.imaging.imagefilters.filteroptions.FilterOptionsBase) -> None:
        '''Filters the specified rectangle.
        
        :param rectangle: The rectangle.
        :param options: The options.'''
        raise NotImplementedError()
    
    def replace_argb(self, old_color_argb : int, old_color_diff : int, new_color_argb : int) -> None:
        '''Replaces one color to another with allowed difference and preserves original alpha value to save smooth edges.
        
        :param old_color_argb: Old color ARGB value to be replaced.
        :param old_color_diff: Allowed difference in old color to be able to widen replaced color tone.
        :param new_color_argb: New color ARGB value to replace old color with.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether object\'s data is cached currently and no data reading is required.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        raise NotImplementedError()
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the :py:class:`aspose.imaging.Image` container.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @property
    def use_palette(self) -> bool:
        '''Gets a value indicating whether the image palette is used.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        '''Gets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor) -> None:
        '''Sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def auto_adjust_palette(self) -> bool:
        '''Gets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool) -> None:
        '''Sets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @property
    def has_background_color(self) -> bool:
        '''Gets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @has_background_color.setter
    def has_background_color(self, value : bool) -> None:
        '''Sets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        '''Gets a value of file format'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a value for the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a value for the background color.'''
        raise NotImplementedError()
    
    @property
    def metadata(self) -> aspose.imaging.metadata.ImageMetadata:
        '''Gets the image metadata.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the Xmp data.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the Xmp data.'''
        raise NotImplementedError()
    
    @property
    def premultiply_components(self) -> bool:
        '''Gets a value indicating whether the image components must be premultiplied.'''
        raise NotImplementedError()
    
    @premultiply_components.setter
    def premultiply_components(self, value : bool) -> None:
        '''Sets a value indicating whether the image components must be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def use_raw_data(self) -> bool:
        '''Gets a value indicating whether to use raw data loading when the raw data loading is available.'''
        raise NotImplementedError()
    
    @use_raw_data.setter
    def use_raw_data(self, value : bool) -> None:
        '''Sets a value indicating whether to use raw data loading when the raw data loading is available.'''
        raise NotImplementedError()
    
    @property
    def update_xmp_data(self) -> bool:
        '''Gets a value indicating whether to update the XMP metadata.'''
        raise NotImplementedError()
    
    @update_xmp_data.setter
    def update_xmp_data(self, value : bool) -> None:
        '''Sets a value indicating whether to update the XMP metadata.'''
        raise NotImplementedError()
    
    @property
    def raw_indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        '''Gets the indexed color converter'''
        raise NotImplementedError()
    
    @raw_indexed_color_converter.setter
    def raw_indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter) -> None:
        '''Sets the indexed color converter'''
        raise NotImplementedError()
    
    @property
    def raw_custom_color_converter(self) -> aspose.imaging.IColorConverter:
        '''Gets the custom color converter'''
        raise NotImplementedError()
    
    @raw_custom_color_converter.setter
    def raw_custom_color_converter(self, value : aspose.imaging.IColorConverter) -> None:
        '''Sets the custom color converter'''
        raise NotImplementedError()
    
    @property
    def raw_fallback_index(self) -> int:
        '''Gets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @raw_fallback_index.setter
    def raw_fallback_index(self, value : int) -> None:
        '''Sets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @property
    def raw_data_settings(self) -> aspose.imaging.RawDataSettings:
        '''Gets the current raw data settings. Note when using these settings the data loads without conversion.'''
        raise NotImplementedError()
    
    @property
    def raw_data_format(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the raw data format.'''
        raise NotImplementedError()
    
    @property
    def raw_line_size(self) -> int:
        '''Gets the raw line size in bytes.'''
        raise NotImplementedError()
    
    @property
    def is_raw_data_available(self) -> bool:
        '''Gets a value indicating whether raw data loading is available.'''
        raise NotImplementedError()
    
    @property
    def horizontal_resolution(self) -> float:
        '''Gets the horizontal resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float) -> None:
        '''Sets the horizontal resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @property
    def vertical_resolution(self) -> float:
        '''Gets the vertical resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float) -> None:
        '''Sets the vertical resolution, in pixels per inch, of this :py:class:`aspose.imaging.RasterImage`.'''
        raise NotImplementedError()
    
    @property
    def has_transparent_color(self) -> bool:
        '''Gets a value indicating whether image has transparent color.'''
        raise NotImplementedError()
    
    @has_transparent_color.setter
    def has_transparent_color(self, value : bool) -> None:
        '''Gets a value indicating whether image has transparent color.'''
        raise NotImplementedError()
    
    @property
    def has_alpha(self) -> bool:
        '''Gets a value indicating whether this instance has alpha.'''
        raise NotImplementedError()
    
    @property
    def transparent_color(self) -> aspose.imaging.Color:
        '''Gets the image transparent color.'''
        raise NotImplementedError()
    
    @transparent_color.setter
    def transparent_color(self, value : aspose.imaging.Color) -> None:
        '''Gets the image transparent color.'''
        raise NotImplementedError()
    
    @property
    def image_opacity(self) -> float:
        '''Gets opacity of this image.'''
        raise NotImplementedError()
    

class RawDataSettings:
    '''The raw data settings'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def clone(self) -> aspose.imaging.RawDataSettings:
        '''Creates a shalow clone.
        
        :returns: A shalow clone.'''
        raise NotImplementedError()
    
    @property
    def pixel_data_format(self) -> aspose.imaging.PixelDataFormat:
        '''Gets the pixel data format'''
        raise NotImplementedError()
    
    @pixel_data_format.setter
    def pixel_data_format(self, value : aspose.imaging.PixelDataFormat) -> None:
        '''Sets the pixel data format'''
        raise NotImplementedError()
    
    @property
    def color_palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette'''
        raise NotImplementedError()
    
    @color_palette.setter
    def color_palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette'''
        raise NotImplementedError()
    
    @property
    def dithering_method(self) -> aspose.imaging.DitheringMethods:
        '''Gets the dithering method to use for raw data conversion'''
        raise NotImplementedError()
    
    @dithering_method.setter
    def dithering_method(self, value : aspose.imaging.DitheringMethods) -> None:
        '''Sets the dithering method to use for raw data conversion'''
        raise NotImplementedError()
    
    @property
    def indexed_color_converter(self) -> aspose.imaging.IIndexedColorConverter:
        '''Gets the indexed color converter'''
        raise NotImplementedError()
    
    @indexed_color_converter.setter
    def indexed_color_converter(self, value : aspose.imaging.IIndexedColorConverter) -> None:
        '''Sets the indexed color converter'''
        raise NotImplementedError()
    
    @property
    def custom_color_converter(self) -> aspose.imaging.IColorConverter:
        '''Gets the custom color converter'''
        raise NotImplementedError()
    
    @custom_color_converter.setter
    def custom_color_converter(self, value : aspose.imaging.IColorConverter) -> None:
        '''Sets the custom color converter'''
        raise NotImplementedError()
    
    @property
    def fallback_index(self) -> int:
        '''Gets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @fallback_index.setter
    def fallback_index(self, value : int) -> None:
        '''Sets the fallback index to use when palette index is out of bounds'''
        raise NotImplementedError()
    
    @property
    def line_size(self) -> int:
        '''Gets the pixels line size in bytes for raw data processing'''
        raise NotImplementedError()
    
    @line_size.setter
    def line_size(self, value : int) -> None:
        '''Sets the pixels line size in bytes for raw data processing'''
        raise NotImplementedError()
    

class Rectangle:
    '''Stores a set of four integers that represent the location and size of a rectangle.'''
    
    @overload
    def __init__(self, x : int, y : int, width : int, height : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Rectangle` structure with the specified location and size.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle.
        :param y: The y-coordinate of the upper-left corner of the rectangle.
        :param width: The width of the rectangle.
        :param height: The height of the rectangle.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, location : aspose.imaging.Point, size : aspose.imaging.Size) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Rectangle` structure with the specified location and size.
        
        :param location: A :py:class:`aspose.imaging.Point` that represents the upper-left corner of the rectangular region.
        :param size: A :py:class:`aspose.imaging.Size` that represents the width and height of the rectangular region.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def inflate(rect : aspose.imaging.Rectangle, x : int, y : int) -> aspose.imaging.Rectangle:
        '''Creates and returns an inflated copy of the specified :py:class:`aspose.imaging.Rectangle` structure. The copy is inflated by the specified amount. The original :py:class:`aspose.imaging.Rectangle` structure remains unmodified.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` with which to start. This rectangle is not modified.
        :param x: The amount to inflate this :py:class:`aspose.imaging.Rectangle` horizontally.
        :param y: The amount to inflate this :py:class:`aspose.imaging.Rectangle` vertically.
        :returns: The inflated :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @overload
    def inflate(self, width : int, height : int) -> None:
        '''Inflates this :py:class:`aspose.imaging.Rectangle` by the specified amount.
        
        :param width: The amount to inflate this :py:class:`aspose.imaging.Rectangle` horizontally.
        :param height: The amount to inflate this :py:class:`aspose.imaging.Rectangle` vertically.'''
        raise NotImplementedError()
    
    @overload
    def inflate(self, size : aspose.imaging.Size) -> None:
        '''Inflates this :py:class:`aspose.imaging.Rectangle` by the specified amount.
        
        :param size: The amount to inflate this rectangle.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def intersect(a : aspose.imaging.Rectangle, b : aspose.imaging.Rectangle) -> aspose.imaging.Rectangle:
        '''Returns a third :py:class:`aspose.imaging.Rectangle` structure that represents the intersection of two other :py:class:`aspose.imaging.Rectangle` structures. If there is no intersection, an empty :py:class:`aspose.imaging.Rectangle` is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A :py:class:`aspose.imaging.Rectangle` that represents the intersection of ``a`` and ``b``.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Replaces this :py:class:`aspose.imaging.Rectangle` with the intersection of itself and the specified :py:class:`aspose.imaging.Rectangle`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` with which to intersect.'''
        raise NotImplementedError()
    
    @overload
    def contains(self, x : int, y : int) -> bool:
        '''Determines if the specified point is contained within this :py:class:`aspose.imaging.Rectangle` structure.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the point defined by ``x`` and ``y`` is contained within this :py:class:`aspose.imaging.Rectangle` structure; otherwise false.'''
        raise NotImplementedError()
    
    @overload
    def contains(self, point : aspose.imaging.Point) -> bool:
        '''Determines if the specified point is contained within this :py:class:`aspose.imaging.Rectangle` structure.
        
        :param point: The :py:class:`aspose.imaging.Point` to test.
        :returns: This method returns true if the point represented by ``point`` is contained within this :py:class:`aspose.imaging.Rectangle` structure; otherwise false.'''
        raise NotImplementedError()
    
    @overload
    def contains(self, rect : aspose.imaging.Rectangle) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within this :py:class:`aspose.imaging.Rectangle` structure; otherwise false.'''
        raise NotImplementedError()
    
    @overload
    def offset(self, pos : aspose.imaging.Point) -> None:
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param pos: Amount to offset the location.'''
        raise NotImplementedError()
    
    @overload
    def offset(self, x : int, y : int) -> None:
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param x: The horizontal offset.
        :param y: The vertical offset.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_points(point1 : aspose.imaging.Point, point2 : aspose.imaging.Point) -> aspose.imaging.Rectangle:
        '''Creates a new :py:class:`aspose.imaging.Rectangle` from two points specified. Two verticales of the created :py:class:`aspose.imaging.Rectangle` will be equal to the passed ``point1`` and ``point2``. These would be typically the opposite vertices.
        
        :param point1: The first :py:class:`aspose.imaging.Point` for the new rectangle.
        :param point2: The second :py:class:`aspose.imaging.Point` for the new rectangle.
        :returns: A newly created :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @staticmethod
    def ceiling(value : aspose.imaging.RectangleF) -> aspose.imaging.Rectangle:
        '''Converts the specified :py:class:`aspose.imaging.RectangleF` structure to a :py:class:`aspose.imaging.Rectangle` structure by rounding the :py:class:`aspose.imaging.RectangleF` values to the next higher integer values.
        
        :param value: The :py:class:`aspose.imaging.RectangleF` structure to be converted.
        :returns: Returns a :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @staticmethod
    def truncate(value : aspose.imaging.RectangleF) -> aspose.imaging.Rectangle:
        '''Converts the specified :py:class:`aspose.imaging.RectangleF` to a :py:class:`aspose.imaging.Rectangle` by truncating the :py:class:`aspose.imaging.RectangleF` values.
        
        :param value: The :py:class:`aspose.imaging.RectangleF` to be converted.
        :returns: A new :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @staticmethod
    def round(value : aspose.imaging.RectangleF) -> aspose.imaging.Rectangle:
        '''Converts the specified :py:class:`aspose.imaging.RectangleF` to a :py:class:`aspose.imaging.Rectangle` by rounding the :py:class:`aspose.imaging.RectangleF` values to the nearest integer values.
        
        :param value: The :py:class:`aspose.imaging.RectangleF` to be converted.
        :returns: A new :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @staticmethod
    def inflate_rect(rect : aspose.imaging.Rectangle, x : int, y : int) -> aspose.imaging.Rectangle:
        '''Creates and returns an inflated copy of the specified :py:class:`aspose.imaging.Rectangle` structure. The copy is inflated by the specified amount. The original :py:class:`aspose.imaging.Rectangle` structure remains unmodified.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` with which to start. This rectangle is not modified.
        :param x: The amount to inflate this :py:class:`aspose.imaging.Rectangle` horizontally.
        :param y: The amount to inflate this :py:class:`aspose.imaging.Rectangle` vertically.
        :returns: The inflated :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @staticmethod
    def intersect_rects(a : aspose.imaging.Rectangle, b : aspose.imaging.Rectangle) -> aspose.imaging.Rectangle:
        '''Returns a third :py:class:`aspose.imaging.Rectangle` structure that represents the intersection of two other :py:class:`aspose.imaging.Rectangle` structures. If there is no intersection, an empty :py:class:`aspose.imaging.Rectangle` is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A :py:class:`aspose.imaging.Rectangle` that represents the intersection of ``a`` and ``b``.'''
        raise NotImplementedError()
    
    @staticmethod
    def union(a : aspose.imaging.Rectangle, b : aspose.imaging.Rectangle) -> aspose.imaging.Rectangle:
        '''Gets a :py:class:`aspose.imaging.Rectangle` structure that contains the union of two :py:class:`aspose.imaging.Rectangle` structures.
        
        :param a: A first rectangle to union.
        :param b: A second rectangle to union.
        :returns: A :py:class:`aspose.imaging.Rectangle` structure that bounds the union of the two :py:class:`aspose.imaging.Rectangle` structures.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_left_top_right_bottom(left : int, top : int, right : int, bottom : int) -> aspose.imaging.Rectangle:
        '''Creates a :py:class:`aspose.imaging.Rectangle` structure with the specified edge locations.
        
        :param left: The x-coordinate of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.
        :param top: The y-coordinate of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.
        :param right: The x-coordinate of the lower-right corner of this :py:class:`aspose.imaging.Rectangle` structure.
        :param bottom: The y-coordinate of the lower-right corner of this :py:class:`aspose.imaging.Rectangle` structure.
        :returns: The new :py:class:`aspose.imaging.Rectangle` that this method creates.'''
        raise NotImplementedError()
    
    def contains_point(self, point : aspose.imaging.Point) -> bool:
        '''Determines if the specified point is contained within this :py:class:`aspose.imaging.Rectangle` structure.
        
        :param point: The :py:class:`aspose.imaging.Point` to test.
        :returns: This method returns true if the point represented by ``point`` is contained within this :py:class:`aspose.imaging.Rectangle` structure; otherwise false.'''
        raise NotImplementedError()
    
    def contains_rect(self, rect : aspose.imaging.Rectangle) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within this :py:class:`aspose.imaging.Rectangle` structure; otherwise false.'''
        raise NotImplementedError()
    
    def intersects_with(self, rect : aspose.imaging.Rectangle) -> bool:
        '''Determines if this rectangle intersects with ``rect``.
        
        :param rect: The rectangle to test.
        :returns: This method returns true if there is any intersection, otherwise false.'''
        raise NotImplementedError()
    
    def normalize(self) -> None:
        '''Normalizes the rectangle by making it\'s width and height positive, left less than right and top less than bottom.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.Rectangle:
        '''Gets a new instance of the :py:class:`aspose.imaging.Rectangle` structure that has :py:attr:`aspose.imaging.Rectangle.x`, :py:attr:`aspose.imaging.Rectangle.y`, :py:attr:`aspose.imaging.Rectangle.width` and :py:attr:`aspose.imaging.Rectangle.height` values set to zero.'''
        raise NotImplementedError()

    @property
    def location(self) -> aspose.imaging.Point:
        '''Gets the coordinates of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @location.setter
    def location(self, value : aspose.imaging.Point) -> None:
        '''Sets the coordinates of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the size of this :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : aspose.imaging.Size) -> None:
        '''Sets the size of this :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x-coordinate of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x-coordinate of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y-coordinate of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y-coordinate of the upper-left corner of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> int:
        '''Gets the x-coordinate of the left edge of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : int) -> None:
        '''Sets the x-coordinate of the left edge of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> int:
        '''Gets the y-coordinate of the top edge of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : int) -> None:
        '''Sets the y-coordinate of the top edge of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> int:
        '''Gets the x-coordinate that is the sum of :py:attr:`aspose.imaging.Rectangle.x` and :py:attr:`aspose.imaging.Rectangle.width` property values of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : int) -> None:
        '''Sets the x-coordinate that is the sum of :py:attr:`aspose.imaging.Rectangle.x` and :py:attr:`aspose.imaging.Rectangle.width` property values of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> int:
        '''Gets the y-coordinate that is the sum of the :py:attr:`aspose.imaging.Rectangle.y` and :py:attr:`aspose.imaging.Rectangle.height` property values of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : int) -> None:
        '''Sets the y-coordinate that is the sum of the :py:attr:`aspose.imaging.Rectangle.y` and :py:attr:`aspose.imaging.Rectangle.height` property values of this :py:class:`aspose.imaging.Rectangle` structure.'''
        raise NotImplementedError()
    
    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether all numeric properties of this :py:class:`aspose.imaging.Rectangle` have values of zero.'''
        raise NotImplementedError()
    

class RectangleF:
    '''Stores a set of four floating-point numbers that represent the location and size of a rectangle.'''
    
    @overload
    def __init__(self, x : float, y : float, width : float, height : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.RectangleF` structure with the specified location and size.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle.
        :param y: The y-coordinate of the upper-left corner of the rectangle.
        :param width: The width of the rectangle.
        :param height: The height of the rectangle.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, location : aspose.imaging.PointF, size : aspose.imaging.SizeF) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.RectangleF` structure with the specified location and size.
        
        :param location: A :py:class:`aspose.imaging.PointF` that represents the upper-left corner of the rectangular region.
        :param size: A :py:class:`aspose.imaging.SizeF` that represents the width and height of the rectangular region.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def inflate(rect : aspose.imaging.RectangleF, x : float, y : float) -> aspose.imaging.RectangleF:
        '''Creates and returns an inflated copy of the specified :py:class:`aspose.imaging.RectangleF` structure. The copy is inflated by the specified amount. The original rectangle remains unmodified.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` to be copied. This rectangle is not modified.
        :param x: The amount to inflate the copy of the rectangle horizontally.
        :param y: The amount to inflate the copy of the rectangle vertically.
        :returns: The inflated :py:class:`aspose.imaging.RectangleF`.'''
        raise NotImplementedError()
    
    @overload
    def inflate(self, x : float, y : float) -> None:
        '''Inflates this :py:class:`aspose.imaging.RectangleF` structure by the specified amount.
        
        :param x: The amount to inflate this :py:class:`aspose.imaging.RectangleF` structure horizontally.
        :param y: The amount to inflate this :py:class:`aspose.imaging.RectangleF` structure vertically.'''
        raise NotImplementedError()
    
    @overload
    def inflate(self, size : aspose.imaging.SizeF) -> None:
        '''Inflates this :py:class:`aspose.imaging.RectangleF` by the specified amount.
        
        :param size: The amount to inflate this rectangle.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def intersect(a : aspose.imaging.RectangleF, b : aspose.imaging.RectangleF) -> aspose.imaging.RectangleF:
        '''Returns a :py:class:`aspose.imaging.RectangleF` structure that represents the intersection of two rectangles. If there is no intersection, and empty :py:class:`aspose.imaging.RectangleF` is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A third :py:class:`aspose.imaging.RectangleF` structure the size of which represents the overlapped area of the two specified rectangles.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, rect : aspose.imaging.RectangleF) -> None:
        '''Replaces this :py:class:`aspose.imaging.RectangleF` structure with the intersection of itself and the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The rectangle to intersect.'''
        raise NotImplementedError()
    
    @overload
    def contains(self, x : float, y : float) -> bool:
        '''Determines if the specified point is contained within this :py:class:`aspose.imaging.RectangleF` structure.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: This method returns true if the point defined by ``x`` and ``y`` is contained within this :py:class:`aspose.imaging.RectangleF` structure; otherwise false.'''
        raise NotImplementedError()
    
    @overload
    def contains(self, point : aspose.imaging.PointF) -> bool:
        '''Determines if the specified point is contained within this :py:class:`aspose.imaging.RectangleF` structure.
        
        :param point: The :py:class:`aspose.imaging.PointF` to test.
        :returns: This method returns true if the point represented by the ``point`` parameter is contained within this :py:class:`aspose.imaging.RectangleF` structure; otherwise false.'''
        raise NotImplementedError()
    
    @overload
    def contains(self, rect : aspose.imaging.RectangleF) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within the rectangular region represented by this :py:class:`aspose.imaging.RectangleF`; otherwise false.'''
        raise NotImplementedError()
    
    @overload
    def offset(self, pos : aspose.imaging.PointF) -> None:
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param pos: The amount to offset the location.'''
        raise NotImplementedError()
    
    @overload
    def offset(self, x : float, y : float) -> None:
        '''Adjusts the location of this rectangle by the specified amount.
        
        :param x: The amount to offset the location horizontally.
        :param y: The amount to offset the location vertically.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_points(point1 : aspose.imaging.PointF, point2 : aspose.imaging.PointF) -> aspose.imaging.RectangleF:
        '''Creates a new :py:class:`aspose.imaging.Rectangle` from two points specified. Two verticles of the created :py:class:`aspose.imaging.Rectangle` will be equal to the passed ``point1`` and ``point2``. These would be typically the opposite vertices.
        
        :param point1: The first :py:class:`aspose.imaging.Point` for the new rectangle.
        :param point2: The second :py:class:`aspose.imaging.Point` for the new rectangle.
        :returns: A newly created :py:class:`aspose.imaging.Rectangle`.'''
        raise NotImplementedError()
    
    @staticmethod
    def inflate_rect(rect : aspose.imaging.RectangleF, x : float, y : float) -> aspose.imaging.RectangleF:
        '''Creates and returns an inflated copy of the specified :py:class:`aspose.imaging.RectangleF` structure. The copy is inflated by the specified amount. The original rectangle remains unmodified.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` to be copied. This rectangle is not modified.
        :param x: The amount to inflate the copy of the rectangle horizontally.
        :param y: The amount to inflate the copy of the rectangle vertically.
        :returns: The inflated :py:class:`aspose.imaging.RectangleF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def intersect_rects(a : aspose.imaging.RectangleF, b : aspose.imaging.RectangleF) -> aspose.imaging.RectangleF:
        '''Returns a :py:class:`aspose.imaging.RectangleF` structure that represents the intersection of two rectangles. If there is no intersection, and empty :py:class:`aspose.imaging.RectangleF` is returned.
        
        :param a: A first rectangle to intersect.
        :param b: A second rectangle to intersect.
        :returns: A third :py:class:`aspose.imaging.RectangleF` structure the size of which represents the overlapped area of the two specified rectangles.'''
        raise NotImplementedError()
    
    @staticmethod
    def union(a : aspose.imaging.RectangleF, b : aspose.imaging.RectangleF) -> aspose.imaging.RectangleF:
        '''Creates the smallest possible third rectangle that can contain both of two rectangles that form a union.
        
        :param a: A first rectangle to union.
        :param b: A second rectangle to union.
        :returns: A third :py:class:`aspose.imaging.RectangleF` structure that contains both of the two rectangles that form the union.'''
        raise NotImplementedError()
    
    @staticmethod
    def from_left_top_right_bottom(left : float, top : float, right : float, bottom : float) -> aspose.imaging.RectangleF:
        '''Creates a :py:class:`aspose.imaging.RectangleF` structure with upper-left corner and lower-right corner at the specified locations.
        
        :param left: The x-coordinate of the upper-left corner of the rectangular region.
        :param top: The y-coordinate of the upper-left corner of the rectangular region.
        :param right: The x-coordinate of the lower-right corner of the rectangular region.
        :param bottom: The y-coordinate of the lower-right corner of the rectangular region.
        :returns: The new :py:class:`aspose.imaging.RectangleF` that this method creates.'''
        raise NotImplementedError()
    
    def normalize(self) -> None:
        '''Normalizes the rectangle by making it\'s width and height positive, left less than right and top less than bottom.'''
        raise NotImplementedError()
    
    def contains_point_f(self, point : aspose.imaging.PointF) -> bool:
        '''Determines if the specified point is contained within this :py:class:`aspose.imaging.RectangleF` structure.
        
        :param point: The :py:class:`aspose.imaging.PointF` to test.
        :returns: This method returns true if the point represented by the ``point`` parameter is contained within this :py:class:`aspose.imaging.RectangleF` structure; otherwise false.'''
        raise NotImplementedError()
    
    def contains_rect_f(self, rect : aspose.imaging.RectangleF) -> bool:
        '''Determines if the rectangular region represented by ``rect`` is entirely contained within this :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` to test.
        :returns: This method returns true if the rectangular region represented by ``rect`` is entirely contained within the rectangular region represented by this :py:class:`aspose.imaging.RectangleF`; otherwise false.'''
        raise NotImplementedError()
    
    def intersects_with(self, rect : aspose.imaging.RectangleF) -> bool:
        '''Determines if this rectangle intersects with ``rect``.
        
        :param rect: The rectangle to test.
        :returns: This method returns true if there is any intersection.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.RectangleF:
        '''Gets a new instance of the :py:class:`aspose.imaging.RectangleF` structure that has :py:attr:`aspose.imaging.RectangleF.x`, :py:attr:`aspose.imaging.RectangleF.y`, :py:attr:`aspose.imaging.RectangleF.width` and :py:attr:`aspose.imaging.RectangleF.height` values set to zero.'''
        raise NotImplementedError()

    @property
    def location(self) -> aspose.imaging.PointF:
        '''Gets the coordinates of the upper-left corner of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @location.setter
    def location(self, value : aspose.imaging.PointF) -> None:
        '''Sets the coordinates of the upper-left corner of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.SizeF:
        '''Gets the size of this :py:class:`aspose.imaging.RectangleF`.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : aspose.imaging.SizeF) -> None:
        '''Sets the size of this :py:class:`aspose.imaging.RectangleF`.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> float:
        '''Gets the x-coordinate of the upper-left corner of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : float) -> None:
        '''Sets the x-coordinate of the upper-left corner of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> float:
        '''Gets the y-coordinate of the upper-left corner of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : float) -> None:
        '''Sets the y-coordinate of the upper-left corner of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Gets the width of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : float) -> None:
        '''Sets the width of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> float:
        '''Gets the height of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : float) -> None:
        '''Sets the height of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def left(self) -> float:
        '''Gets the x-coordinate of the left edge of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @left.setter
    def left(self, value : float) -> None:
        '''Sets the x-coordinate of the left edge of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def top(self) -> float:
        '''Gets the y-coordinate of the top edge of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @top.setter
    def top(self, value : float) -> None:
        '''Sets the y-coordinate of the top edge of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def right(self) -> float:
        '''Gets the x-coordinate that is the sum of :py:attr:`aspose.imaging.RectangleF.x` and :py:attr:`aspose.imaging.RectangleF.width` of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @right.setter
    def right(self, value : float) -> None:
        '''Sets the x-coordinate that is the sum of :py:attr:`aspose.imaging.RectangleF.x` and :py:attr:`aspose.imaging.RectangleF.width` of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def bottom(self) -> float:
        '''Gets the y-coordinate that is the sum of :py:attr:`aspose.imaging.RectangleF.y` and :py:attr:`aspose.imaging.RectangleF.height` of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @bottom.setter
    def bottom(self, value : float) -> None:
        '''Sets the y-coordinate that is the sum of :py:attr:`aspose.imaging.RectangleF.y` and :py:attr:`aspose.imaging.RectangleF.height` of this :py:class:`aspose.imaging.RectangleF` structure.'''
        raise NotImplementedError()
    
    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether the :py:attr:`aspose.imaging.RectangleF.width` or :py:attr:`aspose.imaging.RectangleF.height` property of this :py:class:`aspose.imaging.RectangleF` has a value of zero.'''
        raise NotImplementedError()
    

class Region:
    '''Describes the interior of a graphics shape composed of rectangles and paths. This class cannot be inherited.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, rect : aspose.imaging.RectangleF) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Region` from the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: A :py:class:`aspose.imaging.RectangleF` structure that defines the interior of the new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, rect : aspose.imaging.Rectangle) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Region` from the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: A :py:class:`aspose.imaging.Rectangle` structure that defines the interior of the new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Initializes a new :py:class:`aspose.imaging.Region` with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: A :py:class:`aspose.imaging.GraphicsPath` that defines the new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def intersect(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def union(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def union(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def union(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def union(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def xor(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def xor(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def xor(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def xor(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def exclude(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def exclude(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def exclude(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def exclude(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def complement(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.RectangleF` structure that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to complement this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def complement(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.Rectangle` structure that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to complement this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def complement(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.GraphicsPath` that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to complement this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @overload
    def complement(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.Region` that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` object to complement this :py:class:`aspose.imaging.Region` object.'''
        raise NotImplementedError()
    
    @overload
    def translate(self, dx : float, dy : float) -> None:
        '''Offsets the coordinates of this :py:class:`aspose.imaging.Region` by the specified amount.
        
        :param dx: The amount to offset this :py:class:`aspose.imaging.Region` horizontally.
        :param dy: The amount to offset this :py:class:`aspose.imaging.Region` vertically.'''
        raise NotImplementedError()
    
    @overload
    def translate(self, dx : int, dy : int) -> None:
        '''Offsets the coordinates of this :py:class:`aspose.imaging.Region` by the specified amount.
        
        :param dx: The amount to offset this :py:class:`aspose.imaging.Region` horizontally.
        :param dy: The amount to offset this :py:class:`aspose.imaging.Region` vertically.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : float, y : float) -> bool:
        '''Tests whether the specified point is contained within this :py:class:`aspose.imaging.Region`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: True when the specified point is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, point : aspose.imaging.PointF) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.PointF` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param point: The :py:class:`aspose.imaging.PointF` structure to test.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : float, y : float, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: True when the specified point is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, point : aspose.imaging.PointF, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.PointF` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param point: The :py:class:`aspose.imaging.PointF` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : float, y : float, width : float, height : float) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region` object; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, rect : aspose.imaging.RectangleF) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.RectangleF` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to test.
        :returns: true when any portion of ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : float, y : float, width : float, height : float, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, rect : aspose.imaging.RectangleF, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.RectangleF` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : int, y : int, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this :py:class:`aspose.imaging.Region` object when drawn using the specified :py:class:`aspose.imaging.Graphics` object.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when the specified point is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, point : aspose.imaging.Point) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.Point` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param point: The :py:class:`aspose.imaging.Point` structure to test.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, point : aspose.imaging.Point, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.Point` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param point: The :py:class:`aspose.imaging.Point` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : int, y : int, width : int, height : int) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, rect : aspose.imaging.Rectangle) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.Rectangle` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to test.
        :returns: This method returns true when any portion of ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, x : int, y : int, width : int, height : int, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @overload
    def is_visible(self, rect : aspose.imaging.Rectangle, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.Rectangle` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when any portion of the ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_rect_f(rect : aspose.imaging.RectangleF) -> aspose.imaging.Region:
        '''Initializes a new :py:class:`aspose.imaging.Region` from the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: A :py:class:`aspose.imaging.RectangleF` structure that defines the interior of the new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_rect(rect : aspose.imaging.Rectangle) -> aspose.imaging.Region:
        '''Initializes a new :py:class:`aspose.imaging.Region` from the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: A :py:class:`aspose.imaging.Rectangle` structure that defines the interior of the new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_with_path(path : aspose.imaging.GraphicsPath) -> aspose.imaging.Region:
        '''Initializes a new :py:class:`aspose.imaging.Region` with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: A :py:class:`aspose.imaging.GraphicsPath` that defines the new :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def deep_clone(self) -> aspose.imaging.Region:
        '''Creates an exact deep copy of this :py:class:`aspose.imaging.Region`.
        
        :returns: The :py:class:`aspose.imaging.Region` that this method creates.'''
        raise NotImplementedError()
    
    def make_infinite(self) -> None:
        '''Initializes this :py:class:`aspose.imaging.Region` object to an infinite interior.'''
        raise NotImplementedError()
    
    def make_empty(self) -> None:
        '''Initializes this :py:class:`aspose.imaging.Region` to an empty interior.'''
        raise NotImplementedError()
    
    def intersect_rect_f(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def intersect_rect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def intersect_path(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def intersect_rgn(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the intersection of itself with the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to intersect with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def union_rect_f(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def union_rect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def union_path(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def union_rgn(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union of itself and the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to unite with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def xor_rect_f(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def xor_rect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def xor_path(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def xor_rgn(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to the union minus the intersection of itself with the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to xor with this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def exclude_rect_f(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.RectangleF` structure.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def exclude_rect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.Rectangle` structure.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def exclude_path(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.GraphicsPath`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def exclude_rgn(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain only the portion of its interior that does not intersect with the specified :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` to exclude from this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def complement_rect_f(self, rect : aspose.imaging.RectangleF) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.RectangleF` structure that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to complement this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def complement_rect(self, rect : aspose.imaging.Rectangle) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.Rectangle` structure that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to complement this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def complement_path(self, path : aspose.imaging.GraphicsPath) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.GraphicsPath` that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param path: The :py:class:`aspose.imaging.GraphicsPath` to complement this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def complement_rgn(self, region : aspose.imaging.Region) -> None:
        '''Updates this :py:class:`aspose.imaging.Region` to contain the portion of the specified :py:class:`aspose.imaging.Region` that does not intersect with this :py:class:`aspose.imaging.Region`.
        
        :param region: The :py:class:`aspose.imaging.Region` object to complement this :py:class:`aspose.imaging.Region` object.'''
        raise NotImplementedError()
    
    def translate_f(self, dx : float, dy : float) -> None:
        '''Offsets the coordinates of this :py:class:`aspose.imaging.Region` by the specified amount.
        
        :param dx: The amount to offset this :py:class:`aspose.imaging.Region` horizontally.
        :param dy: The amount to offset this :py:class:`aspose.imaging.Region` vertically.'''
        raise NotImplementedError()
    
    def transform(self, matrix : aspose.imaging.Matrix) -> None:
        '''Transforms this :py:class:`aspose.imaging.Region` by the specified :py:class:`aspose.imaging.Matrix`.
        
        :param matrix: The :py:class:`aspose.imaging.Matrix` by which to transform this :py:class:`aspose.imaging.Region`.'''
        raise NotImplementedError()
    
    def is_empty(self, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether this :py:class:`aspose.imaging.Region` has an empty interior on the specified drawing surface.
        
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a drawing surface.
        :returns: true if the interior of this :py:class:`aspose.imaging.Region` is empty when the transformation associated with ``g`` is applied; otherwise, false.'''
        raise NotImplementedError()
    
    def is_infinite(self, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether this :py:class:`aspose.imaging.Region` has an infinite interior on the specified drawing surface.
        
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a drawing surface.
        :returns: true if the interior of this :py:class:`aspose.imaging.Region` is infinite when the transformation associated with ``g`` is applied; otherwise, false.'''
        raise NotImplementedError()
    
    def equals(self, region : aspose.imaging.Region, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.Region` is identical to this :py:class:`aspose.imaging.Region` on the specified drawing surface.
        
        :param region: The :py:class:`aspose.imaging.Region` to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a drawing surface.
        :returns: True if the interior of region is identical to the interior of this region when the transformation associated with the ``g`` parameter is applied; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_f(self, x : float, y : float) -> bool:
        '''Tests whether the specified point is contained within this :py:class:`aspose.imaging.Region`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :returns: True when the specified point is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point_f(self, point : aspose.imaging.PointF) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.PointF` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param point: The :py:class:`aspose.imaging.PointF` structure to test.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_with_graphics_f(self, x : float, y : float, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: True when the specified point is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point_f_with_graphics(self, point : aspose.imaging.PointF, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.PointF` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param point: The :py:class:`aspose.imaging.PointF` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xywhf(self, x : float, y : float, width : float, height : float) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region` object; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_rect_f(self, rect : aspose.imaging.RectangleF) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.RectangleF` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to test.
        :returns: true when any portion of ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xywh_graphics_f(self, x : float, y : float, width : float, height : float, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_rect_f_with_graphics(self, rect : aspose.imaging.RectangleF, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.RectangleF` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param rect: The :py:class:`aspose.imaging.RectangleF` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_with_graphics(self, x : int, y : int, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified point is contained within this :py:class:`aspose.imaging.Region` object when drawn using the specified :py:class:`aspose.imaging.Graphics` object.
        
        :param x: The x-coordinate of the point to test.
        :param y: The y-coordinate of the point to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when the specified point is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point(self, point : aspose.imaging.Point) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.Point` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param point: The :py:class:`aspose.imaging.Point` structure to test.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_point_with_graphics(self, point : aspose.imaging.Point, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether the specified :py:class:`aspose.imaging.Point` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param point: The :py:class:`aspose.imaging.Point` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when ``point`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xywh(self, x : int, y : int, width : int, height : int) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_rect(self, rect : aspose.imaging.Rectangle) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.Rectangle` structure is contained within this :py:class:`aspose.imaging.Region`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to test.
        :returns: This method returns true when any portion of ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_xywh_graphics(self, x : int, y : int, width : int, height : int, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param x: The x-coordinate of the upper-left corner of the rectangle to test.
        :param y: The y-coordinate of the upper-left corner of the rectangle to test.
        :param width: The width of the rectangle to test.
        :param height: The height of the rectangle to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when any portion of the specified rectangle is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    
    def is_visible_rect_with_graphics(self, rect : aspose.imaging.Rectangle, g : aspose.imaging.Graphics) -> bool:
        '''Tests whether any portion of the specified :py:class:`aspose.imaging.Rectangle` structure is contained within this :py:class:`aspose.imaging.Region` when drawn using the specified :py:class:`aspose.imaging.Graphics`.
        
        :param rect: The :py:class:`aspose.imaging.Rectangle` structure to test.
        :param g: A :py:class:`aspose.imaging.Graphics` that represents a graphics context.
        :returns: true when any portion of the ``rect`` is contained within this :py:class:`aspose.imaging.Region`; otherwise, false.'''
        raise NotImplementedError()
    

class RemoveBackgroundSettings:
    '''The remve background settings'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def detection_level(self) -> System.Nullable`1[[System.Int32]]:
        '''Gets the detection level.'''
        raise NotImplementedError()
    
    @detection_level.setter
    def detection_level(self, value : System.Nullable`1[[System.Int32]]) -> None:
        '''Sets the detection level.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> System.Nullable`1[[Aspose.Imaging.RectangleF]]:
        '''Gets the bounds.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : System.Nullable`1[[Aspose.Imaging.RectangleF]]) -> None:
        '''Sets the bounds.'''
        raise NotImplementedError()
    
    @property
    def color1(self) -> System.Nullable`1[[Aspose.Imaging.Color]]:
        '''Gets the color.'''
        raise NotImplementedError()
    
    @color1.setter
    def color1(self, value : System.Nullable`1[[Aspose.Imaging.Color]]) -> None:
        '''Sets the color.'''
        raise NotImplementedError()
    
    @property
    def color2(self) -> System.Nullable`1[[Aspose.Imaging.Color]]:
        '''Gets the color2.'''
        raise NotImplementedError()
    
    @color2.setter
    def color2(self, value : System.Nullable`1[[Aspose.Imaging.Color]]) -> None:
        '''Sets the color2.'''
        raise NotImplementedError()
    

class ResolutionSetting:
    '''The resolution setting for image save options.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ResolutionSetting` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, horizontal_resolution : float, vertical_resolution : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.ResolutionSetting` class.
        
        :param horizontal_resolution: The horizontal resolution.
        :param vertical_resolution: The vertical resolution.'''
        raise NotImplementedError()
    
    @property
    def horizontal_resolution(self) -> float:
        '''Gets the horizontal resolution.'''
        raise NotImplementedError()
    
    @horizontal_resolution.setter
    def horizontal_resolution(self, value : float) -> None:
        '''Sets the horizontal resolution.'''
        raise NotImplementedError()
    
    @property
    def vertical_resolution(self) -> float:
        '''Gets the vertical resolution.'''
        raise NotImplementedError()
    
    @vertical_resolution.setter
    def vertical_resolution(self, value : float) -> None:
        '''Sets the vertical resolution.'''
        raise NotImplementedError()
    

class Shape(ObjectWithBounds):
    '''The shape. A continuous set of points connected using a specific rule.'''
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    @overload
    def get_bounds(self, matrix : aspose.imaging.Matrix, pen : aspose.imaging.Pen) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.
        
        :param matrix: The matrix to apply before bounds will be calculated.
        :param pen: The pen to use for object. This can influence the object\'s bounds size.
        :returns: The estimated object\'s bounds.'''
        raise NotImplementedError()
    
    def transform(self, transform : aspose.imaging.Matrix) -> None:
        '''Applies the specified transformation to the shape.
        
        :param transform: The transformation to apply.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.RectangleF:
        '''Gets the object\'s bounds.'''
        raise NotImplementedError()
    
    @property
    def center(self) -> aspose.imaging.PointF:
        '''Gets the shape\'s center.'''
        raise NotImplementedError()
    
    @property
    def segments(self) -> List[aspose.imaging.ShapeSegment]:
        '''Gets the shape segments.'''
        raise NotImplementedError()
    
    @property
    def has_segments(self) -> bool:
        '''Gets a value indicating whether shape has segments.'''
        raise NotImplementedError()
    

class ShapeSegment:
    '''Represents a shape segment. A segment is a line or curve connecting two points.'''
    
    @property
    def start_point(self) -> aspose.imaging.PointF:
        '''Gets the starting point.'''
        raise NotImplementedError()
    
    @property
    def end_point(self) -> aspose.imaging.PointF:
        '''Gets the ending point.'''
        raise NotImplementedError()
    

class Size:
    '''Represents size.'''
    
    @overload
    def __init__(self, point : aspose.imaging.Point) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Size` structure from the specified :py:class:`aspose.imaging.Point`.
        
        :param point: The :py:class:`aspose.imaging.Point` from which to initialize this :py:class:`aspose.imaging.Size`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, width : int, height : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.Size` structure from the specified dimensions.
        
        :param width: The width component of the new :py:class:`aspose.imaging.Size`.
        :param height: The height component of the new :py:class:`aspose.imaging.Size`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def add(size1 : aspose.imaging.Size, size2 : aspose.imaging.Size) -> aspose.imaging.Size:
        '''Adds the width and height of one :py:class:`aspose.imaging.Size` structure to the width and height of another :py:class:`aspose.imaging.Size` structure.
        
        :param size1: The first :py:class:`aspose.imaging.Size` to add.
        :param size2: The second :py:class:`aspose.imaging.Size` to add.
        :returns: A :py:class:`aspose.imaging.Size` structure that is the result of the addition operation.'''
        raise NotImplementedError()
    
    @staticmethod
    def ceiling(size : aspose.imaging.SizeF) -> aspose.imaging.Size:
        '''Converts the specified :py:class:`aspose.imaging.SizeF` structure to a :py:class:`aspose.imaging.Size` structure by rounding the values of the :py:class:`aspose.imaging.Size` structure to the next higher integer values.
        
        :param size: The :py:class:`aspose.imaging.SizeF` structure to convert.
        :returns: The :py:class:`aspose.imaging.Size` structure this method converts to.'''
        raise NotImplementedError()
    
    @staticmethod
    def subtract(size1 : aspose.imaging.Size, size2 : aspose.imaging.Size) -> aspose.imaging.Size:
        '''Subtracts the width and height of one :py:class:`aspose.imaging.Size` structure from the width and height of another :py:class:`aspose.imaging.Size` structure.
        
        :param size1: The :py:class:`aspose.imaging.Size` structure on the left side of the subtraction operator.
        :param size2: The :py:class:`aspose.imaging.Size` structure on the right side of the subtraction operator.
        :returns: The :py:class:`aspose.imaging.Size` that is a result of the subtraction operation.'''
        raise NotImplementedError()
    
    @staticmethod
    def truncate(size : aspose.imaging.SizeF) -> aspose.imaging.Size:
        '''Converts the specified :py:class:`aspose.imaging.SizeF` structure to a :py:class:`aspose.imaging.Size` structure by truncating the values of the :py:class:`aspose.imaging.SizeF` structure to the next lower integer values.
        
        :param size: The :py:class:`aspose.imaging.SizeF` structure to convert.
        :returns: The :py:class:`aspose.imaging.Size` structure this method converts to.'''
        raise NotImplementedError()
    
    @staticmethod
    def round(size : aspose.imaging.SizeF) -> aspose.imaging.Size:
        '''Converts the specified :py:class:`aspose.imaging.SizeF` structure to a :py:class:`aspose.imaging.Size` structure by rounding the values of the :py:class:`aspose.imaging.SizeF` structure to the nearest integer values.
        
        :param size: The :py:class:`aspose.imaging.SizeF` structure to convert.
        :returns: The :py:class:`aspose.imaging.Size` structure this method converts to.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.Size:
        '''Gets a new instance of the :py:class:`aspose.imaging.Size` structure that has :py:attr:`aspose.imaging.Size.width` and :py:attr:`aspose.imaging.Size.height` values set to zero.'''
        raise NotImplementedError()

    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.Size` has width and height of 0.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the horizontal component of this :py:class:`aspose.imaging.Size`.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the horizontal component of this :py:class:`aspose.imaging.Size`.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the vertical component of this :py:class:`aspose.imaging.Size`.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the vertical component of this :py:class:`aspose.imaging.Size`.'''
        raise NotImplementedError()
    

class SizeF:
    '''Stores an ordered pair of floating-point numbers, typically the width and height of a rectangle.'''
    
    @overload
    def __init__(self, size : aspose.imaging.SizeF) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SizeF` structure from the specified :py:class:`aspose.imaging.SizeF`.
        
        :param size: The :py:class:`aspose.imaging.SizeF` from which to create the new :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, point : aspose.imaging.PointF) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SizeF` structure from the specified :py:class:`aspose.imaging.PointF`.
        
        :param point: The :py:class:`aspose.imaging.PointF` from which to initialize this :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, width : float, height : float) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SizeF` structure from the specified dimensions.
        
        :param width: The width component of the new :py:class:`aspose.imaging.SizeF`.
        :param height: The height component of the new :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @staticmethod
    def create_from_size_f(size : aspose.imaging.SizeF) -> aspose.imaging.SizeF:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SizeF` structure from the specified :py:class:`aspose.imaging.SizeF`.
        
        :param size: The :py:class:`aspose.imaging.SizeF` from which to create the new :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_point_f(point : aspose.imaging.PointF) -> aspose.imaging.SizeF:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SizeF` structure from the specified :py:class:`aspose.imaging.PointF`.
        
        :param point: The :py:class:`aspose.imaging.PointF` from which to initialize this :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @staticmethod
    def add(size1 : aspose.imaging.SizeF, size2 : aspose.imaging.SizeF) -> aspose.imaging.SizeF:
        '''Adds the width and height of one :py:class:`aspose.imaging.SizeF` structure to the width and height of another :py:class:`aspose.imaging.SizeF` structure.
        
        :param size1: The first :py:class:`aspose.imaging.SizeF` to add.
        :param size2: The second :py:class:`aspose.imaging.SizeF` to add.
        :returns: A :py:class:`aspose.imaging.SizeF` structure that is the result of the addition operation.'''
        raise NotImplementedError()
    
    @staticmethod
    def subtract(size1 : aspose.imaging.SizeF, size2 : aspose.imaging.SizeF) -> aspose.imaging.SizeF:
        '''Subtracts the width and height of one :py:class:`aspose.imaging.SizeF` structure from the width and height of another :py:class:`aspose.imaging.SizeF` structure.
        
        :param size1: The :py:class:`aspose.imaging.SizeF` structure on the left side of the subtraction operator.
        :param size2: The :py:class:`aspose.imaging.SizeF` structure on the right side of the subtraction operator.
        :returns: The :py:class:`aspose.imaging.SizeF` that is a result of the subtraction operation.'''
        raise NotImplementedError()
    
    def to_point_f(self) -> aspose.imaging.PointF:
        '''Converts a :py:class:`aspose.imaging.SizeF` to a :py:class:`aspose.imaging.PointF`.
        
        :returns: Returns a :py:class:`aspose.imaging.PointF` structure.'''
        raise NotImplementedError()
    
    def to_size(self) -> aspose.imaging.Size:
        '''Converts a :py:class:`aspose.imaging.SizeF` to a :py:class:`aspose.imaging.Size` structure with truncated size values.
        
        :returns: Returns a :py:class:`aspose.imaging.Size` structure.'''
        raise NotImplementedError()
    
    @property
    def empty(self) -> aspose.imaging.SizeF:
        '''Gets a new instance of the :py:class:`aspose.imaging.SizeF` structure that has :py:attr:`aspose.imaging.SizeF.width` and :py:attr:`aspose.imaging.SizeF.height` values set to zero.'''
        raise NotImplementedError()

    @property
    def is_empty(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.SizeF` has zero width and height.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Gets the horizontal component of this :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : float) -> None:
        '''Sets the horizontal component of this :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> float:
        '''Gets the vertical component of this :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : float) -> None:
        '''Sets the vertical component of this :py:class:`aspose.imaging.SizeF`.'''
        raise NotImplementedError()
    

class Source:
    '''The source is used to contain all relevant information for an object pipe.'''
    
    def get_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the stream container.
        
        :returns: the stream container.'''
        raise NotImplementedError()
    

class SplitStreamContainer(StreamContainer):
    '''Represents split stream container which contains the stream and provides stream processing routines.'''
    
    @overload
    def __init__(self, stream : io._IOBase) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SplitStreamContainer` class.
        
        :param stream: The stream.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, stream : io._IOBase, dispose_stream : bool) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SplitStreamContainer` class.
        
        :param stream: The data stream.
        :param dispose_stream: if set to ``true`` the stream will be disposed when container is disposed.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, stream : aspose.imaging.StreamContainer, dispose_stream : bool) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SplitStreamContainer` class.
        
        :param stream: The stream container.
        :param dispose_stream: if set to ``true`` disposes stream.'''
        raise NotImplementedError()
    
    @overload
    def write(self, bytes : List[int]) -> None:
        '''Writes all of the specified bytes to the stream.
        
        :param bytes: The bytes to write.'''
        raise NotImplementedError()
    
    @overload
    def write(self, buffer : List[int], offset : int, count : int) -> None:
        '''Writes a sequence of bytes to the current stream and advances the current position within this stream by the number of bytes written.
        
        :param buffer: An array of bytes. This method copies ``count`` bytes from ``buffer`` to the current stream.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin copying bytes to the current stream.
        :param count: The number of bytes to be written to the current stream.'''
        raise NotImplementedError()
    
    @overload
    def read(self, bytes : List[int]) -> int:
        '''Reads bytes to fill the specified bytes buffer.
        
        :param bytes: The bytes to fill.
        :returns: The number of bytes read. This value can be less than the number of bytes in the buffer if there is not enough bytes in the stream.'''
        raise NotImplementedError()
    
    @overload
    def read(self, buffer : List[int], offset : int, count : int) -> int:
        '''Reads a sequence of bytes from the current stream and advances the position within the stream by the number of bytes read.
        
        :param buffer: An array of bytes. When this method returns, the buffer contains the specified byte array with the values between ``offset`` and (``offset`` + ``count`` - 1) replaced by the bytes read from the current source.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin storing the data read from the current stream.
        :param count: The maximum number of bytes to be read from the current stream.
        :returns: The total number of bytes read into the buffer. This can be less than the number of bytes requested if that many bytes are not currently available, or zero (0) if the end of the stream has been reached.'''
        raise NotImplementedError()
    
    @overload
    def to_bytes(self) -> List[int]:
        '''Converts the stream data to the :py:class:`int` array.
        
        :returns: The stream data converted to the :py:class:`int` array.'''
        raise NotImplementedError()
    
    @overload
    def to_bytes(self, position : int, bytes_count : int) -> List[int]:
        '''Converts the stream data to the :py:class:`int` array.
        
        :param position: The position to start reading bytes from.
        :param bytes_count: The bytes count to read.
        :returns: The stream data converted to the :py:class:`int` array.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.SplitStreamContainer.length` value.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase, buffer_size : int) -> None:
        '''Saves (copies) all the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, buffer_size : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @overload
    def write_to(self, stream_container : aspose.imaging.StreamContainer) -> None:
        '''Copies the contained data to another :py:class:`aspose.imaging.StreamContainer`.
        
        :param stream_container: The stream container to copy to.'''
        raise NotImplementedError()
    
    @overload
    def write_to(self, stream_container : aspose.imaging.StreamContainer, length : int) -> None:
        '''Copies the contained data to another :py:class:`aspose.imaging.StreamContainer`.
        
        :param stream_container: The stream container to copy to.
        :param length: The bytes count to write.'''
        raise NotImplementedError()
    
    def flush(self) -> None:
        '''Clears all buffers for this stream and causes any buffered data to be written to the underlying device.'''
        raise NotImplementedError()
    
    def write_byte(self, value : int) -> None:
        '''Writes a byte to the current position in the stream and advances the position within the stream by one byte.
        
        :param value: The byte to write to the stream.'''
        raise NotImplementedError()
    
    def read_byte(self) -> int:
        '''Reads a byte from the stream and advances the position within the stream by one byte, or returns -1 if at the end of the stream.
        
        :returns: The unsigned byte cast to an Int32, or -1 if at the end of the stream.'''
        raise NotImplementedError()
    
    def seek(self, offset : int, origin : aspose.imaging.SeekOrigin) -> int:
        '''Sets the position within the current stream.
        
        :param offset: A byte offset relative to the ``origin`` parameter. This value represents offset from the starting stream position passed in the StreamContainer constructor.
        :param origin: A value of type :py:class:`System.IO.SeekOrigin` indicating the reference point used to obtain the new position.
        :returns: The new position within the current stream.'''
        raise NotImplementedError()
    
    def seek_begin(self) -> None:
        '''Sets the stream position to the beginning of the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    def save_to_stream(self, destination_stream : io._IOBase) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.'''
        raise NotImplementedError()
    
    def save_to_stream_with_buf_size(self, destination_stream : io._IOBase, buffer_size : int) -> None:
        '''Saves (copies) all the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        raise NotImplementedError()
    
    def save_to_stream_with_buf_size_and_len(self, destination_stream : io._IOBase, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    def save_with_buf_size(self, file_path : str, buffer_size : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.'''
        raise NotImplementedError()
    
    def save_with_buf_size_and_len(self, file_path : str, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_stream(stream : io._IOBase, dispose_stream : bool) -> aspose.imaging.SplitStreamContainer:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SplitStreamContainer` class.
        
        :param stream: The data stream.
        :param dispose_stream: if set to ``true`` the stream will be disposed when container is disposed.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_stream_container(stream : aspose.imaging.StreamContainer, dispose_stream : bool) -> aspose.imaging.SplitStreamContainer:
        '''Initializes a new instance of the :py:class:`aspose.imaging.SplitStreamContainer` class.
        
        :param stream: The stream container.
        :param dispose_stream: if set to ``true`` disposes stream.'''
        raise NotImplementedError()
    
    def insert(self, position : int, stream : aspose.imaging.StreamContainer, dispose_stream : bool) -> None:
        '''Inserts the stream container into specified position.
        
        :param position: The position to insert to.
        :param stream: The stream container to insert.
        :param dispose_stream: if set to ``true`` disposes stream.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def sync_root(self) -> Any:
        '''Gets an object that can be used to synchronize access to the synchronized resource.'''
        raise NotImplementedError()
    
    @property
    def position(self) -> int:
        '''Gets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : int) -> None:
        '''Sets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @property
    def stream(self) -> io._IOBase:
        '''Gets the data stream.'''
        raise NotImplementedError()
    
    @property
    def is_stream_disposed_on_close(self) -> bool:
        '''Gets a value indicating whether this stream is disposed on close.'''
        raise NotImplementedError()
    
    @property
    def length(self) -> int:
        '''Gets the stream length in bytes. This value is less than the :py:attr:`io._IOBase.Length` by the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @length.setter
    def length(self, value : int) -> None:
        '''Sets the stream length in bytes. This value is less than the :py:attr:`io._IOBase.Length` by the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @property
    def can_read(self) -> bool:
        '''Gets a value indicating whether stream supports reading.'''
        raise NotImplementedError()
    
    @property
    def can_seek(self) -> bool:
        '''Gets a value indicating whether stream supports seeking.'''
        raise NotImplementedError()
    
    @property
    def can_write(self) -> bool:
        '''Gets a value indicating whether stream supports writing.'''
        raise NotImplementedError()
    
    @property
    def READ_WRITE_BYTES_COUNT(self) -> int:
        '''Specifies read and write bytes count when reading sequentially.'''
        raise NotImplementedError()


class StreamContainer(DisposableObject):
    '''Represents stream container which contains the stream and provides stream processing routines.'''
    
    @overload
    def __init__(self, stream : io._IOBase) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.StreamContainer` class.
        
        :param stream: The stream.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, stream : io._IOBase, dispose_stream : bool) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.StreamContainer` class.
        
        :param stream: The data stream.
        :param dispose_stream: if set to ``true`` the stream will be disposed when container is disposed.'''
        raise NotImplementedError()
    
    @overload
    def write(self, bytes : List[int]) -> None:
        '''Writes all of the specified bytes to the stream.
        
        :param bytes: The bytes to write.'''
        raise NotImplementedError()
    
    @overload
    def write(self, buffer : List[int], offset : int, count : int) -> None:
        '''Writes a sequence of bytes to the current stream and advances the current position within this stream by the number of bytes written.
        
        :param buffer: An array of bytes. This method copies ``count`` bytes from ``buffer`` to the current stream.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin copying bytes to the current stream.
        :param count: The number of bytes to be written to the current stream.'''
        raise NotImplementedError()
    
    @overload
    def read(self, bytes : List[int]) -> int:
        '''Reads bytes to fill the specified bytes buffer.
        
        :param bytes: The bytes to fill.
        :returns: The number of bytes read. This value can be less than the number of bytes in the buffer if there is not enough bytes in the stream.'''
        raise NotImplementedError()
    
    @overload
    def read(self, buffer : List[int], offset : int, count : int) -> int:
        '''Reads a sequence of bytes from the current stream and advances the position within the stream by the number of bytes read.
        
        :param buffer: An array of bytes. When this method returns, the buffer contains the specified byte array with the values between ``offset`` and (``offset`` + ``count`` - 1) replaced by the bytes read from the current source.
        :param offset: The zero-based byte offset in ``buffer`` at which to begin storing the data read from the current stream.
        :param count: The maximum number of bytes to be read from the current stream.
        :returns: The total number of bytes read into the buffer. This can be less than the number of bytes requested if that many bytes are not currently available, or zero (0) if the end of the stream has been reached.'''
        raise NotImplementedError()
    
    @overload
    def to_bytes(self) -> List[int]:
        '''Converts the stream data to the :py:class:`int` array.
        
        :returns: The stream data converted to the :py:class:`int` array.'''
        raise NotImplementedError()
    
    @overload
    def to_bytes(self, position : int, bytes_count : int) -> List[int]:
        '''Converts the stream data to the :py:class:`int` array.
        
        :param position: The position to start reading bytes from.
        :param bytes_count: The bytes count to read.
        :returns: The stream data converted to the :py:class:`int` array.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase, buffer_size : int) -> None:
        '''Saves (copies) all the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        raise NotImplementedError()
    
    @overload
    def save(self, destination_stream : io._IOBase, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, buffer_size : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @overload
    def write_to(self, stream_container : aspose.imaging.StreamContainer) -> None:
        '''Copies the contained data to another :py:class:`aspose.imaging.StreamContainer`.
        
        :param stream_container: The stream container to copy to.'''
        raise NotImplementedError()
    
    @overload
    def write_to(self, stream_container : aspose.imaging.StreamContainer, length : int) -> None:
        '''Copies the contained data to another :py:class:`aspose.imaging.StreamContainer`.
        
        :param stream_container: The stream container to copy to.
        :param length: The bytes count to write.'''
        raise NotImplementedError()
    
    def flush(self) -> None:
        '''Clears all buffers for this stream and causes any buffered data to be written to the underlying device.'''
        raise NotImplementedError()
    
    def write_byte(self, value : int) -> None:
        '''Writes a byte to the current position in the stream and advances the position within the stream by one byte.
        
        :param value: The byte to write to the stream.'''
        raise NotImplementedError()
    
    def read_byte(self) -> int:
        '''Reads a byte from the stream and advances the position within the stream by one byte, or returns -1 if at the end of the stream.
        
        :returns: The unsigned byte cast to an Int32, or -1 if at the end of the stream.'''
        raise NotImplementedError()
    
    def seek(self, offset : int, origin : aspose.imaging.SeekOrigin) -> int:
        '''Sets the position within the current stream.
        
        :param offset: A byte offset relative to the ``origin`` parameter. This value represents offset from the starting stream position passed in the StreamContainer constructor.
        :param origin: A value of type :py:class:`System.IO.SeekOrigin` indicating the reference point used to obtain the new position.
        :returns: The new position within the current stream.'''
        raise NotImplementedError()
    
    def seek_begin(self) -> None:
        '''Sets the stream position to the beginning of the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    def save_to_stream(self, destination_stream : io._IOBase) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses default buffer size :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` and stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.'''
        raise NotImplementedError()
    
    def save_to_stream_with_buf_size(self, destination_stream : io._IOBase, buffer_size : int) -> None:
        '''Saves (copies) all the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer.'''
        raise NotImplementedError()
    
    def save_to_stream_with_buf_size_and_len(self, destination_stream : io._IOBase, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param destination_stream: The stream to save the data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    def save_with_buf_size(self, file_path : str, buffer_size : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream. Uses stream :py:attr:`aspose.imaging.StreamContainer.length` value.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.'''
        raise NotImplementedError()
    
    def save_with_buf_size_and_len(self, file_path : str, buffer_size : int, length : int) -> None:
        '''Saves (copies) the stream\'s data to the specified stream.
        
        :param file_path: The file path to save the stream data to.
        :param buffer_size: The buffer size. By default :py:attr:`aspose.imaging.StreamContainer.READ_WRITE_BYTES_COUNT` value is used.
        :param length: The stream data length to copy. By default the length is set to :py:attr:`aspose.imaging.StreamContainer.length` value.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def sync_root(self) -> Any:
        '''Gets an object that can be used to synchronize access to the synchronized resource.'''
        raise NotImplementedError()
    
    @property
    def position(self) -> int:
        '''Gets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : int) -> None:
        '''Sets the current position within the stream. This value represents offset from the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @property
    def stream(self) -> io._IOBase:
        '''Gets the data stream.'''
        raise NotImplementedError()
    
    @property
    def is_stream_disposed_on_close(self) -> bool:
        '''Gets a value indicating whether this stream is disposed on close.'''
        raise NotImplementedError()
    
    @property
    def length(self) -> int:
        '''Gets the stream length in bytes. This value is less than the :py:attr:`io._IOBase.Length` by the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @length.setter
    def length(self, value : int) -> None:
        '''Sets the stream length in bytes. This value is less than the :py:attr:`io._IOBase.Length` by the starting stream position passed in the StreamContainer constructor.'''
        raise NotImplementedError()
    
    @property
    def can_read(self) -> bool:
        '''Gets a value indicating whether stream supports reading.'''
        raise NotImplementedError()
    
    @property
    def can_seek(self) -> bool:
        '''Gets a value indicating whether stream supports seeking.'''
        raise NotImplementedError()
    
    @property
    def can_write(self) -> bool:
        '''Gets a value indicating whether stream supports writing.'''
        raise NotImplementedError()
    
    @property
    def READ_WRITE_BYTES_COUNT(self) -> int:
        '''Specifies read and write bytes count when reading sequentially.'''
        raise NotImplementedError()


class StringFormat(DisposableObject):
    '''Encapsulates text layout information (such as alignment, orientation and tab stops) display manipulations (such as ellipsis insertion and national digit substitution) and OpenType features. This class cannot be inherited.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, options : aspose.imaging.StringFormatFlags) -> None:
        '''Initializes a new :py:class:`aspose.imaging.StringFormat` object with the specified :py:class:`aspose.imaging.StringFormatFlags` enumeration and language.
        
        :param options: The :py:class:`aspose.imaging.StringFormatFlags` enumeration for the new :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, format : aspose.imaging.StringFormat) -> None:
        '''Initializes a new :py:class:`aspose.imaging.StringFormat` object from the specified existing :py:class:`aspose.imaging.StringFormat` object.
        
        :param format: The :py:class:`aspose.imaging.StringFormat` object from which to initialize the new :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_flags(options : aspose.imaging.StringFormatFlags) -> aspose.imaging.StringFormat:
        '''Initializes a new :py:class:`aspose.imaging.StringFormat` object with the specified :py:class:`aspose.imaging.StringFormatFlags` enumeration and language.
        
        :param options: The :py:class:`aspose.imaging.StringFormatFlags` enumeration for the new :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_format(format : aspose.imaging.StringFormat) -> aspose.imaging.StringFormat:
        '''Initializes a new :py:class:`aspose.imaging.StringFormat` object from the specified existing :py:class:`aspose.imaging.StringFormat` object.
        
        :param format: The :py:class:`aspose.imaging.StringFormat` object from which to initialize the new :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    def deep_clone(self) -> aspose.imaging.StringFormat:
        '''Creates a deep clone of this :py:class:`aspose.imaging.StringFormat` object.
        
        :returns: The deep clone of the current :py:class:`aspose.imaging.StringFormat`.'''
        raise NotImplementedError()
    
    def set_tab_stops(self, first_tab_offset : float, tab_stops : List[float]) -> None:
        '''Sets tab stops for this :py:class:`aspose.imaging.StringFormat` object.
        
        :param first_tab_offset: The number of spaces between the beginning of a line of text and the first tab stop.
        :param tab_stops: An array of distances between tab stops in the units specified by the :py:attr:`aspose.imaging.Graphics.page_unit` property.'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def generic_default(self) -> aspose.imaging.StringFormat:
        '''Gets a generic default :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()

    @property
    def generic_typographic(self) -> aspose.imaging.StringFormat:
        '''Gets a generic typographic :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()

    @property
    def format_flags(self) -> aspose.imaging.StringFormatFlags:
        '''Gets a :py:class:`aspose.imaging.StringFormatFlags` enumeration that contains formatting information.'''
        raise NotImplementedError()
    
    @format_flags.setter
    def format_flags(self, value : aspose.imaging.StringFormatFlags) -> None:
        '''Sets a :py:class:`aspose.imaging.StringFormatFlags` enumeration that contains formatting information.'''
        raise NotImplementedError()
    
    @property
    def alignment(self) -> aspose.imaging.StringAlignment:
        '''Gets text alignment information on the vertical plane.'''
        raise NotImplementedError()
    
    @alignment.setter
    def alignment(self, value : aspose.imaging.StringAlignment) -> None:
        '''Sets text alignment information on the vertical plane.'''
        raise NotImplementedError()
    
    @property
    def line_alignment(self) -> aspose.imaging.StringAlignment:
        '''Gets the line alignment on the horizontal plane.'''
        raise NotImplementedError()
    
    @line_alignment.setter
    def line_alignment(self, value : aspose.imaging.StringAlignment) -> None:
        '''Sets the line alignment on the horizontal plane.'''
        raise NotImplementedError()
    
    @property
    def hotkey_prefix(self) -> aspose.imaging.HotkeyPrefix:
        '''Gets the :py:class:`aspose.imaging.HotkeyPrefix` object for this :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @hotkey_prefix.setter
    def hotkey_prefix(self, value : aspose.imaging.HotkeyPrefix) -> None:
        '''Sets the :py:class:`aspose.imaging.HotkeyPrefix` object for this :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @property
    def trimming(self) -> aspose.imaging.StringTrimming:
        '''Gets the :py:class:`aspose.imaging.StringTrimming` enumeration for this :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @trimming.setter
    def trimming(self, value : aspose.imaging.StringTrimming) -> None:
        '''Sets the :py:class:`aspose.imaging.StringTrimming` enumeration for this :py:class:`aspose.imaging.StringFormat` object.'''
        raise NotImplementedError()
    
    @property
    def digit_substitution_method(self) -> aspose.imaging.StringDigitSubstitute:
        '''Gets the method to be used for digit substitution.'''
        raise NotImplementedError()
    
    @digit_substitution_method.setter
    def digit_substitution_method(self, value : aspose.imaging.StringDigitSubstitute) -> None:
        '''Sets the method to be used for digit substitution.'''
        raise NotImplementedError()
    
    @property
    def digit_substitution_language(self) -> int:
        '''Gets the language that is used when local digits are substituted for western digits.'''
        raise NotImplementedError()
    
    @digit_substitution_language.setter
    def digit_substitution_language(self, value : int) -> None:
        '''Sets the language that is used when local digits are substituted for western digits.'''
        raise NotImplementedError()
    
    @property
    def first_tab_offset(self) -> float:
        '''Gets the number of spaces between the beginning of a line of text and the first tab stop.'''
        raise NotImplementedError()
    
    @property
    def tab_stops(self) -> List[float]:
        '''Gets an array of distances between tab stops in the units specified by the :py:attr:`aspose.imaging.Graphics.page_unit` property.'''
        raise NotImplementedError()
    
    @property
    def custom_char_ident(self) -> aspose.imaging.PointF:
        '''Gets the custom character ident.'''
        raise NotImplementedError()
    
    @custom_char_ident.setter
    def custom_char_ident(self, value : aspose.imaging.PointF) -> None:
        '''Sets the custom character ident.'''
        raise NotImplementedError()
    

class TransparencySupporter:
    '''The object supporting transparency.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def opacity(self) -> float:
        '''Gets the object\'s opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        raise NotImplementedError()
    
    @opacity.setter
    def opacity(self, value : float) -> None:
        '''Sets the object\'s opacity. The value should be between 0 and 1. Value of 0 means that object is fully visible, value of 1 means the object is fully opaque.'''
        raise NotImplementedError()
    

class VectorImage(Image):
    '''The vector image is the base class for all type of vector images.'''
    
    @overload
    def save(self) -> None:
        '''Saves the image data to the underlying stream.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int, pixels : List[int]) -> aspose.imaging.Image:
        '''Creates a :py:class:`aspose.imaging.RasterImage` instance from the provided pixel array.
        
        Validates that the specified width and height match the dimensions of the pixel data.
        This method can only be used when the library is in Licensed mode.
        
        :param image_options: The options used to create the :py:class:`aspose.imaging.RasterImage`.
        :param width: The width of the :py:class:`aspose.imaging.RasterImage`.
        :param height: The height of the :py:class:`aspose.imaging.RasterImage`.
        :param pixels: The array of pixel values used to populate the image.
        :returns: A :py:class:`aspose.imaging.RasterImage` populated with the provided pixel data.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(multipage_create_options : aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(file_path : str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, pixels : List[int], width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the specified new width.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image with extended options.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int) -> None:
        '''Resizes the image. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int) -> None:
        '''Resizes the width proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int) -> None:
        '''Resizes the height proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, rectangle : aspose.imaging.Rectangle) -> None:
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, left_shift : int, right_shift : int, top_shift : int, bottom_shift : int) -> None:
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        raise NotImplementedError()
    
    @overload
    def remove_background(self) -> None:
        '''Removes the background.'''
        raise NotImplementedError()
    
    @overload
    def remove_background(self, settings : aspose.imaging.RemoveBackgroundSettings) -> None:
        '''Removes the background.
        
        :param settings: The settings.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data and ensures no additional data loading will be performed from the underlying :py:attr:`aspose.imaging.DataStreamSupporter.data_stream_container`.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_file_format_of_stream(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_width(width : int, height : int, new_height : int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_height(width : int, height : int, new_width : int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        raise NotImplementedError()
    
    def remove_metadata(self) -> None:
        '''Removes metadata.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type; otherwise, false.'''
        raise NotImplementedError()
    
    def can_save(self, options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def resize_by_type(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    def resize_by_settings(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    def get_default_options(self, args : List[Any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default image options.
        
        :param args: The arguments.
        :returns: The default image options.'''
        raise NotImplementedError()
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        :py:func:`aspose.imaging.DataStreamSupporter.save` method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the :py:func:`aspose.imaging.Image.save` method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        raise NotImplementedError()
    
    def resize_width_proportionally_settings(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def resize_height_proportionally_settings(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def rotate_flip(self, rotate_flip_type : aspose.imaging.RotateFlipType) -> None:
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        raise NotImplementedError()
    
    def rotate(self, angle : float) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        raise NotImplementedError()
    
    def save_with_options(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    def save_with_options_rect(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options_rect(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    def get_serialized_stream(self, image_options : aspose.imaging.ImageOptionsBase, clipping_rectangle : aspose.imaging.Rectangle, page_number : List[int]) -> io._IOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        raise NotImplementedError()
    
    def set_palette(self, palette : aspose.imaging.IColorPalette, update_colors : bool) -> None:
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no corresponding palette entries.'''
        raise NotImplementedError()
    
    def get_embedded_images(self) -> List[aspose.imaging.EmbeddedImage]:
        '''Gets the embedded images.
        
        :returns: Array of images'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether object\'s data is cached currently and no data reading is required.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        raise NotImplementedError()
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the :py:class:`aspose.imaging.Image` container.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @property
    def use_palette(self) -> bool:
        '''Gets a value indicating whether the image palette is used.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        '''Gets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor) -> None:
        '''Sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def auto_adjust_palette(self) -> bool:
        '''Gets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool) -> None:
        '''Sets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @property
    def has_background_color(self) -> bool:
        '''Gets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @has_background_color.setter
    def has_background_color(self, value : bool) -> None:
        '''Sets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        '''Gets a value of file format'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a value for the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a value for the background color.'''
        raise NotImplementedError()
    
    @property
    def metadata(self) -> aspose.imaging.metadata.ImageMetadata:
        '''Gets the image metadata.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the Xmp data.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the Xmp data.'''
        raise NotImplementedError()
    
    @property
    def size_f(self) -> aspose.imaging.SizeF:
        '''Gets the object size, in inches.'''
        raise NotImplementedError()
    
    @property
    def width_f(self) -> float:
        '''Gets the object width, in inches.'''
        raise NotImplementedError()
    
    @property
    def height_f(self) -> float:
        '''Gets the object height, in inches.'''
        raise NotImplementedError()
    

class VectorMultipageImage(VectorImage):
    '''The Vector multipage image'''
    
    @overload
    def save(self) -> None:
        '''Saves the image data to the underlying stream.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str) -> None:
        '''Saves the image to the specified file location.
        
        :param file_path: The file path to save the image to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    @overload
    def save(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @overload
    def save(self, file_path : str, over_write : bool) -> None:
        '''Saves the object\'s data to the specified file location.
        
        :param file_path: The file path to save the object\'s data to.
        :param over_write: if set to ``true`` over write the file contents, otherwise append will occur.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str) -> bool:
        '''Determines whether image can be loaded from the specified file path.
        
        :param file_path: The file path.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def can_load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int) -> aspose.imaging.Image:
        '''Creates a new image using the specified create options.
        
        :param image_options: The image options.
        :param width: The width.
        :param height: The height.
        :returns: The newly created image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(image_options : aspose.imaging.ImageOptionsBase, width : int, height : int, pixels : List[int]) -> aspose.imaging.Image:
        '''Creates a :py:class:`aspose.imaging.RasterImage` instance from the provided pixel array.
        
        Validates that the specified width and height match the dimensions of the pixel data.
        This method can only be used when the library is in Licensed mode.
        
        :param image_options: The options used to create the :py:class:`aspose.imaging.RasterImage`.
        :param width: The width of the :py:class:`aspose.imaging.RasterImage`.
        :param height: The height of the :py:class:`aspose.imaging.RasterImage`.
        :param pixels: The array of pixel values used to populate the image.
        :returns: A :py:class:`aspose.imaging.RasterImage` populated with the provided pixel data.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(multipage_create_options : aspose.imaging.imageoptions.MultipageCreateOptions) -> aspose.imaging.Image:
        '''Creates the specified multipage create options.
        
        :param multipage_create_options: The multipage create options.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` [throw exception on load error].
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image]) -> aspose.imaging.Image:
        '''Creates a new image using the specified images as pages
        
        :param images: The images.
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_images(images : List[aspose.imaging.Image], dispose_images : bool) -> aspose.imaging.Image:
        '''Creates a new image the specified images as pages.
        
        :param images: The images.
        :param dispose_images: if set to ``true`` [dispose images].
        :returns: The Image as IMultipageImage'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str], throw_exception_on_load_error : bool) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :param throw_exception_on_load_error: if set to ``true`` throw exception on load error.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def create_from_files(files : List[str]) -> aspose.imaging.Image:
        '''Creates the multipage image containing the specified files as lazy loading pages.
        
        :param files: The files.
        :returns: The multipage image'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(file_path : str) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param file_path: The file path.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_file_format(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def get_fitting_rectangle(rectangle : aspose.imaging.Rectangle, pixels : List[int], width : int, height : int) -> aspose.imaging.Rectangle:
        '''Gets rectangle which fits the current image.
        
        :param rectangle: The rectangle to get fitting rectangle for.
        :param pixels: The 32-bit ARGB pixels.
        :param width: The object width.
        :param height: The object height.
        :returns: The fitting rectangle or exception if no fitting rectangle can be found.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(file_path : str) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    @staticmethod
    def load(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize(self, new_width : int, new_height : int) -> None:
        '''Resizes the image. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int) -> None:
        '''Resizes the width proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_width: The new width.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_width_proportionally(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int) -> None:
        '''Resizes the height proportionally. The default :py:attr:`aspose.imaging.ResizeType.NEAREST_NEIGHBOUR_RESAMPLE` is used.
        
        :param new_height: The new height.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param resize_type: Type of the resize.'''
        raise NotImplementedError()
    
    @overload
    def resize_height_proportionally(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, rectangle : aspose.imaging.Rectangle) -> None:
        '''Crops the specified rectangle.
        
        :param rectangle: The rectangle.'''
        raise NotImplementedError()
    
    @overload
    def crop(self, left_shift : int, right_shift : int, top_shift : int, bottom_shift : int) -> None:
        '''Crop image with shifts.
        
        :param left_shift: The left shift.
        :param right_shift: The right shift.
        :param top_shift: The top shift.
        :param bottom_shift: The bottom shift.'''
        raise NotImplementedError()
    
    @overload
    def remove_background(self, settings : aspose.imaging.RemoveBackgroundSettings) -> None:
        '''Removes the background.
        
        :param settings: The settings.'''
        raise NotImplementedError()
    
    @overload
    def remove_background(self) -> None:
        '''Removes the background.'''
        raise NotImplementedError()
    
    def cache_data(self) -> None:
        '''Caches the data and ensures no additional data loading will be performed from the underlying
        :py:attr:`aspose.imaging.DataStreamSupporter.data_stream_container`.'''
        raise NotImplementedError()
    
    def save_to_stream(self, stream : io._IOBase) -> None:
        '''Saves the object\'s data to the specified stream.
        
        :param stream: The stream to save the object\'s data to.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified file path and optionally using the specified open options.
        
        :param file_path: The file path.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified file; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream(stream : io._IOBase) -> bool:
        '''Determines whether image can be loaded from the specified stream.
        
        :param stream: The stream to load from.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def can_load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> bool:
        '''Determines whether image can be loaded from the specified stream and optionally using the specified ``loadOptions``.
        
        :param stream: The stream to load from.
        :param load_options: The load options.
        :returns: ``true`` if image can be loaded from the specified stream; otherwise, ``false``.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_file_format_of_stream(stream : io._IOBase) -> aspose.imaging.FileFormat:
        '''Gets the file format.
        
        :param stream: The stream.
        :returns: The determined file format.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_with_options(file_path : str, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified file path or URL.
        If ``filePath`` is a file path the method just opens the file.
        If ``filePath`` is an URL, the method downloads the file, stores it as a temporary one, and opens it.
        
        :param file_path: The file path or URL to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream_with_options(stream : io._IOBase, load_options : aspose.imaging.LoadOptions) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :param load_options: The load options.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def load_stream(stream : io._IOBase) -> aspose.imaging.Image:
        '''Loads a new image from the specified stream.
        
        :param stream: The stream to load image from.
        :returns: The loaded image.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_width(width : int, height : int, new_height : int) -> int:
        '''Gets a proportional width.
        
        :param width: The width.
        :param height: The height.
        :param new_height: The new height.
        :returns: The proportional width.'''
        raise NotImplementedError()
    
    @staticmethod
    def get_proportional_height(width : int, height : int, new_width : int) -> int:
        '''Gets a proportional height.
        
        :param width: The width.
        :param height: The height.
        :param new_width: The new width.
        :returns: The proportional height.'''
        raise NotImplementedError()
    
    def remove_metadata(self) -> None:
        '''Removes metadata.'''
        raise NotImplementedError()
    
    def try_set_metadata(self, metadata : aspose.imaging.metadata.IImageMetadataFormat) -> bool:
        '''Tries to set a ``metadata`` instance, if this :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type.
        
        :param metadata: The metadata.
        :returns: True, if the :py:class:`aspose.imaging.Image` instance supports and implements :py:class:`aspose.imaging.metadata.IImageMetadataFormat` type; otherwise, false.'''
        raise NotImplementedError()
    
    def can_save(self, options : aspose.imaging.ImageOptionsBase) -> bool:
        '''Determines whether image can be saved to the specified file format represented by the passed save options.
        
        :param options: The save options to use.
        :returns: ``true`` if image can be saved to the specified file format represented by the passed save options; otherwise, ``false``.'''
        raise NotImplementedError()
    
    def resize_by_type(self, new_width : int, new_height : int, resize_type : aspose.imaging.ResizeType) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param resize_type: The resize type.'''
        raise NotImplementedError()
    
    def resize_by_settings(self, new_width : int, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the image.
        
        :param new_width: The new width.
        :param new_height: The new height.
        :param settings: The resize settings.'''
        raise NotImplementedError()
    
    def get_default_options(self, args : List[Any]) -> aspose.imaging.ImageOptionsBase:
        '''Gets the default image options.
        
        :param args: The arguments.
        :returns: The default image options.'''
        raise NotImplementedError()
    
    def get_original_options(self) -> aspose.imaging.ImageOptionsBase:
        '''Gets the options based on the original file settings.
        This can be helpful to keep bit-depth and other parameters of the original image unchanged.
        For example, if we load a black-white PNG image with 1 bit per pixel and then save it using the
        :py:func:`aspose.imaging.DataStreamSupporter.save` method, the output PNG image with 8-bit per pixel will be produced.
        To avoid it and save PNG image with 1-bit per pixel, use this method to get corresponding saving options and pass them
        to the :py:func:`aspose.imaging.Image.save` method as the second parameter.
        
        :returns: The options based on the original file settings.'''
        raise NotImplementedError()
    
    def resize_width_proportionally_settings(self, new_width : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the width proportionally.
        
        :param new_width: The new width.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def resize_height_proportionally_settings(self, new_height : int, settings : aspose.imaging.ImageResizeSettings) -> None:
        '''Resizes the height proportionally.
        
        :param new_height: The new height.
        :param settings: The image resize settings.'''
        raise NotImplementedError()
    
    def rotate_flip(self, rotate_flip_type : aspose.imaging.RotateFlipType) -> None:
        '''Rotates, flips, or rotates and flips the image.
        
        :param rotate_flip_type: Type of the rotate flip.'''
        raise NotImplementedError()
    
    def rotate(self, angle : float) -> None:
        '''Rotate image around the center.
        
        :param angle: The rotate angle in degrees. Positive values will rotate clockwise.'''
        raise NotImplementedError()
    
    def save_with_options(self, file_path : str, options : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.'''
        raise NotImplementedError()
    
    def save_with_options_rect(self, file_path : str, options : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the object\'s data to the specified file location in the specified file format according to save options.
        
        :param file_path: The file path.
        :param options: The options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use sourse bounds.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.'''
        raise NotImplementedError()
    
    def save_to_stream_with_options_rect(self, stream : io._IOBase, options_base : aspose.imaging.ImageOptionsBase, bounds_rectangle : aspose.imaging.Rectangle) -> None:
        '''Saves the image\'s data to the specified stream in the specified file format according to save options.
        
        :param stream: The stream to save the image\'s data to.
        :param options_base: The save options.
        :param bounds_rectangle: The destination image bounds rectangle. Set the empty rectangle for use source bounds.'''
        raise NotImplementedError()
    
    def get_serialized_stream(self, image_options : aspose.imaging.ImageOptionsBase, clipping_rectangle : aspose.imaging.Rectangle, page_number : List[int]) -> io._IOBase:
        '''Converts to aps.
        
        :param image_options: The image options.
        :param clipping_rectangle: The clipping rectangle.
        :param page_number: The page number.
        :returns: The serialized stream'''
        raise NotImplementedError()
    
    def set_palette(self, palette : aspose.imaging.IColorPalette, update_colors : bool) -> None:
        '''Sets the image palette.
        
        :param palette: The palette to set.
        :param update_colors: if set to ``true`` colors will be updated according to the new palette; otherwise color
        indexes remain unchanged. Note that unchanged indexes may crash the image on loading if some indexes have no
        corresponding palette entries.'''
        raise NotImplementedError()
    
    def get_embedded_images(self) -> List[aspose.imaging.EmbeddedImage]:
        '''Gets the embedded images.
        
        :returns: Array of images'''
        raise NotImplementedError()
    
    @property
    def disposed(self) -> bool:
        '''Gets a value indicating whether this instance is disposed.'''
        raise NotImplementedError()
    
    @property
    def data_stream_container(self) -> aspose.imaging.StreamContainer:
        '''Gets the object\'s data stream.'''
        raise NotImplementedError()
    
    @property
    def is_cached(self) -> bool:
        '''Gets a value indicating whether object\'s data is cached currently and no data reading is required.'''
        raise NotImplementedError()
    
    @property
    def bits_per_pixel(self) -> int:
        '''Gets the image bits per pixel count.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets the image bounds.'''
        raise NotImplementedError()
    
    @property
    def container(self) -> aspose.imaging.Image:
        '''Gets the :py:class:`aspose.imaging.Image` container.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the image height.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.IColorPalette:
        '''Gets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.IColorPalette) -> None:
        '''Sets the color palette. The color palette is not used when pixels are represented directly.'''
        raise NotImplementedError()
    
    @property
    def use_palette(self) -> bool:
        '''Gets a value indicating whether the image palette is used.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> aspose.imaging.Size:
        '''Gets the image size.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the image width.'''
        raise NotImplementedError()
    
    @property
    def interrupt_monitor(self) -> aspose.imaging.multithreading.InterruptMonitor:
        '''Gets the interrupt monitor.'''
        raise NotImplementedError()
    
    @interrupt_monitor.setter
    def interrupt_monitor(self, value : aspose.imaging.multithreading.InterruptMonitor) -> None:
        '''Sets the interrupt monitor.'''
        raise NotImplementedError()
    
    @property
    def buffer_size_hint(self) -> int:
        '''Gets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @buffer_size_hint.setter
    def buffer_size_hint(self, value : int) -> None:
        '''Sets the buffer size hint which is defined max allowed size for all internal buffers.'''
        raise NotImplementedError()
    
    @property
    def auto_adjust_palette(self) -> bool:
        '''Gets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @auto_adjust_palette.setter
    def auto_adjust_palette(self, value : bool) -> None:
        '''Sets a value indicating whether automatic adjust palette.'''
        raise NotImplementedError()
    
    @property
    def has_background_color(self) -> bool:
        '''Gets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @has_background_color.setter
    def has_background_color(self, value : bool) -> None:
        '''Sets a value indicating whether image has background color.'''
        raise NotImplementedError()
    
    @property
    def file_format(self) -> aspose.imaging.FileFormat:
        '''Gets a value of file format'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.imaging.Color:
        '''Gets a value for the background color.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.imaging.Color) -> None:
        '''Sets a value for the background color.'''
        raise NotImplementedError()
    
    @property
    def metadata(self) -> aspose.imaging.metadata.ImageMetadata:
        '''Gets the image metadata.'''
        raise NotImplementedError()
    
    @property
    def exif_data(self) -> aspose.imaging.exif.ExifData:
        '''Gets the Exif data.'''
        raise NotImplementedError()
    
    @exif_data.setter
    def exif_data(self, value : aspose.imaging.exif.ExifData) -> None:
        '''Sets the Exif data.'''
        raise NotImplementedError()
    
    @property
    def xmp_data(self) -> aspose.imaging.xmp.XmpPacketWrapper:
        '''Gets the Xmp data.'''
        raise NotImplementedError()
    
    @xmp_data.setter
    def xmp_data(self, value : aspose.imaging.xmp.XmpPacketWrapper) -> None:
        '''Sets the Xmp data.'''
        raise NotImplementedError()
    
    @property
    def size_f(self) -> aspose.imaging.SizeF:
        '''Gets the object size, in inches.'''
        raise NotImplementedError()
    
    @property
    def width_f(self) -> float:
        '''Gets the object width, in inches.'''
        raise NotImplementedError()
    
    @property
    def height_f(self) -> float:
        '''Gets the object height, in inches.'''
        raise NotImplementedError()
    
    @property
    def page_count(self) -> int:
        '''Gets the page count.'''
        raise NotImplementedError()
    
    @property
    def pages(self) -> List[aspose.imaging.Image]:
        '''Gets the pages.'''
        raise NotImplementedError()
    
    @property
    def default_page(self) -> aspose.imaging.Image:
        '''Gets the default page.'''
        raise NotImplementedError()
    

class AnimationDisposalMethods(enum.Enum):
    PRESERVE = enum.auto()
    '''Do not dispose. The graphic is to be left in place.'''
    BACKGROUND = enum.auto()
    '''Restore to background color. The area used by the graphic must be restored to the background color.'''
    PREVIOUS = enum.auto()
    '''Restore to previous. The decoder is required to restore the area overwritten by the graphic with what was there prior to rendering the graphic.'''

class CacheType(enum.Enum):
    AUTO = enum.auto()
    '''Specifies auto cache type. The auto cache scheme will try to cache in-memory first then on disk.'''
    CACHE_ON_DISK_ONLY = enum.auto()
    '''The disk cache only.'''
    CACHE_IN_MEMORY_ONLY = enum.auto()
    '''The in-memory cache only.'''

class CharacterSet(enum.Enum):
    ANSI = enum.auto()
    '''1252 Latin 1, 1250 Latin 2, 1256 Arabic character sets'''
    DEFAULT = enum.auto()
    '''The default character set.'''
    SYMBOL = enum.auto()
    '''The symbol character set'''
    SHIFTJIS = enum.auto()
    '''DBCS, 932 Japanese character set.'''
    HANGEUL = enum.auto()
    '''DBCS, 949 Korean character set.'''
    HANGUL = enum.auto()
    '''DBCS, 949 Korean character set.'''
    GB2312 = enum.auto()
    '''DBCS, 936 Simplified Chinese character set.'''
    CHINESE_BIG5 = enum.auto()
    '''DBCS, 950 Traditional Chinese character set.'''
    OEM = enum.auto()
    '''437 MS-DOS Latin 1, 852 MS-DOS Latin 2, 864 MS-DOS Arabic character sets.'''
    JOHAB = enum.auto()
    '''DBCS, 1361 Korean character set.'''
    HEBREW = enum.auto()
    '''1255 Hebrew character set.'''
    ARABIC = enum.auto()
    '''1256 Arabic character set.'''
    GREEK = enum.auto()
    '''1253 Greek character set.'''
    TURKISH = enum.auto()
    '''1254 Turkish character set.'''
    VIETNAMESE = enum.auto()
    '''1258 Vietnamese character set.'''
    THAI = enum.auto()
    '''874 Thai character set.'''
    EASTEUROPE = enum.auto()
    '''1250 Latin 2, Central Europe character set.'''
    RUSSIAN = enum.auto()
    '''1251 Cyrillic (Slavic) character set.'''
    MAC = enum.auto()
    '''10000 Mac Roman, 10029 Mac Central Europe, 10007 Mac Cyrillic character sets.'''
    BALTIC = enum.auto()
    '''1257 Baltic Rim character set.'''

class ColorAdjustType(enum.Enum):
    DEFAULT = enum.auto()
    '''Color adjustment information that is used by all GDI+ objects that do not have their own color adjustment information.'''
    BITMAP = enum.auto()
    '''Color adjustment information for Bitmap objects.'''
    BRUSH = enum.auto()
    '''Color adjustment information for Brush objects.'''
    PEN = enum.auto()
    '''Color adjustment information for Pen objects.'''
    TEXT = enum.auto()
    '''Color adjustment information for text.'''
    COUNT = enum.auto()
    '''The number of types specified.'''
    ANY = enum.auto()
    '''The number of types specified.'''

class ColorChannelFlag(enum.Enum):
    COLOR_CHANNEL_C = enum.auto()
    '''The cyan color channel.'''
    COLOR_CHANNEL_M = enum.auto()
    '''The magenta color channel.'''
    COLOR_CHANNEL_Y = enum.auto()
    '''The yellow color channel.'''
    COLOR_CHANNEL_K = enum.auto()
    '''The black color channel.'''
    COLOR_CHANNEL_LAST = enum.auto()
    '''The last selected channel should be used.'''

class ColorCompareMethod(enum.Enum):
    EUCLIDIAN = enum.auto()
    '''The euclidian method'''

class ColorMatrixFlag(enum.Enum):
    DEFAULT = enum.auto()
    '''All color values, including gray shades, are adjusted by the same color-adjustment matrix.'''
    SKIP_GRAYS = enum.auto()
    '''All colors are adjusted, but gray shades are not adjusted. A gray shade is any color that has the same value for its red, green, and blue components.'''
    ALT_GRAYS = enum.auto()
    '''Only gray shades are adjusted.'''

class ColorQuantizationMethod(enum.Enum):
    NONE = enum.auto()
    '''Nothing color quantization method is used'''
    POPULARITY = enum.auto()
    '''The popularity method'''

class CompositingQuality(enum.Enum):
    INVALID = enum.auto()
    '''Invalid quality.'''
    DEFAULT = enum.auto()
    '''Default quality.'''
    HIGH_SPEED = enum.auto()
    '''High speed, low quality.'''
    HIGH_QUALITY = enum.auto()
    '''High quality, low speed compositing.'''
    GAMMA_CORRECTED = enum.auto()
    '''Gamma correction is used.'''
    ASSUME_LINEAR = enum.auto()
    '''Assume linear values.'''

class DashCap(enum.Enum):
    FLAT = enum.auto()
    '''Specifies a square cap that squares off both ends of each dash.'''
    ROUND = enum.auto()
    '''Specifies a circular cap that rounds off both ends of each dash.'''
    TRIANGLE = enum.auto()
    '''Specifies a triangular cap that points both ends of each dash.'''

class DashStyle(enum.Enum):
    SOLID = enum.auto()
    '''Specifies a solid line.'''
    DASH = enum.auto()
    '''Specifies a line consisting of dashes.'''
    DOT = enum.auto()
    '''Specifies a line consisting of dots.'''
    DASH_DOT = enum.auto()
    '''Specifies a line consisting of a repeating pattern of dash-dot.'''
    DASH_DOT_DOT = enum.auto()
    '''Specifies a line consisting of a repeating pattern of dash-dot-dot.'''
    CUSTOM = enum.auto()
    '''Specifies a user-defined custom dash style.'''

class DataRecoveryMode(enum.Enum):
    NONE = enum.auto()
    '''No data recovery is implied. Whenever the file format has some corrupted data the appropriate exception is thrown.'''
    CONSISTENT_RECOVER = enum.auto()
    '''The consistent recovery mode tries to recover all data as long as corruption does not break the file format and allows correct further processing.'''
    MAXIMAL_RECOVER = enum.auto()
    '''The maximal recovery mode recovers all data even if the file format has corrupted structure and further processing may yield unattended effects.'''

class DitheringMethod(enum.Enum):
    THRESHOLD_DITHERING = enum.auto()
    '''Threshold dithering. Simplest and fastest dithering algorithm.'''
    FLOYD_STEINBERG_DITHERING = enum.auto()
    '''The Floyd-Steinberg dithering. A more complex dithering algorithm, uses nearest neighbors intensity values.'''

class DitheringMethods(enum.Enum):
    PALETTE_IGNORE = enum.auto()
    '''The palette is ignored'''
    PALETTE_CONVERSION = enum.auto()
    '''The palette is not ignored and wise color conversion should be applied.'''
    CUSTOM_CONVERTER = enum.auto()
    '''The custom converter.'''

class FileFormat(enum.Enum):
    UNKNOWN = enum.auto()
    '''Unknown file format.'''
    CUSTOM = enum.auto()
    '''Custom file format.'''
    BMP = enum.auto()
    '''Bmp (Dib) file format.'''
    GIF = enum.auto()
    '''Gif file format.'''
    JPEG = enum.auto()
    '''Jpeg file format.'''
    PNG = enum.auto()
    '''Png file format.'''
    TIFF = enum.auto()
    '''Tiff file format.'''
    PSD = enum.auto()
    '''Psd file format.'''
    PDF = enum.auto()
    '''Pdf file format'''
    ICO = enum.auto()
    '''The ico format'''
    JPEG2000 = enum.auto()
    '''Jpeg2000 file format'''
    DJVU = enum.auto()
    '''Djvu file format'''
    WEBP = enum.auto()
    '''The webp file format'''
    EMF = enum.auto()
    '''The Emf/Emf+ file format'''
    DICOM = enum.auto()
    '''The dicom format'''
    SVG = enum.auto()
    '''SVG file format'''
    WMF = enum.auto()
    '''The Wmf file format'''
    DNG = enum.auto()
    '''The DNG file format'''
    ODG = enum.auto()
    '''The Open document graphic format'''
    EPS = enum.auto()
    '''The Encapsulated PostScript format'''
    CDR = enum.auto()
    '''The CDR file format'''
    CMX = enum.auto()
    '''The CMX file format'''
    OTG = enum.auto()
    '''The otg file format'''
    HTML_5_CANVAS = enum.auto()
    '''The Html5 Canvas format'''
    APNG = enum.auto()
    '''The animated Png file format.'''
    TGA = enum.auto()
    '''The Truevision TGA file format.'''
    DXF = enum.auto()
    '''The AutoCAD Drawing Exchange Format.'''
    EMZ = enum.auto()
    '''The emz, compressed emf'''
    WMZ = enum.auto()
    '''The WMZ, compressed wmf'''
    SVGZ = enum.auto()
    '''The SVGZ, compressed svg'''
    F_ODG = enum.auto()
    '''The fodg, flat odg format'''
    AVIF = enum.auto()
    '''The AVIF file format.'''
    BIG_TIFF = enum.auto()
    '''The Big Tiff format.'''

class FillMode(enum.Enum):
    ALTERNATE = enum.auto()
    '''Specifies the alternate fill mode.'''
    WINDING = enum.auto()
    '''Specifies the winding fill mode.'''

class FontStyle(enum.Enum):
    REGULAR = enum.auto()
    '''Normal text.'''
    BOLD = enum.auto()
    '''Bold text.'''
    ITALIC = enum.auto()
    '''Italic text.'''
    UNDERLINE = enum.auto()
    '''Underlined text.'''
    STRIKEOUT = enum.auto()
    '''Text with a line through the middle.'''

class GraphicsUnit(enum.Enum):
    WORLD = enum.auto()
    '''Specifies the world coordinate system unit as the unit of measure.'''
    DISPLAY = enum.auto()
    '''Specifies the unit of measure of the display device. Typically pixels for video displays, and 1/100 inch for printers.'''
    PIXEL = enum.auto()
    '''Specifies a device pixel as the unit of measure.'''
    POINT = enum.auto()
    '''Specifies a printer\'s point (1/72 inch) as the unit of measure.'''
    INCH = enum.auto()
    '''Specifies the inch as the unit of measure.'''
    DOCUMENT = enum.auto()
    '''Specifies the document unit (1/300 inch) as the unit of measure.'''
    MILLIMETER = enum.auto()
    '''Specifies the millimeter as the unit of measure.'''

class HatchStyle(enum.Enum):
    HORIZONTAL = enum.auto()
    '''A pattern of horizontal lines.'''
    MIN = enum.auto()
    '''Specifies hatch style Horizontal.'''
    VERTICAL = enum.auto()
    '''A pattern of vertical lines.'''
    FORWARD_DIAGONAL = enum.auto()
    '''A pattern of lines on a diagonal from upper left to lower right.'''
    BACKWARD_DIAGONAL = enum.auto()
    '''A pattern of lines on a diagonal from upper right to lower left.'''
    CROSS = enum.auto()
    '''Specifies horizontal and vertical lines that cross.'''
    LARGE_GRID = enum.auto()
    '''Specifies the hatch style Cross.'''
    MAX = enum.auto()
    '''Specifies hatch style SolidDiamond.'''
    DIAGONAL_CROSS = enum.auto()
    '''A pattern of crisscross diagonal lines.'''
    PERCENT05 = enum.auto()
    '''Specifies a 5-percent hatch. The ratio of foreground color to background color is 5:95.'''
    PERCENT10 = enum.auto()
    '''Specifies a 10-percent hatch. The ratio of foreground color to background color is 10:90.'''
    PERCENT20 = enum.auto()
    '''Specifies a 20-percent hatch. The ratio of foreground color to background color is 20:80.'''
    PERCENT25 = enum.auto()
    '''Specifies a 25-percent hatch. The ratio of foreground color to background color is 25:75.'''
    PERCENT30 = enum.auto()
    '''Specifies a 30-percent hatch. The ratio of foreground color to background color is 30:70.'''
    PERCENT40 = enum.auto()
    '''Specifies a 40-percent hatch. The ratio of foreground color to background color is 40:60.'''
    PERCENT50 = enum.auto()
    '''Specifies a 50-percent hatch. The ratio of foreground color to background color is 50:50.'''
    PERCENT60 = enum.auto()
    '''Specifies a 60-percent hatch. The ratio of foreground color to background color is 60:40.'''
    PERCENT70 = enum.auto()
    '''Specifies a 70-percent hatch. The ratio of foreground color to background color is 70:30.'''
    PERCENT75 = enum.auto()
    '''Specifies a 75-percent hatch. The ratio of foreground color to background color is 75:25.'''
    PERCENT80 = enum.auto()
    '''Specifies a 80-percent hatch. The ratio of foreground color to background color is 80:100.'''
    PERCENT90 = enum.auto()
    '''Specifies a 90-percent hatch. The ratio of foreground color to background color is 90:10.'''
    LIGHT_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the right from top points to bottom points and are spaced 50 percent closer together than ForwardDiagonal, but are not antialiased.'''
    LIGHT_UPWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the left from top points to bottom points and are spaced 50 percent closer together than BackwardDiagonal, but they are not antialiased.'''
    DARK_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the right from top points to bottom points, are spaced 50 percent closer together than, and are twice the width of ForwardDiagonal. This hatch pattern is not antialiased.'''
    DARK_UPWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the left from top points to bottom points, are spaced 50 percent closer together than BackwardDiagonal, and are twice its width, but the lines are not antialiased.'''
    WIDE_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the right from top points to bottom points, have the same spacing as hatch style ForwardDiagonal, and are triple its width, but are not antialiased.'''
    WIDE_UPWARD_DIAGONAL = enum.auto()
    '''Specifies diagonal lines that slant to the left from top points to bottom points, have the same spacing as hatch style BackwardDiagonal, and are triple its width, but are not antialiased.'''
    LIGHT_VERTICAL = enum.auto()
    '''Specifies vertical lines that are spaced 50 percent closer together than Vertical.'''
    LIGHT_HORIZONTAL = enum.auto()
    '''Specifies horizontal lines that are spaced 50 percent closer together than Horizontal.'''
    NARROW_VERTICAL = enum.auto()
    '''Specifies vertical lines that are spaced 75 percent closer together than hatch style Vertical (or 25 percent closer together than LightVertical).'''
    NARROW_HORIZONTAL = enum.auto()
    '''Specifies horizontal lines that are spaced 75 percent closer together than hatch style Horizontal (or 25 percent closer together than LightHorizontal).'''
    DARK_VERTICAL = enum.auto()
    '''Specifies vertical lines that are spaced 50 percent closer together than Vertical and are twice its width.'''
    DARK_HORIZONTAL = enum.auto()
    '''Specifies horizontal lines that are spaced 50 percent closer together than Horizontal and are twice the width of Horizontal.'''
    DASHED_DOWNWARD_DIAGONAL = enum.auto()
    '''Specifies dashed diagonal lines, that slant to the right from top points to bottom points.'''
    DASHED_UPWARD_DIAGONAL = enum.auto()
    '''Specifies dashed diagonal lines, that slant to the left from top points to bottom points.'''
    DASHED_HORIZONTAL = enum.auto()
    '''Specifies dashed horizontal lines.'''
    DASHED_VERTICAL = enum.auto()
    '''Specifies dashed vertical lines.'''
    SMALL_CONFETTI = enum.auto()
    '''Specifies a hatch that has the appearance of confetti.'''
    LARGE_CONFETTI = enum.auto()
    '''Specifies a hatch that has the appearance of confetti, and is composed of larger pieces than SmallConfetti.'''
    ZIG_ZAG = enum.auto()
    '''Specifies horizontal lines that are composed of zigzags.'''
    WAVE = enum.auto()
    '''Specifies horizontal lines that are composed of tildes.'''
    DIAGONAL_BRICK = enum.auto()
    '''Specifies a hatch that has the appearance of layered bricks that slant to the left from top points to bottom points.'''
    HORIZONTAL_BRICK = enum.auto()
    '''Specifies a hatch that has the appearance of horizontally layered bricks.'''
    WEAVE = enum.auto()
    '''Specifies a hatch that has the appearance of a woven material.'''
    PLAID = enum.auto()
    '''Specifies a hatch that has the appearance of a plaid material.'''
    DIVOT = enum.auto()
    '''Specifies a hatch that has the appearance of divots.'''
    DOTTED_GRID = enum.auto()
    '''Specifies horizontal and vertical lines, each of which is composed of dots, that cross.'''
    DOTTED_DIAMOND = enum.auto()
    '''Specifies forward diagonal and backward diagonal lines, each of which is composed of dots, that cross.'''
    SHINGLE = enum.auto()
    '''Specifies a hatch that has the appearance of diagonally layered shingles that slant to the right from top points to bottom points.'''
    TRELLIS = enum.auto()
    '''Specifies a hatch that has the appearance of a trellis.'''
    SPHERE = enum.auto()
    '''Specifies a hatch that has the appearance of spheres laid adjacent to one another.'''
    SMALL_GRID = enum.auto()
    '''Specifies horizontal and vertical lines that cross and are spaced 50 percent closer together than hatch style Cross.'''
    SMALL_CHECKER_BOARD = enum.auto()
    '''Specifies a hatch that has the appearance of a checkerboard.'''
    LARGE_CHECKER_BOARD = enum.auto()
    '''Specifies a hatch that has the appearance of a checkerboard with squares that are twice the size of SmallCheckerBoard.'''
    OUTLINED_DIAMOND = enum.auto()
    '''Specifies forward diagonal and backward diagonal lines that cross but are not antialiased.'''
    SOLID_DIAMOND = enum.auto()
    '''Specifies a hatch that has the appearance of a checkerboard placed diagonally.'''

class HotkeyPrefix(enum.Enum):
    NONE = enum.auto()
    '''No hot-key prefix.'''
    SHOW = enum.auto()
    '''Display the hot-key prefix.'''
    HIDE = enum.auto()
    '''Do not display the hot-key prefix.'''

class ImageFilterType(enum.Enum):
    NONE = enum.auto()
    '''Nothing filter used'''
    BIG_RECTANGULAR = enum.auto()
    '''The big rectangular filter'''
    SMALL_RECTANGULAR = enum.auto()
    '''The small rectangular filter'''

class InterpolationMode(enum.Enum):
    INVALID = enum.auto()
    '''Invalid interpolation mode.'''
    DEFAULT = enum.auto()
    '''Specifies default mode.'''
    LOW = enum.auto()
    '''Specifies low quality interpolation.'''
    HIGH = enum.auto()
    '''Specifies high quality interpolation.'''
    BILINEAR = enum.auto()
    '''Specifies bilinear interpolation. No prefiltering is done. This mode is not suitable for shrinking an image below 50 percent of its original size.'''
    BICUBIC = enum.auto()
    '''Specifies bicubic interpolation. No prefiltering is done. This mode is not suitable for shrinking an image below 25 percent of its original size.'''
    NEAREST_NEIGHBOR = enum.auto()
    '''Specifies nearest-neighbor interpolation.'''
    HIGH_QUALITY_BILINEAR = enum.auto()
    '''Specifies high-quality, bilinear interpolation. Prefiltering is performed to ensure high-quality shrinking.'''
    HIGH_QUALITY_BICUBIC = enum.auto()
    '''Specifies high-quality, bicubic interpolation. Prefiltering is performed to ensure high-quality shrinking. This mode produces the highest quality transformed images.'''

class KnownColor(enum.Enum):
    TRANSPARENT = enum.auto()
    '''A system-defined color.'''
    ALICE_BLUE = enum.auto()
    '''A system-defined color.'''
    ANTIQUE_WHITE = enum.auto()
    '''A system-defined color.'''
    AQUA = enum.auto()
    '''A system-defined color.'''
    AQUAMARINE = enum.auto()
    '''A system-defined color.'''
    AZURE = enum.auto()
    '''A system-defined color.'''
    BEIGE = enum.auto()
    '''A system-defined color.'''
    BISQUE = enum.auto()
    '''A system-defined color.'''
    BLACK = enum.auto()
    '''A system-defined color.'''
    BLANCHED_ALMOND = enum.auto()
    '''A system-defined color.'''
    BLUE = enum.auto()
    '''A system-defined color.'''
    BLUE_VIOLET = enum.auto()
    '''A system-defined color.'''
    BROWN = enum.auto()
    '''A system-defined color.'''
    BURLY_WOOD = enum.auto()
    '''A system-defined color.'''
    CADET_BLUE = enum.auto()
    '''A system-defined color.'''
    CHARTREUSE = enum.auto()
    '''A system-defined color.'''
    CHOCOLATE = enum.auto()
    '''A system-defined color.'''
    CORAL = enum.auto()
    '''A system-defined color.'''
    CORNFLOWER_BLUE = enum.auto()
    '''A system-defined color.'''
    CORNSILK = enum.auto()
    '''A system-defined color.'''
    CRIMSON = enum.auto()
    '''A system-defined color.'''
    CYAN = enum.auto()
    '''A system-defined color.'''
    DARK_BLUE = enum.auto()
    '''A system-defined color.'''
    DARK_CYAN = enum.auto()
    '''A system-defined color.'''
    DARK_GOLDENROD = enum.auto()
    '''A system-defined color.'''
    DARK_GRAY = enum.auto()
    '''A system-defined color.'''
    DARK_GREEN = enum.auto()
    '''A system-defined color.'''
    DARK_KHAKI = enum.auto()
    '''A system-defined color.'''
    DARK_MAGENTA = enum.auto()
    '''A system-defined color.'''
    DARK_OLIVE_GREEN = enum.auto()
    '''A system-defined color.'''
    DARK_ORANGE = enum.auto()
    '''A system-defined color.'''
    DARK_ORCHID = enum.auto()
    '''A system-defined color.'''
    DARK_RED = enum.auto()
    '''A system-defined color.'''
    DARK_SALMON = enum.auto()
    '''A system-defined color.'''
    DARK_SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    DARK_SLATE_BLUE = enum.auto()
    '''A system-defined color.'''
    DARK_SLATE_GRAY = enum.auto()
    '''A system-defined color.'''
    DARK_TURQUOISE = enum.auto()
    '''A system-defined color.'''
    DARK_VIOLET = enum.auto()
    '''A system-defined color.'''
    DEEP_PINK = enum.auto()
    '''A system-defined color.'''
    DEEP_SKY_BLUE = enum.auto()
    '''A system-defined color.'''
    DIM_GRAY = enum.auto()
    '''A system-defined color.'''
    DODGER_BLUE = enum.auto()
    '''A system-defined color.'''
    FIREBRICK = enum.auto()
    '''A system-defined color.'''
    FLORAL_WHITE = enum.auto()
    '''A system-defined color.'''
    FOREST_GREEN = enum.auto()
    '''A system-defined color.'''
    FUCHSIA = enum.auto()
    '''A system-defined color.'''
    GAINSBORO = enum.auto()
    '''A system-defined color.'''
    GHOST_WHITE = enum.auto()
    '''A system-defined color.'''
    GOLD = enum.auto()
    '''A system-defined color.'''
    GOLDENROD = enum.auto()
    '''A system-defined color.'''
    GRAY = enum.auto()
    '''A system-defined color.'''
    GREEN = enum.auto()
    '''A system-defined color.'''
    GREEN_YELLOW = enum.auto()
    '''A system-defined color.'''
    HONEYDEW = enum.auto()
    '''A system-defined color.'''
    HOT_PINK = enum.auto()
    '''A system-defined color.'''
    INDIAN_RED = enum.auto()
    '''A system-defined color.'''
    INDIGO = enum.auto()
    '''A system-defined color.'''
    IVORY = enum.auto()
    '''A system-defined color.'''
    KHAKI = enum.auto()
    '''A system-defined color.'''
    LAVENDER = enum.auto()
    '''A system-defined color.'''
    LAVENDER_BLUSH = enum.auto()
    '''A system-defined color.'''
    LAWN_GREEN = enum.auto()
    '''A system-defined color.'''
    LEMON_CHIFFON = enum.auto()
    '''A system-defined color.'''
    LIGHT_BLUE = enum.auto()
    '''A system-defined color.'''
    LIGHT_CORAL = enum.auto()
    '''A system-defined color.'''
    LIGHT_CYAN = enum.auto()
    '''A system-defined color.'''
    LIGHT_GOLDENROD_YELLOW = enum.auto()
    '''A system-defined color.'''
    LIGHT_GRAY = enum.auto()
    '''A system-defined color.'''
    LIGHT_GREEN = enum.auto()
    '''A system-defined color.'''
    LIGHT_PINK = enum.auto()
    '''A system-defined color.'''
    LIGHT_SALMON = enum.auto()
    '''A system-defined color.'''
    LIGHT_SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    LIGHT_SKY_BLUE = enum.auto()
    '''A system-defined color.'''
    LIGHT_SLATE_GRAY = enum.auto()
    '''A system-defined color.'''
    LIGHT_STEEL_BLUE = enum.auto()
    '''A system-defined color.'''
    LIGHT_YELLOW = enum.auto()
    '''A system-defined color.'''
    LIME = enum.auto()
    '''A system-defined color.'''
    LIME_GREEN = enum.auto()
    '''A system-defined color.'''
    LINEN = enum.auto()
    '''A system-defined color.'''
    MAGENTA = enum.auto()
    '''A system-defined color.'''
    MAROON = enum.auto()
    '''A system-defined color.'''
    MEDIUM_AQUAMARINE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_BLUE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_ORCHID = enum.auto()
    '''A system-defined color.'''
    MEDIUM_PURPLE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    MEDIUM_SLATE_BLUE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_SPRING_GREEN = enum.auto()
    '''A system-defined color.'''
    MEDIUM_TURQUOISE = enum.auto()
    '''A system-defined color.'''
    MEDIUM_VIOLET_RED = enum.auto()
    '''A system-defined color.'''
    MIDNIGHT_BLUE = enum.auto()
    '''A system-defined color.'''
    MINT_CREAM = enum.auto()
    '''A system-defined color.'''
    MISTY_ROSE = enum.auto()
    '''A system-defined color.'''
    MOCCASIN = enum.auto()
    '''A system-defined color.'''
    NAVAJO_WHITE = enum.auto()
    '''A system-defined color.'''
    NAVY = enum.auto()
    '''A system-defined color.'''
    OLD_LACE = enum.auto()
    '''A system-defined color.'''
    OLIVE = enum.auto()
    '''A system-defined color.'''
    OLIVE_DRAB = enum.auto()
    '''A system-defined color.'''
    ORANGE = enum.auto()
    '''A system-defined color.'''
    ORANGE_RED = enum.auto()
    '''A system-defined color.'''
    ORCHID = enum.auto()
    '''A system-defined color.'''
    PALE_GOLDENROD = enum.auto()
    '''A system-defined color.'''
    PALE_GREEN = enum.auto()
    '''A system-defined color.'''
    PALE_TURQUOISE = enum.auto()
    '''A system-defined color.'''
    PALE_VIOLET_RED = enum.auto()
    '''A system-defined color.'''
    PAPAYA_WHIP = enum.auto()
    '''A system-defined color.'''
    PEACH_PUFF = enum.auto()
    '''A system-defined color.'''
    PERU = enum.auto()
    '''A system-defined color.'''
    PINK = enum.auto()
    '''A system-defined color.'''
    PLUM = enum.auto()
    '''A system-defined color.'''
    POWDER_BLUE = enum.auto()
    '''A system-defined color.'''
    PURPLE = enum.auto()
    '''A system-defined color.'''
    RED = enum.auto()
    '''A system-defined color.'''
    ROSY_BROWN = enum.auto()
    '''A system-defined color.'''
    ROYAL_BLUE = enum.auto()
    '''A system-defined color.'''
    SADDLE_BROWN = enum.auto()
    '''A system-defined color.'''
    SALMON = enum.auto()
    '''A system-defined color.'''
    SANDY_BROWN = enum.auto()
    '''A system-defined color.'''
    SEA_GREEN = enum.auto()
    '''A system-defined color.'''
    SEA_SHELL = enum.auto()
    '''A system-defined color.'''
    SIENNA = enum.auto()
    '''A system-defined color.'''
    SILVER = enum.auto()
    '''A system-defined color.'''
    SKY_BLUE = enum.auto()
    '''A system-defined color.'''
    SLATE_BLUE = enum.auto()
    '''A system-defined color.'''
    SLATE_GRAY = enum.auto()
    '''A system-defined color.'''
    SNOW = enum.auto()
    '''A system-defined color.'''
    SPRING_GREEN = enum.auto()
    '''A system-defined color.'''
    STEEL_BLUE = enum.auto()
    '''A system-defined color.'''
    TAN = enum.auto()
    '''A system-defined color.'''
    TEAL = enum.auto()
    '''A system-defined color.'''
    THISTLE = enum.auto()
    '''A system-defined color.'''
    TOMATO = enum.auto()
    '''A system-defined color.'''
    TURQUOISE = enum.auto()
    '''A system-defined color.'''
    VIOLET = enum.auto()
    '''A system-defined color.'''
    WHEAT = enum.auto()
    '''A system-defined color.'''
    WHITE = enum.auto()
    '''A system-defined color.'''
    WHITE_SMOKE = enum.auto()
    '''A system-defined color.'''
    YELLOW = enum.auto()
    '''A system-defined color.'''
    YELLOW_GREEN = enum.auto()
    '''A system-defined color.'''

class LineCap(enum.Enum):
    FLAT = enum.auto()
    '''Specifies a flat line cap.'''
    SQUARE = enum.auto()
    '''Specifies a square line cap.'''
    ROUND = enum.auto()
    '''Specifies a round line cap.'''
    TRIANGLE = enum.auto()
    '''Specifies a triangular line cap.'''
    NO_ANCHOR = enum.auto()
    '''Specifies no anchor.'''
    SQUARE_ANCHOR = enum.auto()
    '''Specifies a square anchor line cap.'''
    ROUND_ANCHOR = enum.auto()
    '''Specifies a round anchor cap.'''
    DIAMOND_ANCHOR = enum.auto()
    '''Specifies a diamond anchor cap.'''
    ARROW_ANCHOR = enum.auto()
    '''Specifies an arrow-shaped anchor cap.'''
    ANCHOR_MASK = enum.auto()
    '''Specifies a custom line cap.'''
    CUSTOM = enum.auto()
    '''Specifies a mask used to check whether a line cap is an anchor cap.'''

class LineJoin(enum.Enum):
    MITER = enum.auto()
    '''Specifies a mitered join. This produces a sharp corner or a clipped corner, depending on whether the length of the miter exceeds the miter limit.'''
    BEVEL = enum.auto()
    '''Specifies a beveled join. This produces a diagonal corner.'''
    ROUND = enum.auto()
    '''Specifies a circular join. This produces a smooth, circular arc between the lines.'''
    MITER_CLIPPED = enum.auto()
    '''Specifies a mitered join. This produces a sharp corner or a beveled corner, depending on whether the length of the miter exceeds the miter limit.'''

class MatrixOrder(enum.Enum):
    PREPEND = enum.auto()
    '''The new operation is applied before the old operation.'''
    APPEND = enum.auto()
    '''The new operation is applied after the old operation.'''

class PaletteMiningMethod(enum.Enum):
    USE_CURRENT_PALETTE = enum.auto()
    '''Use exisiting palette of the image'''
    COLOR_CLUSTERING = enum.auto()
    '''The color clustering method'''
    HISTOGRAM = enum.auto()
    '''The histogram method'''

class PdfComplianceVersion(enum.Enum):
    PDF15 = enum.auto()
    '''The output file will be PDF 1.5 compliant.'''
    PDF_A1A = enum.auto()
    '''The output file will be PDF/A-1a compliant.'''
    PDF_A1B = enum.auto()
    '''The output file will be PDF/A-1b compliant.'''

class PenAlignment(enum.Enum):
    CENTER = enum.auto()
    '''Specifies that the :py:class:`aspose.imaging.Pen` object is centered over the theoretical line.'''
    INSET = enum.auto()
    '''Specifies that the :py:class:`aspose.imaging.Pen` is positioned on the inside of the theoretical line.'''
    OUTSET = enum.auto()
    '''Specifies the :py:class:`aspose.imaging.Pen` is positioned on the outside of the theoretical line.'''
    LEFT = enum.auto()
    '''Specifies the :py:class:`aspose.imaging.Pen` is positioned to the left of the theoretical line.'''
    RIGHT = enum.auto()
    '''Specifies the :py:class:`aspose.imaging.Pen` is positioned to the right of the theoretical line.'''

class PenType(enum.Enum):
    SOLID_COLOR = enum.auto()
    '''Specifies a solid fill.'''
    HATCH_FILL = enum.auto()
    '''Specifies a hatch fill.'''
    TEXTURE_FILL = enum.auto()
    '''Specifies a bitmap texture fill.'''
    PATH_GRADIENT = enum.auto()
    '''Specifies a path gradient fill.'''
    LINEAR_GRADIENT = enum.auto()
    '''Specifies a linear gradient fill.'''

class PixelFormat(enum.Enum):
    GRAYSCALE = enum.auto()
    '''The grayscale color space'''
    BGR = enum.auto()
    '''The BGR color space.'''
    RGB = enum.auto()
    '''The RGB color space.'''
    Y_CB_CR = enum.auto()
    '''The YCbCr color space.'''
    CMYK = enum.auto()
    '''The CMYK color space.'''
    YCCK = enum.auto()
    '''The YCCK color space.'''
    CIE_LAB = enum.auto()
    '''The CIE lab color space.'''

class ProcessingType(enum.Enum):
    DEFAULT = enum.auto()
    '''The default processing.'''
    INTERLACED8 = enum.auto()
    '''Interlaced by 8 lines processing.'''

class ResizeType(enum.Enum):
    NONE = enum.auto()
    '''The pixels are not preserved during resize operation.'''
    LEFT_TOP_TO_LEFT_TOP = enum.auto()
    '''Left top point of the new image will coincide with the left top point of the original image. Crop will occur if required.'''
    RIGHT_TOP_TO_RIGHT_TOP = enum.auto()
    '''Right top point of the new image will coincide with the right top point of the original image. Crop will occur if required.'''
    RIGHT_BOTTOM_TO_RIGHT_BOTTOM = enum.auto()
    '''Right bottom point of the new image will coincide with the right bottom point of the original image. Crop will occur if required.'''
    LEFT_BOTTOM_TO_LEFT_BOTTOM = enum.auto()
    '''Left bottom point of the new image will coincide with the left bottom point of the original image. Crop will occur if required.'''
    CENTER_TO_CENTER = enum.auto()
    '''Center of the new image will coincide with the center of the original image. Crop will occur if required.'''
    LANCZOS_RESAMPLE = enum.auto()
    '''Resample using lanczos algorithm with a=3.'''
    NEAREST_NEIGHBOUR_RESAMPLE = enum.auto()
    '''Resample using nearest neighbour algorithm.'''
    ADAPTIVE_RESAMPLE = enum.auto()
    '''Resample using adaptive algorithm based on weighted and blended rational function and lanczos3 interpolation algorithms.'''
    BILINEAR_RESAMPLE = enum.auto()
    '''Resample using bilinear interpolation. Image pre-filtering is allowed to remove the noice before resample, when needed'''
    HIGH_QUALITY_RESAMPLE = enum.auto()
    '''The high quality resample'''
    CATMULL_ROM = enum.auto()
    '''The Catmull-Rom cubic interpolation method.'''
    CUBIC_CONVOLUTION = enum.auto()
    '''The Cubic Convolution interpolation method'''
    CUBIC_B_SPLINE = enum.auto()
    '''The CubicBSpline cubic interpolation method'''
    MITCHELL = enum.auto()
    '''The Mitchell cubic interpolation method'''
    SIN_C = enum.auto()
    '''The Sinc (Lanczos3) cubic interpolation method'''
    BELL = enum.auto()
    '''The Bell interpolation method'''

class ResolutionUnit(enum.Enum):
    NONE = enum.auto()
    '''Undefined units'''
    INCH = enum.auto()
    '''Inch units'''
    CM = enum.auto()
    '''Metric centimeter units'''

class RotateFlipType(enum.Enum):
    ROTATE_NONE_FLIP_NONE = enum.auto()
    '''Specifies no clockwise rotation and no flipping.'''
    ROTATE_90_FLIP_NONE = enum.auto()
    '''Specifies a 90-degree clockwise rotation without flipping.'''
    ROTATE_180_FLIP_NONE = enum.auto()
    '''Specifies a 180-degree clockwise rotation without flipping.'''
    ROTATE_270_FLIP_NONE = enum.auto()
    '''Specifies a 270-degree clockwise rotation without flipping.'''
    ROTATE_NONE_FLIP_X = enum.auto()
    '''Specifies no clockwise rotation followed by a horizontal flip.'''
    ROTATE_90_FLIP_X = enum.auto()
    '''Specifies a 90-degree clockwise rotation followed by a horizontal flip.'''
    ROTATE_180_FLIP_X = enum.auto()
    '''Specifies a 180-degree clockwise rotation followed by a horizontal flip.'''
    ROTATE_270_FLIP_X = enum.auto()
    '''Specifies a 270-degree clockwise rotation followed by a horizontal flip.'''
    ROTATE_NONE_FLIP_Y = enum.auto()
    '''Specifies no clockwise rotation followed by a vertical flip.'''
    ROTATE_90_FLIP_Y = enum.auto()
    '''Specifies a 90-degree clockwise rotation followed by a vertical flip.'''
    ROTATE_180_FLIP_Y = enum.auto()
    '''Specifies a 180-degree clockwise rotation followed by a vertical flip.'''
    ROTATE_270_FLIP_Y = enum.auto()
    '''Specifies a 270-degree clockwise rotation followed by a vertical flip.'''
    ROTATE_NONE_FLIP_XY = enum.auto()
    '''Specifies no clockwise rotation followed by a horizontal and vertical flip.'''
    ROTATE_90_FLIP_XY = enum.auto()
    '''Specifies a 90-degree clockwise rotation followed by a horizontal and vertical flip.'''
    ROTATE_180_FLIP_XY = enum.auto()
    '''Specifies a 180-degree clockwise rotation followed by a horizontal and vertical flip.'''
    ROTATE_270_FLIP_XY = enum.auto()
    '''Specifies a 270-degree clockwise rotation followed by a horizontal and vertical flip.'''

class SeekOrigin(enum.Enum):
    BEGIN = enum.auto()
    '''Specifies the beginning of a stream.'''
    CURRENT = enum.auto()
    '''Specifies the current position within a stream.'''
    END = enum.auto()
    '''Specifies the end of a stream.'''

class SmoothingMode(enum.Enum):
    INVALID = enum.auto()
    '''Specifies an invalid mode.'''
    DEFAULT = enum.auto()
    '''Specifies no antialiasing.'''
    HIGH_SPEED = enum.auto()
    '''Specifies no antialiasing.'''
    HIGH_QUALITY = enum.auto()
    '''Specifies antialiased rendering.'''
    NONE = enum.auto()
    '''Specifies no antialiasing.'''
    ANTI_ALIAS = enum.auto()
    '''Specifies antialiased rendering.'''

class StringAlignment(enum.Enum):
    NEAR = enum.auto()
    '''Specifies the text be aligned near the layout. In a left-to-right layout, the near position is left. In a right-to-left layout, the near position is right.'''
    CENTER = enum.auto()
    '''Specifies that text is aligned in the center of the layout rectangle.'''
    FAR = enum.auto()
    '''Specifies that text is aligned far from the origin position of the layout rectangle. In a left-to-right layout, the far position is right. In a right-to-left layout, the far position is left.'''

class StringDigitSubstitute(enum.Enum):
    USER = enum.auto()
    '''Specifies a user-defined substitution scheme.'''
    NONE = enum.auto()
    '''Specifies to disable substitutions.'''
    NATIONAL = enum.auto()
    '''Specifies substitution digits that correspond with the official national language of the user\'s locale.'''
    TRADITIONAL = enum.auto()
    '''Specifies substitution digits that correspond with the user\'s native script or language, which may be different from the official national language of the user\'s locale.'''

class StringFormatFlags(enum.Enum):
    DIRECTION_RIGHT_TO_LEFT = enum.auto()
    '''Text is displayed from right to left.'''
    DIRECTION_VERTICAL = enum.auto()
    '''Text is vertically aligned.'''
    FIT_BLACK_BOX = enum.auto()
    '''Parts of characters are allowed to overhang the string\'s layout rectangle. By default, characters are repositioned to avoid any overhang.'''
    DISPLAY_FORMAT_CONTROL = enum.auto()
    '''Control characters such as the left-to-right mark are shown in the output with a representative glyph.'''
    NO_FONT_FALLBACK = enum.auto()
    '''Fallback to alternate fonts for characters not supported in the requested font is disabled. Any missing characters are displayed with the fonts missing glyph, usually an open square.'''
    MEASURE_TRAILING_SPACES = enum.auto()
    '''Includes the trailing space at the end of each line. By default the boundary rectangle returned by the MeasureString method excludes the space at the end of each line. Set this flag to include that space in measurement.'''
    NO_WRAP = enum.auto()
    '''Text wrapping between lines when formatting within a rectangle is disabled. This flag is implied when a point is passed instead of a rectangle, or when the specified rectangle has a zero line length.'''
    LINE_LIMIT = enum.auto()
    '''Only entire lines are laid out in the formatting rectangle. By default layout continues until the end of the text, or until no more lines are visible as a result of clipping, whichever comes first.
    Note that the default settings allow the last line to be partially obscured by a formatting rectangle that is not a whole multiple of the line height. To ensure that only whole lines are seen,
    specify this value and be careful to provide a formatting rectangle at least as tall as the height of one line.'''
    NO_CLIP = enum.auto()
    '''Overhanging parts of glyphs, and unwrapped text reaching outside the formatting rectangle are allowed to show. By default all text and glyph parts reaching outside the formatting rectangle are clipped.'''
    EXACT_ALIGNMENT = enum.auto()
    '''The exact alignment, correct padding GDI+'''

class StringTrimming(enum.Enum):
    NONE = enum.auto()
    '''Specifies no trimming.'''
    CHARACTER = enum.auto()
    '''Specifies that the text is trimmed to the nearest character.'''
    WORD = enum.auto()
    '''Specifies that text is trimmed to the nearest word.'''
    ELLIPSIS_CHARACTER = enum.auto()
    '''Specifies that the text is trimmed to the nearest character, and an ellipsis is inserted at the end of a trimmed line.'''
    ELLIPSIS_WORD = enum.auto()
    '''Specifies that text is trimmed to the nearest word, and an ellipsis is inserted at the end of a trimmed line.'''
    ELLIPSIS_PATH = enum.auto()
    '''The center is removed from trimmed lines and replaced by an ellipsis. The algorithm keeps as much of the last slash-delimited segment of the line as possible.'''

class TextRenderingHint(enum.Enum):
    SYSTEM_DEFAULT = enum.auto()
    '''Each character is drawn using its glyph bitmap, with the system default rendering hint. The text will be drawn using whatever font-smoothing settings the user has selected for the system.'''
    SINGLE_BIT_PER_PIXEL_GRID_FIT = enum.auto()
    '''Each character is drawn using its glyph bitmap. Hinting is used to improve character appearance on stems and curvature.'''
    SINGLE_BIT_PER_PIXEL = enum.auto()
    '''Each character is drawn using its glyph bitmap. Hinting is not used.'''
    ANTI_ALIAS_GRID_FIT = enum.auto()
    '''Each character is drawn using its antialiased glyph bitmap with hinting. Much better quality due to antialiasing, but at a higher performance cost.'''
    ANTI_ALIAS = enum.auto()
    '''Each character is drawn using its antialiased glyph bitmap without hinting. Better quality due to antialiasing. Stem width differences may be noticeable because hinting is turned off.'''
    CLEAR_TYPE_GRID_FIT = enum.auto()
    '''Each character is drawn using its glyph ClearType bitmap with hinting. The highest quality setting. Used to take advantage of ClearType font features.'''

class WarpMode(enum.Enum):
    PERSPECTIVE = enum.auto()
    '''Specifies a perspective warp.'''
    BILINEAR = enum.auto()
    '''Specifies a bilinear warp.'''

class WrapMode(enum.Enum):
    TILE = enum.auto()
    '''Tiles the gradient or texture.'''
    TILE_FLIP_X = enum.auto()
    '''Reverses the texture or gradient horizontally and then tiles the texture or gradient.'''
    TILE_FLIP_Y = enum.auto()
    '''Reverses the texture or gradient vertically and then tiles the texture or gradient.'''
    TILE_FLIP_XY = enum.auto()
    '''Reverses the texture or gradient horizontally and vertically and then tiles the texture or gradient.'''
    CLAMP = enum.auto()
    '''The texture or gradient is not tiled.'''

