"""The namespace contains types [MS-EMF]: Enhanced Metafile Format.
            2.3 EMF Records"""
from typing import List, Optional, Dict, Iterable, Any, overload
import enum
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.imaging
import aspose.imaging.apsbuilder
import aspose.imaging.apsbuilder.dib
import aspose.imaging.asynctask
import aspose.imaging.brushes
import aspose.imaging.dithering
import aspose.imaging.exif
import aspose.imaging.exif.enums
import aspose.imaging.extensions
import aspose.imaging.fileformats
import aspose.imaging.fileformats.apng
import aspose.imaging.fileformats.avif
import aspose.imaging.fileformats.bigtiff
import aspose.imaging.fileformats.bmp
import aspose.imaging.fileformats.bmp.structures
import aspose.imaging.fileformats.cdr
import aspose.imaging.fileformats.cdr.const
import aspose.imaging.fileformats.cdr.enum
import aspose.imaging.fileformats.cdr.objects
import aspose.imaging.fileformats.cdr.types
import aspose.imaging.fileformats.cmx
import aspose.imaging.fileformats.cmx.objectmodel
import aspose.imaging.fileformats.cmx.objectmodel.enums
import aspose.imaging.fileformats.cmx.objectmodel.specs
import aspose.imaging.fileformats.cmx.objectmodel.styles
import aspose.imaging.fileformats.core
import aspose.imaging.fileformats.core.vectorpaths
import aspose.imaging.fileformats.dicom
import aspose.imaging.fileformats.djvu
import aspose.imaging.fileformats.dng
import aspose.imaging.fileformats.dng.decoder
import aspose.imaging.fileformats.emf
import aspose.imaging.fileformats.emf.dtyp
import aspose.imaging.fileformats.emf.dtyp.commondatastructures
import aspose.imaging.fileformats.emf.emf
import aspose.imaging.fileformats.emf.emf.consts
import aspose.imaging.fileformats.emf.emf.objects
import aspose.imaging.fileformats.emf.emf.records
import aspose.imaging.fileformats.emf.emfplus
import aspose.imaging.fileformats.emf.emfplus.consts
import aspose.imaging.fileformats.emf.emfplus.objects
import aspose.imaging.fileformats.emf.emfplus.records
import aspose.imaging.fileformats.emf.emfspool
import aspose.imaging.fileformats.emf.emfspool.records
import aspose.imaging.fileformats.emf.graphics
import aspose.imaging.fileformats.eps
import aspose.imaging.fileformats.eps.consts
import aspose.imaging.fileformats.gif
import aspose.imaging.fileformats.gif.blocks
import aspose.imaging.fileformats.ico
import aspose.imaging.fileformats.jpeg
import aspose.imaging.fileformats.jpeg2000
import aspose.imaging.fileformats.opendocument
import aspose.imaging.fileformats.opendocument.enums
import aspose.imaging.fileformats.opendocument.objects
import aspose.imaging.fileformats.opendocument.objects.brush
import aspose.imaging.fileformats.opendocument.objects.font
import aspose.imaging.fileformats.opendocument.objects.graphic
import aspose.imaging.fileformats.opendocument.objects.pen
import aspose.imaging.fileformats.pdf
import aspose.imaging.fileformats.png
import aspose.imaging.fileformats.psd
import aspose.imaging.fileformats.svg
import aspose.imaging.fileformats.svg.graphics
import aspose.imaging.fileformats.tga
import aspose.imaging.fileformats.tiff
import aspose.imaging.fileformats.tiff.enums
import aspose.imaging.fileformats.tiff.filemanagement
import aspose.imaging.fileformats.tiff.filemanagement.bigtiff
import aspose.imaging.fileformats.tiff.instancefactory
import aspose.imaging.fileformats.tiff.pathresources
import aspose.imaging.fileformats.tiff.tifftagtypes
import aspose.imaging.fileformats.webp
import aspose.imaging.fileformats.wmf
import aspose.imaging.fileformats.wmf.consts
import aspose.imaging.fileformats.wmf.graphics
import aspose.imaging.fileformats.wmf.objects
import aspose.imaging.fileformats.wmf.objects.escaperecords
import aspose.imaging.imagefilters
import aspose.imaging.imagefilters.complexutils
import aspose.imaging.imagefilters.convolution
import aspose.imaging.imagefilters.filteroptions
import aspose.imaging.imageloadoptions
import aspose.imaging.imageoptions
import aspose.imaging.interfaces
import aspose.imaging.magicwand
import aspose.imaging.magicwand.imagemasks
import aspose.imaging.masking
import aspose.imaging.masking.options
import aspose.imaging.masking.result
import aspose.imaging.memorymanagement
import aspose.imaging.metadata
import aspose.imaging.multithreading
import aspose.imaging.palettehelper
import aspose.imaging.progressmanagement
import aspose.imaging.shapes
import aspose.imaging.shapesegments
import aspose.imaging.sources
import aspose.imaging.watermark
import aspose.imaging.watermark.options
import aspose.imaging.xmp
import aspose.imaging.xmp.schemas
import aspose.imaging.xmp.schemas.dicom
import aspose.imaging.xmp.schemas.dublincore
import aspose.imaging.xmp.schemas.pdf
import aspose.imaging.xmp.schemas.photoshop
import aspose.imaging.xmp.schemas.xmpbaseschema
import aspose.imaging.xmp.schemas.xmpdm
import aspose.imaging.xmp.schemas.xmpmm
import aspose.imaging.xmp.schemas.xmprm
import aspose.imaging.xmp.types
import aspose.imaging.xmp.types.basic
import aspose.imaging.xmp.types.complex
import aspose.imaging.xmp.types.complex.colorant
import aspose.imaging.xmp.types.complex.dimensions
import aspose.imaging.xmp.types.complex.font
import aspose.imaging.xmp.types.complex.resourceevent
import aspose.imaging.xmp.types.complex.resourceref
import aspose.imaging.xmp.types.complex.thumbnail
import aspose.imaging.xmp.types.complex.version
import aspose.imaging.xmp.types.derived

class EmfAbortPath(EmfPathBracketRecordType):
    '''This record aborts a path bracket or discards the path from a closed path bracket.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfAbortPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfAlphaBlend(EmfBitmapRecordType):
    '''The EMR_ALPHABLEND record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, including alpha transparency data, according to a specified blending operation.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfAlphaBlend` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the destination
        rectangle. This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @cx_dest.setter
    def cx_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the destination
        rectangle. This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @property
    def cy_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the destination
        rectangle. This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @cy_dest.setter
    def cy_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the destination
        rectangle. This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @property
    def blend_function(self) -> aspose.imaging.fileformats.emf.emf.records.EmfBlendFunction:
        '''Gets a structure that specifies the blending operations for source and
        destination bitmaps'''
        raise NotImplementedError()
    
    @blend_function.setter
    def blend_function(self, value : aspose.imaging.fileformats.emf.emf.records.EmfBlendFunction) -> None:
        '''Sets a structure that specifies the blending operations for source and
        destination bitmaps'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def xform_sr(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @xform_sr.setter
    def xform_sr(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def bk_src_argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @bk_src_argb_32_color.setter
    def bk_src_argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def cx_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the source rectangle.
        This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @cx_src.setter
    def cx_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the source rectangle.
        This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @property
    def cy_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the source
        rectangle. This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @cy_src.setter
    def cy_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the source
        rectangle. This value MUST be greater than zero.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_ALPHABLEND record. Accordingly, fields in this
        buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_ALPHABLEND record. Accordingly, fields in this
        buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    

class EmfAngleArc(EmfDrawingRecordType):
    '''The EMR_ANGLEARC record specifies a line segment of an arc. The line segment is drawn from the
    current position to the beginning of the arc. The arc is drawn along the perimeter of a circle with the
    given radius and center. The length of the arc is defined by the given start and sweep angles'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfAngleArc` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfAngleArc` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def center(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the circle\'s center.'''
        raise NotImplementedError()
    
    @center.setter
    def center(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the circle\'s center.'''
        raise NotImplementedError()
    
    @property
    def radius(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the circle\'s radius, in logical units.'''
        raise NotImplementedError()
    
    @radius.setter
    def radius(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the circle\'s radius, in logical units.'''
        raise NotImplementedError()
    
    @property
    def start_angle(self) -> float:
        '''Gets a 32-bit float that specifies the arc\'s start angle, in degrees.'''
        raise NotImplementedError()
    
    @start_angle.setter
    def start_angle(self, value : float) -> None:
        '''Sets a 32-bit float that specifies the arc\'s start angle, in degrees.'''
        raise NotImplementedError()
    
    @property
    def sweep_angle(self) -> float:
        '''Gets a 32-bit float that specifies the arc\'s sweep angle, in degrees.'''
        raise NotImplementedError()
    
    @sweep_angle.setter
    def sweep_angle(self, value : float) -> None:
        '''Sets a 32-bit float that specifies the arc\'s sweep angle, in degrees.'''
        raise NotImplementedError()
    

class EmfArc(EmfDrawingRecordType):
    '''The EMR_ARC record specifies an elliptical arc.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfArc` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfArc` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the ending point of the radial line defining the
        starting point of the arc.'''
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the ending point of the radial line defining the
        starting point of the arc.'''
        raise NotImplementedError()
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object that specifies the coordinates, in logical units, of
        the ending point of the radial line defining the ending point of the arc.'''
        raise NotImplementedError()
    
    @end.setter
    def end(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object that specifies the coordinates, in logical units, of
        the ending point of the radial line defining the ending point of the arc.'''
        raise NotImplementedError()
    

class EmfArcTo(EmfDrawingRecordType):
    '''The EMR_ARCTO record specifies an elliptical arc. It resets the current position to the end point of the arc.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfArcTo` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfArcTo` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates of the first radial ending point, in logical units.'''
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates of the first radial ending point, in logical units.'''
        raise NotImplementedError()
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object that specifies the coordinates of the second radial
        ending point, in logical units.'''
        raise NotImplementedError()
    
    @end.setter
    def end(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object that specifies the coordinates of the second radial
        ending point, in logical units.'''
        raise NotImplementedError()
    

class EmfBeginPath(EmfPathBracketRecordType):
    '''This record opens a path bracket in the current playback device context.
    After a path bracket is open, an application can begin processing records to define
    the points that lie in the path.An application MUST close an open path bracket by
    processing the EMR_ENDPATH record.
    When an application processes the EMR_BEGINPATH record, all previous paths
    MUST be discarded from the playback device context.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfBeginPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfBitBlt(EmfBitmapRecordType):
    '''The EMR_BITBLT record specifies a block transfer of pixels from a source bitmap to a destination
    rectangle, optionally in combination with a brush pattern, according to a specified raster operation.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfBitBlt` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the source and
        destination rectangles.'''
        raise NotImplementedError()
    
    @cx_dest.setter
    def cx_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the source and
        destination rectangles.'''
        raise NotImplementedError()
    
    @property
    def cy_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the source and
        destination rectangles.'''
        raise NotImplementedError()
    
    @cy_dest.setter
    def cy_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the source and
        destination rectangles.'''
        raise NotImplementedError()
    
    @property
    def bit_blt_raster_operation(self) -> aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation:
        '''Gets a 32-bit unsigned integer that specifies the raster operation
        code. This code defines how the color data of the source rectangle is to be combined with the
        color data of the destination rectangle and optionally a brush pattern, to achieve the final color.'''
        raise NotImplementedError()
    
    @bit_blt_raster_operation.setter
    def bit_blt_raster_operation(self, value : aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation) -> None:
        '''Sets a 32-bit unsigned integer that specifies the raster operation
        code. This code defines how the color data of the source rectangle is to be combined with the
        color data of the destination rectangle and optionally a brush pattern, to achieve the final color.'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def bk_src_argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @bk_src_argb_32_color.setter
    def bk_src_argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_BITBLT record. Accordingly, fields in this buffer
        that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_BITBLT record. Accordingly, fields in this buffer
        that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    

class EmfBitmapRecordType(EmfRecord):
    '''The bitmap record types perform block transfers of bitmap images.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfBlendFunction:
    '''A structure that specifies the blending operations for source and destination bitmaps.'''
    
    @overload
    def __init__(self, dword_data : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfBlendFunction` class.
        
        :param dword_data: The dword data.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def to_int(self) -> int:
        '''Converts the string representation of a number to an integer.
        
        :returns: The DWORD value of structure.'''
        raise NotImplementedError()
    
    @property
    def blend_operation(self) -> int:
        '''Gets the blend operation code.
        The only source and destination
        blend operation that has been defined is 0x00, which specifies that the source bitmap
        MUST be combined with the destination bitmap based on the alpha transparency values
        of the source pixels. See the following equations for details.'''
        raise NotImplementedError()
    
    @property
    def blend_flags(self) -> int:
        '''Gets the blend flags.
        This value MUST be 0x00 and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def src_constant_alpha(self) -> int:
        '''Gets an 8-bit unsigned integer that specifies alpha transparency,
        which determines the blend of the source and destination bitmaps. This value MUST be
        used on the entire source bitmap. The minimum alpha transparency value, zero,
        corresponds to completely transparent the maximum value, 0xFF, corresponds to
        completely opaque. In effect, a value of 0xFF specifies that the per-pixel alpha values
        determine the blend of the source and destination bitmaps. See the equations later in
        this section for details.'''
        raise NotImplementedError()
    
    @property
    def alpha_format(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfBlendFunction+AlphaFormatEnum:
        '''Gets a structure that specifies how source and destination pixels are
        interpreted with respect to alpha transparency.'''
        raise NotImplementedError()
    

class EmfBoundedRecord(EmfDrawingRecordType):
    '''Base EMF polyshape class.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    

class EmfChord(EmfDrawingRecordType):
    '''The EMR_CHORD record specifies a chord, which is a region bounded by the intersection of an
    ellipse and a line segment, called a secant. The chord is outlined by using the current pen and filled
    by using the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfChord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfChord` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the endpoint of the radial defining the beginning of the chord.'''
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the logical coordinates of the endpoint of the radial defining the beginning of the chord.'''
        raise NotImplementedError()
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object that specifies the logical coordinates of the
        endpoint of the radial defining the end of the chord.'''
        raise NotImplementedError()
    
    @end.setter
    def end(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object that specifies the logical coordinates of the
        endpoint of the radial defining the end of the chord.'''
        raise NotImplementedError()
    

class EmfClippingRecordType(EmfRecord):
    '''The clipping record types specify and manage clipping regions.
    Note  The EMR_SETMETARGN record does not specify parameters.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfCloseFigure(EmfPathBracketRecordType):
    '''This record closes an open figure in a path.
    Processing the EMR_CLOSEFIGURE record MUST close the figure by drawing a line
    from the current position to the first point of the figure, and then it MUST connect
    the lines by using the line join style.If a figure is closed by processing the
    EMR_LINETO record instead of the EMR_CLOSEFIGURE record, end caps are
    used to create the corner instead of a join.EMR_LINETO is specified in section
    2.3.5.13.
    The EMR_CLOSEFIGURE record SHOULD only be used if there is an open path
    bracket in the playback device context.
    A figure in a path is open unless it is explicitly closed by processing this record.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCloseFigure` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfColorCorrectPalette(EmfObjectManipulationRecordType):
    '''The EMR_COLORCORRECTPALETTE record specifies how to correct the entries of a logical palette
    object using WCS 1.0 values.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfColorCorrectPalette` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_palette(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies index of a logical palette object
        (section 2.2.17) in the EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    
    @ih_palette.setter
    def ih_palette(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies index of a logical palette object
        (section 2.2.17) in the EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    
    @property
    def n_first_entry(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the first entry to correct.'''
        raise NotImplementedError()
    
    @n_first_entry.setter
    def n_first_entry(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the first entry to correct.'''
        raise NotImplementedError()
    
    @property
    def n_pal_entries(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of palette entries to correct.'''
        raise NotImplementedError()
    
    @n_pal_entries.setter
    def n_pal_entries(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of palette entries to correct.'''
        raise NotImplementedError()
    

class EmfColorMatchToTargetW(EmfStateRecordType):
    '''The EMR_COLORMATCHTOTargetW record specifies whether to perform color matching with a color
    profile that is specified in a file with a name consisting of Unicode characters.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfColorMatchToTargetW` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def dw_action(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfColorSpace:
        '''Gets a 32-bit unsigned integer that specifies a value from the ColorSpace
        enumeration (section 2.1.7).'''
        raise NotImplementedError()
    
    @dw_action.setter
    def dw_action(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfColorSpace) -> None:
        '''Sets a 32-bit unsigned integer that specifies a value from the ColorSpace
        enumeration (section 2.1.7).'''
        raise NotImplementedError()
    
    @property
    def dw_flags(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfColorMatchToTarget:
        '''Gets a 32-bit unsigned integer that specifies a value from the
        ColorMatchToTarget enumeration (section 2.1.6).'''
        raise NotImplementedError()
    
    @dw_flags.setter
    def dw_flags(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfColorMatchToTarget) -> None:
        '''Sets a 32-bit unsigned integer that specifies a value from the
        ColorMatchToTarget enumeration (section 2.1.6).'''
        raise NotImplementedError()
    
    @property
    def cb_name(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of bytes in the Unicode
        UTF16-LE name of the desired color profile.'''
        raise NotImplementedError()
    
    @cb_name.setter
    def cb_name(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of bytes in the Unicode
        UTF16-LE name of the desired color profile.'''
        raise NotImplementedError()
    
    @property
    def cb_data(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of the raw data of the target
        color profile, if it is contained in the Data field.'''
        raise NotImplementedError()
    
    @cb_data.setter
    def cb_data(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of the raw data of the target
        color profile, if it is contained in the Data field.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name'''
        raise NotImplementedError()
    
    @property
    def raw_data(self) -> List[int]:
        '''Gets the raw data'''
        raise NotImplementedError()
    

class EmfComment(EmfCommentRecordType):
    '''The EMR_COMMENT record contains arbitrary private data.
    Note  Fields that are not described in this section are specified in section 2.3.3.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfComment` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets the comment identifier.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets the comment identifier.'''
        raise NotImplementedError()
    
    @property
    def private_data(self) -> List[int]:
        '''Gets an optional array of bytes that specifies the private data. The first
        DWORD of this data MUST NOT be one of the predefined comment identifier values specified
        in section 2.3.3.
        Private data is unknown to EMF; it is meaningful only to applications that know the format of the
        data and how to use it. EMR_COMMENT private data records MAY be ignored.'''
        raise NotImplementedError()
    
    @private_data.setter
    def private_data(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that specifies the private data. The first
        DWORD of this data MUST NOT be one of the predefined comment identifier values specified
        in section 2.3.3.
        Private data is unknown to EMF; it is meaningful only to applications that know the format of the
        data and how to use it. EMR_COMMENT private data records MAY be ignored.'''
        raise NotImplementedError()
    

class EmfCommentBeginGroup(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_BEGINGROUP record specifies the beginning of a group of drawing records.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentBeginGroup` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        '''Gets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment) -> None:
        '''Sets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @property
    def rectangle(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        output rectangle in logical coordinates.'''
        raise NotImplementedError()
    
    @rectangle.setter
    def rectangle(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        output rectangle in logical coordinates.'''
        raise NotImplementedError()
    
    @property
    def n_description(self) -> int:
        '''Gets the number of Unicode characters in the optional description string that follows.'''
        raise NotImplementedError()
    
    @n_description.setter
    def n_description(self, value : int) -> None:
        '''Sets the number of Unicode characters in the optional description string that follows.'''
        raise NotImplementedError()
    
    @property
    def description(self) -> str:
        '''Gets an optional, null-terminated Unicode string that describes this group of records.'''
        raise NotImplementedError()
    
    @description.setter
    def description(self, value : str) -> None:
        '''Sets an optional, null-terminated Unicode string that describes this group of records.'''
        raise NotImplementedError()
    

class EmfCommentEmfPlus(EmfCommentRecordType):
    '''The EMR_COMMENT_EMFPLUS record contains embedded EMF+ records.
    Note  Fields that are not described in this section are specified in section 2.3.3.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentEmfPlus` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as containing EMF+ records. The value 0x2B464D45, which is the ASCII string "+FME",
        identifies this as an EMR_COMMENT_EMFPLUS record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as containing EMF+ records. The value 0x2B464D45, which is the ASCII string "+FME",
        identifies this as an EMR_COMMENT_EMFPLUS record.'''
        raise NotImplementedError()
    
    @property
    def emf_plus_records(self) -> List[aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord]:
        '''Gets an array of bytes that contains one or more EMF+ records ([MS-EMFPLUS] section 2.3.1).'''
        raise NotImplementedError()
    
    @emf_plus_records.setter
    def emf_plus_records(self, value : List[aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord]) -> None:
        '''Sets an array of bytes that contains one or more EMF+ records ([MS-EMFPLUS] section 2.3.1).'''
        raise NotImplementedError()
    

class EmfCommentEmfSpool(EmfCommentRecordType):
    '''The EMR_COMMENT_EMFSPOOL record contains embedded EMFSPOOL records.
    Note  Fields that are not described in this section are specified in section 2.3.3.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentEmfSpool` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentEmfSpool` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as containing EMFSPOOL records. The value 0x00000000 identifies this as an
        EMR_COMMENT_EMFSPOOL record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as containing EMFSPOOL records. The value 0x00000000 identifies this as an
        EMR_COMMENT_EMFSPOOL record.'''
        raise NotImplementedError()
    
    @property
    def emf_spool_record_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentEmfSpool+EmfSpoolRecordIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies the type of
        EMR_COMMENT_EMFSPOOL record.'''
        raise NotImplementedError()
    
    @emf_spool_record_identifier.setter
    def emf_spool_record_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentEmfSpool+EmfSpoolRecordIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies the type of
        EMR_COMMENT_EMFSPOOL record.'''
        raise NotImplementedError()
    
    @property
    def emf_spool_records(self) -> List[aspose.imaging.fileformats.emf.emfspool.records.EmfSpoolFontDefinitionRecordType]:
        '''Gets a variable-length array of bytes that contains one or more
        EMFSPOOL font definition records ([MS-EMFSPOOL] section 2.2.3.3).'''
        raise NotImplementedError()
    
    @emf_spool_records.setter
    def emf_spool_records(self, value : List[aspose.imaging.fileformats.emf.emfspool.records.EmfSpoolFontDefinitionRecordType]) -> None:
        '''Sets a variable-length array of bytes that contains one or more
        EMFSPOOL font definition records ([MS-EMFSPOOL] section 2.2.3.3).'''
        raise NotImplementedError()
    

class EmfCommentEndGroup(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_ENDGROUP record specifies the end of a group of drawing records.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentEndGroup` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        '''Gets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment) -> None:
        '''Sets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    

class EmfCommentMultiFormats(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_MULTIFORMATS record specifies an image in multiple graphics formats.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentMultiFormats` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        '''Gets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment) -> None:
        '''Sets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @property
    def output_rect(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        output rectangle, in logical coordinates.'''
        raise NotImplementedError()
    
    @output_rect.setter
    def output_rect(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the
        output rectangle, in logical coordinates.'''
        raise NotImplementedError()
    
    @property
    def a_formats(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfFormat]:
        '''Gets a CountFormats length array of graphics formats, specified by
        EmrFormat objects (section 2.2.4), in order of preference'''
        raise NotImplementedError()
    
    @a_formats.setter
    def a_formats(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfFormat]) -> None:
        '''Sets a CountFormats length array of graphics formats, specified by
        EmrFormat objects (section 2.2.4), in order of preference'''
        raise NotImplementedError()
    
    @property
    def format_data(self) -> List[List[int]]:
        '''Gets a variable-length array of bytes of image data for all graphics formats
        contained in this record.
        The size of the data for each image is provided by the DataSize field in the corresponding
        EmrFormat object. Thus, the total size of this field is the sum of DataSize values in all
        EmrFormat objects.
        The graphics format of the data for each image is specified by the Signature field in the
        corresponding EmrFormat object.'''
        raise NotImplementedError()
    
    @format_data.setter
    def format_data(self, value : List[List[int]]) -> None:
        '''Sets a variable-length array of bytes of image data for all graphics formats
        contained in this record.
        The size of the data for each image is provided by the DataSize field in the corresponding
        EmrFormat object. Thus, the total size of this field is the sum of DataSize values in all
        EmrFormat objects.
        The graphics format of the data for each image is specified by the Signature field in the
        corresponding EmrFormat object.'''
        raise NotImplementedError()
    

class EmfCommentPublicRecordType(EmfCommentRecordType):
    '''The EMR_COMMENT_PUBLIC record types specify extensions to EMF processing.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        '''Gets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment) -> None:
        '''Sets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    

class EmfCommentRecordType(EmfRecord):
    '''The comment record types define formats for specifying arbitrary private data, embedding records
    in other metafile formats, and adding new or special-purpose commands.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets the comment identifier.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets the comment identifier.'''
        raise NotImplementedError()
    

class EmfCommentWindowsMetaFile(EmfCommentPublicRecordType):
    '''The EMR_COMMENT_WINDOWS_METAFILE record specifies an image in an embedded WMF metafile.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCommentWindowsMetaFile` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        CommentIdentifier and CommentRecordParm fields in the RecordBuffer field that
        follows. It MUST NOT include the size of itself or the size of the AlignmentPadding field, if
        present'''
        raise NotImplementedError()
    
    @property
    def comment_identifier(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum:
        '''Gets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @comment_identifier.setter
    def comment_identifier(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfCommentRecordType+CommentIdentifierEnum) -> None:
        '''Sets a 32-bit unsigned integer that identifies this comment record
        as specifying public data. The value 0x43494447, which is the ASCII string "CIDG", identifies
        this as an EMR_COMMENT_PUBLIC record.'''
        raise NotImplementedError()
    
    @property
    def public_comment_identifier(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment:
        '''Gets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @public_comment_identifier.setter
    def public_comment_identifier(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfEmrComment) -> None:
        '''Sets a 32-bit unsigned integer that identifies the type of
        public comment record. This SHOULD be one of the values listed in the preceding table, which
        are specified in the EmrComment enumeration (section 2.1.10), unless additional public
        comment record types have been implemented on the print server.'''
        raise NotImplementedError()
    
    @property
    def version(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileVersion:
        '''Gets a 16-bit unsigned integer that specifies the WMF metafile version in terms
        of support for device-independent bitmaps (DIBs), from the WMF MetafileVersion
        enumeration ([MS-WMF] section 2.1.1.19).'''
        raise NotImplementedError()
    
    @version.setter
    def version(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileVersion) -> None:
        '''Sets a 16-bit unsigned integer that specifies the WMF metafile version in terms
        of support for device-independent bitmaps (DIBs), from the WMF MetafileVersion
        enumeration ([MS-WMF] section 2.1.1.19).'''
        raise NotImplementedError()
    
    @property
    def checksum(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the checksum for this record.'''
        raise NotImplementedError()
    
    @checksum.setter
    def checksum(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the checksum for this record.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 32-bit value that MUST be 0x00000000 and MUST be ignored.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 32-bit value that MUST be 0x00000000 and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def win_metafile_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the
        WMF metafile in the WinMetafile field.'''
        raise NotImplementedError()
    
    @win_metafile_size.setter
    def win_metafile_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the
        WMF metafile in the WinMetafile field.'''
        raise NotImplementedError()
    
    @property
    def win_metafile(self) -> aspose.imaging.fileformats.emf.MetaImage:
        '''Gets a buffer that contains the WMF metafile.'''
        raise NotImplementedError()
    
    @win_metafile.setter
    def win_metafile(self, value : aspose.imaging.fileformats.emf.MetaImage) -> None:
        '''Sets a buffer that contains the WMF metafile.'''
        raise NotImplementedError()
    

class EmfControlRecordType(EmfRecord):
    '''The control record types define the start and end of an EMF metafile and properties of the metafile.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfCreateBrushIndirect(EmfObjectCreationRecordType):
    '''The EMR_CREATEBRUSHINDIRECT record defines a logical brush for graphics operations.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateBrushIndirect` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateBrushIndirect` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_brush(self) -> int:
        '''Gets A 32-bit unsigned integer that specifies the index of the logical brush object
        in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @ih_brush.setter
    def ih_brush(self, value : int) -> None:
        '''Sets A 32-bit unsigned integer that specifies the index of the logical brush object
        in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @property
    def log_brush(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogBrushEx:
        '''Gets A LogBrushEx object (section 2.2.12) that specifies the style, color, and
        pattern of the logical brush. The BrushStyle field in this object MUST be BS_SOLID,
        BS_HATCHED, or BS_NULL.'''
        raise NotImplementedError()
    
    @log_brush.setter
    def log_brush(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogBrushEx) -> None:
        '''Sets A LogBrushEx object (section 2.2.12) that specifies the style, color, and
        pattern of the logical brush. The BrushStyle field in this object MUST be BS_SOLID,
        BS_HATCHED, or BS_NULL.'''
        raise NotImplementedError()
    

class EmfCreateColorSpace(EmfObjectCreationRecordType):
    '''The EMR_CREATECOLORSPACE record creates a logical color space object from a color profile with a
    name consisting of ASCII characters.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateColorSpace` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_cs(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the logical color space
        object in the EMF object table (section 3.1.1.1). This index MUST be saved so that this object
        can be reused or modified.'''
        raise NotImplementedError()
    
    @ih_cs.setter
    def ih_cs(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the logical color space
        object in the EMF object table (section 3.1.1.1). This index MUST be saved so that this object
        can be reused or modified.'''
        raise NotImplementedError()
    
    @property
    def lcs(self) -> aspose.imaging.fileformats.wmf.objects.WmfLogColorSpace:
        '''Gets a WMF LogColorSpace object ([MS-WMF] section 2.2.2.11), which can specify
        the name of a color profile in ASCII characters.'''
        raise NotImplementedError()
    
    @lcs.setter
    def lcs(self, value : aspose.imaging.fileformats.wmf.objects.WmfLogColorSpace) -> None:
        '''Sets a WMF LogColorSpace object ([MS-WMF] section 2.2.2.11), which can specify
        the name of a color profile in ASCII characters.'''
        raise NotImplementedError()
    

class EmfCreateColorSpaceW(EmfObjectCreationRecordType):
    '''The EMR_CREATECOLORSPACEW record creates a logical color space object from a color profile with
    a name consisting of Unicode characters.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateColorSpaceW` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_cs(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the logical color space
        object in the EMF object table (section 3.1.1.1). This index MUST be saved so that this object
        can be reused or modified.'''
        raise NotImplementedError()
    
    @ih_cs.setter
    def ih_cs(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the logical color space
        object in the EMF object table (section 3.1.1.1). This index MUST be saved so that this object
        can be reused or modified.'''
        raise NotImplementedError()
    
    @property
    def lcs(self) -> aspose.imaging.fileformats.wmf.objects.WmfLogColorSpaceW:
        '''Gets a WMF LogColorSpaceW object ([MS-WMF] section 2.2.2.12) that can specify
        the name of a color profile in Unicode UTF16-LE characters'''
        raise NotImplementedError()
    
    @lcs.setter
    def lcs(self, value : aspose.imaging.fileformats.wmf.objects.WmfLogColorSpaceW) -> None:
        '''Sets a WMF LogColorSpaceW object ([MS-WMF] section 2.2.2.12) that can specify
        the name of a color profile in Unicode UTF16-LE characters'''
        raise NotImplementedError()
    
    @property
    def dw_flags(self) -> int:
        '''Gets a 32-bit unsigned integer that provides information about the data in this record.'''
        raise NotImplementedError()
    
    @dw_flags.setter
    def dw_flags(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that provides information about the data in this record.'''
        raise NotImplementedError()
    
    @property
    def cb_data(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the Data field.'''
        raise NotImplementedError()
    
    @cb_data.setter
    def cb_data(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the Data field.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets an optional array of bytes that specifies color profile data.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that specifies color profile data.'''
        raise NotImplementedError()
    

class EmfCreateDibPatternBrushPt(EmfObjectCreationRecordType):
    '''The EMR_CREATEDIBPATTERNBRUSHPT record defines a pattern brush for graphics operations. The
    pattern is specified by a DIB.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateDibPatternBrushPt` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateDibPatternBrushPt` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_brush(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the pattern brush
        object in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object
        can be reused or modified.'''
        raise NotImplementedError()
    
    @ih_brush.setter
    def ih_brush(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the pattern brush
        object in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object
        can be reused or modified.'''
        raise NotImplementedError()
    
    @property
    def usage(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage.setter
    def usage(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def bitmap_buffer(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing a packed DIB in the form of a WMF
        DeviceIndependentBitmap object ([MS-WMF] section 2.2.2.9). It is not required to be
        contiguous with the fixed portion of the EMR_CREATEDIBPATTERNBRUSHPT record.'''
        raise NotImplementedError()
    
    @bitmap_buffer.setter
    def bitmap_buffer(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing a packed DIB in the form of a WMF
        DeviceIndependentBitmap object ([MS-WMF] section 2.2.2.9). It is not required to be
        contiguous with the fixed portion of the EMR_CREATEDIBPATTERNBRUSHPT record.'''
        raise NotImplementedError()
    

class EmfCreateMonoBrush(EmfObjectCreationRecordType):
    '''The EMR_CREATEMONOBRUSH record defines a monochrome pattern brush for graphics operations.
    The pattern is specified by a monochrome DIB.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreateMonoBrush` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_brush(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the monochrome
        pattern brush object in the EMF Object Table (section 3.1.1.1). This index MUST be saved so
        that this object can be reused or modified.'''
        raise NotImplementedError()
    
    @ih_brush.setter
    def ih_brush(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the monochrome
        pattern brush object in the EMF Object Table (section 3.1.1.1). This index MUST be saved so
        that this object can be reused or modified.'''
        raise NotImplementedError()
    
    @property
    def usage(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage.setter
    def usage(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the color
        table in the DIB header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def bitmap_buffer(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing a packed DIB in the form of a WMF
        DeviceIndependentBitmap object ([MS-WMF] section 2.2.2.9). It is not required to be
        contiguous with the fixed portion of the EMR_CREATEDIBPATTERNBRUSHPT record.'''
        raise NotImplementedError()
    
    @bitmap_buffer.setter
    def bitmap_buffer(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing a packed DIB in the form of a WMF
        DeviceIndependentBitmap object ([MS-WMF] section 2.2.2.9). It is not required to be
        contiguous with the fixed portion of the EMR_CREATEDIBPATTERNBRUSHPT record.'''
        raise NotImplementedError()
    

class EmfCreatePalette(EmfObjectCreationRecordType):
    '''The EMR_CREATEPALETTE record defines a logical palette for graphics operations.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreatePalette` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_pal(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the logical palette object
        in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @ih_pal.setter
    def ih_pal(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the logical palette object
        in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @property
    def log_palette(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogPalette:
        '''Gets a LogPalette object (section 2.2.17). The Version field of this object
        MUST be set to 0x0300. If the NumberOfEntries value in this object is zero, processing of
        this record MUST fail.'''
        raise NotImplementedError()
    
    @log_palette.setter
    def log_palette(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogPalette) -> None:
        '''Sets a LogPalette object (section 2.2.17). The Version field of this object
        MUST be set to 0x0300. If the NumberOfEntries value in this object is zero, processing of
        this record MUST fail.'''
        raise NotImplementedError()
    

class EmfCreatePen(EmfObjectCreationRecordType):
    '''The EMR_CREATEPEN record defines a logical pen for graphics operations.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreatePen` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfCreatePen` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_pen(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the logical pen object in
        the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @ih_pen.setter
    def ih_pen(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the logical pen object in
        the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @property
    def log_pen(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogPen:
        '''Gets a LogPen object (section 2.2.19) that specifies the style, width, and color
        of the logical pen.'''
        raise NotImplementedError()
    
    @log_pen.setter
    def log_pen(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogPen) -> None:
        '''Sets a LogPen object (section 2.2.19) that specifies the style, width, and color
        of the logical pen.'''
        raise NotImplementedError()
    

class EmfDeleteColorSpace(EmfObjectManipulationRecordType):
    '''The EMR_DELETECOLORSPACE record deletes a logical color space object.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfDeleteColorSpace` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_cs(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of a logical color space object
        in the EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    
    @ih_cs.setter
    def ih_cs(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of a logical color space object
        in the EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    

class EmfDeleteObject(EmfRecord):
    '''The EMR_DELETEOBJECT record deletes a graphics object, which is specified by its index in the EMF Object Table(section 3.1.1.1).'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfDeleteObject` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfDeleteObject` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def object_handle(self) -> int:
        '''Gets 32-bit unsigned integer that specifies either the index of a graphics object
        in the EMF Object Table or the index of a stock object from the StockObject enumeration.'''
        raise NotImplementedError()
    
    @object_handle.setter
    def object_handle(self, value : int) -> None:
        '''Sets 32-bit unsigned integer that specifies either the index of a graphics object
        in the EMF Object Table or the index of a stock object from the StockObject enumeration.'''
        raise NotImplementedError()
    

class EmfDrawEscape(EmfEscapeRecordType):
    '''The EMR_DRAWESCAPE record passes arbitrary information to a printer driver. The intent is that the
    information will result in drawing being done.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfDrawEscape` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        '''Gets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes) -> None:
        '''Sets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @property
    def cj_in(self) -> int:
        '''Gets a 32-bit unsigned integer specifying the number of bytes to pass to the printer driver.'''
        raise NotImplementedError()
    
    @cj_in.setter
    def cj_in(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer specifying the number of bytes to pass to the printer driver.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        raise NotImplementedError()
    

class EmfDrawingRecordType(EmfRecord):
    '''The drawing record types perform graphics drawing.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfEllipse(EmfDrawingRecordType):
    '''The EMR_ELLIPSE record specifies an ellipse. The center of the ellipse is the center of the specified
    bounding rectangle. The ellipse is outlined by using the current pen and is filled by using the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfEllipse` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfEllipse` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit (WMF) RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit (WMF) RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    

class EmfEndPath(EmfPathBracketRecordType):
    '''This record closes a path bracket and selects the path defined by the bracket into
    the playback device context.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfEndPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfEof(EmfControlRecordType):
    '''The EMR_EOF record indicates the end of the metafile and specifies a palette.'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfEof` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfEof` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def palette_argb_32_entries(self) -> List[int]:
        '''Gets an optional buffer that contains palette data, which is not
        required to be contiguous with the fixed portion of the EMR_EOF
        record. Accordingly, fields in this buffer that are labeled
        "UndefinedSpace" are optional and MUST be ignored.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @palette_argb_32_entries.setter
    def palette_argb_32_entries(self, value : List[int]) -> None:
        '''Sets an optional buffer that contains palette data, which is not
        required to be contiguous with the fixed portion of the EMR_EOF
        record. Accordingly, fields in this buffer that are labeled
        "UndefinedSpace" are optional and MUST be ignored.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @property
    def size_last(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST be the same as Size and MUST be the last
        field of the record and hence the metafile. LogPaletteEntry objects, if they
        exist, MUST precede this field.'''
        raise NotImplementedError()
    
    @size_last.setter
    def size_last(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST be the same as Size and MUST be the last
        field of the record and hence the metafile. LogPaletteEntry objects, if they
        exist, MUST precede this field.'''
        raise NotImplementedError()
    

class EmfEscapeRecordType(EmfRecord):
    '''The escape record types execute printer driver functions.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        '''Gets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes) -> None:
        '''Sets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    

class EmfExcludeClipRect(EmfClippingRecordType):
    '''The EMR_EXCLUDECLIPRECT record specifies a new clipping region that consists of the existing
    clipping region minus the specified rectangle.
    Note  Fields that are not described in this section are specified in section 2.3.2.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExcludeClipRect` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExcludeClipRect` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def clip(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the clipping
        rectangle in logical units.'''
        raise NotImplementedError()
    
    @clip.setter
    def clip(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the clipping
        rectangle in logical units.'''
        raise NotImplementedError()
    

class EmfExtCreateFontIndirectW(EmfObjectCreationRecordType):
    '''The EMR_EXTCREATEFONTINDIRECTW record defines a logical font for graphics operations.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtCreateFontIndirectW` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtCreateFontIndirectW` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_fonts(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the logical font object
        in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @ih_fonts.setter
    def ih_fonts(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the logical font object
        in the EMF Object Table (section 3.1.1.1). This index MUST be saved so that this object can be
        reused or modified.'''
        raise NotImplementedError()
    
    @property
    def elw(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogFont:
        '''Gets a LogFontExDv object (section 2.2.15), which specifies the logical font. A
        LogFont object 2.2.13 MAY be present instead.[90]The process for determining the type of
        object in this field is described below.'''
        raise NotImplementedError()
    
    @elw.setter
    def elw(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogFont) -> None:
        '''Sets a LogFontExDv object (section 2.2.15), which specifies the logical font. A
        LogFont object 2.2.13 MAY be present instead.[90]The process for determining the type of
        object in this field is described below.'''
        raise NotImplementedError()
    

class EmfExtCreatePen(EmfObjectCreationRecordType):
    '''The EMR_EXTCREATEPEN record defines an extended logical pen for graphics operations. An
    optional DIB can be specified to use as the line style.'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtCreatePen` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtCreatePen` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_pen(self) -> int:
        '''Gets  32-bit unsigned integer that specifies the index of the extended logical
        pen object in the EMF Object Table (section 3.1.1.1).
        This index MUST be saved so that this object can be reused or modified.'''
        raise NotImplementedError()
    
    @ih_pen.setter
    def ih_pen(self, value : int) -> None:
        '''Sets  32-bit unsigned integer that specifies the index of the extended logical
        pen object in the EMF Object Table (section 3.1.1.1).
        This index MUST be saved so that this object can be reused or modified.'''
        raise NotImplementedError()
    
    @property
    def elp(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfLogPenEx:
        '''Gets a LogPenEx object (section 2.2.20) that specifies an extended logical
        pen with attributes including an optional line style array.'''
        raise NotImplementedError()
    
    @elp.setter
    def elp(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfLogPenEx) -> None:
        '''Sets a LogPenEx object (section 2.2.20) that specifies an extended logical
        pen with attributes including an optional line style array.'''
        raise NotImplementedError()
    
    @property
    def bitmap_buffer(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets an optional buffer containing a packed DIB in the form of a WMF DeviceIndependentBitmap object
        ([MS-WMF] section 2.2.2.9). It is not required to be contiguous with the fixed portion of the EMR_EXTCREATEPEN record'''
        raise NotImplementedError()
    
    @bitmap_buffer.setter
    def bitmap_buffer(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets an optional buffer containing a packed DIB in the form of a WMF DeviceIndependentBitmap object
        ([MS-WMF] section 2.2.2.9). It is not required to be contiguous with the fixed portion of the EMR_EXTCREATEPEN record'''
        raise NotImplementedError()
    

class EmfExtEscape(EmfEscapeRecordType):
    '''The EMR_EXTESCAPE record passes arbitrary information to a printer driver. The intent is that the
    information will not result in drawing being done.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtEscape` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        '''Gets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes) -> None:
        '''Sets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @property
    def cj_in(self) -> int:
        '''Gets a 32-bit unsigned integer specifying the number of bytes to pass to the printer driver.'''
        raise NotImplementedError()
    
    @cj_in.setter
    def cj_in(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer specifying the number of bytes to pass to the printer driver.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets the data to pass to the printer driver. There MUST be cjIn bytes available.'''
        raise NotImplementedError()
    

class EmfExtFloodFill(EmfDrawingRecordType):
    '''The EMR_EXTFLOODFILL record fills an area of the display surface with the current brush'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtFloodFill` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a WMF PointL object ([MS-WMF] section 2.2.2.15), which specifies the
        coordinates, in logical units, where filling begins.'''
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : aspose.imaging.Point) -> None:
        '''Sets a WMF PointL object ([MS-WMF] section 2.2.2.15), which specifies the
        coordinates, in logical units, where filling begins.'''
        raise NotImplementedError()
    
    @property
    def argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8), which is used with the
        FloodFillMode to determine the area to fill.'''
        raise NotImplementedError()
    
    @argb_32_color.setter
    def argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8), which is used with the
        FloodFillMode to determine the area to fill.'''
        raise NotImplementedError()
    
    @property
    def flood_fill_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfFloodFill:
        '''Gets a 32-bit unsigned integer that specifies how to use the Color value
        to determine the area for the flood fill operation. The value MUST be in the FloodFill
        enumeration (section 2.1.13).'''
        raise NotImplementedError()
    
    @flood_fill_mode.setter
    def flood_fill_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfFloodFill) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to use the Color value
        to determine the area for the flood fill operation. The value MUST be in the FloodFill
        enumeration (section 2.1.13).'''
        raise NotImplementedError()
    

class EmfExtSelectClipRgn(EmfClippingRecordType):
    '''The EMR_EXTSELECTCLIPRGN record combines the specified region with the current clip region
    using the specified mode.
    Note  Fields that are not described in this section are specified in section 2.3.2.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtSelectClipRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtSelectClipRgn` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def rgn_data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of region data in bytes.'''
        raise NotImplementedError()
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of region data in bytes.'''
        raise NotImplementedError()
    
    @property
    def region_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode:
        '''Gets a 32-bit unsigned integer that specifies the way to use the region. The
        value MUST be in the RegionMode (section 2.1.29) enumeration.'''
        raise NotImplementedError()
    
    @region_mode.setter
    def region_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the way to use the region. The
        value MUST be in the RegionMode (section 2.1.29) enumeration.'''
        raise NotImplementedError()
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        '''Gets a RgnDataSize length array of bytes that specifies a RegionData object
        in logical units. If RegionMode is RGN_COPY, this data can be omitted and the clip region
        SHOULD be set to the default (NULL) clip region.'''
        raise NotImplementedError()
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData) -> None:
        '''Sets a RgnDataSize length array of bytes that specifies a RegionData object
        in logical units. If RegionMode is RGN_COPY, this data can be omitted and the clip region
        SHOULD be set to the default (NULL) clip region.'''
        raise NotImplementedError()
    

class EmfExtTextOutA(EmfDrawingRecordType):
    '''The EMR_EXTTEXTOUTA record draws an ASCII text string using the current font and text colors.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtTextOutA` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtTextOutA` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        raise NotImplementedError()
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        '''Gets a 32-bit unsigned integer that specifies the graphics mode from the
        GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the graphics mode from the
        GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @property
    def ex_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the scale factor to apply along
        the X axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ex_scale.setter
    def ex_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the scale factor to apply along
        the X axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def ey_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the scale factor to apply along
        the Y axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ey_scale.setter
    def ey_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the scale factor to apply along
        the Y axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def a_emr_text(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfText:
        '''Gets an EmrText object (section 2.2.5) that specifies the output string in 8-bit
        ASCII characters, text attributes, and spacing values.'''
        raise NotImplementedError()
    
    @a_emr_text.setter
    def a_emr_text(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfText) -> None:
        '''Sets an EmrText object (section 2.2.5) that specifies the output string in 8-bit
        ASCII characters, text attributes, and spacing values.'''
        raise NotImplementedError()
    

class EmfExtTextOutW(EmfDrawingRecordType):
    '''The EMR_EXTTEXTOUTW record draws an ASCII text string using the current font and text colors.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtTextOutW` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfExtTextOutW` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19). It is not used and
        MUST be ignored on receipt.'''
        raise NotImplementedError()
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        '''Gets a 32-bit unsigned integer that specifies the graphics mode from the
        GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the graphics mode from the
        GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @property
    def ex_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the scale factor to apply along
        the X axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ex_scale.setter
    def ex_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the scale factor to apply along
        the X axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def ey_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the scale factor to apply along
        the Y axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ey_scale.setter
    def ey_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the scale factor to apply along
        the Y axis to convert from page space units to .01mm units. This SHOULD be used only if the
        graphics mode specified by iGraphicsMode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def w_emr_text(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfText:
        '''Gets an EmrText object (section 2.2.5) that specifies the output string in 16-bit Unicode UTF16-LE characters, with text attributes and spacing values.'''
        raise NotImplementedError()
    
    @w_emr_text.setter
    def w_emr_text(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfText) -> None:
        '''Sets an EmrText object (section 2.2.5) that specifies the output string in 16-bit Unicode UTF16-LE characters, with text attributes and spacing values.'''
        raise NotImplementedError()
    

class EmfFillPath(EmfDrawingRecordType):
    '''The EMR_FILLPATH record closes any open figures in the current path and fills the path\'s interior by
    using the current brush and polygon-filling mode.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFillPath` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFillPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies bounding rectangle, in device units.'''
        raise NotImplementedError()
    

class EmfFillRgn(EmfDrawingRecordType):
    '''The EMR_FILLRGN record fills the specified region by using the specified brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFillRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFillRgn` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def rgn_data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @property
    def ih_brush(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the brush EMF Object Table index
        to fill the region.'''
        raise NotImplementedError()
    
    @ih_brush.setter
    def ih_brush(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the brush EMF Object Table index
        to fill the region.'''
        raise NotImplementedError()
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        '''Gets a RgnDataSize length array of bytes that contains a RegionData (section 2.2.24) object.'''
        raise NotImplementedError()
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData) -> None:
        '''Sets a RgnDataSize length array of bytes that contains a RegionData (section 2.2.24) object.'''
        raise NotImplementedError()
    

class EmfFlatternPath(EmfPathBracketRecordType):
    '''This record transforms any curves in the selected path into the playback device
    context; each curve MUST be turned into a sequence of lines.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFlatternPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfForceUfiMapping(EmfStateRecordType):
    '''The EMR_FORCEUFIMAPPING record forces the font mapper to match fonts based on their
    UniversalFontId in preference to their LogFont (section 2.2.13) information.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfForceUfiMapping` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ufi(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId:
        '''Gets the font id to use, specified as a UniversalFontId (section 2.2.27).'''
        raise NotImplementedError()
    
    @ufi.setter
    def ufi(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId) -> None:
        '''Sets the font id to use, specified as a UniversalFontId (section 2.2.27).'''
        raise NotImplementedError()
    

class EmfFrameRgn(EmfDrawingRecordType):
    '''The EMR_FRAMERGN record draws a border around the specified region using the specified brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFrameRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfFrameRgn` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def rgn_data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @property
    def ih_brush(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the brush EMF Object Table index.'''
        raise NotImplementedError()
    
    @ih_brush.setter
    def ih_brush(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the brush EMF Object Table index.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets a 32-bit signed integer that specifies the width of the vertical brush stroke, in logical units.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the width of the vertical brush stroke, in logical units.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets a 32-bit signed integer that specifies the height of the horizontal brush
        stroke, in logical units.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the height of the horizontal brush
        stroke, in logical units.'''
        raise NotImplementedError()
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        '''Gets a RgnDataSize length array of bytes that specifies a RegionData object,
        in logical units'''
        raise NotImplementedError()
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData) -> None:
        '''Sets a RgnDataSize length array of bytes that specifies a RegionData object,
        in logical units'''
        raise NotImplementedError()
    

class EmfGlsBoundedRecord(EmfOpenGlRecordType):
    '''The EMR_GLSBOUNDEDRECORD record specifies an OpenGL function with a bounding rectangle for output.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfGlsBoundedRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines a bounding
        rectangle, in device units, for output produced by executing the OpenGL function.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines a bounding
        rectangle, in device units, for output produced by executing the OpenGL function.'''
        raise NotImplementedError()
    
    @property
    def cb_data(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the Data field.
        If this value is zero, no data is attached to this record.'''
        raise NotImplementedError()
    
    @cb_data.setter
    def cb_data(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the Data field.
        If this value is zero, no data is attached to this record.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        raise NotImplementedError()
    

class EmfGlsRecord(EmfOpenGlRecordType):
    '''The EMR_GLSRECORD record specifies an OpenGL function.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfGlsRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def cb_data(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size, in bytes, of the Data field.
        If this value is zero, no data is attached to this record.'''
        raise NotImplementedError()
    
    @cb_data.setter
    def cb_data(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size, in bytes, of the Data field.
        If this value is zero, no data is attached to this record.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets an optional array of bytes of cbData length that specifies data for the OpenGL function.'''
        raise NotImplementedError()
    

class EmfGradientFill(EmfDrawingRecordType):
    '''The EMR_GRADIENTFILL record specifies filling rectangles or triangles with gradients of color.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfGradientFill` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies a
        bounding rectangle, in inclusive-inclusive device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies a
        bounding rectangle, in inclusive-inclusive device units.'''
        raise NotImplementedError()
    
    @property
    def n_ver(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of vertexes.'''
        raise NotImplementedError()
    
    @n_ver.setter
    def n_ver(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of vertexes.'''
        raise NotImplementedError()
    
    @property
    def n_tri(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of rectangles or triangles to fill.'''
        raise NotImplementedError()
    
    @n_tri.setter
    def n_tri(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of rectangles or triangles to fill.'''
        raise NotImplementedError()
    
    @property
    def ul_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGradientFill:
        '''Gets a 32-bit unsigned integer that specifies the gradient fill mode. The value
        MUST be in the GradientFill enumeration (section 2.1.15).'''
        raise NotImplementedError()
    
    @ul_mode.setter
    def ul_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGradientFill) -> None:
        '''Sets a 32-bit unsigned integer that specifies the gradient fill mode. The value
        MUST be in the GradientFill enumeration (section 2.1.15).'''
        raise NotImplementedError()
    
    @property
    def vertex_data(self) -> aspose.imaging.fileformats.emf.emf.records.EmfVertexData:
        '''Gets objects that specify the vertexes of either rectangles or triangles and
        the colors that correspond to them.'''
        raise NotImplementedError()
    
    @vertex_data.setter
    def vertex_data(self, value : aspose.imaging.fileformats.emf.emf.records.EmfVertexData) -> None:
        '''Sets objects that specify the vertexes of either rectangles or triangles and
        the colors that correspond to them.'''
        raise NotImplementedError()
    

class EmfIntersectClipRect(EmfClippingRecordType):
    '''The EMR_INTERSECTCLIPRECT record specifies a new clipping region from the intersection of the
    current clipping region and the specified rectangle.
    Note  Fields that are not described in this section are specified in section 2.3.2.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfIntersectClipRect` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def clip(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the rectangle in logical units.'''
        raise NotImplementedError()
    
    @clip.setter
    def clip(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the rectangle in logical units.'''
        raise NotImplementedError()
    

class EmfInvertRgn(EmfStateRecordType):
    '''The EMR_INVERTRGN record inverts the colors in the specified region.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfInvertRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def rgn_data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @property
    def rgn_data(self) -> List[int]:
        '''Gets a RgnDataSize length array of bytes that specifies a RegionData object, in logical units.'''
        raise NotImplementedError()
    
    @rgn_data.setter
    def rgn_data(self, value : List[int]) -> None:
        '''Sets a RgnDataSize length array of bytes that specifies a RegionData object, in logical units.'''
        raise NotImplementedError()
    

class EmfLineTo(EmfRecord):
    '''The EMR_LINETO record specifies a line from the current position up to, but not including, the
    specified point.It resets the current position to the specified point.'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfLineTo` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfLineTo` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def point(self) -> aspose.imaging.Point:
        '''Gets 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies the coordinates of the line\'s ending point.'''
        raise NotImplementedError()
    
    @point.setter
    def point(self, value : aspose.imaging.Point) -> None:
        '''Sets 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies the coordinates of the line\'s ending point.'''
        raise NotImplementedError()
    

class EmfMaskBlt(EmfBitmapRecordType):
    '''The EMR_MASKBLT record specifies a block transfer of pixels from a source bitmap to a destination
    rectangle, optionally in combination with a brush pattern and with the application of a color mask
    bitmap, according to specified foreground and background raster operations.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMaskBlt` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @cx_dest.setter
    def cx_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @cy_dest.setter
    def cy_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def rop4(self) -> aspose.imaging.fileformats.emf.emf.records.EmfRop4:
        '''Gets a quaternary raster operation, which specifies ternary raster operations for
        the foreground and background colors of a bitmap. These values define how the color data of
        the source rectangle is to be combined with the color data of the destination rectangle.'''
        raise NotImplementedError()
    
    @rop4.setter
    def rop4(self, value : aspose.imaging.fileformats.emf.emf.records.EmfRop4) -> None:
        '''Sets a quaternary raster operation, which specifies ternary raster operations for
        the foreground and background colors of a bitmap. These values define how the color data of
        the source rectangle is to be combined with the color data of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def argb_32_bk_color_src(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @argb_32_bk_color_src.setter
    def argb_32_bk_color_src(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def x_mask(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @x_mask.setter
    def x_mask(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @property
    def y_mask(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @y_mask.setter
    def y_mask(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_mask(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the mask bitmap header. This value MUST be in the DIBColors enumeration.'''
        raise NotImplementedError()
    
    @usage_mask.setter
    def usage_mask(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the mask bitmap header. This value MUST be in the DIBColors enumeration.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmaps, which are not
        required to be contiguous with the fixed portion of the EMR_MASKBLT record or with each
        other. Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and
        MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmaps, which are not
        required to be contiguous with the fixed portion of the EMR_MASKBLT record or with each
        other. Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and
        MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def mask_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the mask bitmaps, which are not
        required to be contiguous with the fixed portion of the EMR_MASKBLT record or with each
        other. Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and
        MUST be ignored.'''
        raise NotImplementedError()
    
    @mask_bitmap.setter
    def mask_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the mask bitmaps, which are not
        required to be contiguous with the fixed portion of the EMR_MASKBLT record or with each
        other. Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and
        MUST be ignored.'''
        raise NotImplementedError()
    

class EmfMetafileHeader(EmfRecord):
    '''The EMR_HEADER record types define the starting points of EMF metafiles
    and specify properties of the device on which the image in the metafile
    was created. The information in the header record makes it possible for
    EMF metafiles to be independent of any specific output device.
    The value of the Size field can be used to distinguish between the different
    EMR_HEADER record types listed earlier in this section.
    There are three possible headers:
    The base header, which is the EmfMetafileHeader record.
    The fixed-size part of this header is 88 bytes, and it contains a Header object.
    The first extension header, which is the EmfMetafileHeaderExtension1 record.
    The fixed-size part of this header is 100 bytes, and it contains a Header object
    and a HeaderExtension1 object (section 2.2.10).
    The second extension header, which is the EmfMetafileHeaderExtension2 record.
    The fixed-size part of this header is 108 bytes, and it contains a Header object,
    a HeaderExtension1 object, and a HeaderExtension2 object (section 2.2.11).'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_header(header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def emf_header(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject:
        '''Gets a Header object (section 2.2.9), which contains information about the content
        and structure of the metafile'''
        raise NotImplementedError()
    
    @emf_header.setter
    def emf_header(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject) -> None:
        '''Sets a Header object (section 2.2.9), which contains information about the content
        and structure of the metafile'''
        raise NotImplementedError()
    
    @property
    def emf_header_record_buffer(self) -> List[int]:
        '''Gets an optional array of bytes that contains the remainder of the EMF header record.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @emf_header_record_buffer.setter
    def emf_header_record_buffer(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that contains the remainder of the EMF header record.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @property
    def emf_description_buffer(self) -> List[int]:
        '''Gets the EMF description buffer
        An optional array of bytes that contains the EMF description string, which is
        not required to be contiguous with the fixed portion of the EmfMetafileHeader
        record. Accordingly, the field in this buffer that is labeled "UndefinedSpace"
        is optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @emf_description_buffer.setter
    def emf_description_buffer(self, value : List[int]) -> None:
        '''Sets the EMF description buffer
        An optional array of bytes that contains the EMF description string, which is
        not required to be contiguous with the fixed portion of the EmfMetafileHeader
        record. Accordingly, the field in this buffer that is labeled "UndefinedSpace"
        is optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def emf_description(self) -> str:
        '''Gets the EMF description
        An optional, null-terminated Unicode UTF16-LE string of arbitrary length and content.
        Its location in the record and number of characters are specified by the offDescription
        and nDescription fields, respectively, in EmfHeader. If the value of either field
        is zero, no description string is present.'''
        raise NotImplementedError()
    
    @emf_description.setter
    def emf_description(self, value : str) -> None:
        '''Sets the EMF description
        An optional, null-terminated Unicode UTF16-LE string of arbitrary length and content.
        Its location in the record and number of characters are specified by the offDescription
        and nDescription fields, respectively, in EmfHeader. If the value of either field
        is zero, no description string is present.'''
        raise NotImplementedError()
    

class EmfMetafileHeaderExtension1(EmfMetafileHeader):
    '''The EmfMetafileHeaderExtension1 record is the header record used in the first extension to EMF metafiles.
    Following the EmfHeaderExtension1 field, the remaining fields are optional and can be present in any order.'''
    
    @overload
    def __init__(self, header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_header(header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_header_extension1(header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def emf_header(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject:
        '''Gets a Header object (section 2.2.9), which contains information about the content
        and structure of the metafile'''
        raise NotImplementedError()
    
    @emf_header.setter
    def emf_header(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject) -> None:
        '''Sets a Header object (section 2.2.9), which contains information about the content
        and structure of the metafile'''
        raise NotImplementedError()
    
    @property
    def emf_header_record_buffer(self) -> List[int]:
        '''Gets an optional array of bytes that contains the remainder of the EMF header record.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @emf_header_record_buffer.setter
    def emf_header_record_buffer(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that contains the remainder of the EMF header record.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @property
    def emf_description_buffer(self) -> List[int]:
        '''Gets the EMF description buffer
        An optional array of bytes that contains the EMF description string, which is
        not required to be contiguous with the fixed portion of the EmfMetafileHeader
        record. Accordingly, the field in this buffer that is labeled "UndefinedSpace"
        is optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @emf_description_buffer.setter
    def emf_description_buffer(self, value : List[int]) -> None:
        '''Sets the EMF description buffer
        An optional array of bytes that contains the EMF description string, which is
        not required to be contiguous with the fixed portion of the EmfMetafileHeader
        record. Accordingly, the field in this buffer that is labeled "UndefinedSpace"
        is optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def emf_description(self) -> str:
        '''Gets the EMF description
        An optional, null-terminated Unicode UTF16-LE string of arbitrary length and content.
        Its location in the record and number of characters are specified by the offDescription
        and nDescription fields, respectively, in EmfHeader. If the value of either field
        is zero, no description string is present.'''
        raise NotImplementedError()
    
    @emf_description.setter
    def emf_description(self, value : str) -> None:
        '''Sets the EMF description
        An optional, null-terminated Unicode UTF16-LE string of arbitrary length and content.
        Its location in the record and number of characters are specified by the offDescription
        and nDescription fields, respectively, in EmfHeader. If the value of either field
        is zero, no description string is present.'''
        raise NotImplementedError()
    
    @property
    def emf_header_extension1(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1:
        '''Gets a HeaderExtension1 object, which specifies additional information about the image in the metafile.'''
        raise NotImplementedError()
    
    @emf_header_extension1.setter
    def emf_header_extension1(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1) -> None:
        '''Sets a HeaderExtension1 object, which specifies additional information about the image in the metafile.'''
        raise NotImplementedError()
    
    @property
    def emf_pixel_format_buffer(self) -> List[int]:
        '''Gets an optional array of bytes that contains the EMF pixel format descriptor, which is not required to
        be contiguous with the fixed portion of the EmfMetafileHeaderExtension1 record or with the EMF
        description string. Accordingly, the field in this buffer that is labeled "UndefinedSpace" is
        optional and MUST be ignored'''
        raise NotImplementedError()
    
    @emf_pixel_format_buffer.setter
    def emf_pixel_format_buffer(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that contains the EMF pixel format descriptor, which is not required to
        be contiguous with the fixed portion of the EmfMetafileHeaderExtension1 record or with the EMF
        description string. Accordingly, the field in this buffer that is labeled "UndefinedSpace" is
        optional and MUST be ignored'''
        raise NotImplementedError()
    

class EmfMetafileHeaderExtension2(EmfMetafileHeaderExtension1):
    '''The EmfMetafileHeaderExtension2 record is the header record used in the second extension to EMF
    metafiles. Following the EmfHeaderExtension2 field, the remaining fields are optional and
    can be present in any order.'''
    
    @overload
    def __init__(self, header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_header(header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeader) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_header_extension1(header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension1) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_header_extension2(header : aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2) -> aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMetafileHeaderExtension2` class.
        
        :param header: The header.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def emf_header(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject:
        '''Gets a Header object (section 2.2.9), which contains information about the content
        and structure of the metafile'''
        raise NotImplementedError()
    
    @emf_header.setter
    def emf_header(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderObject) -> None:
        '''Sets a Header object (section 2.2.9), which contains information about the content
        and structure of the metafile'''
        raise NotImplementedError()
    
    @property
    def emf_header_record_buffer(self) -> List[int]:
        '''Gets an optional array of bytes that contains the remainder of the EMF header record.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @emf_header_record_buffer.setter
    def emf_header_record_buffer(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that contains the remainder of the EMF header record.
        The size of this field MUST be a multiple of 4 bytes'''
        raise NotImplementedError()
    
    @property
    def emf_description_buffer(self) -> List[int]:
        '''Gets the EMF description buffer
        An optional array of bytes that contains the EMF description string, which is
        not required to be contiguous with the fixed portion of the EmfMetafileHeader
        record. Accordingly, the field in this buffer that is labeled "UndefinedSpace"
        is optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @emf_description_buffer.setter
    def emf_description_buffer(self, value : List[int]) -> None:
        '''Sets the EMF description buffer
        An optional array of bytes that contains the EMF description string, which is
        not required to be contiguous with the fixed portion of the EmfMetafileHeader
        record. Accordingly, the field in this buffer that is labeled "UndefinedSpace"
        is optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def emf_description(self) -> str:
        '''Gets the EMF description
        An optional, null-terminated Unicode UTF16-LE string of arbitrary length and content.
        Its location in the record and number of characters are specified by the offDescription
        and nDescription fields, respectively, in EmfHeader. If the value of either field
        is zero, no description string is present.'''
        raise NotImplementedError()
    
    @emf_description.setter
    def emf_description(self, value : str) -> None:
        '''Sets the EMF description
        An optional, null-terminated Unicode UTF16-LE string of arbitrary length and content.
        Its location in the record and number of characters are specified by the offDescription
        and nDescription fields, respectively, in EmfHeader. If the value of either field
        is zero, no description string is present.'''
        raise NotImplementedError()
    
    @property
    def emf_header_extension1(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1:
        '''Gets a HeaderExtension1 object, which specifies additional information about the image in the metafile.'''
        raise NotImplementedError()
    
    @emf_header_extension1.setter
    def emf_header_extension1(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension1) -> None:
        '''Sets a HeaderExtension1 object, which specifies additional information about the image in the metafile.'''
        raise NotImplementedError()
    
    @property
    def emf_pixel_format_buffer(self) -> List[int]:
        '''Gets an optional array of bytes that contains the EMF pixel format descriptor, which is not required to
        be contiguous with the fixed portion of the EmfMetafileHeaderExtension1 record or with the EMF
        description string. Accordingly, the field in this buffer that is labeled "UndefinedSpace" is
        optional and MUST be ignored'''
        raise NotImplementedError()
    
    @emf_pixel_format_buffer.setter
    def emf_pixel_format_buffer(self, value : List[int]) -> None:
        '''Sets an optional array of bytes that contains the EMF pixel format descriptor, which is not required to
        be contiguous with the fixed portion of the EmfMetafileHeaderExtension1 record or with the EMF
        description string. Accordingly, the field in this buffer that is labeled "UndefinedSpace" is
        optional and MUST be ignored'''
        raise NotImplementedError()
    
    @property
    def emf_header_extension2(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension2:
        '''Gets a HeaderExtension2 object, which specifies additional information about the image in the metafile'''
        raise NotImplementedError()
    
    @emf_header_extension2.setter
    def emf_header_extension2(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfHeaderExtension2) -> None:
        '''Sets a HeaderExtension2 object, which specifies additional information about the image in the metafile'''
        raise NotImplementedError()
    

class EmfModifyWorldTransform(EmfTransformRecordType):
    '''The EMR_MODIFYWORLDTRANSFORM record modifies the current world-space to page-space
    transform in the playback device context.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfModifyWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfModifyWorldTransform` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def xform(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        raise NotImplementedError()
    
    @xform.setter
    def xform(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        raise NotImplementedError()
    
    @property
    def modify_world_transform_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfModifyWorldTransformMode:
        '''Gets a 32-bit unsigned integer that specifies how the
        transform specified in Xform is used. This value MUST be in the
        ModifyWorldTransformMode enumeration (section 2.1.24).'''
        raise NotImplementedError()
    
    @modify_world_transform_mode.setter
    def modify_world_transform_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfModifyWorldTransformMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies how the
        transform specified in Xform is used. This value MUST be in the
        ModifyWorldTransformMode enumeration (section 2.1.24).'''
        raise NotImplementedError()
    

class EmfMoveToEx(EmfRecord):
    '''The EMR_MOVETOEX record specifies coordinates of the new current position, in logical units.'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMoveToEx` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfMoveToEx` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def offset(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies coordinates of the new current position in logical units.'''
        raise NotImplementedError()
    
    @offset.setter
    def offset(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15,
        which specifies coordinates of the new current position in logical units.'''
        raise NotImplementedError()
    

class EmfNamedEscape(EmfEscapeRecordType):
    '''The MR_NAMEDESCAPE record passes arbitrary information to a specified printer driver.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfNamedEscape` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def escape(self) -> aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes:
        '''Gets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @escape.setter
    def escape(self, value : aspose.imaging.fileformats.wmf.consts.WmfMetafileEscapes) -> None:
        '''Sets a 32-bit unsigned integer that specifies the printer driver escape to
        execute. This MUST be one of the values in the WMF MetafileEscapes enumeration ([MSWMF] section 2.1.1.17).'''
        raise NotImplementedError()
    
    @property
    def cj_driver(self) -> int:
        '''Gets A 32-bit unsigned integer that specifies the number of bytes in the
        DriverName field. This value MUST be an even number.'''
        raise NotImplementedError()
    
    @cj_driver.setter
    def cj_driver(self, value : int) -> None:
        '''Sets A 32-bit unsigned integer that specifies the number of bytes in the
        DriverName field. This value MUST be an even number.'''
        raise NotImplementedError()
    
    @property
    def cj_in(self) -> int:
        '''Gets A 32-bit unsigned integer specifying the number of bytes to pass to the printer driver.'''
        raise NotImplementedError()
    
    @cj_in.setter
    def cj_in(self, value : int) -> None:
        '''Sets A 32-bit unsigned integer specifying the number of bytes to pass to the printer driver.'''
        raise NotImplementedError()
    
    @property
    def driver_name(self) -> str:
        '''Gets A string of 16-bit Unicode characters that specifies the name of the
        printer driver that will receive data. This value MUST be cjDriver bytes long, and it MUST be
        terminated with a null character.'''
        raise NotImplementedError()
    
    @driver_name.setter
    def driver_name(self, value : str) -> None:
        '''Sets A string of 16-bit Unicode characters that specifies the name of the
        printer driver that will receive data. This value MUST be cjDriver bytes long, and it MUST be
        terminated with a null character.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets The data to pass to the printer driver. There MUST be cjIn bytes available.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets The data to pass to the printer driver. There MUST be cjIn bytes available.'''
        raise NotImplementedError()
    

class EmfObjectCreationRecordType(EmfRecord):
    '''The object creation record types create graphics objects.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfObjectManipulationRecordType(EmfRecord):
    '''The object manipulation record types manage and modify graphics objects.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfOffsetClipRgn(EmfClippingRecordType):
    '''The EMR_OFFSETCLIPRGN record moves the current clipping region in the playback device context
    by the specified offsets.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfOffsetClipRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfOffsetClipRgn` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def offset(self) -> aspose.imaging.Point:
        '''Gets a WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        horizontal and vertical offsets in logical units.'''
        raise NotImplementedError()
    
    @offset.setter
    def offset(self, value : aspose.imaging.Point) -> None:
        '''Sets a WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        horizontal and vertical offsets in logical units.'''
        raise NotImplementedError()
    

class EmfOpenGlRecordType(EmfRecord):
    '''The OpenGL record types specify OpenGL functions.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfPaintRgn(EmfDrawingRecordType):
    '''The EMR_PAINTRGN record paints the specified region by using the brush currently selected into the
    playback device context.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPaintRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPaintRgn` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19,
        which specifies the bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def rgn_data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @rgn_data_size.setter
    def rgn_data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of region data, in bytes.'''
        raise NotImplementedError()
    
    @property
    def rgn_data(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfRegionData:
        '''Gets a RgnDataSize length array of bytes that specifies a RegionData (section
        2.2.24) object, in logical units.'''
        raise NotImplementedError()
    
    @rgn_data.setter
    def rgn_data(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfRegionData) -> None:
        '''Sets a RgnDataSize length array of bytes that specifies a RegionData (section
        2.2.24) object, in logical units.'''
        raise NotImplementedError()
    

class EmfPathBracketRecordType(EmfRecord):
    '''The path bracket record types specify and manipulate paths in path brackets.
    Note: None of the path bracket records specify parameters.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfPie(EmfDrawingRecordType):
    '''The EMR_PIE record specifies a pie-shaped wedge bounded by the intersection of an ellipse and two
    radials. The pie is outlined by using the current pen and filled by using the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPie` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPie` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive bounding rectangle.'''
        raise NotImplementedError()
    
    @property
    def start(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL objects, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the endpoint of the first radial.'''
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL objects, specified in [MS-WMF] section 2.2.2.15, which
        specifies the coordinates, in logical units, of the endpoint of the first radial.'''
        raise NotImplementedError()
    
    @property
    def end(self) -> aspose.imaging.Point:
        '''Gets a 64-bit PointL object that specifies the coordinates, in logical units, of the
        endpoint of the second radial.'''
        raise NotImplementedError()
    
    @end.setter
    def end(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit PointL object that specifies the coordinates, in logical units, of the
        endpoint of the second radial.'''
        raise NotImplementedError()
    

class EmfPixelFormat(EmfStateRecordType):
    '''The EMR_PIXELFORMAT record specifies the pixel format to use for graphics operations.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPixelFormat` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def pfd(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfPixelFormatDescriptor:
        '''Gets a PixelFormatDescriptor object (section 2.2.22) that specifies pixel format data.'''
        raise NotImplementedError()
    
    @pfd.setter
    def pfd(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfPixelFormatDescriptor) -> None:
        '''Sets a PixelFormatDescriptor object (section 2.2.22) that specifies pixel format data.'''
        raise NotImplementedError()
    

class EmfPlgBlt(EmfBitmapRecordType):
    '''The EMR_PLGBLT record specifies a block transfer of pixels from a source bitmap to a destination
    parallelogram, with the application of a color mask bitmap.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPlgBlt` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        bounding rectangle, in device units, for output to the destination.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        bounding rectangle, in device units, for output to the destination.'''
        raise NotImplementedError()
    
    @property
    def aptl_dest(self) -> List[aspose.imaging.Point]:
        '''Gets an array of three WMF PointL objects ([MS-WMF] section 2.2.2.15) that
        specifies three corners a parallelogram destination area for the block transfer.
        The upper-left corner of the source rectangle is mapped to the first point in this array, the
        upper-right corner to the second point, and the lower-left corner to the third point. The lower-right corner of the source rectangle is mapped to the implicit fourth point in the
        parallelogram, which is computed from the first three points (A, B, and C) by treating them as
        vectors.
        D = B + C A'''
        raise NotImplementedError()
    
    @aptl_dest.setter
    def aptl_dest(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of three WMF PointL objects ([MS-WMF] section 2.2.2.15) that
        specifies three corners a parallelogram destination area for the block transfer.
        The upper-left corner of the source rectangle is mapped to the first point in this array, the
        upper-right corner to the second point, and the lower-left corner to the third point. The lower-right corner of the source rectangle is mapped to the implicit fourth point in the
        parallelogram, which is computed from the first three points (A, B, and C) by treating them as
        vectors.
        D = B + C A'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the source rectangle.'''
        raise NotImplementedError()
    
    @cx_src.setter
    def cx_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the source rectangle.'''
        raise NotImplementedError()
    
    @cy_src.setter
    def cy_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def x_form_src(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @x_form_src.setter
    def x_form_src(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def bk_src_argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @bk_src_argb_32_color.setter
    def bk_src_argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration'''
        raise NotImplementedError()
    
    @property
    def x_mask(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @x_mask.setter
    def x_mask(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @property
    def y_mask(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @y_mask.setter
    def y_mask(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left corner of the mask bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_mask(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the mask bitmap header. This value MUST be in the DIBColors enumeration.'''
        raise NotImplementedError()
    
    @usage_mask.setter
    def usage_mask(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the mask bitmap header. This value MUST be in the DIBColors enumeration.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which are not
        required to be contiguous with the fixed portion of the EMR_PLGBLT record or with each other.
        Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which are not
        required to be contiguous with the fixed portion of the EMR_PLGBLT record or with each other.
        Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def mask_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the mask bitmap, which are not
        required to be contiguous with the fixed portion of the EMR_PLGBLT record or with each other.
        Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @mask_bitmap.setter
    def mask_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the mask bitmap, which are not
        required to be contiguous with the fixed portion of the EMR_PLGBLT record or with each other.
        Accordingly, fields in this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    

class EmfPolyBezier(EmfPolyShape):
    '''The EMR_POLYBEZIER record specifies one or more Bezier curves.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezier` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezier` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyBezier16(EmfPolyShape):
    '''The EMR_POLYBEZIER16 record specifies one or more Bezier curves. The curves are drawn using
    the current pen.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezier16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezier16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyBezierTo(EmfPolyShape):
    '''The EMR_POLYBEZIERTO record specifies one or more Bezier curves based upon the current position.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezierTo` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezierTo` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyBezierTo16(EmfPolyShape):
    '''The EMR_POLYBEZIERTO16 record specifies one or more Bezier curves based on the current position.'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezierTo16` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyBezierTo16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyDraw(EmfPolyShape):
    '''The EMR_POLYDRAW record specifies a set of line segments and Bezier curves.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyDraw` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyDraw` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @property
    def ab_types(self) -> List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]:
        '''Gets a Count length array of byte values that specifies how each point in the
        Gets aPoints array is used. This value MUST be in the Point (section 2.1.26) enumeration.'''
        raise NotImplementedError()
    
    @ab_types.setter
    def ab_types(self, value : List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]) -> None:
        '''Sets a Count length array of byte values that specifies how each point in the
        Sets aPoints array is used. This value MUST be in the Point (section 2.1.26) enumeration.'''
        raise NotImplementedError()
    

class EmfPolyDraw16(EmfPolyShape):
    '''The EMR_POLYDRAW16 record specifies a set of line segments and Bezier curves.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyDraw16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @property
    def ab_types(self) -> List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]:
        '''Gets a Count length array of bytes that specifies the point types. This value
        MUST be in the Point (section 2.1.26) enumeration.'''
        raise NotImplementedError()
    
    @ab_types.setter
    def ab_types(self, value : List[aspose.imaging.fileformats.emf.emf.consts.EmfPointEnum]) -> None:
        '''Sets a Count length array of bytes that specifies the point types. This value
        MUST be in the Point (section 2.1.26) enumeration.'''
        raise NotImplementedError()
    

class EmfPolyPolyShape(EmfBoundedRecord):
    '''base EMF poly polyshape class.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        '''Gets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]) -> None:
        '''Sets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    

class EmfPolyPolygon(EmfPolyPolyShape):
    '''The EMR_POLYPOLYGON record specifies a series of closed polygons.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolygon` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolygon` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        '''Gets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]) -> None:
        '''Sets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    

class EmfPolyPolygon16(EmfPolyPolyShape):
    '''The EMR_POLYPOLYGON16 record specifies a series of closed polygons. Each polygon is outlined
    using the current pen, and filled using the current brush and polygon fill mode. The polygons drawn
    by this record can overlap.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolygon16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolygon16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        '''Gets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]) -> None:
        '''Sets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    

class EmfPolyPolyline(EmfPolyPolyShape):
    '''The EMR_POLYPOLYLINE record specifies multiple series of connected line segments.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolyline` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolyline` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        '''Gets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]) -> None:
        '''Sets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    

class EmfPolyPolyline16(EmfPolyPolyShape):
    '''The EMR_POLYPOLYLINE16 record specifies multiple series of connected line segments.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolyline16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyPolyline16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[List[aspose.imaging.Point]]:
        '''Gets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[List[aspose.imaging.Point]]) -> None:
        '''Sets an array of WMF PointS objects, specified in [MS-WMF]
        section 2.2.2.16, which specifies the array of points.'''
        raise NotImplementedError()
    

class EmfPolyShape(EmfBoundedRecord):
    '''Base EMF polyshape class.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyTextOutA(EmfDrawingRecordType):
    '''The EMR_POLYTEXTOUTA record draws one or more ASCII text strings using the current font and text colors.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyTextOutA` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyTextOutA` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        '''Gets a 32-bit unsigned integer that specifies the current graphics mode,
        from the GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the current graphics mode,
        from the GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @property
    def ex_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the X scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ex_scale.setter
    def ex_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the X scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def ey_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the Y scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ey_scale.setter
    def ey_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the Y scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def a_emr_text(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfText]:
        '''Gets an array of EmrText objects (section 2.2.5) that specify the output
        strings in 8-bit ASCII characters, with text attributes, and spacing values. The number of
        EmrText objects is specified by cStrings.'''
        raise NotImplementedError()
    
    @a_emr_text.setter
    def a_emr_text(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfText]) -> None:
        '''Sets an array of EmrText objects (section 2.2.5) that specify the output
        strings in 8-bit ASCII characters, with text attributes, and spacing values. The number of
        EmrText objects is specified by cStrings.'''
        raise NotImplementedError()
    

class EmfPolyTextOutW(EmfDrawingRecordType):
    '''The EMR_POLYTEXTOUTW record draws one or more Unicode text strings using the current font and text colors.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyTextOutW` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyTextOutW` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19), which specifies the
        bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        '''Gets a 32-bit unsigned integer that specifies the current graphics mode,
        from the GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the current graphics mode,
        from the GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @property
    def ex_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the X scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ex_scale.setter
    def ex_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the X scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def ey_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the Y scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @ey_scale.setter
    def ey_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the Y scale from page units to
        .01mm units if graphics mode is GM_COMPATIBLE.'''
        raise NotImplementedError()
    
    @property
    def w_emr_text(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfText]:
        '''Gets an array of EmrText objects (section 2.2.5) that specify the output
        strings in 16-bit Unicode UTF16-LE characters, with text attributes and spacing values. The
        number of EmrText objects is specified by cStrings.'''
        raise NotImplementedError()
    
    @w_emr_text.setter
    def w_emr_text(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfText]) -> None:
        '''Sets an array of EmrText objects (section 2.2.5) that specify the output
        strings in 16-bit Unicode UTF16-LE characters, with text attributes and spacing values. The
        number of EmrText objects is specified by cStrings.'''
        raise NotImplementedError()
    

class EmfPolygon(EmfPolyShape):
    '''The EMR_POLYGON record specifies a polygon consisting of two or more vertexes connected by
    straight lines.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolygon` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolygon` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolygon16(EmfPolyShape):
    '''The EMR_POLYGON16 record specifies a polygon consisting of two or more vertexes connected by
    straight lines. The polygon is outlined by using the current pen and filled by using the current brush
    and polygon fill mode. The polygon is closed automatically by drawing a line from the last vertex to the first.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolygon16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolygon16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyline(EmfPolyShape):
    '''The EMR_POLYLINE record specifies a series of line segments by connecting the points in the
    specified array.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyline` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyline` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolyline16(EmfPolyShape):
    '''The EMR_POLYLINE16 record specifies a series of line segments by connecting the points in the
    specified array.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyline16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolyline16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolylineTo(EmfPolyShape):
    '''The EMR_POLYLINETO record specifies one or more straight lines based upon the current position.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolylineTo` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolylineTo` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfPolylineTo16(EmfPolyShape):
    '''The EMR_POLYLINETO16 record specifies one or more straight lines based upon the current position.
    A line is drawn from the current position to the first point specified by the aPoints field by using the
    current pen. For each additional line, drawing is performed from the ending point of the previous
    line to the next point specified by aPoints.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolylineTo16` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfPolylineTo16` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @property
    def a_points(self) -> List[aspose.imaging.Point]:
        '''Gets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    
    @a_points.setter
    def a_points(self, value : List[aspose.imaging.Point]) -> None:
        '''Sets an array of WMF PointL objects ([MS-WMF] section 2.2.2.15) that specifies the point data, in logical units.'''
        raise NotImplementedError()
    

class EmfRealizePalette(EmfStateRecordType):
    '''This record maps palette entries from the current
    LogPalette object (section 2.2.17) to the system_palette.
    This EMF record specifies no parameters.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRealizePalette` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfRecord(aspose.imaging.fileformats.emf.MetaObject):
    '''Base class for EMF records
    All EMF records MUST have a length that is a multiple of 4 bytes. This is depicted in the
    generic structures of the preceding EMF record types by including AlignmentPadding fields
    where appropriate at the ends of these structures. The contents of AlignmentPadding fields
    MUST always be ignored. For brevity, these fields are not shown in every individual EMF
    record definition.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfRectangle(EmfDrawingRecordType):
    '''The EMR_RECTANGLE record draws a rectangle. The rectangle is outlined by using the current pen
    and filled by using the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRectangle` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRectangle` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        raise NotImplementedError()
    

class EmfResizePalette(EmfObjectManipulationRecordType):
    '''The EMR_RESIZEPALETTE record increases or decreases the size of an existing LogPalette object (section 2.2.17).'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfResizePalette` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_pal(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the palette object in the
        EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    
    @ih_pal.setter
    def ih_pal(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the palette object in the
        EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    

class EmfRestoreDc(EmfStateRecordType):
    '''The EMR_RESTOREDC record restores the playback device context to the specified state. The
    playback device context is restored by popping state information off a stack that was created by
    prior EMR_SAVEDC records (section 2.3.11).'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRestoreDc` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRestoreDc` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def saved_dc(self) -> int:
        '''Gets a 32-bit signed integer that specifies the saved state to restore relative to
        the current state. This value MUST be negative; –1 represents the state that was most
        recently saved on the stack, –2 the one before that, etc.'''
        raise NotImplementedError()
    
    @saved_dc.setter
    def saved_dc(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the saved state to restore relative to
        the current state. This value MUST be negative; –1 represents the state that was most
        recently saved on the stack, –2 the one before that, etc.'''
        raise NotImplementedError()
    

class EmfRop4:
    '''A quaternary raster operation, which specifies ternary raster operations for
    the foreground and background colors of a bitmap. These values define how the color data of
    the source rectangle is to be combined with the color data of the destination rectangle.'''
    
    def __init__(self, dword_data : int) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRop4` class.
        
        :param dword_data: The dword data.'''
        raise NotImplementedError()
    
    @property
    def background_rop3(self) -> int:
        '''Gets the background ROP3.
        The unsigned, most-significant 8 bits of a 24-bit ternary
        raster operation value from the WMF Ternary Raster Operation enumeration ([MS-WMF] section 2.1.1.31). This code defines how to combine the background color data of
        the source and destination bitmaps and brush pattern.'''
        raise NotImplementedError()
    
    @property
    def foreground_rop3(self) -> int:
        '''Gets the foreground ROP3.
        The unsigned, most-significant 8 bits of a 24-bit ternary
        raster operation value from the WMF Ternary Raster Operation enumeration. This
        code defines how to combine the foreground color data of the source and destination
        bitmaps and brush pattern.'''
        raise NotImplementedError()
    

class EmfRoundRect(EmfDrawingRecordType):
    '''The EMR_ROUNDRECT record specifies a rectangle with rounded corners. The rectangle is outlined
    by using the current pen and filled by using the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRoundRect` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRoundRect` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def box(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        raise NotImplementedError()
    
    @box.setter
    def box(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object, specified in [MS-WMF] section 2.2.2.19, which
        specifies the inclusive-inclusive rectangle to draw.'''
        raise NotImplementedError()
    
    @property
    def corner(self) -> aspose.imaging.Size:
        '''Gets a 64-bit WMF SizeL object, specified in [MS-WMF] section 2.2.2.22, which
        specifies the width and height, in logical coordinates, of the ellipse used to draw the rounded corners.'''
        raise NotImplementedError()
    
    @corner.setter
    def corner(self, value : aspose.imaging.Size) -> None:
        '''Sets a 64-bit WMF SizeL object, specified in [MS-WMF] section 2.2.2.22, which
        specifies the width and height, in logical coordinates, of the ellipse used to draw the rounded corners.'''
        raise NotImplementedError()
    

class EmfSaveDc(EmfStateRecordType):
    '''Saves the current state of playback device context on a
    stack of states saved by preceding EMR_SAVEDC
    records, if any. The state consists of graphics properties
    and objects, including the currently selected bitmap,
    brush, palette, font, pen, and region. An
    EMR_RESTOREDC record is used to restore the state.
    This EMF record specifies no parameters.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSaveDc` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSaveDc` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfScaleViewportExtex(EmfStateRecordType):
    '''The EMR_SCALEVIEWPORTEXTEX record respecifies the viewport for a device context by using the
    ratios formed by the specified multiplicands and divisors.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfScaleViewportExtex` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfScaleViewportExtex` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def x_num(self) -> int:
        '''Gets a 32-bit signed integer that specifies the horizontal multiplicand. Cannot be zero.'''
        raise NotImplementedError()
    
    @x_num.setter
    def x_num(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the horizontal multiplicand. Cannot be zero.'''
        raise NotImplementedError()
    
    @property
    def x_denom(self) -> int:
        '''Gets a 32-bit signed integer that specifies the horizontal divisor. Cannot be zero.'''
        raise NotImplementedError()
    
    @x_denom.setter
    def x_denom(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the horizontal divisor. Cannot be zero.'''
        raise NotImplementedError()
    
    @property
    def y_num(self) -> int:
        '''Gets a 32-bit signed integer that specifies the vertical multiplicand. Cannot be zero.'''
        raise NotImplementedError()
    
    @y_num.setter
    def y_num(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the vertical multiplicand. Cannot be zero.'''
        raise NotImplementedError()
    
    @property
    def y_denom(self) -> int:
        '''Gets a 32-bit signed integer that specifies the vertical divisor. Cannot be zero.'''
        raise NotImplementedError()
    
    @y_denom.setter
    def y_denom(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the vertical divisor. Cannot be zero.'''
        raise NotImplementedError()
    

class EmfScaleWindowExtex(EmfStateRecordType):
    '''The EMR_SCALEWINDOWEXTEX record respecifies the window for a playback device context by
    using the ratios formed by the specified multiplicands and divisors.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfScaleWindowExtex` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfScaleWindowExtex` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def x_num(self) -> int:
        '''Gets a 32-bit signed integer that specifies the horizontal multiplicand. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @x_num.setter
    def x_num(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the horizontal multiplicand. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @property
    def x_denom(self) -> int:
        '''Gets a 32-bit signed integer that specifies the horizontal divisor. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @x_denom.setter
    def x_denom(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the horizontal divisor. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @property
    def y_num(self) -> int:
        '''Gets a 32-bit signed integer that specifies the vertical multiplicand. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @y_num.setter
    def y_num(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the vertical multiplicand. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @property
    def y_denom(self) -> int:
        '''Gets a 32-bit signed integer that specifies the vertical divisor. MUST NOT be zero.'''
        raise NotImplementedError()
    
    @y_denom.setter
    def y_denom(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the vertical divisor. MUST NOT be zero.'''
        raise NotImplementedError()
    

class EmfSelectClipPath(EmfClippingRecordType):
    '''The EMR_SELECTCLIPPATH record specifies the current path as a clipping region for a playback
    device context, combining the new region with any existing clipping region using the specified mode.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSelectClipPath` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSelectClipPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def region_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode:
        '''Gets a 32-bit unsigned integer that specifies the way to use the path. The
        value MUST be in the RegionMode enumeration (section 2.1.29).'''
        raise NotImplementedError()
    
    @region_mode.setter
    def region_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRegionMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the way to use the path. The
        value MUST be in the RegionMode enumeration (section 2.1.29).'''
        raise NotImplementedError()
    

class EmfSelectObject(EmfRecord):
    '''The EMR_SELECTOBJECT record adds a graphics object to the current metafile playback device
    context. The object is specified either by its index in the EMF Object Table(section 3.1.1.1) or by its
    value from the StockObject enumeration(section 2.1.31).'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSelectObject` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSelectObject` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def object_handle(self) -> int:
        '''Gets 32-bit unsigned integer that specifies either the index of a graphics object
        in the EMF Object Table or the index of a stock object from the :py:class:`aspose.imaging.fileformats.emf.emf.consts.EmfStockObject` enumeration.'''
        raise NotImplementedError()
    
    @object_handle.setter
    def object_handle(self, value : int) -> None:
        '''Sets 32-bit unsigned integer that specifies either the index of a graphics object
        in the EMF Object Table or the index of a stock object from the :py:class:`aspose.imaging.fileformats.emf.emf.consts.EmfStockObject` enumeration.'''
        raise NotImplementedError()
    

class EmfSelectPalette(EmfObjectManipulationRecordType):
    '''The EMR_SELECTPALETTE record specifies a logical palette for the playback device context.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSelectPalette` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_pal(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies either the index of a LogPalette object
        (section 2.2.17) in the EMF Object Table or the value DEFAULT_PALETTE, which is the index
        of a stock object palette from the StockObject enumeration (section 2.1.31).'''
        raise NotImplementedError()
    
    @ih_pal.setter
    def ih_pal(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies either the index of a LogPalette object
        (section 2.2.17) in the EMF Object Table or the value DEFAULT_PALETTE, which is the index
        of a stock object palette from the StockObject enumeration (section 2.1.31).'''
        raise NotImplementedError()
    

class EmfSetArcDirection(EmfStateRecordType):
    '''The EMR_SETARCDIRECTION record specifies the drawing direction to be used for arc and rectangle output.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetArcDirection` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetArcDirection` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def arc_direction(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfArcDirection:
        '''Gets a 32-bit unsigned integer that specifies the arc direction. The value
        MUST be in the ArcDirection enumeration (section 2.1.2).
        The default direction is counterclockwise.'''
        raise NotImplementedError()
    
    @arc_direction.setter
    def arc_direction(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfArcDirection) -> None:
        '''Sets a 32-bit unsigned integer that specifies the arc direction. The value
        MUST be in the ArcDirection enumeration (section 2.1.2).
        The default direction is counterclockwise.'''
        raise NotImplementedError()
    

class EmfSetBkColor(EmfStateRecordType):
    '''The EMR_SETBKCOLOR record specifies the background color.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetBkColor` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetBkColor` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def argb_32_color(self) -> int:
        '''Gets a 32-bit WMF ColorRef object, specified in [MS-WMF] section 2.2.2.8, which
        specifies the background color value.'''
        raise NotImplementedError()
    
    @argb_32_color.setter
    def argb_32_color(self, value : int) -> None:
        '''Sets a 32-bit WMF ColorRef object, specified in [MS-WMF] section 2.2.2.8, which
        specifies the background color value.'''
        raise NotImplementedError()
    

class EmfSetBkMode(EmfStateRecordType):
    '''The EMR_SETBKMODE record specifies the background mix mode of the playback device context.
    The background mix mode is used with text, hatched brushes, and pen styles that are not solid lines.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetBkMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetBkMode` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfBackgroundMode:
        '''Gets a 32-bit unsigned integer that specifies the background mode
        and MUST be in the BackgroundMode (section 2.1.4) enumeration.'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfBackgroundMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the background mode
        and MUST be in the BackgroundMode (section 2.1.4) enumeration.'''
        raise NotImplementedError()
    

class EmfSetBrushOrgEx(EmfStateRecordType):
    '''The EMR_SETBRUSHORGEX record specifies the origin of the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetBrushOrgEx` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetBrushOrgEx` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def origin(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the brush\'s horizontal and vertical origin in device units.'''
        raise NotImplementedError()
    
    @origin.setter
    def origin(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object, specified in [MS-WMF] section 2.2.2.15, which
        specifies the brush\'s horizontal and vertical origin in device units.'''
        raise NotImplementedError()
    

class EmfSetColorAdjustment(EmfStateRecordType):
    '''The EMR_SETCOLORADJUSTMENT record specifies color adjustment properties in the playback
    device context.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetColorAdjustment` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def color_adjustment(self) -> aspose.imaging.fileformats.emf.emf.objects.EmfColorAdjustment:
        '''Gets a ColorAdjustment object (section 2.2.2) that specifies color
        adjustment values.'''
        raise NotImplementedError()
    
    @color_adjustment.setter
    def color_adjustment(self, value : aspose.imaging.fileformats.emf.emf.objects.EmfColorAdjustment) -> None:
        '''Sets a ColorAdjustment object (section 2.2.2) that specifies color
        adjustment values.'''
        raise NotImplementedError()
    

class EmfSetColorSpace(EmfObjectManipulationRecordType):
    '''The EMR_SETCOLORSPACE record defines the current logical color space object for graphics operations.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetColorSpace` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_cs(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of a logical color space object
        in the EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    
    @ih_cs.setter
    def ih_cs(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of a logical color space object
        in the EMF Object Table (section 3.1.1.1).'''
        raise NotImplementedError()
    

class EmfSetDiBitsToDevice(EmfBitmapRecordType):
    '''The EMR_SETDIBITSTODEVICE record specifies a block transfer of pixels from specified scan lines of
    a source bitmap to a destination rectangle.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetDiBitsToDevice` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the x-coordinate in pixels of the lower-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the x-coordinate in pixels of the lower-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the y-coordinate in pixels of the lower-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the y-coordinate in pixels of the lower-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the width in pixels of the source rectangle.'''
        raise NotImplementedError()
    
    @cx_src.setter
    def cx_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the width in pixels of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the height in pixels of the source rectangle'''
        raise NotImplementedError()
    
    @cy_src.setter
    def cy_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the height in pixels of the source rectangle'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def start_scan(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the first scan line in the array.'''
        raise NotImplementedError()
    
    @start_scan.setter
    def start_scan(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the first scan line in the array.'''
        raise NotImplementedError()
    
    @property
    def c_scans(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of scan lines.'''
        raise NotImplementedError()
    
    @c_scans.setter
    def c_scans(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of scan lines.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_SETDIBITSTODEVICE record. Accordingly, fields
        in this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_SETDIBITSTODEVICE record. Accordingly, fields
        in this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    

class EmfSetIcmMode(EmfStateRecordType):
    '''The EMR_SETICMMODE record specifies the mode of Image Color Management (ICM) for graphics operations.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetIcmMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def icm_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfIcmMode:
        '''Gets a 32-bit unsigned integer that specifies whether to enable or disable ICM,
        from the ICMMode enumeration (section 2.1.18). This value is part of the state of the
        playback device context.'''
        raise NotImplementedError()
    
    @icm_mode.setter
    def icm_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfIcmMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies whether to enable or disable ICM,
        from the ICMMode enumeration (section 2.1.18). This value is part of the state of the
        playback device context.'''
        raise NotImplementedError()
    

class EmfSetIcmProfileA(EmfStateRecordType):
    '''The EMR_SETICMPROFILEA record specifies a color profile in a file with a name consisting of ASCII
    characters, for graphics output.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetIcmProfileA` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def dw_flags(self) -> int:
        '''Gets a 32-bit unsigned integer that contains color profile flags.'''
        raise NotImplementedError()
    
    @dw_flags.setter
    def dw_flags(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that contains color profile flags.'''
        raise NotImplementedError()
    
    @property
    def cb_name(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of bytes in the ASCII
        name of the desired color profile.'''
        raise NotImplementedError()
    
    @cb_name.setter
    def cb_name(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of bytes in the ASCII
        name of the desired color profile.'''
        raise NotImplementedError()
    
    @property
    def cb_data(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of the color profile data, if it
        is contained in the Data field.'''
        raise NotImplementedError()
    
    @cb_data.setter
    def cb_data(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of the color profile data, if it
        is contained in the Data field.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets an array of size (cbName + cbData) in bytes, which specifies the ASCII
        name and raw data of the desired color profile.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets an array of size (cbName + cbData) in bytes, which specifies the ASCII
        name and raw data of the desired color profile.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name'''
        raise NotImplementedError()
    
    @property
    def raw_data(self) -> List[int]:
        '''Gets the raw data'''
        raise NotImplementedError()
    

class EmfSetIcmProfileW(EmfStateRecordType):
    '''The EMR_SETICMPROFILEW record specifies a color profile in a file with a name consisting of
    Unicode characters, for graphics output.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetIcmProfileW` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def dw_flags(self) -> int:
        '''Gets a 32-bit unsigned integer that contains color profile flags.'''
        raise NotImplementedError()
    
    @dw_flags.setter
    def dw_flags(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that contains color profile flags.'''
        raise NotImplementedError()
    
    @property
    def cb_name(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of bytes in the Unicode
        UTF16-LE name of the desired color profile.'''
        raise NotImplementedError()
    
    @cb_name.setter
    def cb_name(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of bytes in the Unicode
        UTF16-LE name of the desired color profile.'''
        raise NotImplementedError()
    
    @property
    def cb_data(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size of color profile data, if attached.'''
        raise NotImplementedError()
    
    @cb_data.setter
    def cb_data(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size of color profile data, if attached.'''
        raise NotImplementedError()
    
    @property
    def data(self) -> List[int]:
        '''Gets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        raise NotImplementedError()
    
    @data.setter
    def data(self, value : List[int]) -> None:
        '''Sets an array of size (cbName + cbData) in bytes, which specifies the UTF16-LE
        name and raw data of the desired color profile.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name'''
        raise NotImplementedError()
    
    @property
    def raw_data(self) -> List[int]:
        '''Gets the raw data'''
        raise NotImplementedError()
    

class EmfSetLayout(EmfStateRecordType):
    '''The EMR_SETLAYOUT record specifies the order in which text and graphics are drawn.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetLayout` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def layout_mode(self) -> Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfSetLayout+LayoutModeEnum:
        '''Gets a 32-bit unsigned integer that specifies the layout mode'''
        raise NotImplementedError()
    
    @layout_mode.setter
    def layout_mode(self, value : Aspose.Imaging.FileFormats.Emf.Emf.Records.EmfSetLayout+LayoutModeEnum) -> None:
        '''Sets a 32-bit unsigned integer that specifies the layout mode'''
        raise NotImplementedError()
    

class EmfSetLinkedUfis(EmfStateRecordType):
    '''The EMR_SETLINKEDUFIS record sets the UniversalFontIds (section 2.2.27) of the linked fonts to
    use during character lookup.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetLinkedUfis` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ufis(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId]:
        '''Gets an array of uNumLinkedUFI elements of type UniversalFontId, which specifies
        the identifiers of the linked fonts.'''
        raise NotImplementedError()
    
    @ufis.setter
    def ufis(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfUniversalFontId]) -> None:
        '''Sets an array of uNumLinkedUFI elements of type UniversalFontId, which specifies
        the identifiers of the linked fonts.'''
        raise NotImplementedError()
    

class EmfSetMapMode(EmfRecord):
    '''The EMR_SETMAPMODE record specifies the mapping mode of the playback device context.
    The mapping mode specifies the unit of measure used to transform page space units
    into device space units, and also specifies the orientation of the device\'s x-axis and y-axis.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetMapMode` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetMapMode` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def map_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfMapMode:
        '''Gets the map mode.'''
        raise NotImplementedError()
    
    @map_mode.setter
    def map_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfMapMode) -> None:
        '''Sets the map mode.'''
        raise NotImplementedError()
    

class EmfSetMapperFlags(EmfStateRecordType):
    '''The EMR_SETMAPPERFLAGS record specifies parameters of the process of matching logical fonts to
    physical fonts, which is performed by the font mapper.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetMapperFlags` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies parameters of the font matching process.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies parameters of the font matching process.'''
        raise NotImplementedError()
    

class EmfSetMetaRgn(EmfClippingRecordType):
    '''Inter sets the current meta region with the current clipping region
    to form a new meta region for the playback device context. The
    current clipping region SHOULD be reset to null.
    This EMF record specifies no parameters.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetMetaRgn` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfSetMiterLimit(EmfStateRecordType):
    '''The EMR_SETMITERLIMIT record specifies the limit for the length of miter joins for the playback device context.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetMiterLimit` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetMiterLimit` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def miter_limit(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the new miter length limit.'''
        raise NotImplementedError()
    
    @miter_limit.setter
    def miter_limit(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the new miter length limit.'''
        raise NotImplementedError()
    

class EmfSetPaletteEntries(EmfObjectManipulationRecordType):
    '''The EMR_SETPALETTEENTRIES record defines RGB color values in a range of entries for an existing
    LogPalette (section 2.2.17) object.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetPaletteEntries` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def ih_pal(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the palette EMF Object Table index.'''
        raise NotImplementedError()
    
    @ih_pal.setter
    def ih_pal(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the palette EMF Object Table index.'''
        raise NotImplementedError()
    
    @property
    def start(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of the first entry to set.'''
        raise NotImplementedError()
    
    @start.setter
    def start(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of the first entry to set.'''
        raise NotImplementedError()
    
    @property
    def numberof_entries(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the number of entries.'''
        raise NotImplementedError()
    
    @numberof_entries.setter
    def numberof_entries(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the number of entries.'''
        raise NotImplementedError()
    
    @property
    def argb_32_pal_entries(self) -> List[int]:
        '''Gets an array of LogPaletteEntry (section 2.2.18) objects, of
        NumberOfEntries length, which specifies the palette entry data. The Values members do
        not contain any values.'''
        raise NotImplementedError()
    
    @argb_32_pal_entries.setter
    def argb_32_pal_entries(self, value : List[int]) -> None:
        '''Sets an array of LogPaletteEntry (section 2.2.18) objects, of
        NumberOfEntries length, which specifies the palette entry data. The Values members do
        not contain any values.'''
        raise NotImplementedError()
    

class EmfSetPixelV(EmfDrawingRecordType):
    '''The EMR_SETPIXELV record defines the color of the pixel at the specified logical coordinates.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetPixelV` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetPixelV` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def pixel(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        logical coordinates for the pixel.'''
        raise NotImplementedError()
    
    @pixel.setter
    def pixel(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        logical coordinates for the pixel.'''
        raise NotImplementedError()
    
    @property
    def argb_32_color(self) -> int:
        '''Gets a 32-bit WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies the pixel color.'''
        raise NotImplementedError()
    
    @argb_32_color.setter
    def argb_32_color(self, value : int) -> None:
        '''Sets a 32-bit WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies the pixel color.'''
        raise NotImplementedError()
    

class EmfSetPolyFillMode(EmfStateRecordType):
    '''The EMR_SETPOLYFILLMODE record defines polygon fill mode.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetPolyFillMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetPolyFillMode` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def polygon_fill_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfPolygonFillMode:
        '''Gets a 32-bit unsigned integer that specifies the polygon fill mode and
        MUST be in the PolygonFillMode (section 2.1.27) enumeration.'''
        raise NotImplementedError()
    
    @polygon_fill_mode.setter
    def polygon_fill_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfPolygonFillMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the polygon fill mode and
        MUST be in the PolygonFillMode (section 2.1.27) enumeration.'''
        raise NotImplementedError()
    

class EmfSetRop2(EmfStateRecordType):
    '''The EMR_SETROP2 record defines a binary raster operation mode.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetRop2` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetRop2` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def rop_2_mode(self) -> aspose.imaging.fileformats.wmf.consts.WmfBinaryRasterOperation:
        '''Gets a 32-bit unsigned integer that specifies the raster operation mode and
        MUST be in the WMF Binary Raster Op enumeration ([MS-WMF] section 2.1.1.2).'''
        raise NotImplementedError()
    
    @rop_2_mode.setter
    def rop_2_mode(self, value : aspose.imaging.fileformats.wmf.consts.WmfBinaryRasterOperation) -> None:
        '''Sets a 32-bit unsigned integer that specifies the raster operation mode and
        MUST be in the WMF Binary Raster Op enumeration ([MS-WMF] section 2.1.1.2).'''
        raise NotImplementedError()
    

class EmfSetStrechBltMode(EmfStateRecordType):
    '''The EMR_SETSTRETCHBLTMODE record specifies bitmap stretch mode.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetStrechBltMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def stretch_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfStretchMode:
        '''Gets a 32-bit unsigned integer that specifies the stretch mode and MAY be
        in the StretchMode enumeration.'''
        raise NotImplementedError()
    
    @stretch_mode.setter
    def stretch_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfStretchMode) -> None:
        '''Sets a 32-bit unsigned integer that specifies the stretch mode and MAY be
        in the StretchMode enumeration.'''
        raise NotImplementedError()
    

class EmfSetTextAlign(EmfStateRecordType):
    '''The EMR_SETTEXTALIGN record specifies text alignment.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetTextAlign` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetTextAlign` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def text_alignment_mode(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies text alignment by
        using a mask of text alignment flags. These are either :py:class:`aspose.imaging.fileformats.wmf.consts.WmfTextAlignmentModeFlags`
        ([MS-WMF] section 2.1.2.3) for text with a horizontal baseline, or :py:class:`aspose.imaging.fileformats.wmf.consts.WmfVerticalTextAlignmentModeFlags`
        ([MS-WMF] section 2.1.2.4) for text with a vertical
        baseline. Only one value can be chosen from those that affect horizontal and vertical
        alignment.'''
        raise NotImplementedError()
    
    @text_alignment_mode.setter
    def text_alignment_mode(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies text alignment by
        using a mask of text alignment flags. These are either :py:class:`aspose.imaging.fileformats.wmf.consts.WmfTextAlignmentModeFlags`
        ([MS-WMF] section 2.1.2.3) for text with a horizontal baseline, or :py:class:`aspose.imaging.fileformats.wmf.consts.WmfVerticalTextAlignmentModeFlags`
        ([MS-WMF] section 2.1.2.4) for text with a vertical
        baseline. Only one value can be chosen from those that affect horizontal and vertical
        alignment.'''
        raise NotImplementedError()
    

class EmfSetTextColor(EmfStateRecordType):
    '''The EMR_SETTEXTCOLOR record defines the current text color.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetTextColor` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetTextColor` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies the text color value.'''
        raise NotImplementedError()
    
    @argb_32_color.setter
    def argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies the text color value.'''
        raise NotImplementedError()
    

class EmfSetTextJustification(EmfStateRecordType):
    '''The EMR_SETTEXTJUSTIFICATION record specifies the amount of extra space to add to break
    characters for text justification.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetTextJustification` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def n_break_extra(self) -> int:
        '''Gets a 32-bit signed integer that specifies the total amount of extra space,
        in logical units, to add.'''
        raise NotImplementedError()
    
    @n_break_extra.setter
    def n_break_extra(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the total amount of extra space,
        in logical units, to add.'''
        raise NotImplementedError()
    
    @property
    def n_break_count(self) -> int:
        '''Gets a 32-bit signed integer that specifies the number of break characters.'''
        raise NotImplementedError()
    
    @n_break_count.setter
    def n_break_count(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the number of break characters.'''
        raise NotImplementedError()
    

class EmfSetViewportExtEx(EmfStateRecordType):
    '''The EMR_SETVIEWPORTEXTEX record defines the viewport extent.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetViewportExtEx` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetViewportExtEx` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def extent(self) -> aspose.imaging.Size:
        '''Gets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in device units.'''
        raise NotImplementedError()
    
    @extent.setter
    def extent(self, value : aspose.imaging.Size) -> None:
        '''Sets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in device units.'''
        raise NotImplementedError()
    

class EmfSetViewportOrgEx(EmfStateRecordType):
    '''The EMR_SETVIEWPORTORGEX record defines the viewport origin.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetViewportOrgEx` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetViewportOrgEx` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def origin(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in device units.'''
        raise NotImplementedError()
    
    @origin.setter
    def origin(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in device units.'''
        raise NotImplementedError()
    

class EmfSetWindowExtEx(EmfStateRecordType):
    '''The EMR_SETWINDOWEXTEX record defines the window extent.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetWindowExtEx` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetWindowExtEx` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def extent(self) -> aspose.imaging.Size:
        '''Gets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in logical units.'''
        raise NotImplementedError()
    
    @extent.setter
    def extent(self, value : aspose.imaging.Size) -> None:
        '''Sets a 64-bit WMF SizeL object ([MS-WMF] section 2.2.2.22) that specifies the
        horizontal and vertical extents in logical units.'''
        raise NotImplementedError()
    

class EmfSetWindowOrgEx(EmfStateRecordType):
    '''The EMR_SETWINDOWORGEX record defines the window origin.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetWindowOrgEx` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetWindowOrgEx` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def origin(self) -> aspose.imaging.Point:
        '''Gets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in logical units.'''
        raise NotImplementedError()
    
    @origin.setter
    def origin(self, value : aspose.imaging.Point) -> None:
        '''Sets a 64-bit WMF PointL object ([MS-WMF] section 2.2.2.15) that specifies the
        window horizontal and vertical origin in logical units.'''
        raise NotImplementedError()
    

class EmfSetWorldTransform(EmfTransformRecordType):
    '''The EMR_SETWORLDTRANSFORM record specifies a transform for the current world-space to page space transform in the playback device context.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSetWorldTransform` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def xform(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        raise NotImplementedError()
    
    @xform.setter
    def xform(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        raise NotImplementedError()
    

class EmfSmallTextOut(EmfDrawingRecordType):
    '''The EMR_SMALLTEXTOUT record outputs a string.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfSmallTextOut` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets a 32-bit signed integer specifying the x-coordinate of where to place the string.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets a 32-bit signed integer specifying the x-coordinate of where to place the string.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets a 32-bit signed integer specifying the y-coordinate of where to place the string.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets a 32-bit signed integer specifying the y-coordinate of where to place the string.'''
        raise NotImplementedError()
    
    @property
    def c_chars(self) -> int:
        '''Gets a 32-bit unsigned integer specifying the number of 16-bit characters in the
        string. The string is NOT null-terminated.'''
        raise NotImplementedError()
    
    @c_chars.setter
    def c_chars(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer specifying the number of 16-bit characters in the
        string. The string is NOT null-terminated.'''
        raise NotImplementedError()
    
    @property
    def fu_options(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfExtTextOutOptions:
        '''Gets a 32-bit unsigned integer specifying the text output options to use. These
        options are specified by one or a combination of values from the ExtTextOutOptions
        enumeration (section 2.1.11).'''
        raise NotImplementedError()
    
    @fu_options.setter
    def fu_options(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfExtTextOutOptions) -> None:
        '''Sets a 32-bit unsigned integer specifying the text output options to use. These
        options are specified by one or a combination of values from the ExtTextOutOptions
        enumeration (section 2.1.11).'''
        raise NotImplementedError()
    
    @property
    def graphics_mode(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode:
        '''Gets a 32-bit unsigned integer specifying the graphics mode, from the
        GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @graphics_mode.setter
    def graphics_mode(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfGraphicsMode) -> None:
        '''Sets a 32-bit unsigned integer specifying the graphics mode, from the
        GraphicsMode enumeration (section 2.1.16).'''
        raise NotImplementedError()
    
    @property
    def ex_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies how much to scale the text in the x-direction.'''
        raise NotImplementedError()
    
    @ex_scale.setter
    def ex_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies how much to scale the text in the x-direction.'''
        raise NotImplementedError()
    
    @property
    def ey_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies how much to scale the text in the y-direction.'''
        raise NotImplementedError()
    
    @ey_scale.setter
    def ey_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies how much to scale the text in the y-direction.'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets an optional, 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that
        specifies the bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets an optional, 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that
        specifies the bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def text_string(self) -> str:
        '''Gets a variable-length string that contains the text string to draw, in either
        8-bit or 16-bit character codes, according to the value of the fuOptions field.'''
        raise NotImplementedError()
    
    @text_string.setter
    def text_string(self, value : str) -> None:
        '''Sets a variable-length string that contains the text string to draw, in either
        8-bit or 16-bit character codes, according to the value of the fuOptions field.'''
        raise NotImplementedError()
    

class EmfStateRecordType(EmfRecord):
    '''The state record types specify and manage graphics properties that define the state of the playback device context.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

class EmfStretchBlt(EmfBitmapRecordType):
    '''The EMR_STRETCHBLT record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, optionally in combination with a brush pattern, according to a specified raster
    operation, stretching or compressing the output to fit the dimensions of the destination, if necessary.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStretchBlt` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStretchBlt` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @cx_dest.setter
    def cx_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @cy_dest.setter
    def cy_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def bit_blt_raster_operation(self) -> aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation:
        '''Gets a 32-bit unsigned integer that specifies the raster operation
        code. This code defines how the color data of the source rectangle is to be combined with the
        color data of the destination rectangle and optionally a brush pattern, to achieve the final color'''
        raise NotImplementedError()
    
    @bit_blt_raster_operation.setter
    def bit_blt_raster_operation(self, value : aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation) -> None:
        '''Sets a 32-bit unsigned integer that specifies the raster operation
        code. This code defines how the color data of the source rectangle is to be combined with the
        color data of the destination rectangle and optionally a brush pattern, to achieve the final color'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def argb_32_bk_color_src(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @argb_32_bk_color_src.setter
    def argb_32_bk_color_src(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8 that specifies the
        background color of the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def cx_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the source rectangle.'''
        raise NotImplementedError()
    
    @cx_src.setter
    def cx_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the source rectangle.'''
        raise NotImplementedError()
    
    @cy_src.setter
    def cy_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_STRETCHBLT record. Accordingly, fields in this
        buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_STRETCHBLT record. Accordingly, fields in this
        buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def src_rect(self) -> aspose.imaging.Rectangle:
        '''Gets the source rect.'''
        raise NotImplementedError()
    
    @src_rect.setter
    def src_rect(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets the source rect.'''
        raise NotImplementedError()
    
    @property
    def dest_rect(self) -> aspose.imaging.Rectangle:
        '''Gets the dest rect.'''
        raise NotImplementedError()
    
    @dest_rect.setter
    def dest_rect(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets the dest rect.'''
        raise NotImplementedError()
    

class EmfStretchDiBits(EmfBitmapRecordType):
    '''The EMR_STRETCHDIBITS record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, optionally in combination with a brush pattern, according to a specified raster
    operation, stretching or compressing the output to fit the dimensions of the destination, if necessary.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStretchDiBits` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the x-coordinate in pixels of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the x-coordinate in pixels of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the y-coordinate in pixels of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the y-coordinate in pixels of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the width in pixels of the source rectangle.'''
        raise NotImplementedError()
    
    @cx_src.setter
    def cx_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the width in pixels of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the height in pixels of the source rectangle.'''
        raise NotImplementedError()
    
    @cy_src.setter
    def cy_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the height in pixels of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9).'''
        raise NotImplementedError()
    
    @property
    def bit_blt_raster_operation(self) -> aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation:
        '''Gets a 32-bit unsigned integer that specifies a raster operation
        code. These codes define how the color data of the source rectangle is to be combined with
        the color data of the destination rectangle and optionally a brush pattern, to achieve the final color.'''
        raise NotImplementedError()
    
    @bit_blt_raster_operation.setter
    def bit_blt_raster_operation(self, value : aspose.imaging.fileformats.wmf.consts.WmfTernaryRasterOperation) -> None:
        '''Sets a 32-bit unsigned integer that specifies a raster operation
        code. These codes define how the color data of the source rectangle is to be combined with
        the color data of the destination rectangle and optionally a brush pattern, to achieve the final color.'''
        raise NotImplementedError()
    
    @property
    def cx_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @cx_dest.setter
    def cx_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @cy_dest.setter
    def cy_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_STRETCHDIBITS record. Accordingly, fields in
        this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_STRETCHDIBITS record. Accordingly, fields in
        this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    

class EmfStrokeAndFillPath(EmfDrawingRecordType):
    '''The EMR_STROKEANDFILLPATH record closes any open figures in a path, strokes the outline of the
    path by using the current pen, and fills its interior by using the current brush.'''
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStrokeAndFillPath` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStrokeAndFillPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies
        the bounding rectangle, in device units.'''
        raise NotImplementedError()
    

class EmfStrokePath(EmfDrawingRecordType):
    '''EMR_STROKEPATH class'''
    
    @overload
    def __init__(self, record : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStrokePath` class.
        
        :param record: The record.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfStrokePath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle in device units'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a 128-bit WMF RectL object ([MS-WMF] section 2.2.2.19) that specifies the bounding rectangle in device units'''
        raise NotImplementedError()
    

class EmfTransformRecordType(EmfRecord):
    '''The transform record types specify and modify world-space to page-space transforms.'''
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def xform(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        raise NotImplementedError()
    
    @xform.setter
    def xform(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28), which defines a world-space to page space transform.'''
        raise NotImplementedError()
    

class EmfTransparentBlt(EmfBitmapRecordType):
    '''The EMR_TRANSPARENTBLT record specifies a block transfer of pixels from a source bitmap to a
    destination rectangle, treating a specified color as transparent, stretching or compressing the output
    to fit the dimensions of the destination, if necessary'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfTransparentBlt` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    
    @property
    def bounds(self) -> aspose.imaging.Rectangle:
        '''Gets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @bounds.setter
    def bounds(self, value : aspose.imaging.Rectangle) -> None:
        '''Sets a WMF RectL object ([MS-WMF] section 2.2.2.19) that defines the
        destination bounding rectangle in device units.'''
        raise NotImplementedError()
    
    @property
    def x_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @x_dest.setter
    def x_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @y_dest.setter
    def y_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cx_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @cx_dest.setter
    def cx_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_dest(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @cy_dest.setter
    def cy_dest(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the destination rectangle.'''
        raise NotImplementedError()
    
    @property
    def transparent_argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies
        the color in the source bitmap to be treated as transparent.'''
        raise NotImplementedError()
    
    @transparent_argb_32_color.setter
    def transparent_argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object ([MS-WMF] section 2.2.2.8) that specifies
        the color in the source bitmap to be treated as transparent.'''
        raise NotImplementedError()
    
    @property
    def x_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @x_src.setter
    def x_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical x-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def y_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @y_src.setter
    def y_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical y-coordinate of the upper-left
        corner of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def xform_src(self) -> aspose.imaging.Matrix:
        '''Gets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @xform_src.setter
    def xform_src(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an XForm object (section 2.2.28) that specifies a world-space to page-space transform to apply to the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def src_bk_argb_32_color(self) -> int:
        '''Gets a WMF ColorRef object that specifies the background color of the source bitmap.'''
        raise NotImplementedError()
    
    @src_bk_argb_32_color.setter
    def src_bk_argb_32_color(self, value : int) -> None:
        '''Sets a WMF ColorRef object that specifies the background color of the source bitmap.'''
        raise NotImplementedError()
    
    @property
    def usage_src(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfDibColors:
        '''Gets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9)'''
        raise NotImplementedError()
    
    @usage_src.setter
    def usage_src(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfDibColors) -> None:
        '''Sets a 32-bit unsigned integer that specifies how to interpret values in the
        color table in the source bitmap header. This value MUST be in the DIBColors enumeration (section 2.1.9)'''
        raise NotImplementedError()
    
    @property
    def cx_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical width of the source rectangle.'''
        raise NotImplementedError()
    
    @cx_src.setter
    def cx_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical width of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def cy_src(self) -> int:
        '''Gets a 32-bit signed integer that specifies the logical height of the source rectangle.'''
        raise NotImplementedError()
    
    @cy_src.setter
    def cy_src(self, value : int) -> None:
        '''Sets a 32-bit signed integer that specifies the logical height of the source rectangle.'''
        raise NotImplementedError()
    
    @property
    def source_bitmap(self) -> aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap:
        '''Gets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_TRANSPARENTBLT record. Accordingly, fields in
        this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    
    @source_bitmap.setter
    def source_bitmap(self, value : aspose.imaging.fileformats.wmf.objects.WmfDeviceIndependentBitmap) -> None:
        '''Sets a buffer containing the source bitmap, which is not required to be
        contiguous with the fixed portion of the EMR_TRANSPARENTBLT record. Accordingly, fields in
        this buffer that are labeled "UndefinedSpace" are optional and MUST be ignored.'''
        raise NotImplementedError()
    

class EmfVertexData:
    '''Objects that specify the vertexes of either rectangles or triangles and
    the colors that correspond to them.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def vertex_objects(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfTriVertex]:
        '''Gets an array of nVer TriVertex objects (section 2.2.26). Each
        object specifies the position and color of a vertex of either a rectangle or a triangle,
        depending on the value of the ulMode field.'''
        raise NotImplementedError()
    
    @vertex_objects.setter
    def vertex_objects(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfTriVertex]) -> None:
        '''Sets an array of nVer TriVertex objects (section 2.2.26). Each
        object specifies the position and color of a vertex of either a rectangle or a triangle,
        depending on the value of the ulMode field.'''
        raise NotImplementedError()
    
    @property
    def vertex_indexes(self) -> List[aspose.imaging.fileformats.emf.emf.objects.EmfGradientRectangle]:
        '''Gets an array of nTri GradientRectangle objects (section 2.2.7) or
        GradientTriangle objects (section 2.2.8), depending on the value of the ulMode field.
        Each object specifies indexes into the array of TriVertex objects in the VertexObjects field.'''
        raise NotImplementedError()
    
    @vertex_indexes.setter
    def vertex_indexes(self, value : List[aspose.imaging.fileformats.emf.emf.objects.EmfGradientRectangle]) -> None:
        '''Sets an array of nTri GradientRectangle objects (section 2.2.7) or
        GradientTriangle objects (section 2.2.8), depending on the value of the ulMode field.
        Each object specifies indexes into the array of TriVertex objects in the VertexObjects field.'''
        raise NotImplementedError()
    
    @property
    def vertex_padding(self) -> List[int]:
        '''Gets an optional variable-length array of nTri times four bytes
        that MUST be present if the value of the ulMode field indicates GradientRectangle
        objects (section 2.2.7). If the value of the ulMode field indicates GradientTriangle
        objects (section 2.2.8), no VertexPadding is present. This field MUST be ignored.'''
        raise NotImplementedError()
    
    @vertex_padding.setter
    def vertex_padding(self, value : List[int]) -> None:
        '''Sets an optional variable-length array of nTri times four bytes
        that MUST be present if the value of the ulMode field indicates GradientRectangle
        objects (section 2.2.7). If the value of the ulMode field indicates GradientTriangle
        objects (section 2.2.8), no VertexPadding is present. This field MUST be ignored.'''
        raise NotImplementedError()
    

class EmfWidenPath(EmfPathBracketRecordType):
    '''This record redefines the current path as the area that would be painted if the path
    were drawn using the pen currently selected into the playback device context.'''
    
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfWidenPath` class.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_record(source : aspose.imaging.fileformats.emf.emf.records.EmfRecord) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @staticmethod
    def create_from_type(type : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> aspose.imaging.fileformats.emf.emf.records.EmfRecord:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emf.records.EmfRecord` class.
        
        :param type: The record type.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emf.consts.EmfRecordType:
        '''Gets the type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.imaging.fileformats.emf.emf.consts.EmfRecordType) -> None:
        '''Sets the type.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size of the record'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size of the record'''
        raise NotImplementedError()
    

