"""The namespace contains types [MS-EMFPLUS]: Enhanced Metafile Format Plus Extensions
            2.3 EMF+ Records"""
from typing import List, Optional, Dict, Iterable, Any, overload
import enum
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.imaging
import aspose.imaging.apsbuilder
import aspose.imaging.apsbuilder.dib
import aspose.imaging.asynctask
import aspose.imaging.brushes
import aspose.imaging.dithering
import aspose.imaging.exif
import aspose.imaging.exif.enums
import aspose.imaging.extensions
import aspose.imaging.fileformats
import aspose.imaging.fileformats.apng
import aspose.imaging.fileformats.avif
import aspose.imaging.fileformats.bigtiff
import aspose.imaging.fileformats.bmp
import aspose.imaging.fileformats.bmp.structures
import aspose.imaging.fileformats.cdr
import aspose.imaging.fileformats.cdr.const
import aspose.imaging.fileformats.cdr.enum
import aspose.imaging.fileformats.cdr.objects
import aspose.imaging.fileformats.cdr.types
import aspose.imaging.fileformats.cmx
import aspose.imaging.fileformats.cmx.objectmodel
import aspose.imaging.fileformats.cmx.objectmodel.enums
import aspose.imaging.fileformats.cmx.objectmodel.specs
import aspose.imaging.fileformats.cmx.objectmodel.styles
import aspose.imaging.fileformats.core
import aspose.imaging.fileformats.core.vectorpaths
import aspose.imaging.fileformats.dicom
import aspose.imaging.fileformats.djvu
import aspose.imaging.fileformats.dng
import aspose.imaging.fileformats.dng.decoder
import aspose.imaging.fileformats.emf
import aspose.imaging.fileformats.emf.dtyp
import aspose.imaging.fileformats.emf.dtyp.commondatastructures
import aspose.imaging.fileformats.emf.emf
import aspose.imaging.fileformats.emf.emf.consts
import aspose.imaging.fileformats.emf.emf.objects
import aspose.imaging.fileformats.emf.emf.records
import aspose.imaging.fileformats.emf.emfplus
import aspose.imaging.fileformats.emf.emfplus.consts
import aspose.imaging.fileformats.emf.emfplus.objects
import aspose.imaging.fileformats.emf.emfplus.records
import aspose.imaging.fileformats.emf.emfspool
import aspose.imaging.fileformats.emf.emfspool.records
import aspose.imaging.fileformats.emf.graphics
import aspose.imaging.fileformats.eps
import aspose.imaging.fileformats.eps.consts
import aspose.imaging.fileformats.gif
import aspose.imaging.fileformats.gif.blocks
import aspose.imaging.fileformats.ico
import aspose.imaging.fileformats.jpeg
import aspose.imaging.fileformats.jpeg2000
import aspose.imaging.fileformats.opendocument
import aspose.imaging.fileformats.opendocument.enums
import aspose.imaging.fileformats.opendocument.objects
import aspose.imaging.fileformats.opendocument.objects.brush
import aspose.imaging.fileformats.opendocument.objects.font
import aspose.imaging.fileformats.opendocument.objects.graphic
import aspose.imaging.fileformats.opendocument.objects.pen
import aspose.imaging.fileformats.pdf
import aspose.imaging.fileformats.png
import aspose.imaging.fileformats.psd
import aspose.imaging.fileformats.svg
import aspose.imaging.fileformats.svg.graphics
import aspose.imaging.fileformats.tga
import aspose.imaging.fileformats.tiff
import aspose.imaging.fileformats.tiff.enums
import aspose.imaging.fileformats.tiff.filemanagement
import aspose.imaging.fileformats.tiff.filemanagement.bigtiff
import aspose.imaging.fileformats.tiff.instancefactory
import aspose.imaging.fileformats.tiff.pathresources
import aspose.imaging.fileformats.tiff.tifftagtypes
import aspose.imaging.fileformats.webp
import aspose.imaging.fileformats.wmf
import aspose.imaging.fileformats.wmf.consts
import aspose.imaging.fileformats.wmf.graphics
import aspose.imaging.fileformats.wmf.objects
import aspose.imaging.fileformats.wmf.objects.escaperecords
import aspose.imaging.imagefilters
import aspose.imaging.imagefilters.complexutils
import aspose.imaging.imagefilters.convolution
import aspose.imaging.imagefilters.filteroptions
import aspose.imaging.imageloadoptions
import aspose.imaging.imageoptions
import aspose.imaging.interfaces
import aspose.imaging.magicwand
import aspose.imaging.magicwand.imagemasks
import aspose.imaging.masking
import aspose.imaging.masking.options
import aspose.imaging.masking.result
import aspose.imaging.memorymanagement
import aspose.imaging.metadata
import aspose.imaging.multithreading
import aspose.imaging.palettehelper
import aspose.imaging.progressmanagement
import aspose.imaging.shapes
import aspose.imaging.shapesegments
import aspose.imaging.sources
import aspose.imaging.watermark
import aspose.imaging.watermark.options
import aspose.imaging.xmp
import aspose.imaging.xmp.schemas
import aspose.imaging.xmp.schemas.dicom
import aspose.imaging.xmp.schemas.dublincore
import aspose.imaging.xmp.schemas.pdf
import aspose.imaging.xmp.schemas.photoshop
import aspose.imaging.xmp.schemas.xmpbaseschema
import aspose.imaging.xmp.schemas.xmpdm
import aspose.imaging.xmp.schemas.xmpmm
import aspose.imaging.xmp.schemas.xmprm
import aspose.imaging.xmp.types
import aspose.imaging.xmp.types.basic
import aspose.imaging.xmp.types.complex
import aspose.imaging.xmp.types.complex.colorant
import aspose.imaging.xmp.types.complex.dimensions
import aspose.imaging.xmp.types.complex.font
import aspose.imaging.xmp.types.complex.resourceevent
import aspose.imaging.xmp.types.complex.resourceref
import aspose.imaging.xmp.types.complex.thumbnail
import aspose.imaging.xmp.types.complex.version
import aspose.imaging.xmp.types.derived

class EmfPlusBeginContainer(EmfPlusStateRecordType):
    '''The EmfPlusBeginContainer record opens a new graphics state container and specifies a transform for it.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusBeginContainer` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def page_unit(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusUnitType:
        '''Gets the page unit.'''
        raise NotImplementedError()
    
    @property
    def dest_rect(self) -> aspose.imaging.RectangleF:
        '''Gets an EmfPlusRectF object (section 2.2.2.39) that, with SrcRect, specifies
        a transform for the container. This transformation results in SrcRect when applied to DestRect.'''
        raise NotImplementedError()
    
    @dest_rect.setter
    def dest_rect(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets an EmfPlusRectF object (section 2.2.2.39) that, with SrcRect, specifies
        a transform for the container. This transformation results in SrcRect when applied to DestRect.'''
        raise NotImplementedError()
    
    @property
    def src_rect(self) -> aspose.imaging.RectangleF:
        '''Gets an EmfPlusRectF rectangle that, with DestRect, specifies a transformation
        for the container. This transformation results in SrcRect when applied to DestRect.'''
        raise NotImplementedError()
    
    @src_rect.setter
    def src_rect(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets an EmfPlusRectF rectangle that, with DestRect, specifies a transformation
        for the container. This transformation results in SrcRect when applied to DestRect.'''
        raise NotImplementedError()
    
    @property
    def stack_index(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies an index to associate with the
        graphics state container. The index MUST be referenced by a subsequent
        EmfPlusEndContainer record (section 2.3.7.3) to close the graphics state container.'''
        raise NotImplementedError()
    
    @stack_index.setter
    def stack_index(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies an index to associate with the
        graphics state container. The index MUST be referenced by a subsequent
        EmfPlusEndContainer record (section 2.3.7.3) to close the graphics state container.'''
        raise NotImplementedError()
    

class EmfPlusBeginContainerNoParams(EmfPlusStateRecordType):
    '''The EmfPlusBeginContainerNoParams record opens a new graphics state container.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusBeginContainerNoParams` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def stack_index(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies an index to associate with the
        graphics state container. The index MUST be referenced by a subsequent
        EmfPlusEndContainer record (section 2.3.7.3) to close the graphics state container.'''
        raise NotImplementedError()
    
    @stack_index.setter
    def stack_index(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies an index to associate with the
        graphics state container. The index MUST be referenced by a subsequent
        EmfPlusEndContainer record (section 2.3.7.3) to close the graphics state container.'''
        raise NotImplementedError()
    

class EmfPlusClear(EmfPlusDrawingRecordType):
    '''The EmfPlusClear record clears the output coordinate space and initializes it with a background color and transparency'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusClear` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def argb_32_color(self) -> int:
        '''Gets the color.
        An EmfPlusARGB object (section 2.2.2.1) that defines the color to paint the screen. All colors are specified in [IEC-RGB], unless otherwise noted.'''
        raise NotImplementedError()
    
    @argb_32_color.setter
    def argb_32_color(self, value : int) -> None:
        '''Sets the color.
        An EmfPlusARGB object (section 2.2.2.1) that defines the color to paint the screen. All colors are specified in [IEC-RGB], unless otherwise noted.'''
        raise NotImplementedError()
    

class EmfPlusClippingRecordType(EmfPlusRecord):
    '''The clipping record types specify clipping regions and operations.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusComment(EmfPlusRecord):
    '''The EmfPlusComment record specifies arbitrary private data.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusComment` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def private_data(self) -> List[int]:
        '''Gets a DataSize-length byte array of private data.
        bytes of record-specific data that follows.'''
        raise NotImplementedError()
    
    @private_data.setter
    def private_data(self, value : List[int]) -> None:
        '''Sets a DataSize-length byte array of private data.
        bytes of record-specific data that follows.'''
        raise NotImplementedError()
    

class EmfPlusControlRecordType(EmfPlusRecord):
    '''The control record types specify global parameters for EMF+ metafile processing.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusDrawArc(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawArc record specifies drawing the arc of an ellipse.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawArc` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets the size.
        A 32-bit unsigned integer that specifies the 32-bit-aligned number of
        bytes in the entire record, including the 12-byte record header and
        record-specific data. For this record type, the value MUST be one of the following:
        0x0000001C  If the C bit is set in the Flags field.
        0x00000024  If the C bit is clear in the Flags field'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets the size.
        A 32-bit unsigned integer that specifies the 32-bit-aligned number of
        bytes in the entire record, including the 12-byte record header and
        record-specific data. For this record type, the value MUST be one of the following:
        0x0000001C  If the C bit is set in the Flags field.
        0x00000024  If the C bit is clear in the Flags field'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets the size of the data.
        A 32-bit unsigned integer that specifies the 32-bit-aligned number of
        bytes of record-specific data that follows.
        For this record type, the value MUST be one of the following:
        0x00000010 If the C bit is set in the Flags field.
        0x00000018 If the C bit is clear in the Flags field.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets the size of the data.
        A 32-bit unsigned integer that specifies the 32-bit-aligned number of
        bytes of record-specific data that follows.
        For this record type, the value MUST be one of the following:
        0x00000010 If the C bit is set in the Flags field.
        0x00000018 If the C bit is clear in the Flags field.'''
        raise NotImplementedError()
    
    @property
    def rect_float(self) -> bool:
        '''Gets a value indicating whether the data contains
        EmfPlusRectF or EmfPlusRect records
        This bit indicates whether the data in the RectData field is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @rect_float.setter
    def rect_float(self, value : bool) -> None:
        '''Sets a value indicating whether the data contains
        EmfPlusRectF or EmfPlusRect records
        This bit indicates whether the data in the RectData field is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the
        EMF+ Object Table to draw the arc. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the
        EMF+ Object Table to draw the arc. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def start_angle(self) -> float:
        '''Gets the start angle
        A 32-bit non-negative floating-point value that specifies the angle between
        the x-axis and the starting point of the arc. Any value is acceptable,
        but it MUST be interpreted modulo 360, with the result that is used being
        in the range 0.0 inclusive to 360.0 exclusive.'''
        raise NotImplementedError()
    
    @start_angle.setter
    def start_angle(self, value : float) -> None:
        '''Sets the start angle
        A 32-bit non-negative floating-point value that specifies the angle between
        the x-axis and the starting point of the arc. Any value is acceptable,
        but it MUST be interpreted modulo 360, with the result that is used being
        in the range 0.0 inclusive to 360.0 exclusive.'''
        raise NotImplementedError()
    
    @property
    def sweep_angle(self) -> float:
        '''Gets the sweep angle
        A 32-bit floating-point value that specifies the extent of the arc to draw,
        as an angle in degrees measured from the starting point defined by the
        StartAngle value. Any value is acceptable, but it MUST be clamped to -360.0
        to 360.0 inclusive. A positive value indicates that the sweep is defined in
        a clockwise direction, and a negative value indicates that the sweep is
        defined in a counter-clockwise direction.'''
        raise NotImplementedError()
    
    @sweep_angle.setter
    def sweep_angle(self, value : float) -> None:
        '''Sets the sweep angle
        A 32-bit floating-point value that specifies the extent of the arc to draw,
        as an angle in degrees measured from the starting point defined by the
        StartAngle value. Any value is acceptable, but it MUST be clamped to -360.0
        to 360.0 inclusive. A positive value indicates that the sweep is defined in
        a clockwise direction, and a negative value indicates that the sweep is
        defined in a counter-clockwise direction.'''
        raise NotImplementedError()
    
    @property
    def rectangle_data(self) -> aspose.imaging.RectangleF:
        '''Gets the rectangle data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box
        of the ellipse that is collinear with the arc. This rectangle defines the
        position, size, and shape of the arc. The type of object in this field is
        specified by the value of the Flags field.'''
        raise NotImplementedError()
    
    @rectangle_data.setter
    def rectangle_data(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the rectangle data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box
        of the ellipse that is collinear with the arc. This rectangle defines the
        position, size, and shape of the arc. The type of object in this field is
        specified by the value of the Flags field.'''
        raise NotImplementedError()
    

class EmfPlusDrawBeziers(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawBeziers record specifies drawing a sequence of connected Bezier curves.
    The order for Bezier data points is the start point, control point 1,
    control point 2 and end point. For more information see [MSDN-DrawBeziers].'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawBeziers` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        If set, PointData specifies absolute locations in the coordinate space with
        16-bit integer coordinates. If clear, PointData specifies absolute locations
        in the coordinate space with 32-bit floating-point coordinates.
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        If set, PointData specifies absolute locations in the coordinate space with
        16-bit integer coordinates. If clear, PointData specifies absolute locations
        in the coordinate space with 32-bit floating-point coordinates.
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def relative(self) -> bool:
        '''Gets a value indicating whether the PointData is relative.
        If set, each element in PointData specifies a location in the coordinate space
        that is relative to the location specified by the previous element in the array.
        In the case of the first element in PointData, a previous location at coordinates
        (0,0) is assumed. If clear, PointData specifies absolute locations according
        to the C flag.
        Note If this flag is set, the C flag (above) is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @relative.setter
    def relative(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is relative.
        If set, each element in PointData specifies a location in the coordinate space
        that is relative to the location specified by the previous element in the array.
        In the case of the first element in PointData, a previous location at coordinates
        (0,0) is assumed. If clear, PointData specifies absolute locations according
        to the C flag.
        Note If this flag is set, the C flag (above) is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the Bezier curves. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the Bezier curves. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets the point data
        An array of Count points that specify the starting, ending, and control points of the Bezier curves. The ending coordinate of one Bezier curve is the starting coordinate of the next. The control points are used for producing the Bezier effect.
        The type of data in this array is specified by the Flags field, as follows: Data Type Meaning
        EmfPlusPointR object (section 2.2.2.37)
        If the P flag is set in the Flags, the points specify relative locations.
        EmfPlusPointF object (section 2.2.2.36)
        If the P and C bits are clear in the Flags field, the points specify absolute locations.
        EmfPlusPoint object (section 2.2.2.35)
        If the P bit is clear and the C bit is set in the Flags field, the points specify relative locations.
        A Bezier curve does not pass through its control points. The control points act as'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets the point data
        An array of Count points that specify the starting, ending, and control points of the Bezier curves. The ending coordinate of one Bezier curve is the starting coordinate of the next. The control points are used for producing the Bezier effect.
        The type of data in this array is specified by the Flags field, as follows: Data Type Meaning
        EmfPlusPointR object (section 2.2.2.37)
        If the P flag is set in the Flags, the points specify relative locations.
        EmfPlusPointF object (section 2.2.2.36)
        If the P and C bits are clear in the Flags field, the points specify absolute locations.
        EmfPlusPoint object (section 2.2.2.35)
        If the P bit is clear and the C bit is set in the Flags field, the points specify relative locations.
        A Bezier curve does not pass through its control points. The control points act as'''
        raise NotImplementedError()
    

class EmfPlusDrawClosedCurve(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawClosedCurve record specifies drawing a closed cardinal spline'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` class.
        RecordType - A 16-bit unsigned integer that identifies this record type as EmfPlusDrawClosedCurve
        from the RecordType enumeration (section 2.1.1.1). The value MUST be 0x4017.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the closed curve. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the closed curve. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer coordinates.
        If clear, PointData specifies absolute locations in the coordinate space with 32-bit floating-point coordinates
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer coordinates.
        If clear, PointData specifies absolute locations in the coordinate space with 32-bit floating-point coordinates
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @property
    def relative(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is relative
        to the location specified by the previous element in the array. In the case of the first
        element in PointData, a previous location at coordinates (0,0) is assumed. If clear,
        PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the Compressed flag (above) is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @relative.setter
    def relative(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is relative
        to the location specified by the previous element in the array. In the case of the first
        element in PointData, a previous location at coordinates (0,0) is assumed. If clear,
        PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the Compressed flag (above) is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @property
    def tension(self) -> float:
        '''Gets the tension
        A 32-bit floating point number that specifies how tightly the spline
        bends as it passes through the points. A value of 0 specifies that
        the spline is a sequence of straight lines. As the value increases,
        the curve becomes more rounded. For more information, see [SPLINE77] and [PETZOLD].'''
        raise NotImplementedError()
    
    @tension.setter
    def tension(self, value : float) -> None:
        '''Sets the tension
        A 32-bit floating point number that specifies how tightly the spline
        bends as it passes through the points. A value of 0 specifies that
        the spline is a sequence of straight lines. As the value increases,
        the curve becomes more rounded. For more information, see [SPLINE77] and [PETZOLD].'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets the point data
        An array of Count points that specify the endpoints of the lines that define the spline. In a closed cardinal spline,
        the curve continues through the last point in the PointData array and connects with the first point in the array.
        The type of data in this array is specified by the Flags field, as follows: Data Type Meaning
        EmfPlusPointR object (section 2.2.2.37)
        If the P flag is set in the Flags, the points specify relative locations.
        EmfPlusPointF object (section 2.2.2.36)
        If the P and C bits are set in the Flags field, the points specify absolute locations.
        EmfPlusPoint object (section 2.2.2.35)
        If the P bit is clear and the C bit is set in the Flags field, the points specify relative locations.'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets the point data
        An array of Count points that specify the endpoints of the lines that define the spline. In a closed cardinal spline,
        the curve continues through the last point in the PointData array and connects with the first point in the array.
        The type of data in this array is specified by the Flags field, as follows: Data Type Meaning
        EmfPlusPointR object (section 2.2.2.37)
        If the P flag is set in the Flags, the points specify relative locations.
        EmfPlusPointF object (section 2.2.2.36)
        If the P and C bits are set in the Flags field, the points specify absolute locations.
        EmfPlusPoint object (section 2.2.2.35)
        If the P bit is clear and the C bit is set in the Flags field, the points specify relative locations.'''
        raise NotImplementedError()
    

class EmfPlusDrawCurve(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawCurve record specifies drawing a cardinal spline
    NOTE: ObjectID (1 byte): The index of an EmfPlusPen object (section 2.2.1.7)
    in the EMF+ Object Table to draw the curve. The value MUST be zero to 63, inclusive.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawCurve` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer coordinates.
        If clear, PointData specifies absolute locations in the coordinate space with 32-bit floating-point coordinates
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer coordinates.
        If clear, PointData specifies absolute locations in the coordinate space with 32-bit floating-point coordinates
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the curve. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the curve. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def tension(self) -> float:
        '''Gets the tension
        A 32-bit floating point number that specifies how tightly the spline
        bends as it passes through the points. A value of 0 specifies that
        the spline is a sequence of straight lines. As the value increases,
        the curve becomes more rounded. For more information, see [SPLINE77] and [PETZOLD].'''
        raise NotImplementedError()
    
    @tension.setter
    def tension(self, value : float) -> None:
        '''Sets the tension
        A 32-bit floating point number that specifies how tightly the spline
        bends as it passes through the points. A value of 0 specifies that
        the spline is a sequence of straight lines. As the value increases,
        the curve becomes more rounded. For more information, see [SPLINE77] and [PETZOLD].'''
        raise NotImplementedError()
    
    @property
    def num_segments(self) -> int:
        '''Gets the segments count
        A 32-bit unsigned integer that specifies the number of line segments making up the spline.'''
        raise NotImplementedError()
    
    @num_segments.setter
    def num_segments(self, value : int) -> None:
        '''Sets the segments count
        A 32-bit unsigned integer that specifies the number of line segments making up the spline.'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets an array of either 32-bit signed integers or 32-bit floating-point numbers of
        Count length that defines coordinate values of the endpoints of the lines to be stroked.'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets an array of either 32-bit signed integers or 32-bit floating-point numbers of
        Count length that defines coordinate values of the endpoints of the lines to be stroked.'''
        raise NotImplementedError()
    

class EmfPlusDrawDriverString(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawDriverString record specifies text output with character positions.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawDriverString` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The EMF+ Object Table index of an :link:`EmfPlusFont` object (section
        2.2.1.3) to render the text. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The EMF+ Object Table index of an :link:`EmfPlusFont` object (section
        2.2.1.3) to render the text. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that specifies either the foreground color of the text or a graphics brush,
        depending on the value of the S flag in the Flags'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that specifies either the foreground color of the text or a graphics brush,
        depending on the value of the S flag in the Flags'''
        raise NotImplementedError()
    
    @property
    def driver_string_options_flags(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusDriverStringOptionsFlags:
        '''Gets the driver string options flags
        A 32-bit unsigned integer that specifies the spacing, orientation, and quality of rendering for the string.'''
        raise NotImplementedError()
    
    @driver_string_options_flags.setter
    def driver_string_options_flags(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusDriverStringOptionsFlags) -> None:
        '''Sets the driver string options flags
        A 32-bit unsigned integer that specifies the spacing, orientation, and quality of rendering for the string.'''
        raise NotImplementedError()
    
    @property
    def glyph_count(self) -> int:
        '''Gets the glyph count
        A 32-bit unsigned integer that specifies number of glyphs in the string'''
        raise NotImplementedError()
    
    @glyph_count.setter
    def glyph_count(self, value : int) -> None:
        '''Sets the glyph count
        A 32-bit unsigned integer that specifies number of glyphs in the string'''
        raise NotImplementedError()
    
    @property
    def glyph_pos(self) -> List[aspose.imaging.PointF]:
        '''Gets the glyph positions array
        An array of EmfPlusPointF objects (section 2.2.2.36) that specify the output position of each character glyph.
        There MUST be GlyphCount elements, which have a one-to-one correspondence with the elements in the Glyphs array.
        Glyph positions are calculated from the position of the first glyph if the DriverStringOptionsRealizedAdvance
        flag in DriverStringOptions flags is set. In this case, GlyphPos specifies the position of the first glyph only.'''
        raise NotImplementedError()
    
    @glyph_pos.setter
    def glyph_pos(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets the glyph positions array
        An array of EmfPlusPointF objects (section 2.2.2.36) that specify the output position of each character glyph.
        There MUST be GlyphCount elements, which have a one-to-one correspondence with the elements in the Glyphs array.
        Glyph positions are calculated from the position of the first glyph if the DriverStringOptionsRealizedAdvance
        flag in DriverStringOptions flags is set. In this case, GlyphPos specifies the position of the first glyph only.'''
        raise NotImplementedError()
    
    @property
    def glyphs(self) -> List[int]:
        '''Gets the glyphs array
        An array of 16-bit values that define the text string to draw.
        If the DriverStringOptionsCmapLookup flag in the DriverStringOptionsFlags field is set, each value in this
        array specifies a Unicode character. Otherwise, each value specifies an index to a
        character glyph in the EmfPlusFont object specified by the ObjectId value in Flags field.'''
        raise NotImplementedError()
    
    @glyphs.setter
    def glyphs(self, value : List[int]) -> None:
        '''Sets the glyphs array
        An array of 16-bit values that define the text string to draw.
        If the DriverStringOptionsCmapLookup flag in the DriverStringOptionsFlags field is set, each value in this
        array specifies a Unicode character. Otherwise, each value specifies an index to a
        character glyph in the EmfPlusFont object specified by the ObjectId value in Flags field.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        This bit indicates the type of data in the BrushId field.
        If set, BrushId specifies the color value in an EmfPlusARGB object
        (section 2.2.2.1). If clear, BrushId contains the EMF+ Object
        Table index of an EmfPlusBrush object (section 2.2.1.1).'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        This bit indicates the type of data in the BrushId field.
        If set, BrushId specifies the color value in an EmfPlusARGB object
        (section 2.2.2.1). If clear, BrushId contains the EMF+ Object
        Table index of an EmfPlusBrush object (section 2.2.1.1).'''
        raise NotImplementedError()
    
    @property
    def matrix_present(self) -> int:
        '''Gets if the matrix present flag
        A 32-bit unsigned integer that specifies whether a transform matrix is present in the TransformMatrix field
        0 - no matrix present. 1 - transform matrix is in TransformMatrix field'''
        raise NotImplementedError()
    
    @matrix_present.setter
    def matrix_present(self, value : int) -> None:
        '''Sets if the matrix present flag
        A 32-bit unsigned integer that specifies whether a transform matrix is present in the TransformMatrix field
        0 - no matrix present. 1 - transform matrix is in TransformMatrix field'''
        raise NotImplementedError()
    
    @property
    def transform_matrix(self) -> aspose.imaging.Matrix:
        '''Gets the transform matrix
        An optional EmfPlusTransformMatrix object (section 2.2.2.47) that specifies the transformation to apply to
        each value in the text array. The presence of this data is determined from the MatrixPresent field.'''
        raise NotImplementedError()
    
    @transform_matrix.setter
    def transform_matrix(self, value : aspose.imaging.Matrix) -> None:
        '''Sets the transform matrix
        An optional EmfPlusTransformMatrix object (section 2.2.2.47) that specifies the transformation to apply to
        each value in the text array. The presence of this data is determined from the MatrixPresent field.'''
        raise NotImplementedError()
    

class EmfPlusDrawEllipse(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawEllipse record specifies drawing an ellipse.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawEllipse` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen (section 2.2.1.7) object in the EMF+
        Object Table to draw the ellipse. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen (section 2.2.1.7) object in the EMF+
        Object Table to draw the ellipse. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> aspose.imaging.RectangleF:
        '''Gets the rectangle data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the ellipse.'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the rectangle data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the ellipse.'''
        raise NotImplementedError()
    

class EmfPlusDrawImage(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawImage record specifies drawing a scaled image.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawImage` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusImage object (section 2.2.1.4) in the EMF+
        Object Table, which specifies the image to render. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusImage object (section 2.2.1.4) in the EMF+
        Object Table, which specifies the image to render. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def image_attributes_id(self) -> int:
        '''Gets the image attributes identifier
        A 32-bit unsigned integer that specifies the index of an optional EmfPlusImageAttributes object (section 2.2.1.5) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @image_attributes_id.setter
    def image_attributes_id(self, value : int) -> None:
        '''Sets the image attributes identifier
        A 32-bit unsigned integer that specifies the index of an optional EmfPlusImageAttributes object (section 2.2.1.5) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> aspose.imaging.RectangleF:
        '''Gets the rect data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the image.
        The portion of the image specified by the SrcRect field is scaled to fit this rectangle.'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the rect data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the image.
        The portion of the image specified by the SrcRect field is scaled to fit this rectangle.'''
        raise NotImplementedError()
    
    @property
    def src_rect(self) -> aspose.imaging.RectangleF:
        '''Gets the source rect
        An EmfPlusRectF object that specifies a portion of the image to be rendered.
        The portion of the image specified by this rectangle is scaled to fit the destination
        rectangle specified by the RectData field.'''
        raise NotImplementedError()
    
    @src_rect.setter
    def src_rect(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the source rect
        An EmfPlusRectF object that specifies a portion of the image to be rendered.
        The portion of the image specified by this rectangle is scaled to fit the destination
        rectangle specified by the RectData field.'''
        raise NotImplementedError()
    
    @property
    def src_unit(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusUnitType:
        '''Gets the source unit
        32-bit signed integer that specifies the units of the SrcRect field.
        It MUST be the UnitTypePixel member of the UnitType enumeration (section 2.1.1.33).'''
        raise NotImplementedError()
    
    @src_unit.setter
    def src_unit(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusUnitType) -> None:
        '''Sets the source unit
        32-bit signed integer that specifies the units of the SrcRect field.
        It MUST be the UnitTypePixel member of the UnitType enumeration (section 2.1.1.33).'''
        raise NotImplementedError()
    

class EmfPlusDrawImagePoints(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawImagePoints record specifies drawing a scaled image inside a parallelogram.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawImagePoints` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer
        coordinates. If clear, PointData specifies absolute locations in the coordinate space with
        32-bit floating-point coordinates.
        Note If the P flag (below) is set, this flag is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer
        coordinates. If clear, PointData specifies absolute locations in the coordinate space with
        32-bit floating-point coordinates.
        Note If the P flag (below) is set, this flag is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusImage object (section 2.2.1.4) in the EMF+
        Object Table, which specifies the image to render. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusImage object (section 2.2.1.4) in the EMF+
        Object Table, which specifies the image to render. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def applying_an_effect(self) -> bool:
        '''Gets a value indicating whether [applying an effect].
        This bit indicates that the rendering of the image includes applying an effect.
        If set, an object of the Effect class MUST have been specified in an earlier
        EmfPlusSerializableObject record (section 2.3.5.2).'''
        raise NotImplementedError()
    
    @applying_an_effect.setter
    def applying_an_effect(self, value : bool) -> None:
        '''Sets a value indicating whether [applying an effect].
        This bit indicates that the rendering of the image includes applying an effect.
        If set, an object of the Effect class MUST have been specified in an earlier
        EmfPlusSerializableObject record (section 2.3.5.2).'''
        raise NotImplementedError()
    
    @property
    def relative(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawImagePoints` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is
        relative to the location specified by the previous element in the array. In the case of the
        first element in PointData, a previous location at coordinates (0,0) is assumed. If clear,
        PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the C flag (above) is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @relative.setter
    def relative(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawImagePoints` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is
        relative to the location specified by the previous element in the array. In the case of the
        first element in PointData, a previous location at coordinates (0,0) is assumed. If clear,
        PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the C flag (above) is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def image_attributes_id(self) -> int:
        '''Gets a 32-bit unsigned integer that contains the index of the
        optional EmfPlusImageAttributes object (section 2.2.1.5) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @image_attributes_id.setter
    def image_attributes_id(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that contains the index of the
        optional EmfPlusImageAttributes object (section 2.2.1.5) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def src_unit(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusUnitType:
        '''Gets a 32-bit signed integer that defines the units of the SrcRect field. It MUST
        be the UnitPixel value of the UnitType enumeration (section 2.1.1.33).'''
        raise NotImplementedError()
    
    @src_unit.setter
    def src_unit(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusUnitType) -> None:
        '''Sets a 32-bit signed integer that defines the units of the SrcRect field. It MUST
        be the UnitPixel value of the UnitType enumeration (section 2.1.1.33).'''
        raise NotImplementedError()
    
    @property
    def src_rect(self) -> aspose.imaging.RectangleF:
        '''Gets an EmfPlusRectF object (section 2.2.2.39) that defines a portion of the image to be rendered.'''
        raise NotImplementedError()
    
    @src_rect.setter
    def src_rect(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets an EmfPlusRectF object (section 2.2.2.39) that defines a portion of the image to be rendered.'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets an array of Count points that specify three points of a parallelogram.
        The three points represent the upper-left, upper-right, and lower-left corners of the
        parallelogram. The fourth point of the parallelogram is extrapolated from the first three. The
        portion of the image specified by the SrcRect field SHOULD have scaling and shearing
        transforms applied if necessary to fit inside the parallelogram.'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets an array of Count points that specify three points of a parallelogram.
        The three points represent the upper-left, upper-right, and lower-left corners of the
        parallelogram. The fourth point of the parallelogram is extrapolated from the first three. The
        portion of the image specified by the SrcRect field SHOULD have scaling and shearing
        transforms applied if necessary to fit inside the parallelogram.'''
        raise NotImplementedError()
    

class EmfPlusDrawLines(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawlLines record specifies drawing a series of connected lines'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawLines` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the lines. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the lines. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer coordinates.
        If clear, PointData specifies absolute locations in the coordinate space with 32-bit floating-point coordinates
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit integer coordinates.
        If clear, PointData specifies absolute locations in the coordinate space with 32-bit floating-point coordinates
        Note If the Relative flag (below) is set, this flag is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @property
    def relative(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is relative
        to the location specified by the previous element in the array. In the case of the first
        element in PointData, a previous location at coordinates (0,0) is assumed. If clear,
        PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the Compressed flag (above) is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @relative.setter
    def relative(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawClosedCurve` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is relative
        to the location specified by the previous element in the array. In the case of the first
        element in PointData, a previous location at coordinates (0,0) is assumed. If clear,
        PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the Compressed flag (above) is undefined and MUST be ignored'''
        raise NotImplementedError()
    
    @property
    def closed_shape(self) -> bool:
        '''Gets a value indicating whether [closed shape].'''
        raise NotImplementedError()
    
    @closed_shape.setter
    def closed_shape(self, value : bool) -> None:
        '''Sets a value indicating whether [closed shape].'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets the point data
        An array of Count points that specify the starting and ending points of the lines to be drawn.'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets the point data
        An array of Count points that specify the starting and ending points of the lines to be drawn.'''
        raise NotImplementedError()
    

class EmfPlusDrawPath(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawPath record specifies drawing a graphics path.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawPath` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of the EmfPlusPath object (section 2.2.1.6) to draw, in the
        EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of the EmfPlusPath object (section 2.2.1.6) to draw, in the
        EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def pen_id(self) -> int:
        '''Gets the pen identifier
        A 32-bit unsigned integer that specifies an index in the EMF+ Object Table
        for an EmfPlusPen object (section 2.2.1.7) to use for drawing the EmfPlusPath.
        The value MUST be zero to 63, inclusive'''
        raise NotImplementedError()
    
    @pen_id.setter
    def pen_id(self, value : int) -> None:
        '''Sets the pen identifier
        A 32-bit unsigned integer that specifies an index in the EMF+ Object Table
        for an EmfPlusPen object (section 2.2.1.7) to use for drawing the EmfPlusPath.
        The value MUST be zero to 63, inclusive'''
        raise NotImplementedError()
    

class EmfPlusDrawPie(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawPie record specifies drawing a section of the interior of an ellipse.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawPie` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the pie. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the pie. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def start_angle(self) -> float:
        '''Gets the start angle
        A 32-bit, non-negative floating-point value that specifies the angle between the
        x-axis and the starting point of the pie wedge. Any value is acceptable, but it
        MUST be interpreted modulo 360, with the result that is used being in the range
        0.0 inclusive to 360.0 exclusive.'''
        raise NotImplementedError()
    
    @start_angle.setter
    def start_angle(self, value : float) -> None:
        '''Sets the start angle
        A 32-bit, non-negative floating-point value that specifies the angle between the
        x-axis and the starting point of the pie wedge. Any value is acceptable, but it
        MUST be interpreted modulo 360, with the result that is used being in the range
        0.0 inclusive to 360.0 exclusive.'''
        raise NotImplementedError()
    
    @property
    def sweep_angle(self) -> float:
        '''Gets the sweep angle
        A 32-bit floating-point value that specifies the extent of the arc that defines
        the pie wedge to draw, as an angle in degrees measured from the starting point
        defined by the StartAngle value. Any value is acceptable, but it MUST be clamped
        to -360.0 to 360.0 inclusive. A positive value indicates that the sweep is defined
        in a clockwise direction, and a negative value indicates that the sweep is defined
        in a counter-clockwise direction.'''
        raise NotImplementedError()
    
    @sweep_angle.setter
    def sweep_angle(self, value : float) -> None:
        '''Sets the sweep angle
        A 32-bit floating-point value that specifies the extent of the arc that defines
        the pie wedge to draw, as an angle in degrees measured from the starting point
        defined by the StartAngle value. Any value is acceptable, but it MUST be clamped
        to -360.0 to 360.0 inclusive. A positive value indicates that the sweep is defined
        in a clockwise direction, and a negative value indicates that the sweep is defined
        in a counter-clockwise direction.'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> aspose.imaging.RectangleF:
        '''Gets the rectangle datas
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the
        ellipse that contains the pie wedge. This rectangle defines the position, size,
        and shape of the pie. The type of object in this field is specified by the value
        of the Flags field.'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the rectangle datas
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the
        ellipse that contains the pie wedge. This rectangle defines the position, size,
        and shape of the pie. The type of object in this field is specified by the value
        of the Flags field.'''
        raise NotImplementedError()
    

class EmfPlusDrawRects(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawRects record specifies drawing a series of rectangles'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawRects` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the rectangles. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusPen object (section 2.2.1.7) in the EMF+
        Object Table to draw the rectangles. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> List[aspose.imaging.RectangleF]:
        '''Gets the rect data
        An array of either an EmfPlusRect or EmfPlusRectF objects of Count length that defines the rectangle data.'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : List[aspose.imaging.RectangleF]) -> None:
        '''Sets the rect data
        An array of either an EmfPlusRect or EmfPlusRectF objects of Count length that defines the rectangle data.'''
        raise NotImplementedError()
    

class EmfPlusDrawString(EmfPlusDrawingRecordType):
    '''The EmfPlusDrawString record specifies text output with string formatting'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusDrawString` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object
        (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object
        (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of an EmfPlusFont object (section 2.2.1.3) in the EMF+
        Object Table to render the text. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of an EmfPlusFont object (section 2.2.1.3) in the EMF+
        Object Table to render the text. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that specifies the brush, the content of which
        is determined by the S bit in the Flags field. This definition is used
        to paint the foreground text color; that is, just the glyphs themselves.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that specifies the brush, the content of which
        is determined by the S bit in the Flags field. This definition is used
        to paint the foreground text color; that is, just the glyphs themselves.'''
        raise NotImplementedError()
    
    @property
    def format_id(self) -> int:
        '''Gets the format identifier
        A 32-bit unsigned integer that specifies the index of an optional
        EmfPlusStringFormat object (section 2.2.1.9) in the EMF+ Object Table.
        This object specifies text layout information and display manipulations
        to be applied to a string'''
        raise NotImplementedError()
    
    @format_id.setter
    def format_id(self, value : int) -> None:
        '''Sets the format identifier
        A 32-bit unsigned integer that specifies the index of an optional
        EmfPlusStringFormat object (section 2.2.1.9) in the EMF+ Object Table.
        This object specifies text layout information and display manipulations
        to be applied to a string'''
        raise NotImplementedError()
    
    @property
    def length(self) -> int:
        '''Gets the length
        32-bit unsigned integer that specifies the number of characters in the string.'''
        raise NotImplementedError()
    
    @length.setter
    def length(self, value : int) -> None:
        '''Sets the length
        32-bit unsigned integer that specifies the number of characters in the string.'''
        raise NotImplementedError()
    
    @property
    def layout_rect(self) -> aspose.imaging.RectangleF:
        '''Gets the layout rect
        An EmfPlusRectF object (section 2.2.2.39) that defines the bounding area
        of the destination that will receive the string'''
        raise NotImplementedError()
    
    @layout_rect.setter
    def layout_rect(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the layout rect
        An EmfPlusRectF object (section 2.2.2.39) that defines the bounding area
        of the destination that will receive the string'''
        raise NotImplementedError()
    
    @property
    def string_data(self) -> str:
        '''Gets the string data
        An array of 16-bit Unicode characters that specifies the string to be drawn'''
        raise NotImplementedError()
    
    @string_data.setter
    def string_data(self, value : str) -> None:
        '''Sets the string data
        An array of 16-bit Unicode characters that specifies the string to be drawn'''
        raise NotImplementedError()
    

class EmfPlusDrawingRecordType(EmfPlusRecord):
    '''The drawing record types specify graphics output.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusEndContainer(EmfPlusStateRecordType):
    '''The EmfPlusEndContainer record closes a graphics state container that was previously opened by a begin container operation.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusEndContainer` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def stack_index(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the index of a graphics state
        container. The index MUST must match the value associated with a graphics state container
        opened by a previous EmfPlusBeginContainer (section 2.3.7.1) or
        EmfPlusBeginContainerNoParams record (section 2.3.7.2).'''
        raise NotImplementedError()
    
    @stack_index.setter
    def stack_index(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the index of a graphics state
        container. The index MUST must match the value associated with a graphics state container
        opened by a previous EmfPlusBeginContainer (section 2.3.7.1) or
        EmfPlusBeginContainerNoParams record (section 2.3.7.2).'''
        raise NotImplementedError()
    

class EmfPlusEndOfFile(EmfPlusControlRecordType):
    '''The EmfPlusEndOfFile record specifies the end of EMF+ data in the metafile.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusEndOfFile` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusFillClosedCurve(EmfPlusDrawingRecordType):
    '''The EmfPlusFillClosedCurve record specifies filling the interior of a closed cardinal spline'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object
        (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object
        (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit
        integer coordinates. If clear, PointData specifies absolute locations in the
        coordinate space with 32-bit floating-point coordinates.
        ----------------------
        A "winding" fill operation fills areas according to the "even-odd parity" rule.
        According to this rule, a test point can be determined to be inside or outside a
        closed curve as follows: Draw a line from the test point to a point that is distant
        from the curve. If that line crosses the curve an odd number of times, the test
        point is inside the curve; otherwise, the test point is outside the curve.
        ---------------------
        An "alternate" fill operation fills areas according to the "non-zero" rule.
        According to this rule, a test point can be determined to be inside or outside
        a closed curve as follows: Draw a line from a test point to a point that is
        distant from the curve. Count the number of times the curve crosses the test
        line from left to right, and count the number of times the curve crosses the
        test line from right to left. If those two numbers are the same, the test point
        is outside the curve; otherwise, the test point is inside the curve.'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` is compressed.
        This bit indicates whether the PointData field specifies compressed data.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit
        integer coordinates. If clear, PointData specifies absolute locations in the
        coordinate space with 32-bit floating-point coordinates.
        ----------------------
        A "winding" fill operation fills areas according to the "even-odd parity" rule.
        According to this rule, a test point can be determined to be inside or outside a
        closed curve as follows: Draw a line from the test point to a point that is distant
        from the curve. If that line crosses the curve an odd number of times, the test
        point is inside the curve; otherwise, the test point is outside the curve.
        ---------------------
        An "alternate" fill operation fills areas according to the "non-zero" rule.
        According to this rule, a test point can be determined to be inside or outside
        a closed curve as follows: Draw a line from a test point to a point that is
        distant from the curve. Count the number of times the curve crosses the test
        line from left to right, and count the number of times the curve crosses the
        test line from right to left. If those two numbers are the same, the test point
        is outside the curve; otherwise, the test point is inside the curve.'''
        raise NotImplementedError()
    
    @property
    def winding(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` is winding.
        This bit indicates how to perform the fill operation.
        If set, the fill is a "winding" fill. If clear, the fill is an "alternate" fill.'''
        raise NotImplementedError()
    
    @winding.setter
    def winding(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` is winding.
        This bit indicates how to perform the fill operation.
        If set, the fill is a "winding" fill. If clear, the fill is an "alternate" fill.'''
        raise NotImplementedError()
    
    @property
    def relative(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is
        relative to the location specified by the previous element in the array. In the case
        of the first element in PointData, a previous location at coordinates (0,0) is assumed.
        If clear, PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the C flag (above) is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @relative.setter
    def relative(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillClosedCurve` is relative.
        This bit indicates whether the PointData field specifies relative or absolute locations.
        If set, each element in PointData specifies a location in the coordinate space that is
        relative to the location specified by the previous element in the array. In the case
        of the first element in PointData, a previous location at coordinates (0,0) is assumed.
        If clear, PointData specifies absolute locations according to the C flag.
        Note If this flag is set, the C flag (above) is undefined and MUST be ignored.'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that specifies the EmfPlusBrush, the content of which is
        determined by the S bit in the Flags field. This brush is used to fill the interior
        of the closed cardinal spline.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that specifies the EmfPlusBrush, the content of which is
        determined by the S bit in the Flags field. This brush is used to fill the interior
        of the closed cardinal spline.'''
        raise NotImplementedError()
    
    @property
    def tension(self) -> float:
        '''Gets the tension
        A 32-bit floating point value that specifies how tightly the spline bends as it passes
        through the points. A value of 0.0 specifies that the spline is a sequence of straight
        lines. As the value increases, the curve becomes more rounded. For more information,
        see [SPLINE77] and [PETZOLD].'''
        raise NotImplementedError()
    
    @tension.setter
    def tension(self, value : float) -> None:
        '''Sets the tension
        A 32-bit floating point value that specifies how tightly the spline bends as it passes
        through the points. A value of 0.0 specifies that the spline is a sequence of straight
        lines. As the value increases, the curve becomes more rounded. For more information,
        see [SPLINE77] and [PETZOLD].'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets the point data
        An array of Count points that specify the endpoints of the lines that define the spline.
        In a closed cardinal spline, the curve continues through the last point in the PointData
        array and connects with the first point in the array'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets the point data
        An array of Count points that specify the endpoints of the lines that define the spline.
        In a closed cardinal spline, the curve continues through the last point in the PointData
        array and connects with the first point in the array'''
        raise NotImplementedError()
    

class EmfPlusFillEllipse(EmfPlusDrawingRecordType):
    '''The EmfPlusFillEllipse record specifies filling the interior of an ellipse'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillEllipse` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object
        (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object
        (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def is_compressed(self) -> bool:
        '''Gets a value indicating whether this instance is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @is_compressed.setter
    def is_compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that specifies the brush, the content of which
        is determined by the S bit in the Flags field. This definition is used
        to fill the interior of the ellipse'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that specifies the brush, the content of which
        is determined by the S bit in the Flags field. This definition is used
        to fill the interior of the ellipse'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> aspose.imaging.RectangleF:
        '''Gets the rect data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the ellipse'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the rect data
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the ellipse'''
        raise NotImplementedError()
    

class EmfPlusFillPath(EmfPlusDrawingRecordType):
    '''Fill path record
    FLAGS:
    16-bit unsigned integer that provides information about how the operation is to be performed,
    and about the structure of the record.
    0 1 2 3 4 5 6 7 8 9 1 0 1 2 3 4 5 6 7 8 9 2 0 1 2 3 4 5 6 7 8 9 3 0 1
    S X X X X X X X |   ObjectId    |
    S (1 bit): This bit indicates the type of data in the BrushId field.
    If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1). If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.
    X (1 bit): Reserved and MUST be ignored.
    ObjectId (1 byte): The index of the EmfPlusPath object (section 2.2.1.6) to fill, in the EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillPath` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1). If clear,
        BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1). If clear,
        BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of the EmfPlusPath object (section 2.2.1.6) to fill, in the
        EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of the EmfPlusPath object (section 2.2.1.6) to fill, in the
        EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the Brush ID
        A 32-bit unsigned integer that defines the brush, the content of which is determined
        by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the Brush ID
        A 32-bit unsigned integer that defines the brush, the content of which is determined
        by the S bit in the Flags field.'''
        raise NotImplementedError()
    

class EmfPlusFillPie(EmfPlusDrawingRecordType):
    '''The EmfPlusFillPie record specifies filling a section of the interior of an ellipse'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillPie` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether the PointData is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38).
        If clear, RectData contains an EmfPlusRectF object (section 2.2.2.39).'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def start_angle(self) -> float:
        '''Gets the start angle
        A 32-bit, non-negative floating-point value that specifies the angle between the
        x-axis and the starting point of the pie wedge. Any value is acceptable, but it
        MUST be interpreted modulo 360, with the result that is used being in the range
        0.0 inclusive to 360.0 exclusive.'''
        raise NotImplementedError()
    
    @start_angle.setter
    def start_angle(self, value : float) -> None:
        '''Sets the start angle
        A 32-bit, non-negative floating-point value that specifies the angle between the
        x-axis and the starting point of the pie wedge. Any value is acceptable, but it
        MUST be interpreted modulo 360, with the result that is used being in the range
        0.0 inclusive to 360.0 exclusive.'''
        raise NotImplementedError()
    
    @property
    def sweep_angle(self) -> float:
        '''Gets the sweep angle
        A 32-bit floating-point value that specifies the extent of the arc that defines
        the pie wedge to draw, as an angle in degrees measured from the starting point
        defined by the StartAngle value. Any value is acceptable, but it MUST be clamped
        to -360.0 to 360.0 inclusive. A positive value indicates that the sweep is defined
        in a clockwise direction, and a negative value indicates that the sweep is defined
        in a counter-clockwise direction.'''
        raise NotImplementedError()
    
    @sweep_angle.setter
    def sweep_angle(self, value : float) -> None:
        '''Sets the sweep angle
        A 32-bit floating-point value that specifies the extent of the arc that defines
        the pie wedge to draw, as an angle in degrees measured from the starting point
        defined by the StartAngle value. Any value is acceptable, but it MUST be clamped
        to -360.0 to 360.0 inclusive. A positive value indicates that the sweep is defined
        in a clockwise direction, and a negative value indicates that the sweep is defined
        in a counter-clockwise direction.'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> aspose.imaging.RectangleF:
        '''Gets the rectangle datas
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the
        ellipse that contains the pie wedge. This rectangle defines the position, size,
        and shape of the pie. The type of object in this field is specified by the value
        of the Flags field.'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets the rectangle datas
        Either an EmfPlusRect or EmfPlusRectF object that defines the bounding box of the
        ellipse that contains the pie wedge. This rectangle defines the position, size,
        and shape of the pie. The type of object in this field is specified by the value
        of the Flags field.'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content of which
        is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content of which
        is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    

class EmfPlusFillPolygon(EmfPlusDrawingRecordType):
    '''The EmfPlusFillPolygon record specifies filling the interior of a polygon.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillPolygon` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def is_compressed(self) -> bool:
        '''Gets a value indicating whether this instance is compressed.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit
        integer coordinates. If clear, PointData specifies absolute locations in the coordinate
        space with 32-bit floating-point coordinates'''
        raise NotImplementedError()
    
    @is_compressed.setter
    def is_compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is compressed.
        If set, PointData specifies absolute locations in the coordinate space with 16-bit
        integer coordinates. If clear, PointData specifies absolute locations in the coordinate
        space with 32-bit floating-point coordinates'''
        raise NotImplementedError()
    
    @property
    def is_relative(self) -> bool:
        '''Gets a value indicating whether this instance is relative.
        If set, each element in PointData specifies a location in the coordinate
        space that is relative to the location specified by the previous element
        in the array. In the case of the first element in PointData, a previous
        location at coordinates (0,0) is assumed. If clear, PointData specifies
        absolute locations according to the C flag'''
        raise NotImplementedError()
    
    @is_relative.setter
    def is_relative(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is relative.
        If set, each element in PointData specifies a location in the coordinate
        space that is relative to the location specified by the previous element
        in the array. In the case of the first element in PointData, a previous
        location at coordinates (0,0) is assumed. If clear, PointData specifies
        absolute locations according to the C flag'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content
        of which is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content
        of which is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @property
    def point_data(self) -> List[aspose.imaging.PointF]:
        '''Gets the point data
        An array of Count points that define the vertices of the polygon.
        The first two points in the array specify the first side of the polygon.
        Each additional point specifies a new side, the vertices of which
        include the point and the previous point. If the last point and the
        first point do not coincide, they specify the last side of the polygon.'''
        raise NotImplementedError()
    
    @point_data.setter
    def point_data(self, value : List[aspose.imaging.PointF]) -> None:
        '''Sets the point data
        An array of Count points that define the vertices of the polygon.
        The first two points in the array specify the first side of the polygon.
        Each additional point specifies a new side, the vertices of which
        include the point and the previous point. If the last point and the
        first point do not coincide, they specify the last side of the polygon.'''
        raise NotImplementedError()
    

class EmfPlusFillRects(EmfPlusDrawingRecordType):
    '''The EmfPlusFillRects record specifies filling the interiors of a series of rectangles'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillRects` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillRects` is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38). If clear, RectData
        contains an EmfPlusRectF object (section 2.2.2.39) object'''
        raise NotImplementedError()
    
    @compressed.setter
    def compressed(self, value : bool) -> None:
        '''Sets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillRects` is compressed.
        If set, RectData contains an EmfPlusRect object (section 2.2.2.38). If clear, RectData
        contains an EmfPlusRectF object (section 2.2.2.39) object'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content of which is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content of which is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @property
    def rect_data(self) -> List[aspose.imaging.RectangleF]:
        '''Gets the rectangle data
        An array of either an EmfPlusRect or EmfPlusRectF objects of Count length that defines the rectangle data.'''
        raise NotImplementedError()
    
    @rect_data.setter
    def rect_data(self, value : List[aspose.imaging.RectangleF]) -> None:
        '''Sets the rectangle data
        An array of either an EmfPlusRect or EmfPlusRectF objects of Count length that defines the rectangle data.'''
        raise NotImplementedError()
    

class EmfPlusFillRegion(EmfPlusDrawingRecordType):
    '''The EmfPlusFillRegion record specifies filling the interior of a graphics region'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusFillRegion` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index of the EmfPlusRegion object (section 2.2.1.8) to fill, in the
        EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index of the EmfPlusRegion object (section 2.2.1.8) to fill, in the
        EMF+ Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def is_color(self) -> bool:
        '''Gets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @is_color.setter
    def is_color(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is color.
        If set, BrushId specifies a color as an EmfPlusARGB object (section 2.2.2.1).
        If clear, BrushId contains the index of an EmfPlusBrush object (section 2.2.1.1) in the EMF+ Object Table.'''
        raise NotImplementedError()
    
    @property
    def brush_id(self) -> int:
        '''Gets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content of which is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    
    @brush_id.setter
    def brush_id(self, value : int) -> None:
        '''Sets the brush identifier
        A 32-bit unsigned integer that defines the brush, the content of which is determined by the S bit in the Flags field.'''
        raise NotImplementedError()
    

class EmfPlusGetDc(EmfPlusControlRecordType):
    '''The EmfPlusGetDC record specifies that subsequent EMF records encountered in the metafile SHOULD be processed.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusGetDc` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusHeader(EmfPlusControlRecordType):
    '''The EmfPlusHeader record specifies the start of EMF+ data in the metafile.
    The EmfPlusHeader record MUST be embedded in an EMF EMR_COMMENT_EMFPLUS record,
    which MUST be the record immediately following the EMF header in the metafile.
    The EMR_COMMENT_EMFPLUS record is specified in [MS-EMF] section 2.3.3.2.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusHeader` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def dual_mode(self) -> bool:
        '''Gets a value indicating whether [dual mode].
        If set, this flag indicates that this metafile is "dual-mode", which means
        that it contains two sets of records, each of which completely specifies
        the graphics content. If clear, the graphics content is specified by EMF+
        records, and possibly EMF records that are preceded by an EmfPlusGetDC record.
        If this flag is set, EMF records alone SHOULD suffice to define the
        graphics content. Note that whether the "dual-mode" flag is set or not, some
        EMF records are always present, namely EMF control records and the EMF records
        that contain EMF+ records. EMF control records are specified in [MS-EMF]
        section 2.3.4.'''
        raise NotImplementedError()
    
    @dual_mode.setter
    def dual_mode(self, value : bool) -> None:
        '''Sets a value indicating whether [dual mode].
        If set, this flag indicates that this metafile is "dual-mode", which means
        that it contains two sets of records, each of which completely specifies
        the graphics content. If clear, the graphics content is specified by EMF+
        records, and possibly EMF records that are preceded by an EmfPlusGetDC record.
        If this flag is set, EMF records alone SHOULD suffice to define the
        graphics content. Note that whether the "dual-mode" flag is set or not, some
        EMF records are always present, namely EMF control records and the EMF records
        that contain EMF+ records. EMF control records are specified in [MS-EMF]
        section 2.3.4.'''
        raise NotImplementedError()
    
    @property
    def video_display(self) -> bool:
        '''Gets a value indicating whether video display.
        if set, this flag indicates that the metafile was recorded with a reference device
        context for a video display. If clear, the metafile was recorded with a reference device
        context for a printer.'''
        raise NotImplementedError()
    
    @video_display.setter
    def video_display(self, value : bool) -> None:
        '''Sets a value indicating whether video display.
        if set, this flag indicates that the metafile was recorded with a reference device
        context for a video display. If clear, the metafile was recorded with a reference device
        context for a printer.'''
        raise NotImplementedError()
    
    @property
    def emf_plus_flags(self) -> int:
        '''Gets the EMF plus flags.
        A 32-bit unsigned integer that contains information about how this metafile was recorded.
        if 31-st bit of the field is set, this flag indicates that the metafile was recorded with
        a reference device context for a video display. If clear, the metafile was recorded with
        a reference device context for a printer.'''
        raise NotImplementedError()
    
    @emf_plus_flags.setter
    def emf_plus_flags(self, value : int) -> None:
        '''Sets the EMF plus flags.
        A 32-bit unsigned integer that contains information about how this metafile was recorded.
        if 31-st bit of the field is set, this flag indicates that the metafile was recorded with
        a reference device context for a video display. If clear, the metafile was recorded with
        a reference device context for a printer.'''
        raise NotImplementedError()
    
    @property
    def logical_dpi_x(self) -> int:
        '''Gets the logical dpi x.
        A 32-bit unsigned integer that specifies the horizontal resolution for which the metafile
        was recorded, in units of pixels per inch.'''
        raise NotImplementedError()
    
    @logical_dpi_x.setter
    def logical_dpi_x(self, value : int) -> None:
        '''Sets the logical dpi x.
        A 32-bit unsigned integer that specifies the horizontal resolution for which the metafile
        was recorded, in units of pixels per inch.'''
        raise NotImplementedError()
    
    @property
    def logical_dpi_y(self) -> int:
        '''Gets the logical dpi y.
        A 32-bit unsigned integer that specifies the vertical resolution for which the metafile
        was recorded, in units of lines per inch'''
        raise NotImplementedError()
    
    @logical_dpi_y.setter
    def logical_dpi_y(self, value : int) -> None:
        '''Sets the logical dpi y.
        A 32-bit unsigned integer that specifies the vertical resolution for which the metafile
        was recorded, in units of lines per inch'''
        raise NotImplementedError()
    
    @property
    def version(self) -> aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusGraphicsVersion:
        '''Gets the version.
        An EmfPlusGraphicsVersion object (section 2.2.2.19) that specifies the version of operating
        system graphics that was used to create this metafile.'''
        raise NotImplementedError()
    
    @version.setter
    def version(self, value : aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusGraphicsVersion) -> None:
        '''Sets the version.
        An EmfPlusGraphicsVersion object (section 2.2.2.19) that specifies the version of operating
        system graphics that was used to create this metafile.'''
        raise NotImplementedError()
    
    @property
    def is_valid(self) -> bool:
        '''Gets a value indicating whether this instance is valid.'''
        raise NotImplementedError()
    

class EmfPlusMultiplyWorldTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusMultiplyWorldTransform record multiplies the current world space transform by a
    specified transform matrix.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusMultiplyWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def post_multiplied_matrix(self) -> bool:
        '''Gets a value indicating whether [post multiplied matrix].
        If set, the transform matrix should be post-multipled. If clear, it should be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def matrix_data(self) -> aspose.imaging.Matrix:
        '''Gets an EmfPlusTransformMatrix object (section 2.2.2.47) that defines the multiplication matrix.'''
        raise NotImplementedError()
    
    @matrix_data.setter
    def matrix_data(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an EmfPlusTransformMatrix object (section 2.2.2.47) that defines the multiplication matrix.'''
        raise NotImplementedError()
    

class EmfPlusObject(EmfPlusObjectRecordType):
    '''The EmfPlusObject record specifies an object for use in graphics operations. The object definition
    can span multiple records, which is indicated by the value of the Flags field.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusObject` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def is_continuable(self) -> bool:
        '''Gets a value indicating whether this instance is continuable.
        Indicates that the object definition continues on in the next EmfPlusObject
        record. This flag is never set in the final record that defines the object.'''
        raise NotImplementedError()
    
    @is_continuable.setter
    def is_continuable(self, value : bool) -> None:
        '''Sets a value indicating whether this instance is continuable.
        Indicates that the object definition continues on in the next EmfPlusObject
        record. This flag is never set in the final record that defines the object.'''
        raise NotImplementedError()
    
    @property
    def object_type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusObjectType:
        '''Gets the type of the object.'''
        raise NotImplementedError()
    
    @object_type.setter
    def object_type(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusObjectType) -> None:
        '''Sets the type of the object.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the object identifier.
        The index in the EMF+ Object Table to associate with the object
        created by this record. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the object identifier.
        The index in the EMF+ Object Table to associate with the object
        created by this record. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @property
    def total_object_size(self) -> int:
        '''Gets the total size of the object.
        If the record is continuable, when the continue bit is set, this field
        will be present. Continuing objects have multiple EMF+ records starting with
        EmfPlusContineudObjectRecord. Each EmfPlusContinuedObjectRecord will contain a
        TotalObjectSize. Once TotalObjectSize number of bytes has been read, the next EMF+
        record will not be treated as part of the continuing object.'''
        raise NotImplementedError()
    
    @total_object_size.setter
    def total_object_size(self, value : int) -> None:
        '''Sets the total size of the object.
        If the record is continuable, when the continue bit is set, this field
        will be present. Continuing objects have multiple EMF+ records starting with
        EmfPlusContineudObjectRecord. Each EmfPlusContinuedObjectRecord will contain a
        TotalObjectSize. Once TotalObjectSize number of bytes has been read, the next EMF+
        record will not be treated as part of the continuing object.'''
        raise NotImplementedError()
    
    @property
    def object_data(self) -> aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusGraphicsObjectType:
        '''Gets an array of bytes that contains data for the type of object specified in
        the Flags field. The content and format of the data can be different for each object type. See
        the individual object definitions in section 2.2.1 for additional information.'''
        raise NotImplementedError()
    
    @object_data.setter
    def object_data(self, value : aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusGraphicsObjectType) -> None:
        '''Sets an array of bytes that contains data for the type of object specified in
        the Flags field. The content and format of the data can be different for each object type. See
        the individual object definitions in section 2.2.1 for additional information.'''
        raise NotImplementedError()
    

class EmfPlusObjectRecordType(EmfPlusRecord):
    '''The Object Record Types define reusable graphics objects.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusOffsetClip(EmfPlusClippingRecordType):
    '''The EmfPlusOffsetClip record applies a translation transform on the current clipping region for the world space.
    The new current clipping region is set to the result of the translation transform.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusOffsetClip` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def dx(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the horizontal offset for the translation.'''
        raise NotImplementedError()
    
    @dx.setter
    def dx(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the horizontal offset for the translation.'''
        raise NotImplementedError()
    
    @property
    def dy(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the vertical offset for the translation.'''
        raise NotImplementedError()
    
    @dy.setter
    def dy(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the vertical offset for the translation.'''
        raise NotImplementedError()
    

class EmfPlusPropertyRecordType(EmfPlusRecord):
    '''The Property Record Types specify properties of the playback device context.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusRecord(aspose.imaging.fileformats.emf.MetaObject):
    '''The Emf+ base record type.'''
    
    @overload
    def __init__(self) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord` class.'''
        raise NotImplementedError()
    
    @overload
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusResetClip(EmfPlusClippingRecordType):
    '''The EmfPlusResetClip record resets the current clipping region for the world space to infinity.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusResetClip` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusResetWorldTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusResetWorldTransform record resets the current world space transform to the identify matrix.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusResetWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusRestore(EmfPlusStateRecordType):
    '''The EmfPlusRestore record restores the graphics state, identified by a specified index, from a stack of saved graphics states.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRestore` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def stack_index(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the level associated with a
        graphics state. The level value was assigned to the graphics state by a previous EmfPlusSave record (section 2.3.7.5).'''
        raise NotImplementedError()
    
    @stack_index.setter
    def stack_index(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the level associated with a
        graphics state. The level value was assigned to the graphics state by a previous EmfPlusSave record (section 2.3.7.5).'''
        raise NotImplementedError()
    

class EmfPlusRotateWorldTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusRotateWorldTransform record performs a rotation on the current world space transform.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRotateWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def post_multiplied_matrix(self) -> bool:
        '''Gets a value indicating whether [post multiplied matrix].
        If set, the transform matrix should be post-multiplied. If clear, it should be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def angle(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the angle of rotation in degrees.
        The operation is performed by constructing a new transform matrix from the following
        diagram:
        ---------------------------------
        |  sin(Angle) |  cos(Angle) | 0 |
        |  cos(Angle) |  sin(Angle) | 0 |
        ---------------------------------
        Figure 2: Rotation Transform Matrix
        The current world space transform is multiplied by this matrix, and the result becomes the
        new current world space transform. The Flags field determines the order of multiplication.'''
        raise NotImplementedError()
    
    @angle.setter
    def angle(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the angle of rotation in degrees.
        The operation is performed by constructing a new transform matrix from the following
        diagram:
        ---------------------------------
        |  sin(Angle) |  cos(Angle) | 0 |
        |  cos(Angle) |  sin(Angle) | 0 |
        ---------------------------------
        Figure 2: Rotation Transform Matrix
        The current world space transform is multiplied by this matrix, and the result becomes the
        new current world space transform. The Flags field determines the order of multiplication.'''
        raise NotImplementedError()
    

class EmfPlusSave(EmfPlusStateRecordType):
    '''The EmfPlusSave record saves the graphics state, identified by a specified index, on a stack of saved graphics states.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSave` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def stack_index(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies a level to associate with the
        graphics state. The level value can be used by a subsequent EmfPlusRestore record (section
        2.3.7.4) operation to retrieve the graphics state.'''
        raise NotImplementedError()
    
    @stack_index.setter
    def stack_index(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies a level to associate with the
        graphics state. The level value can be used by a subsequent EmfPlusRestore record (section
        2.3.7.4) operation to retrieve the graphics state.'''
        raise NotImplementedError()
    

class EmfPlusScaleWorldTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusScaleWorldTransform record performs a scaling on the current world space transform.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusScaleWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def post_multiplied_matrix(self) -> bool:
        '''Gets a value indicating whether [post multiplied matrix].
        If set, the transform matrix should be post-multipled. If clear, it should be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def sx(self) -> float:
        '''Gets a 32-bit floating-point value that defines the horizontal scale factor. The scaling
        is performed by constructing a new transform matrix from the Sx and Sy field values, as
        shown in the following table.
        -----------------
        |  Sx |   0 | 0 |
        |   0 |  Sx | 0 |
        -----------------
        Figure 3: Scale Transform Matrix'''
        raise NotImplementedError()
    
    @sx.setter
    def sx(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that defines the horizontal scale factor. The scaling
        is performed by constructing a new transform matrix from the Sx and Sy field values, as
        shown in the following table.
        -----------------
        |  Sx |   0 | 0 |
        |   0 |  Sx | 0 |
        -----------------
        Figure 3: Scale Transform Matrix'''
        raise NotImplementedError()
    
    @property
    def sy(self) -> float:
        '''Gets a 32-bit floating-point value that defines the vertical scale factor.'''
        raise NotImplementedError()
    
    @sy.setter
    def sy(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that defines the vertical scale factor.'''
        raise NotImplementedError()
    

class EmfPlusSerializableObject(EmfPlusObjectRecordType):
    '''The EmfPlusSerializableObject record defines an image effects parameter block that has been
    serialized into a data buffer.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSerializableObject` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that is not used. This field SHOULD be set to zero
        and MUST be ignored upon receipt.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def object_guid(self) -> aspose.imaging.fileformats.emf.dtyp.commondatastructures.GuidPacketRepresentation:
        '''Gets the GUID packet representation value ([MS-DTYP] section 2.3.4.2)
        for the image effect. This MUST correspond to one of the ImageEffects identifiers (section 2.1.3.1).'''
        raise NotImplementedError()
    
    @object_guid.setter
    def object_guid(self, value : aspose.imaging.fileformats.emf.dtyp.commondatastructures.GuidPacketRepresentation) -> None:
        '''Sets the GUID packet representation value ([MS-DTYP] section 2.3.4.2)
        for the image effect. This MUST correspond to one of the ImageEffects identifiers (section 2.1.3.1).'''
        raise NotImplementedError()
    
    @property
    def buffer_size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the size in bytes of the 32-bitaligned Buffer field.'''
        raise NotImplementedError()
    
    @buffer_size.setter
    def buffer_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the size in bytes of the 32-bitaligned Buffer field.'''
        raise NotImplementedError()
    
    @property
    def buffer(self) -> List[int]:
        '''Gets an array of BufferSize bytes that contain the serialized image effects
        parameter block that corresponds to the GUID in the ObjectGUID field. This MUST be one of
        the Image Effects objects (section 2.2.3).'''
        raise NotImplementedError()
    
    @buffer.setter
    def buffer(self, value : List[int]) -> None:
        '''Sets an array of BufferSize bytes that contain the serialized image effects
        parameter block that corresponds to the GUID in the ObjectGUID field. This MUST be one of
        the Image Effects objects (section 2.2.3).'''
        raise NotImplementedError()
    
    @property
    def image_effect(self) -> aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusImageEffectsObjectType:
        '''Gets the image effect.'''
        raise NotImplementedError()
    
    @image_effect.setter
    def image_effect(self, value : aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusImageEffectsObjectType) -> None:
        '''Sets the image effect.'''
        raise NotImplementedError()
    

class EmfPlusSetAntiAliasMode(EmfPlusPropertyRecordType):
    '''The EmfPlusSetAntiAliasMode record specifies the anti-aliasing mode for text output.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetAntiAliasMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def smoothing_mode(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusSmoothingMode:
        '''Gets the smoothing mode.
        (7 bits): The smoothing mode value, from the SmoothingMode enumeration (section 2.1.1.28)'''
        raise NotImplementedError()
    
    @smoothing_mode.setter
    def smoothing_mode(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusSmoothingMode) -> None:
        '''Sets the smoothing mode.
        (7 bits): The smoothing mode value, from the SmoothingMode enumeration (section 2.1.1.28)'''
        raise NotImplementedError()
    
    @property
    def anti_aliasing(self) -> bool:
        '''Gets a value indicating whether [anti aliasing].
        If set, anti-aliasing SHOULD be performed.
        If clear, anti-aliasing SHOULD NOT be performed.'''
        raise NotImplementedError()
    
    @anti_aliasing.setter
    def anti_aliasing(self, value : bool) -> None:
        '''Sets a value indicating whether [anti aliasing].
        If set, anti-aliasing SHOULD be performed.
        If clear, anti-aliasing SHOULD NOT be performed.'''
        raise NotImplementedError()
    

class EmfPlusSetClipPath(EmfPlusClippingRecordType):
    '''The EmfPlusSetClipPath record combines the current clipping region with a graphics path.
    The new current clipping region is set to the result of the CombineMode operation.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetClipPath` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def cm(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCombineMode:
        '''Gets the CM (4 bits): Specifies the logical operation for combining two regions. See the
        CombineMode enumeration (section 2.1.1.4) for the meanings of the values.'''
        raise NotImplementedError()
    
    @cm.setter
    def cm(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCombineMode) -> None:
        '''Sets the CM (4 bits): Specifies the logical operation for combining two regions. See the
        CombineMode enumeration (section 2.1.1.4) for the meanings of the values.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the index of an EmfPlusPath object (section 2.2.1.6) in the EMF+
        Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the index of an EmfPlusPath object (section 2.2.1.6) in the EMF+
        Object Table. The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    

class EmfPlusSetClipRect(EmfPlusClippingRecordType):
    '''The EmfPlusSetClipRect record combines the current clipping region with a rectangle.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetClipRect` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def cm(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCombineMode:
        '''Gets the CM (4 bits): Specifies the logical operation for combining two regions. See the
        CombineMode enumeration (section 2.1.1.4) for the meanings of the values.'''
        raise NotImplementedError()
    
    @cm.setter
    def cm(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCombineMode) -> None:
        '''Sets the CM (4 bits): Specifies the logical operation for combining two regions. See the
        CombineMode enumeration (section 2.1.1.4) for the meanings of the values.'''
        raise NotImplementedError()
    
    @property
    def clip_rect(self) -> aspose.imaging.RectangleF:
        '''Gets an EmfPlusRectF object (section 2.2.2.39) that defines the rectangle to
        use in the CombineMode operation.'''
        raise NotImplementedError()
    
    @clip_rect.setter
    def clip_rect(self, value : aspose.imaging.RectangleF) -> None:
        '''Sets an EmfPlusRectF object (section 2.2.2.39) that defines the rectangle to
        use in the CombineMode operation.'''
        raise NotImplementedError()
    

class EmfPlusSetClipRegion(EmfPlusClippingRecordType):
    '''The EmfPlusSetClipRegion record combines the current clipping region with another graphics region.
    The new current clipping region is set to the result of performing the CombineMode operation on
    the previous current clipping region and the specified EmfPlusRegion object.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetClipRegion` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def cm(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCombineMode:
        '''Gets the CM (4 bits): Specifies the logical operation for combining two regions. See the
        CombineMode enumeration (section 2.1.1.4) for the meanings of the values.'''
        raise NotImplementedError()
    
    @cm.setter
    def cm(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCombineMode) -> None:
        '''Sets the CM (4 bits): Specifies the logical operation for combining two regions. See the
        CombineMode enumeration (section 2.1.1.4) for the meanings of the values.'''
        raise NotImplementedError()
    
    @property
    def object_id(self) -> int:
        '''Gets the index of an EmfPlusRegion object (section 2.2.1.8) in the EMF+
        Object Table.The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    
    @object_id.setter
    def object_id(self, value : int) -> None:
        '''Sets the index of an EmfPlusRegion object (section 2.2.1.8) in the EMF+
        Object Table.The value MUST be zero to 63, inclusive.'''
        raise NotImplementedError()
    

class EmfPlusSetCompositingMode(EmfPlusPropertyRecordType):
    '''The EmfPlusSetCompositingMode record specifies how source colors are combined with background colors.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetCompositingMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compositing_mode(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingMode:
        '''Gets the compositing mode value, from the CompositingMode
        enumeration (section 2.1.1.5). Compositing can be expressed as the state of alpha
        blending, which can either be on or off.'''
        raise NotImplementedError()
    
    @compositing_mode.setter
    def compositing_mode(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingMode) -> None:
        '''Sets the compositing mode value, from the CompositingMode
        enumeration (section 2.1.1.5). Compositing can be expressed as the state of alpha
        blending, which can either be on or off.'''
        raise NotImplementedError()
    

class EmfPlusSetCompositingQuality(EmfPlusPropertyRecordType):
    '''The EmfPlusSetCompositingQuality record specifies the desired level of quality for creating
    composite images from multiple objects.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetCompositingQuality` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compositing_quality(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingQuality:
        '''Gets the compositing quality.'''
        raise NotImplementedError()
    
    @compositing_quality.setter
    def compositing_quality(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingQuality) -> None:
        '''Sets the compositing quality.'''
        raise NotImplementedError()
    

class EmfPlusSetInterpolationMode(EmfPlusPropertyRecordType):
    '''The EmfPlusSetInterpolationMode record specifies how image scaling, including stretching and shrinking, is performed.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetInterpolationMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def interpolation_mode(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusInterpolationMode:
        '''Gets the interpolation mode value, from the InterpolationMode enumeration (section 2.1.1.16).'''
        raise NotImplementedError()
    
    @interpolation_mode.setter
    def interpolation_mode(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusInterpolationMode) -> None:
        '''Sets the interpolation mode value, from the InterpolationMode enumeration (section 2.1.1.16).'''
        raise NotImplementedError()
    

class EmfPlusSetPageTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusSetPageTransform record specifies scaling factors and units for converting page space
    coordinates to device space coordinates.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetPageTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def page_unit(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusUnitType:
        '''Gets the unit of measure for page space coordinates, from the UnitType
        enumeration (section 2.1.1.33). This value SHOULD NOT be UnitTypeDisplay or UnitTypeWorld.'''
        raise NotImplementedError()
    
    @property
    def page_scale(self) -> float:
        '''Gets a 32-bit floating-point value that specifies the scale factor for converting
        page space coordinates to device space coordinates.'''
        raise NotImplementedError()
    
    @page_scale.setter
    def page_scale(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that specifies the scale factor for converting
        page space coordinates to device space coordinates.'''
        raise NotImplementedError()
    

class EmfPlusSetPixelOffsetMode(EmfPlusPropertyRecordType):
    '''The EmfPlusSetPixelOffsetMode record specifies how pixels are centered with respect to the
    coordinates of the drawing surface.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetPixelOffsetMode` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def pixel_offset_mode(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusPixelOffsetMode:
        '''Gets the pixel offset mode value, from the PixelOffsetMode
        enumeration (section 2.1.1.26).'''
        raise NotImplementedError()
    
    @pixel_offset_mode.setter
    def pixel_offset_mode(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusPixelOffsetMode) -> None:
        '''Sets the pixel offset mode value, from the PixelOffsetMode
        enumeration (section 2.1.1.26).'''
        raise NotImplementedError()
    

class EmfPlusSetRenderingOrigin(EmfPlusPropertyRecordType):
    '''The EmfPlusSetRenderingOrigin record specifies the rendering origin for graphics output.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetRenderingOrigin` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets a 32-bit unsigned integer that defines the horizontal coordinate value of the rendering origin.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that defines the horizontal coordinate value of the rendering origin.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets a 32-bit unsigned integer that defines the vertical coordinate value of the rendering origin.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that defines the vertical coordinate value of the rendering origin.'''
        raise NotImplementedError()
    

class EmfPlusSetTextContrast(EmfPlusPropertyRecordType):
    '''The EmfPlusSetTextContrast record specifies text contrast according to the gamma correction value.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetTextContrast` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def text_contrast(self) -> int:
        '''Gets the gamma correction value X 1000, which will be applied to
        subsequent text rendering operations. The allowable range is 1000 to 2200,
        representing text gamma values of 1.0 to 2.2.'''
        raise NotImplementedError()
    
    @text_contrast.setter
    def text_contrast(self, value : int) -> None:
        '''Sets the gamma correction value X 1000, which will be applied to
        subsequent text rendering operations. The allowable range is 1000 to 2200,
        representing text gamma values of 1.0 to 2.2.'''
        raise NotImplementedError()
    

class EmfPlusSetTextRenderingHint(EmfPlusPropertyRecordType):
    '''The EmfPlusSetTextRenderingHint record specifies the quality of text rendering, including the type of anti-aliasing.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetTextRenderingHint` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def text_rendering_hint(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusTextRenderingHint:
        '''Gets the text rendering hint value, from the
        TextRenderingHint enumeration (section 2.1.1.32), which specifies the quality to
        use in subsequent text rendering.'''
        raise NotImplementedError()
    
    @text_rendering_hint.setter
    def text_rendering_hint(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusTextRenderingHint) -> None:
        '''Sets the text rendering hint value, from the
        TextRenderingHint enumeration (section 2.1.1.32), which specifies the quality to
        use in subsequent text rendering.'''
        raise NotImplementedError()
    

class EmfPlusSetTsClip(EmfPlusTerminalServerRecordType):
    '''The EmfPlusSetTSClip record specifies clipping areas in the graphics device context for a terminal server.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetTsClip` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def compressed(self) -> bool:
        '''Gets a value indicating whether this :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetTsClip` is compressed.
        This bit specifies the format of the rectangle data in the rects field. If set, each
        rectangle is defined in 4 bytes. If clear, each rectangle is defined in 8 bytes.'''
        raise NotImplementedError()
    
    @property
    def num_rects(self) -> int:
        '''Gets the number rects.
        This field specifies the number of rectangles that are defined in the rect field.'''
        raise NotImplementedError()
    
    @property
    def rects(self) -> List[aspose.imaging.Rectangle]:
        '''Gets an array of NumRects rectangles that define clipping areas. The format of
        this data is determined by the C bit in the Flags field.'''
        raise NotImplementedError()
    
    @rects.setter
    def rects(self, value : List[aspose.imaging.Rectangle]) -> None:
        '''Sets an array of NumRects rectangles that define clipping areas. The format of
        this data is determined by the C bit in the Flags field.'''
        raise NotImplementedError()
    

class EmfPlusSetTsGraphics(EmfPlusTerminalServerRecordType):
    '''The EmfPlusSetTSGraphics record specifies the state of a graphics device context for a terminal server.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetTsGraphics` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def basic_vga_colors(self) -> bool:
        '''Gets a value indicating whether [basic vga colors].
        If set, the palette contains only the basic VGA colors.'''
        raise NotImplementedError()
    
    @property
    def have_palette(self) -> bool:
        '''Gets a value indicating whether [have palette].
        If set, this record contains an EmfPlusPalette object (section 2.2.2.28) in the
        Palette field following the graphics state data.'''
        raise NotImplementedError()
    
    @property
    def anti_alias_mode(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusSmoothingMode:
        '''Gets an 8-bit unsigned integer that specifies the quality of line rendering,
        including the type of line anti-aliasing. It MUST be defined in the SmoothingMode
        enumeration (section 2.1.1.28).'''
        raise NotImplementedError()
    
    @anti_alias_mode.setter
    def anti_alias_mode(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusSmoothingMode) -> None:
        '''Sets an 8-bit unsigned integer that specifies the quality of line rendering,
        including the type of line anti-aliasing. It MUST be defined in the SmoothingMode
        enumeration (section 2.1.1.28).'''
        raise NotImplementedError()
    
    @property
    def text_render_hint(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusTextRenderingHint:
        '''Gets an 8-bit unsigned integer that specifies the quality of text
        rendering, including the type of text anti-aliasing. It MUST be defined in the
        TextRenderingHint enumeration (section 2.1.1.32).'''
        raise NotImplementedError()
    
    @text_render_hint.setter
    def text_render_hint(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusTextRenderingHint) -> None:
        '''Sets an 8-bit unsigned integer that specifies the quality of text
        rendering, including the type of text anti-aliasing. It MUST be defined in the
        TextRenderingHint enumeration (section 2.1.1.32).'''
        raise NotImplementedError()
    
    @property
    def compositing_mode(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingMode:
        '''Gets an 8-bit unsigned integer that specifies how source colors are
        combined with background colors. It MUST be a value in the CompositingMode
        enumeration (section 2.1.1.5).'''
        raise NotImplementedError()
    
    @compositing_mode.setter
    def compositing_mode(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingMode) -> None:
        '''Sets an 8-bit unsigned integer that specifies how source colors are
        combined with background colors. It MUST be a value in the CompositingMode
        enumeration (section 2.1.1.5).'''
        raise NotImplementedError()
    
    @property
    def compositing_quality(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingQuality:
        '''Gets an 8-bit unsigned integer that specifies the degree of
        smoothing to apply to lines, curves and the edges of filled areas to make them appear more
        continuous or sharply defined. It MUST be a value in the CompositingQuality enumeration (section 2.1.1.6).'''
        raise NotImplementedError()
    
    @compositing_quality.setter
    def compositing_quality(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusCompositingQuality) -> None:
        '''Sets an 8-bit unsigned integer that specifies the degree of
        smoothing to apply to lines, curves and the edges of filled areas to make them appear more
        continuous or sharply defined. It MUST be a value in the CompositingQuality enumeration (section 2.1.1.6).'''
        raise NotImplementedError()
    
    @property
    def render_origin_x(self) -> int:
        '''Gets a 16-bit signed integer, which is the horizontal coordinate of the
        origin for rendering halftoning and dithering matrixes.'''
        raise NotImplementedError()
    
    @render_origin_x.setter
    def render_origin_x(self, value : int) -> None:
        '''Sets a 16-bit signed integer, which is the horizontal coordinate of the
        origin for rendering halftoning and dithering matrixes.'''
        raise NotImplementedError()
    
    @property
    def render_origin_y(self) -> int:
        '''Gets a 16-bit signed integer, which is the vertical coordinate of the origin
        for rendering halftoning and dithering matrixes.'''
        raise NotImplementedError()
    
    @render_origin_y.setter
    def render_origin_y(self, value : int) -> None:
        '''Sets a 16-bit signed integer, which is the vertical coordinate of the origin
        for rendering halftoning and dithering matrixes.'''
        raise NotImplementedError()
    
    @property
    def text_contrast(self) -> int:
        '''Gets a 16-bit unsigned integer that specifies the gamma correction value
        used for rendering anti-aliased and ClearType text. This value MUST be in the range 0 to 12, inclusive.'''
        raise NotImplementedError()
    
    @text_contrast.setter
    def text_contrast(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that specifies the gamma correction value
        used for rendering anti-aliased and ClearType text. This value MUST be in the range 0 to 12, inclusive.'''
        raise NotImplementedError()
    
    @property
    def filter_type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusFilterType:
        '''Gets an 8-bit unsigned integer that specifies how scaling, including stretching
        and shrinking, is performed. It MUST be a value in the FilterType enumeration (section 2.1.1.11).'''
        raise NotImplementedError()
    
    @filter_type.setter
    def filter_type(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusFilterType) -> None:
        '''Sets an 8-bit unsigned integer that specifies how scaling, including stretching
        and shrinking, is performed. It MUST be a value in the FilterType enumeration (section 2.1.1.11).'''
        raise NotImplementedError()
    
    @property
    def pixel_offset(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusPixelOffsetMode:
        '''Gets an 8-bit unsigned integer that specifies the overall quality of the image
        and text-rendering process. It MUST be a value in the PixelOffsetMode enumeration (section 2.1.1.26).'''
        raise NotImplementedError()
    
    @pixel_offset.setter
    def pixel_offset(self, value : aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusPixelOffsetMode) -> None:
        '''Sets an 8-bit unsigned integer that specifies the overall quality of the image
        and text-rendering process. It MUST be a value in the PixelOffsetMode enumeration (section 2.1.1.26).'''
        raise NotImplementedError()
    
    @property
    def world_to_device(self) -> aspose.imaging.Matrix:
        '''Gets an 192-bit EmfPlusTransformMatrix object (section 2.2.2.47) that
        specifies the world space to device space transforms.'''
        raise NotImplementedError()
    
    @world_to_device.setter
    def world_to_device(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an 192-bit EmfPlusTransformMatrix object (section 2.2.2.47) that
        specifies the world space to device space transforms.'''
        raise NotImplementedError()
    
    @property
    def palette(self) -> aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusPalette:
        '''Gets an optional EmfPlusPalette object.'''
        raise NotImplementedError()
    
    @palette.setter
    def palette(self, value : aspose.imaging.fileformats.emf.emfplus.objects.EmfPlusPalette) -> None:
        '''Sets an optional EmfPlusPalette object.'''
        raise NotImplementedError()
    

class EmfPlusSetWorldTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusSetWorldTransform record sets the world transform according to the values in a
    specified transform matrix.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusSetWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def matrix_data(self) -> aspose.imaging.Matrix:
        '''Gets an EmfPlusTransformMatrix object (section 2.2.2.47) that defines the
        new current world transform.'''
        raise NotImplementedError()
    
    @matrix_data.setter
    def matrix_data(self, value : aspose.imaging.Matrix) -> None:
        '''Sets an EmfPlusTransformMatrix object (section 2.2.2.47) that defines the
        new current world transform.'''
        raise NotImplementedError()
    

class EmfPlusStateRecordType(EmfPlusRecord):
    '''The State Record Types specify operations on the state of the playback device context.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusTerminalServerRecordType(EmfPlusRecord):
    '''The Terminal Server Record Types specify graphics processing on a terminal server. The following
    are EMF+ terminal server record types.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusTransformRecordType(EmfPlusRecord):
    '''The Transform Record Types specify properties and transforms on coordinate spaces.'''
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    

class EmfPlusTranslateWorldTransform(EmfPlusTerminalServerRecordType):
    '''The EmfPlusTranslateWorldTransform record performs a translation on the current world space transform.'''
    
    def __init__(self, source : aspose.imaging.fileformats.emf.emfplus.records.EmfPlusRecord) -> None:
        '''Initializes a new instance of the :py:class:`aspose.imaging.fileformats.emf.emfplus.records.EmfPlusTranslateWorldTransform` class.
        
        :param source: The source.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.imaging.fileformats.emf.emfplus.consts.EmfPlusRecordType:
        '''Gets a 16-bit unsigned integer that identifies the record type.'''
        raise NotImplementedError()
    
    @property
    def flags(self) -> int:
        '''Gets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @flags.setter
    def flags(self, value : int) -> None:
        '''Sets a 16-bit unsigned integer that contains information for some records on how
        the operation is to be performed and on the structure of the record.'''
        raise NotImplementedError()
    
    @property
    def size(self) -> int:
        '''Gets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @size.setter
    def size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that specifies the 32-bit-aligned number of bytes
        in the entire record, including the 12-byte record header and record-specific data.'''
        raise NotImplementedError()
    
    @property
    def data_size(self) -> int:
        '''Gets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @data_size.setter
    def data_size(self, value : int) -> None:
        '''Sets a 32-bit unsigned integer that MUST define the 32-bit–aligned number of
        bytes of data in the RecordData field that follows. This number does not include the 12-byte record header.'''
        raise NotImplementedError()
    
    @property
    def post_multiplied_matrix(self) -> bool:
        '''Gets a value indicating whether [post multiplied matrix].
        If set, the transform matrix should be post-multiplied. If clear, it should be premultiplied.'''
        raise NotImplementedError()
    
    @property
    def dx(self) -> float:
        '''Gets a 32-bit floating-point value that defines the horizontal distance. The translation
        is performed by constructing a new world transform matrix from the dx and dy fields'''
        raise NotImplementedError()
    
    @dx.setter
    def dx(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that defines the horizontal distance. The translation
        is performed by constructing a new world transform matrix from the dx and dy fields'''
        raise NotImplementedError()
    
    @property
    def dy(self) -> float:
        '''Gets a 32-bit floating-point value that defines the vertical distance value.'''
        raise NotImplementedError()
    
    @dy.setter
    def dy(self, value : float) -> None:
        '''Sets a 32-bit floating-point value that defines the vertical distance value.'''
        raise NotImplementedError()
    

