# generated by datamodel-codegen:
#   filename:  api/data/createChart.json
#   timestamp: 2023-05-12T06:22:55+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.data import chart
from ...type import basic, entityReference, tagLabel


class CreateChartRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName = Field(..., description='Name that identifies this Chart.')
    displayName: Optional[str] = Field(
        None,
        description='Display Name that identifies this Chart. It could be title or label from the source services',
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='Description of the chart instance. What it has and how to use it.',
    )
    chartType: Optional[chart.ChartType] = None
    chartUrl: Optional[str] = Field(
        None, description='Chart URL suffix from its service.'
    )
    tags: Optional[List[tagLabel.TagLabel]] = Field(
        None, description='Tags for this chart'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this chart'
    )
    service: basic.FullyQualifiedEntityName = Field(
        ..., description='Link to the chart service where this chart is hosted in'
    )
