# generated by datamodel-codegen:
#   filename:  configuration/authenticationConfiguration.json
#   timestamp: 2023-05-12T06:22:55+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..security.client import samlSSOClientConfig
from . import ldapConfiguration


class AuthenticationConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    provider: str = Field(
        ...,
        description='SSO provider: no-auth, okta, google, azure, auth0, custom-oidc, aws-cognito, ldap, saml, etc.',
    )
    providerName: str = Field(
        ..., description='Custom OIDC Authentication Provider Name'
    )
    publicKeyUrls: List[str] = Field(..., description='List of Public Key URLs')
    authority: str = Field(..., description='Authentication Authority')
    clientId: str = Field(..., description='Client ID')
    callbackUrl: str = Field(..., description='Callback URL')
    jwtPrincipalClaims: List[str] = Field(..., description='Jwt Principal Claim')
    enableSelfSignup: Optional[bool] = Field(False, description='Enable Self Sign Up')
    ldapConfiguration: Optional[ldapConfiguration.LdapConfiguration] = Field(
        None, description='LDAP Configuration in case the Provider is LDAP'
    )
    samlConfiguration: Optional[samlSSOClientConfig.SamlSSOClientConfig] = Field(
        None,
        description='Saml Configuration that is applicable only when the provider is Saml',
    )
