# generated by datamodel-codegen:
#   filename:  entity/services/connections/messaging/redpandaConnection.json
#   timestamp: 2023-05-12T06:22:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType
from . import saslMechanismType


class RedpandaType(Enum):
    Redpanda = 'Redpanda'


class RedpandaConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[RedpandaType] = Field(
        RedpandaType.Redpanda, description='Service Type', title='Service Type'
    )
    bootstrapServers: str = Field(
        ...,
        description='Redpanda bootstrap servers. add them in comma separated values ex: host1:9092,host2:9092',
        title='Bootstrap Servers',
    )
    schemaRegistryURL: Optional[AnyUrl] = Field(
        None,
        description='Confluent Redpanda Schema Registry URL.',
        title='Schema Registry URL',
    )
    saslUsername: Optional[str] = Field(
        None,
        description='sasl.username consumer config property',
        title='SASL Username',
    )
    saslPassword: Optional[CustomSecretStr] = Field(
        None,
        description='sasl.password consumer config property',
        title='SASL Password',
    )
    saslMechanism: Optional[saslMechanismType.SaslMechanismType] = Field(
        saslMechanismType.SaslMechanismType.PLAIN,
        description='sasl.mechanism Consumer Config property',
        title='SASL Mechanism',
    )
    basicAuthUserInfo: Optional[CustomSecretStr] = Field(
        None,
        description='basic.auth.user.info schema registry config property, Client HTTP credentials in the form of username:password.',
        title='Basic Auth User Info',
    )
    consumerConfig: Optional[Dict[str, Any]] = Field(
        {}, description='Confluent Redpanda Consumer Config', title='Consumer Config'
    )
    schemaRegistryConfig: Optional[Dict[str, Any]] = Field(
        {},
        description='Confluent Redpanda Schema Registry Config.',
        title='Schema Registry Config',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
