# generated by datamodel-codegen:
#   filename:  type/csvImportResult.json
#   timestamp: 2023-05-12T06:22:55+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, conint

from . import basic


class RowCount(BaseModel):
    __root__: conint(ge=0) = Field(..., description='Type used to indicate row count')


class Index(BaseModel):
    __root__: conint(ge=1) = Field(
        ...,
        description='Type used to indicate row number or field number. In CSV the indexes start with 1.',
    )


class CsvImportResult(BaseModel):
    class Config:
        extra = Extra.forbid

    dryRun: Optional[bool] = Field(
        None, description='True if the CSV import has dryRun flag enabled'
    )
    status: Optional[basic.Status] = None
    abortReason: Optional[str] = Field(
        None,
        description='Reason why import was aborted. This is set only when the `status` field is set to `aborted`',
    )
    numberOfRowsProcessed: Optional[RowCount] = None
    numberOfRowsPassed: Optional[RowCount] = None
    numberOfRowsFailed: Optional[RowCount] = None
    importResultsCsv: Optional[str] = Field(
        None, description='CSV file that captures the result of import operation.'
    )
