import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#id DataAzurermKustoCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#name DataAzurermKustoCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#resource_group_name DataAzurermKustoCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#timeouts DataAzurermKustoCluster#timeouts}
    */
    readonly timeouts?: DataAzurermKustoClusterTimeouts;
}
export interface DataAzurermKustoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#read DataAzurermKustoCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKustoClusterTimeoutsToTerraform(struct?: DataAzurermKustoClusterTimeoutsOutputReference | DataAzurermKustoClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKustoClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKustoClusterTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster azurerm_kusto_cluster}
*/
export declare class DataAzurermKustoCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_kusto_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster azurerm_kusto_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKustoClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKustoClusterConfig);
    get dataIngestionUri(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get uri(): string;
    private _timeouts;
    get timeouts(): DataAzurermKustoClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKustoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKustoClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
