import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSpringCloudAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#id DataAzurermSpringCloudApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#name DataAzurermSpringCloudApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#resource_group_name DataAzurermSpringCloudApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#service_name DataAzurermSpringCloudApp#service_name}
    */
    readonly serviceName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#timeouts DataAzurermSpringCloudApp#timeouts}
    */
    readonly timeouts?: DataAzurermSpringCloudAppTimeouts;
}
export interface DataAzurermSpringCloudAppIdentity {
}
export declare function dataAzurermSpringCloudAppIdentityToTerraform(struct?: DataAzurermSpringCloudAppIdentity): any;
export declare class DataAzurermSpringCloudAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudAppIdentity | undefined;
    set internalValue(value: DataAzurermSpringCloudAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermSpringCloudAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudAppIdentityOutputReference;
}
export interface DataAzurermSpringCloudAppPersistentDisk {
}
export declare function dataAzurermSpringCloudAppPersistentDiskToTerraform(struct?: DataAzurermSpringCloudAppPersistentDisk): any;
export declare class DataAzurermSpringCloudAppPersistentDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSpringCloudAppPersistentDisk | undefined;
    set internalValue(value: DataAzurermSpringCloudAppPersistentDisk | undefined);
    get mountPath(): string;
    get sizeInGb(): number;
}
export declare class DataAzurermSpringCloudAppPersistentDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSpringCloudAppPersistentDiskOutputReference;
}
export interface DataAzurermSpringCloudAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app#read DataAzurermSpringCloudApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSpringCloudAppTimeoutsToTerraform(struct?: DataAzurermSpringCloudAppTimeoutsOutputReference | DataAzurermSpringCloudAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSpringCloudAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSpringCloudAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSpringCloudAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app azurerm_spring_cloud_app}
*/
export declare class DataAzurermSpringCloudApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_spring_cloud_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/spring_cloud_app azurerm_spring_cloud_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSpringCloudAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSpringCloudAppConfig);
    get fqdn(): string;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermSpringCloudAppIdentityList;
    get isPublic(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _persistentDisk;
    get persistentDisk(): DataAzurermSpringCloudAppPersistentDiskList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    get tlsEnabled(): cdktf.IResolvable;
    get url(): string;
    private _timeouts;
    get timeouts(): DataAzurermSpringCloudAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSpringCloudAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSpringCloudAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
