import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LinuxVirtualMachineScaleSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#admin_password LinuxVirtualMachineScaleSet#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#admin_username LinuxVirtualMachineScaleSet#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#capacity_reservation_group_id LinuxVirtualMachineScaleSet#capacity_reservation_group_id}
    */
    readonly capacityReservationGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#computer_name_prefix LinuxVirtualMachineScaleSet#computer_name_prefix}
    */
    readonly computerNamePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#custom_data LinuxVirtualMachineScaleSet#custom_data}
    */
    readonly customData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disable_password_authentication LinuxVirtualMachineScaleSet#disable_password_authentication}
    */
    readonly disablePasswordAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#do_not_run_extensions_on_overprovisioned_machines LinuxVirtualMachineScaleSet#do_not_run_extensions_on_overprovisioned_machines}
    */
    readonly doNotRunExtensionsOnOverprovisionedMachines?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#edge_zone LinuxVirtualMachineScaleSet#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#encryption_at_host_enabled LinuxVirtualMachineScaleSet#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#eviction_policy LinuxVirtualMachineScaleSet#eviction_policy}
    */
    readonly evictionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#extension_operations_enabled LinuxVirtualMachineScaleSet#extension_operations_enabled}
    */
    readonly extensionOperationsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#extensions_time_budget LinuxVirtualMachineScaleSet#extensions_time_budget}
    */
    readonly extensionsTimeBudget?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#health_probe_id LinuxVirtualMachineScaleSet#health_probe_id}
    */
    readonly healthProbeId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#host_group_id LinuxVirtualMachineScaleSet#host_group_id}
    */
    readonly hostGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#id LinuxVirtualMachineScaleSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#instances LinuxVirtualMachineScaleSet#instances}
    */
    readonly instances?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#location LinuxVirtualMachineScaleSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_bid_price LinuxVirtualMachineScaleSet#max_bid_price}
    */
    readonly maxBidPrice?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#overprovision LinuxVirtualMachineScaleSet#overprovision}
    */
    readonly overprovision?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#platform_fault_domain_count LinuxVirtualMachineScaleSet#platform_fault_domain_count}
    */
    readonly platformFaultDomainCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#priority LinuxVirtualMachineScaleSet#priority}
    */
    readonly priority?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#provision_vm_agent LinuxVirtualMachineScaleSet#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#proximity_placement_group_id LinuxVirtualMachineScaleSet#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#resource_group_name LinuxVirtualMachineScaleSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#scale_in_policy LinuxVirtualMachineScaleSet#scale_in_policy}
    */
    readonly scaleInPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#secure_boot_enabled LinuxVirtualMachineScaleSet#secure_boot_enabled}
    */
    readonly secureBootEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#single_placement_group LinuxVirtualMachineScaleSet#single_placement_group}
    */
    readonly singlePlacementGroup?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#sku LinuxVirtualMachineScaleSet#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#source_image_id LinuxVirtualMachineScaleSet#source_image_id}
    */
    readonly sourceImageId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#tags LinuxVirtualMachineScaleSet#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#upgrade_mode LinuxVirtualMachineScaleSet#upgrade_mode}
    */
    readonly upgradeMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#user_data LinuxVirtualMachineScaleSet#user_data}
    */
    readonly userData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#vtpm_enabled LinuxVirtualMachineScaleSet#vtpm_enabled}
    */
    readonly vtpmEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#zone_balance LinuxVirtualMachineScaleSet#zone_balance}
    */
    readonly zoneBalance?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#zones LinuxVirtualMachineScaleSet#zones}
    */
    readonly zones?: string[];
    /**
    * additional_capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#additional_capabilities LinuxVirtualMachineScaleSet#additional_capabilities}
    */
    readonly additionalCapabilities?: LinuxVirtualMachineScaleSetAdditionalCapabilities;
    /**
    * admin_ssh_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#admin_ssh_key LinuxVirtualMachineScaleSet#admin_ssh_key}
    */
    readonly adminSshKey?: LinuxVirtualMachineScaleSetAdminSshKey[] | cdktf.IResolvable;
    /**
    * automatic_instance_repair block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#automatic_instance_repair LinuxVirtualMachineScaleSet#automatic_instance_repair}
    */
    readonly automaticInstanceRepair?: LinuxVirtualMachineScaleSetAutomaticInstanceRepair;
    /**
    * automatic_os_upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#automatic_os_upgrade_policy LinuxVirtualMachineScaleSet#automatic_os_upgrade_policy}
    */
    readonly automaticOsUpgradePolicy?: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy;
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#boot_diagnostics LinuxVirtualMachineScaleSet#boot_diagnostics}
    */
    readonly bootDiagnostics?: LinuxVirtualMachineScaleSetBootDiagnostics;
    /**
    * data_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#data_disk LinuxVirtualMachineScaleSet#data_disk}
    */
    readonly dataDisk?: LinuxVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
    * extension block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#extension LinuxVirtualMachineScaleSet#extension}
    */
    readonly extension?: LinuxVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * gallery_application block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#gallery_application LinuxVirtualMachineScaleSet#gallery_application}
    */
    readonly galleryApplication?: LinuxVirtualMachineScaleSetGalleryApplication[] | cdktf.IResolvable;
    /**
    * gallery_applications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#gallery_applications LinuxVirtualMachineScaleSet#gallery_applications}
    */
    readonly galleryApplications?: LinuxVirtualMachineScaleSetGalleryApplications[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#identity LinuxVirtualMachineScaleSet#identity}
    */
    readonly identity?: LinuxVirtualMachineScaleSetIdentity;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#network_interface LinuxVirtualMachineScaleSet#network_interface}
    */
    readonly networkInterface: LinuxVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
    * os_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#os_disk LinuxVirtualMachineScaleSet#os_disk}
    */
    readonly osDisk: LinuxVirtualMachineScaleSetOsDisk;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#plan LinuxVirtualMachineScaleSet#plan}
    */
    readonly plan?: LinuxVirtualMachineScaleSetPlan;
    /**
    * rolling_upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#rolling_upgrade_policy LinuxVirtualMachineScaleSet#rolling_upgrade_policy}
    */
    readonly rollingUpgradePolicy?: LinuxVirtualMachineScaleSetRollingUpgradePolicy;
    /**
    * scale_in block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#scale_in LinuxVirtualMachineScaleSet#scale_in}
    */
    readonly scaleIn?: LinuxVirtualMachineScaleSetScaleIn;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#secret LinuxVirtualMachineScaleSet#secret}
    */
    readonly secret?: LinuxVirtualMachineScaleSetSecret[] | cdktf.IResolvable;
    /**
    * source_image_reference block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#source_image_reference LinuxVirtualMachineScaleSet#source_image_reference}
    */
    readonly sourceImageReference?: LinuxVirtualMachineScaleSetSourceImageReference;
    /**
    * spot_restore block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#spot_restore LinuxVirtualMachineScaleSet#spot_restore}
    */
    readonly spotRestore?: LinuxVirtualMachineScaleSetSpotRestore;
    /**
    * terminate_notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#terminate_notification LinuxVirtualMachineScaleSet#terminate_notification}
    */
    readonly terminateNotification?: LinuxVirtualMachineScaleSetTerminateNotification;
    /**
    * termination_notification block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#termination_notification LinuxVirtualMachineScaleSet#termination_notification}
    */
    readonly terminationNotification?: LinuxVirtualMachineScaleSetTerminationNotification;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#timeouts LinuxVirtualMachineScaleSet#timeouts}
    */
    readonly timeouts?: LinuxVirtualMachineScaleSetTimeouts;
}
export interface LinuxVirtualMachineScaleSetAdditionalCapabilities {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ultra_ssd_enabled LinuxVirtualMachineScaleSet#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetAdditionalCapabilitiesToTerraform(struct?: LinuxVirtualMachineScaleSetAdditionalCapabilitiesOutputReference | LinuxVirtualMachineScaleSetAdditionalCapabilities): any;
export declare class LinuxVirtualMachineScaleSetAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetAdditionalCapabilities | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    resetUltraSsdEnabled(): void;
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxVirtualMachineScaleSetAdminSshKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#public_key LinuxVirtualMachineScaleSet#public_key}
    */
    readonly publicKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#username LinuxVirtualMachineScaleSet#username}
    */
    readonly username: string;
}
export declare function linuxVirtualMachineScaleSetAdminSshKeyToTerraform(struct?: LinuxVirtualMachineScaleSetAdminSshKey | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetAdminSshKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetAdminSshKey | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetAdminSshKey | cdktf.IResolvable | undefined);
    private _publicKey?;
    get publicKey(): string;
    set publicKey(value: string);
    get publicKeyInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class LinuxVirtualMachineScaleSetAdminSshKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetAdminSshKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetAdminSshKeyOutputReference;
}
export interface LinuxVirtualMachineScaleSetAutomaticInstanceRepair {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enabled LinuxVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#grace_period LinuxVirtualMachineScaleSet#grace_period}
    */
    readonly gracePeriod?: string;
}
export declare function linuxVirtualMachineScaleSetAutomaticInstanceRepairToTerraform(struct?: LinuxVirtualMachineScaleSetAutomaticInstanceRepairOutputReference | LinuxVirtualMachineScaleSetAutomaticInstanceRepair): any;
export declare class LinuxVirtualMachineScaleSetAutomaticInstanceRepairOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetAutomaticInstanceRepair | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gracePeriod?;
    get gracePeriod(): string;
    set gracePeriod(value: string);
    resetGracePeriod(): void;
    get gracePeriodInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disable_automatic_rollback LinuxVirtualMachineScaleSet#disable_automatic_rollback}
    */
    readonly disableAutomaticRollback: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enable_automatic_os_upgrade LinuxVirtualMachineScaleSet#enable_automatic_os_upgrade}
    */
    readonly enableAutomaticOsUpgrade: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetAutomaticOsUpgradePolicyToTerraform(struct?: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference | LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy): any;
export declare class LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined);
    private _disableAutomaticRollback?;
    get disableAutomaticRollback(): boolean | cdktf.IResolvable;
    set disableAutomaticRollback(value: boolean | cdktf.IResolvable);
    get disableAutomaticRollbackInput(): boolean | cdktf.IResolvable | undefined;
    private _enableAutomaticOsUpgrade?;
    get enableAutomaticOsUpgrade(): boolean | cdktf.IResolvable;
    set enableAutomaticOsUpgrade(value: boolean | cdktf.IResolvable);
    get enableAutomaticOsUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxVirtualMachineScaleSetBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#storage_account_uri LinuxVirtualMachineScaleSet#storage_account_uri}
    */
    readonly storageAccountUri?: string;
}
export declare function linuxVirtualMachineScaleSetBootDiagnosticsToTerraform(struct?: LinuxVirtualMachineScaleSetBootDiagnosticsOutputReference | LinuxVirtualMachineScaleSetBootDiagnostics): any;
export declare class LinuxVirtualMachineScaleSetBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetBootDiagnostics | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetBootDiagnostics | undefined);
    private _storageAccountUri?;
    get storageAccountUri(): string;
    set storageAccountUri(value: string);
    resetStorageAccountUri(): void;
    get storageAccountUriInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#caching LinuxVirtualMachineScaleSet#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#create_option LinuxVirtualMachineScaleSet#create_option}
    */
    readonly createOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_encryption_set_id LinuxVirtualMachineScaleSet#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_size_gb LinuxVirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#lun LinuxVirtualMachineScaleSet#lun}
    */
    readonly lun: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#storage_account_type LinuxVirtualMachineScaleSet#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ultra_ssd_disk_iops_read_write LinuxVirtualMachineScaleSet#ultra_ssd_disk_iops_read_write}
    */
    readonly ultraSsdDiskIopsReadWrite?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ultra_ssd_disk_mbps_read_write LinuxVirtualMachineScaleSet#ultra_ssd_disk_mbps_read_write}
    */
    readonly ultraSsdDiskMbpsReadWrite?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#write_accelerator_enabled LinuxVirtualMachineScaleSet#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetDataDiskToTerraform(struct?: LinuxVirtualMachineScaleSetDataDisk | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetDataDisk | cdktf.IResolvable | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    resetCreateOption(): void;
    get createOptionInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    get diskSizeGbInput(): number | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _ultraSsdDiskIopsReadWrite?;
    get ultraSsdDiskIopsReadWrite(): number;
    set ultraSsdDiskIopsReadWrite(value: number);
    resetUltraSsdDiskIopsReadWrite(): void;
    get ultraSsdDiskIopsReadWriteInput(): number | undefined;
    private _ultraSsdDiskMbpsReadWrite?;
    get ultraSsdDiskMbpsReadWrite(): number;
    set ultraSsdDiskMbpsReadWrite(value: number);
    resetUltraSsdDiskMbpsReadWrite(): void;
    get ultraSsdDiskMbpsReadWriteInput(): number | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class LinuxVirtualMachineScaleSetDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetDataDiskOutputReference;
}
export interface LinuxVirtualMachineScaleSetExtension {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#auto_upgrade_minor_version LinuxVirtualMachineScaleSet#auto_upgrade_minor_version}
    */
    readonly autoUpgradeMinorVersion?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#automatic_upgrade_enabled LinuxVirtualMachineScaleSet#automatic_upgrade_enabled}
    */
    readonly automaticUpgradeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#force_update_tag LinuxVirtualMachineScaleSet#force_update_tag}
    */
    readonly forceUpdateTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#protected_settings LinuxVirtualMachineScaleSet#protected_settings}
    */
    readonly protectedSettings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#provision_after_extensions LinuxVirtualMachineScaleSet#provision_after_extensions}
    */
    readonly provisionAfterExtensions?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#publisher LinuxVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#settings LinuxVirtualMachineScaleSet#settings}
    */
    readonly settings?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type LinuxVirtualMachineScaleSet#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type_handler_version LinuxVirtualMachineScaleSet#type_handler_version}
    */
    readonly typeHandlerVersion: string;
}
export declare function linuxVirtualMachineScaleSetExtensionToTerraform(struct?: LinuxVirtualMachineScaleSetExtension | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetExtension | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetExtension | cdktf.IResolvable | undefined);
    private _autoUpgradeMinorVersion?;
    get autoUpgradeMinorVersion(): boolean | cdktf.IResolvable;
    set autoUpgradeMinorVersion(value: boolean | cdktf.IResolvable);
    resetAutoUpgradeMinorVersion(): void;
    get autoUpgradeMinorVersionInput(): boolean | cdktf.IResolvable | undefined;
    private _automaticUpgradeEnabled?;
    get automaticUpgradeEnabled(): boolean | cdktf.IResolvable;
    set automaticUpgradeEnabled(value: boolean | cdktf.IResolvable);
    resetAutomaticUpgradeEnabled(): void;
    get automaticUpgradeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forceUpdateTag?;
    get forceUpdateTag(): string;
    set forceUpdateTag(value: string);
    resetForceUpdateTag(): void;
    get forceUpdateTagInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protectedSettings?;
    get protectedSettings(): string;
    set protectedSettings(value: string);
    resetProtectedSettings(): void;
    get protectedSettingsInput(): string | undefined;
    private _provisionAfterExtensions?;
    get provisionAfterExtensions(): string[];
    set provisionAfterExtensions(value: string[]);
    resetProvisionAfterExtensions(): void;
    get provisionAfterExtensionsInput(): string[] | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _settings?;
    get settings(): string;
    set settings(value: string);
    resetSettings(): void;
    get settingsInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _typeHandlerVersion?;
    get typeHandlerVersion(): string;
    set typeHandlerVersion(value: string);
    get typeHandlerVersionInput(): string | undefined;
}
export declare class LinuxVirtualMachineScaleSetExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetExtension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetExtensionOutputReference;
}
export interface LinuxVirtualMachineScaleSetGalleryApplication {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#configuration_blob_uri LinuxVirtualMachineScaleSet#configuration_blob_uri}
    */
    readonly configurationBlobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#order LinuxVirtualMachineScaleSet#order}
    */
    readonly order?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#tag LinuxVirtualMachineScaleSet#tag}
    */
    readonly tag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#version_id LinuxVirtualMachineScaleSet#version_id}
    */
    readonly versionId: string;
}
export declare function linuxVirtualMachineScaleSetGalleryApplicationToTerraform(struct?: LinuxVirtualMachineScaleSetGalleryApplication | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetGalleryApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetGalleryApplication | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetGalleryApplication | cdktf.IResolvable | undefined);
    private _configurationBlobUri?;
    get configurationBlobUri(): string;
    set configurationBlobUri(value: string);
    resetConfigurationBlobUri(): void;
    get configurationBlobUriInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    resetOrder(): void;
    get orderInput(): number | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    get versionIdInput(): string | undefined;
}
export declare class LinuxVirtualMachineScaleSetGalleryApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetGalleryApplication[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetGalleryApplicationOutputReference;
}
export interface LinuxVirtualMachineScaleSetGalleryApplications {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#configuration_reference_blob_uri LinuxVirtualMachineScaleSet#configuration_reference_blob_uri}
    */
    readonly configurationReferenceBlobUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#order LinuxVirtualMachineScaleSet#order}
    */
    readonly order?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#package_reference_id LinuxVirtualMachineScaleSet#package_reference_id}
    */
    readonly packageReferenceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#tag LinuxVirtualMachineScaleSet#tag}
    */
    readonly tag?: string;
}
export declare function linuxVirtualMachineScaleSetGalleryApplicationsToTerraform(struct?: LinuxVirtualMachineScaleSetGalleryApplications | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetGalleryApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetGalleryApplications | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetGalleryApplications | cdktf.IResolvable | undefined);
    private _configurationReferenceBlobUri?;
    get configurationReferenceBlobUri(): string;
    set configurationReferenceBlobUri(value: string);
    resetConfigurationReferenceBlobUri(): void;
    get configurationReferenceBlobUriInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    resetOrder(): void;
    get orderInput(): number | undefined;
    private _packageReferenceId?;
    get packageReferenceId(): string;
    set packageReferenceId(value: string);
    get packageReferenceIdInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class LinuxVirtualMachineScaleSetGalleryApplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetGalleryApplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetGalleryApplicationsOutputReference;
}
export interface LinuxVirtualMachineScaleSetIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#identity_ids LinuxVirtualMachineScaleSet#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type LinuxVirtualMachineScaleSet#type}
    */
    readonly type: string;
}
export declare function linuxVirtualMachineScaleSetIdentityToTerraform(struct?: LinuxVirtualMachineScaleSetIdentityOutputReference | LinuxVirtualMachineScaleSetIdentity): any;
export declare class LinuxVirtualMachineScaleSetIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetIdentity | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#tag LinuxVirtualMachineScaleSet#tag}
    */
    readonly tag: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#type LinuxVirtualMachineScaleSet#type}
    */
    readonly type: string;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag | cdktf.IResolvable | undefined);
    private _tag?;
    get tag(): string;
    set tag(value: string);
    get tagInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagOutputReference;
}
export interface LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#domain_name_label LinuxVirtualMachineScaleSet#domain_name_label}
    */
    readonly domainNameLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#idle_timeout_in_minutes LinuxVirtualMachineScaleSet#idle_timeout_in_minutes}
    */
    readonly idleTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#public_ip_prefix_id LinuxVirtualMachineScaleSet#public_ip_prefix_id}
    */
    readonly publicIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#version LinuxVirtualMachineScaleSet#version}
    */
    readonly version?: string;
    /**
    * ip_tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ip_tag LinuxVirtualMachineScaleSet#ip_tag}
    */
    readonly ipTag?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress | cdktf.IResolvable | undefined);
    private _domainNameLabel?;
    get domainNameLabel(): string;
    set domainNameLabel(value: string);
    resetDomainNameLabel(): void;
    get domainNameLabelInput(): string | undefined;
    private _idleTimeoutInMinutes?;
    get idleTimeoutInMinutes(): number;
    set idleTimeoutInMinutes(value: number);
    resetIdleTimeoutInMinutes(): void;
    get idleTimeoutInMinutesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicIpPrefixId?;
    get publicIpPrefixId(): string;
    set publicIpPrefixId(value: string);
    resetPublicIpPrefixId(): void;
    get publicIpPrefixIdInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _ipTag;
    get ipTag(): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagList;
    putIpTag(value: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | cdktf.IResolvable): void;
    resetIpTag(): void;
    get ipTagInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag[] | undefined;
}
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressOutputReference;
}
export interface LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#application_gateway_backend_address_pool_ids LinuxVirtualMachineScaleSet#application_gateway_backend_address_pool_ids}
    */
    readonly applicationGatewayBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#application_security_group_ids LinuxVirtualMachineScaleSet#application_security_group_ids}
    */
    readonly applicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#load_balancer_backend_address_pool_ids LinuxVirtualMachineScaleSet#load_balancer_backend_address_pool_ids}
    */
    readonly loadBalancerBackendAddressPoolIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#load_balancer_inbound_nat_rules_ids LinuxVirtualMachineScaleSet#load_balancer_inbound_nat_rules_ids}
    */
    readonly loadBalancerInboundNatRulesIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#primary LinuxVirtualMachineScaleSet#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#subnet_id LinuxVirtualMachineScaleSet#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#version LinuxVirtualMachineScaleSet#version}
    */
    readonly version?: string;
    /**
    * public_ip_address block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#public_ip_address LinuxVirtualMachineScaleSet#public_ip_address}
    */
    readonly publicIpAddress?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined);
    private _applicationGatewayBackendAddressPoolIds?;
    get applicationGatewayBackendAddressPoolIds(): string[];
    set applicationGatewayBackendAddressPoolIds(value: string[]);
    resetApplicationGatewayBackendAddressPoolIds(): void;
    get applicationGatewayBackendAddressPoolIdsInput(): string[] | undefined;
    private _applicationSecurityGroupIds?;
    get applicationSecurityGroupIds(): string[];
    set applicationSecurityGroupIds(value: string[]);
    resetApplicationSecurityGroupIds(): void;
    get applicationSecurityGroupIdsInput(): string[] | undefined;
    private _loadBalancerBackendAddressPoolIds?;
    get loadBalancerBackendAddressPoolIds(): string[];
    set loadBalancerBackendAddressPoolIds(value: string[]);
    resetLoadBalancerBackendAddressPoolIds(): void;
    get loadBalancerBackendAddressPoolIdsInput(): string[] | undefined;
    private _loadBalancerInboundNatRulesIds?;
    get loadBalancerInboundNatRulesIds(): string[];
    set loadBalancerInboundNatRulesIds(value: string[]);
    resetLoadBalancerInboundNatRulesIds(): void;
    get loadBalancerInboundNatRulesIdsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _publicIpAddress;
    get publicIpAddress(): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressList;
    putPublicIpAddress(value: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | cdktf.IResolvable): void;
    resetPublicIpAddress(): void;
    get publicIpAddressInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress[] | undefined;
}
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationOutputReference;
}
export interface LinuxVirtualMachineScaleSetNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#dns_servers LinuxVirtualMachineScaleSet#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enable_accelerated_networking LinuxVirtualMachineScaleSet#enable_accelerated_networking}
    */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enable_ip_forwarding LinuxVirtualMachineScaleSet#enable_ip_forwarding}
    */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#network_security_group_id LinuxVirtualMachineScaleSet#network_security_group_id}
    */
    readonly networkSecurityGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#primary LinuxVirtualMachineScaleSet#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#ip_configuration LinuxVirtualMachineScaleSet#ip_configuration}
    */
    readonly ipConfiguration: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetNetworkInterfaceToTerraform(struct?: LinuxVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetNetworkInterface | cdktf.IResolvable | undefined);
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _enableAcceleratedNetworking?;
    get enableAcceleratedNetworking(): boolean | cdktf.IResolvable;
    set enableAcceleratedNetworking(value: boolean | cdktf.IResolvable);
    resetEnableAcceleratedNetworking(): void;
    get enableAcceleratedNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIpForwarding?;
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    resetEnableIpForwarding(): void;
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSecurityGroupId?;
    get networkSecurityGroupId(): string;
    set networkSecurityGroupId(value: string);
    resetNetworkSecurityGroupId(): void;
    get networkSecurityGroupIdInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _ipConfiguration;
    get ipConfiguration(): LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationList;
    putIpConfiguration(value: LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration[] | undefined;
}
export declare class LinuxVirtualMachineScaleSetNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetNetworkInterfaceOutputReference;
}
export interface LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#option LinuxVirtualMachineScaleSet#option}
    */
    readonly option: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#placement LinuxVirtualMachineScaleSet#placement}
    */
    readonly placement?: string;
}
export declare function linuxVirtualMachineScaleSetOsDiskDiffDiskSettingsToTerraform(struct?: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference | LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings): any;
export declare class LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined);
    private _option?;
    get option(): string;
    set option(value: string);
    get optionInput(): string | undefined;
    private _placement?;
    get placement(): string;
    set placement(value: string);
    resetPlacement(): void;
    get placementInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#caching LinuxVirtualMachineScaleSet#caching}
    */
    readonly caching: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_encryption_set_id LinuxVirtualMachineScaleSet#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#disk_size_gb LinuxVirtualMachineScaleSet#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#secure_vm_disk_encryption_set_id LinuxVirtualMachineScaleSet#secure_vm_disk_encryption_set_id}
    */
    readonly secureVmDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#security_encryption_type LinuxVirtualMachineScaleSet#security_encryption_type}
    */
    readonly securityEncryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#storage_account_type LinuxVirtualMachineScaleSet#storage_account_type}
    */
    readonly storageAccountType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#write_accelerator_enabled LinuxVirtualMachineScaleSet#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
    * diff_disk_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#diff_disk_settings LinuxVirtualMachineScaleSet#diff_disk_settings}
    */
    readonly diffDiskSettings?: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings;
}
export declare function linuxVirtualMachineScaleSetOsDiskToTerraform(struct?: LinuxVirtualMachineScaleSetOsDiskOutputReference | LinuxVirtualMachineScaleSetOsDisk): any;
export declare class LinuxVirtualMachineScaleSetOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetOsDisk | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetOsDisk | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    get cachingInput(): string | undefined;
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _secureVmDiskEncryptionSetId?;
    get secureVmDiskEncryptionSetId(): string;
    set secureVmDiskEncryptionSetId(value: string);
    resetSecureVmDiskEncryptionSetId(): void;
    get secureVmDiskEncryptionSetIdInput(): string | undefined;
    private _securityEncryptionType?;
    get securityEncryptionType(): string;
    set securityEncryptionType(value: string);
    resetSecurityEncryptionType(): void;
    get securityEncryptionTypeInput(): string | undefined;
    private _storageAccountType?;
    get storageAccountType(): string;
    set storageAccountType(value: string);
    get storageAccountTypeInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _diffDiskSettings;
    get diffDiskSettings(): LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsOutputReference;
    putDiffDiskSettings(value: LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings): void;
    resetDiffDiskSettings(): void;
    get diffDiskSettingsInput(): LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings | undefined;
}
export interface LinuxVirtualMachineScaleSetPlan {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#name LinuxVirtualMachineScaleSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#product LinuxVirtualMachineScaleSet#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#publisher LinuxVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
}
export declare function linuxVirtualMachineScaleSetPlanToTerraform(struct?: LinuxVirtualMachineScaleSetPlanOutputReference | LinuxVirtualMachineScaleSetPlan): any;
export declare class LinuxVirtualMachineScaleSetPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetPlan | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetPlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetRollingUpgradePolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#cross_zone_upgrades_enabled LinuxVirtualMachineScaleSet#cross_zone_upgrades_enabled}
    */
    readonly crossZoneUpgradesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_batch_instance_percent LinuxVirtualMachineScaleSet#max_batch_instance_percent}
    */
    readonly maxBatchInstancePercent: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_unhealthy_instance_percent LinuxVirtualMachineScaleSet#max_unhealthy_instance_percent}
    */
    readonly maxUnhealthyInstancePercent: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#max_unhealthy_upgraded_instance_percent LinuxVirtualMachineScaleSet#max_unhealthy_upgraded_instance_percent}
    */
    readonly maxUnhealthyUpgradedInstancePercent: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#pause_time_between_batches LinuxVirtualMachineScaleSet#pause_time_between_batches}
    */
    readonly pauseTimeBetweenBatches: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#prioritize_unhealthy_instances_enabled LinuxVirtualMachineScaleSet#prioritize_unhealthy_instances_enabled}
    */
    readonly prioritizeUnhealthyInstancesEnabled?: boolean | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetRollingUpgradePolicyToTerraform(struct?: LinuxVirtualMachineScaleSetRollingUpgradePolicyOutputReference | LinuxVirtualMachineScaleSetRollingUpgradePolicy): any;
export declare class LinuxVirtualMachineScaleSetRollingUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetRollingUpgradePolicy | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetRollingUpgradePolicy | undefined);
    private _crossZoneUpgradesEnabled?;
    get crossZoneUpgradesEnabled(): boolean | cdktf.IResolvable;
    set crossZoneUpgradesEnabled(value: boolean | cdktf.IResolvable);
    resetCrossZoneUpgradesEnabled(): void;
    get crossZoneUpgradesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _maxBatchInstancePercent?;
    get maxBatchInstancePercent(): number;
    set maxBatchInstancePercent(value: number);
    get maxBatchInstancePercentInput(): number | undefined;
    private _maxUnhealthyInstancePercent?;
    get maxUnhealthyInstancePercent(): number;
    set maxUnhealthyInstancePercent(value: number);
    get maxUnhealthyInstancePercentInput(): number | undefined;
    private _maxUnhealthyUpgradedInstancePercent?;
    get maxUnhealthyUpgradedInstancePercent(): number;
    set maxUnhealthyUpgradedInstancePercent(value: number);
    get maxUnhealthyUpgradedInstancePercentInput(): number | undefined;
    private _pauseTimeBetweenBatches?;
    get pauseTimeBetweenBatches(): string;
    set pauseTimeBetweenBatches(value: string);
    get pauseTimeBetweenBatchesInput(): string | undefined;
    private _prioritizeUnhealthyInstancesEnabled?;
    get prioritizeUnhealthyInstancesEnabled(): boolean | cdktf.IResolvable;
    set prioritizeUnhealthyInstancesEnabled(value: boolean | cdktf.IResolvable);
    resetPrioritizeUnhealthyInstancesEnabled(): void;
    get prioritizeUnhealthyInstancesEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LinuxVirtualMachineScaleSetScaleIn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#force_deletion_enabled LinuxVirtualMachineScaleSet#force_deletion_enabled}
    */
    readonly forceDeletionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#rule LinuxVirtualMachineScaleSet#rule}
    */
    readonly rule?: string;
}
export declare function linuxVirtualMachineScaleSetScaleInToTerraform(struct?: LinuxVirtualMachineScaleSetScaleInOutputReference | LinuxVirtualMachineScaleSetScaleIn): any;
export declare class LinuxVirtualMachineScaleSetScaleInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetScaleIn | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetScaleIn | undefined);
    private _forceDeletionEnabled?;
    get forceDeletionEnabled(): boolean | cdktf.IResolvable;
    set forceDeletionEnabled(value: boolean | cdktf.IResolvable);
    resetForceDeletionEnabled(): void;
    get forceDeletionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _rule?;
    get rule(): string;
    set rule(value: string);
    resetRule(): void;
    get ruleInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetSecretCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#url LinuxVirtualMachineScaleSet#url}
    */
    readonly url: string;
}
export declare function linuxVirtualMachineScaleSetSecretCertificateToTerraform(struct?: LinuxVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetSecretCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetSecretCertificate | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class LinuxVirtualMachineScaleSetSecretCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetSecretCertificateOutputReference;
}
export interface LinuxVirtualMachineScaleSetSecret {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#key_vault_id LinuxVirtualMachineScaleSet#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#certificate LinuxVirtualMachineScaleSet#certificate}
    */
    readonly certificate: LinuxVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable;
}
export declare function linuxVirtualMachineScaleSetSecretToTerraform(struct?: LinuxVirtualMachineScaleSetSecret | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LinuxVirtualMachineScaleSetSecret | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetSecret | cdktf.IResolvable | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _certificate;
    get certificate(): LinuxVirtualMachineScaleSetSecretCertificateList;
    putCertificate(value: LinuxVirtualMachineScaleSetSecretCertificate[] | cdktf.IResolvable): void;
    get certificateInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetSecretCertificate[] | undefined;
}
export declare class LinuxVirtualMachineScaleSetSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LinuxVirtualMachineScaleSetSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LinuxVirtualMachineScaleSetSecretOutputReference;
}
export interface LinuxVirtualMachineScaleSetSourceImageReference {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#offer LinuxVirtualMachineScaleSet#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#publisher LinuxVirtualMachineScaleSet#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#sku LinuxVirtualMachineScaleSet#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#version LinuxVirtualMachineScaleSet#version}
    */
    readonly version: string;
}
export declare function linuxVirtualMachineScaleSetSourceImageReferenceToTerraform(struct?: LinuxVirtualMachineScaleSetSourceImageReferenceOutputReference | LinuxVirtualMachineScaleSetSourceImageReference): any;
export declare class LinuxVirtualMachineScaleSetSourceImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetSourceImageReference | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetSourceImageReference | undefined);
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetSpotRestore {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enabled LinuxVirtualMachineScaleSet#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#timeout LinuxVirtualMachineScaleSet#timeout}
    */
    readonly timeout?: string;
}
export declare function linuxVirtualMachineScaleSetSpotRestoreToTerraform(struct?: LinuxVirtualMachineScaleSetSpotRestoreOutputReference | LinuxVirtualMachineScaleSetSpotRestore): any;
export declare class LinuxVirtualMachineScaleSetSpotRestoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetSpotRestore | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetSpotRestore | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetTerminateNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enabled LinuxVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#timeout LinuxVirtualMachineScaleSet#timeout}
    */
    readonly timeout?: string;
}
export declare function linuxVirtualMachineScaleSetTerminateNotificationToTerraform(struct?: LinuxVirtualMachineScaleSetTerminateNotificationOutputReference | LinuxVirtualMachineScaleSetTerminateNotification): any;
export declare class LinuxVirtualMachineScaleSetTerminateNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetTerminateNotification | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetTerminateNotification | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetTerminationNotification {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#enabled LinuxVirtualMachineScaleSet#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#timeout LinuxVirtualMachineScaleSet#timeout}
    */
    readonly timeout?: string;
}
export declare function linuxVirtualMachineScaleSetTerminationNotificationToTerraform(struct?: LinuxVirtualMachineScaleSetTerminationNotificationOutputReference | LinuxVirtualMachineScaleSetTerminationNotification): any;
export declare class LinuxVirtualMachineScaleSetTerminationNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetTerminationNotification | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetTerminationNotification | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface LinuxVirtualMachineScaleSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#create LinuxVirtualMachineScaleSet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#delete LinuxVirtualMachineScaleSet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#read LinuxVirtualMachineScaleSet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set#update LinuxVirtualMachineScaleSet#update}
    */
    readonly update?: string;
}
export declare function linuxVirtualMachineScaleSetTimeoutsToTerraform(struct?: LinuxVirtualMachineScaleSetTimeoutsOutputReference | LinuxVirtualMachineScaleSetTimeouts | cdktf.IResolvable): any;
export declare class LinuxVirtualMachineScaleSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LinuxVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LinuxVirtualMachineScaleSetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set azurerm_linux_virtual_machine_scale_set}
*/
export declare class LinuxVirtualMachineScaleSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_linux_virtual_machine_scale_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/linux_virtual_machine_scale_set azurerm_linux_virtual_machine_scale_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LinuxVirtualMachineScaleSetConfig
    */
    constructor(scope: Construct, id: string, config: LinuxVirtualMachineScaleSetConfig);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _capacityReservationGroupId?;
    get capacityReservationGroupId(): string;
    set capacityReservationGroupId(value: string);
    resetCapacityReservationGroupId(): void;
    get capacityReservationGroupIdInput(): string | undefined;
    private _computerNamePrefix?;
    get computerNamePrefix(): string;
    set computerNamePrefix(value: string);
    resetComputerNamePrefix(): void;
    get computerNamePrefixInput(): string | undefined;
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
    private _disablePasswordAuthentication?;
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    resetDisablePasswordAuthentication(): void;
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _doNotRunExtensionsOnOverprovisionedMachines?;
    get doNotRunExtensionsOnOverprovisionedMachines(): boolean | cdktf.IResolvable;
    set doNotRunExtensionsOnOverprovisionedMachines(value: boolean | cdktf.IResolvable);
    resetDoNotRunExtensionsOnOverprovisionedMachines(): void;
    get doNotRunExtensionsOnOverprovisionedMachinesInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _evictionPolicy?;
    get evictionPolicy(): string;
    set evictionPolicy(value: string);
    resetEvictionPolicy(): void;
    get evictionPolicyInput(): string | undefined;
    private _extensionOperationsEnabled?;
    get extensionOperationsEnabled(): boolean | cdktf.IResolvable;
    set extensionOperationsEnabled(value: boolean | cdktf.IResolvable);
    resetExtensionOperationsEnabled(): void;
    get extensionOperationsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _extensionsTimeBudget?;
    get extensionsTimeBudget(): string;
    set extensionsTimeBudget(value: string);
    resetExtensionsTimeBudget(): void;
    get extensionsTimeBudgetInput(): string | undefined;
    private _healthProbeId?;
    get healthProbeId(): string;
    set healthProbeId(value: string);
    resetHealthProbeId(): void;
    get healthProbeIdInput(): string | undefined;
    private _hostGroupId?;
    get hostGroupId(): string;
    set hostGroupId(value: string);
    resetHostGroupId(): void;
    get hostGroupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instances?;
    get instances(): number;
    set instances(value: number);
    resetInstances(): void;
    get instancesInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxBidPrice?;
    get maxBidPrice(): number;
    set maxBidPrice(value: number);
    resetMaxBidPrice(): void;
    get maxBidPriceInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _overprovision?;
    get overprovision(): boolean | cdktf.IResolvable;
    set overprovision(value: boolean | cdktf.IResolvable);
    resetOverprovision(): void;
    get overprovisionInput(): boolean | cdktf.IResolvable | undefined;
    private _platformFaultDomainCount?;
    get platformFaultDomainCount(): number;
    set platformFaultDomainCount(value: number);
    resetPlatformFaultDomainCount(): void;
    get platformFaultDomainCountInput(): number | undefined;
    private _priority?;
    get priority(): string;
    set priority(value: string);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scaleInPolicy?;
    get scaleInPolicy(): string;
    set scaleInPolicy(value: string);
    resetScaleInPolicy(): void;
    get scaleInPolicyInput(): string | undefined;
    private _secureBootEnabled?;
    get secureBootEnabled(): boolean | cdktf.IResolvable;
    set secureBootEnabled(value: boolean | cdktf.IResolvable);
    resetSecureBootEnabled(): void;
    get secureBootEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _singlePlacementGroup?;
    get singlePlacementGroup(): boolean | cdktf.IResolvable;
    set singlePlacementGroup(value: boolean | cdktf.IResolvable);
    resetSinglePlacementGroup(): void;
    get singlePlacementGroupInput(): boolean | cdktf.IResolvable | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _sourceImageId?;
    get sourceImageId(): string;
    set sourceImageId(value: string);
    resetSourceImageId(): void;
    get sourceImageIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get uniqueId(): string;
    private _upgradeMode?;
    get upgradeMode(): string;
    set upgradeMode(value: string);
    resetUpgradeMode(): void;
    get upgradeModeInput(): string | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
    private _vtpmEnabled?;
    get vtpmEnabled(): boolean | cdktf.IResolvable;
    set vtpmEnabled(value: boolean | cdktf.IResolvable);
    resetVtpmEnabled(): void;
    get vtpmEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zoneBalance?;
    get zoneBalance(): boolean | cdktf.IResolvable;
    set zoneBalance(value: boolean | cdktf.IResolvable);
    resetZoneBalance(): void;
    get zoneBalanceInput(): boolean | cdktf.IResolvable | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _additionalCapabilities;
    get additionalCapabilities(): LinuxVirtualMachineScaleSetAdditionalCapabilitiesOutputReference;
    putAdditionalCapabilities(value: LinuxVirtualMachineScaleSetAdditionalCapabilities): void;
    resetAdditionalCapabilities(): void;
    get additionalCapabilitiesInput(): LinuxVirtualMachineScaleSetAdditionalCapabilities | undefined;
    private _adminSshKey;
    get adminSshKey(): LinuxVirtualMachineScaleSetAdminSshKeyList;
    putAdminSshKey(value: LinuxVirtualMachineScaleSetAdminSshKey[] | cdktf.IResolvable): void;
    resetAdminSshKey(): void;
    get adminSshKeyInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetAdminSshKey[] | undefined;
    private _automaticInstanceRepair;
    get automaticInstanceRepair(): LinuxVirtualMachineScaleSetAutomaticInstanceRepairOutputReference;
    putAutomaticInstanceRepair(value: LinuxVirtualMachineScaleSetAutomaticInstanceRepair): void;
    resetAutomaticInstanceRepair(): void;
    get automaticInstanceRepairInput(): LinuxVirtualMachineScaleSetAutomaticInstanceRepair | undefined;
    private _automaticOsUpgradePolicy;
    get automaticOsUpgradePolicy(): LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicyOutputReference;
    putAutomaticOsUpgradePolicy(value: LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy): void;
    resetAutomaticOsUpgradePolicy(): void;
    get automaticOsUpgradePolicyInput(): LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): LinuxVirtualMachineScaleSetBootDiagnosticsOutputReference;
    putBootDiagnostics(value: LinuxVirtualMachineScaleSetBootDiagnostics): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): LinuxVirtualMachineScaleSetBootDiagnostics | undefined;
    private _dataDisk;
    get dataDisk(): LinuxVirtualMachineScaleSetDataDiskList;
    putDataDisk(value: LinuxVirtualMachineScaleSetDataDisk[] | cdktf.IResolvable): void;
    resetDataDisk(): void;
    get dataDiskInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetDataDisk[] | undefined;
    private _extension;
    get extension(): LinuxVirtualMachineScaleSetExtensionList;
    putExtension(value: LinuxVirtualMachineScaleSetExtension[] | cdktf.IResolvable): void;
    resetExtension(): void;
    get extensionInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetExtension[] | undefined;
    private _galleryApplication;
    get galleryApplication(): LinuxVirtualMachineScaleSetGalleryApplicationList;
    putGalleryApplication(value: LinuxVirtualMachineScaleSetGalleryApplication[] | cdktf.IResolvable): void;
    resetGalleryApplication(): void;
    get galleryApplicationInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetGalleryApplication[] | undefined;
    private _galleryApplications;
    get galleryApplications(): LinuxVirtualMachineScaleSetGalleryApplicationsList;
    putGalleryApplications(value: LinuxVirtualMachineScaleSetGalleryApplications[] | cdktf.IResolvable): void;
    resetGalleryApplications(): void;
    get galleryApplicationsInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetGalleryApplications[] | undefined;
    private _identity;
    get identity(): LinuxVirtualMachineScaleSetIdentityOutputReference;
    putIdentity(value: LinuxVirtualMachineScaleSetIdentity): void;
    resetIdentity(): void;
    get identityInput(): LinuxVirtualMachineScaleSetIdentity | undefined;
    private _networkInterface;
    get networkInterface(): LinuxVirtualMachineScaleSetNetworkInterfaceList;
    putNetworkInterface(value: LinuxVirtualMachineScaleSetNetworkInterface[] | cdktf.IResolvable): void;
    get networkInterfaceInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetNetworkInterface[] | undefined;
    private _osDisk;
    get osDisk(): LinuxVirtualMachineScaleSetOsDiskOutputReference;
    putOsDisk(value: LinuxVirtualMachineScaleSetOsDisk): void;
    get osDiskInput(): LinuxVirtualMachineScaleSetOsDisk | undefined;
    private _plan;
    get plan(): LinuxVirtualMachineScaleSetPlanOutputReference;
    putPlan(value: LinuxVirtualMachineScaleSetPlan): void;
    resetPlan(): void;
    get planInput(): LinuxVirtualMachineScaleSetPlan | undefined;
    private _rollingUpgradePolicy;
    get rollingUpgradePolicy(): LinuxVirtualMachineScaleSetRollingUpgradePolicyOutputReference;
    putRollingUpgradePolicy(value: LinuxVirtualMachineScaleSetRollingUpgradePolicy): void;
    resetRollingUpgradePolicy(): void;
    get rollingUpgradePolicyInput(): LinuxVirtualMachineScaleSetRollingUpgradePolicy | undefined;
    private _scaleIn;
    get scaleIn(): LinuxVirtualMachineScaleSetScaleInOutputReference;
    putScaleIn(value: LinuxVirtualMachineScaleSetScaleIn): void;
    resetScaleIn(): void;
    get scaleInInput(): LinuxVirtualMachineScaleSetScaleIn | undefined;
    private _secret;
    get secret(): LinuxVirtualMachineScaleSetSecretList;
    putSecret(value: LinuxVirtualMachineScaleSetSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetSecret[] | undefined;
    private _sourceImageReference;
    get sourceImageReference(): LinuxVirtualMachineScaleSetSourceImageReferenceOutputReference;
    putSourceImageReference(value: LinuxVirtualMachineScaleSetSourceImageReference): void;
    resetSourceImageReference(): void;
    get sourceImageReferenceInput(): LinuxVirtualMachineScaleSetSourceImageReference | undefined;
    private _spotRestore;
    get spotRestore(): LinuxVirtualMachineScaleSetSpotRestoreOutputReference;
    putSpotRestore(value: LinuxVirtualMachineScaleSetSpotRestore): void;
    resetSpotRestore(): void;
    get spotRestoreInput(): LinuxVirtualMachineScaleSetSpotRestore | undefined;
    private _terminateNotification;
    get terminateNotification(): LinuxVirtualMachineScaleSetTerminateNotificationOutputReference;
    putTerminateNotification(value: LinuxVirtualMachineScaleSetTerminateNotification): void;
    resetTerminateNotification(): void;
    get terminateNotificationInput(): LinuxVirtualMachineScaleSetTerminateNotification | undefined;
    private _terminationNotification;
    get terminationNotification(): LinuxVirtualMachineScaleSetTerminationNotificationOutputReference;
    putTerminationNotification(value: LinuxVirtualMachineScaleSetTerminationNotification): void;
    resetTerminationNotification(): void;
    get terminationNotificationInput(): LinuxVirtualMachineScaleSetTerminationNotification | undefined;
    private _timeouts;
    get timeouts(): LinuxVirtualMachineScaleSetTimeoutsOutputReference;
    putTimeouts(value: LinuxVirtualMachineScaleSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LinuxVirtualMachineScaleSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
