import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaContentKeyPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#description MediaContentKeyPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#id MediaContentKeyPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#media_services_account_name MediaContentKeyPolicy#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#name MediaContentKeyPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#resource_group_name MediaContentKeyPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * policy_option block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#policy_option MediaContentKeyPolicy#policy_option}
    */
    readonly policyOption: MediaContentKeyPolicyPolicyOption[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#timeouts MediaContentKeyPolicy#timeouts}
    */
    readonly timeouts?: MediaContentKeyPolicyTimeouts;
}
export interface MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#playback_duration_seconds MediaContentKeyPolicy#playback_duration_seconds}
    */
    readonly playbackDurationSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#storage_duration_seconds MediaContentKeyPolicy#storage_duration_seconds}
    */
    readonly storageDurationSeconds?: number;
}
export declare function mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct?: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference | MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration): any;
export declare class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration | undefined);
    private _playbackDurationSeconds?;
    get playbackDurationSeconds(): number;
    set playbackDurationSeconds(value: number);
    resetPlaybackDurationSeconds(): void;
    get playbackDurationSecondsInput(): number | undefined;
    private _storageDurationSeconds?;
    get storageDurationSeconds(): number;
    set storageDurationSeconds(value: number);
    resetStorageDurationSeconds(): void;
    get storageDurationSecondsInput(): number | undefined;
}
export interface MediaContentKeyPolicyPolicyOptionFairplayConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#ask MediaContentKeyPolicy#ask}
    */
    readonly ask?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#pfx MediaContentKeyPolicy#pfx}
    */
    readonly pfx?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#pfx_password MediaContentKeyPolicy#pfx_password}
    */
    readonly pfxPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#rental_and_lease_key_type MediaContentKeyPolicy#rental_and_lease_key_type}
    */
    readonly rentalAndLeaseKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#rental_duration_seconds MediaContentKeyPolicy#rental_duration_seconds}
    */
    readonly rentalDurationSeconds?: number;
    /**
    * offline_rental_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#offline_rental_configuration MediaContentKeyPolicy#offline_rental_configuration}
    */
    readonly offlineRentalConfiguration?: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration;
}
export declare function mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct?: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference | MediaContentKeyPolicyPolicyOptionFairplayConfiguration): any;
export declare class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaContentKeyPolicyPolicyOptionFairplayConfiguration | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOptionFairplayConfiguration | undefined);
    private _ask?;
    get ask(): string;
    set ask(value: string);
    resetAsk(): void;
    get askInput(): string | undefined;
    private _pfx?;
    get pfx(): string;
    set pfx(value: string);
    resetPfx(): void;
    get pfxInput(): string | undefined;
    private _pfxPassword?;
    get pfxPassword(): string;
    set pfxPassword(value: string);
    resetPfxPassword(): void;
    get pfxPasswordInput(): string | undefined;
    private _rentalAndLeaseKeyType?;
    get rentalAndLeaseKeyType(): string;
    set rentalAndLeaseKeyType(value: string);
    resetRentalAndLeaseKeyType(): void;
    get rentalAndLeaseKeyTypeInput(): string | undefined;
    private _rentalDurationSeconds?;
    get rentalDurationSeconds(): number;
    set rentalDurationSeconds(value: number);
    resetRentalDurationSeconds(): void;
    get rentalDurationSecondsInput(): number | undefined;
    private _offlineRentalConfiguration;
    get offlineRentalConfiguration(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference;
    putOfflineRentalConfiguration(value: MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration): void;
    resetOfflineRentalConfiguration(): void;
    get offlineRentalConfigurationInput(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfiguration | undefined;
}
export interface MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#agc_and_color_stripe_restriction MediaContentKeyPolicy#agc_and_color_stripe_restriction}
    */
    readonly agcAndColorStripeRestriction?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#allow_passing_video_content_to_unknown_output MediaContentKeyPolicy#allow_passing_video_content_to_unknown_output}
    */
    readonly allowPassingVideoContentToUnknownOutput?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#analog_video_opl MediaContentKeyPolicy#analog_video_opl}
    */
    readonly analogVideoOpl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#compressed_digital_audio_opl MediaContentKeyPolicy#compressed_digital_audio_opl}
    */
    readonly compressedDigitalAudioOpl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#digital_video_only_content_restriction MediaContentKeyPolicy#digital_video_only_content_restriction}
    */
    readonly digitalVideoOnlyContentRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#first_play_expiration MediaContentKeyPolicy#first_play_expiration}
    */
    readonly firstPlayExpiration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#image_constraint_for_analog_component_video_restriction MediaContentKeyPolicy#image_constraint_for_analog_component_video_restriction}
    */
    readonly imageConstraintForAnalogComponentVideoRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#image_constraint_for_analog_computer_monitor_restriction MediaContentKeyPolicy#image_constraint_for_analog_computer_monitor_restriction}
    */
    readonly imageConstraintForAnalogComputerMonitorRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#scms_restriction MediaContentKeyPolicy#scms_restriction}
    */
    readonly scmsRestriction?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#uncompressed_digital_audio_opl MediaContentKeyPolicy#uncompressed_digital_audio_opl}
    */
    readonly uncompressedDigitalAudioOpl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#uncompressed_digital_video_opl MediaContentKeyPolicy#uncompressed_digital_video_opl}
    */
    readonly uncompressedDigitalVideoOpl?: number;
}
export declare function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference | MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight): any;
export declare class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight | undefined);
    private _agcAndColorStripeRestriction?;
    get agcAndColorStripeRestriction(): number;
    set agcAndColorStripeRestriction(value: number);
    resetAgcAndColorStripeRestriction(): void;
    get agcAndColorStripeRestrictionInput(): number | undefined;
    private _allowPassingVideoContentToUnknownOutput?;
    get allowPassingVideoContentToUnknownOutput(): string;
    set allowPassingVideoContentToUnknownOutput(value: string);
    resetAllowPassingVideoContentToUnknownOutput(): void;
    get allowPassingVideoContentToUnknownOutputInput(): string | undefined;
    private _analogVideoOpl?;
    get analogVideoOpl(): number;
    set analogVideoOpl(value: number);
    resetAnalogVideoOpl(): void;
    get analogVideoOplInput(): number | undefined;
    private _compressedDigitalAudioOpl?;
    get compressedDigitalAudioOpl(): number;
    set compressedDigitalAudioOpl(value: number);
    resetCompressedDigitalAudioOpl(): void;
    get compressedDigitalAudioOplInput(): number | undefined;
    private _digitalVideoOnlyContentRestriction?;
    get digitalVideoOnlyContentRestriction(): boolean | cdktf.IResolvable;
    set digitalVideoOnlyContentRestriction(value: boolean | cdktf.IResolvable);
    resetDigitalVideoOnlyContentRestriction(): void;
    get digitalVideoOnlyContentRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _firstPlayExpiration?;
    get firstPlayExpiration(): string;
    set firstPlayExpiration(value: string);
    resetFirstPlayExpiration(): void;
    get firstPlayExpirationInput(): string | undefined;
    private _imageConstraintForAnalogComponentVideoRestriction?;
    get imageConstraintForAnalogComponentVideoRestriction(): boolean | cdktf.IResolvable;
    set imageConstraintForAnalogComponentVideoRestriction(value: boolean | cdktf.IResolvable);
    resetImageConstraintForAnalogComponentVideoRestriction(): void;
    get imageConstraintForAnalogComponentVideoRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _imageConstraintForAnalogComputerMonitorRestriction?;
    get imageConstraintForAnalogComputerMonitorRestriction(): boolean | cdktf.IResolvable;
    set imageConstraintForAnalogComputerMonitorRestriction(value: boolean | cdktf.IResolvable);
    resetImageConstraintForAnalogComputerMonitorRestriction(): void;
    get imageConstraintForAnalogComputerMonitorRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _scmsRestriction?;
    get scmsRestriction(): number;
    set scmsRestriction(value: number);
    resetScmsRestriction(): void;
    get scmsRestrictionInput(): number | undefined;
    private _uncompressedDigitalAudioOpl?;
    get uncompressedDigitalAudioOpl(): number;
    set uncompressedDigitalAudioOpl(value: number);
    resetUncompressedDigitalAudioOpl(): void;
    get uncompressedDigitalAudioOplInput(): number | undefined;
    private _uncompressedDigitalVideoOpl?;
    get uncompressedDigitalVideoOpl(): number;
    set uncompressedDigitalVideoOpl(value: number);
    resetUncompressedDigitalVideoOpl(): void;
    get uncompressedDigitalVideoOplInput(): number | undefined;
}
export interface MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#allow_test_devices MediaContentKeyPolicy#allow_test_devices}
    */
    readonly allowTestDevices?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#begin_date MediaContentKeyPolicy#begin_date}
    */
    readonly beginDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#content_key_location_from_header_enabled MediaContentKeyPolicy#content_key_location_from_header_enabled}
    */
    readonly contentKeyLocationFromHeaderEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#content_key_location_from_key_id MediaContentKeyPolicy#content_key_location_from_key_id}
    */
    readonly contentKeyLocationFromKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#content_type MediaContentKeyPolicy#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#expiration_date MediaContentKeyPolicy#expiration_date}
    */
    readonly expirationDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#grace_period MediaContentKeyPolicy#grace_period}
    */
    readonly gracePeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#license_type MediaContentKeyPolicy#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#relative_begin_date MediaContentKeyPolicy#relative_begin_date}
    */
    readonly relativeBeginDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#relative_expiration_date MediaContentKeyPolicy#relative_expiration_date}
    */
    readonly relativeExpirationDate?: string;
    /**
    * play_right block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#play_right MediaContentKeyPolicy#play_right}
    */
    readonly playRight?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight;
}
export declare function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform(struct?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense | cdktf.IResolvable): any;
export declare class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense | cdktf.IResolvable | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense | cdktf.IResolvable | undefined);
    private _allowTestDevices?;
    get allowTestDevices(): boolean | cdktf.IResolvable;
    set allowTestDevices(value: boolean | cdktf.IResolvable);
    resetAllowTestDevices(): void;
    get allowTestDevicesInput(): boolean | cdktf.IResolvable | undefined;
    private _beginDate?;
    get beginDate(): string;
    set beginDate(value: string);
    resetBeginDate(): void;
    get beginDateInput(): string | undefined;
    private _contentKeyLocationFromHeaderEnabled?;
    get contentKeyLocationFromHeaderEnabled(): boolean | cdktf.IResolvable;
    set contentKeyLocationFromHeaderEnabled(value: boolean | cdktf.IResolvable);
    resetContentKeyLocationFromHeaderEnabled(): void;
    get contentKeyLocationFromHeaderEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _contentKeyLocationFromKeyId?;
    get contentKeyLocationFromKeyId(): string;
    set contentKeyLocationFromKeyId(value: string);
    resetContentKeyLocationFromKeyId(): void;
    get contentKeyLocationFromKeyIdInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _expirationDate?;
    get expirationDate(): string;
    set expirationDate(value: string);
    resetExpirationDate(): void;
    get expirationDateInput(): string | undefined;
    private _gracePeriod?;
    get gracePeriod(): string;
    set gracePeriod(value: string);
    resetGracePeriod(): void;
    get gracePeriodInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _relativeBeginDate?;
    get relativeBeginDate(): string;
    set relativeBeginDate(value: string);
    resetRelativeBeginDate(): void;
    get relativeBeginDateInput(): string | undefined;
    private _relativeExpirationDate?;
    get relativeExpirationDate(): string;
    set relativeExpirationDate(value: string);
    resetRelativeExpirationDate(): void;
    get relativeExpirationDateInput(): string | undefined;
    private _playRight;
    get playRight(): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference;
    putPlayRight(value: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight): void;
    resetPlayRight(): void;
    get playRightInput(): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRight | undefined;
}
export declare class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseOutputReference;
}
export interface MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#type MediaContentKeyPolicy#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#value MediaContentKeyPolicy#value}
    */
    readonly value?: string;
}
export declare function mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform(struct?: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim | cdktf.IResolvable): any;
export declare class MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim | cdktf.IResolvable | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimOutputReference;
}
export interface MediaContentKeyPolicyPolicyOptionTokenRestriction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#audience MediaContentKeyPolicy#audience}
    */
    readonly audience?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#issuer MediaContentKeyPolicy#issuer}
    */
    readonly issuer?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#open_id_connect_discovery_document MediaContentKeyPolicy#open_id_connect_discovery_document}
    */
    readonly openIdConnectDiscoveryDocument?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_rsa_token_key_exponent MediaContentKeyPolicy#primary_rsa_token_key_exponent}
    */
    readonly primaryRsaTokenKeyExponent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_rsa_token_key_modulus MediaContentKeyPolicy#primary_rsa_token_key_modulus}
    */
    readonly primaryRsaTokenKeyModulus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_symmetric_token_key MediaContentKeyPolicy#primary_symmetric_token_key}
    */
    readonly primarySymmetricTokenKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#primary_x509_token_key_raw MediaContentKeyPolicy#primary_x509_token_key_raw}
    */
    readonly primaryX509TokenKeyRaw?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#token_type MediaContentKeyPolicy#token_type}
    */
    readonly tokenType?: string;
    /**
    * required_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#required_claim MediaContentKeyPolicy#required_claim}
    */
    readonly requiredClaim?: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[] | cdktf.IResolvable;
}
export declare function mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct?: MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference | MediaContentKeyPolicyPolicyOptionTokenRestriction): any;
export declare class MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaContentKeyPolicyPolicyOptionTokenRestriction | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOptionTokenRestriction | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _openIdConnectDiscoveryDocument?;
    get openIdConnectDiscoveryDocument(): string;
    set openIdConnectDiscoveryDocument(value: string);
    resetOpenIdConnectDiscoveryDocument(): void;
    get openIdConnectDiscoveryDocumentInput(): string | undefined;
    private _primaryRsaTokenKeyExponent?;
    get primaryRsaTokenKeyExponent(): string;
    set primaryRsaTokenKeyExponent(value: string);
    resetPrimaryRsaTokenKeyExponent(): void;
    get primaryRsaTokenKeyExponentInput(): string | undefined;
    private _primaryRsaTokenKeyModulus?;
    get primaryRsaTokenKeyModulus(): string;
    set primaryRsaTokenKeyModulus(value: string);
    resetPrimaryRsaTokenKeyModulus(): void;
    get primaryRsaTokenKeyModulusInput(): string | undefined;
    private _primarySymmetricTokenKey?;
    get primarySymmetricTokenKey(): string;
    set primarySymmetricTokenKey(value: string);
    resetPrimarySymmetricTokenKey(): void;
    get primarySymmetricTokenKeyInput(): string | undefined;
    private _primaryX509TokenKeyRaw?;
    get primaryX509TokenKeyRaw(): string;
    set primaryX509TokenKeyRaw(value: string);
    resetPrimaryX509TokenKeyRaw(): void;
    get primaryX509TokenKeyRawInput(): string | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    private _requiredClaim;
    get requiredClaim(): MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimList;
    putRequiredClaim(value: MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[] | cdktf.IResolvable): void;
    resetRequiredClaim(): void;
    get requiredClaimInput(): cdktf.IResolvable | MediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaim[] | undefined;
}
export interface MediaContentKeyPolicyPolicyOption {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#clear_key_configuration_enabled MediaContentKeyPolicy#clear_key_configuration_enabled}
    */
    readonly clearKeyConfigurationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#name MediaContentKeyPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#open_restriction_enabled MediaContentKeyPolicy#open_restriction_enabled}
    */
    readonly openRestrictionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#widevine_configuration_template MediaContentKeyPolicy#widevine_configuration_template}
    */
    readonly widevineConfigurationTemplate?: string;
    /**
    * fairplay_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#fairplay_configuration MediaContentKeyPolicy#fairplay_configuration}
    */
    readonly fairplayConfiguration?: MediaContentKeyPolicyPolicyOptionFairplayConfiguration;
    /**
    * playready_configuration_license block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#playready_configuration_license MediaContentKeyPolicy#playready_configuration_license}
    */
    readonly playreadyConfigurationLicense?: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense[] | cdktf.IResolvable;
    /**
    * token_restriction block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#token_restriction MediaContentKeyPolicy#token_restriction}
    */
    readonly tokenRestriction?: MediaContentKeyPolicyPolicyOptionTokenRestriction;
}
export declare function mediaContentKeyPolicyPolicyOptionToTerraform(struct?: MediaContentKeyPolicyPolicyOption | cdktf.IResolvable): any;
export declare class MediaContentKeyPolicyPolicyOptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaContentKeyPolicyPolicyOption | cdktf.IResolvable | undefined;
    set internalValue(value: MediaContentKeyPolicyPolicyOption | cdktf.IResolvable | undefined);
    private _clearKeyConfigurationEnabled?;
    get clearKeyConfigurationEnabled(): boolean | cdktf.IResolvable;
    set clearKeyConfigurationEnabled(value: boolean | cdktf.IResolvable);
    resetClearKeyConfigurationEnabled(): void;
    get clearKeyConfigurationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _openRestrictionEnabled?;
    get openRestrictionEnabled(): boolean | cdktf.IResolvable;
    set openRestrictionEnabled(value: boolean | cdktf.IResolvable);
    resetOpenRestrictionEnabled(): void;
    get openRestrictionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _widevineConfigurationTemplate?;
    get widevineConfigurationTemplate(): string;
    set widevineConfigurationTemplate(value: string);
    resetWidevineConfigurationTemplate(): void;
    get widevineConfigurationTemplateInput(): string | undefined;
    private _fairplayConfiguration;
    get fairplayConfiguration(): MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference;
    putFairplayConfiguration(value: MediaContentKeyPolicyPolicyOptionFairplayConfiguration): void;
    resetFairplayConfiguration(): void;
    get fairplayConfigurationInput(): MediaContentKeyPolicyPolicyOptionFairplayConfiguration | undefined;
    private _playreadyConfigurationLicense;
    get playreadyConfigurationLicense(): MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseList;
    putPlayreadyConfigurationLicense(value: MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense[] | cdktf.IResolvable): void;
    resetPlayreadyConfigurationLicense(): void;
    get playreadyConfigurationLicenseInput(): cdktf.IResolvable | MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicense[] | undefined;
    private _tokenRestriction;
    get tokenRestriction(): MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference;
    putTokenRestriction(value: MediaContentKeyPolicyPolicyOptionTokenRestriction): void;
    resetTokenRestriction(): void;
    get tokenRestrictionInput(): MediaContentKeyPolicyPolicyOptionTokenRestriction | undefined;
}
export declare class MediaContentKeyPolicyPolicyOptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaContentKeyPolicyPolicyOption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaContentKeyPolicyPolicyOptionOutputReference;
}
export interface MediaContentKeyPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#create MediaContentKeyPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#delete MediaContentKeyPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#read MediaContentKeyPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy#update MediaContentKeyPolicy#update}
    */
    readonly update?: string;
}
export declare function mediaContentKeyPolicyTimeoutsToTerraform(struct?: MediaContentKeyPolicyTimeoutsOutputReference | MediaContentKeyPolicyTimeouts | cdktf.IResolvable): any;
export declare class MediaContentKeyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaContentKeyPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaContentKeyPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy}
*/
export declare class MediaContentKeyPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_content_key_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaContentKeyPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MediaContentKeyPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _policyOption;
    get policyOption(): MediaContentKeyPolicyPolicyOptionList;
    putPolicyOption(value: MediaContentKeyPolicyPolicyOption[] | cdktf.IResolvable): void;
    get policyOptionInput(): cdktf.IResolvable | MediaContentKeyPolicyPolicyOption[] | undefined;
    private _timeouts;
    get timeouts(): MediaContentKeyPolicyTimeoutsOutputReference;
    putTimeouts(value: MediaContentKeyPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaContentKeyPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
