import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaStreamingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#default_content_key_policy_name MediaStreamingPolicy#default_content_key_policy_name}
    */
    readonly defaultContentKeyPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#id MediaStreamingPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#media_services_account_name MediaStreamingPolicy#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#name MediaStreamingPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#resource_group_name MediaStreamingPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * common_encryption_cbcs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#common_encryption_cbcs MediaStreamingPolicy#common_encryption_cbcs}
    */
    readonly commonEncryptionCbcs?: MediaStreamingPolicyCommonEncryptionCbcs;
    /**
    * common_encryption_cenc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#common_encryption_cenc MediaStreamingPolicy#common_encryption_cenc}
    */
    readonly commonEncryptionCenc?: MediaStreamingPolicyCommonEncryptionCenc;
    /**
    * no_encryption_enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#no_encryption_enabled_protocols MediaStreamingPolicy#no_encryption_enabled_protocols}
    */
    readonly noEncryptionEnabledProtocols?: MediaStreamingPolicyNoEncryptionEnabledProtocols;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#timeouts MediaStreamingPolicy#timeouts}
    */
    readonly timeouts?: MediaStreamingPolicyTimeouts;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#label MediaStreamingPolicy#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}
    */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#allow_persistent_license MediaStreamingPolicy#allow_persistent_license}
    */
    readonly allowPersistentLicense?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#custom_license_acquisition_url_template MediaStreamingPolicy#custom_license_acquisition_url_template}
    */
    readonly customLicenseAcquisitionUrlTemplate?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsDrmFairplayToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined);
    private _allowPersistentLicense?;
    get allowPersistentLicense(): boolean | cdktf.IResolvable;
    set allowPersistentLicense(value: boolean | cdktf.IResolvable);
    resetAllowPersistentLicense(): void;
    get allowPersistentLicenseInput(): boolean | cdktf.IResolvable | undefined;
    private _customLicenseAcquisitionUrlTemplate?;
    get customLicenseAcquisitionUrlTemplate(): string;
    set customLicenseAcquisitionUrlTemplate(value: string);
    resetCustomLicenseAcquisitionUrlTemplate(): void;
    get customLicenseAcquisitionUrlTemplateInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcs {
    /**
    * default_content_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
    */
    readonly defaultContentKey?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey;
    /**
    * drm_fairplay block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#drm_fairplay MediaStreamingPolicy#drm_fairplay}
    */
    readonly drmFairplay?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay;
    /**
    * enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
    */
    readonly enabledProtocols?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsOutputReference | MediaStreamingPolicyCommonEncryptionCbcs): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcs | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcs | undefined);
    private _defaultContentKey;
    get defaultContentKey(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference;
    putDefaultContentKey(value: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): void;
    resetDefaultContentKey(): void;
    get defaultContentKeyInput(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined;
    private _drmFairplay;
    get drmFairplay(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference;
    putDrmFairplay(value: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): void;
    resetDrmFairplay(): void;
    get drmFairplayInput(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined;
    private _enabledProtocols;
    get enabledProtocols(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference;
    putEnabledProtocols(value: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): void;
    resetEnabledProtocols(): void;
    get enabledProtocolsInput(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencDefaultContentKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#label MediaStreamingPolicy#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}
    */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): any;
export declare class MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencDrmPlayready {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#custom_attributes MediaStreamingPolicy#custom_attributes}
    */
    readonly customAttributes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#custom_license_acquisition_url_template MediaStreamingPolicy#custom_license_acquisition_url_template}
    */
    readonly customLicenseAcquisitionUrlTemplate?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencDrmPlayreadyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference | MediaStreamingPolicyCommonEncryptionCencDrmPlayready): any;
export declare class MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined);
    private _customAttributes?;
    get customAttributes(): string;
    set customAttributes(value: string);
    resetCustomAttributes(): void;
    get customAttributesInput(): string | undefined;
    private _customLicenseAcquisitionUrlTemplate?;
    get customLicenseAcquisitionUrlTemplate(): string;
    set customLicenseAcquisitionUrlTemplate(value: string);
    resetCustomLicenseAcquisitionUrlTemplate(): void;
    get customLicenseAcquisitionUrlTemplateInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCencEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): any;
export declare class MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCenc {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#drm_widevine_custom_license_acquisition_url_template MediaStreamingPolicy#drm_widevine_custom_license_acquisition_url_template}
    */
    readonly drmWidevineCustomLicenseAcquisitionUrlTemplate?: string;
    /**
    * default_content_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
    */
    readonly defaultContentKey?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey;
    /**
    * drm_playready block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#drm_playready MediaStreamingPolicy#drm_playready}
    */
    readonly drmPlayready?: MediaStreamingPolicyCommonEncryptionCencDrmPlayready;
    /**
    * enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
    */
    readonly enabledProtocols?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols;
}
export declare function mediaStreamingPolicyCommonEncryptionCencToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencOutputReference | MediaStreamingPolicyCommonEncryptionCenc): any;
export declare class MediaStreamingPolicyCommonEncryptionCencOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCenc | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCenc | undefined);
    private _drmWidevineCustomLicenseAcquisitionUrlTemplate?;
    get drmWidevineCustomLicenseAcquisitionUrlTemplate(): string;
    set drmWidevineCustomLicenseAcquisitionUrlTemplate(value: string);
    resetDrmWidevineCustomLicenseAcquisitionUrlTemplate(): void;
    get drmWidevineCustomLicenseAcquisitionUrlTemplateInput(): string | undefined;
    private _defaultContentKey;
    get defaultContentKey(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference;
    putDefaultContentKey(value: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): void;
    resetDefaultContentKey(): void;
    get defaultContentKeyInput(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined;
    private _drmPlayready;
    get drmPlayready(): MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference;
    putDrmPlayready(value: MediaStreamingPolicyCommonEncryptionCencDrmPlayready): void;
    resetDrmPlayready(): void;
    get drmPlayreadyInput(): MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined;
    private _enabledProtocols;
    get enabledProtocols(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference;
    putEnabledProtocols(value: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): void;
    resetEnabledProtocols(): void;
    get enabledProtocolsInput(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined;
}
export interface MediaStreamingPolicyNoEncryptionEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyNoEncryptionEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference | MediaStreamingPolicyNoEncryptionEnabledProtocols): any;
export declare class MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#create MediaStreamingPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#delete MediaStreamingPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy#read MediaStreamingPolicy#read}
    */
    readonly read?: string;
}
export declare function mediaStreamingPolicyTimeoutsToTerraform(struct?: MediaStreamingPolicyTimeoutsOutputReference | MediaStreamingPolicyTimeouts | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy azurerm_media_streaming_policy}
*/
export declare class MediaStreamingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_streaming_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_streaming_policy azurerm_media_streaming_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaStreamingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MediaStreamingPolicyConfig);
    private _defaultContentKeyPolicyName?;
    get defaultContentKeyPolicyName(): string;
    set defaultContentKeyPolicyName(value: string);
    resetDefaultContentKeyPolicyName(): void;
    get defaultContentKeyPolicyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _commonEncryptionCbcs;
    get commonEncryptionCbcs(): MediaStreamingPolicyCommonEncryptionCbcsOutputReference;
    putCommonEncryptionCbcs(value: MediaStreamingPolicyCommonEncryptionCbcs): void;
    resetCommonEncryptionCbcs(): void;
    get commonEncryptionCbcsInput(): MediaStreamingPolicyCommonEncryptionCbcs | undefined;
    private _commonEncryptionCenc;
    get commonEncryptionCenc(): MediaStreamingPolicyCommonEncryptionCencOutputReference;
    putCommonEncryptionCenc(value: MediaStreamingPolicyCommonEncryptionCenc): void;
    resetCommonEncryptionCenc(): void;
    get commonEncryptionCencInput(): MediaStreamingPolicyCommonEncryptionCenc | undefined;
    private _noEncryptionEnabledProtocols;
    get noEncryptionEnabledProtocols(): MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference;
    putNoEncryptionEnabledProtocols(value: MediaStreamingPolicyNoEncryptionEnabledProtocols): void;
    resetNoEncryptionEnabledProtocols(): void;
    get noEncryptionEnabledProtocolsInput(): MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined;
    private _timeouts;
    get timeouts(): MediaStreamingPolicyTimeoutsOutputReference;
    putTimeouts(value: MediaStreamingPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaStreamingPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
