import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#access_tier StorageAccount#access_tier}
    */
    readonly accessTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#account_kind StorageAccount#account_kind}
    */
    readonly accountKind?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#account_replication_type StorageAccount#account_replication_type}
    */
    readonly accountReplicationType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#account_tier StorageAccount#account_tier}
    */
    readonly accountTier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allow_nested_items_to_be_public StorageAccount#allow_nested_items_to_be_public}
    */
    readonly allowNestedItemsToBePublic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cross_tenant_replication_enabled StorageAccount#cross_tenant_replication_enabled}
    */
    readonly crossTenantReplicationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#default_to_oauth_authentication StorageAccount#default_to_oauth_authentication}
    */
    readonly defaultToOauthAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#edge_zone StorageAccount#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#enable_https_traffic_only StorageAccount#enable_https_traffic_only}
    */
    readonly enableHttpsTrafficOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#id StorageAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#infrastructure_encryption_enabled StorageAccount#infrastructure_encryption_enabled}
    */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#is_hns_enabled StorageAccount#is_hns_enabled}
    */
    readonly isHnsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#large_file_share_enabled StorageAccount#large_file_share_enabled}
    */
    readonly largeFileShareEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#location StorageAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#min_tls_version StorageAccount#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#name StorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#nfsv3_enabled StorageAccount#nfsv3_enabled}
    */
    readonly nfsv3Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#public_network_access_enabled StorageAccount#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#queue_encryption_key_type StorageAccount#queue_encryption_key_type}
    */
    readonly queueEncryptionKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#resource_group_name StorageAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#shared_access_key_enabled StorageAccount#shared_access_key_enabled}
    */
    readonly sharedAccessKeyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#table_encryption_key_type StorageAccount#table_encryption_key_type}
    */
    readonly tableEncryptionKeyType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#tags StorageAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * azure_files_authentication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#azure_files_authentication StorageAccount#azure_files_authentication}
    */
    readonly azureFilesAuthentication?: StorageAccountAzureFilesAuthentication;
    /**
    * blob_properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#blob_properties StorageAccount#blob_properties}
    */
    readonly blobProperties?: StorageAccountBlobProperties;
    /**
    * custom_domain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#custom_domain StorageAccount#custom_domain}
    */
    readonly customDomain?: StorageAccountCustomDomain;
    /**
    * customer_managed_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#customer_managed_key StorageAccount#customer_managed_key}
    */
    readonly customerManagedKey?: StorageAccountCustomerManagedKey;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#identity StorageAccount#identity}
    */
    readonly identity?: StorageAccountIdentity;
    /**
    * immutability_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#immutability_policy StorageAccount#immutability_policy}
    */
    readonly immutabilityPolicy?: StorageAccountImmutabilityPolicy;
    /**
    * network_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#network_rules StorageAccount#network_rules}
    */
    readonly networkRules?: StorageAccountNetworkRules;
    /**
    * queue_properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#queue_properties StorageAccount#queue_properties}
    */
    readonly queueProperties?: StorageAccountQueueProperties;
    /**
    * routing block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#routing StorageAccount#routing}
    */
    readonly routing?: StorageAccountRouting;
    /**
    * share_properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#share_properties StorageAccount#share_properties}
    */
    readonly shareProperties?: StorageAccountShareProperties;
    /**
    * static_website block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#static_website StorageAccount#static_website}
    */
    readonly staticWebsite?: StorageAccountStaticWebsite;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#timeouts StorageAccount#timeouts}
    */
    readonly timeouts?: StorageAccountTimeouts;
}
export interface StorageAccountAzureFilesAuthenticationActiveDirectory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#domain_guid StorageAccount#domain_guid}
    */
    readonly domainGuid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#domain_name StorageAccount#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#domain_sid StorageAccount#domain_sid}
    */
    readonly domainSid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#forest_name StorageAccount#forest_name}
    */
    readonly forestName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#netbios_domain_name StorageAccount#netbios_domain_name}
    */
    readonly netbiosDomainName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#storage_sid StorageAccount#storage_sid}
    */
    readonly storageSid: string;
}
export declare function storageAccountAzureFilesAuthenticationActiveDirectoryToTerraform(struct?: StorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference | StorageAccountAzureFilesAuthenticationActiveDirectory): any;
export declare class StorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountAzureFilesAuthenticationActiveDirectory | undefined;
    set internalValue(value: StorageAccountAzureFilesAuthenticationActiveDirectory | undefined);
    private _domainGuid?;
    get domainGuid(): string;
    set domainGuid(value: string);
    get domainGuidInput(): string | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    private _domainSid?;
    get domainSid(): string;
    set domainSid(value: string);
    get domainSidInput(): string | undefined;
    private _forestName?;
    get forestName(): string;
    set forestName(value: string);
    get forestNameInput(): string | undefined;
    private _netbiosDomainName?;
    get netbiosDomainName(): string;
    set netbiosDomainName(value: string);
    get netbiosDomainNameInput(): string | undefined;
    private _storageSid?;
    get storageSid(): string;
    set storageSid(value: string);
    get storageSidInput(): string | undefined;
}
export interface StorageAccountAzureFilesAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#directory_type StorageAccount#directory_type}
    */
    readonly directoryType: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#active_directory StorageAccount#active_directory}
    */
    readonly activeDirectory?: StorageAccountAzureFilesAuthenticationActiveDirectory;
}
export declare function storageAccountAzureFilesAuthenticationToTerraform(struct?: StorageAccountAzureFilesAuthenticationOutputReference | StorageAccountAzureFilesAuthentication): any;
export declare class StorageAccountAzureFilesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountAzureFilesAuthentication | undefined;
    set internalValue(value: StorageAccountAzureFilesAuthentication | undefined);
    private _directoryType?;
    get directoryType(): string;
    set directoryType(value: string);
    get directoryTypeInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): StorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference;
    putActiveDirectory(value: StorageAccountAzureFilesAuthenticationActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): StorageAccountAzureFilesAuthenticationActiveDirectory | undefined;
}
export interface StorageAccountBlobPropertiesContainerDeleteRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#days StorageAccount#days}
    */
    readonly days?: number;
}
export declare function storageAccountBlobPropertiesContainerDeleteRetentionPolicyToTerraform(struct?: StorageAccountBlobPropertiesContainerDeleteRetentionPolicyOutputReference | StorageAccountBlobPropertiesContainerDeleteRetentionPolicy): any;
export declare class StorageAccountBlobPropertiesContainerDeleteRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountBlobPropertiesContainerDeleteRetentionPolicy | undefined;
    set internalValue(value: StorageAccountBlobPropertiesContainerDeleteRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
}
export interface StorageAccountBlobPropertiesCorsRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_headers StorageAccount#allowed_headers}
    */
    readonly allowedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_methods StorageAccount#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_origins StorageAccount#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#exposed_headers StorageAccount#exposed_headers}
    */
    readonly exposedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#max_age_in_seconds StorageAccount#max_age_in_seconds}
    */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountBlobPropertiesCorsRuleToTerraform(struct?: StorageAccountBlobPropertiesCorsRule | cdktf.IResolvable): any;
export declare class StorageAccountBlobPropertiesCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountBlobPropertiesCorsRule | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountBlobPropertiesCorsRule | cdktf.IResolvable | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    get maxAgeInSecondsInput(): number | undefined;
}
export declare class StorageAccountBlobPropertiesCorsRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountBlobPropertiesCorsRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountBlobPropertiesCorsRuleOutputReference;
}
export interface StorageAccountBlobPropertiesDeleteRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#days StorageAccount#days}
    */
    readonly days?: number;
}
export declare function storageAccountBlobPropertiesDeleteRetentionPolicyToTerraform(struct?: StorageAccountBlobPropertiesDeleteRetentionPolicyOutputReference | StorageAccountBlobPropertiesDeleteRetentionPolicy): any;
export declare class StorageAccountBlobPropertiesDeleteRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountBlobPropertiesDeleteRetentionPolicy | undefined;
    set internalValue(value: StorageAccountBlobPropertiesDeleteRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
}
export interface StorageAccountBlobProperties {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#change_feed_enabled StorageAccount#change_feed_enabled}
    */
    readonly changeFeedEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#change_feed_retention_in_days StorageAccount#change_feed_retention_in_days}
    */
    readonly changeFeedRetentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#default_service_version StorageAccount#default_service_version}
    */
    readonly defaultServiceVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#last_access_time_enabled StorageAccount#last_access_time_enabled}
    */
    readonly lastAccessTimeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#versioning_enabled StorageAccount#versioning_enabled}
    */
    readonly versioningEnabled?: boolean | cdktf.IResolvable;
    /**
    * container_delete_retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#container_delete_retention_policy StorageAccount#container_delete_retention_policy}
    */
    readonly containerDeleteRetentionPolicy?: StorageAccountBlobPropertiesContainerDeleteRetentionPolicy;
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cors_rule StorageAccount#cors_rule}
    */
    readonly corsRule?: StorageAccountBlobPropertiesCorsRule[] | cdktf.IResolvable;
    /**
    * delete_retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#delete_retention_policy StorageAccount#delete_retention_policy}
    */
    readonly deleteRetentionPolicy?: StorageAccountBlobPropertiesDeleteRetentionPolicy;
}
export declare function storageAccountBlobPropertiesToTerraform(struct?: StorageAccountBlobPropertiesOutputReference | StorageAccountBlobProperties): any;
export declare class StorageAccountBlobPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountBlobProperties | undefined;
    set internalValue(value: StorageAccountBlobProperties | undefined);
    private _changeFeedEnabled?;
    get changeFeedEnabled(): boolean | cdktf.IResolvable;
    set changeFeedEnabled(value: boolean | cdktf.IResolvable);
    resetChangeFeedEnabled(): void;
    get changeFeedEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _changeFeedRetentionInDays?;
    get changeFeedRetentionInDays(): number;
    set changeFeedRetentionInDays(value: number);
    resetChangeFeedRetentionInDays(): void;
    get changeFeedRetentionInDaysInput(): number | undefined;
    private _defaultServiceVersion?;
    get defaultServiceVersion(): string;
    set defaultServiceVersion(value: string);
    resetDefaultServiceVersion(): void;
    get defaultServiceVersionInput(): string | undefined;
    private _lastAccessTimeEnabled?;
    get lastAccessTimeEnabled(): boolean | cdktf.IResolvable;
    set lastAccessTimeEnabled(value: boolean | cdktf.IResolvable);
    resetLastAccessTimeEnabled(): void;
    get lastAccessTimeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _versioningEnabled?;
    get versioningEnabled(): boolean | cdktf.IResolvable;
    set versioningEnabled(value: boolean | cdktf.IResolvable);
    resetVersioningEnabled(): void;
    get versioningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _containerDeleteRetentionPolicy;
    get containerDeleteRetentionPolicy(): StorageAccountBlobPropertiesContainerDeleteRetentionPolicyOutputReference;
    putContainerDeleteRetentionPolicy(value: StorageAccountBlobPropertiesContainerDeleteRetentionPolicy): void;
    resetContainerDeleteRetentionPolicy(): void;
    get containerDeleteRetentionPolicyInput(): StorageAccountBlobPropertiesContainerDeleteRetentionPolicy | undefined;
    private _corsRule;
    get corsRule(): StorageAccountBlobPropertiesCorsRuleList;
    putCorsRule(value: StorageAccountBlobPropertiesCorsRule[] | cdktf.IResolvable): void;
    resetCorsRule(): void;
    get corsRuleInput(): cdktf.IResolvable | StorageAccountBlobPropertiesCorsRule[] | undefined;
    private _deleteRetentionPolicy;
    get deleteRetentionPolicy(): StorageAccountBlobPropertiesDeleteRetentionPolicyOutputReference;
    putDeleteRetentionPolicy(value: StorageAccountBlobPropertiesDeleteRetentionPolicy): void;
    resetDeleteRetentionPolicy(): void;
    get deleteRetentionPolicyInput(): StorageAccountBlobPropertiesDeleteRetentionPolicy | undefined;
}
export interface StorageAccountCustomDomain {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#name StorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#use_subdomain StorageAccount#use_subdomain}
    */
    readonly useSubdomain?: boolean | cdktf.IResolvable;
}
export declare function storageAccountCustomDomainToTerraform(struct?: StorageAccountCustomDomainOutputReference | StorageAccountCustomDomain): any;
export declare class StorageAccountCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountCustomDomain | undefined;
    set internalValue(value: StorageAccountCustomDomain | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useSubdomain?;
    get useSubdomain(): boolean | cdktf.IResolvable;
    set useSubdomain(value: boolean | cdktf.IResolvable);
    resetUseSubdomain(): void;
    get useSubdomainInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageAccountCustomerManagedKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#key_vault_key_id StorageAccount#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#user_assigned_identity_id StorageAccount#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId: string;
}
export declare function storageAccountCustomerManagedKeyToTerraform(struct?: StorageAccountCustomerManagedKeyOutputReference | StorageAccountCustomerManagedKey): any;
export declare class StorageAccountCustomerManagedKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountCustomerManagedKey | undefined;
    set internalValue(value: StorageAccountCustomerManagedKey | undefined);
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    get userAssignedIdentityIdInput(): string | undefined;
}
export interface StorageAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#identity_ids StorageAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#type StorageAccount#type}
    */
    readonly type: string;
}
export declare function storageAccountIdentityToTerraform(struct?: StorageAccountIdentityOutputReference | StorageAccountIdentity): any;
export declare class StorageAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountIdentity | undefined;
    set internalValue(value: StorageAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StorageAccountImmutabilityPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allow_protected_append_writes StorageAccount#allow_protected_append_writes}
    */
    readonly allowProtectedAppendWrites: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#period_since_creation_in_days StorageAccount#period_since_creation_in_days}
    */
    readonly periodSinceCreationInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#state StorageAccount#state}
    */
    readonly state: string;
}
export declare function storageAccountImmutabilityPolicyToTerraform(struct?: StorageAccountImmutabilityPolicyOutputReference | StorageAccountImmutabilityPolicy): any;
export declare class StorageAccountImmutabilityPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountImmutabilityPolicy | undefined;
    set internalValue(value: StorageAccountImmutabilityPolicy | undefined);
    private _allowProtectedAppendWrites?;
    get allowProtectedAppendWrites(): boolean | cdktf.IResolvable;
    set allowProtectedAppendWrites(value: boolean | cdktf.IResolvable);
    get allowProtectedAppendWritesInput(): boolean | cdktf.IResolvable | undefined;
    private _periodSinceCreationInDays?;
    get periodSinceCreationInDays(): number;
    set periodSinceCreationInDays(value: number);
    get periodSinceCreationInDaysInput(): number | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    get stateInput(): string | undefined;
}
export interface StorageAccountNetworkRulesPrivateLinkAccess {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#endpoint_resource_id StorageAccount#endpoint_resource_id}
    */
    readonly endpointResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#endpoint_tenant_id StorageAccount#endpoint_tenant_id}
    */
    readonly endpointTenantId?: string;
}
export declare function storageAccountNetworkRulesPrivateLinkAccessToTerraform(struct?: StorageAccountNetworkRulesPrivateLinkAccess | cdktf.IResolvable): any;
export declare class StorageAccountNetworkRulesPrivateLinkAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountNetworkRulesPrivateLinkAccess | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountNetworkRulesPrivateLinkAccess | cdktf.IResolvable | undefined);
    private _endpointResourceId?;
    get endpointResourceId(): string;
    set endpointResourceId(value: string);
    get endpointResourceIdInput(): string | undefined;
    private _endpointTenantId?;
    get endpointTenantId(): string;
    set endpointTenantId(value: string);
    resetEndpointTenantId(): void;
    get endpointTenantIdInput(): string | undefined;
}
export declare class StorageAccountNetworkRulesPrivateLinkAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountNetworkRulesPrivateLinkAccess[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountNetworkRulesPrivateLinkAccessOutputReference;
}
export interface StorageAccountNetworkRules {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#bypass StorageAccount#bypass}
    */
    readonly bypass?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#default_action StorageAccount#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#ip_rules StorageAccount#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#virtual_network_subnet_ids StorageAccount#virtual_network_subnet_ids}
    */
    readonly virtualNetworkSubnetIds?: string[];
    /**
    * private_link_access block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#private_link_access StorageAccount#private_link_access}
    */
    readonly privateLinkAccess?: StorageAccountNetworkRulesPrivateLinkAccess[] | cdktf.IResolvable;
}
export declare function storageAccountNetworkRulesToTerraform(struct?: StorageAccountNetworkRulesOutputReference | StorageAccountNetworkRules): any;
export declare class StorageAccountNetworkRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountNetworkRules | undefined;
    set internalValue(value: StorageAccountNetworkRules | undefined);
    private _bypass?;
    get bypass(): string[];
    set bypass(value: string[]);
    resetBypass(): void;
    get bypassInput(): string[] | undefined;
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _virtualNetworkSubnetIds?;
    get virtualNetworkSubnetIds(): string[];
    set virtualNetworkSubnetIds(value: string[]);
    resetVirtualNetworkSubnetIds(): void;
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
    private _privateLinkAccess;
    get privateLinkAccess(): StorageAccountNetworkRulesPrivateLinkAccessList;
    putPrivateLinkAccess(value: StorageAccountNetworkRulesPrivateLinkAccess[] | cdktf.IResolvable): void;
    resetPrivateLinkAccess(): void;
    get privateLinkAccessInput(): cdktf.IResolvable | StorageAccountNetworkRulesPrivateLinkAccess[] | undefined;
}
export interface StorageAccountQueuePropertiesCorsRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_headers StorageAccount#allowed_headers}
    */
    readonly allowedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_methods StorageAccount#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_origins StorageAccount#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#exposed_headers StorageAccount#exposed_headers}
    */
    readonly exposedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#max_age_in_seconds StorageAccount#max_age_in_seconds}
    */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountQueuePropertiesCorsRuleToTerraform(struct?: StorageAccountQueuePropertiesCorsRule | cdktf.IResolvable): any;
export declare class StorageAccountQueuePropertiesCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountQueuePropertiesCorsRule | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountQueuePropertiesCorsRule | cdktf.IResolvable | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    get maxAgeInSecondsInput(): number | undefined;
}
export declare class StorageAccountQueuePropertiesCorsRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountQueuePropertiesCorsRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountQueuePropertiesCorsRuleOutputReference;
}
export interface StorageAccountQueuePropertiesHourMetrics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#enabled StorageAccount#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#include_apis StorageAccount#include_apis}
    */
    readonly includeApis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy_days StorageAccount#retention_policy_days}
    */
    readonly retentionPolicyDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#version StorageAccount#version}
    */
    readonly version: string;
}
export declare function storageAccountQueuePropertiesHourMetricsToTerraform(struct?: StorageAccountQueuePropertiesHourMetricsOutputReference | StorageAccountQueuePropertiesHourMetrics): any;
export declare class StorageAccountQueuePropertiesHourMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesHourMetrics | undefined;
    set internalValue(value: StorageAccountQueuePropertiesHourMetrics | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _includeApis?;
    get includeApis(): boolean | cdktf.IResolvable;
    set includeApis(value: boolean | cdktf.IResolvable);
    resetIncludeApis(): void;
    get includeApisInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    get retentionPolicyDays(): number;
    set retentionPolicyDays(value: number);
    resetRetentionPolicyDays(): void;
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface StorageAccountQueuePropertiesLogging {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#delete StorageAccount#delete}
    */
    readonly delete: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#read StorageAccount#read}
    */
    readonly read: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy_days StorageAccount#retention_policy_days}
    */
    readonly retentionPolicyDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#version StorageAccount#version}
    */
    readonly version: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#write StorageAccount#write}
    */
    readonly write: boolean | cdktf.IResolvable;
}
export declare function storageAccountQueuePropertiesLoggingToTerraform(struct?: StorageAccountQueuePropertiesLoggingOutputReference | StorageAccountQueuePropertiesLogging): any;
export declare class StorageAccountQueuePropertiesLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesLogging | undefined;
    set internalValue(value: StorageAccountQueuePropertiesLogging | undefined);
    private _delete?;
    get delete(): boolean | cdktf.IResolvable;
    set delete(value: boolean | cdktf.IResolvable);
    get deleteInput(): boolean | cdktf.IResolvable | undefined;
    private _read?;
    get read(): boolean | cdktf.IResolvable;
    set read(value: boolean | cdktf.IResolvable);
    get readInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    get retentionPolicyDays(): number;
    set retentionPolicyDays(value: number);
    resetRetentionPolicyDays(): void;
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _write?;
    get write(): boolean | cdktf.IResolvable;
    set write(value: boolean | cdktf.IResolvable);
    get writeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageAccountQueuePropertiesMinuteMetrics {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#enabled StorageAccount#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#include_apis StorageAccount#include_apis}
    */
    readonly includeApis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy_days StorageAccount#retention_policy_days}
    */
    readonly retentionPolicyDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#version StorageAccount#version}
    */
    readonly version: string;
}
export declare function storageAccountQueuePropertiesMinuteMetricsToTerraform(struct?: StorageAccountQueuePropertiesMinuteMetricsOutputReference | StorageAccountQueuePropertiesMinuteMetrics): any;
export declare class StorageAccountQueuePropertiesMinuteMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueuePropertiesMinuteMetrics | undefined;
    set internalValue(value: StorageAccountQueuePropertiesMinuteMetrics | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _includeApis?;
    get includeApis(): boolean | cdktf.IResolvable;
    set includeApis(value: boolean | cdktf.IResolvable);
    resetIncludeApis(): void;
    get includeApisInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPolicyDays?;
    get retentionPolicyDays(): number;
    set retentionPolicyDays(value: number);
    resetRetentionPolicyDays(): void;
    get retentionPolicyDaysInput(): number | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface StorageAccountQueueProperties {
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cors_rule StorageAccount#cors_rule}
    */
    readonly corsRule?: StorageAccountQueuePropertiesCorsRule[] | cdktf.IResolvable;
    /**
    * hour_metrics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#hour_metrics StorageAccount#hour_metrics}
    */
    readonly hourMetrics?: StorageAccountQueuePropertiesHourMetrics;
    /**
    * logging block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#logging StorageAccount#logging}
    */
    readonly logging?: StorageAccountQueuePropertiesLogging;
    /**
    * minute_metrics block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#minute_metrics StorageAccount#minute_metrics}
    */
    readonly minuteMetrics?: StorageAccountQueuePropertiesMinuteMetrics;
}
export declare function storageAccountQueuePropertiesToTerraform(struct?: StorageAccountQueuePropertiesOutputReference | StorageAccountQueueProperties): any;
export declare class StorageAccountQueuePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountQueueProperties | undefined;
    set internalValue(value: StorageAccountQueueProperties | undefined);
    private _corsRule;
    get corsRule(): StorageAccountQueuePropertiesCorsRuleList;
    putCorsRule(value: StorageAccountQueuePropertiesCorsRule[] | cdktf.IResolvable): void;
    resetCorsRule(): void;
    get corsRuleInput(): cdktf.IResolvable | StorageAccountQueuePropertiesCorsRule[] | undefined;
    private _hourMetrics;
    get hourMetrics(): StorageAccountQueuePropertiesHourMetricsOutputReference;
    putHourMetrics(value: StorageAccountQueuePropertiesHourMetrics): void;
    resetHourMetrics(): void;
    get hourMetricsInput(): StorageAccountQueuePropertiesHourMetrics | undefined;
    private _logging;
    get logging(): StorageAccountQueuePropertiesLoggingOutputReference;
    putLogging(value: StorageAccountQueuePropertiesLogging): void;
    resetLogging(): void;
    get loggingInput(): StorageAccountQueuePropertiesLogging | undefined;
    private _minuteMetrics;
    get minuteMetrics(): StorageAccountQueuePropertiesMinuteMetricsOutputReference;
    putMinuteMetrics(value: StorageAccountQueuePropertiesMinuteMetrics): void;
    resetMinuteMetrics(): void;
    get minuteMetricsInput(): StorageAccountQueuePropertiesMinuteMetrics | undefined;
}
export interface StorageAccountRouting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#choice StorageAccount#choice}
    */
    readonly choice?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#publish_internet_endpoints StorageAccount#publish_internet_endpoints}
    */
    readonly publishInternetEndpoints?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#publish_microsoft_endpoints StorageAccount#publish_microsoft_endpoints}
    */
    readonly publishMicrosoftEndpoints?: boolean | cdktf.IResolvable;
}
export declare function storageAccountRoutingToTerraform(struct?: StorageAccountRoutingOutputReference | StorageAccountRouting): any;
export declare class StorageAccountRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountRouting | undefined;
    set internalValue(value: StorageAccountRouting | undefined);
    private _choice?;
    get choice(): string;
    set choice(value: string);
    resetChoice(): void;
    get choiceInput(): string | undefined;
    private _publishInternetEndpoints?;
    get publishInternetEndpoints(): boolean | cdktf.IResolvable;
    set publishInternetEndpoints(value: boolean | cdktf.IResolvable);
    resetPublishInternetEndpoints(): void;
    get publishInternetEndpointsInput(): boolean | cdktf.IResolvable | undefined;
    private _publishMicrosoftEndpoints?;
    get publishMicrosoftEndpoints(): boolean | cdktf.IResolvable;
    set publishMicrosoftEndpoints(value: boolean | cdktf.IResolvable);
    resetPublishMicrosoftEndpoints(): void;
    get publishMicrosoftEndpointsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageAccountSharePropertiesCorsRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_headers StorageAccount#allowed_headers}
    */
    readonly allowedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_methods StorageAccount#allowed_methods}
    */
    readonly allowedMethods: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#allowed_origins StorageAccount#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#exposed_headers StorageAccount#exposed_headers}
    */
    readonly exposedHeaders: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#max_age_in_seconds StorageAccount#max_age_in_seconds}
    */
    readonly maxAgeInSeconds: number;
}
export declare function storageAccountSharePropertiesCorsRuleToTerraform(struct?: StorageAccountSharePropertiesCorsRule | cdktf.IResolvable): any;
export declare class StorageAccountSharePropertiesCorsRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountSharePropertiesCorsRule | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountSharePropertiesCorsRule | cdktf.IResolvable | undefined);
    private _allowedHeaders?;
    get allowedHeaders(): string[];
    set allowedHeaders(value: string[]);
    get allowedHeadersInput(): string[] | undefined;
    private _allowedMethods?;
    get allowedMethods(): string[];
    set allowedMethods(value: string[]);
    get allowedMethodsInput(): string[] | undefined;
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _exposedHeaders?;
    get exposedHeaders(): string[];
    set exposedHeaders(value: string[]);
    get exposedHeadersInput(): string[] | undefined;
    private _maxAgeInSeconds?;
    get maxAgeInSeconds(): number;
    set maxAgeInSeconds(value: number);
    get maxAgeInSecondsInput(): number | undefined;
}
export declare class StorageAccountSharePropertiesCorsRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountSharePropertiesCorsRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountSharePropertiesCorsRuleOutputReference;
}
export interface StorageAccountSharePropertiesRetentionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#days StorageAccount#days}
    */
    readonly days?: number;
}
export declare function storageAccountSharePropertiesRetentionPolicyToTerraform(struct?: StorageAccountSharePropertiesRetentionPolicyOutputReference | StorageAccountSharePropertiesRetentionPolicy): any;
export declare class StorageAccountSharePropertiesRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountSharePropertiesRetentionPolicy | undefined;
    set internalValue(value: StorageAccountSharePropertiesRetentionPolicy | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
}
export interface StorageAccountSharePropertiesSmb {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#authentication_types StorageAccount#authentication_types}
    */
    readonly authenticationTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#channel_encryption_type StorageAccount#channel_encryption_type}
    */
    readonly channelEncryptionType?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#kerberos_ticket_encryption_type StorageAccount#kerberos_ticket_encryption_type}
    */
    readonly kerberosTicketEncryptionType?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#multichannel_enabled StorageAccount#multichannel_enabled}
    */
    readonly multichannelEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#versions StorageAccount#versions}
    */
    readonly versions?: string[];
}
export declare function storageAccountSharePropertiesSmbToTerraform(struct?: StorageAccountSharePropertiesSmbOutputReference | StorageAccountSharePropertiesSmb): any;
export declare class StorageAccountSharePropertiesSmbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountSharePropertiesSmb | undefined;
    set internalValue(value: StorageAccountSharePropertiesSmb | undefined);
    private _authenticationTypes?;
    get authenticationTypes(): string[];
    set authenticationTypes(value: string[]);
    resetAuthenticationTypes(): void;
    get authenticationTypesInput(): string[] | undefined;
    private _channelEncryptionType?;
    get channelEncryptionType(): string[];
    set channelEncryptionType(value: string[]);
    resetChannelEncryptionType(): void;
    get channelEncryptionTypeInput(): string[] | undefined;
    private _kerberosTicketEncryptionType?;
    get kerberosTicketEncryptionType(): string[];
    set kerberosTicketEncryptionType(value: string[]);
    resetKerberosTicketEncryptionType(): void;
    get kerberosTicketEncryptionTypeInput(): string[] | undefined;
    private _multichannelEnabled?;
    get multichannelEnabled(): boolean | cdktf.IResolvable;
    set multichannelEnabled(value: boolean | cdktf.IResolvable);
    resetMultichannelEnabled(): void;
    get multichannelEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _versions?;
    get versions(): string[];
    set versions(value: string[]);
    resetVersions(): void;
    get versionsInput(): string[] | undefined;
}
export interface StorageAccountShareProperties {
    /**
    * cors_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#cors_rule StorageAccount#cors_rule}
    */
    readonly corsRule?: StorageAccountSharePropertiesCorsRule[] | cdktf.IResolvable;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#retention_policy StorageAccount#retention_policy}
    */
    readonly retentionPolicy?: StorageAccountSharePropertiesRetentionPolicy;
    /**
    * smb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#smb StorageAccount#smb}
    */
    readonly smb?: StorageAccountSharePropertiesSmb;
}
export declare function storageAccountSharePropertiesToTerraform(struct?: StorageAccountSharePropertiesOutputReference | StorageAccountShareProperties): any;
export declare class StorageAccountSharePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountShareProperties | undefined;
    set internalValue(value: StorageAccountShareProperties | undefined);
    private _corsRule;
    get corsRule(): StorageAccountSharePropertiesCorsRuleList;
    putCorsRule(value: StorageAccountSharePropertiesCorsRule[] | cdktf.IResolvable): void;
    resetCorsRule(): void;
    get corsRuleInput(): cdktf.IResolvable | StorageAccountSharePropertiesCorsRule[] | undefined;
    private _retentionPolicy;
    get retentionPolicy(): StorageAccountSharePropertiesRetentionPolicyOutputReference;
    putRetentionPolicy(value: StorageAccountSharePropertiesRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): StorageAccountSharePropertiesRetentionPolicy | undefined;
    private _smb;
    get smb(): StorageAccountSharePropertiesSmbOutputReference;
    putSmb(value: StorageAccountSharePropertiesSmb): void;
    resetSmb(): void;
    get smbInput(): StorageAccountSharePropertiesSmb | undefined;
}
export interface StorageAccountStaticWebsite {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#error_404_document StorageAccount#error_404_document}
    */
    readonly error404Document?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#index_document StorageAccount#index_document}
    */
    readonly indexDocument?: string;
}
export declare function storageAccountStaticWebsiteToTerraform(struct?: StorageAccountStaticWebsiteOutputReference | StorageAccountStaticWebsite): any;
export declare class StorageAccountStaticWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountStaticWebsite | undefined;
    set internalValue(value: StorageAccountStaticWebsite | undefined);
    private _error404Document?;
    get error404Document(): string;
    set error404Document(value: string);
    resetError404Document(): void;
    get error404DocumentInput(): string | undefined;
    private _indexDocument?;
    get indexDocument(): string;
    set indexDocument(value: string);
    resetIndexDocument(): void;
    get indexDocumentInput(): string | undefined;
}
export interface StorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#create StorageAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#delete StorageAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#read StorageAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account#update StorageAccount#update}
    */
    readonly update?: string;
}
export declare function storageAccountTimeoutsToTerraform(struct?: StorageAccountTimeoutsOutputReference | StorageAccountTimeouts | cdktf.IResolvable): any;
export declare class StorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account azurerm_storage_account}
*/
export declare class StorageAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_account azurerm_storage_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: StorageAccountConfig);
    private _accessTier?;
    get accessTier(): string;
    set accessTier(value: string);
    resetAccessTier(): void;
    get accessTierInput(): string | undefined;
    private _accountKind?;
    get accountKind(): string;
    set accountKind(value: string);
    resetAccountKind(): void;
    get accountKindInput(): string | undefined;
    private _accountReplicationType?;
    get accountReplicationType(): string;
    set accountReplicationType(value: string);
    get accountReplicationTypeInput(): string | undefined;
    private _accountTier?;
    get accountTier(): string;
    set accountTier(value: string);
    get accountTierInput(): string | undefined;
    private _allowNestedItemsToBePublic?;
    get allowNestedItemsToBePublic(): boolean | cdktf.IResolvable;
    set allowNestedItemsToBePublic(value: boolean | cdktf.IResolvable);
    resetAllowNestedItemsToBePublic(): void;
    get allowNestedItemsToBePublicInput(): boolean | cdktf.IResolvable | undefined;
    private _crossTenantReplicationEnabled?;
    get crossTenantReplicationEnabled(): boolean | cdktf.IResolvable;
    set crossTenantReplicationEnabled(value: boolean | cdktf.IResolvable);
    resetCrossTenantReplicationEnabled(): void;
    get crossTenantReplicationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultToOauthAuthentication?;
    get defaultToOauthAuthentication(): boolean | cdktf.IResolvable;
    set defaultToOauthAuthentication(value: boolean | cdktf.IResolvable);
    resetDefaultToOauthAuthentication(): void;
    get defaultToOauthAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _enableHttpsTrafficOnly?;
    get enableHttpsTrafficOnly(): boolean | cdktf.IResolvable;
    set enableHttpsTrafficOnly(value: boolean | cdktf.IResolvable);
    resetEnableHttpsTrafficOnly(): void;
    get enableHttpsTrafficOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _infrastructureEncryptionEnabled?;
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetInfrastructureEncryptionEnabled(): void;
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isHnsEnabled?;
    get isHnsEnabled(): boolean | cdktf.IResolvable;
    set isHnsEnabled(value: boolean | cdktf.IResolvable);
    resetIsHnsEnabled(): void;
    get isHnsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _largeFileShareEnabled?;
    get largeFileShareEnabled(): boolean | cdktf.IResolvable;
    set largeFileShareEnabled(value: boolean | cdktf.IResolvable);
    resetLargeFileShareEnabled(): void;
    get largeFileShareEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nfsv3Enabled?;
    get nfsv3Enabled(): boolean | cdktf.IResolvable;
    set nfsv3Enabled(value: boolean | cdktf.IResolvable);
    resetNfsv3Enabled(): void;
    get nfsv3EnabledInput(): boolean | cdktf.IResolvable | undefined;
    get primaryAccessKey(): string;
    get primaryBlobConnectionString(): string;
    get primaryBlobEndpoint(): string;
    get primaryBlobHost(): string;
    get primaryConnectionString(): string;
    get primaryDfsEndpoint(): string;
    get primaryDfsHost(): string;
    get primaryFileEndpoint(): string;
    get primaryFileHost(): string;
    get primaryLocation(): string;
    get primaryQueueEndpoint(): string;
    get primaryQueueHost(): string;
    get primaryTableEndpoint(): string;
    get primaryTableHost(): string;
    get primaryWebEndpoint(): string;
    get primaryWebHost(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _queueEncryptionKeyType?;
    get queueEncryptionKeyType(): string;
    set queueEncryptionKeyType(value: string);
    resetQueueEncryptionKeyType(): void;
    get queueEncryptionKeyTypeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryBlobConnectionString(): string;
    get secondaryBlobEndpoint(): string;
    get secondaryBlobHost(): string;
    get secondaryConnectionString(): string;
    get secondaryDfsEndpoint(): string;
    get secondaryDfsHost(): string;
    get secondaryFileEndpoint(): string;
    get secondaryFileHost(): string;
    get secondaryLocation(): string;
    get secondaryQueueEndpoint(): string;
    get secondaryQueueHost(): string;
    get secondaryTableEndpoint(): string;
    get secondaryTableHost(): string;
    get secondaryWebEndpoint(): string;
    get secondaryWebHost(): string;
    private _sharedAccessKeyEnabled?;
    get sharedAccessKeyEnabled(): boolean | cdktf.IResolvable;
    set sharedAccessKeyEnabled(value: boolean | cdktf.IResolvable);
    resetSharedAccessKeyEnabled(): void;
    get sharedAccessKeyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tableEncryptionKeyType?;
    get tableEncryptionKeyType(): string;
    set tableEncryptionKeyType(value: string);
    resetTableEncryptionKeyType(): void;
    get tableEncryptionKeyTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _azureFilesAuthentication;
    get azureFilesAuthentication(): StorageAccountAzureFilesAuthenticationOutputReference;
    putAzureFilesAuthentication(value: StorageAccountAzureFilesAuthentication): void;
    resetAzureFilesAuthentication(): void;
    get azureFilesAuthenticationInput(): StorageAccountAzureFilesAuthentication | undefined;
    private _blobProperties;
    get blobProperties(): StorageAccountBlobPropertiesOutputReference;
    putBlobProperties(value: StorageAccountBlobProperties): void;
    resetBlobProperties(): void;
    get blobPropertiesInput(): StorageAccountBlobProperties | undefined;
    private _customDomain;
    get customDomain(): StorageAccountCustomDomainOutputReference;
    putCustomDomain(value: StorageAccountCustomDomain): void;
    resetCustomDomain(): void;
    get customDomainInput(): StorageAccountCustomDomain | undefined;
    private _customerManagedKey;
    get customerManagedKey(): StorageAccountCustomerManagedKeyOutputReference;
    putCustomerManagedKey(value: StorageAccountCustomerManagedKey): void;
    resetCustomerManagedKey(): void;
    get customerManagedKeyInput(): StorageAccountCustomerManagedKey | undefined;
    private _identity;
    get identity(): StorageAccountIdentityOutputReference;
    putIdentity(value: StorageAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): StorageAccountIdentity | undefined;
    private _immutabilityPolicy;
    get immutabilityPolicy(): StorageAccountImmutabilityPolicyOutputReference;
    putImmutabilityPolicy(value: StorageAccountImmutabilityPolicy): void;
    resetImmutabilityPolicy(): void;
    get immutabilityPolicyInput(): StorageAccountImmutabilityPolicy | undefined;
    private _networkRules;
    get networkRules(): StorageAccountNetworkRulesOutputReference;
    putNetworkRules(value: StorageAccountNetworkRules): void;
    resetNetworkRules(): void;
    get networkRulesInput(): StorageAccountNetworkRules | undefined;
    private _queueProperties;
    get queueProperties(): StorageAccountQueuePropertiesOutputReference;
    putQueueProperties(value: StorageAccountQueueProperties): void;
    resetQueueProperties(): void;
    get queuePropertiesInput(): StorageAccountQueueProperties | undefined;
    private _routing;
    get routing(): StorageAccountRoutingOutputReference;
    putRouting(value: StorageAccountRouting): void;
    resetRouting(): void;
    get routingInput(): StorageAccountRouting | undefined;
    private _shareProperties;
    get shareProperties(): StorageAccountSharePropertiesOutputReference;
    putShareProperties(value: StorageAccountShareProperties): void;
    resetShareProperties(): void;
    get sharePropertiesInput(): StorageAccountShareProperties | undefined;
    private _staticWebsite;
    get staticWebsite(): StorageAccountStaticWebsiteOutputReference;
    putStaticWebsite(value: StorageAccountStaticWebsite): void;
    resetStaticWebsite(): void;
    get staticWebsiteInput(): StorageAccountStaticWebsite | undefined;
    private _timeouts;
    get timeouts(): StorageAccountTimeoutsOutputReference;
    putTimeouts(value: StorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
