import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#id StorageManagementPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#storage_account_id StorageManagementPolicy#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#rule StorageManagementPolicy#rule}
    */
    readonly rule?: StorageManagementPolicyRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#timeouts StorageManagementPolicy#timeouts}
    */
    readonly timeouts?: StorageManagementPolicyTimeouts;
}
export interface StorageManagementPolicyRuleActionsBaseBlob {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_last_access_time_greater_than StorageManagementPolicy#delete_after_days_since_last_access_time_greater_than}
    */
    readonly deleteAfterDaysSinceLastAccessTimeGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_modification_greater_than StorageManagementPolicy#delete_after_days_since_modification_greater_than}
    */
    readonly deleteAfterDaysSinceModificationGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_archive_after_days_since_last_access_time_greater_than StorageManagementPolicy#tier_to_archive_after_days_since_last_access_time_greater_than}
    */
    readonly tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_archive_after_days_since_last_tier_change_greater_than StorageManagementPolicy#tier_to_archive_after_days_since_last_tier_change_greater_than}
    */
    readonly tierToArchiveAfterDaysSinceLastTierChangeGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_archive_after_days_since_modification_greater_than StorageManagementPolicy#tier_to_archive_after_days_since_modification_greater_than}
    */
    readonly tierToArchiveAfterDaysSinceModificationGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_cool_after_days_since_last_access_time_greater_than StorageManagementPolicy#tier_to_cool_after_days_since_last_access_time_greater_than}
    */
    readonly tierToCoolAfterDaysSinceLastAccessTimeGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_cool_after_days_since_modification_greater_than StorageManagementPolicy#tier_to_cool_after_days_since_modification_greater_than}
    */
    readonly tierToCoolAfterDaysSinceModificationGreaterThan?: number;
}
export declare function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct?: StorageManagementPolicyRuleActionsBaseBlobOutputReference | StorageManagementPolicyRuleActionsBaseBlob): any;
export declare class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageManagementPolicyRuleActionsBaseBlob | undefined;
    set internalValue(value: StorageManagementPolicyRuleActionsBaseBlob | undefined);
    private _deleteAfterDaysSinceLastAccessTimeGreaterThan?;
    get deleteAfterDaysSinceLastAccessTimeGreaterThan(): number;
    set deleteAfterDaysSinceLastAccessTimeGreaterThan(value: number);
    resetDeleteAfterDaysSinceLastAccessTimeGreaterThan(): void;
    get deleteAfterDaysSinceLastAccessTimeGreaterThanInput(): number | undefined;
    private _deleteAfterDaysSinceModificationGreaterThan?;
    get deleteAfterDaysSinceModificationGreaterThan(): number;
    set deleteAfterDaysSinceModificationGreaterThan(value: number);
    resetDeleteAfterDaysSinceModificationGreaterThan(): void;
    get deleteAfterDaysSinceModificationGreaterThanInput(): number | undefined;
    private _tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan?;
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(): number;
    set tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(value: number);
    resetTierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(): void;
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThanInput(): number | undefined;
    private _tierToArchiveAfterDaysSinceLastTierChangeGreaterThan?;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): number;
    set tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(value: number);
    resetTierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): void;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThanInput(): number | undefined;
    private _tierToArchiveAfterDaysSinceModificationGreaterThan?;
    get tierToArchiveAfterDaysSinceModificationGreaterThan(): number;
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value: number);
    resetTierToArchiveAfterDaysSinceModificationGreaterThan(): void;
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput(): number | undefined;
    private _tierToCoolAfterDaysSinceLastAccessTimeGreaterThan?;
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThan(): number;
    set tierToCoolAfterDaysSinceLastAccessTimeGreaterThan(value: number);
    resetTierToCoolAfterDaysSinceLastAccessTimeGreaterThan(): void;
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThanInput(): number | undefined;
    private _tierToCoolAfterDaysSinceModificationGreaterThan?;
    get tierToCoolAfterDaysSinceModificationGreaterThan(): number;
    set tierToCoolAfterDaysSinceModificationGreaterThan(value: number);
    resetTierToCoolAfterDaysSinceModificationGreaterThan(): void;
    get tierToCoolAfterDaysSinceModificationGreaterThanInput(): number | undefined;
}
export interface StorageManagementPolicyRuleActionsSnapshot {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_archive_after_days_since_creation StorageManagementPolicy#change_tier_to_archive_after_days_since_creation}
    */
    readonly changeTierToArchiveAfterDaysSinceCreation?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_cool_after_days_since_creation StorageManagementPolicy#change_tier_to_cool_after_days_since_creation}
    */
    readonly changeTierToCoolAfterDaysSinceCreation?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_creation_greater_than StorageManagementPolicy#delete_after_days_since_creation_greater_than}
    */
    readonly deleteAfterDaysSinceCreationGreaterThan?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_archive_after_days_since_last_tier_change_greater_than StorageManagementPolicy#tier_to_archive_after_days_since_last_tier_change_greater_than}
    */
    readonly tierToArchiveAfterDaysSinceLastTierChangeGreaterThan?: number;
}
export declare function storageManagementPolicyRuleActionsSnapshotToTerraform(struct?: StorageManagementPolicyRuleActionsSnapshotOutputReference | StorageManagementPolicyRuleActionsSnapshot): any;
export declare class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageManagementPolicyRuleActionsSnapshot | undefined;
    set internalValue(value: StorageManagementPolicyRuleActionsSnapshot | undefined);
    private _changeTierToArchiveAfterDaysSinceCreation?;
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    set changeTierToArchiveAfterDaysSinceCreation(value: number);
    resetChangeTierToArchiveAfterDaysSinceCreation(): void;
    get changeTierToArchiveAfterDaysSinceCreationInput(): number | undefined;
    private _changeTierToCoolAfterDaysSinceCreation?;
    get changeTierToCoolAfterDaysSinceCreation(): number;
    set changeTierToCoolAfterDaysSinceCreation(value: number);
    resetChangeTierToCoolAfterDaysSinceCreation(): void;
    get changeTierToCoolAfterDaysSinceCreationInput(): number | undefined;
    private _deleteAfterDaysSinceCreationGreaterThan?;
    get deleteAfterDaysSinceCreationGreaterThan(): number;
    set deleteAfterDaysSinceCreationGreaterThan(value: number);
    resetDeleteAfterDaysSinceCreationGreaterThan(): void;
    get deleteAfterDaysSinceCreationGreaterThanInput(): number | undefined;
    private _tierToArchiveAfterDaysSinceLastTierChangeGreaterThan?;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): number;
    set tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(value: number);
    resetTierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): void;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThanInput(): number | undefined;
}
export interface StorageManagementPolicyRuleActionsVersion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_archive_after_days_since_creation StorageManagementPolicy#change_tier_to_archive_after_days_since_creation}
    */
    readonly changeTierToArchiveAfterDaysSinceCreation?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#change_tier_to_cool_after_days_since_creation StorageManagementPolicy#change_tier_to_cool_after_days_since_creation}
    */
    readonly changeTierToCoolAfterDaysSinceCreation?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete_after_days_since_creation StorageManagementPolicy#delete_after_days_since_creation}
    */
    readonly deleteAfterDaysSinceCreation?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#tier_to_archive_after_days_since_last_tier_change_greater_than StorageManagementPolicy#tier_to_archive_after_days_since_last_tier_change_greater_than}
    */
    readonly tierToArchiveAfterDaysSinceLastTierChangeGreaterThan?: number;
}
export declare function storageManagementPolicyRuleActionsVersionToTerraform(struct?: StorageManagementPolicyRuleActionsVersionOutputReference | StorageManagementPolicyRuleActionsVersion): any;
export declare class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageManagementPolicyRuleActionsVersion | undefined;
    set internalValue(value: StorageManagementPolicyRuleActionsVersion | undefined);
    private _changeTierToArchiveAfterDaysSinceCreation?;
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    set changeTierToArchiveAfterDaysSinceCreation(value: number);
    resetChangeTierToArchiveAfterDaysSinceCreation(): void;
    get changeTierToArchiveAfterDaysSinceCreationInput(): number | undefined;
    private _changeTierToCoolAfterDaysSinceCreation?;
    get changeTierToCoolAfterDaysSinceCreation(): number;
    set changeTierToCoolAfterDaysSinceCreation(value: number);
    resetChangeTierToCoolAfterDaysSinceCreation(): void;
    get changeTierToCoolAfterDaysSinceCreationInput(): number | undefined;
    private _deleteAfterDaysSinceCreation?;
    get deleteAfterDaysSinceCreation(): number;
    set deleteAfterDaysSinceCreation(value: number);
    resetDeleteAfterDaysSinceCreation(): void;
    get deleteAfterDaysSinceCreationInput(): number | undefined;
    private _tierToArchiveAfterDaysSinceLastTierChangeGreaterThan?;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): number;
    set tierToArchiveAfterDaysSinceLastTierChangeGreaterThan(value: number);
    resetTierToArchiveAfterDaysSinceLastTierChangeGreaterThan(): void;
    get tierToArchiveAfterDaysSinceLastTierChangeGreaterThanInput(): number | undefined;
}
export interface StorageManagementPolicyRuleActions {
    /**
    * base_blob block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#base_blob StorageManagementPolicy#base_blob}
    */
    readonly baseBlob?: StorageManagementPolicyRuleActionsBaseBlob;
    /**
    * snapshot block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#snapshot StorageManagementPolicy#snapshot}
    */
    readonly snapshot?: StorageManagementPolicyRuleActionsSnapshot;
    /**
    * version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#version StorageManagementPolicy#version}
    */
    readonly version?: StorageManagementPolicyRuleActionsVersion;
}
export declare function storageManagementPolicyRuleActionsToTerraform(struct?: StorageManagementPolicyRuleActionsOutputReference | StorageManagementPolicyRuleActions): any;
export declare class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageManagementPolicyRuleActions | undefined;
    set internalValue(value: StorageManagementPolicyRuleActions | undefined);
    private _baseBlob;
    get baseBlob(): StorageManagementPolicyRuleActionsBaseBlobOutputReference;
    putBaseBlob(value: StorageManagementPolicyRuleActionsBaseBlob): void;
    resetBaseBlob(): void;
    get baseBlobInput(): StorageManagementPolicyRuleActionsBaseBlob | undefined;
    private _snapshot;
    get snapshot(): StorageManagementPolicyRuleActionsSnapshotOutputReference;
    putSnapshot(value: StorageManagementPolicyRuleActionsSnapshot): void;
    resetSnapshot(): void;
    get snapshotInput(): StorageManagementPolicyRuleActionsSnapshot | undefined;
    private _version;
    get version(): StorageManagementPolicyRuleActionsVersionOutputReference;
    putVersion(value: StorageManagementPolicyRuleActionsVersion): void;
    resetVersion(): void;
    get versionInput(): StorageManagementPolicyRuleActionsVersion | undefined;
}
export interface StorageManagementPolicyRuleFiltersMatchBlobIndexTag {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#name StorageManagementPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#operation StorageManagementPolicy#operation}
    */
    readonly operation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#value StorageManagementPolicy#value}
    */
    readonly value: string;
}
export declare function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct?: StorageManagementPolicyRuleFiltersMatchBlobIndexTag | cdktf.IResolvable): any;
export declare class StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageManagementPolicyRuleFiltersMatchBlobIndexTag | cdktf.IResolvable | undefined;
    set internalValue(value: StorageManagementPolicyRuleFiltersMatchBlobIndexTag | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operation?;
    get operation(): string;
    set operation(value: string);
    resetOperation(): void;
    get operationInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class StorageManagementPolicyRuleFiltersMatchBlobIndexTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageManagementPolicyRuleFiltersMatchBlobIndexTagOutputReference;
}
export interface StorageManagementPolicyRuleFilters {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#blob_types StorageManagementPolicy#blob_types}
    */
    readonly blobTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#prefix_match StorageManagementPolicy#prefix_match}
    */
    readonly prefixMatch?: string[];
    /**
    * match_blob_index_tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#match_blob_index_tag StorageManagementPolicy#match_blob_index_tag}
    */
    readonly matchBlobIndexTag?: StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | cdktf.IResolvable;
}
export declare function storageManagementPolicyRuleFiltersToTerraform(struct?: StorageManagementPolicyRuleFiltersOutputReference | StorageManagementPolicyRuleFilters): any;
export declare class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageManagementPolicyRuleFilters | undefined;
    set internalValue(value: StorageManagementPolicyRuleFilters | undefined);
    private _blobTypes?;
    get blobTypes(): string[];
    set blobTypes(value: string[]);
    get blobTypesInput(): string[] | undefined;
    private _prefixMatch?;
    get prefixMatch(): string[];
    set prefixMatch(value: string[]);
    resetPrefixMatch(): void;
    get prefixMatchInput(): string[] | undefined;
    private _matchBlobIndexTag;
    get matchBlobIndexTag(): StorageManagementPolicyRuleFiltersMatchBlobIndexTagList;
    putMatchBlobIndexTag(value: StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | cdktf.IResolvable): void;
    resetMatchBlobIndexTag(): void;
    get matchBlobIndexTagInput(): cdktf.IResolvable | StorageManagementPolicyRuleFiltersMatchBlobIndexTag[] | undefined;
}
export interface StorageManagementPolicyRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#enabled StorageManagementPolicy#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#name StorageManagementPolicy#name}
    */
    readonly name: string;
    /**
    * actions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#actions StorageManagementPolicy#actions}
    */
    readonly actions: StorageManagementPolicyRuleActions;
    /**
    * filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#filters StorageManagementPolicy#filters}
    */
    readonly filters?: StorageManagementPolicyRuleFilters;
}
export declare function storageManagementPolicyRuleToTerraform(struct?: StorageManagementPolicyRule | cdktf.IResolvable): any;
export declare class StorageManagementPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageManagementPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: StorageManagementPolicyRule | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _actions;
    get actions(): StorageManagementPolicyRuleActionsOutputReference;
    putActions(value: StorageManagementPolicyRuleActions): void;
    get actionsInput(): StorageManagementPolicyRuleActions | undefined;
    private _filters;
    get filters(): StorageManagementPolicyRuleFiltersOutputReference;
    putFilters(value: StorageManagementPolicyRuleFilters): void;
    resetFilters(): void;
    get filtersInput(): StorageManagementPolicyRuleFilters | undefined;
}
export declare class StorageManagementPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageManagementPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageManagementPolicyRuleOutputReference;
}
export interface StorageManagementPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#create StorageManagementPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#delete StorageManagementPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#read StorageManagementPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy#update StorageManagementPolicy#update}
    */
    readonly update?: string;
}
export declare function storageManagementPolicyTimeoutsToTerraform(struct?: StorageManagementPolicyTimeoutsOutputReference | StorageManagementPolicyTimeouts | cdktf.IResolvable): any;
export declare class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageManagementPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageManagementPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy}
*/
export declare class StorageManagementPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_management_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageManagementPolicyConfig
    */
    constructor(scope: Construct, id: string, config: StorageManagementPolicyConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _rule;
    get rule(): StorageManagementPolicyRuleList;
    putRule(value: StorageManagementPolicyRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | StorageManagementPolicyRule[] | undefined;
    private _timeouts;
    get timeouts(): StorageManagementPolicyTimeoutsOutputReference;
    putTimeouts(value: StorageManagementPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageManagementPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
