# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'DeploymentApmArgs',
    'DeploymentApmConfigArgs',
    'DeploymentElasticsearchArgs',
    'DeploymentElasticsearchColdArgs',
    'DeploymentElasticsearchColdAutoscalingArgs',
    'DeploymentElasticsearchConfigArgs',
    'DeploymentElasticsearchCoordinatingArgs',
    'DeploymentElasticsearchCoordinatingAutoscalingArgs',
    'DeploymentElasticsearchExtensionArgs',
    'DeploymentElasticsearchFrozenArgs',
    'DeploymentElasticsearchFrozenAutoscalingArgs',
    'DeploymentElasticsearchHotArgs',
    'DeploymentElasticsearchHotAutoscalingArgs',
    'DeploymentElasticsearchKeystoreContentsArgs',
    'DeploymentElasticsearchMasterArgs',
    'DeploymentElasticsearchMasterAutoscalingArgs',
    'DeploymentElasticsearchMlArgs',
    'DeploymentElasticsearchMlAutoscalingArgs',
    'DeploymentElasticsearchRemoteClusterArgs',
    'DeploymentElasticsearchSnapshotArgs',
    'DeploymentElasticsearchSnapshotRepositoryArgs',
    'DeploymentElasticsearchSnapshotRepositoryReferenceArgs',
    'DeploymentElasticsearchSnapshotSourceArgs',
    'DeploymentElasticsearchTrustAccountArgs',
    'DeploymentElasticsearchTrustExternalArgs',
    'DeploymentElasticsearchWarmArgs',
    'DeploymentElasticsearchWarmAutoscalingArgs',
    'DeploymentEnterpriseSearchArgs',
    'DeploymentEnterpriseSearchConfigArgs',
    'DeploymentIntegrationsServerArgs',
    'DeploymentIntegrationsServerConfigArgs',
    'DeploymentIntegrationsServerEndpointsArgs',
    'DeploymentKibanaArgs',
    'DeploymentKibanaConfigArgs',
    'DeploymentObservabilityArgs',
    'DeploymentTrafficFilterRuleArgs',
    'SnapshotRepositoryGenericArgs',
    'SnapshotRepositoryS3Args',
    'GetDeploymentsApmArgs',
    'GetDeploymentsElasticsearchArgs',
    'GetDeploymentsEnterpriseSearchArgs',
    'GetDeploymentsIntegrationsServerArgs',
    'GetDeploymentsKibanaArgs',
]

@pulumi.input_type
class DeploymentApmArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['DeploymentApmConfigArgs']] = None,
                 elasticsearch_cluster_ref_id: Optional[pulumi.Input[str]] = None,
                 http_endpoint: Optional[pulumi.Input[str]] = None,
                 https_endpoint: Optional[pulumi.Input[str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 ref_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentApmConfigArgs'] config: Optionally define the Apm configuration options for the APM Server
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeploymentApmConfigArgs']]:
        """
        Optionally define the Apm configuration options for the APM Server
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeploymentApmConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @elasticsearch_cluster_ref_id.setter
    def elasticsearch_cluster_ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_cluster_ref_id", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentApmConfigArgs:
    def __init__(__self__, *,
                 debug_enabled: Optional[pulumi.Input[bool]] = None,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 user_settings_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_yaml: Optional[pulumi.Input[str]] = None,
                 user_settings_yaml: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] debug_enabled: Optionally enable debug mode for APM servers - defaults to false
        :param pulumi.Input[str] docker_image: Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        :param pulumi.Input[str] user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if debug_enabled is not None:
            pulumi.set(__self__, "debug_enabled", debug_enabled)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="debugEnabled")
    def debug_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optionally enable debug mode for APM servers - defaults to false
        """
        return pulumi.get(self, "debug_enabled")

    @debug_enabled.setter
    def debug_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug_enabled", value)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @user_settings_json.setter
    def user_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @user_settings_override_json.setter
    def user_settings_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @user_settings_override_yaml.setter
    def user_settings_override_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_yaml", value)

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")

    @user_settings_yaml.setter
    def user_settings_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_yaml", value)


@pulumi.input_type
class DeploymentElasticsearchArgs:
    def __init__(__self__, *,
                 hot: pulumi.Input['DeploymentElasticsearchHotArgs'],
                 autoscale: Optional[pulumi.Input[bool]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 cold: Optional[pulumi.Input['DeploymentElasticsearchColdArgs']] = None,
                 config: Optional[pulumi.Input['DeploymentElasticsearchConfigArgs']] = None,
                 coordinating: Optional[pulumi.Input['DeploymentElasticsearchCoordinatingArgs']] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchExtensionArgs']]]] = None,
                 frozen: Optional[pulumi.Input['DeploymentElasticsearchFrozenArgs']] = None,
                 http_endpoint: Optional[pulumi.Input[str]] = None,
                 https_endpoint: Optional[pulumi.Input[str]] = None,
                 keystore_contents: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeploymentElasticsearchKeystoreContentsArgs']]]] = None,
                 master: Optional[pulumi.Input['DeploymentElasticsearchMasterArgs']] = None,
                 ml: Optional[pulumi.Input['DeploymentElasticsearchMlArgs']] = None,
                 ref_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remote_clusters: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchRemoteClusterArgs']]]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 snapshot: Optional[pulumi.Input['DeploymentElasticsearchSnapshotArgs']] = None,
                 snapshot_source: Optional[pulumi.Input['DeploymentElasticsearchSnapshotSourceArgs']] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 trust_accounts: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustAccountArgs']]]] = None,
                 trust_externals: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustExternalArgs']]]] = None,
                 warm: Optional[pulumi.Input['DeploymentElasticsearchWarmArgs']] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchHotArgs'] hot: 'hot' topology element
        :param pulumi.Input[bool] autoscale: Enable or disable autoscaling. Defaults to the setting coming from the deployment template.
        :param pulumi.Input[str] cloud_id: The encoded Elasticsearch credentials to use in Beats or Logstash
        :param pulumi.Input['DeploymentElasticsearchColdArgs'] cold: 'cold' topology element
        :param pulumi.Input['DeploymentElasticsearchConfigArgs'] config: Elasticsearch settings which will be applied to all topologies
        :param pulumi.Input['DeploymentElasticsearchCoordinatingArgs'] coordinating: 'coordinating' topology element
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchExtensionArgs']]] extensions: Optional Elasticsearch extensions such as custom bundles or plugins.
        :param pulumi.Input['DeploymentElasticsearchFrozenArgs'] frozen: 'frozen' topology element
        :param pulumi.Input[str] http_endpoint: The Elasticsearch resource HTTP endpoint
        :param pulumi.Input[str] https_endpoint: The Elasticsearch resource HTTPs endpoint
        :param pulumi.Input[Mapping[str, pulumi.Input['DeploymentElasticsearchKeystoreContentsArgs']]] keystore_contents: Keystore contents that are controlled by the deployment resource.
        :param pulumi.Input['DeploymentElasticsearchMasterArgs'] master: 'master' topology element
        :param pulumi.Input['DeploymentElasticsearchMlArgs'] ml: 'ml' topology element
        :param pulumi.Input[str] ref_id: A human readable reference for the Elasticsearch resource. The default value `main-elasticsearch` is recommended.
        :param pulumi.Input[str] region: The Elasticsearch resource region
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchRemoteClusterArgs']]] remote_clusters: Optional Elasticsearch remote clusters to configure for the Elasticsearch resource, can be set multiple times
        :param pulumi.Input[str] resource_id: The Elasticsearch resource unique identifier
        :param pulumi.Input['DeploymentElasticsearchSnapshotArgs'] snapshot: (ECE only) Snapshot configuration settings for an Elasticsearch cluster.
        :param pulumi.Input[str] strategy: Configuration strategy type autodetect, grow_and_shrink, rolling_grow_and_shrink, rolling_all
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustAccountArgs']]] trust_accounts: Optional Elasticsearch account trust settings.
        :param pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustExternalArgs']]] trust_externals: Optional Elasticsearch external trust settings.
        :param pulumi.Input['DeploymentElasticsearchWarmArgs'] warm: 'warm' topology element
        """
        pulumi.set(__self__, "hot", hot)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if cold is not None:
            pulumi.set(__self__, "cold", cold)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if coordinating is not None:
            pulumi.set(__self__, "coordinating", coordinating)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if frozen is not None:
            pulumi.set(__self__, "frozen", frozen)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if keystore_contents is not None:
            pulumi.set(__self__, "keystore_contents", keystore_contents)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if ml is not None:
            pulumi.set(__self__, "ml", ml)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_clusters is not None:
            pulumi.set(__self__, "remote_clusters", remote_clusters)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if snapshot_source is not None:
            pulumi.set(__self__, "snapshot_source", snapshot_source)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if trust_accounts is not None:
            pulumi.set(__self__, "trust_accounts", trust_accounts)
        if trust_externals is not None:
            pulumi.set(__self__, "trust_externals", trust_externals)
        if warm is not None:
            pulumi.set(__self__, "warm", warm)

    @property
    @pulumi.getter
    def hot(self) -> pulumi.Input['DeploymentElasticsearchHotArgs']:
        """
        'hot' topology element
        """
        return pulumi.get(self, "hot")

    @hot.setter
    def hot(self, value: pulumi.Input['DeploymentElasticsearchHotArgs']):
        pulumi.set(self, "hot", value)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable autoscaling. Defaults to the setting coming from the deployment template.
        """
        return pulumi.get(self, "autoscale")

    @autoscale.setter
    def autoscale(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscale", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        """
        The encoded Elasticsearch credentials to use in Beats or Logstash
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter
    def cold(self) -> Optional[pulumi.Input['DeploymentElasticsearchColdArgs']]:
        """
        'cold' topology element
        """
        return pulumi.get(self, "cold")

    @cold.setter
    def cold(self, value: Optional[pulumi.Input['DeploymentElasticsearchColdArgs']]):
        pulumi.set(self, "cold", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeploymentElasticsearchConfigArgs']]:
        """
        Elasticsearch settings which will be applied to all topologies
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeploymentElasticsearchConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def coordinating(self) -> Optional[pulumi.Input['DeploymentElasticsearchCoordinatingArgs']]:
        """
        'coordinating' topology element
        """
        return pulumi.get(self, "coordinating")

    @coordinating.setter
    def coordinating(self, value: Optional[pulumi.Input['DeploymentElasticsearchCoordinatingArgs']]):
        pulumi.set(self, "coordinating", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchExtensionArgs']]]]:
        """
        Optional Elasticsearch extensions such as custom bundles or plugins.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter
    def frozen(self) -> Optional[pulumi.Input['DeploymentElasticsearchFrozenArgs']]:
        """
        'frozen' topology element
        """
        return pulumi.get(self, "frozen")

    @frozen.setter
    def frozen(self, value: Optional[pulumi.Input['DeploymentElasticsearchFrozenArgs']]):
        pulumi.set(self, "frozen", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The Elasticsearch resource HTTP endpoint
        """
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The Elasticsearch resource HTTPs endpoint
        """
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter(name="keystoreContents")
    def keystore_contents(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input['DeploymentElasticsearchKeystoreContentsArgs']]]]:
        """
        Keystore contents that are controlled by the deployment resource.
        """
        return pulumi.get(self, "keystore_contents")

    @keystore_contents.setter
    def keystore_contents(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input['DeploymentElasticsearchKeystoreContentsArgs']]]]):
        pulumi.set(self, "keystore_contents", value)

    @property
    @pulumi.getter
    def master(self) -> Optional[pulumi.Input['DeploymentElasticsearchMasterArgs']]:
        """
        'master' topology element
        """
        return pulumi.get(self, "master")

    @master.setter
    def master(self, value: Optional[pulumi.Input['DeploymentElasticsearchMasterArgs']]):
        pulumi.set(self, "master", value)

    @property
    @pulumi.getter
    def ml(self) -> Optional[pulumi.Input['DeploymentElasticsearchMlArgs']]:
        """
        'ml' topology element
        """
        return pulumi.get(self, "ml")

    @ml.setter
    def ml(self, value: Optional[pulumi.Input['DeploymentElasticsearchMlArgs']]):
        pulumi.set(self, "ml", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        """
        A human readable reference for the Elasticsearch resource. The default value `main-elasticsearch` is recommended.
        """
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The Elasticsearch resource region
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="remoteClusters")
    def remote_clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchRemoteClusterArgs']]]]:
        """
        Optional Elasticsearch remote clusters to configure for the Elasticsearch resource, can be set multiple times
        """
        return pulumi.get(self, "remote_clusters")

    @remote_clusters.setter
    def remote_clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchRemoteClusterArgs']]]]):
        pulumi.set(self, "remote_clusters", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Elasticsearch resource unique identifier
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['DeploymentElasticsearchSnapshotArgs']]:
        """
        (ECE only) Snapshot configuration settings for an Elasticsearch cluster.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['DeploymentElasticsearchSnapshotArgs']]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter(name="snapshotSource")
    def snapshot_source(self) -> Optional[pulumi.Input['DeploymentElasticsearchSnapshotSourceArgs']]:
        return pulumi.get(self, "snapshot_source")

    @snapshot_source.setter
    def snapshot_source(self, value: Optional[pulumi.Input['DeploymentElasticsearchSnapshotSourceArgs']]):
        pulumi.set(self, "snapshot_source", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration strategy type autodetect, grow_and_shrink, rolling_grow_and_shrink, rolling_all
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "strategy", value)

    @property
    @pulumi.getter(name="trustAccounts")
    def trust_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustAccountArgs']]]]:
        """
        Optional Elasticsearch account trust settings.
        """
        return pulumi.get(self, "trust_accounts")

    @trust_accounts.setter
    def trust_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustAccountArgs']]]]):
        pulumi.set(self, "trust_accounts", value)

    @property
    @pulumi.getter(name="trustExternals")
    def trust_externals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustExternalArgs']]]]:
        """
        Optional Elasticsearch external trust settings.
        """
        return pulumi.get(self, "trust_externals")

    @trust_externals.setter
    def trust_externals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeploymentElasticsearchTrustExternalArgs']]]]):
        pulumi.set(self, "trust_externals", value)

    @property
    @pulumi.getter
    def warm(self) -> Optional[pulumi.Input['DeploymentElasticsearchWarmArgs']]:
        """
        'warm' topology element
        """
        return pulumi.get(self, "warm")

    @warm.setter
    def warm(self, value: Optional[pulumi.Input['DeploymentElasticsearchWarmArgs']]):
        pulumi.set(self, "warm", value)


@pulumi.input_type
class DeploymentElasticsearchColdArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchColdAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchColdAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchColdAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchColdAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchColdAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentElasticsearchConfigArgs:
    def __init__(__self__, *,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 plugins: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_settings_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_yaml: Optional[pulumi.Input[str]] = None,
                 user_settings_yaml: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] docker_image: Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] plugins: List of Elasticsearch supported plugins, which vary from version to version. Check the Stack Pack version to see which plugins are supported for each version. This is currently only available from the UI and [ecctl](https://www.elastic.co/guide/en/ecctl/master/ecctl_stack_list.html)
        :param pulumi.Input[str] user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter
    def plugins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of Elasticsearch supported plugins, which vary from version to version. Check the Stack Pack version to see which plugins are supported for each version. This is currently only available from the UI and [ecctl](https://www.elastic.co/guide/en/ecctl/master/ecctl_stack_list.html)
        """
        return pulumi.get(self, "plugins")

    @plugins.setter
    def plugins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "plugins", value)

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @user_settings_json.setter
    def user_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @user_settings_override_json.setter
    def user_settings_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @user_settings_override_yaml.setter
    def user_settings_override_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_yaml", value)

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")

    @user_settings_yaml.setter
    def user_settings_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_yaml", value)


@pulumi.input_type
class DeploymentElasticsearchCoordinatingArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchCoordinatingAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchCoordinatingAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchCoordinatingAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchCoordinatingAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchCoordinatingAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentElasticsearchExtensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 type: pulumi.Input[str],
                 url: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Extension name.
        :param pulumi.Input[str] type: Extension type, only `bundle` or `plugin` are supported.
        :param pulumi.Input[str] url: Bundle or plugin URL, the extension URL can be obtained from the `ec_deployment_extension.<name>.url` attribute or the API and cannot be a random HTTP address that is hosted elsewhere.
        :param pulumi.Input[str] version: Elasticsearch compatibility version. Bundles should specify major or minor versions with wildcards, such as `7.*` or `*` but **plugins must use full version notation down to the patch level**, such as `7.10.1` and wildcards are not allowed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Extension name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Extension type, only `bundle` or `plugin` are supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Bundle or plugin URL, the extension URL can be obtained from the `ec_deployment_extension.<name>.url` attribute or the API and cannot be a random HTTP address that is hosted elsewhere.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Elasticsearch compatibility version. Bundles should specify major or minor versions with wildcards, such as `7.*` or `*` but **plugins must use full version notation down to the patch level**, such as `7.10.1` and wildcards are not allowed.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DeploymentElasticsearchFrozenArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchFrozenAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchFrozenAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchFrozenAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchFrozenAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchFrozenAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentElasticsearchHotArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchHotAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchHotAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchHotAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchHotAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchHotAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentElasticsearchKeystoreContentsArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[str],
                 as_file: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] value: Secret value. This can either be a string or a JSON object that is stored as a JSON string in the keystore.
        :param pulumi.Input[bool] as_file: If true, the secret is handled as a file. Otherwise, it's handled as a plain string.
        """
        pulumi.set(__self__, "value", value)
        if as_file is not None:
            pulumi.set(__self__, "as_file", as_file)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Secret value. This can either be a string or a JSON object that is stored as a JSON string in the keystore.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="asFile")
    def as_file(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the secret is handled as a file. Otherwise, it's handled as a plain string.
        """
        return pulumi.get(self, "as_file")

    @as_file.setter
    def as_file(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "as_file", value)


@pulumi.input_type
class DeploymentElasticsearchMasterArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchMasterAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchMasterAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchMasterAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchMasterAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchMasterAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentElasticsearchMlArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchMlAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchMlAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchMlAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchMlAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchMlAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentElasticsearchRemoteClusterArgs:
    def __init__(__self__, *,
                 alias: pulumi.Input[str],
                 deployment_id: pulumi.Input[str],
                 ref_id: Optional[pulumi.Input[str]] = None,
                 skip_unavailable: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] alias: Alias for this Cross Cluster Search binding
        :param pulumi.Input[str] deployment_id: Remote deployment ID
        :param pulumi.Input[str] ref_id: Remote elasticsearch "ref_id", it is best left to the default value
        :param pulumi.Input[bool] skip_unavailable: If true, skip the cluster during search when disconnected
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "deployment_id", deployment_id)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if skip_unavailable is not None:
            pulumi.set(__self__, "skip_unavailable", skip_unavailable)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Input[str]:
        """
        Alias for this Cross Cluster Search binding
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: pulumi.Input[str]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        Remote deployment ID
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        """
        Remote elasticsearch "ref_id", it is best left to the default value
        """
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter(name="skipUnavailable")
    def skip_unavailable(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, skip the cluster during search when disconnected
        """
        return pulumi.get(self, "skip_unavailable")

    @skip_unavailable.setter
    def skip_unavailable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_unavailable", value)


@pulumi.input_type
class DeploymentElasticsearchSnapshotArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 repository: Optional[pulumi.Input['DeploymentElasticsearchSnapshotRepositoryArgs']] = None):
        """
        :param pulumi.Input[bool] enabled: Indicates if Snapshotting is enabled.
        :param pulumi.Input['DeploymentElasticsearchSnapshotRepositoryArgs'] repository: Snapshot repository configuration
        """
        pulumi.set(__self__, "enabled", enabled)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Indicates if Snapshotting is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input['DeploymentElasticsearchSnapshotRepositoryArgs']]:
        """
        Snapshot repository configuration
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input['DeploymentElasticsearchSnapshotRepositoryArgs']]):
        pulumi.set(self, "repository", value)


@pulumi.input_type
class DeploymentElasticsearchSnapshotRepositoryArgs:
    def __init__(__self__, *,
                 reference: Optional[pulumi.Input['DeploymentElasticsearchSnapshotRepositoryReferenceArgs']] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchSnapshotRepositoryReferenceArgs'] reference: Cluster snapshot reference repository settings, containing the repository name in ECE fashion
        """
        if reference is not None:
            pulumi.set(__self__, "reference", reference)

    @property
    @pulumi.getter
    def reference(self) -> Optional[pulumi.Input['DeploymentElasticsearchSnapshotRepositoryReferenceArgs']]:
        """
        Cluster snapshot reference repository settings, containing the repository name in ECE fashion
        """
        return pulumi.get(self, "reference")

    @reference.setter
    def reference(self, value: Optional[pulumi.Input['DeploymentElasticsearchSnapshotRepositoryReferenceArgs']]):
        pulumi.set(self, "reference", value)


@pulumi.input_type
class DeploymentElasticsearchSnapshotRepositoryReferenceArgs:
    def __init__(__self__, *,
                 repository_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] repository_name: ECE snapshot repository name, from the '/platform/configuration/snapshots/repositories' endpoint
        """
        pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> pulumi.Input[str]:
        """
        ECE snapshot repository name, from the '/platform/configuration/snapshots/repositories' endpoint
        """
        return pulumi.get(self, "repository_name")

    @repository_name.setter
    def repository_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_name", value)


@pulumi.input_type
class DeploymentElasticsearchSnapshotSourceArgs:
    def __init__(__self__, *,
                 source_elasticsearch_cluster_id: pulumi.Input[str],
                 snapshot_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] source_elasticsearch_cluster_id: ID of the Elasticsearch cluster that will be used as the source of the snapshot
        :param pulumi.Input[str] snapshot_name: Name of the snapshot to restore. Use '**latest_success**' to get the most recent successful snapshot.
        """
        pulumi.set(__self__, "source_elasticsearch_cluster_id", source_elasticsearch_cluster_id)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @property
    @pulumi.getter(name="sourceElasticsearchClusterId")
    def source_elasticsearch_cluster_id(self) -> pulumi.Input[str]:
        """
        ID of the Elasticsearch cluster that will be used as the source of the snapshot
        """
        return pulumi.get(self, "source_elasticsearch_cluster_id")

    @source_elasticsearch_cluster_id.setter
    def source_elasticsearch_cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_elasticsearch_cluster_id", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the snapshot to restore. Use '**latest_success**' to get the most recent successful snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)


@pulumi.input_type
class DeploymentElasticsearchTrustAccountArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 trust_all: pulumi.Input[bool],
                 trust_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] account_id: The ID of the Account.
        :param pulumi.Input[bool] trust_all: If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trust_allowlists: The list of clusters to trust. Only used when `trust_all` is false.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "trust_all", trust_all)
        if trust_allowlists is not None:
            pulumi.set(__self__, "trust_allowlists", trust_allowlists)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The ID of the Account.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="trustAll")
    def trust_all(self) -> pulumi.Input[bool]:
        """
        If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        """
        return pulumi.get(self, "trust_all")

    @trust_all.setter
    def trust_all(self, value: pulumi.Input[bool]):
        pulumi.set(self, "trust_all", value)

    @property
    @pulumi.getter(name="trustAllowlists")
    def trust_allowlists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of clusters to trust. Only used when `trust_all` is false.
        """
        return pulumi.get(self, "trust_allowlists")

    @trust_allowlists.setter
    def trust_allowlists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trust_allowlists", value)


@pulumi.input_type
class DeploymentElasticsearchTrustExternalArgs:
    def __init__(__self__, *,
                 relationship_id: pulumi.Input[str],
                 trust_all: pulumi.Input[bool],
                 trust_allowlists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] relationship_id: The ID of the external trust relationship.
        :param pulumi.Input[bool] trust_all: If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trust_allowlists: The list of clusters to trust. Only used when `trust_all` is false.
        """
        pulumi.set(__self__, "relationship_id", relationship_id)
        pulumi.set(__self__, "trust_all", trust_all)
        if trust_allowlists is not None:
            pulumi.set(__self__, "trust_allowlists", trust_allowlists)

    @property
    @pulumi.getter(name="relationshipId")
    def relationship_id(self) -> pulumi.Input[str]:
        """
        The ID of the external trust relationship.
        """
        return pulumi.get(self, "relationship_id")

    @relationship_id.setter
    def relationship_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "relationship_id", value)

    @property
    @pulumi.getter(name="trustAll")
    def trust_all(self) -> pulumi.Input[bool]:
        """
        If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        """
        return pulumi.get(self, "trust_all")

    @trust_all.setter
    def trust_all(self, value: pulumi.Input[bool]):
        pulumi.set(self, "trust_all", value)

    @property
    @pulumi.getter(name="trustAllowlists")
    def trust_allowlists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of clusters to trust. Only used when `trust_all` is false.
        """
        return pulumi.get(self, "trust_allowlists")

    @trust_allowlists.setter
    def trust_allowlists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trust_allowlists", value)


@pulumi.input_type
class DeploymentElasticsearchWarmArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['DeploymentElasticsearchWarmAutoscalingArgs'],
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_type_data: Optional[pulumi.Input[str]] = None,
                 node_type_ingest: Optional[pulumi.Input[str]] = None,
                 node_type_master: Optional[pulumi.Input[str]] = None,
                 node_type_ml: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentElasticsearchWarmAutoscalingArgs'] autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param pulumi.Input[str] instance_configuration_id: Computed Instance Configuration ID of the topology element
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_roles: The computed list of node roles for the current topology element
        :param pulumi.Input[str] node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param pulumi.Input[str] node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param pulumi.Input[str] node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param pulumi.Input[str] node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param pulumi.Input[str] size: Amount of "size_resource" per node in the "<size in GB>g" notation
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        :param pulumi.Input[int] zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['DeploymentElasticsearchWarmAutoscalingArgs']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['DeploymentElasticsearchWarmAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @node_roles.setter
    def node_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_roles", value)

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @node_type_data.setter
    def node_type_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_data", value)

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @node_type_ingest.setter
    def node_type_ingest(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ingest", value)

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @node_type_master.setter
    def node_type_master(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_master", value)

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[pulumi.Input[str]]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @node_type_ml.setter
    def node_type_ml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type_ml", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        """
        Amount of "size_resource" per node in the "<size in GB>g" notation
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentElasticsearchWarmAutoscalingArgs:
    def __init__(__self__, *,
                 max_size: Optional[pulumi.Input[str]] = None,
                 max_size_resource: Optional[pulumi.Input[str]] = None,
                 min_size: Optional[pulumi.Input[str]] = None,
                 min_size_resource: Optional[pulumi.Input[str]] = None,
                 policy_override_json: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] max_size: Maximum size value for the maximum autoscaling setting.
        :param pulumi.Input[str] max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param pulumi.Input[str] min_size: Minimum size value for the minimum autoscaling setting.
        :param pulumi.Input[str] min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param pulumi.Input[str] policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @max_size_resource.setter
    def max_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_size_resource", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @min_size_resource.setter
    def min_size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_size_resource", value)

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")

    @policy_override_json.setter
    def policy_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_override_json", value)


@pulumi.input_type
class DeploymentEnterpriseSearchArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['DeploymentEnterpriseSearchConfigArgs']] = None,
                 elasticsearch_cluster_ref_id: Optional[pulumi.Input[str]] = None,
                 http_endpoint: Optional[pulumi.Input[str]] = None,
                 https_endpoint: Optional[pulumi.Input[str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 node_type_appserver: Optional[pulumi.Input[bool]] = None,
                 node_type_connector: Optional[pulumi.Input[bool]] = None,
                 node_type_worker: Optional[pulumi.Input[bool]] = None,
                 ref_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentEnterpriseSearchConfigArgs'] config: Optionally define the Enterprise Search configuration options for the Enterprise Search Server
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if node_type_appserver is not None:
            pulumi.set(__self__, "node_type_appserver", node_type_appserver)
        if node_type_connector is not None:
            pulumi.set(__self__, "node_type_connector", node_type_connector)
        if node_type_worker is not None:
            pulumi.set(__self__, "node_type_worker", node_type_worker)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeploymentEnterpriseSearchConfigArgs']]:
        """
        Optionally define the Enterprise Search configuration options for the Enterprise Search Server
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeploymentEnterpriseSearchConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @elasticsearch_cluster_ref_id.setter
    def elasticsearch_cluster_ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_cluster_ref_id", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="nodeTypeAppserver")
    def node_type_appserver(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "node_type_appserver")

    @node_type_appserver.setter
    def node_type_appserver(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_type_appserver", value)

    @property
    @pulumi.getter(name="nodeTypeConnector")
    def node_type_connector(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "node_type_connector")

    @node_type_connector.setter
    def node_type_connector(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_type_connector", value)

    @property
    @pulumi.getter(name="nodeTypeWorker")
    def node_type_worker(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "node_type_worker")

    @node_type_worker.setter
    def node_type_worker(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "node_type_worker", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentEnterpriseSearchConfigArgs:
    def __init__(__self__, *,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 user_settings_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_yaml: Optional[pulumi.Input[str]] = None,
                 user_settings_yaml: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] docker_image: Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        :param pulumi.Input[str] user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @user_settings_json.setter
    def user_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @user_settings_override_json.setter
    def user_settings_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @user_settings_override_yaml.setter
    def user_settings_override_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_yaml", value)

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")

    @user_settings_yaml.setter
    def user_settings_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_yaml", value)


@pulumi.input_type
class DeploymentIntegrationsServerArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['DeploymentIntegrationsServerConfigArgs']] = None,
                 elasticsearch_cluster_ref_id: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input['DeploymentIntegrationsServerEndpointsArgs']] = None,
                 http_endpoint: Optional[pulumi.Input[str]] = None,
                 https_endpoint: Optional[pulumi.Input[str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 ref_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentIntegrationsServerConfigArgs'] config: Optionally define the Integrations Server configuration options for the IntegrationsServer Server
        :param pulumi.Input['DeploymentIntegrationsServerEndpointsArgs'] endpoints: URLs for the accessing the Fleet and APM API's within this Integrations Server resource.
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeploymentIntegrationsServerConfigArgs']]:
        """
        Optionally define the Integrations Server configuration options for the IntegrationsServer Server
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeploymentIntegrationsServerConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @elasticsearch_cluster_ref_id.setter
    def elasticsearch_cluster_ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_cluster_ref_id", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['DeploymentIntegrationsServerEndpointsArgs']]:
        """
        URLs for the accessing the Fleet and APM API's within this Integrations Server resource.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['DeploymentIntegrationsServerEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentIntegrationsServerConfigArgs:
    def __init__(__self__, *,
                 debug_enabled: Optional[pulumi.Input[bool]] = None,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 user_settings_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_yaml: Optional[pulumi.Input[str]] = None,
                 user_settings_yaml: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] debug_enabled: Optionally enable debug mode for APM servers - defaults to false
        :param pulumi.Input[str] docker_image: Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        :param pulumi.Input[str] user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if debug_enabled is not None:
            pulumi.set(__self__, "debug_enabled", debug_enabled)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="debugEnabled")
    def debug_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optionally enable debug mode for APM servers - defaults to false
        """
        return pulumi.get(self, "debug_enabled")

    @debug_enabled.setter
    def debug_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "debug_enabled", value)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @user_settings_json.setter
    def user_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @user_settings_override_json.setter
    def user_settings_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @user_settings_override_yaml.setter
    def user_settings_override_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_yaml", value)

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")

    @user_settings_yaml.setter
    def user_settings_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_yaml", value)


@pulumi.input_type
class DeploymentIntegrationsServerEndpointsArgs:
    def __init__(__self__, *,
                 apm: pulumi.Input[str],
                 fleet: pulumi.Input[str]):
        pulumi.set(__self__, "apm", apm)
        pulumi.set(__self__, "fleet", fleet)

    @property
    @pulumi.getter
    def apm(self) -> pulumi.Input[str]:
        return pulumi.get(self, "apm")

    @apm.setter
    def apm(self, value: pulumi.Input[str]):
        pulumi.set(self, "apm", value)

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Input[str]:
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: pulumi.Input[str]):
        pulumi.set(self, "fleet", value)


@pulumi.input_type
class DeploymentKibanaArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['DeploymentKibanaConfigArgs']] = None,
                 elasticsearch_cluster_ref_id: Optional[pulumi.Input[str]] = None,
                 http_endpoint: Optional[pulumi.Input[str]] = None,
                 https_endpoint: Optional[pulumi.Input[str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 ref_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[str]] = None,
                 size_resource: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['DeploymentKibanaConfigArgs'] config: Optionally define the Kibana configuration options for the Kibana Server
        :param pulumi.Input[str] size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['DeploymentKibanaConfigArgs']]:
        """
        Optionally define the Kibana configuration options for the Kibana Server
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['DeploymentKibanaConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @elasticsearch_cluster_ref_id.setter
    def elasticsearch_cluster_ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticsearch_cluster_ref_id", value)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "http_endpoint")

    @http_endpoint.setter
    def http_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_endpoint", value)

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "https_endpoint")

    @https_endpoint.setter
    def https_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "https_endpoint", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[pulumi.Input[str]]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @size_resource.setter
    def size_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_resource", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class DeploymentKibanaConfigArgs:
    def __init__(__self__, *,
                 docker_image: Optional[pulumi.Input[str]] = None,
                 user_settings_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_json: Optional[pulumi.Input[str]] = None,
                 user_settings_override_yaml: Optional[pulumi.Input[str]] = None,
                 user_settings_yaml: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] docker_image: Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        :param pulumi.Input[str] user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param pulumi.Input[str] user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[pulumi.Input[str]]:
        """
        Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        """
        return pulumi.get(self, "docker_image")

    @docker_image.setter
    def docker_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_image", value)

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @user_settings_json.setter
    def user_settings_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @user_settings_override_json.setter
    def user_settings_override_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_json", value)

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @user_settings_override_yaml.setter
    def user_settings_override_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_override_yaml", value)

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")

    @user_settings_yaml.setter
    def user_settings_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_settings_yaml", value)


@pulumi.input_type
class DeploymentObservabilityArgs:
    def __init__(__self__, *,
                 deployment_id: pulumi.Input[str],
                 logs: Optional[pulumi.Input[bool]] = None,
                 metrics: Optional[pulumi.Input[bool]] = None,
                 ref_id: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "deployment_id", deployment_id)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ref_id")

    @ref_id.setter
    def ref_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ref_id", value)


@pulumi.input_type
class DeploymentTrafficFilterRuleArgs:
    def __init__(__self__, *,
                 azure_endpoint_guid: Optional[pulumi.Input[str]] = None,
                 azure_endpoint_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] azure_endpoint_guid: Azure endpoint GUID. Only applicable when the ruleset type is set to `azure_private_endpoint`
        :param pulumi.Input[str] azure_endpoint_name: Azure endpoint name. Only applicable when the ruleset type is set to `azure_private_endpoint`
        :param pulumi.Input[str] description: Description of this individual rule
        :param pulumi.Input[str] id: Computed rule ID
        :param pulumi.Input[str] source: Traffic filter source: IP address, CIDR mask, or VPC endpoint ID, **only required** when the type is not `azure_private_endpoint`
        """
        if azure_endpoint_guid is not None:
            pulumi.set(__self__, "azure_endpoint_guid", azure_endpoint_guid)
        if azure_endpoint_name is not None:
            pulumi.set(__self__, "azure_endpoint_name", azure_endpoint_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="azureEndpointGuid")
    def azure_endpoint_guid(self) -> Optional[pulumi.Input[str]]:
        """
        Azure endpoint GUID. Only applicable when the ruleset type is set to `azure_private_endpoint`
        """
        return pulumi.get(self, "azure_endpoint_guid")

    @azure_endpoint_guid.setter
    def azure_endpoint_guid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_endpoint_guid", value)

    @property
    @pulumi.getter(name="azureEndpointName")
    def azure_endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        Azure endpoint name. Only applicable when the ruleset type is set to `azure_private_endpoint`
        """
        return pulumi.get(self, "azure_endpoint_name")

    @azure_endpoint_name.setter
    def azure_endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_endpoint_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of this individual rule
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Computed rule ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Traffic filter source: IP address, CIDR mask, or VPC endpoint ID, **only required** when the type is not `azure_private_endpoint`
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class SnapshotRepositoryGenericArgs:
    def __init__(__self__, *,
                 settings: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] settings: An arbitrary JSON object containing the repository settings.
        :param pulumi.Input[str] type: Repository type
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Input[str]:
        """
        An arbitrary JSON object containing the repository settings.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: pulumi.Input[str]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Repository type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SnapshotRepositoryS3Args:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 access_key: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 path_style_access: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] bucket: Name of the S3 bucket to use for snapshots.
        :param pulumi.Input[str] access_key: An S3 access key. If set, the secret_key setting must also be specified. If unset, the client will use the instance or container role instead.
        :param pulumi.Input[str] endpoint: The S3 service endpoint to connect to. This defaults to s3.amazonaws.com but the AWS documentation lists alternative S3 endpoints. If you are using an S3-compatible service then you should set this to the service’s endpoint.
        :param pulumi.Input[bool] path_style_access: Whether to force the use of the path style access pattern. If true, the path style access pattern will be used. If false, the access pattern will be automatically determined by the AWS Java SDK (See AWS documentation for details). Defaults to false.
        :param pulumi.Input[str] region: Allows specifying the signing region to use. Specifying this setting manually should not be necessary for most use cases. Generally, the SDK will correctly guess the signing region to use. It should be considered an expert level setting to support S3-compatible APIs that require v4 signatures and use a region other than the default us-east-1. Defaults to empty string which means that the SDK will try to automatically determine the correct signing region.
        :param pulumi.Input[str] secret_key: An S3 secret key. If set, the access_key setting must also be specified.
        :param pulumi.Input[bool] server_side_encryption: When set to true files are encrypted on server side using AES256 algorithm. Defaults to false.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if path_style_access is not None:
            pulumi.set(__self__, "path_style_access", path_style_access)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Name of the S3 bucket to use for snapshots.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        An S3 access key. If set, the secret_key setting must also be specified. If unset, the client will use the instance or container role instead.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The S3 service endpoint to connect to. This defaults to s3.amazonaws.com but the AWS documentation lists alternative S3 endpoints. If you are using an S3-compatible service then you should set this to the service’s endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="pathStyleAccess")
    def path_style_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to force the use of the path style access pattern. If true, the path style access pattern will be used. If false, the access pattern will be automatically determined by the AWS Java SDK (See AWS documentation for details). Defaults to false.
        """
        return pulumi.get(self, "path_style_access")

    @path_style_access.setter
    def path_style_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "path_style_access", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Allows specifying the signing region to use. Specifying this setting manually should not be necessary for most use cases. Generally, the SDK will correctly guess the signing region to use. It should be considered an expert level setting to support S3-compatible APIs that require v4 signatures and use a region other than the default us-east-1. Defaults to empty string which means that the SDK will try to automatically determine the correct signing region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        An S3 secret key. If set, the access_key setting must also be specified.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true files are encrypted on server side using AES256 algorithm. Defaults to false.
        """
        return pulumi.get(self, "server_side_encryption")

    @server_side_encryption.setter
    def server_side_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "server_side_encryption", value)


@pulumi.input_type
class GetDeploymentsApmArgs:
    def __init__(__self__, *,
                 healthy: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str healthy: Overall health status of the resource instances.
        :param str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[str]):
        pulumi.set(self, "healthy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GetDeploymentsElasticsearchArgs:
    def __init__(__self__, *,
                 healthy: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str healthy: Overall health status of the resource instances.
        :param str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[str]):
        pulumi.set(self, "healthy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GetDeploymentsEnterpriseSearchArgs:
    def __init__(__self__, *,
                 healthy: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str healthy: Overall health status of the resource instances.
        :param str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[str]):
        pulumi.set(self, "healthy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GetDeploymentsIntegrationsServerArgs:
    def __init__(__self__, *,
                 healthy: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str healthy: Overall health status of the resource instances.
        :param str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[str]):
        pulumi.set(self, "healthy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class GetDeploymentsKibanaArgs:
    def __init__(__self__, *,
                 healthy: Optional[str] = None,
                 status: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str healthy: Overall health status of the resource instances.
        :param str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @healthy.setter
    def healthy(self, value: Optional[str]):
        pulumi.set(self, "healthy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[str]):
        pulumi.set(self, "version", value)


