#!/usr/bin/python3.8
# -*- coding: utf-8 -*-
# @Author  : youshu.Ji
import codecs
import os
import json
import pickle
import time
# file's io ----------------------------------------------------------------------

# 读txt文件 一次全读完 返回list 去换行
def readtxt_list_all_strip(path, encoding='utf-8'):
    lines = []
    with codecs.open(path, 'r', encoding) as r:
        for line in r.readlines():
            line = line.strip('\n').strip("\r")
            lines.append(line)
        return lines


# 读txt 一次读一行 最后返回list
def readtxt_list_each(path):
    lines = []
    with codecs.open(path, 'r', 'utf-8') as r:
        line = r.readline()
        while line:
            lines.append(line)
            line = r.readline()
    return lines


# 读txt 一次读一行 最后返回list 去换行
def readtxt_list_each_strip(path):
    lines = []
    with codecs.open(path, 'r', 'utf-8') as r:
        line = r.readline()
        while line:
            lines.append(line.strip("\n").strip("\r"))
            line = r.readline()
    return lines


# 读txt文件 一次全读完 返回list
def readtxt_list_all(path):
    with codecs.open(path, 'r', 'utf-8') as r:
        lines = r.readlines()
        return lines


# 读byte文件 读成一条string
def readtxt_byte(path, encoding="utf-8"):
    with codecs.open(path, 'rb') as r:
        lines = r.read()
        lines = lines.decode(encoding)
        return lines.replace('\r', '')


# 读txt文件 读成一条string
def readtxt_string(path, encoding="utf-8"):
    with codecs.open(path, 'r', encoding) as r:
        lines = r.read()
        return lines.replace('\r', '')


# 写txt文件覆盖
def writetxt_w(txt, path, r='w'):
    with codecs.open(path, r, 'utf-8') as w:
        w.writelines(txt)


# 写txt文件追加
def writetxt_a(txt, path):
    with codecs.open(path, 'a', 'utf-8') as w:
        w.writelines(txt)


def writetxt(txt, path, encoding="utf-8"):
    with codecs.open(path, 'w', encoding) as w:
        w.write(txt)


def writetxt_wb(txt, path):
    with codecs.open(path, 'wb') as w:
        w.write(txt)


# 写list 覆盖
def writetxt_w_list(list, path, num_lf=1):
    with codecs.open(path, 'w', "utf-8") as w:
        for i in list:
            w.write(i)
            w.write("\n" * num_lf)


# 写list 追加
def writetxt_a_list(list, path, num_lf=2):
    with codecs.open(path, 'a', "utf-8") as w:
        for i in list:
            w.write(i)
            w.write("\n" * num_lf)


# 写二维list 追加
def writetxt_a_2list(list, path):
    with codecs.open(path, 'a', "utf-8") as w:
        for i in list:
            writetxt_a_list(i, path)




def SaveToJson(content, path):
    with codecs.open(path, "w", "utf-8") as w:
        json.dump(content, w, ensure_ascii=False, indent=1)


def LoadFromJson(path):
    with codecs.open(path, "r", "utf-8") as r:
        content = json.load(r)
        return content


# 读txt文件 读成一条string if gb2312
def readtxt_string_all_encoding(path):
    try:
        with codecs.open(path, 'rb', "utf-8-sig") as r:
            lines = r.read()
            return lines
    except:
        try:
            with codecs.open(path, 'rb', "utf-8") as r:
                lines = r.reacd()
                return lines
        except:
            try:
                with codecs.open(path, 'rb', "big5") as r:
                    lines = r.read()
                    return lines
            except:
                print(path)
                with codecs.open(path, 'rb', "gb2312", errors='ignore') as r:
                    lines = r.read()
                    return lines


def readtxt_list_all_encoding(path):
    try:
        with codecs.open(path, 'rb', "utf-8-sig") as r:
            lines = r.readlines()
            return lines
    except:
        try:
            with codecs.open(path, 'rb', "utf-8") as r:
                lines = r.readlines()
                return lines
        except:
            try:
                with codecs.open(path, 'rb', "big5") as r:
                    lines = r.readlines()
                    return lines
            except:
                with codecs.open(path, 'rb', "gb2312", errors='ignore') as r:
                    lines = r.readlines()
                    return lines

# line by line
def save_to_json(corpus, path):
    with open(path, 'w', encoding='utf-8') as wt:
        for i in corpus:
            wt.write(json.dumps(i, ensure_ascii=False))
            wt.write('\n')


# line by line
def load_from_json(path):
    with open(path, 'r', encoding='utf-8') as rd:
        corpus = []
        while True:
            line = rd.readline()
            if line:
                corpus.append(json.loads(line))
            else:
                break
    return corpus

def pickle_save(data, path):
    with open(path, 'wb') as f:
        pickle.dump(data, f)


def pickle_load(path):
    with open(path, 'rb') as f:
        data = pickle.load(f)
    return data

