# Generated by Django 2.1 on 2018-09-21 20:45

import uuid

import _socket
import django.db.models.deletion
import django_audit_fields.fields.uuid_auto_field
import django_crypto_fields.fields.encrypted_text_field
import django_revision.revision_field
import edc_model_fields.fields.hostname_modification_field
import edc_model_fields.fields.userfield
import edc_utils
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [migrations.swappable_dependency(settings.AUTH_USER_MODEL)]

    operations = [
        migrations.CreateModel(
            name="DataRequest",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=25)),
                ("description", models.TextField(null=True)),
                ("decrypt", models.BooleanField(default=False)),
                (
                    "export_format",
                    models.CharField(choices=[("CSV", "CSV")], default="CSV", max_length=25),
                ),
                (
                    "models",
                    models.TextField(
                        help_text='List one table per line, no commas. Use "label lower" format.'
                    ),
                ),
            ],
            options={"ordering": ("name",)},
        ),
        migrations.CreateModel(
            name="DataRequestHistory",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("archive_filename", models.CharField(max_length=200, null=True)),
                ("emailed_to", models.EmailField(max_length=254, null=True)),
                ("emailed_datetime", models.DateTimeField(null=True)),
                ("summary", models.TextField(null=True)),
                (
                    "exported_datetime",
                    models.DateTimeField(default=edc_utils.date.get_utcnow),
                ),
                (
                    "data_request",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_export.DataRequest",
                    ),
                ),
            ],
            options={"ordering": ("-exported_datetime",)},
        ),
        migrations.CreateModel(
            name="ExportReceipt",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "export_uuid",
                    models.UUIDField(
                        editable=False, help_text="system field for export tracking."
                    ),
                ),
                ("model", models.CharField(max_length=64)),
                ("tx_pk", models.CharField(max_length=36)),
                ("timestamp", models.CharField(max_length=50, null=True)),
                (
                    "received_datetime",
                    models.DateTimeField(help_text="date ACK received", null=True),
                ),
            ],
            options={"ordering": ("-timestamp",)},
        ),
        migrations.CreateModel(
            name="FileHistory",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "history_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="system field for export tracking.",
                        unique=True,
                    ),
                ),
                ("model", models.CharField(max_length=50)),
                (
                    "export_uuid_list",
                    models.TextField(
                        help_text="list of export_uuid's of model app_label.model_name",
                        null=True,
                    ),
                ),
                (
                    "pk_list",
                    models.TextField(
                        help_text="list of pk's of model app_label.model_name",
                        null=True,
                    ),
                ),
                (
                    "exit_message",
                    models.CharField(
                        help_text="exit message from the export_transactions command",
                        max_length=250,
                    ),
                ),
                (
                    "exit_status",
                    models.IntegerField(
                        help_text="0=success, 1=failed from the export_transactions command",
                        null=True,
                    ),
                ),
                (
                    "filename",
                    models.CharField(help_text="original filename on export", max_length=250),
                ),
                (
                    "file_contents",
                    models.TextField(
                        help_text="save contents of file as a list of rows", null=True
                    ),
                ),
                (
                    "exported",
                    models.BooleanField(default=False, help_text="exported to a file"),
                ),
                ("exported_datetime", models.DateTimeField(null=True)),
                ("notification_plan_name", models.CharField(max_length=50, null=True)),
                (
                    "sent",
                    models.BooleanField(
                        default=False, help_text="export file sent to recipient"
                    ),
                ),
                ("sent_datetime", models.DateTimeField(null=True)),
                (
                    "received",
                    models.BooleanField(
                        default=False,
                        help_text="have received an ACK from the recipient",
                    ),
                ),
                ("received_datetime", models.DateTimeField(null=True)),
                (
                    "closed",
                    models.BooleanField(default=False, help_text="exported, sent, received"),
                ),
                ("closed_datetime", models.DateTimeField(null=True)),
            ],
            options={"ordering": ("-sent_datetime",)},
        ),
        migrations.CreateModel(
            name="HistoricalDataRequest",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("name", models.CharField(max_length=25)),
                ("description", models.TextField(null=True)),
                ("decrypt", models.BooleanField(default=False)),
                (
                    "export_format",
                    models.CharField(choices=[("CSV", "CSV")], default="CSV", max_length=25),
                ),
                (
                    "models",
                    models.TextField(
                        help_text='List one table per line, no commas. Use "label lower" format.'
                    ),
                ),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                ("history_date", models.DateTimeField()),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical data request",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalExportReceipt",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "export_uuid",
                    models.UUIDField(
                        editable=False, help_text="system field for export tracking."
                    ),
                ),
                ("model", models.CharField(max_length=64)),
                ("tx_pk", models.CharField(max_length=36)),
                ("timestamp", models.CharField(max_length=50, null=True)),
                (
                    "received_datetime",
                    models.DateTimeField(help_text="date ACK received", null=True),
                ),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                ("history_date", models.DateTimeField()),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical export receipt",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalFileHistory",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "history_uuid",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        help_text="system field for export tracking.",
                    ),
                ),
                ("model", models.CharField(max_length=50)),
                (
                    "export_uuid_list",
                    models.TextField(
                        help_text="list of export_uuid's of model app_label.model_name",
                        null=True,
                    ),
                ),
                (
                    "pk_list",
                    models.TextField(
                        help_text="list of pk's of model app_label.model_name",
                        null=True,
                    ),
                ),
                (
                    "exit_message",
                    models.CharField(
                        help_text="exit message from the export_transactions command",
                        max_length=250,
                    ),
                ),
                (
                    "exit_status",
                    models.IntegerField(
                        help_text="0=success, 1=failed from the export_transactions command",
                        null=True,
                    ),
                ),
                (
                    "filename",
                    models.CharField(help_text="original filename on export", max_length=250),
                ),
                (
                    "file_contents",
                    models.TextField(
                        help_text="save contents of file as a list of rows", null=True
                    ),
                ),
                (
                    "exported",
                    models.BooleanField(default=False, help_text="exported to a file"),
                ),
                ("exported_datetime", models.DateTimeField(null=True)),
                ("notification_plan_name", models.CharField(max_length=50, null=True)),
                (
                    "sent",
                    models.BooleanField(
                        default=False, help_text="export file sent to recipient"
                    ),
                ),
                ("sent_datetime", models.DateTimeField(null=True)),
                (
                    "received",
                    models.BooleanField(
                        default=False,
                        help_text="have received an ACK from the recipient",
                    ),
                ),
                ("received_datetime", models.DateTimeField(null=True)),
                (
                    "closed",
                    models.BooleanField(default=False, help_text="exported, sent, received"),
                ),
                ("closed_datetime", models.DateTimeField(null=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                ("history_date", models.DateTimeField()),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical file history",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalObjectHistory",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "exported",
                    models.BooleanField(
                        default=False,
                        editable=False,
                        help_text="system field for export tracking. considered 'exported' if both sent and received.",
                    ),
                ),
                (
                    "export_change_type",
                    models.CharField(
                        choices=[("I", "Insert"), ("U", "Update"), ("D", "Delete")],
                        default="I",
                        editable=False,
                        help_text="system field for export tracking.",
                        max_length=1,
                    ),
                ),
                (
                    "export_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="system field for export tracking.",
                    ),
                ),
                ("model", models.CharField(max_length=64)),
                ("tx_pk", models.UUIDField()),
                (
                    "tx",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True, help_text=" (Encryption: AES local)", max_length=71
                    ),
                ),
                ("exported_datetime", models.DateTimeField()),
                (
                    "timestamp",
                    models.CharField(db_index=True, max_length=50, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("exported", "Exported"),
                            ("closed", "Closed"),
                            ("cancelled", "Cancelled"),
                        ],
                        default="New",
                        help_text="exported by export_transactions, closed by import_receipts",
                        max_length=15,
                    ),
                ),
                (
                    "received",
                    models.BooleanField(default=False, help_text="True if ACK received"),
                ),
                (
                    "received_datetime",
                    models.DateTimeField(help_text="date ACK received", null=True),
                ),
                (
                    "is_ignored",
                    models.BooleanField(default=False, help_text="Ignore if update"),
                ),
                ("is_error", models.BooleanField(default=False)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                ("history_date", models.DateTimeField()),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical object history",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalPlan",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=25)),
                ("model", models.CharField(max_length=50)),
                (
                    "field_names",
                    models.TextField(blank=True, max_length=500, null=True),
                ),
                (
                    "header_labels",
                    models.TextField(blank=True, max_length=500, null=True),
                ),
                ("lookups", models.TextField(blank=True, max_length=500, null=True)),
                (
                    "model_type",
                    models.CharField(
                        choices=[
                            ("consent", "Consent"),
                            ("crf", "CRF"),
                            ("locator", "Locator"),
                            ("plain", "Plain"),
                        ],
                        default="plain",
                        max_length=25,
                    ),
                ),
                (
                    "excluded_field_names",
                    models.TextField(blank=True, max_length=500, null=True),
                ),
                (
                    "header",
                    models.BooleanField(default=True, verbose_name="Include header"),
                ),
                (
                    "encrypt",
                    models.BooleanField(default=True, verbose_name="Mask encrypted values"),
                ),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                ("history_date", models.DateTimeField()),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        primary_key=True, serialize=False
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical plan",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="ObjectHistory",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "exported",
                    models.BooleanField(
                        default=False,
                        editable=False,
                        help_text="system field for export tracking. considered 'exported' if both sent and received.",
                    ),
                ),
                (
                    "export_change_type",
                    models.CharField(
                        choices=[("I", "Insert"), ("U", "Update"), ("D", "Delete")],
                        default="I",
                        editable=False,
                        help_text="system field for export tracking.",
                        max_length=1,
                    ),
                ),
                (
                    "export_uuid",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        help_text="system field for export tracking.",
                    ),
                ),
                ("model", models.CharField(max_length=64)),
                ("tx_pk", models.UUIDField()),
                (
                    "tx",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True, help_text=" (Encryption: AES local)", max_length=71
                    ),
                ),
                ("exported_datetime", models.DateTimeField()),
                (
                    "timestamp",
                    models.CharField(db_index=True, max_length=50, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("exported", "Exported"),
                            ("closed", "Closed"),
                            ("cancelled", "Cancelled"),
                        ],
                        default="New",
                        help_text="exported by export_transactions, closed by import_receipts",
                        max_length=15,
                    ),
                ),
                (
                    "received",
                    models.BooleanField(default=False, help_text="True if ACK received"),
                ),
                (
                    "received_datetime",
                    models.DateTimeField(help_text="date ACK received", null=True),
                ),
                (
                    "is_ignored",
                    models.BooleanField(default=False, help_text="Ignore if update"),
                ),
                ("is_error", models.BooleanField(default=False)),
            ],
            options={"ordering": ("-timestamp",)},
        ),
        migrations.CreateModel(
            name="Plan",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("name", models.CharField(max_length=25, unique=True)),
                ("model", models.CharField(max_length=50)),
                (
                    "field_names",
                    models.TextField(blank=True, max_length=500, null=True),
                ),
                (
                    "header_labels",
                    models.TextField(blank=True, max_length=500, null=True),
                ),
                ("lookups", models.TextField(blank=True, max_length=500, null=True)),
                (
                    "model_type",
                    models.CharField(
                        choices=[
                            ("consent", "Consent"),
                            ("crf", "CRF"),
                            ("locator", "Locator"),
                            ("plain", "Plain"),
                        ],
                        default="plain",
                        max_length=25,
                    ),
                ),
                (
                    "excluded_field_names",
                    models.TextField(blank=True, max_length=500, null=True),
                ),
                (
                    "header",
                    models.BooleanField(default=True, verbose_name="Include header"),
                ),
                (
                    "encrypt",
                    models.BooleanField(default=True, verbose_name="Mask encrypted values"),
                ),
            ],
            options={
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="UploadExportReceiptFile",
            fields=[
                (
                    "created",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=edc_utils.date.get_utcnow),
                ),
                (
                    "user_created",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    edc_model_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    edc_model_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "export_receipt_file",
                    models.FileField(upload_to="media/edc_export/uploads"),
                ),
                (
                    "file_name",
                    models.CharField(editable=False, max_length=50, null=True, unique=True),
                ),
                ("app_label", models.CharField(max_length=50)),
                ("model_name", models.CharField(max_length=50)),
                ("accepted", models.IntegerField(default=0, editable=False)),
                ("duplicate", models.IntegerField(default=0, editable=False)),
                ("total", models.IntegerField(default=0, editable=False)),
                ("errors", models.TextField(editable=False, null=True)),
                ("receipt_datetime", models.DateTimeField(editable=False, null=True)),
            ],
            options={"ordering": ("-created",)},
        ),
    ]
