import json
import logging
import os
import re
from pprint import pformat

from httmock import HTTMock, urlmatch


class NominodeMock(HTTMock):
    def __init__(self, task_parameters=None):
        super().__init__(self.api_match)
        self.logger = logging.getLogger("nomigen.nominode-mock")
        self.params = task_parameters or {}
        self.calls = []

    def __enter__(self):
        super().__enter__()
        self.old_environ = os.environ.copy()
        os.environ["execution_uuid"] = "TEST_UUID"
        os.environ["task_uuid"] = "TASK_UUID"
        os.environ["project_uuid"] = "TEST_PROJECT"
        os.environ["nomnom_api"] = "http://127.0.0.1:9090"
        os.environ["token"] = "token"
        return self

    def __exit__(self, type, value, traceback):
        super().__exit__(type, value, traceback)
        os.environ.clear()
        os.environ.update(self.old_environ)

    @urlmatch(netloc=r"(.*\.)?127.0.0.1:9090$")
    def api_match(self, url, request):
        match = re.match(r"/connection/(?P<uuid>.+)/update", url.path)
        if match:
            json_data = request.body
            loaded = json.loads(json_data)
            uuid = match.groupdict()["uuid"]
            self.params["config"][uuid] = json.loads(loaded["parameters"])
            self.logger.debug("Caught connections update. Test creds updated")
        elif url.path == "/execution/log/TEST_UUID":
            json_data = request.body
            # self.logger.debug("Caught log message {}".format(json_data))
            loaded = json.loads(json_data)
        elif url.path == "/task/TEST_UUID/update":
            json_data = request.body
            loaded = json.loads(json_data)
            self.logger.debug("Caught task update {}".format(pformat(loaded)))
        elif url.path == "/execution/update/TEST_UUID":
            json_data = request.body
            loaded = json.loads(json_data)
            self.logger.debug(
                "Caught execution progress update {}".format(pformat(loaded))
            )
        else:
            self.logger.info(
                f"Unknown api endpoint called {url.path}, \n Body {request.body}"
            )
        self.calls.append((url.path, json.loads(request.body)))
        return '{"you_logged":"test"}'
