ReLax
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

![Python](https://img.shields.io/pypi/pyversions/jax-relax.svg) ![CI
status](https://github.com/BirkhoffG/ReLax/actions/workflows/test.yaml/badge.svg)
![Docs](https://github.com/BirkhoffG/ReLax/actions/workflows/deploy.yaml/badge.svg)
![pypi](https://img.shields.io/pypi/v/jax-relax.svg) ![GitHub
License](https://img.shields.io/github/license/BirkhoffG/ReLax.svg)

[**Overview**](#overview) \| [**Installation**](#installation) \|
[**Tutorials**](tutorials/getting_started.ipynb) \|
[**Documentation**](https://birkhoffg.github.io/ReLax/) \| [**Citing
ReLax**](#citing-relax)

## Overview

`ReLax` (**Re**course Explanation **L**ibrary in J**ax**) is a library
built on top of `jax` to generate counterfactual and recourse
explanations. By leveraging *vectorization* though `vmap`/`pmap` and
*just-in-time* compilation in `jax`, `ReLax` offers massive speed
improvements in generating individual (or local) explanations.

Some of the key features:

- 🏃 **Fast** recourse generation via `jax.jit`, `jax.vmap`/`jax.pmap`.

- 🚀 **Accelerated** over `cpu`, `gpu`, `tpu`.

- 🪓 **Extensive** recourse methods implemented for benchmarking.

- 👐 **Customizable** API to enable building entire modeling and
  interpreting pipeline.

## Installation

The latest `ReLax` release can directly be installed from PyPI:

``` bash
pip install jax-relax
```

or install directly from the repository:

``` bash
pip install git+https://github.com/BirkhoffG/ReLax.git 
```

To futher unleash the power of accelerators (i.e., GPU/TPU), we suggest
to first install this library via `pip install jax-relax`. Then, follow
steps in the [official install
guidelines](https://github.com/google/jax#installation) to install the
right version for GPU or TPU.

## An Example of using `ReLax`

See [Getting Started with ReLax](tutorials/getting_started.ipynb).

## Citing `ReLax`

To cite this repository:

``` latex
@software{relax2023github,
  author = {Hangzhi Guo and Xinchang Xiong and Amulya Yadav},
  title = {{R}e{L}ax: Recourse Explanation Library in Jax},
  url = {http://github.com/birkhoffg/ReLax},
  version = {0.1.0},
  year = {2023},
}
```
