# generated by fastapi-codegen:
#   filename:  /home/circleci/project/guardicore/connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, ConfigDict, Field

from ..common.common import Connector


class ChainName(Enum):
    OVERRIDE_ALLOW = 'override-allow'
    OVERRIDE_ALERT = 'override-alert'
    OVERRIDE_BLOCK = 'override-block'
    ALLOW = 'allow'
    ALERT = 'alert'
    BLOCK = 'block'


class Protocol(Enum):
    TCP = 'tcp'
    UDP = 'udp'
    ICMP = 'icmp'
    ALL = 'all'


class Verdict(Enum):
    ALLOW = 'allow'
    BLOCK = 'block'


class Attributes(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    auto_create_sg: Optional[bool] = Field(None, alias='auto-create-sg')


class CompoundLabel(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    include_labels: List[List[str]] = Field(..., alias='include-labels')
    exclude_labels: Optional[List[List[str]]] = Field(None, alias='exclude-labels')


class PortRangeMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    start: int
    end: int


class ProcessMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    image_path: Optional[str] = Field(None, alias='image-path')
    image_basename: Optional[str] = Field(None, alias='image-basename')


class DomainGroupMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    domain_name: str = Field(..., alias='domain-name')
    sid: str
    gname: str


class Ver(Enum):
    INTEGER_4 = 4
    INTEGER_6 = 6


class IcmpMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    ver: Ver
    type: int
    codes: Optional[List[int]] = None


class WinServiceMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    service_name: Optional[str] = Field(None, alias='service-name')
    service_image_names: Optional[List[str]] = Field(None, alias='service-image-names')


class AddressRange(Enum):
    PRIVATE = 'Private'
    INTERNET = 'Internet'


class Op(Enum):
    EQUALS = 'equals'
    STARTS_WITH = 'starts-with'
    ENDS_WITH = 'ends-with'
    CONTAINS = 'contains'
    WILDCARDS = 'wildcards'
    REGEX = 'regex'


class CriterionType(Enum):
    HOSTNAME = 'hostname'
    SUBSCRIPTION = 'subscription'
    VNET = 'vnet'
    SUBNET = 'subnet'
    REGION = 'region'
    RESOURCE_GROUP = 'resource_group'
    TAG = 'tag'
    PLATFORM = 'platform'
    RESOURCE_TYPE = 'resource_type'
    SERVICE_TAG = 'service_tag'
    ROLE = 'role'
    HW_TYPE = 'hw_type'
    HW_CLASS = 'hw_class'
    HW_MANUFACTURER = 'hw_manufacturer'
    ACCOUNT = 'account'
    ACCOUNT_ID = 'account_id'
    VPC = 'vpc'
    AVAILABILITY_ZONE = 'availability_zone'
    RESOURCE_ARN = 'resource_arn'


class DCInventoryItem(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    item_id: str = Field(..., alias='item-id')
    external_id: Optional[str] = Field(None, alias='external-id')
    ip_addresses: Optional[List[str]] = Field(None, alias='ip-addresses')


class Action(Enum):
    SET = 'set'
    UPDATE = 'update'


class GroupMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    domain_groups: Optional[List[DomainGroupMatch]] = Field(None, alias='domain-groups')
    local_admins: Optional[bool] = Field(None, alias='local-admins')
    local_users: Optional[bool] = Field(None, alias='local-users')


class LabelCriterion(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: CriterionType
    op: Op
    argument: str
    resolvable: Connector = Field(
        ..., description='determine which connector can resolve criteria matched assets'
    )


class EntityMatch(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    match_labels: Optional[CompoundLabel] = Field(None, alias='match-labels')
    match_multiple_subnets: Optional[List[str]] = Field(
        None, alias='match-multiple-subnets'
    )
    match_inventory_items: Optional[List[str]] = Field(
        None, alias='match-inventory-items'
    )
    match_ports: Optional[List[int]] = Field(None, alias='match-ports')
    match_port_ranges: Optional[List[PortRangeMatch]] = Field(
        None, alias='match-port-ranges'
    )
    match_processes: Optional[List[ProcessMatch]] = Field(None, alias='match-processes')
    match_dns_list: Optional[List[str]] = Field(None, alias='match-dns-list')
    match_groups: Optional[GroupMatch] = Field(None, alias='match-groups')
    match_icmp_types: Optional[List[IcmpMatch]] = Field(None, alias='match-icmp-types')
    match_win_services: Optional[List[WinServiceMatch]] = Field(
        None, alias='match-win-services'
    )
    match_win_any_services: Optional[bool] = Field(None, alias='match-win-any-services')
    match_address_range: Optional[AddressRange] = Field(
        None, alias='match-address-range'
    )


class LabelInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    label_id: str = Field(..., alias='label-id')
    key: Optional[str] = None
    value: Optional[str] = None
    label_criteria: Optional[List[LabelCriterion]] = Field(None, alias='label-criteria')
    labeled_items: Optional[List[str]] = Field(
        None,
        alias='labeled-items',
        description='The list of asset ids that belong to this label. Asset ids must exist provider the inventory-items array.',
    )


class PolicyRule(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    match_src: EntityMatch = Field(..., alias='match-src')
    match_dst: EntityMatch = Field(..., alias='match-dst')
    protocols: List[Protocol]
    verdict: Verdict
    rule_id: Optional[str] = None
    ruleset_name: Optional[str] = None
    attributes: Optional[Attributes] = None


class EnforcementPolicyInventory(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    labels: Optional[List[LabelInfo]] = Field(
        None, description='Array of all the labels.'
    )
    inventory_items: Optional[List[DCInventoryItem]] = Field(
        None, alias='inventory-items'
    )
    dc_inventory_revision: int = Field(..., alias='dc-inventory-revision')
    policy_revision: int = Field(..., alias='policy-revision')


class PolicyChain(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    chain_name: ChainName = Field(..., alias='chain-name')
    rules: List[PolicyRule]


class EnforcementPolicy(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    policy_rules: Optional[List[PolicyChain]] = Field(None, alias='policy-rules')
    policy_revision: int = Field(..., alias='policy-revision')
    policy_entity: Optional[str] = Field(None, alias='policy-entity')
