# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Enforcement'])
registry = HandlerRegistry()


@registry.register()
class EnforcementHandler:
    def __init__(self):
        pass

    def set_enforcement_policy_inventory(
        self, action: Optional[Action] = 'set', body: EnforcementPolicyInventory = ...
    ) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"set_enforcement_policy_inventory not implemented"
        )

    def set_enforcement_policy(
        self, action: Optional[Action] = 'set', body: EnforcementPolicy = ...
    ) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"set_enforcement_policy not implemented"
        )


@router.post('/v1/consumer/inventory', response_model=None, tags=['Enforcement'])
def set_enforcement_policy_inventory(
    action: Optional[Action] = 'set', body: EnforcementPolicyInventory = ...
) -> None:
    """
    Set enforcement policy inventory
    """
    return registry.call_handler(
        set_enforcement_policy_inventory.__name__, action, body
    )


@router.post('/v1/consumer/policy', response_model=None, tags=['Enforcement'])
def set_enforcement_policy(
    action: Optional[Action] = 'set', body: EnforcementPolicy = ...
) -> None:
    """
    Set enforcement policy
    """
    return registry.call_handler(set_enforcement_policy.__name__, action, body)
