# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Health'])
registry = HandlerRegistry()


@registry.register()
class HealthHandler:
    def __init__(self):
        pass

    def get_integration_flags(
        self,
    ) -> V1OperationsFlagsGetResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_flags not implemented"
        )

    def get_integration_status(
        self,
    ) -> V1OperationsHealthGetResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_status not implemented"
        )

    def get_integration_metrics(
        self,
    ) -> V1OperationsMetricsGetResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_metrics not implemented"
        )


@router.get(
    '/v1/operations/flags', response_model=V1OperationsFlagsGetResponse, tags=['Health']
)
def get_integration_flags() -> V1OperationsFlagsGetResponse:
    """
    Endpoint to retrieve components flags
    """
    return registry.call_handler(
        get_integration_flags.__name__,
    )


@router.get(
    '/v1/operations/health',
    response_model=V1OperationsHealthGetResponse,
    tags=['Health'],
)
def get_integration_status() -> V1OperationsHealthGetResponse:
    """
    Endpoint to retrieve components status
    """
    return registry.call_handler(
        get_integration_status.__name__,
    )


@router.get(
    '/v1/operations/metrics',
    response_model=V1OperationsMetricsGetResponse,
    tags=['Health'],
)
def get_integration_metrics() -> V1OperationsMetricsGetResponse:
    """
    Endpoint to retrieve components metrics
    """
    return registry.call_handler(
        get_integration_metrics.__name__,
    )
