# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Info'])
registry = HandlerRegistry()


@registry.register()
class InfoHandler:
    def __init__(self):
        pass

    def get_integration_details(
        self,
    ) -> IntegrationEnvInfo:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_details not implemented"
        )

    def get_integration_units_details(
        self,
        cursor: Optional[conint(ge=0)] = 0,
        page_size: Optional[conint(ge=1, le=1000)] = 100,
    ) -> EnvUnits:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_units_details not implemented"
        )


@router.get('/v1/operations/env-info', response_model=IntegrationEnvInfo, tags=['Info'])
def get_integration_details() -> IntegrationEnvInfo:
    """
    Endpoint to retrieve integration environment details. Should fit in one response page.
    """
    return registry.call_handler(
        get_integration_details.__name__,
    )


@router.get('/v1/operations/env-units-list', response_model=EnvUnits, tags=['Info'])
def get_integration_units_details(
    cursor: Optional[conint(ge=0)] = 0, page_size: Optional[conint(ge=1, le=1000)] = 100
) -> EnvUnits:
    """
    Endpoint to retrieve integration environment logical units details. This endpoint support pagination for big amount of units
    """
    return registry.call_handler(
        get_integration_units_details.__name__, cursor, page_size
    )
