# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Onboarding'])
registry = HandlerRegistry()


@registry.register()
class OnboardingHandler:
    def __init__(self):
        pass

    def on_board(self, body: Onboard) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"on_board not implemented")

    def get_on_boarding_status(self, body: StatusRequest) -> StatusResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_on_boarding_status not implemented"
        )


@router.post('/v1/operations/onboarding', response_model=None, tags=['Onboarding'])
def on_board(body: Onboard) -> None:
    """
    Endpoint to onboard connector
    """
    return registry.call_handler(on_board.__name__, body)


@router.post(
    '/v1/operations/status', response_model=StatusResponse, tags=['Onboarding']
)
def get_on_boarding_status(body: StatusRequest) -> StatusResponse:
    """
    Endpoint to get onboarding status
    """
    return registry.call_handler(get_on_boarding_status.__name__, body)
