# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Operations'])
registry = HandlerRegistry()


@registry.register()
class OperationsHandler:
    def __init__(self):
        pass

    def get_integration_configuration_options(
        self,
    ) -> InternalConfigMetadata:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404,
            detail=f"get_integration_configuration_options not implemented",
        )

    def set_integration_configuration(self, body: InternalConfig) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"set_integration_configuration not implemented"
        )


@router.get(
    '/v1/operations/internal/config_metadata',
    response_model=InternalConfigMetadata,
    tags=['Operations'],
)
def get_integration_configuration_options() -> InternalConfigMetadata:
    """
    Endpoint to retrieve internal configuration options
    """
    return registry.call_handler(
        get_integration_configuration_options.__name__,
    )


@router.post(
    '/v1/operations/internal/internal_config', response_model=None, tags=['Operations']
)
def set_integration_configuration(body: InternalConfig) -> None:
    """
    Endpoint to set internal services configuration
    """
    return registry.call_handler(set_integration_configuration.__name__, body)
