# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import FastAPI

from .routers import (
    agents,
    control,
    enforcement,
    health,
    info,
    inventory,
    logging,
    onboarding,
    operations,
)

app = FastAPI(
    title='Version Handshake API',
    description='Version API , Centra Integration Controller rely on to integrate with 3rd party platforms.\n\nSome useful links:\n- [Contracts OpenApi spec](https://github.com/guardicore/contracts)',
    license={
        'name': 'Apache 2.0',
        'url': 'https://www.apache.org/licenses/LICENSE-2.0.html',
    },
    version='1.10.0',
    servers=[{'url': 'http://127.0.0.1:8000'}],
)

app.include_router(agents.router)
app.include_router(control.router)
app.include_router(enforcement.router)
app.include_router(health.router)
app.include_router(info.router)
app.include_router(inventory.router)
app.include_router(logging.router)
app.include_router(onboarding.router)
app.include_router(operations.router)


@app.get("/")
async def root():
    return {"message": "Gateway of the App"}
