# generated by fastapi-codegen:
#   filename:  /home/circleci/project/guardicore/connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, ConfigDict, Field

from ..common.inventory import InventoryItem


class ProcessInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    process_name: str = Field(
        ..., alias='process-name', description='Name of the process.'
    )
    image_path: Optional[str] = Field(
        None, alias='image-path', description='Path to the executable of the process.'
    )
    cmdline: Optional[List[str]] = Field(
        None, description='Command line arguments used for the process.'
    )


class Verdict(Enum):
    ALLOW = 'allow'
    ALERT = 'alert'
    BLOCK = 'block'


class EnforcementInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    rule_id: Optional[str] = Field(None, alias='rule-id')
    rule_name: Optional[str] = Field(None, alias='rule-name')
    connector_dst_rule_id: Optional[str] = Field(None, alias='connector-dst-rule-id')
    connector_src_rule_id: Optional[str] = Field(None, alias='connector-src-rule-id')
    verdict: Optional[Verdict] = None
    policy_revision: Optional[int] = Field(None, alias='policy-revision')
    dc_inventory_revision: Optional[int] = Field(None, alias='dc-inventory-revision')
    ruleset_name: Optional[str] = Field('', alias='ruleset-name')


class Type(Enum):
    SNAT = 'snat'
    DNAT = 'dnat'
    SNAT_AND_DNAT = 'snat_and_dnat'


class NatInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    source_ip: str = Field(..., alias='source-ip', description='NAT source IP address.')
    dest_ip: str = Field(
        ..., alias='dest-ip', description='NAT destination IP address.'
    )
    dest_port: int = Field(..., alias='dest-port', description='NAT destination port.')
    type: Type = Field(..., description='Type of NAT.')


class ReportingEntity(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    uuid: str = Field(
        ...,
        description='Unique identifier for the reporting entity such as CloudApp id',
    )
    type: str = Field(..., description='Type of the reporting entity such as CloudApp')


class Direction(Enum):
    OUTBOUND = 'outbound'
    INBOUND = 'inbound'
    BI_DIRECTIONAL = 'bi-directional'
    OUTBOUND_ONLY = 'outbound-only'


class EventType(Enum):
    SUCCESSFUL = 'successful'
    FAILED = 'failed'
    REDIRECTED = 'redirected'


class IpProtocol(Enum):
    TCP = 'tcp'
    UDP = 'udp'
    ICMP = 'icmp'


class IpVersion(Enum):
    IPV4 = 'ipv4'
    IPV6 = 'ipv6'


class EnforcementState(Enum):
    REVEAL_ONLY = 'reveal-only'
    MONITORING = 'monitoring'
    ENFORCING = 'enforcing'


class ConnectionInfo(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    direction: Direction = Field(
        ...,
        description='Indicates the direction of the network event; bi-directional is reported for two-sided connection; outbound-only - Destination is PaaS resource behind a private endpoint. ',
    )
    event_type: EventType = Field(
        ...,
        alias='event-type',
        description='Type of network event that occurred; redirected is used for honeypot',
    )
    source_ip: str = Field(
        ..., alias='source-ip', description='Source IP address of the network event.'
    )
    dest_ip: str = Field(
        ..., alias='dest-ip', description='Destination IP address of the network event.'
    )
    dest_port: int = Field(
        ...,
        alias='dest-port',
        description='Destination port number for the network event.',
    )
    ip_protocol: IpProtocol = Field(
        ..., alias='ip-protocol', description='IP protocol used in the network event.'
    )
    ip_version: IpVersion = Field(
        ..., alias='ip-version', description='IP version used in the network event.'
    )
    enforcement_state: EnforcementState = Field(
        ...,
        alias='enforcement-state',
        description="Specifies the enforcement level for a network event: 'monitoring' for policy evaluation but allows traffic, and 'reveal only' for data reporting without policy evaluation.",
    )
    enforcement_info: Optional[EnforcementInfo] = Field(
        None,
        alias='enforcement-info',
        description='Additional enforcement information.',
    )
    nat_info: Optional[NatInfo] = Field(
        None,
        alias='nat-info',
        description='Information about Network Address Translation.',
    )
    source_process_info: Optional[ProcessInfo] = Field(
        None,
        alias='source-process-info',
        description='Information about the source process involved in the network event.',
    )
    dest_process_info: Optional[ProcessInfo] = Field(
        None,
        alias='dest-process-info',
        description='Information about the destination process involved in the network event.',
    )
    source_inventory_item: Optional[InventoryItem] = Field(
        None,
        alias='source-inventory-item',
        description='Inventory information for the source in the network event.',
    )
    dest_inventory_item: Optional[InventoryItem] = Field(
        None,
        alias='dest-inventory-item',
        description='Inventory information for the destination in the network event.',
    )
    source_username: Optional[str] = Field(
        None,
        alias='source-username',
        description='Username associated with the source in the network event.',
    )
    dest_username: Optional[str] = Field(
        None,
        alias='dest-username',
        description='Username associated with the destination in the network event.',
    )
    dest_domain: Optional[str] = Field(
        None,
        alias='dest-domain',
        description='Domain associated with the destination in the network event (FQDN)',
    )
    start_time: int = Field(
        ...,
        alias='start-time',
        description='Start time of the network event.** for aggregated events (epoch in seconds)',
    )
    end_time: int = Field(
        ...,
        alias='end-time',
        description='End time of the network event.** for aggregated events (epoch in seconds)',
    )
    count: int = Field(..., description='Number of occurrences of the network event.')
    reporting_entity: ReportingEntity = Field(
        ...,
        alias='reporting-entity',
        description='Entity that reported the network event.',
    )
