# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Control'])
registry = HandlerRegistry()


@registry.register()
class ControlHandler:
    def __init__(self):
        pass

    def version_hanshake(self, body: VersionHandshakeData) -> VersionHandshakeData:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"version_hanshake not implemented")


@router.post(
    '/version-handshake', response_model=VersionHandshakeData, tags=['Control']
)
def version_hanshake(body: VersionHandshakeData) -> VersionHandshakeData:
    """
    Perform version handshake
    """
    return registry.call_handler(version_hanshake.__name__, body)
