# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-06T13:42:39+00:00

from __future__ import annotations

from fastapi import APIRouter, HTTPException

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Logging'])
registry = HandlerRegistry()


@registry.register()
class LoggingHandler:
    def __init__(self):
        pass

    def get_logs(self, id: Optional[UUID] = None) -> bytes:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"get_logs not implemented")

    def start_logging(self, body: LogStart) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"start_logging not implemented")

    def get_logging_status(self, id: Optional[UUID] = None) -> LogStatus:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_logging_status not implemented"
        )

    def stop_logging(self, id: Optional[UUID] = None) -> None:
        """This method should be implemented by the subclass."""
        raise HTTPException(status_code=404, detail=f"stop_logging not implemented")


@router.get('/v1/operations/log/download', response_model=bytes, tags=['Logging'])
def get_logs(id: Optional[UUID] = None) -> bytes:
    """
    Endpoint to retrieve component logs
    """
    return registry.call_handler(get_logs.__name__, id)


@router.post('/v1/operations/log/start', response_model=None, tags=['Logging'])
def start_logging(body: LogStart) -> None:
    """
    Endpoint for instructing component to gather logs
    """
    return registry.call_handler(start_logging.__name__, body)


@router.get('/v1/operations/log/status', response_model=LogStatus, tags=['Logging'])
def get_logging_status(id: Optional[UUID] = None) -> LogStatus:
    """
    Endpoint to query component on logs gathering status
    """
    return registry.call_handler(get_logging_status.__name__, id)


@router.get('/v1/operations/log/stop', response_model=None, tags=['Logging'])
def stop_logging(id: Optional[UUID] = None) -> None:
    """
    Endpoint to abort logs gathering
    """
    return registry.call_handler(stop_logging.__name__, id)
