"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureLogBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secure_bucket_1 = require("@gammarer/aws-secure-bucket");
const cdk = require("aws-cdk-lib");
const s3 = require("aws-cdk-lib/aws-s3");
class SecureLogBucket extends aws_secure_bucket_1.SecureBucket {
    constructor(scope, id, props) {
        super(scope, id, {
            bucketName: props?.bucketName,
            encryption: aws_secure_bucket_1.SecureBucketEncryption.KMS_MANAGED,
            versioned: true,
            objectOwnership: props?.objectOwnership,
            lifecycleRules: [{
                    id: 'archive-step-lifecycle-rule',
                    enabled: true,
                    transitions: [
                        {
                            storageClass: s3.StorageClass.INFREQUENT_ACCESS,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.infrequentAccessDays ?? 60),
                        },
                        {
                            storageClass: s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.intelligentTieringDays ?? 120),
                        },
                        {
                            storageClass: s3.StorageClass.GLACIER,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.glacierDays ?? 180),
                        },
                        {
                            storageClass: s3.StorageClass.DEEP_ARCHIVE,
                            transitionAfter: cdk.Duration.days(props?.changeClassTransition?.deepArchiveDays ?? 360),
                        },
                    ],
                }],
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
SecureLogBucket[_a] = { fqn: "@gammarer/aws-secure-log-bucket.SecureLogBucket", version: "0.13.1" };
exports.SecureLogBucket = SecureLogBucket;
//# sourceMappingURL=data:application/json;base64,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