# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.1
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _gazebo
else:
    import _gazebo

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def ToGazeboWorld(base):
    return _gazebo.ToGazeboWorld(base)

def ToGazeboModel(base):
    return _gazebo.ToGazeboModel(base)

def ToGazeboJoint(base):
    return _gazebo.ToGazeboJoint(base)

def ToGazeboLink(base):
    return _gazebo.ToGazeboLink(base)
class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gazebo.delete_SwigPyIterator

    def value(self):
        return _gazebo.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _gazebo.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _gazebo.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _gazebo.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _gazebo.SwigPyIterator_equal(self, x)

    def copy(self):
        return _gazebo.SwigPyIterator_copy(self)

    def next(self):
        return _gazebo.SwigPyIterator_next(self)

    def __next__(self):
        return _gazebo.SwigPyIterator___next__(self)

    def previous(self):
        return _gazebo.SwigPyIterator_previous(self)

    def advance(self, n):
        return _gazebo.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _gazebo.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _gazebo.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _gazebo.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _gazebo.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _gazebo.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _gazebo.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _gazebo:
_gazebo.SwigPyIterator_swigregister(SwigPyIterator)

SHARED_PTR_DISOWN = _gazebo.SHARED_PTR_DISOWN
import scenario.bindings.core
Verbosity_suppress_all = _gazebo.Verbosity_suppress_all
Verbosity_error = _gazebo.Verbosity_error
Verbosity_warning = _gazebo.Verbosity_warning
Verbosity_info = _gazebo.Verbosity_info
Verbosity_debug = _gazebo.Verbosity_debug

def set_verbosity(*args):
    r"""
    Set the verbosity process-wise.

    Accepted levels are the following:

    - ``Verbosity::SuppressAll``: No messages.
    - ``Verbosity::Error``: Error messages.
    - ``Verbosity::Warning``: Error and warning messages.
    - ``Verbosity::Info``: Error, warning, and info messages.
    - ``Verbosity::Debug``: Error, warning, info, and debug messages.

    If called without specifying the level, it will use
    ``Verbosity::Warning`` or ``Verbosity::Debug`` depending if the project
    was compiled respectively with Release or Debug flags.

    :type level: int
    :param level: The verbosity level.
    """
    return _gazebo.set_verbosity(*args)

def find_sdf_file(file_name):
    r"""
    Find a SDF file in the filesystem.

    The search path is defined with the ``IGN_GAZEBO_RESOURCE_PATH``
    environment variable.

    :type fileName: string
    :param fileName: The SDF file name.
    :rtype: string
    :return: The absolute path to the file if found, an empty string
                otherwise.
    """
    return _gazebo.find_sdf_file(file_name)

def sdf_string_valid(sdf_string):
    r"""
    Check if a SDF string is valid.

    An SDF string could contain for instance an SDF model or
    an SDF world, and it is valid if it can be parsed successfully
    by the SDFormat library.

    :type sdfString: string
    :param sdfString: The SDF string to check.
    :rtype: boolean
    :return: True if the SDF string is valid, false otherwise.
    """
    return _gazebo.sdf_string_valid(sdf_string)

def get_sdf_string(file_name):
    r"""
    Get an SDF string from a SDF file.

    :type fileName: string
    :param fileName: An SDF file. It could be either an absolute path
               to the file or the file name if the parent folder is part
               of the ``IGN_GAZEBO_RESOURCE_PATH`` environment variable.
    :rtype: string
    :return: The SDF string if the file was found and is valid, an
                empty string otherwise.
    """
    return _gazebo.get_sdf_string(file_name)

def get_model_name_from_sdf(file_name, model_index=0):
    r"""
    Get the name of a model from a SDF file.

    :type fileName: string
    :param fileName: An SDF file. It could be either an absolute path
               to the file or the file name if the parent folder is part
               of the ``IGN_GAZEBO_RESOURCE_PATH`` environment variable.
    :type modelIndex: int
    :param modelIndex: The index of the model in the SDF file. By
               default it finds the first model.
    :rtype: string
    :return: The name of the model.
    """
    return _gazebo.get_model_name_from_sdf(file_name, model_index)

def get_world_name_from_sdf(file_name, world_index=0):
    r"""
    Get the name of a world from a SDF file.

    :type fileName: string
    :param fileName: An SDF file. It could be either an absolute path
               to the file or the file name if the parent folder is part
               of the ``IGN_GAZEBO_RESOURCE_PATH`` environment variable.
    :type worldIndex: int
    :param worldIndex: The index of the world in the SDF file. By
               default it finds the first world.
    :rtype: string
    :return: The name of the world.
    """
    return _gazebo.get_world_name_from_sdf(file_name, world_index)

def get_empty_world():
    r"""
    Return a SDF string with an empty world.

    An empty world only has a sun and the default DART
    physics profile enabled.

    Notes: The empty world does not have any ground plane.

    :rtype: string
    :return: A SDF string with the empty world.
    """
    return _gazebo.get_empty_world()

def get_model_file_from_fuel(uri, use_cache=False):
    r"""
    Get a SDF model file from a Fuel URI.

    Notes: A valid URI has the following form:
    https://fuel.ignitionrobotics.org/openrobotics/models/model_name

    :type URI: string
    :param URI: A valid Fuel URI.
    :type useCache: boolean
    :param useCache: Load the model from the local cache.
    :rtype: string
    :return: The absolute path to the SDF model.
    """
    return _gazebo.get_model_file_from_fuel(uri, use_cache)

def get_random_string(length):
    r"""
    Generate a random alpha numeric string.

    :type length: int
    :param length: The length of the string.
    :rtype: string
    :return: The random string.
    """
    return _gazebo.get_random_string(length)

def urdffile_to_sdfstring(urdf_file):
    r"""
    Convert a URDF file to a SDF string.

    :type urdfFile: string
    :param urdfFile: The absolute path to the URDF file.
    :rtype: string
    :return: The SDF string if the file exists and it was successfully
                converted, an empty string otherwise.
    """
    return _gazebo.urdffile_to_sdfstring(urdf_file)

def urdfstring_to_sdfstring(urdf_string):
    r"""
    Convert a URDF string to a SDF string.

    :param urdfFile: A URDF string.
    :rtype: string
    :return: The SDF string if the URDF string was successfully
                converted, an empty string otherwise.
    """
    return _gazebo.urdfstring_to_sdfstring(urdf_string)

def normalize(input, low, high):
    r"""
    Normalize a vector in [-1, 1].

    The normalization applies the following equation, where
    :math:`v` is the input, :math:`l` and :math:`h` are respectively
    the lower and higher limits:

    :math:`v_{normalized} = 2 \frac{v - l}{h - l} - 1`

    The input, low and high arguments are broadcasted to a common
    size. Refer to the following for broadcasting definition:

    https://numpy.org/doc/stable/user/basics.broadcasting.html

    Notes: If the lower limit matches the higher limit, the
    corresponding input value is not normalized.

    :type input: Iterable[float]
    :param input: The input vector.
    :type low: Iterable[float]
    :param low: The lower limit.
    :type high: Iterable[float]
    :param high: The higher limit.
    :raises: std::invalid_argument If the arguments cannot be
        broadcasted.
    :rtype: Iterable[float]
    :return: The normalized input.
    """
    return _gazebo.normalize(input, low, high)

def denormalize(input, low, high):
    r"""
    Denormalize a vector from [-1, 1].

    The denormalization applies the following equation, where
    :math:`v` is the input, :math:`l` and :math:`h` are respectively
    the lower and higher limits:

    :math:`v_{denormalized} = \frac{1}{2} (v + 1)(h - l) - l`

    The input, low and high arguments are broadcasted to a common
    size. Refer to the following for broadcasting definition:

    https://numpy.org/doc/stable/user/basics.broadcasting.html

    :type input: Iterable[float]
    :param input: The input vector.
    :type low: Iterable[float]
    :param low: The lower limit.
    :type high: Iterable[float]
    :param high: The higher limit.
    :raises: std::invalid_argument If the arguments cannot be
        broadcasted.
    :rtype: Iterable[float]
    :return: The denormalized input.
    """
    return _gazebo.denormalize(input, low, high)
class GazeboEntity(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _gazebo.delete_GazeboEntity

    def id(self):
        r"""
        Get the unique id of the object.

        Notes: It might differ from the entity number since a multi-world setting
        with the same models inserted in the same order would result to same
        numbering.

        :rtype: int
        :return: The unique object id. Invalid objects return 0.
        """
        return _gazebo.GazeboEntity_id(self)

    def entity(self):
        r"""
        Return the entity of this object.

        :rtype: ignition::gazebo::Entity
        :return: The entity that corresponds to this object.
        """
        return _gazebo.GazeboEntity_entity(self)

# Register GazeboEntity in _gazebo:
_gazebo.GazeboEntity_swigregister(GazeboEntity)

class Joint(scenario.bindings.core.Joint, GazeboEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gazebo.Joint_swiginit(self, _gazebo.new_Joint())
    __swig_destroy__ = _gazebo.delete_Joint

    def id(self):
        return _gazebo.Joint_id(self)

    def reset_position(self, position=0, dof=0):
        r"""
        Reset the position of a joint DOF.

        :type position: float
        :param position: The desired position.
        :type dof: int
        :param dof: The index of the DOF.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_reset_position(self, position, dof)

    def reset_velocity(self, velocity=0, dof=0):
        r"""
        Reset the velocity of a joint DOF.

        :type velocity: float
        :param velocity: The desired velocity.
        :type dof: int
        :param dof: The index of the DOF.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_reset_velocity(self, velocity, dof)

    def reset(self, position=0, velocity=0, dof=0):
        r"""
        Reset the state of a joint DOF.

        This method also resets the PID state of the joint.

        :type position: float
        :param position: The desired position.
        :type velocity: float
        :param velocity: The desired velocity.
        :type dof: int
        :param dof: The index of the DOF.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_reset(self, position, velocity, dof)

    def reset_joint_position(self, position):
        r"""
        Reset the position of the joint.

        This method also resets the PID state of the joint.

        :type position: Iterable[float]
        :param position: The desired position.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_reset_joint_position(self, position)

    def reset_joint_velocity(self, velocity):
        r"""
        Reset the velocity of the joint.

        This method also resets the PID state of the joint.

        :type velocity: Iterable[float]
        :param velocity: The desired velocity.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_reset_joint_velocity(self, velocity)

    def reset_joint(self, position, velocity):
        r"""
        Reset the state of the joint.

        This method also resets the PID state of the joint.

        :type position: Iterable[float]
        :param position: The desired position.
        :type velocity: Iterable[float]
        :param velocity: The desired velocity.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_reset_joint(self, position, velocity)

    def set_coulomb_friction(self, value):
        r"""
        Set the Coulomb friction parameter of the joint.

        Notes: Friction can be changed only before the first simulated step
        after model insertion.

        :type value: float
        :param value: The new Coulomb friction value.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_set_coulomb_friction(self, value)

    def set_viscous_friction(self, value):
        r"""
        Set the viscous friction parameter of the joint.

        Notes: Friction can be changed only before the first simulated step
        after model insertion.

        :type value: float
        :param value: The new viscous friction value.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Joint_set_viscous_friction(self, value)

    def valid(self):
        return _gazebo.Joint_valid(self)

    def dofs(self):
        return _gazebo.Joint_dofs(self)

    def name(self, scoped=False):
        return _gazebo.Joint_name(self, scoped)

    def type(self):
        return _gazebo.Joint_type(self)

    def control_mode(self):
        return _gazebo.Joint_control_mode(self)

    def set_control_mode(self, mode):
        return _gazebo.Joint_set_control_mode(self, mode)

    def controller_period(self):
        return _gazebo.Joint_controller_period(self)

    def pid(self):
        return _gazebo.Joint_pid(self)

    def set_pid(self, pid):
        return _gazebo.Joint_set_pid(self, pid)

    def history_of_applied_joint_forces_enabled(self):
        return _gazebo.Joint_history_of_applied_joint_forces_enabled(self)

    def enable_history_of_applied_joint_forces(self, enable=True, max_history_size=100):
        return _gazebo.Joint_enable_history_of_applied_joint_forces(self, enable, max_history_size)

    def history_of_applied_joint_forces(self):
        return _gazebo.Joint_history_of_applied_joint_forces(self)

    def coulomb_friction(self):
        return _gazebo.Joint_coulomb_friction(self)

    def viscous_friction(self):
        return _gazebo.Joint_viscous_friction(self)

    def position_limit(self, dof=0):
        return _gazebo.Joint_position_limit(self, dof)

    def max_generalized_force(self, dof=0):
        return _gazebo.Joint_max_generalized_force(self, dof)

    def set_max_generalized_force(self, max_force, dof=0):
        return _gazebo.Joint_set_max_generalized_force(self, max_force, dof)

    def position(self, dof=0):
        return _gazebo.Joint_position(self, dof)

    def velocity(self, dof=0):
        return _gazebo.Joint_velocity(self, dof)

    def acceleration(self, dof=0):
        return _gazebo.Joint_acceleration(self, dof)

    def generalized_force(self, dof=0):
        return _gazebo.Joint_generalized_force(self, dof)

    def set_position_target(self, position, dof=0):
        return _gazebo.Joint_set_position_target(self, position, dof)

    def set_velocity_target(self, velocity, dof=0):
        return _gazebo.Joint_set_velocity_target(self, velocity, dof)

    def set_acceleration_target(self, acceleration, dof=0):
        return _gazebo.Joint_set_acceleration_target(self, acceleration, dof)

    def set_generalized_force_target(self, force, dof=0):
        return _gazebo.Joint_set_generalized_force_target(self, force, dof)

    def position_target(self, dof=0):
        return _gazebo.Joint_position_target(self, dof)

    def velocity_target(self, dof=0):
        return _gazebo.Joint_velocity_target(self, dof)

    def acceleration_target(self, dof=0):
        return _gazebo.Joint_acceleration_target(self, dof)

    def generalized_force_target(self, dof=0):
        return _gazebo.Joint_generalized_force_target(self, dof)

    def joint_position_limit(self):
        return _gazebo.Joint_joint_position_limit(self)

    def joint_max_generalized_force(self):
        return _gazebo.Joint_joint_max_generalized_force(self)

    def set_joint_max_generalized_force(self, max_force):
        return _gazebo.Joint_set_joint_max_generalized_force(self, max_force)

    def joint_position(self):
        return _gazebo.Joint_joint_position(self)

    def joint_velocity(self):
        return _gazebo.Joint_joint_velocity(self)

    def joint_acceleration(self):
        return _gazebo.Joint_joint_acceleration(self)

    def joint_generalized_force(self):
        return _gazebo.Joint_joint_generalized_force(self)

    def set_joint_position_target(self, position):
        return _gazebo.Joint_set_joint_position_target(self, position)

    def set_joint_velocity_target(self, velocity):
        return _gazebo.Joint_set_joint_velocity_target(self, velocity)

    def set_joint_acceleration_target(self, acceleration):
        return _gazebo.Joint_set_joint_acceleration_target(self, acceleration)

    def set_joint_generalized_force_target(self, force):
        return _gazebo.Joint_set_joint_generalized_force_target(self, force)

    def joint_position_target(self):
        return _gazebo.Joint_joint_position_target(self)

    def joint_velocity_target(self):
        return _gazebo.Joint_joint_velocity_target(self)

    def joint_acceleration_target(self):
        return _gazebo.Joint_joint_acceleration_target(self)

    def joint_generalized_force_target(self):
        return _gazebo.Joint_joint_generalized_force_target(self)

# Register Joint in _gazebo:
_gazebo.Joint_swigregister(Joint)

class Link(scenario.bindings.core.Link, GazeboEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gazebo.Link_swiginit(self, _gazebo.new_Link())
    __swig_destroy__ = _gazebo.delete_Link

    def id(self):
        return _gazebo.Link_id(self)

    def valid(self):
        return _gazebo.Link_valid(self)

    def name(self, scoped=False):
        return _gazebo.Link_name(self, scoped)

    def mass(self):
        return _gazebo.Link_mass(self)

    def position(self):
        return _gazebo.Link_position(self)

    def orientation(self):
        return _gazebo.Link_orientation(self)

    def world_linear_velocity(self):
        return _gazebo.Link_world_linear_velocity(self)

    def world_angular_velocity(self):
        return _gazebo.Link_world_angular_velocity(self)

    def body_linear_velocity(self):
        return _gazebo.Link_body_linear_velocity(self)

    def body_angular_velocity(self):
        return _gazebo.Link_body_angular_velocity(self)

    def world_linear_acceleration(self):
        return _gazebo.Link_world_linear_acceleration(self)

    def world_angular_acceleration(self):
        return _gazebo.Link_world_angular_acceleration(self)

    def body_linear_acceleration(self):
        return _gazebo.Link_body_linear_acceleration(self)

    def body_angular_acceleration(self):
        return _gazebo.Link_body_angular_acceleration(self)

    def contacts_enabled(self):
        return _gazebo.Link_contacts_enabled(self)

    def enable_contact_detection(self, enable):
        return _gazebo.Link_enable_contact_detection(self, enable)

    def in_contact(self):
        return _gazebo.Link_in_contact(self)

    def contacts(self):
        return _gazebo.Link_contacts(self)

    def contact_wrench(self):
        return _gazebo.Link_contact_wrench(self)

    def apply_world_force(self, force, duration=0.0):
        r"""
        Apply a force to the link.

        The force is applied to the origin of the link frame.

        :type force: Iterable[float, float, float]
        :param force: The force to apply expressed in world coordinates.
        :type duration: float
        :param duration: The duration of the application of the force.
            By default the force is applied for a single physics step.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Link_apply_world_force(self, force, duration)

    def apply_world_torque(self, torque, duration=0.0):
        r"""
        Apply a torque to the link.

        The force is applied to the origin of the link frame.

        :type torque: Iterable[float, float, float]
        :param torque: The torque to apply expressed in world coordinates.
        :type duration: float
        :param duration: The duration of the application of the torque.
            By default the torque is applied for a single physics step.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Link_apply_world_torque(self, torque, duration)

    def apply_world_wrench(self, force, torque, duration=0.0):
        r"""
        Apply a wrench to the link.

        The force is applied to the origin of the link frame.

        :type force: Iterable[float, float, float]
        :param force: The force to apply expressed in world coordinates.
        :type torque: Iterable[float, float, float]
        :param torque: The torque to apply expressed in world coordinates.
        :type duration: float
        :param duration: The duration of the application of the wrench.
            By default the wrench is applied for a single physics step.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Link_apply_world_wrench(self, force, torque, duration)

    def apply_world_wrench_to_co_m(self, force, torque, duration=0.0):
        r"""
        Apply a wrench to the CoM of the link.

        Notes: This method considers the CoM being positioned in the origin of
        the inertial frame as it is defined in the SDF description of the model.
        Note that if not explicitly specified, inertial and link frames match.
        In this case, `applyWorldWrench` and `applyWorldWrenchToCoM` effects
        will be the same.

        :type force: Iterable[float, float, float]
        :param force: The force to apply expressed in world coordinates.
        :type torque: Iterable[float, float, float]
        :param torque: The torque to apply expressed in world coordinates.
        :type duration: float
        :param duration: The duration of the application of the wrench.
            By default the wrench is applied for a single physics step.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Link_apply_world_wrench_to_co_m(self, force, torque, duration)

# Register Link in _gazebo:
_gazebo.Link_swigregister(Link)

class Model(scenario.bindings.core.Model, GazeboEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gazebo.Model_swiginit(self, _gazebo.new_Model())
    __swig_destroy__ = _gazebo.delete_Model

    def id(self):
        return _gazebo.Model_id(self)

    def insert_model_plugin(self, *args):
        r"""
        Insert a Ignition Gazebo plugin to the model.

        :type libName: string
        :param libName: The library name of the plugin.
        :type className: string
        :param className: The class name (or alias) of the plugin.
        :type context: string
        :param context: Optional XML plugin context.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_insert_model_plugin(self, *args)

    def reset_joint_positions(self, *args):
        r"""
        Reset the positions of the joints.

        :type positions: Iterable[float]
        :param positions: The desired new joint positions.
        :type jointNames: Iterable[string]
        :param jointNames: Optional vector of considered joints. By default,
            ``Model::jointNames`` is used.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_joint_positions(self, *args)

    def reset_joint_velocities(self, *args):
        r"""
        Reset the velocities of the joints.

        :type velocities: Iterable[float]
        :param velocities: The desired new velocities positions.
        :type jointNames: Iterable[string]
        :param jointNames: Optional vector of considered joints. By default,
            ``Model::jointNames`` is used.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_joint_velocities(self, *args)

    def reset_base_pose(self, *args):
        r"""
        Reset the pose of the base link.

        :type position: Iterable[float, float, float]
        :param position: The desired position of the base link in world
            coordinates.
        :type orientation: Iterable[float, float, float, float]
        :param orientation: The wxyz quaternion defining the desired orientation
            of the base link wrt the world frame.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_base_pose(self, *args)

    def reset_base_position(self, *args):
        r"""
        Reset the position of the base link.

        :type position: Iterable[float, float, float]
        :param position: The desired position of the base link in world
            coordinates.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_base_position(self, *args)

    def reset_base_orientation(self, *args):
        r"""
        Reset the orientation of the base link.

        :type orientation: Iterable[float, float, float, float]
        :param orientation: The wxyz quaternion defining the desired orientation
            of the base link wrt the world frame.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_base_orientation(self, *args)

    def reset_base_world_linear_velocity(self, *args):
        r"""
        Reset the linear mixed velocity of the base link.

        :type linear: Iterable[float, float, float]
        :param linear: The desired linear mixed velocity of the base link.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_base_world_linear_velocity(self, *args)

    def reset_base_world_angular_velocity(self, *args):
        r"""
        Reset the angular mixed velocity of the base link.

        :type angular: Iterable[float, float, float]
        :param angular: The desired angular mixed velocity of the base link.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_base_world_angular_velocity(self, *args)

    def reset_base_world_velocity(self, *args):
        r"""
        Reset the mixed velocity of the base link.

        :type linear: Iterable[float, float, float]
        :param linear: The desired linear mixed velocity of the base link.
        :type angular: Iterable[float, float, float]
        :param angular: The desired angular mixed velocity of the base link.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_reset_base_world_velocity(self, *args)

    def self_collisions_enabled(self):
        r"""
        Check if the detection of self-collisions is enabled.

        :rtype: boolean
        :return: True if self-collisions detection is enabled, false
            otherwise.
        """
        return _gazebo.Model_self_collisions_enabled(self)

    def enable_self_collisions(self, enable=True):
        r"""
        Enable the detection of self-collisions.

        It will enable contact detection if it was disabled.

        :type enable: boolean
        :param enable: True to enable the self-collision detection, false to
            disable.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.Model_enable_self_collisions(self, enable)

    def valid(self):
        return _gazebo.Model_valid(self)

    def dofs(self, *args):
        return _gazebo.Model_dofs(self, *args)

    def name(self):
        return _gazebo.Model_name(self)

    def nr_of_links(self):
        return _gazebo.Model_nr_of_links(self)

    def nr_of_joints(self):
        return _gazebo.Model_nr_of_joints(self)

    def total_mass(self, *args):
        return _gazebo.Model_total_mass(self, *args)

    def get_link(self, link_name):
        return _gazebo.Model_get_link(self, link_name)

    def get_joint(self, joint_name):
        return _gazebo.Model_get_joint(self, joint_name)

    def link_names(self, scoped=False):
        return _gazebo.Model_link_names(self, scoped)

    def joint_names(self, scoped=False):
        return _gazebo.Model_joint_names(self, scoped)

    def controller_period(self):
        return _gazebo.Model_controller_period(self)

    def set_controller_period(self, period):
        return _gazebo.Model_set_controller_period(self, period)

    def enable_history_of_applied_joint_forces(self, *args):
        return _gazebo.Model_enable_history_of_applied_joint_forces(self, *args)

    def history_of_applied_joint_forces_enabled(self, *args):
        return _gazebo.Model_history_of_applied_joint_forces_enabled(self, *args)

    def history_of_applied_joint_forces(self, *args):
        return _gazebo.Model_history_of_applied_joint_forces(self, *args)

    def contacts_enabled(self):
        return _gazebo.Model_contacts_enabled(self)

    def enable_contacts(self, enable=True):
        return _gazebo.Model_enable_contacts(self, enable)

    def links_in_contact(self):
        return _gazebo.Model_links_in_contact(self)

    def contacts(self, *args):
        return _gazebo.Model_contacts(self, *args)

    def joint_positions(self, *args):
        return _gazebo.Model_joint_positions(self, *args)

    def joint_velocities(self, *args):
        return _gazebo.Model_joint_velocities(self, *args)

    def joint_accelerations(self, *args):
        return _gazebo.Model_joint_accelerations(self, *args)

    def joint_generalized_forces(self, *args):
        return _gazebo.Model_joint_generalized_forces(self, *args)

    def joint_limits(self, *args):
        return _gazebo.Model_joint_limits(self, *args)

    def set_joint_control_mode(self, *args):
        return _gazebo.Model_set_joint_control_mode(self, *args)

    def links(self, *args):
        return _gazebo.Model_links(self, *args)

    def joints(self, *args):
        return _gazebo.Model_joints(self, *args)

    def set_joint_position_targets(self, *args):
        return _gazebo.Model_set_joint_position_targets(self, *args)

    def set_joint_velocity_targets(self, *args):
        return _gazebo.Model_set_joint_velocity_targets(self, *args)

    def set_joint_acceleration_targets(self, *args):
        return _gazebo.Model_set_joint_acceleration_targets(self, *args)

    def set_joint_generalized_force_targets(self, *args):
        return _gazebo.Model_set_joint_generalized_force_targets(self, *args)

    def joint_position_targets(self, *args):
        return _gazebo.Model_joint_position_targets(self, *args)

    def joint_velocity_targets(self, *args):
        return _gazebo.Model_joint_velocity_targets(self, *args)

    def joint_acceleration_targets(self, *args):
        return _gazebo.Model_joint_acceleration_targets(self, *args)

    def joint_generalized_force_targets(self, *args):
        return _gazebo.Model_joint_generalized_force_targets(self, *args)

    def base_frame(self):
        return _gazebo.Model_base_frame(self)

    def base_position(self):
        return _gazebo.Model_base_position(self)

    def base_orientation(self):
        return _gazebo.Model_base_orientation(self)

    def base_body_linear_velocity(self):
        return _gazebo.Model_base_body_linear_velocity(self)

    def base_body_angular_velocity(self):
        return _gazebo.Model_base_body_angular_velocity(self)

    def base_world_linear_velocity(self):
        return _gazebo.Model_base_world_linear_velocity(self)

    def base_world_angular_velocity(self):
        return _gazebo.Model_base_world_angular_velocity(self)

    def set_base_pose_target(self, position, orientation):
        return _gazebo.Model_set_base_pose_target(self, position, orientation)

    def set_base_position_target(self, position):
        return _gazebo.Model_set_base_position_target(self, position)

    def set_base_orientation_target(self, orientation):
        return _gazebo.Model_set_base_orientation_target(self, orientation)

    def set_base_world_velocity_target(self, linear, angular):
        return _gazebo.Model_set_base_world_velocity_target(self, linear, angular)

    def set_base_world_linear_velocity_target(self, linear):
        return _gazebo.Model_set_base_world_linear_velocity_target(self, linear)

    def set_base_world_angular_velocity_target(self, angular):
        return _gazebo.Model_set_base_world_angular_velocity_target(self, angular)

    def set_base_world_linear_acceleration_target(self, linear):
        return _gazebo.Model_set_base_world_linear_acceleration_target(self, linear)

    def set_base_world_angular_acceleration_target(self, angular):
        return _gazebo.Model_set_base_world_angular_acceleration_target(self, angular)

    def base_position_target(self):
        return _gazebo.Model_base_position_target(self)

    def base_orientation_target(self):
        return _gazebo.Model_base_orientation_target(self)

    def base_world_linear_velocity_target(self):
        return _gazebo.Model_base_world_linear_velocity_target(self)

    def base_world_angular_velocity_target(self):
        return _gazebo.Model_base_world_angular_velocity_target(self)

    def base_world_linear_acceleration_target(self):
        return _gazebo.Model_base_world_linear_acceleration_target(self)

    def base_world_angular_acceleration_target(self):
        return _gazebo.Model_base_world_angular_acceleration_target(self)

# Register Model in _gazebo:
_gazebo.Model_swigregister(Model)

PhysicsEngine_dart = _gazebo.PhysicsEngine_dart
r""" The physics engine included in the Dynamic Animation and Robotics Toolkit."""
class World(scenario.bindings.core.World, GazeboEntity):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gazebo.World_swiginit(self, _gazebo.new_World())
    __swig_destroy__ = _gazebo.delete_World

    def id(self):
        return _gazebo.World_id(self)

    def insert_world_plugin(self, *args):
        r"""
        Insert a Ignition Gazebo plugin to the world.

        :type libName: string
        :param libName: The library name of the plugin.
        :type className: string
        :param className: The class name (or alias) of the plugin.
        :type context: string
        :param context: Optional XML plugin context.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.World_insert_world_plugin(self, *args)

    def set_physics_engine(self, engine):
        r"""
        Set the physics engine of the world.

        By default, if the world file does not already contain a physics
        plugin, no physics is loaded by default. This method allows to
        insert in the simulator a plugin with one of the supported physics
        engines.

        :type engine: int
        :param engine: The desired physics engine.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.World_set_physics_engine(self, engine)

    def set_gravity(self, gravity):
        r"""
        Set the gravity of the world.

        Notes: This method must be called after setting the physics engine and
        before performing any physics step.

        :type gravity: Iterable[float, float, float]
        :param gravity: The desired gravity vector.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.World_set_gravity(self, gravity)

    def insert_model(self, *args):
        r"""
        Insert a model in the world.

        :type modelFile: string
        :param modelFile: The path to the URDF or SDF file to load.
        :type pose: :py:class:`Pose`
        :param pose: The optional initial pose of the model.
        :type overrideModelName: string
        :param overrideModelName: The optional name of the model. This is the name
            used to get the model with ``World::getModel``.
        :rtype: boolean
        :return: True for success, false otherwise.

        Notes: The default pose and model name are those specified in the
        robot description. If the pose is not specified, the identity is used.

        Warning: In order to process the model insertion, a simulator step must
        be executed. It could either be a paused or unpaused step.
        """
        return _gazebo.World_insert_model(self, *args)

    def remove_model(self, model_name):
        r"""
        Remove a model from the world.

        :type modelName: string
        :param modelName: The name of the model to remove.
        :rtype: boolean
        :return: True for success, false otherwise.

        Warning: In order to process the model removal, a simulator step must
        be executed. It could either be a paused or unpaused step.
        """
        return _gazebo.World_remove_model(self, model_name)

    def valid(self):
        return _gazebo.World_valid(self)

    def time(self):
        return _gazebo.World_time(self)

    def name(self):
        return _gazebo.World_name(self)

    def gravity(self):
        return _gazebo.World_gravity(self)

    def model_names(self):
        return _gazebo.World_model_names(self)

    def get_model(self, model_name):

        r"""
        Get a model part of the world.

        :type modelName: string
        :param modelName: The name of the model to get.
        :rtype: :py:class:`scenario.core.Model`
        :return: The model if it is part of the world, None otherwise.
        """


        return _gazebo.World_get_model(self, model_name)


# Register World in _gazebo:
_gazebo.World_swigregister(World)

class GazeboSimulator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, step_size=0.001, rtf=1.0, steps_per_run=1):
        r"""
        Class wrapping the Ignition Gazebo simulator.

        The simulator can execute either unpaused or paused runs. Paused runs
        update the internal state of the simulator without stepping the physics.
        This is useful to process e.g. model insertions or removals.
        Every simulator run can execute one or more physics steps, depending on
        how it is configured when constructed.

        :type stepSize: float
        :param stepSize: The size of the physics step.
        :type rtf: float
        :param rtf: The desired real-time factor.
        :type stepsPerRun: int
        :param stepsPerRun: Number of steps to execute at each simulator run.
        """
        _gazebo.GazeboSimulator_swiginit(self, _gazebo.new_GazeboSimulator(step_size, rtf, steps_per_run))
    __swig_destroy__ = _gazebo.delete_GazeboSimulator

    def step_size(self):
        r"""
        Get the size of a simulator step.

        :rtype: float
        :return: The simulator step size in seconds.
        """
        return _gazebo.GazeboSimulator_step_size(self)

    def real_time_factor(self):
        r"""
        Get the desired real-time factor of the simulator.

        :rtype: float
        :return: The desired real-time factor.
        """
        return _gazebo.GazeboSimulator_real_time_factor(self)

    def steps_per_run(self):
        r"""
        Get the number or steps to execute every simulator run.

        :rtype: int
        :return: The configured number of steps per run.
        """
        return _gazebo.GazeboSimulator_steps_per_run(self)

    def initialize(self):
        r"""
        Initialize the simulator.

        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_initialize(self)

    def initialized(self):
        r"""
        Check if the simulator has been initialized.

        :rtype: boolean
        :return: True if the simulator was initialized, false otherwise.
        """
        return _gazebo.GazeboSimulator_initialized(self)

    def run(self, paused=False):
        r"""
        Run the simulator.

        :type paused: boolean
        :param paused: True to perform paused steps that do not affect the
            physics, false for normal steps. The number of steps configured during
            construction are executed.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_run(self, paused)

    def gui(self, verbosity=-1):
        r"""
        Open the Ignition Gazebo GUI.

        :type verbosity: int
        :param verbosity: Configure the verbosity of the GUI (0-4)
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_gui(self, verbosity)

    def close(self):
        r"""
        Close the simulator and the GUI.

        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_close(self)

    def pause(self):
        r"""
        Pause the simulator.

        Notes: This method is useful in non-deterministic mode, which is not
        currently supported.

        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_pause(self)

    def running(self):
        r"""
        Check if the simulator is running.

        Notes: This method is useful in non-deterministic mode, which is not
        currently supported.

        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_running(self)

    def insert_world_from_sdf(self, *args):
        r"""
        Load a SDF world file.

        Notes: If the world file is not passed, the default empty world is
        inserted. The default empty world does not have the ground plane nor
        any physics. Both can be added by operating on the ``World`` object.

        :type worldFile: string
        :param worldFile: The path to the SDF world file.
        :type worldName: string
        :param worldName: Optionally override the name of the world defined in the
            SDF world file.
        :rtype: boolean
        :return: True for success, false otherwise.
        """
        return _gazebo.GazeboSimulator_insert_world_from_sdf(self, *args)

    def insert_worlds_from_sdf(self, *args):
        r"""
        Load a SDF world file containing multiple worlds.

        :type worldFile: string
        :param worldFile: The path to the SDF world file.
        :type worldNames: Iterable[string]
        :param worldNames: Optionally override the names of the worlds defined in
            the SDF world file.
        :rtype: boolean
        :return: True for success, false otherwise.

        Warning: This is an experimental feature. Multiworld simulations are only
        partially supported by Ignition Gazebo.
        """
        return _gazebo.GazeboSimulator_insert_worlds_from_sdf(self, *args)

    def world_names(self):
        r"""
        Get the list if the world names part of the simulation.

        :rtype: Iterable[string]
        :return: The world names.
        """
        return _gazebo.GazeboSimulator_world_names(self)

    def get_world(self, *args):
        r"""
        Get a simulated world.

        :type worldName: string
        :param worldName: The name of the desired world.
        :rtype: :py:class:`World`
        :return: The world object.
        """
        return _gazebo.GazeboSimulator_get_world(self, *args)

# Register GazeboSimulator in _gazebo:
_gazebo.GazeboSimulator_swigregister(GazeboSimulator)

class ECMSingleton(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _gazebo.ECMSingleton_swiginit(self, _gazebo.new_ECMSingleton())
    __swig_destroy__ = _gazebo.delete_ECMSingleton

    @staticmethod
    def instance():
        return _gazebo.ECMSingleton_instance()

    def valid(self, *args):
        return _gazebo.ECMSingleton_valid(self, *args)

    def has_world(self, *args):
        return _gazebo.ECMSingleton_has_world(self, *args)

    def world_names(self):
        return _gazebo.ECMSingleton_world_names(self)

# Register ECMSingleton in _gazebo:
_gazebo.ECMSingleton_swigregister(ECMSingleton)

def ECMSingleton_instance():
    return _gazebo.ECMSingleton_instance()



