"""
Copyright (C) 2024 Austin Choi
See end of file for extended copyright information
"""

import curses

class Entity:
    def __init__(self, char = '#', x = 0, y = 0, width = 1, height = 1):
        """
                Constructor for Entity object

            Parameters:
                char (str): The character to be displayed on the screen
                x (int): The x-coordinate of the top-left corner of the entity
                y (int): The y-coordinate of the top-left corner of the entity
                width (int): The width of the entity
                height (int): The height of the entity
            returns:
                None
        """
        self.char = char
        self.x = x
        self.y = y
        self.width = width
        self.height = height

    def get_char(self):
        """
                returns the char attribute

            Parameters:
                None
            returns:
                str: The char attribute
        """
        return self.char

    def get_x(self):
        """
                returns the x attribute

            Parameters:
                None
            returns:
                int: The x attribute
        """
        return self.x

    def get_y(self):
        """
                returns the y attribute

            Parameters:
                None
            returns:
                int: The y attribute
        """
        return self.y

    def get_width(self):
        """
                returns the width attribute

            Parameters:
                None
            returns:
                int: The width attribute
        """
        return self.width

    def get_height(self):
        """
                returns the height attribute

            Parameters:
                None
            returns:
                int: The height attribute
        """
        return self.height

    def set_char(self, char):
        """
                sets the char attribute

            Parameters:
                char (str): The character to be displayed on the screen
            returns:
                None
        """
        self.char = char

    def set_x(self, x):
        """
                sets the x attribute

            Parameters:
                x (int): The x-coordinate of the top-left corner of the entity
            returns:
                None
        """
        self.x = x

    def set_y(self, y):
        """
                sets the y attribute

            Parameters:
                y (int): The y-coordinate of the top-left corner of the entity
            returns:
                None
        """
        self.y = y

    def set_width(self, width):
        """
                sets the width attribute

            Parameters:
                width (int): The width of the entity
            returns:
                None
        """
        self.width = width

    def set_height(self, height):
        """
                sets the height attribute

            Parameters:
                height (int): The height of the entity
            returns:
                None
        """
        self.height = height

    def render(self, stdscr):
        """
                Renders the entity on the screen

            Parameters:
                stdscr (curses.window): The window object to render the entity on
            returns:
                None
        """
        for i in range(self.height):
            stdscr.addstr(self.y + i, self.x, self.char * self.width)

    def handle_input(self, key):
        """
                Handles input for the entity

            Parameters:
                key (int): The key code of the key pressed
            returns:
                None
        """
        pass

"""
Copyright (C) 2024 Austin Choi

Tuitoy

A library to make pretty Terminal projects by drawing screens, menus, and other components. Uses Curses under the hood

This code is licensed under the MIT License.
Please see the LICENSE file in the root directory of this project for the full license details.
"""
