#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apig = require("@aws-cdk/aws-apigateway");
const acm = require("@aws-cdk/aws-certificatemanager");
const lambda = require("@aws-cdk/aws-lambda");
const route53 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
const targets = require("../lib");
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id);
        const domainName = 'example.com';
        const certArn = 'arn:aws:acm:us-east-1:111111111111:certificate';
        const hostedZoneId = 'AAAAAAAAAAAAA';
        const handler = new lambda.Function(this, 'Handler', {
            code: lambda.Code.fromInline(`exports.handler = async () => {
        return {
          statusCode: '200',
          body: 'hello, world!'
        };
      };`),
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
        });
        const certificate = acm.Certificate.fromCertificateArn(this, 'cert', certArn);
        const api = new apig.LambdaRestApi(this, 'api', {
            handler,
            domainName: {
                certificate,
                domainName,
                endpointType: apig.EndpointType.REGIONAL,
            },
        });
        const zone = route53.HostedZone.fromHostedZoneAttributes(this, 'hosted-zone', {
            zoneName: domainName,
            hostedZoneId,
        });
        new route53.ARecord(this, 'Alias', {
            zone,
            target: route53.RecordTarget.fromAlias(new targets.ApiGateway(api)),
        });
    }
}
const app = new core_1.App();
new TestStack(app, 'aws-cdk-apigw-alias-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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